/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.power_analysis;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.power_analysis.GroupTableInfo;
import com.spss.java_client.ui.dialogs.base.analyze.power_analysis.PlotTypeEnum;
import com.spss.java_client.ui.dialogs.base.analyze.power_analysis.PowerAnalysisPlotRangeMaster;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.FocusableLabel;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.SPSSTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PowerAnalysisCommonPlotSubDlg
extends BaseSubDialog {
    private static final Insets BASE_INSETS = (Insets)DialogUtil.getStandardControlInsets().clone();
    private static final Insets LEVEL_ONE__INSETS = new Insets(PowerAnalysisCommonPlotSubDlg.BASE_INSETS.top, PowerAnalysisCommonPlotSubDlg.BASE_INSETS.left + 20, PowerAnalysisCommonPlotSubDlg.BASE_INSETS.bottom, PowerAnalysisCommonPlotSubDlg.BASE_INSETS.right);
    private static final Insets LEVEL_TWO_INSETS = new Insets(PowerAnalysisCommonPlotSubDlg.LEVEL_ONE__INSETS.top, PowerAnalysisCommonPlotSubDlg.LEVEL_ONE__INSETS.left + 20, PowerAnalysisCommonPlotSubDlg.LEVEL_ONE__INSETS.bottom, PowerAnalysisCommonPlotSubDlg.LEVEL_ONE__INSETS.right);
    private KeyByPlotTypeMaster mKeyByPlotTypeMaster;
    private JCheckBox mTwoDimensionSampleSizeCheck;
    private JCheckBox mTwoDimensionSampleSizeRangeCheck;
    private JLabel mTwoDimensionSampleSizeLowerLabel;
    private SPSSTextField mTwoDimensionSampleSizeLowerField;
    private JLabel mTwoDimensionSampleSizeUpperLabel;
    private SPSSTextField mTwoDimensionSampleSizeUpperField;
    private JCheckBox mTwoDimensionEffectSizeCheck;
    private JCheckBox mTwoDimensionEffectSizeRangeCheck;
    private JLabel mTwoDimensionEffectSizeLowerLabel;
    private FloatTextField mTwoDimensionEffectSizeLowerField;
    private JLabel mTwoDimensionEffectSizeUpperLabel;
    private FloatTextField mTwoDimensionEffectSizeUpperField;
    private JCheckBox mThreeDimensionPowerVersusCheck;
    private SpssButtonGroup mPowerVersusRBGroup;
    private JRadioButton mXAxisMajorRadio;
    private JRadioButton mYAxisMajorRadio;
    private JLabel mVerticalRotationLabel;
    private IntTextField mVerticalRotaionField;
    private JLabel mVerticalDegreeLabel;
    private JLabel mHorizontalRotationLabel;
    private IntTextField mHorizontalRotaionField;
    private JLabel mHorizontalDegreeLabel;
    private JCheckBox mThreeDimensionSampleSizeRangeCheck;
    private JLabel mThreeDimensionSampleSizeLowerLabel;
    private SPSSTextField mThreeDimensionSampleSizeLowerField;
    private JLabel mThreeDimensionSampleSizeUpperLabel;
    private SPSSTextField mThreeDimensionSampleSizeUpperField;
    private JCheckBox mThreeDimensionEffectSizeRangeCheck;
    private JLabel mThreeDimensionEffectSizeLowerLabel;
    private FloatTextField mThreeDimensionEffectSizeLowerField;
    private JLabel mThreeDimensionEffectSizeUpperLabel;
    private FloatTextField mThreeDimensionEffectSizeUpperField;
    private JCheckBox mDisplatTooltip;
    private FocusableLabel mTwoDimensionEffectSizeInfo;
    private FocusableLabel mThreeDimensionEffectSizeInfo;
    private GroupTableInfo mGroupTableInfo;
    private PlotTypeEnum mPlotType;
    private boolean mTestDirectionIsDirectional;
    private boolean mEqualForTwoGroups;

    public PowerAnalysisCommonPlotSubDlg(BaseProcedureDialog baseProcedureDialog, String string, PlotTypeEnum plotTypeEnum, boolean bl, boolean bl2) {
        super(baseProcedureDialog, string, true);
        this.mTestDirectionIsDirectional = bl;
        this.mEqualForTwoGroups = bl2;
        this.myInit(baseProcedureDialog, plotTypeEnum);
    }

    public PowerAnalysisCommonPlotSubDlg(BaseProcedureDialog baseProcedureDialog, String string, PlotTypeEnum plotTypeEnum, GroupTableInfo groupTableInfo) {
        super(baseProcedureDialog, string, true);
        this.mGroupTableInfo = groupTableInfo;
        this.myInit(baseProcedureDialog, plotTypeEnum);
    }

    private void myInit(BaseProcedureDialog baseProcedureDialog, PlotTypeEnum plotTypeEnum) {
        this.mPlotType = plotTypeEnum;
        this.mKeyByPlotTypeMaster = new KeyByPlotTypeMaster(plotTypeEnum);
        this.setupPanel();
        this.setDefaults();
        this.enableControls();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public String getDialogHelpID() {
        String string = "";
        switch (this.mPlotType) {
            case ANOVA: {
                string = "idh_power_anova_plot";
                break;
            }
            case ONE_TTEST: {
                string = "idh_power_onesample_plot";
                break;
            }
            case RELATED_TTEST: {
                string = "idh_power_related_plot";
                break;
            }
            case INDEPENDENT_TTEST: {
                string = "idh_power_independent_plot";
            }
        }
        return string;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        this.enableControls();
    }

    public static String getSubDialogSyntax(DialogDataModel dialogDataModel, PlotTypeEnum plotTypeEnum) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    static String getRangeSyntax(DialogDataModel dialogDataModel, String string, boolean bl, boolean bl2, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    protected void setupPanel() {
        this.myInitVars();
        this.addListeners();
        this.enableControls();
        JPanel jPanel = this.getViewPanel();
        this.setupPanel(jPanel);
        this.pack();
        this.setFocusTraversalPolicy();
    }

    private void addListeners() {
        this.mTwoDimensionSampleSizeLowerField.getDocument().addDocumentListener(new MyDocumentListener());
        this.mTwoDimensionSampleSizeUpperField.getDocument().addDocumentListener(new MyDocumentListener());
        this.mTwoDimensionEffectSizeLowerField.getDocument().addDocumentListener(new MyDocumentListener());
        this.mTwoDimensionEffectSizeUpperField.getDocument().addDocumentListener(new MyDocumentListener());
        this.mVerticalRotaionField.getDocument().addDocumentListener(new MyDocumentListener());
        this.mHorizontalRotaionField.getDocument().addDocumentListener(new MyDocumentListener());
        this.mThreeDimensionSampleSizeLowerField.getDocument().addDocumentListener(new MyDocumentListener());
        this.mThreeDimensionSampleSizeUpperField.getDocument().addDocumentListener(new MyDocumentListener());
        this.mThreeDimensionEffectSizeLowerField.getDocument().addDocumentListener(new MyDocumentListener());
        this.mThreeDimensionEffectSizeUpperField.getDocument().addDocumentListener(new MyDocumentListener());
    }

    private ImageIcon getInfoIcon() {
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        return new ImageIcon(uRL);
    }

    protected void myInitVars() {
        this.mTwoDimensionSampleSizeCheck = new JCheckBox(new ToggleButtonAction(this, this.mKeyByPlotTypeMaster.getTwoDimSampleSizeKey()));
        this.mTwoDimensionSampleSizeCheck.addActionListener(new MyActionListener());
        this.mTwoDimensionSampleSizeRangeCheck = new JCheckBox(new ToggleButtonAction(this, this.mKeyByPlotTypeMaster.getTwoDimSampleSizeRangeKey()));
        this.mTwoDimensionSampleSizeRangeCheck.addActionListener(new MyActionListener());
        this.mTwoDimensionSampleSizeLowerField = this.getTwoDimensionSampleSizeRangeField(true);
        this.mTwoDimensionSampleSizeLowerLabel = DialogUtil.createLabel(this, KeyByPlotTypeMaster.SAMPLE_SIZE_2D_LOWER_BOUND_KEY);
        this.mTwoDimensionSampleSizeLowerLabel.setLabelFor((Component)this.mTwoDimensionSampleSizeLowerField);
        this.mTwoDimensionSampleSizeUpperField = this.getTwoDimensionSampleSizeRangeField(false);
        this.mTwoDimensionSampleSizeUpperLabel = DialogUtil.createLabel(this, KeyByPlotTypeMaster.SAMPLE_SIZE_2D_UPPER_BOUND_KEY);
        this.mTwoDimensionSampleSizeUpperLabel.setLabelFor((Component)this.mTwoDimensionSampleSizeUpperField);
        this.mTwoDimensionEffectSizeCheck = new JCheckBox(new ToggleButtonAction(this, this.mKeyByPlotTypeMaster.getTwoDimEffectsSizeKey()));
        this.mTwoDimensionEffectSizeCheck.addActionListener(new MyActionListener());
        this.mTwoDimensionEffectSizeRangeCheck = new JCheckBox(new ToggleButtonAction(this, this.mKeyByPlotTypeMaster.getTwoDimEffectsSizeRangeKey()));
        this.mTwoDimensionEffectSizeRangeCheck.addActionListener(new MyActionListener());
        this.mTwoDimensionEffectSizeLowerField = this.getTwoDimensionEffectSizeRangeField(true);
        this.mTwoDimensionEffectSizeLowerLabel = DialogUtil.createLabel(this, KeyByPlotTypeMaster.EFFECTS_SIZE_2D_LOWER_BOUND_KEY);
        this.mTwoDimensionEffectSizeLowerLabel.setLabelFor((Component)this.mTwoDimensionEffectSizeLowerField);
        this.mTwoDimensionEffectSizeUpperField = this.getTwoDimensionEffectSizeRangeField(false);
        this.mTwoDimensionEffectSizeUpperLabel = DialogUtil.createLabel(this, KeyByPlotTypeMaster.EFFECTS_SIZE_2D_UPPER_BOUND_KEY);
        this.mTwoDimensionEffectSizeUpperLabel.setLabelFor((Component)this.mTwoDimensionEffectSizeUpperField);
        this.mThreeDimensionPowerVersusCheck = new JCheckBox(new ToggleButtonAction(this, this.mKeyByPlotTypeMaster.getPowerEstimationVerusKey()));
        this.mThreeDimensionPowerVersusCheck.addActionListener(new MyActionListener());
        this.mXAxisMajorRadio = new JRadioButton(new ToggleButtonAction(this, this.mKeyByPlotTypeMaster.getMajorXKey()));
        this.mYAxisMajorRadio = new JRadioButton(new ToggleButtonAction(this, this.mKeyByPlotTypeMaster.getMajorYKey()));
        this.mPowerVersusRBGroup = new SpssButtonGroup();
        this.mPowerVersusRBGroup.add(this.mXAxisMajorRadio);
        this.mPowerVersusRBGroup.add(this.mYAxisMajorRadio);
        this.mVerticalRotationLabel = DialogUtil.createLabel(this, this.mKeyByPlotTypeMaster.getVerticalRotationKey());
        this.mVerticalRotaionField = this.getDegreeIntField(true);
        this.mVerticalRotationLabel.setLabelFor((Component)this.mVerticalRotaionField);
        this.mVerticalDegreeLabel = DialogUtil.createLabel(this, "IDS_POWER_ANALYSIS_ANOVA_PLOT_COMMON_DEGREES");
        this.mHorizontalRotationLabel = DialogUtil.createLabel(this, this.mKeyByPlotTypeMaster.getHorizontalRotationKey());
        this.mHorizontalRotaionField = this.getDegreeIntField(false);
        this.mHorizontalRotationLabel.setLabelFor((Component)this.mHorizontalRotaionField);
        this.mHorizontalDegreeLabel = DialogUtil.createLabel(this, "IDS_POWER_ANALYSIS_ANOVA_PLOT_COMMON_DEGREES");
        this.mThreeDimensionSampleSizeRangeCheck = new JCheckBox(new ToggleButtonAction(this, this.mKeyByPlotTypeMaster.getThreeDimSampleSizeRangeKey()));
        this.mThreeDimensionSampleSizeRangeCheck.addActionListener(new MyActionListener());
        this.mThreeDimensionSampleSizeLowerField = this.getThreeDimensionSampleSizeRangeField(true);
        this.mThreeDimensionSampleSizeLowerLabel = DialogUtil.createLabel(this, KeyByPlotTypeMaster.SAMPLE_SIZE_3D_LOWER_BOUND_KEY);
        this.mThreeDimensionSampleSizeLowerLabel.setLabelFor((Component)this.mThreeDimensionSampleSizeLowerField);
        this.mThreeDimensionSampleSizeUpperField = this.getThreeDimensionSampleSizeRangeField(false);
        this.mThreeDimensionSampleSizeUpperLabel = DialogUtil.createLabel(this, KeyByPlotTypeMaster.SAMPLE_SIZE_3D_UPPER_BOUND_KEY);
        this.mThreeDimensionSampleSizeUpperLabel.setLabelFor((Component)this.mThreeDimensionSampleSizeUpperField);
        this.mThreeDimensionEffectSizeRangeCheck = new JCheckBox(new ToggleButtonAction(this, this.mKeyByPlotTypeMaster.getThreeDimEffectsSizeRangeKey()));
        this.mThreeDimensionEffectSizeRangeCheck.addActionListener(new MyActionListener());
        this.mThreeDimensionEffectSizeLowerField = this.getThreeDimensionEffectSizeRangeField(true);
        this.mThreeDimensionEffectSizeLowerLabel = DialogUtil.createLabel(this, KeyByPlotTypeMaster.EFFECTS_SIZE_3D_LOWER_BOUND_KEY);
        this.mThreeDimensionEffectSizeLowerLabel.setLabelFor((Component)this.mThreeDimensionEffectSizeLowerField);
        this.mThreeDimensionEffectSizeUpperField = this.getThreeDimensionEffectSizeRangeField(false);
        this.mThreeDimensionEffectSizeUpperLabel = DialogUtil.createLabel(this, KeyByPlotTypeMaster.EFFECTS_SIZE_3D_UPPER_BOUND_KEY);
        this.mThreeDimensionEffectSizeUpperLabel.setLabelFor((Component)this.mThreeDimensionSampleSizeUpperField);
        this.mDisplatTooltip = new JCheckBox(new ToggleButtonAction(this, this.mKeyByPlotTypeMaster.getTooltipDisplayKey()));
        this.mDisplatTooltip.addActionListener(new MyActionListener());
        this.mTwoDimensionEffectSizeInfo = new FocusableLabel(this.getResString("IDS_POWER_ANALYSIS_ANOVA_PLOT_INDEPENDENT_2D_EFFECT_SIZE_INFO"));
        this.mTwoDimensionEffectSizeInfo.setIcon((Icon)this.getInfoIcon());
        this.mThreeDimensionEffectSizeInfo = new FocusableLabel(this.getResString("IDS_POWER_ANALYSIS_ANOVA_PLOT_INDEPENDENT_2D_EFFECT_SIZE_INFO"));
        this.mThreeDimensionEffectSizeInfo.setIcon((Icon)this.getInfoIcon());
    }

    public static void resetPlotModelDependentFields(DialogDataModel dialogDataModel, PlotTypeEnum plotTypeEnum) {
        KeyByPlotTypeMaster keyByPlotTypeMaster = new KeyByPlotTypeMaster(plotTypeEnum);
        if (dialogDataModel != null) {
            if (plotTypeEnum == PlotTypeEnum.ANOVA) {
                dialogDataModel.putString(KeyByPlotTypeMaster.SAMPLE_SIZE_2D_LOWER_BOUND_KEY, "");
                dialogDataModel.putString(KeyByPlotTypeMaster.SAMPLE_SIZE_2D_UPPER_BOUND_KEY, "");
                dialogDataModel.putString(KeyByPlotTypeMaster.EFFECTS_SIZE_2D_LOWER_BOUND_KEY, "");
                dialogDataModel.putString(KeyByPlotTypeMaster.EFFECTS_SIZE_2D_UPPER_BOUND_KEY, "");
                dialogDataModel.putString(KeyByPlotTypeMaster.SAMPLE_SIZE_3D_LOWER_BOUND_KEY, "");
                dialogDataModel.putString(KeyByPlotTypeMaster.SAMPLE_SIZE_3D_UPPER_BOUND_KEY, "");
                dialogDataModel.putString(KeyByPlotTypeMaster.EFFECTS_SIZE_3D_LOWER_BOUND_KEY, "");
                dialogDataModel.putString(KeyByPlotTypeMaster.EFFECTS_SIZE_3D_UPPER_BOUND_KEY, "");
            } else if (plotTypeEnum == PlotTypeEnum.INDEPENDENT_TTEST || plotTypeEnum == PlotTypeEnum.ONE_TTEST || plotTypeEnum == PlotTypeEnum.RELATED_TTEST) {
                dialogDataModel.putString(KeyByPlotTypeMaster.EFFECTS_SIZE_2D_LOWER_BOUND_KEY, "");
                dialogDataModel.putString(KeyByPlotTypeMaster.EFFECTS_SIZE_2D_UPPER_BOUND_KEY, "");
                dialogDataModel.putString(KeyByPlotTypeMaster.EFFECTS_SIZE_3D_LOWER_BOUND_KEY, "");
                dialogDataModel.putString(KeyByPlotTypeMaster.EFFECTS_SIZE_3D_UPPER_BOUND_KEY, "");
            }
        }
    }

    private SPSSTextField getTwoDimensionSampleSizeRangeField(boolean bl) {
        IntTextField intTextField = null;
        if (this.mKeyByPlotTypeMaster.mPlotType == PlotTypeEnum.INDEPENDENT_TTEST) {
            intTextField = new FloatTextField(0.0, Double.MAX_VALUE, 5, true);
            intTextField.setAllowMinMax(true, true);
            intTextField.setAction((Action)new TextFieldAction(this.mParentDlg, bl ? KeyByPlotTypeMaster.SAMPLE_SIZE_2D_LOWER_BOUND_KEY : KeyByPlotTypeMaster.SAMPLE_SIZE_2D_UPPER_BOUND_KEY));
            intTextField.setPreferredSize(new Dimension(50, 25));
        } else {
            intTextField = new IntTextField(0, Integer.MAX_VALUE, true);
            intTextField.setAllowMinMax(false, false);
            intTextField.setAction((Action)new TextFieldAction(this.mParentDlg, bl ? KeyByPlotTypeMaster.SAMPLE_SIZE_2D_LOWER_BOUND_KEY : KeyByPlotTypeMaster.SAMPLE_SIZE_2D_UPPER_BOUND_KEY));
            intTextField.setPreferredSize(new Dimension(50, 25));
        }
        return intTextField;
    }

    private FloatTextField getTwoDimensionEffectSizeRangeField(boolean bl) {
        FloatTextField floatTextField = new FloatTextField(-1.7976931348623157E308, Double.MAX_VALUE, 5, false);
        floatTextField.setAllowMinMax(true, true);
        floatTextField.setAction((Action)new TextFieldAction(this.mParentDlg, bl ? KeyByPlotTypeMaster.EFFECTS_SIZE_2D_LOWER_BOUND_KEY : KeyByPlotTypeMaster.EFFECTS_SIZE_2D_UPPER_BOUND_KEY));
        floatTextField.setPreferredSize(new Dimension(50, 25));
        return floatTextField;
    }

    private IntTextField getDegreeIntField(boolean bl) {
        IntTextField intTextField = new IntTextField(0, 359, true);
        intTextField.setAllowMinMax(true, true);
        intTextField.setAction((Action)new TextFieldAction(this.mParentDlg, bl ? this.mKeyByPlotTypeMaster.getVerticalRotationKey() : this.mKeyByPlotTypeMaster.getHorizontalRotationKey()));
        intTextField.setPreferredSize(new Dimension(50, 25));
        return intTextField;
    }

    private SPSSTextField getThreeDimensionSampleSizeRangeField(boolean bl) {
        IntTextField intTextField = null;
        if (this.mKeyByPlotTypeMaster.mPlotType == PlotTypeEnum.INDEPENDENT_TTEST) {
            intTextField = new FloatTextField(0.0, Double.MAX_VALUE, 5, true);
            intTextField.setAllowMinMax(true, true);
            intTextField.setAction((Action)new TextFieldAction(this.mParentDlg, bl ? KeyByPlotTypeMaster.SAMPLE_SIZE_3D_LOWER_BOUND_KEY : KeyByPlotTypeMaster.SAMPLE_SIZE_3D_UPPER_BOUND_KEY));
            intTextField.setPreferredSize(new Dimension(50, 25));
        } else {
            intTextField = new IntTextField(0, Integer.MAX_VALUE, true);
            intTextField.setAllowMinMax(false, false);
            intTextField.setAction((Action)new TextFieldAction(this.mParentDlg, bl ? KeyByPlotTypeMaster.SAMPLE_SIZE_3D_LOWER_BOUND_KEY : KeyByPlotTypeMaster.SAMPLE_SIZE_3D_UPPER_BOUND_KEY));
            intTextField.setPreferredSize(new Dimension(50, 25));
        }
        return intTextField;
    }

    private FloatTextField getThreeDimensionEffectSizeRangeField(boolean bl) {
        FloatTextField floatTextField = new FloatTextField(-1.7976931348623157E308, Double.MAX_VALUE, 5, false);
        floatTextField.setAllowMinMax(true, true);
        floatTextField.setAction((Action)new TextFieldAction(this.mParentDlg, bl ? KeyByPlotTypeMaster.EFFECTS_SIZE_3D_LOWER_BOUND_KEY : KeyByPlotTypeMaster.EFFECTS_SIZE_3D_UPPER_BOUND_KEY));
        floatTextField.setPreferredSize(new Dimension(50, 25));
        return floatTextField;
    }

    private void enableControls() {
        boolean bl = this.mTwoDimensionSampleSizeCheck.isSelected();
        boolean bl2 = this.mTwoDimensionSampleSizeRangeCheck.isSelected();
        this.mTwoDimensionSampleSizeRangeCheck.setEnabled(bl);
        this.mTwoDimensionSampleSizeLowerLabel.setEnabled(bl && bl2);
        this.mTwoDimensionSampleSizeLowerField.setEnabled(bl && bl2);
        this.mTwoDimensionSampleSizeUpperLabel.setEnabled(bl && bl2);
        this.mTwoDimensionSampleSizeUpperField.setEnabled(bl && bl2);
        boolean bl3 = this.mTwoDimensionEffectSizeCheck.isSelected();
        boolean bl4 = this.mTwoDimensionEffectSizeRangeCheck.isSelected();
        this.mTwoDimensionEffectSizeRangeCheck.setEnabled(bl3);
        this.mTwoDimensionEffectSizeLowerLabel.setEnabled(bl3 && bl4);
        this.mTwoDimensionEffectSizeLowerField.setEnabled(bl3 && bl4);
        this.mTwoDimensionEffectSizeUpperLabel.setEnabled(bl3 && bl4);
        this.mTwoDimensionEffectSizeUpperField.setEnabled(bl3 && bl4);
        boolean bl5 = this.mThreeDimensionPowerVersusCheck.isSelected();
        this.mXAxisMajorRadio.setEnabled(bl5);
        this.mYAxisMajorRadio.setEnabled(bl5);
        this.mVerticalRotationLabel.setEnabled(bl5);
        this.mVerticalRotaionField.setEnabled(bl5);
        this.mVerticalDegreeLabel.setEnabled(bl5);
        this.mHorizontalRotationLabel.setEnabled(bl5);
        this.mHorizontalRotaionField.setEnabled(bl5);
        this.mHorizontalDegreeLabel.setEnabled(bl5);
        boolean bl6 = this.mThreeDimensionSampleSizeRangeCheck.isSelected();
        this.mThreeDimensionSampleSizeRangeCheck.setEnabled(bl5);
        this.mThreeDimensionSampleSizeLowerLabel.setEnabled(bl5 && bl6);
        this.mThreeDimensionSampleSizeLowerField.setEnabled(bl5 && bl6);
        this.mThreeDimensionSampleSizeUpperLabel.setEnabled(bl5 && bl6);
        this.mThreeDimensionSampleSizeUpperField.setEnabled(bl5 && bl6);
        boolean bl7 = this.mThreeDimensionEffectSizeRangeCheck.isSelected();
        this.mThreeDimensionEffectSizeRangeCheck.setEnabled(bl5);
        this.mThreeDimensionEffectSizeLowerLabel.setEnabled(bl5 && bl7);
        this.mThreeDimensionEffectSizeLowerField.setEnabled(bl5 && bl7);
        this.mThreeDimensionEffectSizeUpperLabel.setEnabled(bl5 && bl7);
        this.mThreeDimensionEffectSizeUpperField.setEnabled(bl5 && bl7);
        this.enableContinue(this.canEnableContinue());
    }

    private void setDefaults() {
        this.mTwoDimensionSampleSizeCheck.setSelected(false);
        this.mTwoDimensionSampleSizeRangeCheck.setSelected(false);
        this.mTwoDimensionSampleSizeLowerField.setText("");
        this.mTwoDimensionSampleSizeUpperField.setText("");
        this.mTwoDimensionEffectSizeCheck.setSelected(false);
        this.mTwoDimensionEffectSizeRangeCheck.setSelected(false);
        this.mTwoDimensionEffectSizeLowerField.setText("");
        this.mTwoDimensionEffectSizeUpperField.setText("");
        this.mThreeDimensionPowerVersusCheck.setSelected(false);
        this.mXAxisMajorRadio.setSelected(true);
        this.mYAxisMajorRadio.setSelected(false);
        this.mVerticalRotaionField.setText("10");
        this.mHorizontalRotaionField.setText("325");
        this.mThreeDimensionSampleSizeRangeCheck.setSelected(false);
        this.mThreeDimensionSampleSizeLowerField.setText("");
        this.mThreeDimensionSampleSizeUpperField.setText("");
        this.mThreeDimensionEffectSizeRangeCheck.setSelected(false);
        this.mThreeDimensionEffectSizeLowerField.setText("");
        this.mThreeDimensionEffectSizeUpperField.setText("");
        this.mDisplatTooltip.setSelected(false);
    }

    private boolean canEnableContinue() {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = true;
        boolean bl6 = true;
        boolean bl7 = true;
        boolean bl8 = true;
        boolean bl9 = true;
        boolean bl10 = true;
        if (this.mTwoDimensionSampleSizeCheck.isSelected() && this.mTwoDimensionSampleSizeRangeCheck.isSelected()) {
            bl = this.mTwoDimensionSampleSizeLowerField.getText().trim().length() > 0;
            boolean bl11 = bl2 = this.mTwoDimensionSampleSizeUpperField.getText().trim().length() > 0;
        }
        if (this.mTwoDimensionEffectSizeCheck.isSelected() && this.mTwoDimensionEffectSizeRangeCheck.isSelected()) {
            bl3 = this.mTwoDimensionEffectSizeLowerField.getText().trim().length() > 0;
            boolean bl12 = bl4 = this.mTwoDimensionEffectSizeUpperField.getText().trim().length() > 0;
        }
        if (this.mThreeDimensionPowerVersusCheck.isSelected()) {
            bl5 = this.mVerticalRotaionField.getText().trim().length() > 0;
            boolean bl13 = bl6 = this.mHorizontalRotaionField.getText().trim().length() > 0;
            if (this.mThreeDimensionSampleSizeRangeCheck.isSelected()) {
                bl8 = this.mThreeDimensionSampleSizeLowerField.getText().trim().length() > 0;
                boolean bl14 = bl7 = this.mThreeDimensionSampleSizeUpperField.getText().trim().length() > 0;
            }
            if (this.mThreeDimensionEffectSizeRangeCheck.isSelected()) {
                bl9 = this.mThreeDimensionEffectSizeLowerField.getText().trim().length() > 0;
                bl10 = this.mThreeDimensionEffectSizeUpperField.getText().trim().length() > 0;
            }
        }
        return bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl8 && bl7 && bl9 && bl10;
    }

    public boolean testRangeValues(JComponent jComponent, JComponent jComponent2, double d, double d2, PowerAnalysisPlotRangeMaster.MinMaxInfo minMaxInfo) {
        String string = null;
        JComponent jComponent3 = null;
        if (!minMaxInfo.mMinInclusive && d <= minMaxInfo.mMinValue || minMaxInfo.mMinInclusive && d < minMaxInfo.mMinValue) {
            String string2 = minMaxInfo.mMinInclusive ? "IDS_POWER_ANALYSIS_LOWER_GREATER_EQUAL_ERROR" : "IDS_POWER_ANALYSIS_LOWER_GREATER_ERROR";
            string = MessageFormat.format(this.getResString(string2), minMaxInfo.mMinValue);
            jComponent3 = jComponent;
        } else if (d >= d2) {
            string = this.getResString("IDS_POWER_ANALYSIS_INPUT_LOWER_GREATER_THAN_UPPER_ERROR");
            jComponent3 = jComponent2;
        } else if (!minMaxInfo.mMaxInclusive && d2 >= minMaxInfo.mMaxValue || minMaxInfo.mMaxInclusive && d2 > minMaxInfo.mMaxValue) {
            String string3 = minMaxInfo.mMaxInclusive ? "IDS_POWER_ANALYSIS_UPPER_LESS_EQUAL_ERROR" : "IDS_POWER_ANALYSIS_UPPER_LESS_ERROR";
            string = MessageFormat.format(this.getResString(string3), minMaxInfo.mMaxValue);
            jComponent3 = jComponent2;
        }
        if (string != null) {
            SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this), string, "");
            jComponent3.requestFocusInWindow();
        }
        return string == null;
    }

    public boolean testValue(JComponent jComponent, double d, PowerAnalysisPlotRangeMaster.MinMaxInfo minMaxInfo) {
        String string = null;
        if (!minMaxInfo.mMinInclusive && d <= minMaxInfo.mMinValue || minMaxInfo.mMinInclusive && d < minMaxInfo.mMinValue || !minMaxInfo.mMaxInclusive && d >= minMaxInfo.mMaxValue || minMaxInfo.mMaxInclusive && d > minMaxInfo.mMaxValue) {
            string = MessageFormat.format(this.getResString("IDS_POWER_ANALYSIS_INPUT_RANGE_ERROR"), minMaxInfo.mMinValue, minMaxInfo.mMaxValue);
        }
        if (string != null) {
            SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this), string, "");
            jComponent.requestFocusInWindow();
        }
        return string == null;
    }

    @Override
    public boolean continuePressed() {
        PowerAnalysisPlotRangeMaster.MinMaxInfo minMaxInfo;
        double d;
        double d2;
        boolean bl = true;
        if (this.mTwoDimensionSampleSizeCheck.isSelected() && this.mTwoDimensionSampleSizeRangeCheck.isSelected()) {
            d2 = Double.parseDouble(this.mTwoDimensionSampleSizeLowerField.getText());
            d = Double.parseDouble(this.mTwoDimensionSampleSizeUpperField.getText());
            minMaxInfo = PowerAnalysisPlotRangeMaster.getSampleLowerUpperBounds(this.mPlotType, this.mGroupTableInfo);
            bl = this.testRangeValues((JComponent)this.mTwoDimensionSampleSizeLowerField, (JComponent)this.mTwoDimensionSampleSizeUpperField, d2, d, minMaxInfo);
        }
        if (bl && this.mTwoDimensionEffectSizeCheck.isSelected() && this.mTwoDimensionEffectSizeRangeCheck.isSelected()) {
            d2 = Double.parseDouble(this.mTwoDimensionEffectSizeLowerField.getText());
            d = Double.parseDouble(this.mTwoDimensionEffectSizeUpperField.getText());
            minMaxInfo = PowerAnalysisPlotRangeMaster.getEffectsLowerUpperBounds(this.mPlotType, this.mTestDirectionIsDirectional, this.mEqualForTwoGroups);
            bl = this.testRangeValues((JComponent)this.mTwoDimensionEffectSizeLowerField, (JComponent)this.mTwoDimensionEffectSizeUpperField, d2, d, minMaxInfo);
        }
        if (bl && this.mThreeDimensionPowerVersusCheck.isSelected()) {
            double d3;
            double d4;
            PowerAnalysisPlotRangeMaster.MinMaxInfo minMaxInfo2;
            d2 = Double.parseDouble(this.mVerticalRotaionField.getText());
            bl = this.testValue((JComponent)this.mVerticalRotaionField, d2, minMaxInfo2 = PowerAnalysisPlotRangeMaster.get3DVerticalHorizontalRotationDegrees(true));
            if (bl) {
                d4 = Double.parseDouble(this.mHorizontalRotaionField.getText());
                bl = this.testValue((JComponent)this.mHorizontalRotaionField, d4, minMaxInfo2);
            }
            if (bl && this.mThreeDimensionSampleSizeRangeCheck.isSelected()) {
                d4 = Double.parseDouble(this.mThreeDimensionSampleSizeLowerField.getText());
                d3 = Double.parseDouble(this.mThreeDimensionSampleSizeUpperField.getText());
                minMaxInfo2 = PowerAnalysisPlotRangeMaster.getSampleLowerUpperBounds(this.mPlotType, this.mGroupTableInfo);
                bl = this.testRangeValues((JComponent)this.mThreeDimensionSampleSizeLowerField, (JComponent)this.mThreeDimensionSampleSizeUpperField, d4, d3, minMaxInfo2);
            }
            if (bl && this.mThreeDimensionEffectSizeRangeCheck.isSelected()) {
                d4 = Double.parseDouble(this.mThreeDimensionEffectSizeLowerField.getText());
                d3 = Double.parseDouble(this.mThreeDimensionEffectSizeUpperField.getText());
                minMaxInfo2 = PowerAnalysisPlotRangeMaster.getEffectsLowerUpperBounds(this.mPlotType, this.mTestDirectionIsDirectional, this.mEqualForTwoGroups);
                bl = this.testRangeValues((JComponent)this.mThreeDimensionEffectSizeLowerField, (JComponent)this.mThreeDimensionEffectSizeUpperField, d4, d3, minMaxInfo2);
            }
        }
        return bl;
    }

    public static boolean doesModelChangeRequireReselections(DialogDataModel dialogDataModel, PlotTypeEnum plotTypeEnum) {
        boolean bl = false;
        KeyByPlotTypeMaster keyByPlotTypeMaster = new KeyByPlotTypeMaster(plotTypeEnum);
        if (dialogDataModel != null) {
            Boolean bl2 = dialogDataModel.getBoolean(keyByPlotTypeMaster.getTwoDimSampleSizeKey());
            Boolean bl3 = dialogDataModel.getBoolean(keyByPlotTypeMaster.getTwoDimSampleSizeRangeKey());
            String string = dialogDataModel.getString(KeyByPlotTypeMaster.SAMPLE_SIZE_2D_LOWER_BOUND_KEY);
            if (bl2 != null && bl3 != null && bl2.booleanValue() && bl3.booleanValue()) {
                bl = string != null && string.isEmpty();
            }
            Boolean bl4 = dialogDataModel.getBoolean(keyByPlotTypeMaster.getTwoDimEffectsSizeKey());
            Boolean bl5 = dialogDataModel.getBoolean(keyByPlotTypeMaster.getTwoDimEffectsSizeRangeKey());
            string = dialogDataModel.getString(KeyByPlotTypeMaster.EFFECTS_SIZE_2D_LOWER_BOUND_KEY);
            if (bl4 != null && bl5 != null && bl4.booleanValue() && bl5.booleanValue()) {
                bl = string != null && string.isEmpty();
            }
            Boolean bl6 = dialogDataModel.getBoolean(keyByPlotTypeMaster.getThreeDimSampleSizeRangeKey());
            string = dialogDataModel.getString(KeyByPlotTypeMaster.SAMPLE_SIZE_3D_LOWER_BOUND_KEY);
            if (bl6 != null && bl6.booleanValue()) {
                bl = dialogDataModel.getString(KeyByPlotTypeMaster.SAMPLE_SIZE_3D_LOWER_BOUND_KEY).isEmpty();
            }
            Boolean bl7 = dialogDataModel.getBoolean(keyByPlotTypeMaster.getThreeDimEffectsSizeRangeKey());
            string = dialogDataModel.getString(KeyByPlotTypeMaster.EFFECTS_SIZE_3D_LOWER_BOUND_KEY);
            if (bl7 != null && bl7.booleanValue()) {
                bl = string != null && string.isEmpty();
            }
        }
        return bl;
    }

    private void setupPanel(JPanel jPanel) {
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(n / 2, 0, n / 2, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n2 = 23;
        gridBagConstraints.fill = 2;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        DialogUtil.addUsingGBL(jPanel2, this.createTwoDimensionalPanel(), gridBagConstraints, 0, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel2, this.createThreeDimensionalPanel(), gridBagConstraints, 0, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel2, this.createThreeDimensionalTooltipPanel(), gridBagConstraints, 0, 2, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
    }

    private JPanel createTwoDimensionalPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_POWER_ANALYSIS_ANOVA_PLOT_COMMON_TWO_DIM_GRPBOX")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.createTwoDimensionalSampleSizePanel(), gridBagConstraints, 0, 0, 1, 1, n, BASE_INSETS);
        DialogUtil.addUsingGBL(jPanel, this.createTwoDimensionalEffectSizePanel(), gridBagConstraints, 1, 0, 1, 1, n, BASE_INSETS);
        return jPanel;
    }

    private JPanel createTwoDimensionalSampleSizePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mTwoDimensionSampleSizeCheck, gridBagConstraints, 0, 0, 2, 1, n, BASE_INSETS);
        DialogUtil.addUsingGBL(jPanel, this.mTwoDimensionSampleSizeRangeCheck, gridBagConstraints, 0, 1, 2, 1, n, LEVEL_ONE__INSETS);
        DialogUtil.addUsingGBL(jPanel, this.mTwoDimensionSampleSizeLowerLabel, gridBagConstraints, 0, 2, 1, 1, n, LEVEL_TWO_INSETS);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mTwoDimensionSampleSizeLowerField, gridBagConstraints, 1, 2, 1, 1, n, BASE_INSETS);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mTwoDimensionSampleSizeUpperLabel, gridBagConstraints, 0, 3, 1, 1, n, LEVEL_TWO_INSETS);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mTwoDimensionSampleSizeUpperField, gridBagConstraints, 1, 3, 1, 1, n, BASE_INSETS);
        return jPanel;
    }

    private JPanel createTwoDimensionalEffectSizePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mTwoDimensionEffectSizeCheck, gridBagConstraints, 0, 0, 2, 1, n, BASE_INSETS);
        DialogUtil.addUsingGBL(jPanel, this.mTwoDimensionEffectSizeRangeCheck, gridBagConstraints, 0, 1, 2, 1, n, LEVEL_ONE__INSETS);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mTwoDimensionEffectSizeLowerLabel, gridBagConstraints, 0, 2, 1, 1, n, LEVEL_TWO_INSETS);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mTwoDimensionEffectSizeLowerField, gridBagConstraints, 1, 2, 1, 1, n, BASE_INSETS);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mTwoDimensionEffectSizeUpperLabel, gridBagConstraints, 0, 3, 1, 1, n, LEVEL_TWO_INSETS);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mTwoDimensionEffectSizeUpperField, gridBagConstraints, 1, 3, 1, 1, n, BASE_INSETS);
        if (this.mPlotType == PlotTypeEnum.INDEPENDENT_TTEST) {
            DialogUtil.addUsingGBL(jPanel, (JComponent)this.mTwoDimensionEffectSizeInfo, gridBagConstraints, 0, 4, 2, 1, n, BASE_INSETS);
        }
        return jPanel;
    }

    private JPanel createThreeDimensionalPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_POWER_ANALYSIS_ANOVA_PLOT_COMMON_THREE_DIM_GRPBOX")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mThreeDimensionPowerVersusCheck, gridBagConstraints, 0, 0, 1, 1, n, BASE_INSETS);
        DialogUtil.addUsingGBL(jPanel, this.mXAxisMajorRadio, gridBagConstraints, 0, 1, 2, 1, n, LEVEL_ONE__INSETS);
        DialogUtil.addUsingGBL(jPanel, this.mYAxisMajorRadio, gridBagConstraints, 0, 2, 2, 1, n, LEVEL_ONE__INSETS);
        DialogUtil.addUsingGBL(jPanel, this.createThreeDimLeftPanel(), gridBagConstraints, 0, 3, 1, 1, n, BASE_INSETS);
        DialogUtil.addUsingGBL(jPanel, this.createThreeDimRightPanel(), gridBagConstraints, 1, 3, 1, 1, n, BASE_INSETS);
        return jPanel;
    }

    private JPanel createThreeDimLeftPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(this.mVerticalRotationLabel);
        jPanel2.add((Component)this.mVerticalRotaionField);
        jPanel2.add(this.mVerticalDegreeLabel);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 2, 1, n, BASE_INSETS);
        DialogUtil.addUsingGBL(jPanel, this.mThreeDimensionSampleSizeRangeCheck, gridBagConstraints, 0, 1, 2, 1, n, LEVEL_ONE__INSETS);
        DialogUtil.addUsingGBL(jPanel, this.mThreeDimensionSampleSizeLowerLabel, gridBagConstraints, 0, 2, 1, 1, n, LEVEL_TWO_INSETS);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mThreeDimensionSampleSizeLowerField, gridBagConstraints, 1, 2, 1, 1, n, BASE_INSETS);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mThreeDimensionSampleSizeUpperLabel, gridBagConstraints, 0, 3, 1, 1, n, LEVEL_TWO_INSETS);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mThreeDimensionSampleSizeUpperField, gridBagConstraints, 1, 3, 1, 1, n, BASE_INSETS);
        return jPanel;
    }

    private JPanel createThreeDimRightPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        int n = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(this.mHorizontalRotationLabel);
        jPanel2.add((Component)this.mHorizontalRotaionField);
        jPanel2.add(this.mHorizontalDegreeLabel);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 2, 1, n, LEVEL_ONE__INSETS);
        DialogUtil.addUsingGBL(jPanel, this.mThreeDimensionEffectSizeRangeCheck, gridBagConstraints, 0, 1, 2, 1, n, LEVEL_ONE__INSETS);
        DialogUtil.addUsingGBL(jPanel, this.mThreeDimensionEffectSizeLowerLabel, gridBagConstraints, 0, 2, 1, 1, n, LEVEL_TWO_INSETS);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mThreeDimensionEffectSizeLowerField, gridBagConstraints, 1, 2, 1, 1, n, BASE_INSETS);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mThreeDimensionEffectSizeUpperLabel, gridBagConstraints, 0, 3, 1, 1, n, LEVEL_TWO_INSETS);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mThreeDimensionEffectSizeUpperField, gridBagConstraints, 1, 3, 1, 1, n, BASE_INSETS);
        gridBagConstraints.weightx = 0.0;
        if (this.mPlotType == PlotTypeEnum.INDEPENDENT_TTEST) {
            DialogUtil.addUsingGBL(jPanel, (JComponent)this.mThreeDimensionEffectSizeInfo, gridBagConstraints, 0, 4, 2, 1, n, BASE_INSETS);
        }
        return jPanel;
    }

    private JPanel createThreeDimensionalTooltipPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_POWER_ANALYSIS_COMMON_TOOLTIP_DISPLAY_GRPBOX")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mDisplatTooltip, gridBagConstraints, 0, 0, 1, 1, n, BASE_INSETS);
        return jPanel;
    }

    private JLabel getRangeLabel(String string) {
        return DialogUtil.createLabel(this, string);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mTwoDimensionSampleSizeCheck);
        vector.add(this.mTwoDimensionSampleSizeRangeCheck);
        vector.add(this.mTwoDimensionSampleSizeLowerField);
        vector.add(this.mTwoDimensionSampleSizeUpperField);
        vector.add(this.mTwoDimensionEffectSizeCheck);
        vector.add(this.mTwoDimensionEffectSizeRangeCheck);
        vector.add(this.mTwoDimensionEffectSizeLowerField);
        vector.add(this.mTwoDimensionEffectSizeUpperField);
        if (this.mPlotType == PlotTypeEnum.INDEPENDENT_TTEST) {
            vector.add(this.mTwoDimensionEffectSizeInfo);
        }
        vector.add(this.mThreeDimensionPowerVersusCheck);
        vector.add(this.mXAxisMajorRadio);
        vector.add(this.mYAxisMajorRadio);
        vector.add(this.mVerticalRotaionField);
        vector.add(this.mHorizontalRotaionField);
        vector.add(this.mThreeDimensionSampleSizeRangeCheck);
        vector.add(this.mThreeDimensionSampleSizeLowerField);
        vector.add(this.mThreeDimensionSampleSizeUpperField);
        vector.add(this.mThreeDimensionEffectSizeRangeCheck);
        vector.add(this.mThreeDimensionEffectSizeLowerField);
        vector.add(this.mThreeDimensionEffectSizeUpperField);
        if (this.mPlotType == PlotTypeEnum.INDEPENDENT_TTEST) {
            vector.add(this.mThreeDimensionEffectSizeInfo);
        }
        vector.add(this.mDisplatTooltip);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    class MyDocumentListener
    implements DocumentListener {
        MyDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            PowerAnalysisCommonPlotSubDlg.this.enableContinue(PowerAnalysisCommonPlotSubDlg.this.canEnableContinue());
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            PowerAnalysisCommonPlotSubDlg.this.enableContinue(PowerAnalysisCommonPlotSubDlg.this.canEnableContinue());
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            PowerAnalysisCommonPlotSubDlg.this.enableContinue(PowerAnalysisCommonPlotSubDlg.this.canEnableContinue());
        }
    }

    class MyActionListener
    implements ActionListener {
        MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PowerAnalysisCommonPlotSubDlg.this.enableControls();
        }
    }

    private static class KeyByPlotTypeMaster {
        public static String SAMPLE_SIZE_2D_LOWER_BOUND_KEY = "IDS_SAMPLE_SIZE_2D_LOWER_BOUND";
        public static String SAMPLE_SIZE_2D_UPPER_BOUND_KEY = "IDS_SAMPLE_SIZE_2D_UPPER_BOUND";
        public static String EFFECTS_SIZE_2D_LOWER_BOUND_KEY = "IDS_EFFECTS_SIZE_2D_LOWER_BOUND";
        public static String EFFECTS_SIZE_2D_UPPER_BOUND_KEY = "IDS_EFFECTS_SIZE_2D_UPPER_BOUND";
        public static String SAMPLE_SIZE_3D_LOWER_BOUND_KEY = "IDS_SAMPLE_SIZE_3D_LOWER_BOUND";
        public static String SAMPLE_SIZE_3D_UPPER_BOUND_KEY = "IDS_SAMPLE_SIZE_3D_UPPER_BOUND";
        public static String EFFECTS_SIZE_3D_LOWER_BOUND_KEY = "IDS_EFFECTS_SIZE_3D_LOWER_BOUND";
        public static String EFFECTS_SIZE_3D_UPPER_BOUND_KEY = "IDS_EFFECTS_SIZE_3D_UPPER_BOUND";
        private PlotTypeEnum mPlotType;

        KeyByPlotTypeMaster(PlotTypeEnum plotTypeEnum) {
            this.mPlotType = plotTypeEnum;
        }

        public String getTwoDimSampleSizeKey() {
            String string = null;
            switch (this.mPlotType) {
                case ANOVA: {
                    string = "IDS_POWER_ANALYSIS_ANOVA_PLOT_ANOVA_2D_SAMPLE_SIZE_CHECK";
                    break;
                }
                case ONE_TTEST: 
                case RELATED_TTEST: {
                    string = "IDS_POWER_ANALYSIS_ANOVA_PLOT_ONE_PAIRED_2D_SAMPLE_SIZE_CHECK";
                    break;
                }
                case INDEPENDENT_TTEST: {
                    string = "IDS_POWER_ANALYSIS_ANOVA_PLOT_INDEPENDENT_2D_SAMPLE_SIZE_CHECK";
                }
            }
            return string;
        }

        public String getTwoDimSampleSizeRangeKey() {
            String string = null;
            switch (this.mPlotType) {
                case ANOVA: {
                    string = "IDS_POWER_ANALYSIS_ANOVA_PLOT_ANOVA_2D_SAMPLE_SIZE_RANGE_CHECK";
                    break;
                }
                case ONE_TTEST: 
                case RELATED_TTEST: {
                    string = "IDS_POWER_ANALYSIS_ANOVA_PLOT_ONE_PAIRED_2D_SAMPLE_SIZE_RANGE_CHECK";
                    break;
                }
                case INDEPENDENT_TTEST: {
                    string = "IDS_POWER_ANALYSIS_ANOVA_PLOT_INDEPENDENT_2D_SAMPLE_SIZE_RANGE_CHECK";
                }
            }
            return string;
        }

        public String getTwoDimEffectsSizeKey() {
            String string = null;
            switch (this.mPlotType) {
                case ANOVA: {
                    string = "IDS_POWER_ANALYSIS_ANOVA_PLOT_ANOVA_2D_EFFECT_SIZE_CHECK";
                    break;
                }
                case ONE_TTEST: 
                case RELATED_TTEST: {
                    string = "IDS_POWER_ANALYSIS_ANOVA_PLOT_ONE_PAIRED_2D_EFFECT_SIZE_CHECK";
                    break;
                }
                case INDEPENDENT_TTEST: {
                    string = "IDS_POWER_ANALYSIS_ANOVA_PLOT_INDEPENDENT_2D_EFFECT_SIZE_CHECK";
                }
            }
            return string;
        }

        public String getTwoDimEffectsSizeRangeKey() {
            String string = null;
            switch (this.mPlotType) {
                case ANOVA: {
                    string = "IDS_POWER_ANALYSIS_ANOVA_PLOT_ANOVA_2D_EFFECT_SIZE_RANGE_CHECK";
                    break;
                }
                case ONE_TTEST: 
                case RELATED_TTEST: {
                    string = "IDS_POWER_ANALYSIS_ANOVA_PLOT_ONE_PAIRED_2D_EFFECT_SIZE_RANGE_CHECK";
                    break;
                }
                case INDEPENDENT_TTEST: {
                    string = "IDS_POWER_ANALYSIS_ANOVA_PLOT_INDEPENDENT_2D_EFFECT_SIZE_RANGE_CHECK";
                }
            }
            return string;
        }

        public String getPowerEstimationVerusKey() {
            return "IDS_POWER_ANALYSIS_ANOVA_PLOT_COMMON_POWER_ESTIMATION_CHECK";
        }

        public String getMajorXKey() {
            String string = null;
            switch (this.mPlotType) {
                case ANOVA: {
                    string = "IDS_POWER_ANALYSIS_ANOVA_PLOT_ANOVA_MAJOR_X_RADIO";
                    break;
                }
                case ONE_TTEST: 
                case RELATED_TTEST: {
                    string = "IDS_POWER_ANALYSIS_ANOVA_PLOT_ONE_PAIRED_MAJOR_X_RADIO";
                    break;
                }
                case INDEPENDENT_TTEST: {
                    string = "IDS_POWER_ANALYSIS_ANOVA_PLOT_INDEPENDENT_MAJOR_X_RADIO";
                }
            }
            return string;
        }

        public String getMajorYKey() {
            String string = null;
            switch (this.mPlotType) {
                case ANOVA: {
                    string = "IDS_POWER_ANALYSIS_ANOVA_PLOT_ANOVA_MAJOR_Y_RADIO";
                    break;
                }
                case ONE_TTEST: 
                case RELATED_TTEST: {
                    string = "IDS_POWER_ANALYSIS_ANOVA_PLOT_ONE_PAIRED_MAJOR_Y_RADIO";
                    break;
                }
                case INDEPENDENT_TTEST: {
                    string = "IDS_POWER_ANALYSIS_ANOVA_PLOT_INDEPENDENT_MAJOR_Y_RADIO";
                }
            }
            return string;
        }

        public String getVerticalRotationKey() {
            return "IDS_POWER_ANALYSIS_ANOVA_PLOT_COMMON_VERTICAL_ROTATION";
        }

        public String getHorizontalRotationKey() {
            return "IDS_POWER_ANALYSIS_ANOVA_PLOT_COMMON_HORIZONTAL_ROTATION";
        }

        public String getThreeDimSampleSizeRangeKey() {
            String string = null;
            switch (this.mPlotType) {
                case ANOVA: {
                    string = "IDS_POWER_ANALYSIS_ANOVA_PLOT_ANOVA_3D_SAMPLE_SIZE_RANGE_CHECK";
                    break;
                }
                case ONE_TTEST: 
                case RELATED_TTEST: {
                    string = "IDS_POWER_ANALYSIS_ANOVA_PLOT_ONE_PAIRED_3D_SAMPLE_SIZE_RANGE_CHECK";
                    break;
                }
                case INDEPENDENT_TTEST: {
                    string = "IDS_POWER_ANALYSIS_ANOVA_PLOT_INDEPENDENT_3D_SAMPLE_SIZE_RANGE_CHECK";
                }
            }
            return string;
        }

        public String getThreeDimEffectsSizeRangeKey() {
            String string = null;
            switch (this.mPlotType) {
                case ANOVA: {
                    string = "IDS_POWER_ANALYSIS_ANOVA_PLOT_ANOVA_3D_EFFECT_SIZE_RANGE_CHECK";
                    break;
                }
                case ONE_TTEST: 
                case RELATED_TTEST: {
                    string = "IDS_POWER_ANALYSIS_ANOVA_PLOT_ONE_PAIRED_3D_EFFECT_SIZE_RANGE_CHECK";
                    break;
                }
                case INDEPENDENT_TTEST: {
                    string = "IDS_POWER_ANALYSIS_ANOVA_PLOT_INDEPENDENT_3D_EFFECT_SIZE_RANGE_CHECK";
                }
            }
            return string;
        }

        public String getTooltipDisplayKey() {
            return "IDS_POWER_ANALYSIS_ANOVA_PLOT_COMMON_DISPLAY_TOOLTIPS_CHECK";
        }
    }
}

