/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.nonparametric_tests.two_independent_samples;

import com.spss.java_client.core.common.LicenseOption;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.license.LicenseManager;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.ISpssVarFormatter;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.nonparametric_tests.NonParametricTestsExact;
import com.spss.java_client.ui.dialogs.base.analyze.nonparametric_tests.NonParametricTestsOptions;
import com.spss.java_client.ui.dialogs.base.analyze.nonparametric_tests.two_independent_samples.TwoIndependentGroup;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class TwoIndependentSampleDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener,
FocusListener,
KeyListener {
    private static final String ENABLE_OK_PASTE_KEY = "ENABLE_OK_PASTE";
    private static final String OPTIONS_BUTTON = "IDS_COMMON_OPTIONS_3DOT";
    private static final String RANGE_BUTTON = "IDS_2INDEPENDENT_RANGE_BUTTON";
    private static final String EXACT_BUTTON_KEY = "IDS_COMMON_EXACT_BUTTON";
    private static final String MANN_W_CHECK = "IDS_2INDEPENDENT_MANN_W_CHECK";
    private static final String MOSES_CHECK = "IDS_2INDEPENDENT_MOSES_CHECK";
    private static final String K_S_CHECK = "IDS_2INDEPENDENT_K_S_CHECK";
    private static final String WALD_W_CHECK = "IDS_2INDEPENDENT_WALD_W_CHECK";
    private static final int TARGET_LIST_MAX_LIMIT = 11999;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetTestVarList;
    private TargetVariableList mTargetGroupVarList;
    private JCheckBox mMannWhitney;
    private JCheckBox mMoses;
    private JCheckBox mKolmogorov;
    private JCheckBox mWald;
    private ArrowButton mArrowButtonForTestVar;
    private ArrowButton mArrowButtonForGroupVar;
    private JButton mExact;
    private JButton mOption;
    private JButton mGroup;
    private JScrollPane mScrollPane;
    private boolean mGroupSelected;
    private GroupListFormatter mGroupFormatter;

    public TwoIndependentSampleDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.getResString("IDS_ANALYZE_NONPARA_2INDEPENDENT_TITLE"));
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_NT2I";
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetTestVarList.removeAll();
        this.mTargetGroupVarList.removeAll();
        this.setDefaults();
    }

    @Override
    public String getIActionKey() {
        return "analyze_nonparam_tests_2_indep";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.doEnable();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mTargetGroupVarList.getModel()) {
            this.mGroup.setEnabled(false);
            this.mGroupSelected = false;
            this.getDialogDataModel().putString("GROUP1_KEY", null);
            this.getDialogDataModel().putString("GROUP2_KEY", null);
        }
        this.doEnable();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.doEnable();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.doEnable();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mTargetGroupVarList && this.mTargetGroupVarList.getModel().getSize() == 1) {
            this.mGroup.setEnabled(true);
        } else {
            this.mGroup.setEnabled(false);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        stringBuffer.append(SyntaxUtil.getMainCommand("NPAR TESTS"));
        String string = " ";
        string = string + this.mTargetTestVarList.getVariablesStringList();
        string = string + " BY " + this.mTargetGroupVarList.getModel().getElementAt(0).getName() + "(" + this.getDialogDataModel().getString("GROUP1_KEY") + " " + this.getDialogDataModel().getString("GROUP2_KEY") + ")";
        if (this.mMannWhitney.isSelected()) {
            stringBuffer.append("\n" + SyntaxUtil.getSingleValueSubCommand("M-W", string, false));
        }
        if (this.mMoses.isSelected()) {
            stringBuffer.append("\n" + SyntaxUtil.getSingleValueSubCommand("MOSES", string, false));
        }
        if (this.mKolmogorov.isSelected()) {
            stringBuffer.append("\n" + SyntaxUtil.getSingleValueSubCommand("K-S", string, false));
        }
        if (this.mWald.isSelected()) {
            stringBuffer.append("\n" + SyntaxUtil.getSingleValueSubCommand("W-W", string, false));
        }
        Boolean bl = this.getDialogDataModel().getBoolean("IDS_NTO_DESCRIPTIVE");
        String string2 = "";
        if (bl != null && bl.booleanValue()) {
            string2 = string2 + "DESCRIPTIVES ";
        }
        if ((bl = this.getDialogDataModel().getBoolean("IDS_NTO_QUARTILES")) != null && bl.booleanValue()) {
            string2 = string2 + "QUARTILES";
        }
        if (string2.length() > 0) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/STATISTICS="));
            stringBuffer.append(string2);
        }
        bl = this.getDialogDataModel().getBoolean("IDS_NTO_TEST_BY_TEST");
        String string3 = "";
        if (bl != null && bl.booleanValue()) {
            string3 = string3 + "ANALYSIS";
        }
        if ((bl = this.getDialogDataModel().getBoolean("IDS_NTO_LISTWISE")) != null && bl.booleanValue()) {
            string3 = string3 + "LISTWISE";
        }
        if (bl == null) {
            string3 = string3 + "ANALYSIS";
        }
        if (string3.length() > 0) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/MISSING "));
            stringBuffer.append(string3);
        }
        if ((bl = dialogDataModel.getBoolean("IDS_NTO_EXACT_MONTECARLO")) != null && bl.booleanValue()) {
            String string4 = dialogDataModel.getString("IDS_NTO_EXACT_PERCENTAGE");
            String string5 = dialogDataModel.getString("IDS_NTO_EXACT_NUMBER_OF_SAMPLES");
            String string6 = "";
            if (string4 != null && string5 != null) {
                string6 = " MC CIN(" + string4 + ") SAMPLES(" + string5 + ")";
            }
            stringBuffer.append("\n" + SyntaxUtil.getSingleValueSubCommand("METHOD", string6, false));
        } else {
            bl = dialogDataModel.getBoolean("IDS_NTO_EXACT_EXACT");
            if (bl != null && bl.booleanValue()) {
                bl = (boolean)dialogDataModel.getBoolean("IDS_NTO_EXACT_TIMELIMIT");
                if (bl != null && bl.booleanValue()) {
                    String string7 = dialogDataModel.getString("IDS_NTO_TIME_LIMIT");
                    String string8 = "EXACT TIMER(" + string7 + ")";
                    stringBuffer.append("\n" + SyntaxUtil.getSingleValueSubCommand("METHOD", string8, false));
                } else {
                    String string9 = "EXACT TIMER(0)";
                    stringBuffer.append("\n" + SyntaxUtil.getSingleValueSubCommand("METHOD", string9, false));
                }
            }
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax().toString());
        return stringBuffer.toString();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 39) {
            if (object.equals(this.mMannWhitney)) {
                this.mMoses.requestFocus();
            }
            if (object.equals(this.mMoses)) {
                this.mKolmogorov.requestFocus();
            }
            if (object.equals(this.mKolmogorov)) {
                this.mWald.requestFocus();
            }
            if (object.equals(this.mWald)) {
                this.mMannWhitney.requestFocus();
            }
        }
        if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 37) {
            if (object.equals(this.mWald)) {
                this.mKolmogorov.requestFocus();
            }
            if (object.equals(this.mKolmogorov)) {
                this.mMoses.requestFocus();
            }
            if (object.equals(this.mMoses)) {
                this.mMannWhitney.requestFocus();
            }
            if (object.equals(this.mMannWhitney)) {
                this.mWald.requestFocus();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        ToggleButtonAction toggleButtonAction;
        JPanel jPanel = super.setupOptionsButtonPanel();
        if (LicenseManager.getLicenseManager().getStatus(LicenseOption.CYTEL) == LicenseManager.Status.VALID) {
            toggleButtonAction = new ToggleButtonAction(EXACT_BUTTON_KEY){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TwoIndependentSampleDlg.this.runExactSubDialog();
                }
            };
            this.mExact = new JButton(toggleButtonAction);
            this.addOptionsPanelButton(jPanel, this.mExact);
        } else {
            this.mExact = new JButton();
        }
        toggleButtonAction = new ToggleButtonAction(OPTIONS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TwoIndependentSampleDlg.this.runOptionSubDialog();
            }
        };
        this.mOption = new JButton();
        this.mOption.setAction(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mOption);
        return jPanel;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(new GridBagLayout());
        int n = 23;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_2INDEPENDENT_SOURCE_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, this.mScrollPane, gridBagConstraints, 0, 1, 1, 3, n, null);
        JPanel jPanel2 = this.setupListPanel();
        n = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 2, n, null);
        JPanel jPanel3 = this.setupGroupingVarListPanel();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 2, 1, 1, n, null);
        JPanel jPanel4 = this.setupButtonPanel();
        gridBagConstraints.anchor = 20;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 4, 2, 1, n, null);
        this.setDefaults();
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
        if (this.getDialogDataModel().getBoolean(ENABLE_OK_PASTE_KEY) != null) {
            this.mGroupSelected = this.getDialogDataModel().getBoolean(ENABLE_OK_PASTE_KEY);
        }
        this.doEnable();
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putBoolean(ENABLE_OK_PASTE_KEY, this.mGroupSelected);
    }

    private void runExactSubDialog() {
        this.runSubDialog(new NonParametricTestsExact(this));
    }

    private void runOptionSubDialog() {
        this.runSubDialog(new NonParametricTestsOptions((BaseProcedureDialog)this, this.getResString("IDS_2INDEPENDENT_OPTIONS_TITLE"), "IDH_NT2I_OPT"));
    }

    private void runGroupSubDialog() {
        this.runSubDialog(new TwoIndependentGroup(this));
        String string = this.mGroupFormatter.getDisplayText(this.mTargetGroupVarList.getModel().getElementAt(0));
        this.mGroupSelected = !string.contains("?");
        this.mTargetGroupVarList.repaint();
        boolean bl = this.mMannWhitney.isSelected() || this.mMoses.isSelected() || this.mKolmogorov.isSelected() || this.mWald.isSelected();
        this.enableOkPaste(this.mGroupSelected && this.mTargetGroupVarList.getModel().getSize() > 0 && this.mTargetTestVarList.getModel().getSize() > 0 && bl);
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList();
        this.mSrcVarList.setIdentifier("TWO_SRC_LIST");
        this.mTargetTestVarList = new TargetVariableList();
        this.mTargetTestVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetTestVarList.setMaxLimitOfList(11999);
        this.mTargetTestVarList.setIdentifier("TWO_TARGET_TEST_LIST");
        this.mTargetGroupVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTargetGroupVarList.setIdentifier("TWO_TARGET_GROUP_LIST");
        this.mTargetGroupVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mGroupFormatter = new GroupListFormatter();
        this.mTargetGroupVarList.setCellRenderer(new CustomVarListCellRenderer(this.mGroupFormatter));
        this.mTargetTestVarList.getModel().addListDataListener(this);
        this.mTargetGroupVarList.getModel().addListDataListener(this);
        this.mSrcVarList.addFocusListener(this);
        this.mTargetTestVarList.addFocusListener(this);
        this.mTargetGroupVarList.addFocusListener(this);
        this.mGroup = new JButton();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, RANGE_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TwoIndependentSampleDlg.this.runGroupSubDialog();
            }
        };
        this.mGroup = new JButton();
        this.mGroup.setAction(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, MANN_W_CHECK);
        this.mMannWhitney = new JCheckBox();
        this.mMannWhitney.setAction(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, MOSES_CHECK);
        this.mMoses = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, K_S_CHECK);
        this.mKolmogorov = new JCheckBox();
        this.mKolmogorov.setAction(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, WALD_W_CHECK);
        this.mWald = new JCheckBox();
        this.mWald.setAction(toggleButtonAction);
        this.mMannWhitney.addItemListener(this);
        this.mMoses.addItemListener(this);
        this.mKolmogorov.addItemListener(this);
        this.mWald.addItemListener(this);
        this.mMannWhitney.addKeyListener(this);
        this.mMoses.addKeyListener(this);
        this.mKolmogorov.addKeyListener(this);
        this.mWald.addKeyListener(this);
        this.mScrollPane = new JScrollPane(this.mSrcVarList);
        this.mArrowButtonForTestVar = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButtonForGroupVar = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
    }

    private JPanel setupButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = this.setupCheckBoxPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        int n2 = 24;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(n, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        return jPanel;
    }

    private JPanel setupCheckBoxPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mMannWhitney, this.mMoses, this.mKolmogorov, this.mWald};
        return PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_ANALYZE_NONPARA_2INDEPENDENT_TESTTYPE_BORDER_TITLE"), 2);
    }

    private JPanel setupListPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButtonForTestVar, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_2INDEPENDENT_TEST_VARIABLE_LIST_LABEL");
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mScrollPane = new JScrollPane(this.mTargetTestVarList);
        this.mTargetTestVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetTestVarList.getFixedCellHeight() * 4 + 2));
        this.mScrollPane.setPreferredSize(this.mTargetTestVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, this.mScrollPane, gridBagConstraints, 1, 1, 1, 1, n, null);
        jLabel.setLabelFor(this.mTargetTestVarList);
        this.mArrowButtonForTestVar.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButtonForTestVar.registerVariableList(this.mTargetTestVarList, SpssArrowButton.ButtonOrientation.left);
        return jPanel;
    }

    private JPanel setupGroupingVarListPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        Insets insets2 = new Insets(0, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mArrowButtonForGroupVar, gridBagConstraints, 0, 0, 1, 2, n, insets2);
        int n2 = DialogUtil.getComponentGroupGap();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_2INDEPENDENT_GROUPING_LABEL");
        jLabel.setLabelFor(this.mTargetGroupVarList);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        insets2.set(n2, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        this.mTargetGroupVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        insets2.set(0, insets.left, 0, 0);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        n = 20;
        this.mScrollPane = new JScrollPane(this.mTargetGroupVarList);
        this.mScrollPane.setHorizontalScrollBarPolicy(31);
        this.mScrollPane.setVerticalScrollBarPolicy(21);
        this.mScrollPane.setPreferredSize(this.mTargetGroupVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, this.mScrollPane, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n = 21;
        insets2.set(DialogUtil.getGroupBoxInnerMargin(), insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mGroup, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        this.mArrowButtonForGroupVar.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButtonForGroupVar.registerVariableList(this.mTargetGroupVarList, SpssArrowButton.ButtonOrientation.left);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButtonForTestVar);
        vector.add(this.mArrowButtonForGroupVar);
        vector.add(this.mTargetTestVarList);
        vector.add(this.mTargetGroupVarList);
        vector.add(this.mGroup);
        vector.add(this.mMannWhitney);
        vector.add(this.mMoses);
        vector.add(this.mKolmogorov);
        vector.add(this.mWald);
        if (LicenseManager.getLicenseManager().getStatus(LicenseOption.CYTEL) == LicenseManager.Status.VALID) {
            vector.add(this.mExact);
        }
        vector.add(this.mOption);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setDefaults() {
        this.loadSrcList();
        this.mMannWhitney.setSelected(true);
        this.mKolmogorov.setSelected(false);
        this.mMoses.setSelected(false);
        this.mWald.setSelected(false);
        this.mGroup.setEnabled(false);
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
    }

    private void loadSrcList() {
        SpssVarFilter spssVarFilter = new SpssVarFilter(8, false);
        this.mSrcVarList.addVarFilter(spssVarFilter);
        this.mSrcVarList.loadFromActiveDataset();
    }

    private void doEnable() {
        boolean bl;
        boolean bl2 = bl = this.mGroupSelected && this.mTargetGroupVarList.getModel().getSize() > 0 && this.mTargetTestVarList.getModel().getSize() > 0 && (this.mMannWhitney.isSelected() || this.mMoses.isSelected() || this.mKolmogorov.isSelected() || this.mWald.isSelected());
        if (bl) {
            this.enableOkPaste(true);
        } else {
            this.enableOkPaste(false);
        }
    }

    class GroupListFormatter
    implements ISpssVarFormatter {
        GroupListFormatter() {
        }

        @Override
        public String getDisplayText(ISpssVariable iSpssVariable) {
            DialogDataModel dialogDataModel = TwoIndependentSampleDlg.this.getDialogDataModel();
            String string = dialogDataModel.getString("GROUP1_KEY");
            String string2 = dialogDataModel.getString("GROUP2_KEY");
            if (string != null && string2 != null) {
                return iSpssVariable.getName() + "(" + string + " " + string2 + ")";
            }
            return iSpssVariable.getName() + "(? ?)";
        }

        @Override
        public boolean getShowIcons() {
            return false;
        }

        @Override
        public TargetVariableList getVarList() {
            return TwoIndependentSampleDlg.this.mTargetGroupVarList;
        }
    }
}

