/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.nonparametric_tests.k_related_samples;

import com.spss.java_client.core.common.LicenseOption;
import com.spss.java_client.core.license.LicenseManager;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.nonparametric_tests.NonParametricTestsExact;
import com.spss.java_client.ui.dialogs.base.analyze.nonparametric_tests.k_related_samples.KRelatedSampleStatistic;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class KRelatedSampleDlg
extends BaseProcedureDialog
implements ListDataListener {
    static final int MAX_LIMIT = 16000;
    private static final String STATISTIC_BUTTON = "IDS_COMMON_STATS_3DOT";
    private static final String EXACT_BUTTON_KEY = "IDS_COMMON_EXACT_BUTTON";
    private static final String FREED_CHECK = "IDS_K_FRIED_CHECK";
    private static final String KENDALLS_CHECK = "IDS_K_KENDALLS_CHECK";
    private static final String COCHRANS_CHECK = "IDS_K_COCHRANS_CHECK";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetVarList;
    private JCheckBox mFriedMan;
    private JCheckBox mKendallsW;
    private JCheckBox mCochransQ;
    private ArrowButton mArrowButton;
    private JButton mExact;
    private JButton mStatistic;
    private JScrollPane mScrollPane;

    public KRelatedSampleDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle.getDefaultResourceBundleName(), AnalyzeResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_ANALYZE_NONPARA_KRELATED_TITLE"));
    }

    public void runExactSubDialog() {
        this.runSubDialog(new NonParametricTestsExact(this));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_ntkr";
    }

    public DialogDataModel returnModel() {
        return this.getDialogDataModel();
    }

    public void runStatisticSubDialog() {
        this.runSubDialog(new KRelatedSampleStatistic(this));
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetVarList.removeAll();
        this.setDefaults();
    }

    @Override
    public String getIActionKey() {
        return "analyze_nonparam_tests_k_relat";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.enableOkPaste());
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.enableOkPaste());
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.enableOkPaste());
    }

    @Override
    public String generateSyntax() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("NPAR TESTS"));
        stringBuffer.append("\n");
        String string = this.mTargetVarList.getVariablesStringList();
        boolean bl = dialogDataModel.getBoolean(FREED_CHECK);
        if (bl) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/FRIEDMAN="));
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        if (bl = dialogDataModel.getBoolean(COCHRANS_CHECK).booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/COCHRAN="));
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        if (bl = dialogDataModel.getBoolean(KENDALLS_CHECK).booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/KENDALL="));
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        String string2 = "";
        int n = 0;
        Boolean bl2 = dialogDataModel.getBoolean("IDS_STAT_DES_CHECK");
        if (bl2 != null) {
            bl = bl2;
            if (bl) {
                string2 = string2 + "DESCRIPTIVES ";
                ++n;
            }
            if (bl = dialogDataModel.getBoolean("IDS_STAT_QUARTILES_CHECK").booleanValue()) {
                if (n == 1) {
                    string2 = string2 + "";
                }
                string2 = string2 + "QUARTILES";
                ++n;
            }
            if (n > 0) {
                stringBuffer.append(SyntaxUtil.getSubCommand("/STATISTICS "));
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append(SyntaxUtil.getSubCommand("/MISSING LISTWISE"));
        String string3 = "";
        String string4 = "";
        bl2 = dialogDataModel.getBoolean("IDS_NTO_EXACT_ASYMPTOTIC");
        if (bl2 != null && !bl2.booleanValue()) {
            bl = dialogDataModel.getBoolean("IDS_NTO_EXACT_MONTECARLO");
            if (bl) {
                string3 = dialogDataModel.getString("IDS_NTO_EXACT_PERCENTAGE");
                string4 = dialogDataModel.getString("IDS_NTO_EXACT_NUMBER_OF_SAMPLES");
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/METHOD=MC CIN(")).append(string3).append(") SAMPLES(").append(string4).append(")");
            } else {
                bl = dialogDataModel.getBoolean("IDS_NTO_EXACT_EXACT");
                if (bl) {
                    bl = dialogDataModel.getBoolean("IDS_NTO_EXACT_TIMELIMIT");
                    if (bl) {
                        String string5 = dialogDataModel.getString("IDS_NTO_TIME_LIMIT");
                        stringBuffer.append("\n");
                        stringBuffer.append(SyntaxUtil.getSubCommand("/METHOD=EXACT TIMER(")).append(string5).append(")");
                    } else {
                        stringBuffer.append("\n");
                        stringBuffer.append(SyntaxUtil.getSubCommand("/METHOD=EXACT TIMER(")).append("0").append(")");
                    }
                }
            }
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupAllPanel(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private boolean enableOkPaste() {
        return (this.mFriedMan.isSelected() || this.mKendallsW.isSelected() || this.mCochransQ.isSelected()) && this.mTargetVarList.getModel().getSize() > 1;
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction;
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetVarList.setMaxLimitOfList(16000);
        this.mTargetVarList.getModel().addListDataListener(this);
        if (LicenseManager.getLicenseManager().getStatus(LicenseOption.CYTEL) == LicenseManager.Status.VALID) {
            toggleButtonAction = new ToggleButtonAction(EXACT_BUTTON_KEY){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    KRelatedSampleDlg.this.runExactSubDialog();
                }
            };
            this.mExact = new JButton(toggleButtonAction);
        } else {
            this.mExact = new JButton();
        }
        toggleButtonAction = new ToggleButtonAction(STATISTIC_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KRelatedSampleDlg.this.runStatisticSubDialog();
            }
        };
        this.mStatistic = new JButton();
        this.mStatistic.setAction(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, FREED_CHECK){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KRelatedSampleDlg.this.enableOkPaste(KRelatedSampleDlg.this.enableOkPaste());
            }
        };
        this.mFriedMan = new JCheckBox();
        this.mFriedMan.setAction(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, KENDALLS_CHECK){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KRelatedSampleDlg.this.enableOkPaste(KRelatedSampleDlg.this.enableOkPaste());
            }
        };
        this.mKendallsW = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, COCHRANS_CHECK){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KRelatedSampleDlg.this.enableOkPaste(KRelatedSampleDlg.this.enableOkPaste());
            }
        };
        this.mCochransQ = new JCheckBox();
        this.mCochransQ.setAction(toggleButtonAction);
        this.mScrollPane = new JScrollPane(this.mSrcVarList);
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
    }

    private void setupAllPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = this.setupListPanel();
        gridBagConstraints.fill = 1;
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n, n, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, 23, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets = new Insets(n, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setupCheckBoxPanel(), gridBagConstraints, 0, 1, 1, 1, 23, insets);
        insets = new Insets(n, n, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.setupOptionPanel(), gridBagConstraints, 1, 0, 1, 1, 23, insets);
    }

    private JPanel setupOptionPanel() {
        Insets insets = DialogUtil.getStandardButtonInsets();
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        if (LicenseManager.getLicenseManager().getStatus(LicenseOption.CYTEL) == LicenseManager.Status.VALID) {
            DialogUtil.addUsingGBL(jPanel, this.mExact, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        }
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mStatistic, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        DialogUtil.normalizeButtonWidths((JPanel)jPanel);
        return jPanel;
    }

    private JPanel setupCheckBoxPanel() {
        Insets insets = DialogUtil.getStandardControlInsets();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_ANA_NON_KREL_TEST_TYPE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mFriedMan, gridBagConstraints, 0, 0, 1, 1, 23, insets);
        DialogUtil.addUsingGBL(jPanel, this.mKendallsW, gridBagConstraints, 1, 0, 1, 1, 23, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mCochransQ, gridBagConstraints, 2, 0, 1, 1, 23, insets);
        return jPanel;
    }

    private JPanel setupListPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.mScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_KRELATED_SOURCE_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mScrollPane, gridBagConstraints, 0, 1, 1, 2, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_K_LABEL_VARIABLE");
        gridBagConstraints.weightx = 1.0;
        jLabel2.setLabelFor(this.mTargetVarList);
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mScrollPane = new JScrollPane(this.mTargetVarList);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 6 + 2));
        this.mScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, this.mScrollPane, gridBagConstraints, 2, 1, 1, 1, n, null);
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetVarList);
        vector.add(this.mFriedMan);
        vector.add(this.mKendallsW);
        vector.add(this.mCochransQ);
        if (LicenseManager.getLicenseManager().getStatus(LicenseOption.CYTEL) == LicenseManager.Status.VALID) {
            vector.add(this.mExact);
        }
        vector.add(this.mStatistic);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
        this.mFriedMan.setSelected(true);
        this.mCochransQ.setSelected(false);
        this.mKendallsW.setSelected(false);
    }
}

