/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.nonparametric_tests;

import com.spss.java_client.core.common.LicenseOption;
import com.spss.java_client.core.license.LicenseManager;
import com.spss.java_client.ui.controls.ComponentsArrowButton;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.ListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.PairedVariablesDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.PairedVariablesDropListener;
import com.spss.java_client.ui.dialogs.adv_stats.rep_measures.ListTraversalArrowButton;
import com.spss.java_client.ui.dialogs.base.analyze.nonparametric_tests.NonParametricTestsExact;
import com.spss.java_client.ui.dialogs.base.analyze.nonparametric_tests.NonParametricTestsOptions;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.PairedVariableUtility;
import com.spss.java_client.ui.dialogs.common.PairedVariablesTable;
import com.spss.java_client.ui.dialogs.common.SwapTableContentListener;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TwoRelatedSamplesDlg
extends BaseProcedureDialog
implements ListSelectionListener,
ActionListener,
FocusListener,
ItemListener {
    static final int MAX_LIMIT = 6000;
    static final String WILCO_CHECK = "IDS_2RELATED_SAMPLE_WILCO_CHECK";
    static final String SIGN_CHECK = "IDS_2RELATED_SAMPLE_SIGN_CHECK";
    static final String MCNEMAR_CHECK = "IDS_2RELATED_SAMPLE_MCNEMAR_CHECK";
    static final String MARGINAL_CHECK = "IDS_2RELATED_SAMPLE_MARGINAL_CHECK";
    static final String EXACT_BUTTON_KEY = "IDS_COMMON_EXACT_BUTTON";
    public static final String RELATED_TARGET_LIST_KEY = "RELATED_TTEST_TARGET_LIST";
    private SrcVariableList mSrcVarList;
    private PlainList mTargetVarList;
    private ComponentsArrowButton mArrowButton;
    private Vector<Object> mTabOrder;
    private JButton mOptionsButton;
    private JButton mExactButton;
    private JCheckBox mWilcoCheck;
    private JCheckBox mSignCheck;
    private JCheckBox mMcNemarCheck;
    private JCheckBox mMarginalCheck;
    private PairedVariablesTable mPairTable;
    private JButton mSwapButton;
    private JPanel mPanel;
    private Border mBlueBorder = BorderFactory.createLineBorder(Color.BLUE);
    private Border mDefaultScrollPaneBorder;
    private JScrollPane mPairedTableScrollPane;

    public TwoRelatedSamplesDlg(JFrame jFrame) {
        super(jFrame, true, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.getResString("IDS_2RELATED_SAMPLE_TITLE"));
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.enableOkPaste(PairedVariableUtility.isBlankCellAvailable(this.mPairTable) && (this.mWilcoCheck.isSelected() || this.mSignCheck.isSelected() || this.mMcNemarCheck.isSelected() || this.mMarginalCheck.isSelected()));
        this.enableOkPaste(PairedVariableUtility.isBlankCellAvailable(this.mPairTable) && (this.mWilcoCheck.isSelected() || this.mSignCheck.isSelected() || this.mMcNemarCheck.isSelected() || this.mMarginalCheck.isSelected()));
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() instanceof SrcVariableList) {
            this.enableArrowButton();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.mSrcVarList.clearSelection();
        this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        PairedVariableUtility.resetTable(this.mPairTable);
        this.getDialogDataModel().putSerializableArray("PAIRED_TTEST_TARGET_LIST", null);
        this.enableOkPaste(false);
        this.setDefaults();
        this.mSrcVarList.ensureIndexIsVisible(0);
        this.mSrcVarList.requestFocus();
        this.mSwapButton.setEnabled(false);
    }

    @Override
    public String getIActionKey() {
        return "analyze_nonparam_tests_2_relat";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_nt2r";
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        stringBuffer.append(SyntaxUtil.getMainCommand("NPAR TESTS"));
        if (this.mWilcoCheck.isSelected()) {
            stringBuffer.append("\n" + SyntaxUtil.getSingleValueSubCommand("WILCOXON", PairedVariableUtility.getSyntaxString(this.mPairTable, true), false));
        }
        if (this.mSignCheck.isSelected()) {
            stringBuffer.append("\n" + SyntaxUtil.getSingleValueSubCommand("SIGN", PairedVariableUtility.getSyntaxString(this.mPairTable, true), false));
        }
        if (this.mMcNemarCheck.isSelected()) {
            stringBuffer.append("\n" + SyntaxUtil.getSingleValueSubCommand("MCNEMAR", PairedVariableUtility.getSyntaxString(this.mPairTable, true), false));
        }
        if (this.mMarginalCheck.isSelected()) {
            stringBuffer.append("\n" + SyntaxUtil.getSingleValueSubCommand("MH", PairedVariableUtility.getSyntaxString(this.mPairTable, true), false));
        }
        Boolean bl = this.getDialogDataModel().getBoolean("IDS_NTO_DESCRIPTIVE");
        StringBuffer stringBuffer2 = new StringBuffer();
        if (bl != null && bl.booleanValue()) {
            stringBuffer2.append("DESCRIPTIVES ");
        }
        if ((bl = this.getDialogDataModel().getBoolean("IDS_NTO_QUARTILES")) != null && bl.booleanValue()) {
            stringBuffer2.append("QUARTILES");
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/STATISTICS "));
            stringBuffer.append(stringBuffer2.toString());
        }
        bl = this.getDialogDataModel().getBoolean("IDS_NTO_TEST_BY_TEST");
        StringBuffer stringBuffer3 = new StringBuffer();
        if (bl != null && bl.booleanValue()) {
            stringBuffer3.append("ANALYSIS");
        }
        if ((bl = this.getDialogDataModel().getBoolean("IDS_NTO_LISTWISE")) != null && bl.booleanValue()) {
            stringBuffer3.append("LISTWISE");
        }
        if (bl == null) {
            stringBuffer3.append("ANALYSIS");
        }
        if (stringBuffer3.length() > 0) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/MISSING "));
            stringBuffer.append(stringBuffer3.toString());
        }
        if ((bl = dialogDataModel.getBoolean("IDS_NTO_EXACT_MONTECARLO")) != null && bl.booleanValue()) {
            String string = dialogDataModel.getString("IDS_NTO_EXACT_PERCENTAGE");
            String string2 = dialogDataModel.getString("IDS_NTO_EXACT_NUMBER_OF_SAMPLES");
            String string3 = "";
            if (string != null && string2 != null) {
                string3 = " MC CIN(" + string + ") SAMPLES(" + string2 + ")";
            }
            stringBuffer.append("\n" + SyntaxUtil.getSingleValueSubCommand("METHOD", string3, false));
        } else {
            bl = dialogDataModel.getBoolean("IDS_NTO_EXACT_EXACT");
            if (bl != null && bl.booleanValue()) {
                bl = dialogDataModel.getBoolean("IDS_NTO_EXACT_TIMELIMIT");
                if (bl != null && bl.booleanValue()) {
                    String string = dialogDataModel.getString("IDS_NTO_TIME_LIMIT");
                    String string4 = "EXACT TIMER(" + string + ")";
                    stringBuffer.append("\n" + SyntaxUtil.getSingleValueSubCommand("METHOD", string4, false));
                } else {
                    String string = "EXACT TIMER(0)";
                    stringBuffer.append("\n" + SyntaxUtil.getSingleValueSubCommand("METHOD", string, false));
                }
            }
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax().toString());
        return stringBuffer.toString();
    }

    @Override
    public boolean okPastePressed() {
        if (PairedVariableUtility.isDuplicatePairAvailable(this.mPairTable)) {
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (SpssArrowButton.ButtonOrientation.right != ((ComponentsArrowButton)actionEvent.getSource()).getArrowOrientation()) {
            PairedVariableUtility.removeElementFromTable(this.mPairTable, this.mSrcVarList);
        } else {
            PairedVariableUtility.addElementToTable(this.mPairTable, this.mSrcVarList);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof SrcVariableList) {
            this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
            this.mPairTable.setSelectionBackground(Color.lightGray);
            this.enableArrowButton();
            this.enableOkPasteButton();
        } else if (object instanceof PlainTable) {
            this.mPairedTableScrollPane.setBorder(this.mBlueBorder);
            this.enableOkPasteButton();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof PlainTable) {
            this.mPairedTableScrollPane.setBorder(this.mDefaultScrollPaneBorder);
        }
    }

    @Override
    public void pack() {
        super.pack();
        DialogUtil.removeDragAdapters((DragPane)this.getGlassPane(), this.mSrcVarList);
        if (this.getGlassPane() instanceof DragPane) {
            this.addDragAdapters((DragPane)this.getGlassPane(), (Component)((Object)this), this.mVarMoveHandler);
        }
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0 && (this.mWilcoCheck.isSelected() || this.mSignCheck.isSelected() || this.mMcNemarCheck.isSelected() || this.mMarginalCheck.isSelected()));
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        this.setTabPolicy();
        this.pack();
    }

    @Override
    protected void saveDialogState() {
        ToggleButtonAction toggleButtonAction = (ToggleButtonAction)this.mWilcoCheck.getAction();
        this.getDialogDataModel().putBoolean(toggleButtonAction.getActionKey(), this.mWilcoCheck.isSelected());
        toggleButtonAction = (ToggleButtonAction)this.mSignCheck.getAction();
        this.getDialogDataModel().putBoolean(toggleButtonAction.getActionKey(), this.mSignCheck.isSelected());
        toggleButtonAction = (ToggleButtonAction)this.mMarginalCheck.getAction();
        this.getDialogDataModel().putBoolean(toggleButtonAction.getActionKey(), this.mMarginalCheck.isSelected());
        toggleButtonAction = (ToggleButtonAction)this.mMcNemarCheck.getAction();
        this.getDialogDataModel().putBoolean(toggleButtonAction.getActionKey(), this.mMcNemarCheck.isSelected());
        PairedVariableUtility.saveTableData(this.getDialogDataModel(), this.mPairTable);
    }

    @Override
    protected void loadDialogState() {
        ToggleButtonAction toggleButtonAction = (ToggleButtonAction)this.mWilcoCheck.getAction();
        Boolean bl = this.getDialogDataModel().getBoolean(toggleButtonAction.getActionKey());
        if (bl != null) {
            this.mWilcoCheck.setSelected(bl);
        }
        toggleButtonAction = (ToggleButtonAction)this.mSignCheck.getAction();
        bl = this.getDialogDataModel().getBoolean(toggleButtonAction.getActionKey());
        if (bl != null) {
            this.mSignCheck.setSelected(bl);
        }
        toggleButtonAction = (ToggleButtonAction)this.mMarginalCheck.getAction();
        bl = this.getDialogDataModel().getBoolean(toggleButtonAction.getActionKey());
        if (bl != null) {
            this.mMarginalCheck.setSelected(bl);
        }
        toggleButtonAction = (ToggleButtonAction)this.mMcNemarCheck.getAction();
        bl = this.getDialogDataModel().getBoolean(toggleButtonAction.getActionKey());
        if (bl != null) {
            this.mMcNemarCheck.setSelected(bl);
        }
        PairedVariableUtility.loadTableData(this.getDialogDataModel(), this.mPairTable);
        this.validateSerializableLists();
        this.enableOkPaste(this.mPairTable.getRowCount() > 2);
        this.setVisible(true);
    }

    @Override
    protected void validateSerializableLists() {
    }

    @Override
    protected boolean validateDialogDataModel(boolean bl) {
        PairedVariableUtility.validateTableData(this.getDialogDataModel());
        return super.validateDialogDataModel(bl);
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        if (LicenseManager.getLicenseManager().getStatus(LicenseOption.CYTEL) == LicenseManager.Status.VALID) {
            ToggleButtonAction toggleButtonAction = new ToggleButtonAction(EXACT_BUTTON_KEY){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TwoRelatedSamplesDlg.this.runExactSubDialog();
                }
            };
            this.mExactButton = new JButton(toggleButtonAction);
            this.addOptionsPanelButton(jPanel, this.mExactButton);
        } else {
            this.mExactButton = new JButton();
        }
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TwoRelatedSamplesDlg.this.runOptionsSubDialog();
            }
        };
        this.mOptionsButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mOptionsButton);
        return jPanel;
    }

    private void enableOkPasteButton() {
        if (this.mPairTable.getRowCount() == 1) {
            this.enableOkPaste(false);
        } else {
            boolean bl = PairedVariableUtility.isBlankCellAvailable(this.mPairTable);
            this.enableOkPaste(bl && (this.mWilcoCheck.isSelected() || this.mSignCheck.isSelected() || this.mMcNemarCheck.isSelected() || this.mMarginalCheck.isSelected()));
        }
    }

    private void addDragAdapters(DragPane dragPane, Component component, IVarMoveHandler iVarMoveHandler) {
        if (component instanceof VariableList) {
            VariableList variableList = (VariableList)component;
            ListDragAdapter listDragAdapter = new ListDragAdapter(variableList, dragPane, "VariableList");
            DialogUtil.modifyMouseInputListeners(variableList, listDragAdapter);
        } else if (component instanceof PlainTable) {
            PairedVariablesDragAdapter pairedVariablesDragAdapter = new PairedVariablesDragAdapter(this.mPairTable, dragPane, "PlainTable");
            DialogUtil.modifyMouseInputListeners(this.mPairTable, pairedVariablesDragAdapter);
            dragPane.addDropListener((IDropListener)new PairedVariablesDropListener(this.mPairTable, iVarMoveHandler, this.mSrcVarList));
        } else if (component instanceof Container) {
            Container container = (Container)component;
            for (Component component2 : container.getComponents()) {
                this.addDragAdapters(dragPane, component2, iVarMoveHandler);
            }
        }
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eDoNothing);
        this.mSrcVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    TwoRelatedSamplesDlg.this.mArrowButton.doClick();
                }
            }
        });
        this.mSrcVarList.addListSelectionListener(this);
        this.mSrcVarList.addFocusListener(this);
        this.mTargetVarList = new PlainList("RELATED_TARGET_LIST");
        this.mTargetVarList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    TwoRelatedSamplesDlg.this.mArrowButton.doClick();
                }
            }
        });
        this.mTargetVarList.addFocusListener(this);
        this.mTargetVarList.addListSelectionListener(this);
        this.mTargetVarList.setMaxLimitOfList(6000);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, WILCO_CHECK);
        this.mWilcoCheck = new JCheckBox(toggleButtonAction);
        this.mWilcoCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, SIGN_CHECK);
        this.mSignCheck = new JCheckBox(toggleButtonAction);
        this.mSignCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, MCNEMAR_CHECK);
        this.mMcNemarCheck = new JCheckBox(toggleButtonAction);
        this.mMcNemarCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, MARGINAL_CHECK);
        this.mMarginalCheck = new JCheckBox(toggleButtonAction);
        this.mMarginalCheck.addItemListener(this);
        spssButtonGroup.add(this.mWilcoCheck);
        spssButtonGroup.add(this.mSignCheck);
        spssButtonGroup.add(this.mMcNemarCheck);
        spssButtonGroup.add(this.mMarginalCheck);
        this.mTabOrder = new Vector();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getResString("IDS_2RELATED_SAMPLE_TABLE_COL_FIRST"));
        arrayList.add(this.getResString("IDS_2RELATED_SAMPLE_TABLE_COL_SECOND"));
        arrayList.add(this.getResString("IDS_2RELATED_SAMPLE_TABLE_COL_THREE"));
        this.mPairTable = new PairedVariablesTable(this.mSrcVarList, arrayList);
        this.mPairTable.addFocusListener(this);
        this.mPairTable.getSelectionModel().addListSelectionListener(this);
        this.mPairedTableScrollPane = new JScrollPane(this.mPairTable);
        this.mArrowButton = new ComponentsArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerComponents(this.mPairTable, SpssArrowButton.ButtonOrientation.left);
        this.mArrowButton.setEnabled(false);
        this.mArrowButton.addActionListener(this);
        this.mSwapButton = new JButton();
        String string = ResUtil.getCommonDlgString("IDS_PAIR_VARIABLE_SWAP_BUTTON_IMAGE");
        URL uRL = ResUtil.getCommonDlgImageResource(string);
        this.mSwapButton.setIcon(new ImageIcon(uRL));
        this.mSwapButton.addActionListener(new SwapTableContentListener(this.mPairTable, this.mSwapButton));
        ListTraversalArrowButton listTraversalArrowButton = new ListTraversalArrowButton(this.mPairTable, false, this.mSrcVarList.getSelectionBackground());
        this.mSwapButton.setEnabled(false);
        this.mPanel = listTraversalArrowButton.setupArrowButtonPanel();
    }

    private JPanel setupSrcListPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, n2, 0, 0);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_2RELATED_SAMPLE_SOURCE_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        insets.set(0, n2, n2, 0);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 2, n, insets);
        return jPanel;
    }

    private JPanel setupTargetListPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.fill = 2;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_2RELATED_SAMPLE_PAIRED_VAR_LABEL");
        gridBagConstraints.weightx = 1.0;
        insets.set(0, 0, 0, n2);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        this.mDefaultScrollPaneBorder = this.mPairedTableScrollPane.getBorder();
        Dimension dimension = this.mPairTable.getPreferredSize();
        this.mPairedTableScrollPane.setPreferredSize(new Dimension(dimension.width, 118));
        DialogUtil.addUsingGBL(jPanel, this.mPairedTableScrollPane, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        insets.set(insets2.top, insets2.left, insets2.bottom, insets2.right);
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        n = 23;
        JPanel jPanel2 = this.setupTestTypePanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n2, 0, n2, n2);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 2, 1, 1, n, insets);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(0, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel3, this.mPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel3, this.mSwapButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 2, 1, 1, 1, n, null);
        return jPanel;
    }

    private JPanel setupTestTypePanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mWilcoCheck, this.mSignCheck, this.mMcNemarCheck, this.mMarginalCheck};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_2RELATED_SAMPLE_TEST_TYPE_BORDER"));
        return jPanel;
    }

    private void setupViewPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.setupSrcListPanel(), gridBagConstraints, 0, 0, 1, 2, n, null);
        DialogUtil.addUsingGBL(jPanel, this.setupTargetListPanel(), gridBagConstraints, 1, 0, 1, 1, n, null);
    }

    private void setDefaults() {
        this.mSrcVarList.setSelectedIndex(0);
        this.mWilcoCheck.setSelected(true);
        this.mSignCheck.setSelected(false);
        this.mMcNemarCheck.setSelected(false);
        this.mMarginalCheck.setSelected(false);
        if (LicenseManager.getLicenseManager().getStatus(LicenseOption.CYTEL) == LicenseManager.Status.VALID) {
            this.mMarginalCheck.setEnabled(true);
        } else {
            this.mMarginalCheck.setEnabled(false);
        }
    }

    private void setTabPolicy() {
        int n;
        this.mTabOrder.add(this.mSrcVarList);
        this.mTabOrder.add(this.mArrowButton);
        this.mTabOrder.add(this.mPairTable);
        this.mTabOrder.add(this.mWilcoCheck);
        this.mTabOrder.add(this.mSignCheck);
        this.mTabOrder.add(this.mMcNemarCheck);
        this.mTabOrder.add(this.mMarginalCheck);
        for (n = 0; n < this.mPanel.getComponentCount(); ++n) {
            this.mTabOrder.add(this.mPanel.getComponent(n));
        }
        this.mTabOrder.add(this.mSwapButton);
        if (LicenseManager.getLicenseManager().getStatus(LicenseOption.CYTEL) == LicenseManager.Status.VALID) {
            this.mTabOrder.add(this.mExactButton);
        }
        this.mTabOrder.add(this.mOptionsButton);
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.mTabOrder.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mTabOrder, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void runOptionsSubDialog() {
        this.runSubDialog(new NonParametricTestsOptions((BaseProcedureDialog)this, this.getResString("IDS_2RELATED_OPTIONS_TITLE"), "idh_nt2r_opt"));
    }

    private void runExactSubDialog() {
        this.runSubDialog(new NonParametricTestsExact(this));
    }

    private void enableArrowButton() {
        boolean bl = false;
        if (this.mSrcVarList.getSelectedIndices().length >= 1 && this.mSrcVarList.hasFocus()) {
            bl = true;
        } else if (this.mTargetVarList.hasFocus() && !this.mTargetVarList.isSelectionEmpty()) {
            bl = true;
        }
        this.mArrowButton.setEnabled(bl);
    }
}

