/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.nonparametric_tests;

import com.spss.java_client.core.common.LicenseOption;
import com.spss.java_client.core.license.LicenseManager;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.nonparametric_tests.NonParametricTestsExact;
import com.spss.java_client.ui.dialogs.base.analyze.nonparametric_tests.NonParametricTestsOptions;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class RunsDlg
extends BaseProcedureDialog
implements ListDataListener,
DocumentListener,
ItemListener {
    static final int MAX_LIMIT = 12000;
    static final float MIN_VALUE = -9999.0f;
    static final float MAX_VALUE = 99999.0f;
    static final int CUSTOM_COLUMN = 5;
    static final int CUSTOM_PRECISION = 2;
    static final String CUSTOM_INT_TEXT = "IDS_INT_TEXTFIELD";
    static final String MEDIAN_CHECK_BOX = "IDS_MEDIAN_CHECK";
    static final String MODE_CHECK_BOX = "IDS_MODE_CHECK";
    static final String MEAN_CHECK_BOX = "IDS_MEAN_CHECK";
    static final String CUSTOM_CHECK_BOX = "IDS_CUSTOM_CHECK";
    final String EXACT_BUTTON = "IDS_COMMON_EXACT_BUTTON";
    final String OPTIONS_BUTTON = "IDS_COMMON_OPTIONS_3DOT";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetVarList;
    private ArrowButton mArrowButton;
    private JCheckBox mMedianCheckBox;
    private JCheckBox mModeCheckBox;
    private JCheckBox mMeanCheckBox;
    private JCheckBox mCustomCheckBox;
    private FloatTextField mCustomFloat;
    private JButton mExactButton;
    private JButton mOptionsButton;

    public RunsDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.getResString("IDS_ANALYZE_NONPARA_RUNS_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getIActionKey() {
        return "analyze_nonparam_tests_runs";
    }

    @Override
    public String generateSyntax() {
        String string;
        Boolean bl;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        stringBuffer.append(SyntaxUtil.getMainCommand("NPAR TESTS"));
        if (this.mMedianCheckBox.isSelected()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/RUNS(MEDIAN)=") + this.mTargetVarList.getVariablesStringList());
        }
        if (this.mMeanCheckBox.isSelected()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/RUNS(MEAN)=") + this.mTargetVarList.getVariablesStringList());
        }
        if (this.mModeCheckBox.isSelected()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/RUNS(MODE)=") + this.mTargetVarList.getVariablesStringList());
        }
        if (this.mCustomCheckBox.isSelected()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/RUNS(") + this.mCustomFloat.getText() + ")=" + "" + this.mTargetVarList.getVariablesStringList());
        }
        if ((bl = dialogDataModel.getBoolean("IDS_NTO_DESCRIPTIVE")) != null && bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/STATISTICS DESCRIPTIVES"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_NTO_QUARTILES")) != null && bl.booleanValue()) {
            if (stringBuffer.indexOf("STATISTICS") > 0) {
                stringBuffer.append(" QUARTILES ");
            } else {
                stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/STATISTICS QUARTILES "));
            }
        }
        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/MISSING "));
        bl = dialogDataModel.getBoolean("IDS_NTO_TEST_BY_TEST");
        if (bl == null || bl.booleanValue()) {
            stringBuffer.append("ANALYSIS");
        } else {
            stringBuffer.append("LISTWISE");
        }
        bl = dialogDataModel.getBoolean("IDS_NTO_EXACT_MONTECARLO");
        if (bl != null && bl.booleanValue()) {
            string = dialogDataModel.getString("IDS_NTO_EXACT_PERCENTAGE");
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/METHOD=MC") + " CIN(" + string + ")");
            String string2 = dialogDataModel.getString("IDS_NTO_EXACT_NUMBER_OF_SAMPLES");
            stringBuffer.append(" SAMPLES(" + string2 + ")");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_NTO_EXACT_EXACT")) != null && bl.booleanValue()) {
            bl = dialogDataModel.getBoolean("IDS_NTO_EXACT_TIMELIMIT");
            if (bl != null && bl.booleanValue()) {
                string = dialogDataModel.getString("IDS_NTO_TIME_LIMIT");
                stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/METHOD=EXACT") + " TIMER(" + string + ")");
            } else {
                stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/METHOD=EXACT") + " TIMER(0)");
            }
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetVarList.getModel().removeAll();
        this.mModeCheckBox.setSelected(false);
        this.mMeanCheckBox.setSelected(false);
        this.mCustomCheckBox.setSelected(false);
        this.mCustomFloat.setText("");
        this.setDefaults();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_ntru";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.checkEnableOKPasteCondition();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (this.mTargetVarList.getModel().getSize() > 0) {
            this.checkEnableOKPasteCondition();
        } else {
            this.enableOkPaste(false);
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.mCustomFloat.getText().length() > 0 && this.mTargetVarList.getModel().getSize() > 0) {
            this.enableOkPaste(true);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.mCustomFloat.getText().length() > 0 && this.mTargetVarList.getModel().getSize() > 0) {
            this.enableOkPaste(true);
        } else {
            this.enableOkPaste(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.checkStateOfCheckBox(itemEvent);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setUpUI(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
    }

    protected void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        SpssVarFilter spssVarFilter = new SpssVarFilter(8, false);
        this.mSrcVarList.addVarFilter(spssVarFilter);
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mTargetVarList.setMaxLimitOfList(12000);
        this.mTargetVarList.addVarFilter(spssVarFilter);
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mMedianCheckBox = new JCheckBox(new ToggleButtonAction(this, MEDIAN_CHECK_BOX));
        this.mMedianCheckBox.addItemListener(this);
        this.mMeanCheckBox = new JCheckBox(new ToggleButtonAction(this, MEAN_CHECK_BOX));
        this.mMeanCheckBox.addItemListener(this);
        this.mModeCheckBox = new JCheckBox(new ToggleButtonAction(this, MODE_CHECK_BOX));
        this.mModeCheckBox.addItemListener(this);
        this.mCustomCheckBox = new JCheckBox(new ToggleButtonAction(this, CUSTOM_CHECK_BOX));
        this.mCustomCheckBox.addItemListener(this);
        this.mCustomFloat = new FloatTextField(-9999.0, 99999.0, 2);
        this.mCustomFloat.setAction((Action)new TextFieldAction(this, CUSTOM_INT_TEXT));
        this.mCustomFloat.setColumns(5);
        Dimension dimension = new Dimension(5, 5);
        this.mCustomFloat.setMinimumSize(dimension);
        this.mCustomFloat.getDocument().addDocumentListener(this);
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        this.mExactButton = new JButton();
        if (LicenseManager.getLicenseManager().getStatus(LicenseOption.CYTEL) == LicenseManager.Status.VALID) {
            this.mExactButton.setAction(new ToggleButtonAction("IDS_COMMON_EXACT_BUTTON"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RunsDlg.this.runExactSubDialog();
                }
            });
            this.addOptionsPanelButton(jPanel, this.mExactButton);
        }
        this.mOptionsButton = new JButton();
        this.mOptionsButton.setAction(new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RunsDlg.this.runOptionsSubDialog();
            }
        });
        this.addOptionsPanelButton(jPanel, this.mOptionsButton);
        return jPanel;
    }

    private void checkEnableOKPasteCondition() {
        boolean bl = false;
        if (this.mMeanCheckBox.isSelected() || this.mMedianCheckBox.isSelected() || this.mModeCheckBox.isSelected()) {
            bl = true;
            if (this.mCustomCheckBox.isSelected()) {
                bl = bl && this.mCustomFloat.getText().length() > 0;
            }
        } else if (this.mCustomCheckBox.isSelected()) {
            bl = this.mCustomFloat.getText().length() > 0;
        }
        bl = bl && this.mTargetVarList.getModel().getSize() > 0;
        this.enableOkPaste(bl);
    }

    private void checkStateOfCheckBox(ItemEvent itemEvent) {
        boolean bl = false;
        if (itemEvent.getSource() == this.mCustomCheckBox) {
            if (this.mCustomCheckBox.isSelected()) {
                this.mCustomFloat.setEnabled(true);
                this.mCustomFloat.setOpaque(true);
                if (this.mCustomFloat.getText().length() > 0) {
                    bl = true;
                }
            } else {
                this.mCustomFloat.setEnabled(false);
                this.mCustomFloat.setOpaque(false);
                bl = this.mMeanCheckBox.isSelected() || this.mMedianCheckBox.isSelected() || this.mModeCheckBox.isSelected();
            }
        }
        if (itemEvent.getSource() == this.mMeanCheckBox || itemEvent.getSource() == this.mMedianCheckBox || itemEvent.getSource() == this.mModeCheckBox) {
            if (this.mMeanCheckBox.isSelected() || this.mMedianCheckBox.isSelected() || this.mModeCheckBox.isSelected()) {
                if (this.mCustomCheckBox.isSelected()) {
                    if (this.mCustomFloat.getText().length() > 0) {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
            } else if (this.mCustomCheckBox.isSelected() && this.mCustomFloat.getText().length() > 0) {
                bl = true;
            }
        }
        bl = bl && this.mTargetVarList.getModel().getSize() > 0;
        this.enableOkPaste(bl);
    }

    private void setDefaults() {
        this.mCustomFloat.setEnabled(false);
        this.mMedianCheckBox.setSelected(true);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
        this.mCustomFloat.setOpaque(false);
        this.enableOkPaste(false);
    }

    private void setUpUI(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = this.setUpPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        JPanel jPanel3 = this.setUpCutPointPanel();
        DialogUtil.createButtonGroup(jPanel3);
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
    }

    private void runExactSubDialog() {
        new NonParametricTestsExact(this);
    }

    private void runOptionsSubDialog() {
        new NonParametricTestsOptions((BaseProcedureDialog)this, this.getResString("IDS_NONPARA_RUNS_OPTIONS_TITLE"), "idh_ntru_opt");
    }

    private JPanel setUpPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_ANALYZE_NONPARA_RUN_SOURCE_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 6, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n = 23;
        gridBagConstraints.fill = 2;
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_TARGET_LABEL");
        jLabel2.setLabelFor(this.mTargetVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane2 = new JScrollPane(this.mTargetVarList);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 6 + 2));
        jScrollPane2.setPreferredSize(this.mTargetVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 3, 3, n, null);
        return jPanel;
    }

    private JPanel setUpCutPointPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_CHECK_BOX_BORDER"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mMedianCheckBox, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mModeCheckBox, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mMeanCheckBox, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCustomCheckBox, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        Insets insets2 = new Insets(0, 10, 5, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mCustomFloat, gridBagConstraints, 2, 1, 1, 1, n, insets2);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetVarList);
        vector.add(this.mMedianCheckBox);
        vector.add(this.mMeanCheckBox);
        vector.add(this.mModeCheckBox);
        vector.add(this.mCustomCheckBox);
        vector.add(this.mCustomFloat);
        if (LicenseManager.getLicenseManager().getStatus(LicenseOption.CYTEL) == LicenseManager.Status.VALID) {
            vector.add(this.mExactButton);
        }
        vector.add(this.mOptionsButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }
}

