/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.nonparametric_tests;

import com.spss.java_client.core.common.LicenseOption;
import com.spss.java_client.core.license.LicenseManager;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.nonparametric_tests.NonParametricTestsExact;
import com.spss.java_client.ui.dialogs.base.analyze.nonparametric_tests.NonParametricTestsOptions;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class OneSampleKSDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener {
    static final int MAX_LIMIT = 12000;
    static final String NORMAL_CHECK_BOX = "IDS_1SAMPLE_KS_NORMAL_CHECK";
    static final String UNIFORM_CHECK_BOX = "IDS_1SAMPLE_KS_UNIFORM_CHECK";
    static final String POISSON_CHECK_BOX = "IDS_1SAMPLE_KS_POISSON_CHECK";
    static final String EXPONENTIAL_CHECK_BOX = "IDS_1SAMPLE_KS_EXPONENTIAL_CHECK";
    final String EXACT_BUTTON = "IDS_COMMON_EXACT_BUTTON";
    final String OPTIONS_BUTTON = "IDS_COMMON_OPTIONS_3DOT";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetVarList;
    private ArrowButton mArrowButton;
    private JCheckBox mNormalCheckBox;
    private JCheckBox mUniformCheckBox;
    private JCheckBox mPoissonCheckBox;
    private JCheckBox mExponentialCheckBox;
    private JButton mExactButton;
    private JButton mOptionsButton;

    public OneSampleKSDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.getResString("IDS_1SAMPLE_KS_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getIActionKey() {
        return "analyze_nonparam_tests_1_ks";
    }

    @Override
    public String generateSyntax() {
        String string;
        Boolean bl;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        stringBuffer.append(SyntaxUtil.getMainCommand("NPAR TESTS"));
        if (this.mNormalCheckBox.isSelected()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/K-S(NORMAL)=") + this.mTargetVarList.getVariablesStringList());
        }
        if (this.mUniformCheckBox.isSelected()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/K-S(UNIFORM)=") + this.mTargetVarList.getVariablesStringList());
        }
        if (this.mPoissonCheckBox.isSelected()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/K-S(POISSON)=") + this.mTargetVarList.getVariablesStringList());
        }
        if (this.mExponentialCheckBox.isSelected()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/K-S(EXPONENTIAL)=") + this.mTargetVarList.getVariablesStringList());
        }
        if ((bl = dialogDataModel.getBoolean("IDS_NTO_DESCRIPTIVE")) != null && bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/STATISTICS DESCRIPTIVES"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_NTO_QUARTILES")) != null && bl.booleanValue()) {
            if (stringBuffer.indexOf("STATISTICS") > 0) {
                stringBuffer.append(" QUARTILES");
            } else {
                stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/STATISTICS QUARTILES"));
            }
        }
        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/MISSING "));
        bl = dialogDataModel.getBoolean("IDS_NTO_TEST_BY_TEST");
        if (bl == null || bl.booleanValue()) {
            stringBuffer.append("ANALYSIS");
        } else {
            stringBuffer.append("LISTWISE");
        }
        bl = dialogDataModel.getBoolean("IDS_NTO_EXACT_MONTECARLO");
        if (bl != null && bl.booleanValue()) {
            string = dialogDataModel.getString("IDS_NTO_EXACT_PERCENTAGE");
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/METHOD=MC CIN(") + string + ")");
            String string2 = dialogDataModel.getString("IDS_NTO_EXACT_NUMBER_OF_SAMPLES");
            stringBuffer.append(" SAMPLES(" + string2 + ")");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_NTO_EXACT_EXACT")) != null && bl.booleanValue()) {
            bl = dialogDataModel.getBoolean("IDS_NTO_EXACT_TIMELIMIT");
            if (bl != null && bl.booleanValue()) {
                string = dialogDataModel.getString("IDS_NTO_TIME_LIMIT");
                stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/METHOD=EXACT") + " TIMER(" + string + ")");
            } else {
                stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/METHOD=EXACT") + " TIMER(0)");
            }
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_ntk1";
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetVarList.getModel().removeAll();
        this.mUniformCheckBox.setSelected(false);
        this.mPoissonCheckBox.setSelected(false);
        this.mExponentialCheckBox.setSelected(false);
        this.setDefaults();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.checkEnableOKPasteCondition();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.checkEnableOKPasteCondition();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.checkEnableOKPasteCondition();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setUpUI(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
    }

    protected void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        SpssVarFilter spssVarFilter = new SpssVarFilter(8, false);
        this.mSrcVarList.addVarFilter(spssVarFilter);
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mTargetVarList.setMaxLimitOfList(12000);
        this.mTargetVarList.addVarFilter(spssVarFilter);
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mNormalCheckBox = new JCheckBox(new ToggleButtonAction(this, NORMAL_CHECK_BOX));
        this.mNormalCheckBox.addItemListener(this);
        this.mPoissonCheckBox = new JCheckBox(new ToggleButtonAction(this, POISSON_CHECK_BOX));
        this.mPoissonCheckBox.addItemListener(this);
        this.mUniformCheckBox = new JCheckBox(new ToggleButtonAction(this, UNIFORM_CHECK_BOX));
        this.mUniformCheckBox.addItemListener(this);
        this.mExponentialCheckBox = new JCheckBox(new ToggleButtonAction(this, EXPONENTIAL_CHECK_BOX));
        this.mExponentialCheckBox.addItemListener(this);
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        this.mExactButton = new JButton();
        if (LicenseManager.getLicenseManager().getStatus(LicenseOption.CYTEL) == LicenseManager.Status.VALID) {
            this.mExactButton.setAction(new ToggleButtonAction("IDS_COMMON_EXACT_BUTTON"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OneSampleKSDlg.this.runExactSubDialog();
                }
            });
            this.addOptionsPanelButton(jPanel, this.mExactButton);
        }
        this.mOptionsButton = new JButton();
        this.mOptionsButton.setAction(new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OneSampleKSDlg.this.runOptionsSubDialog();
            }
        });
        this.addOptionsPanelButton(jPanel, this.mOptionsButton);
        return jPanel;
    }

    private void checkEnableOKPasteCondition() {
        if ((this.mNormalCheckBox.isSelected() || this.mUniformCheckBox.isSelected() || this.mPoissonCheckBox.isSelected() || this.mExponentialCheckBox.isSelected()) && this.mTargetVarList.getModel().getSize() > 0) {
            this.enableOkPaste(true);
        } else {
            this.enableOkPaste(false);
        }
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
        this.mNormalCheckBox.setSelected(true);
    }

    private void setUpUI(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = this.setUpListPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        JPanel jPanel3 = this.setUpTestDistributionPanel();
        DialogUtil.createButtonGroup(jPanel3);
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
    }

    private void runExactSubDialog() {
        new NonParametricTestsExact(this);
    }

    private void runOptionsSubDialog() {
        new NonParametricTestsOptions((BaseProcedureDialog)this, this.getResString("IDS_1SAMPLE_KS_OPTIONS_TITLE"), "idh_ntk1_opt");
    }

    private JPanel setUpListPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        JScrollPane jScrollPane2 = new JScrollPane(this.mTargetVarList);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 6 + 2));
        jScrollPane2.setPreferredSize(this.mTargetVarList.getMinimumSize());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_1SAMPLE_KS_TARGET_LABEL");
        jLabel.setLabelFor(this.mTargetVarList);
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_1SAMPLE_KS_SOURCE_LABEL");
        jLabel2.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 6, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 3, 3, n, null);
        return jPanel;
    }

    private JPanel setUpTestDistributionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_1SAMPLE_KS_CHECK_BOX_BORDER"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mNormalCheckBox, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mUniformCheckBox, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mPoissonCheckBox, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mExponentialCheckBox, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetVarList);
        vector.add(this.mNormalCheckBox);
        vector.add(this.mUniformCheckBox);
        vector.add(this.mPoissonCheckBox);
        vector.add(this.mExponentialCheckBox);
        if (LicenseManager.getLicenseManager().getStatus(LicenseOption.CYTEL) == LicenseManager.Status.VALID) {
            vector.add(this.mExactButton);
        }
        vector.add(this.mOptionsButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }
}

