/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.nonparametric_tests;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NonParametricTestsExact
extends BaseSubDialog
implements ItemListener,
DocumentListener,
FocusListener {
    public static final String ASYMPTOTIC_RADIO = "IDS_NTO_EXACT_ASYMPTOTIC";
    public static final String MONTE_CARLO_RADIO = "IDS_NTO_EXACT_MONTECARLO";
    public static final String EXACT_RADIO = "IDS_NTO_EXACT_EXACT";
    public static final String TIME_LIMIT_CHECK = "IDS_NTO_EXACT_TIMELIMIT";
    public static final String TIME_LIMIT = "IDS_NTO_TIME_LIMIT";
    public static final String CONFIDENCE_PERCENT = "IDS_NTO_EXACT_PERCENTAGE";
    public static final String NUMBER_SAMPLES = "IDS_NTO_EXACT_NUMBER_OF_SAMPLES";
    static final String CONFILEVEL_TEXT = "99";
    static final String SAMPLES_TEXT = "10000";
    static final String TIME_TEXT = "5";
    static final int CONFILEVEL_COLUMN = 4;
    static final int SAMPLES_COLUMN = 8;
    static final int TIME_COLUMN = 6;
    static final int MIN_VALUE = 0;
    static final int MAX_VALUE = 9999999;
    static final int SAMPLE_MIN_VALUE = 1;
    static final int SAMPLE_MAX_VALUE = 1000000000;
    static final float CONFILEVEL_MIN_VALUE = 0.0f;
    static final float CONFILEVEL_MAX_VALUE = 100.0f;
    static final int CONFILEVEL_PRECISION = 3;
    private FloatTextField mConfiLevel;
    private IntTextField mSamples;
    private JCheckBox mTimeCheck;
    private IntTextField mTime;
    private JRadioButton mMontoRadio;
    private JRadioButton mExactRadio;
    private JRadioButton mAsymptRadio;
    private SpssButtonGroup mRadioGroup;

    public NonParametricTestsExact(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, "", true, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.mResBundle.getString("IDS_NTO_EXACT_TITLE"));
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.enableMonteCarloGroup(this.mMontoRadio.isSelected());
        this.enableExactGroup(this.mExactRadio.isSelected());
        this.enableContinue();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mConfiLevel)) {
            this.mConfiLevel.selectAll();
        } else if (focusEvent.getSource().equals(this.mSamples)) {
            this.mSamples.selectAll();
        } else if (focusEvent.getSource().equals(this.mTime)) {
            this.mTime.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public String getDialogHelpID() {
        return "idh_exact";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        this.pack();
        this.setFocusTraversalPolicy();
    }

    protected void initVars() {
        this.mAsymptRadio = new JRadioButton(new ToggleButtonAction(this, ASYMPTOTIC_RADIO));
        this.mAsymptRadio.addItemListener(this);
        this.mMontoRadio = new JRadioButton(new ToggleButtonAction(this, MONTE_CARLO_RADIO));
        this.mMontoRadio.addItemListener(this);
        this.mExactRadio = new JRadioButton(new ToggleButtonAction(this, EXACT_RADIO));
        this.mExactRadio.addItemListener(this);
        this.mRadioGroup = new SpssButtonGroup();
        this.mRadioGroup.add(this.mAsymptRadio);
        this.mRadioGroup.add(this.mMontoRadio);
        this.mRadioGroup.add(this.mExactRadio);
        this.mConfiLevel = new FloatTextField(0.0, 100.0, 3);
        this.mConfiLevel.setIncludeMinRange(false);
        this.mConfiLevel.setIncludeMaxRange(false);
        this.mConfiLevel.setAction((Action)new TextFieldAction(this, CONFIDENCE_PERCENT));
        this.mConfiLevel.setColumns(4);
        this.mConfiLevel.getDocument().addDocumentListener(this);
        this.mConfiLevel.addFocusListener((FocusListener)this);
        this.mSamples = new IntTextField(1, 1000000000, true);
        this.mSamples.setAction((Action)new TextFieldAction(this, NUMBER_SAMPLES));
        this.mSamples.setColumns(8);
        this.mSamples.getDocument().addDocumentListener(this);
        this.mSamples.addFocusListener((FocusListener)this);
        this.mTimeCheck = new JCheckBox(new ToggleButtonAction(this, TIME_LIMIT_CHECK));
        this.mTimeCheck.addItemListener(this);
        this.mTime = new IntTextField(0, 9999999, true);
        this.mTime.setAction((Action)new TextFieldAction(this, TIME_LIMIT));
        this.mTime.setColumns(6);
        this.mTime.getDocument().addDocumentListener(this);
        this.mTime.addFocusListener((FocusListener)this);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mRadioGroup);
        vector.add(this.mConfiLevel);
        vector.add(this.mSamples);
        vector.add(this.mTimeCheck);
        vector.add(this.mTime);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setDefaults() {
        this.mTime.setEnabled(false);
        this.mConfiLevel.setEnabled(false);
        this.mSamples.setEnabled(false);
        this.mTimeCheck.setEnabled(false);
        this.mConfiLevel.setText(CONFILEVEL_TEXT);
        this.mConfiLevel.setOpaque(false);
        this.mSamples.setText(SAMPLES_TEXT);
        this.mSamples.setOpaque(false);
        this.mTime.setText(TIME_TEXT);
        this.mTime.setOpaque(false);
        this.mAsymptRadio.setSelected(true);
        this.mTimeCheck.setSelected(true);
        Dimension dimension = new Dimension(36, 19);
        this.mConfiLevel.setMinimumSize(dimension);
        dimension = new Dimension(75, 19);
        this.mSamples.setMinimumSize(dimension);
        dimension = new Dimension(60, 19);
        this.mTime.setMinimumSize(dimension);
    }

    private void enableContinue() {
        boolean bl = false;
        if (this.mAsymptRadio.isSelected()) {
            bl = true;
        } else if (this.mMontoRadio.isSelected() && this.mConfiLevel.getText().length() > 0 && this.mSamples.getText().length() > 0) {
            bl = true;
        } else if (this.mExactRadio.isSelected()) {
            bl = !this.mTimeCheck.isSelected() || this.mTime.getText().length() != 0;
        }
        super.enableContinue(bl);
    }

    private JPanel setupPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_NTO_EXACT_CONFIDENCE");
        jLabel.setLabelFor((Component)this.mConfiLevel);
        JLabel jLabel2 = DialogUtil.createLabel(this, NUMBER_SAMPLES);
        jLabel2.setLabelFor((Component)this.mSamples);
        JLabel jLabel3 = new JLabel(this.getResString(CONFIDENCE_PERCENT));
        JLabel jLabel4 = new JLabel(this.getResString("IDS_NTO_EXACT_MINUTES"));
        JTextArea jTextArea = new JTextArea();
        jTextArea.setColumns(32);
        jTextArea.setRows(2);
        jTextArea.setFont(jLabel4.getFont());
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setText(this.getResString("IDS_NTO_EXACT_METHOD_LABEL"));
        jTextArea.setFocusable(false);
        JTextArea jTextArea2 = new JTextArea();
        jTextArea2.setOpaque(false);
        jTextArea2.setColumns(32);
        jTextArea2.setRows(2);
        jTextArea2.setFont(jLabel4.getFont());
        jTextArea2.setLineWrap(true);
        jTextArea2.setWrapStyleWord(true);
        jTextArea2.setText(this.getResString("IDS_NTO_NON_ASYMPTOTIC_METHOD_LABEL"));
        jTextArea2.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mAsymptRadio, gridBagConstraints, 0, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, this.mMontoRadio, gridBagConstraints, 0, 1, 1, 1, n, null);
        Insets insets2 = new Insets(insets.top, DialogUtil.getGroupBoxInnerMargin() * 6, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        n = 24;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mConfiLevel, gridBagConstraints, 1, 2, 1, 1, n, insets);
        n = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 2, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        n = 10;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        n = 24;
        gridBagConstraints.fill = 0;
        insets = new Insets(insets.bottom * 2, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mSamples, gridBagConstraints, 1, 3, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        n = 23;
        insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mExactRadio, gridBagConstraints, 0, 4, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, this.mTimeCheck, gridBagConstraints, 0, 5, 1, 1, n, insets2);
        n = 24;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mTime, gridBagConstraints, 1, 5, 1, 1, n, insets);
        n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 10;
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 2, 5, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        n = 23;
        gridBagConstraints.weightx = 0.0;
        insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 6, 3, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jTextArea2, gridBagConstraints, 0, 7, 3, 1, n, insets);
        return jPanel;
    }

    private void enableExactGroup(boolean bl) {
        this.mTimeCheck.setEnabled(bl);
        this.mTime.setEnabled(bl && this.mTimeCheck.isSelected());
        this.mTime.setOpaque(bl && this.mTimeCheck.isSelected());
    }

    private void enableMonteCarloGroup(boolean bl) {
        this.mConfiLevel.setEnabled(bl);
        this.mConfiLevel.setOpaque(bl);
        this.mSamples.setEnabled(bl);
        this.mSamples.setOpaque(bl);
    }
}

