/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.nonparametric_tests;

import com.spss.java_client.core.common.LicenseOption;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.license.LicenseManager;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.CustomVarListModel;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SpssVarFormatter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.AnalyzeDefineRange;
import com.spss.java_client.ui.dialogs.base.analyze.nonparametric_tests.NonParametricTestsExact;
import com.spss.java_client.ui.dialogs.base.analyze.nonparametric_tests.NonParametricTestsOptions;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class KIndependentSampleDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener,
FocusListener {
    private static final String OPTIONS_BUTTON = "IDS_COMMON_OPTIONS_3DOT";
    private static final String RANGE_BUTTON = "IDS_KINDEPENDENT_RANGE_BUTTON";
    private static final String EXACT_BUTTON_KEY = "IDS_COMMON_EXACT_BUTTON";
    private static final String KRUSKAL_CHECK = "IDS_KINDEPENDENT_KRUSKAL_CHECK";
    private static final String MEDIAN_CHECK = "IDS_KINDEPENDENT_MEDIAN_CHECK";
    private static final String JONCKH_CHECK = "IDS_KINDEPENDENT_JONCKH_CHECK";
    private static final int TARGET_LIST_LIMIT = 15999;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetTestVarList;
    private TargetVariableList mTargetGroupVarList;
    private KIndependentSamplesSpssVarFormatter mGroupFormatter;
    private KIndependentSampleGroupListModel mGroupModel;
    private JCheckBox mKruskal;
    private JCheckBox mMedian;
    private JCheckBox mJonckheere;
    private ArrowButton mArrowButtonForTestVar;
    private ArrowButton mArrowButtonForGroupVar;
    private JButton mExact;
    private JButton mStatistic;
    private JButton mRange;
    private JScrollPane mScrollPane;
    private boolean mRangeSelected;

    public KIndependentSampleDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.getResString("IDS_ANALYZE_NONPARA_KINDEPENDENT_TITLE"));
    }

    @Override
    public String getDialogHelpID() {
        return "IDH_NTKI";
    }

    @Override
    public void reset() {
        super.reset();
        this.mSrcVarList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mTargetTestVarList.removeAll();
        this.mTargetGroupVarList.removeAll();
        this.setDefaults();
        this.mSrcVarList.requestFocus();
    }

    @Override
    public String getIActionKey() {
        return "analyze_nonparam_tests_k_indep";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableDisableOkPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableDisableOkPaste();
        if (listDataEvent.getSource().equals(this.mGroupModel)) {
            this.mRangeSelected = false;
            DialogDataModel dialogDataModel = this.getDialogDataModel();
            dialogDataModel.putString("IDS_DEFINE_RANGE_MINIMUM", null);
            dialogDataModel.putString("IDS_DEFINE_RANGE_MAXIMUM", null);
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableDisableOkPaste();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.enableDisableOkPaste();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        boolean bl = focusEvent.getSource().equals(this.mSrcVarList) || focusEvent.getSource().equals(this.mTargetTestVarList);
        this.mRange.setEnabled(focusEvent.getSource().equals(this.mTargetGroupVarList) && this.mTargetGroupVarList.getModel().getSize() > 0 && !bl);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        stringBuffer.append(SyntaxUtil.getMainCommand("NPAR TESTS"));
        String string = "";
        for (int i = 0; i < this.mTargetTestVarList.getModel().getSize(); ++i) {
            string = i != this.mTargetTestVarList.getModel().getSize() - 1 ? string + this.mTargetTestVarList.getModel().getElementAt(i).getName() + " " : string + this.mTargetTestVarList.getModel().getElementAt(i).getName();
        }
        string = string + " BY " + this.mTargetGroupVarList.getModel().getElementAt(0).getName() + "(" + this.getDialogDataModel().getString("IDS_DEFINE_RANGE_MINIMUM") + " " + this.getDialogDataModel().getString("IDS_DEFINE_RANGE_MAXIMUM") + ")";
        if (this.mKruskal.isSelected()) {
            stringBuffer.append("\n").append(SyntaxUtil.getSingleValueSubCommand("K-W", string, false));
        }
        if (this.mMedian.isSelected()) {
            stringBuffer.append("\n").append(SyntaxUtil.getSingleValueSubCommand("MEDIAN", string, false));
        }
        if (this.mJonckheere.isSelected()) {
            stringBuffer.append("\n").append(SyntaxUtil.getSingleValueSubCommand("J-T", string, false));
        }
        Boolean bl = this.getDialogDataModel().getBoolean("IDS_NTO_DESCRIPTIVE");
        String string2 = "";
        if (bl != null && bl.booleanValue()) {
            string2 = string2 + "DESCRIPTIVES ";
        }
        if ((bl = this.getDialogDataModel().getBoolean("IDS_NTO_QUARTILES")) != null && bl.booleanValue()) {
            string2 = string2 + "QUARTILES";
        }
        if (string2.length() > 0) {
            stringBuffer.append("\n").append(SyntaxUtil.getSingleParameterSubCommand("STATISTICS", string2, false));
        }
        bl = this.getDialogDataModel().getBoolean("IDS_NTO_TEST_BY_TEST");
        String string3 = "";
        if (bl != null && bl.booleanValue()) {
            string3 = string3 + "ANALYSIS";
        }
        if ((bl = this.getDialogDataModel().getBoolean("IDS_NTO_LISTWISE")) != null && bl.booleanValue()) {
            string3 = string3 + "LISTWISE";
        }
        if (bl == null) {
            string3 = string3 + "ANALYSIS";
        }
        if (string3.length() > 0) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/MISSING ")).append(string3);
        }
        if ((bl = dialogDataModel.getBoolean("IDS_NTO_EXACT_MONTECARLO")) != null && bl.booleanValue()) {
            String string4 = dialogDataModel.getString("IDS_NTO_EXACT_PERCENTAGE");
            String string5 = dialogDataModel.getString("IDS_NTO_EXACT_NUMBER_OF_SAMPLES");
            String string6 = "";
            if (string4 != null && string5 != null) {
                string6 = "MC CIN(" + string4 + ") SAMPLES(" + string5 + ")";
            }
            stringBuffer.append("\n").append(SyntaxUtil.getSingleValueSubCommand("METHOD", string6, false));
        } else {
            bl = dialogDataModel.getBoolean("IDS_NTO_EXACT_EXACT");
            if (bl != null && bl.booleanValue()) {
                bl = dialogDataModel.getBoolean("IDS_NTO_EXACT_TIMELIMIT");
                if (bl != null && bl.booleanValue()) {
                    String string7 = dialogDataModel.getString("IDS_NTO_TIME_LIMIT");
                    String string8 = "EXACT TIMER(" + string7 + ")";
                    stringBuffer.append("\n").append(SyntaxUtil.getSingleValueSubCommand("METHOD", string8, false));
                } else {
                    String string9 = "EXACT TIMER(0)";
                    stringBuffer.append("\n").append(SyntaxUtil.getSingleValueSubCommand("METHOD", string9, false));
                }
            }
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax().toString());
        return stringBuffer.toString();
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putMap(this.mTargetGroupVarList.getIdentifier(), this.mGroupFormatter.getVarMapForSerialization());
        this.getDialogDataModel().putBoolean("RANGE_SELECTED", this.mRangeSelected);
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mGroupFormatter.setVarMap(this.getDialogDataModel().getMap(this.mTargetGroupVarList.getIdentifier()));
        this.mSrcVarList.setSelectedIndex(0);
        if (this.getDialogDataModel().getBoolean("RANGE_SELECTED") != null) {
            this.mRangeSelected = this.getDialogDataModel().getBoolean("RANGE_SELECTED");
        }
        this.enableDisableOkPaste();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(new GridBagLayout());
        int n = 23;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_KINDEPENDENT_SOURCE_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, this.mScrollPane, gridBagConstraints, 0, 1, 1, 3, n, null);
        JPanel jPanel2 = this.setupListPanel();
        n = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 2, n, null);
        JPanel jPanel3 = this.setupGroupingVarListPanel();
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 2, 1, 1, n, null);
        JPanel jPanel4 = this.setupButtonPanel();
        gridBagConstraints.anchor = 15;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 4, 2, 1, n, null);
        this.setDefaults();
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        ToggleButtonAction toggleButtonAction;
        JPanel jPanel = super.setupOptionsButtonPanel();
        if (LicenseManager.getLicenseManager().getStatus(LicenseOption.CYTEL) == LicenseManager.Status.VALID) {
            toggleButtonAction = new ToggleButtonAction(EXACT_BUTTON_KEY){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    KIndependentSampleDlg.this.runExactSubDialog();
                }
            };
            this.mExact = new JButton(toggleButtonAction);
            this.addOptionsPanelButton(jPanel, this.mExact);
        } else {
            this.mExact = new JButton();
        }
        toggleButtonAction = new ToggleButtonAction(OPTIONS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KIndependentSampleDlg.this.runStatisticSubDialog();
            }
        };
        this.mStatistic = new JButton();
        this.mStatistic.setAction(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mStatistic);
        return jPanel;
    }

    void runExactSubDialog() {
        this.runSubDialog(new NonParametricTestsExact(this));
    }

    void runStatisticSubDialog() {
        this.runSubDialog(new NonParametricTestsOptions((BaseProcedureDialog)this, this.getResString("IDS_KINDEPENDENT_OPTIONS_TITLE"), "IDH_NTKI_OPT"));
    }

    void runRangeSubDialog() {
        this.runSubDialog(new AnalyzeDefineRange(this, this.getResString("IDS_ANALYZE_NONPARA_KINDEPENDENT_RANGE_TITLE"), "IDH_NTKI_GROUP", -999, 9999, true, false, false));
        if (this.getDialogDataModel().getString("IDS_DEFINE_RANGE_MINIMUM") != null || this.getDialogDataModel().getString("IDS_DEFINE_RANGE_MAXIMUM") != null) {
            this.mRangeSelected = true;
            String string = this.getDialogDataModel().getString("IDS_DEFINE_RANGE_MINIMUM");
            String string2 = this.getDialogDataModel().getString("IDS_DEFINE_RANGE_MAXIMUM");
            String string3 = "(" + string + " " + string2 + ")";
            ((KIndependentSampleGroupListModel)this.mTargetGroupVarList.getModel()).setElementPropertyAt(0, string3);
        } else {
            this.mRangeSelected = false;
        }
        this.enableDisableOkPaste();
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList();
        this.mSrcVarList.setIdentifier("SRC_VAR_LIST_K_IND");
        this.mSrcVarList.addFocusListener(this);
        this.mTargetTestVarList = new TargetVariableList();
        this.mTargetTestVarList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mTargetTestVarList.setIdentifier("TARGET_LIST_K_IND");
        this.mTargetTestVarList.setMaxLimitOfList(15999);
        this.mTargetGroupVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTargetGroupVarList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mTargetGroupVarList.setIdentifier("TARGET_GROUP_K_IND");
        this.mTargetTestVarList.getModel().addListDataListener(this);
        this.mTargetTestVarList.addFocusListener(this);
        this.mTargetGroupVarList.getModel().addListDataListener(this);
        this.mTargetGroupVarList.addFocusListener(this);
        this.mGroupFormatter = new KIndependentSamplesSpssVarFormatter(this.mTargetGroupVarList);
        this.mGroupModel = new KIndependentSampleGroupListModel(this.mGroupFormatter);
        this.mTargetGroupVarList.setModel(this.mGroupModel);
        this.mGroupModel.addListDataListener(this);
        this.mTargetGroupVarList.setCellRenderer(new CustomVarListCellRenderer(this.mGroupFormatter));
        this.mRange = new JButton();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, RANGE_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KIndependentSampleDlg.this.runRangeSubDialog();
            }
        };
        this.mRange = new JButton();
        this.mRange.setAction(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, KRUSKAL_CHECK);
        this.mKruskal = new JCheckBox();
        this.mKruskal.setAction(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, MEDIAN_CHECK);
        this.mMedian = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, JONCKH_CHECK);
        this.mJonckheere = new JCheckBox();
        this.mJonckheere.setAction(toggleButtonAction);
        this.mKruskal.addItemListener(this);
        this.mMedian.addItemListener(this);
        this.mJonckheere.addItemListener(this);
        this.mScrollPane = new JScrollPane(this.mSrcVarList);
        this.mArrowButtonForTestVar = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButtonForGroupVar = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
    }

    private JPanel setupButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = this.setupCheckBoxPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, -1);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupCheckBoxPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mKruskal, this.mJonckheere, this.mMedian};
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mKruskal);
        spssButtonGroup.add(this.mJonckheere);
        spssButtonGroup.add(this.mMedian);
        return PanelFactory.getGridPanel(jComponentArray, this.getResString("IDS_ANALYZE_NONPARA_KINDEPENDENT_TESTTYPE_BORDER_TITLE"), 2);
    }

    private JPanel setupListPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButtonForTestVar, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_KINDEPENDENT_TEST_VARIABLE_LIST_LABEL");
        jLabel.setLabelFor(this.mTargetTestVarList);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mScrollPane = new JScrollPane(this.mTargetTestVarList);
        this.mTargetTestVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetTestVarList.getFixedCellHeight() * 5 + 2));
        this.mScrollPane.setPreferredSize(this.mTargetTestVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, this.mScrollPane, gridBagConstraints, 1, 1, 1, 1, n, null);
        this.mArrowButtonForTestVar.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButtonForTestVar.registerVariableList(this.mTargetTestVarList, SpssArrowButton.ButtonOrientation.left);
        return jPanel;
    }

    private JPanel setupGroupingVarListPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        Insets insets2 = new Insets(0, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mArrowButtonForGroupVar, gridBagConstraints, 0, 0, 1, 2, n, insets2);
        int n2 = DialogUtil.getComponentGroupGap();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_KINDEPENDENT_GROUPING_LABEL");
        jLabel.setLabelFor(this.mTargetGroupVarList);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        insets2.set(n2, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        this.mTargetGroupVarList.setDragType(VariableList.VarMoveType.eDoNothing);
        this.mScrollPane = new JScrollPane(this.mTargetGroupVarList);
        this.mScrollPane.setHorizontalScrollBarPolicy(31);
        this.mScrollPane.setVerticalScrollBarPolicy(21);
        this.mScrollPane.setPreferredSize(this.mTargetGroupVarList.getMinimumSize());
        insets2.set(0, insets.left, 0, 0);
        n = 20;
        DialogUtil.addUsingGBL(jPanel, this.mScrollPane, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        this.mArrowButtonForGroupVar.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButtonForGroupVar.registerVariableList(this.mTargetGroupVarList, SpssArrowButton.ButtonOrientation.left);
        gridBagConstraints.fill = 0;
        n = 21;
        insets2.set(DialogUtil.getGroupBoxInnerMargin(), insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mRange, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButtonForTestVar);
        vector.add(this.mArrowButtonForGroupVar);
        vector.add(this.mTargetTestVarList);
        vector.add(this.mTargetGroupVarList);
        vector.add(this.mRange);
        vector.add(this.mKruskal);
        vector.add(this.mJonckheere);
        vector.add(this.mMedian);
        if (LicenseManager.getLicenseManager().getStatus(LicenseOption.CYTEL) == LicenseManager.Status.VALID) {
            vector.add(this.mExact);
        }
        vector.add(this.mStatistic);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setDefaults() {
        SpssVarFilter spssVarFilter = new SpssVarFilter(8, true, false);
        this.mSrcVarList.addVarFilter(spssVarFilter);
        this.mSrcVarList.loadFromActiveDataset();
        this.mKruskal.setSelected(true);
        this.mJonckheere.setSelected(false);
        this.mMedian.setSelected(false);
        this.mRange.setEnabled(false);
        this.mSrcVarList.setSelectedIndex(0);
        if (LicenseManager.getLicenseManager().getStatus(LicenseOption.CYTEL) == LicenseManager.Status.VALID) {
            this.mJonckheere.setEnabled(true);
        } else {
            this.mJonckheere.setEnabled(false);
        }
    }

    private void enableDisableOkPaste() {
        boolean bl = this.mKruskal.isSelected() || this.mMedian.isSelected() || this.mJonckheere.isSelected();
        this.enableOkPaste(this.mRangeSelected && this.mTargetGroupVarList.getModel().getSize() > 0 && this.mTargetTestVarList.getModel().getSize() > 0 && bl);
    }

    private class KIndependentSamplesSpssVarFormatter
    extends SpssVarFormatter {
        public KIndependentSamplesSpssVarFormatter(TargetVariableList targetVariableList) {
            super(targetVariableList);
        }

        @Override
        public String getDisplayText(ISpssVariable iSpssVariable) {
            return iSpssVariable.getName() + this.getVarMap().get(iSpssVariable.getId().asInt());
        }
    }

    private class KIndependentSampleGroupListModel
    extends CustomVarListModel {
        public KIndependentSampleGroupListModel(SpssVarFormatter spssVarFormatter) {
            super(spssVarFormatter);
        }

        @Override
        public boolean insertElementAt(ISpssVariable iSpssVariable, int n) {
            this.mVarFormatter.getVarMap().put(iSpssVariable.getId().asInt(), "(? ?)");
            return super.insertElementAt(iSpssVariable, n);
        }

        @Override
        public boolean addElement(ISpssVariable iSpssVariable) {
            this.mVarFormatter.getVarMap().put(iSpssVariable.getId().asInt(), "(? ?)");
            return super.addElement(iSpssVariable);
        }

        public void setElementPropertyAt(int n, String string) {
            if (n < 0 || n >= this.mVariables.size()) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            ISpssVariable iSpssVariable = this.getElementAt(n);
            this.mVarFormatter.getVarMap().put(iSpssVariable.getId().asInt(), string);
            this.fireContentsChanged(iSpssVariable, n, n);
        }

        @Override
        public void fireContentsChanged(Object object, int n, int n2) {
            super.fireContentsChanged(object, n, n2);
        }
    }
}

