/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.nonparametric_tests;

import com.spss.java_client.core.common.LicenseOption;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.license.LicenseManager;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.BasicACREvent;
import com.spss.java_client.ui.controls.BasicACRWidget;
import com.spss.java_client.ui.controls.IBasicACRListener;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.WidgetListNumericCellRenderer;
import com.spss.java_client.ui.dialogs.base.analyze.nonparametric_tests.NonParametricTestsExact;
import com.spss.java_client.ui.dialogs.base.analyze.nonparametric_tests.NonParametricTestsOptions;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ChiSquareDlg
extends BaseProcedureDialog
implements ListDataListener,
FocusListener,
IBasicACRListener,
DocumentListener,
ItemListener {
    static final int MAX_LIMIT = 48000;
    private static final String ACR_WIDGET_CMD_ACTION = "ACR_WIDGET_CMD_ACTION";
    private static final int LOWER_MIN_VAL = -999;
    private static final int UPPER_MAX_VAL = 9999;
    private static final double VALUES_MIN_VAL = 1.0E-4;
    private static final double VALUES_MAX_VAL = 99999.0;
    private static final int VALUES_PRECISION_VAL = 4;
    private static final int LIST_BOX_LIMIT = 200;
    private SrcVariableList mSrcVarList;
    private JScrollPane mSrcScrollPane;
    private JLabel mTestVarLabel;
    private TargetVariableList mTargetVarList;
    private JScrollPane mTargetScrollPane;
    private ArrowButton mTestVarListArrowButton;
    private JRadioButton mGetFromDataRadio;
    private JRadioButton mUseSpecifiedRangeRadio;
    private SpssButtonGroup mExpectedRangeButtonGrp;
    private JLabel mLowerLabel;
    private IntTextField mLowerTextField;
    private JLabel mUpperLabel;
    private IntTextField mUpperTextField;
    private JRadioButton mAllCategoriesEqualRadio;
    private JRadioButton mValuesRadio;
    private SpssButtonGroup mExpectedValuesButtonGrp;
    private FloatTextField mValuesTextField;
    private BasicACRWidget mACRWidget;
    private JButton mOptionsButton;
    private JButton mExactButton;
    private GridBagConstraints mGridConstraints;

    public ChiSquareDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.getResString("IDS_CHI_SQUARE_TITLE"));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_ntch";
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("NPAR TESTS"));
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/CHISQUARE="));
        stringBuffer.append(this.mTargetVarList.getVariablesStringList());
        if (dialogDataModel.getBoolean("IDS_CHI_SQUARE_USE_SPECIFIED_RANGE") != null && dialogDataModel.getBoolean("IDS_CHI_SQUARE_USE_SPECIFIED_RANGE").booleanValue()) {
            stringBuffer.append(" (" + dialogDataModel.getString("IDS_CHI_SQUARE_LOWER") + ",");
            stringBuffer.append(dialogDataModel.getString("IDS_CHI_SQUARE_UPPER") + ")");
        }
        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/EXPECTED="));
        if (dialogDataModel.getBoolean("IDS_CHI_SQUARE_ALL_CATEGORIES_EQUAL") != null && dialogDataModel.getBoolean("IDS_CHI_SQUARE_ALL_CATEGORIES_EQUAL").booleanValue()) {
            stringBuffer.append("EQUAL\n");
        } else if (dialogDataModel.getBoolean("IDS_CHI_SQUARE_VALUES") != null && dialogDataModel.getBoolean("IDS_CHI_SQUARE_VALUES").booleanValue()) {
            stringBuffer.append(this.getListItems() + "\n");
        }
        if (dialogDataModel.getBoolean("IDS_NTO_DESCRIPTIVE") != null && dialogDataModel.getBoolean("IDS_NTO_DESCRIPTIVE").booleanValue() && dialogDataModel.getBoolean("IDS_NTO_QUARTILES") != null && dialogDataModel.getBoolean("IDS_NTO_QUARTILES").booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/STATISTICS ") + "DESCRIPTIVES" + " " + "QUARTILES" + "\n");
        } else if (dialogDataModel.getBoolean("IDS_NTO_DESCRIPTIVE") != null && dialogDataModel.getBoolean("IDS_NTO_DESCRIPTIVE").booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/STATISTICS ") + "DESCRIPTIVES" + "\n");
        } else if (dialogDataModel.getBoolean("IDS_NTO_QUARTILES") != null && dialogDataModel.getBoolean("IDS_NTO_QUARTILES").booleanValue()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/STATISTICS ") + "QUARTILES" + "\n");
        }
        stringBuffer.append(SyntaxUtil.getSubCommand("/MISSING "));
        if (dialogDataModel.getBoolean("IDS_NTO_TEST_BY_TEST") == null || dialogDataModel.getBoolean("IDS_NTO_TEST_BY_TEST") != null && dialogDataModel.getBoolean("IDS_NTO_TEST_BY_TEST").booleanValue()) {
            stringBuffer.append("ANALYSIS");
        } else if (dialogDataModel.getBoolean("IDS_NTO_LISTWISE") != null && dialogDataModel.getBoolean("IDS_NTO_LISTWISE").booleanValue()) {
            stringBuffer.append("LISTWISE");
        }
        if (dialogDataModel.getBoolean("IDS_NTO_EXACT_EXACT") != null && dialogDataModel.getBoolean("IDS_NTO_EXACT_EXACT").booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/METHOD=EXACT "));
            stringBuffer.append("TIMER");
            if (dialogDataModel.getBoolean("IDS_NTO_EXACT_TIMELIMIT") != null && !dialogDataModel.getBoolean("IDS_NTO_EXACT_TIMELIMIT").booleanValue()) {
                stringBuffer.append("(0)");
            } else if (dialogDataModel.getBoolean("IDS_NTO_EXACT_TIMELIMIT") != null && dialogDataModel.getBoolean("IDS_NTO_EXACT_TIMELIMIT").booleanValue()) {
                stringBuffer.append("(");
                stringBuffer.append(dialogDataModel.getString("IDS_NTO_TIME_LIMIT"));
                stringBuffer.append(")");
            }
        } else if (dialogDataModel.getBoolean("IDS_NTO_EXACT_MONTECARLO") != null && dialogDataModel.getBoolean("IDS_NTO_EXACT_MONTECARLO").booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/METHOD=MC "));
            stringBuffer.append("CIN(");
            stringBuffer.append(dialogDataModel.getString("IDS_NTO_EXACT_PERCENTAGE") + ") ");
            stringBuffer.append("SAMPLES(");
            stringBuffer.append(dialogDataModel.getString("IDS_NTO_EXACT_NUMBER_OF_SAMPLES") + ")");
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetVarList.removeAll();
        this.mLowerTextField.setText("");
        this.mUpperTextField.setText("");
        this.mValuesTextField.setText("");
        this.setDefaults();
        this.mACRWidget.clearListModel();
        this.enableOkPaste(false);
    }

    @Override
    public String getIActionKey() {
        return "analyze_nonparam_tests_chi_square";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public boolean okPastePressed() {
        if (this.mUseSpecifiedRangeRadio.isSelected() && Float.parseFloat(this.mLowerTextField.getText()) >= Float.parseFloat(this.mUpperTextField.getText())) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_CHI_SQUARE_ERR_MESSAGE_ASSOCIATED_TEXTVAL_SMALLER"), VersionInfo.getAppVersionString());
            this.mLowerTextField.requestFocus();
            this.mLowerTextField.selectAll();
            return false;
        }
        if (this.mValuesRadio.isSelected() && this.mValuesTextField.getText().length() > 0) {
            if (0 == SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_CHI_SQUARE_ERR_MESSAGE_PENDING_OPERATIONS_WILL_BE_LOST"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) {
                return super.okPastePressed();
            }
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mGetFromDataRadio) {
            this.mLowerLabel.setEnabled(false);
            this.mUpperLabel.setEnabled(false);
            this.mLowerTextField.setEnabled(false);
            this.mLowerTextField.setOpaque(false);
            this.mUpperTextField.setEnabled(false);
            this.mUpperTextField.setOpaque(false);
            this.enableOkPaste(this.canEnableOkPaste());
        } else if (object == this.mUseSpecifiedRangeRadio) {
            this.mLowerLabel.setEnabled(true);
            this.mUpperLabel.setEnabled(true);
            this.mLowerTextField.setEnabled(true);
            this.mLowerTextField.setOpaque(true);
            this.mUpperTextField.setEnabled(true);
            this.mUpperTextField.setOpaque(true);
            this.enableOkPaste(this.canEnableOkPaste());
        }
        if (object == this.mAllCategoriesEqualRadio) {
            this.mValuesTextField.setEnabled(false);
            this.mValuesTextField.setOpaque(false);
            this.mACRWidget.getList().setEnabled(false);
            this.stateOfACRButtons(false, false, false);
            this.enableOkPaste(this.canEnableOkPaste());
            this.mACRWidget.enableListScrollPane(false);
        } else if (object == this.mValuesRadio) {
            this.mValuesTextField.setEnabled(true);
            this.mValuesTextField.setOpaque(true);
            this.mACRWidget.getList().setEnabled(true);
            this.enableOkPaste(this.canEnableOkPaste());
            this.mACRWidget.enableListScrollPane(true);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mLowerTextField)) {
            this.mLowerTextField.selectAll();
        } else if (focusEvent.getSource().equals(this.mUpperTextField)) {
            this.mUpperTextField.selectAll();
        } else if (focusEvent.getSource().equals(this.mValuesTextField)) {
            this.mValuesTextField.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.mLowerTextField.getText().length() > 0 && this.mUpperTextField.getText().length() > 0 && this.mTargetVarList.getModel().getSize() > 0 && this.mAllCategoriesEqualRadio.isSelected()) {
            this.enableOkPaste(true);
        } else if (this.mLowerTextField.getText().length() > 0 && this.mUpperTextField.getText().length() > 0 && this.mTargetVarList.getModel().getSize() > 0 && this.mValuesRadio.isSelected() && this.mACRWidget.getListItemCount() >= 2) {
            this.enableOkPaste(true);
        }
        if (this.mValuesTextField.getText().length() > 0) {
            this.enableOkPaste(this.canEnableOkPaste());
            this.stateOfACRButtons(true, false, false);
        }
        if (this.mACRWidget.getListSelectedIndex() != -1 && this.mValuesTextField.hasFocus()) {
            this.stateOfACRButtons(true, true, false);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.mUseSpecifiedRangeRadio.isSelected() && (this.mLowerTextField.getText().length() == 0 || this.mUpperTextField.getText().length() == 0)) {
            this.enableOkPaste(false);
        }
        if (this.mValuesRadio.isSelected() && this.mValuesTextField.getText().length() == 0) {
            this.enableOkPaste(this.canEnableOkPaste());
            this.stateOfACRButtons(false, false, false);
        }
        if (this.mACRWidget.getListSelectedIndex() != -1 && this.mValuesTextField.hasFocus() && this.mValuesTextField.getText().length() > 0) {
            this.stateOfACRButtons(true, true, false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void acrEventOccured(BasicACREvent basicACREvent) {
        int n;
        BasicACREvent.EventType eventType = basicACREvent.getEventType();
        if (eventType.equals((Object)BasicACREvent.EventType.addButtonPress)) {
            this.stateOfACRButtons(false, false, false);
            n = this.mACRWidget.getListItemCount();
            this.enableOkPaste(this.canEnableOkPaste());
            if (n == 200) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_CHI_SQUARE_ERR_MESSAGE_LIST_BOX_FULL"), VersionInfo.getAppVersionString());
                this.mACRWidget.setAddEnabled(true);
                this.mACRWidget.getList().requestFocus();
            } else {
                this.mACRWidget.addListItemAt(n, this.mValuesTextField.getText());
                this.mValuesTextField.setText("");
                this.mACRWidget.getList().requestFocus();
                this.mACRWidget.getList().clearSelection();
            }
        }
        if (eventType.equals((Object)BasicACREvent.EventType.listGotFocus)) {
            if (this.mACRWidget.getListSelectedIndex() != -1) {
                this.mValuesTextField.setText(this.mACRWidget.getListItemAt(this.mACRWidget.getListSelectedIndex()).toString());
                this.mACRWidget.setAddEnabled(false);
                this.mACRWidget.setRemoveEnabled(true);
            } else {
                this.mACRWidget.setRemoveEnabled(false);
            }
        }
        if (eventType.equals((Object)BasicACREvent.EventType.listItemAdd)) {
            this.enableOkPaste(this.canEnableOkPaste());
        }
        if (eventType.equals((Object)BasicACREvent.EventType.listItemRemove)) {
            this.enableOkPaste(this.canEnableOkPaste());
        }
        if (eventType.equals((Object)BasicACREvent.EventType.removeButtonPress)) {
            this.mACRWidget.removeListItemAt(this.mACRWidget.getListSelectedIndex());
            this.mValuesTextField.setText("");
            this.mValuesTextField.requestFocus();
            this.mACRWidget.setRemoveEnabled(false);
        }
        if (eventType.equals((Object)BasicACREvent.EventType.listSelectionValueChange)) {
            if (this.mACRWidget.getListSelectedIndex() != -1) {
                this.mValuesTextField.setText(this.mACRWidget.getListItemAt(this.mACRWidget.getListSelectedIndex()).toString());
                this.mACRWidget.setRemoveEnabled(true);
            } else {
                this.mACRWidget.setRemoveEnabled(false);
            }
            this.mACRWidget.setAddEnabled(false);
            this.mACRWidget.setChangeEnabled(false);
            this.enableOkPaste(this.canEnableOkPaste());
        }
        if (eventType.equals((Object)BasicACREvent.EventType.changeButtonPress)) {
            this.stateOfACRButtons(false, false, false);
            n = this.mACRWidget.getListSelectedIndex();
            if (n != -1) {
                this.mACRWidget.addListItemAt(n, this.mValuesTextField.getText());
                this.mACRWidget.removeListItemAt(n + 1);
            }
            this.mValuesTextField.setText("");
            this.mExactButton.requestFocus();
            this.mACRWidget.getList().clearSelection();
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupMainPanel(jPanel);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChiSquareDlg.this.runSubDialog(new NonParametricTestsOptions((BaseProcedureDialog)ChiSquareDlg.this, ChiSquareDlg.this.getResString("IDS_CHI_SQUARE_OPTIONS_TITLE"), "idh_ntch_opt"));
            }
        };
        this.mOptionsButton = new JButton(toggleButtonAction);
        if (LicenseManager.getLicenseManager().getStatus(LicenseOption.CYTEL) == LicenseManager.Status.VALID) {
            ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction("IDS_COMMON_EXACT_BUTTON"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ChiSquareDlg.this.runSubDialog(new NonParametricTestsExact(ChiSquareDlg.this));
                }
            };
            this.mExactButton = new JButton(toggleButtonAction2);
            this.addOptionsPanelButton(jPanel, this.mExactButton);
        } else {
            this.mExactButton = new JButton();
        }
        this.addOptionsPanelButton(jPanel, this.mOptionsButton);
        DialogUtil.normalizeButtonWidths((JPanel)jPanel);
        return jPanel;
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        if (this.mUseSpecifiedRangeRadio.isSelected()) {
            this.mLowerLabel.setEnabled(true);
            this.mUpperLabel.setEnabled(true);
            this.mLowerTextField.setEnabled(true);
            this.mLowerTextField.setOpaque(true);
            this.mUpperTextField.setEnabled(true);
            this.mUpperTextField.setOpaque(true);
        }
        if (this.mValuesRadio.isSelected()) {
            this.mValuesTextField.setEnabled(true);
            this.mValuesTextField.setOpaque(true);
        } else if (this.mAllCategoriesEqualRadio.isSelected()) {
            this.stateOfACRButtons(false, false, false);
            this.mACRWidget.setEnabled(false);
            this.mACRWidget.getList().setEnabled(false);
        }
        this.mSrcVarList.setSelectedIndex(0);
    }

    private void setupMainPanel(JPanel jPanel) {
        JPanel jPanel2 = this.setupExpectedRangePanel();
        JPanel jPanel3 = this.setupExpectedValuePanel();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getArrowButtonInsets();
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 0;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_CHI_SQUARE_SRCLIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, this.mGridConstraints, 0, 0, 1, 1, n, null);
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 1.0;
        this.mGridConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, this.mGridConstraints, 0, 1, 1, 1, n, null);
        this.mGridConstraints.fill = 0;
        this.mGridConstraints.weightx = 0.0;
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTestVarListArrowButton, this.mGridConstraints, 1, 1, 1, 1, 10, insets2);
        insets2.set(0, insets.left, 0, 0);
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mTestVarLabel, this.mGridConstraints, 2, 0, 1, 1, n, insets2);
        this.mGridConstraints.weighty = 1.0;
        this.mGridConstraints.fill = 1;
        insets2.set(0, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTargetScrollPane, this.mGridConstraints, 2, 1, 1, 1, n, insets2);
        this.mGridConstraints.weightx = 0.0;
        insets2.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mGridConstraints, 0, 2, 1, 1, n, insets2);
        insets2.set(n2, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, this.mGridConstraints, 2, 2, 1, 1, n, insets2);
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList();
        this.mSrcVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mSrcVarList.setIdentifier("SourceListIdentifier");
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mSrcVarList.getModel().addListDataListener(this);
        this.mSrcVarList.addFocusListener(this);
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetVarList.setIdentifier("TargetListIdentifier");
        this.mTargetScrollPane = new JScrollPane(this.mTargetVarList);
        this.mTargetScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mTargetVarList.setMaxLimitOfList(48000);
        this.mTestVarListArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mTestVarListArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mTestVarListArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mTestVarLabel = DialogUtil.createLabel(this, "IDS_CHI_SQUARE_TEST_VARIABLE_LIST");
        this.mTestVarLabel.setLabelFor(this.mTargetVarList);
        ControlAction controlAction = new ToggleButtonAction(this, "IDS_CHI_SQUARE_GET_FROM_DATA");
        this.mGetFromDataRadio = new JRadioButton(controlAction);
        this.mGetFromDataRadio.addItemListener(this);
        controlAction = new ToggleButtonAction(this, "IDS_CHI_SQUARE_USE_SPECIFIED_RANGE");
        this.mUseSpecifiedRangeRadio = new JRadioButton(controlAction);
        this.mUseSpecifiedRangeRadio.addItemListener(this);
        this.mExpectedRangeButtonGrp = new SpssButtonGroup();
        this.mExpectedRangeButtonGrp.add(this.mGetFromDataRadio);
        this.mExpectedRangeButtonGrp.add(this.mUseSpecifiedRangeRadio);
        this.mLowerTextField = new IntTextField(-999, 9999, false);
        this.mLowerTextField.setColumns(3);
        this.mLowerLabel = DialogUtil.createLabel(this, "IDS_CHI_SQUARE_LOWER");
        this.mLowerLabel.setLabelFor((Component)this.mLowerTextField);
        controlAction = new TextFieldAction(this, "IDS_CHI_SQUARE_LOWER");
        this.mLowerTextField.setAction((Action)controlAction);
        this.mLowerTextField.getDocument().addDocumentListener(this);
        this.mLowerTextField.addFocusListener((FocusListener)this);
        this.mUpperTextField = new IntTextField(-999, 9999, false);
        this.mUpperTextField.setColumns(3);
        this.mUpperLabel = DialogUtil.createLabel(this, "IDS_CHI_SQUARE_UPPER");
        this.mUpperLabel.setLabelFor((Component)this.mUpperTextField);
        controlAction = new TextFieldAction(this, "IDS_CHI_SQUARE_UPPER");
        this.mUpperTextField.setAction((Action)controlAction);
        this.mUpperTextField.getDocument().addDocumentListener(this);
        this.mUpperTextField.addFocusListener((FocusListener)this);
        controlAction = new ToggleButtonAction(this, "IDS_CHI_SQUARE_ALL_CATEGORIES_EQUAL");
        this.mAllCategoriesEqualRadio = new JRadioButton(controlAction);
        this.mAllCategoriesEqualRadio.addItemListener(this);
        controlAction = new ToggleButtonAction(this, "IDS_CHI_SQUARE_VALUES");
        this.mValuesRadio = new JRadioButton(controlAction);
        this.mValuesRadio.addItemListener(this);
        this.mExpectedValuesButtonGrp = new SpssButtonGroup();
        this.mExpectedValuesButtonGrp.add(this.mAllCategoriesEqualRadio);
        this.mExpectedValuesButtonGrp.add(this.mValuesRadio);
        this.mValuesTextField = new FloatTextField(1.0E-4, 99999.0, 4, true);
        this.mValuesTextField.getDocument().addDocumentListener(this);
        this.mValuesTextField.addFocusListener((FocusListener)this);
        this.mACRWidget = new BasicACRWidget(ACR_WIDGET_CMD_ACTION);
        this.mACRWidget.setAllowDuplicates(true);
        this.mACRWidget.setSerializable(true);
        this.mACRWidget.getList().setFocusable(true);
        this.mACRWidget.getList().setCellRenderer(new WidgetListNumericCellRenderer());
        this.mACRWidget.addBasicACRListener(this);
        this.mACRWidget.setRemoveMnemonic(69);
        this.mGridConstraints = new GridBagConstraints();
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.mGetFromDataRadio.setSelected(true);
        this.mAllCategoriesEqualRadio.setSelected(true);
        this.mLowerLabel.setEnabled(false);
        this.mUpperLabel.setEnabled(false);
        this.mLowerTextField.setEnabled(false);
        this.mLowerTextField.setOpaque(false);
        this.mUpperTextField.setEnabled(false);
        this.mUpperTextField.setOpaque(false);
        this.mValuesTextField.setEnabled(false);
        this.mValuesTextField.setOpaque(false);
    }

    private JPanel setupExpectedRangePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_CHI_SQUARE_EXPECTED_RANGE_TITLE")));
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 2;
        Insets insets2 = new Insets(insets.top, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mGetFromDataRadio, this.mGridConstraints, 0, 0, 2, 1, n, insets2);
        insets2.set(insets.top, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mUseSpecifiedRangeRadio, this.mGridConstraints, 0, 1, 2, 1, n, insets2);
        this.mGridConstraints.weightx = 0.0;
        insets2.set(insets.bottom, n2 * 5, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mLowerLabel, this.mGridConstraints, 0, 2, 1, 1, n, insets2);
        this.mGridConstraints.fill = 0;
        insets2.set(insets.top, n2 * 4, insets.bottom, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mLowerTextField, this.mGridConstraints, 1, 2, 1, 1, n, insets2);
        this.mGridConstraints.weighty = 1.0;
        this.mGridConstraints.fill = 2;
        insets2.set(n2 + insets.bottom, n2 * 5, n2, 0);
        DialogUtil.addUsingGBL(jPanel, this.mUpperLabel, this.mGridConstraints, 0, 3, 1, 1, n, insets2);
        this.mGridConstraints.fill = 0;
        insets2.set(n2, n2 * 4, n2 + insets.bottom, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mUpperTextField, this.mGridConstraints, 1, 3, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupExpectedValuePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_CHI_SQUARE_EXPECTED_VALUES_TITLE")));
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 2;
        Insets insets2 = new Insets(insets.top, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mAllCategoriesEqualRadio, this.mGridConstraints, 0, 0, 2, 1, n, insets2);
        insets2.set(insets.top, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mValuesRadio, this.mGridConstraints, 0, 1, 1, 1, n, insets2);
        this.mGridConstraints.fill = 0;
        insets2.set(insets.left, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mValuesTextField, this.mGridConstraints, 1, 1, 1, 1, n, insets2);
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 1.0;
        this.mGridConstraints.fill = 1;
        insets2.set(n2, n2 * 5, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mACRWidget, this.mGridConstraints, 0, 2, 2, 1, n, insets2);
        return jPanel;
    }

    private String getListItems() {
        Object[] objectArray = this.mACRWidget.getListItems();
        String string = "";
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            string = string + objectArray[i].toString();
            if (i >= n - 1) continue;
            string = string + " ";
        }
        return string;
    }

    private boolean canEnableOkPaste() {
        if (this.mTargetVarList.getModel().getSize() > 0 && this.mGetFromDataRadio.isSelected() && this.mAllCategoriesEqualRadio.isSelected()) {
            return true;
        }
        if (this.mTargetVarList.getModel().getSize() > 0 && this.mUseSpecifiedRangeRadio.isSelected() && this.mLowerTextField.getText().length() > 0 && this.mUpperTextField.getText().length() > 0 && this.mAllCategoriesEqualRadio.isSelected()) {
            return true;
        }
        if (this.mTargetVarList.getModel().getSize() > 0 && this.mUseSpecifiedRangeRadio.isSelected() && this.mLowerTextField.getText().length() > 0 && this.mUpperTextField.getText().length() > 0 && this.mValuesRadio.isSelected() && this.mACRWidget.getListItemCount() >= 2) {
            return true;
        }
        return this.mTargetVarList.getModel().getSize() > 0 && this.mGetFromDataRadio.isSelected() && this.mValuesRadio.isSelected() && this.mACRWidget.getListItemCount() >= 2;
    }

    private void stateOfACRButtons(boolean bl, boolean bl2, boolean bl3) {
        this.mACRWidget.setAddEnabled(bl);
        this.mACRWidget.setChangeEnabled(bl2);
        this.mACRWidget.setRemoveEnabled(bl3);
    }

    private Vector<Object> setTabTraversal() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mTestVarListArrowButton);
        vector.add(this.mTargetVarList);
        vector.add(this.mExpectedRangeButtonGrp);
        vector.add(this.mLowerTextField);
        vector.add(this.mUpperTextField);
        vector.add(this.mExpectedValuesButtonGrp);
        vector.add(this.mValuesTextField);
        for (n = 0; n < this.mACRWidget.getComponentCount(); ++n) {
            if (this.mACRWidget.getComponent(n) instanceof JButton) {
                vector.add(this.mACRWidget.getComponent(n));
                continue;
            }
            if (!(this.mACRWidget.getComponent(n) instanceof JScrollPane)) continue;
            vector.add(this.mACRWidget.getList());
        }
        if (LicenseManager.getLicenseManager().getStatus(LicenseOption.CYTEL) == LicenseManager.Status.VALID) {
            vector.add(this.mExactButton);
        }
        vector.add(this.mOptionsButton);
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            if (!(this.mCmdButtonPanel.getComponent(n) instanceof JButton)) continue;
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        return vector;
    }
}

