/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.nonparametric_tests;

import com.spss.java_client.core.common.LicenseOption;
import com.spss.java_client.core.license.LicenseManager;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.nonparametric_tests.NonParametricTestsExact;
import com.spss.java_client.ui.dialogs.base.analyze.nonparametric_tests.NonParametricTestsOptions;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class BinomialDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener,
DocumentListener {
    static final int MAX_LIMIT_OF_LIST = 48000;
    static final String GET_FROM_DATA_KEY = "IDS_GET_FROM_DATA";
    static final String CUT_POINT_KEY = "IDS_CUT_POINT";
    static final String EXACT_BUTTON_KEY = "IDS_COMMON_EXACT_BUTTON";
    static final String OPTIONS_BUTTON_KEY = "IDS_COMMON_OPTIONS_3DOT";
    static final String TEST_PROPORTION = "IDS_BINOMIAL_TEST_PROPORTION";
    static final String BINOMIAL_TARGET_LIST = "IDS_BINOMIAL_TARGET_LIST";
    static final int TESTPROPORTION_COLUMN = 3;
    static final String TESTPROPORTION_TEXT = "0.50";
    static final int CUTPOINT_COLUMN = 4;
    static final String CUTPOINT_TEXT = "";
    static final double MIN_FLOAT_VALUE = 0.001;
    static final double MAX_FLOAT_VALUE = 0.999;
    static final int MIN_INT_VALUE = -9999;
    static final int MAX_INT_VALUE = 99999;
    static final int TESTPROPERTION_PRECISION = 3;
    static final int BINOMIAL_PRECISION = 4;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetVarList;
    private JScrollPane mSrcScrollPane;
    private JScrollPane mTargetScrollPane;
    private ArrowButton mArrowButton;
    private JRadioButton mGetFromDataRadio;
    private JRadioButton mCutPointRadio;
    private SpssButtonGroup mGroup;
    private FloatTextField mCutPointText;
    private FloatTextField mTestProportionText;
    private JButton mExactButton;
    private JButton mOptionsButton;

    public BinomialDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle.getDefaultResourceBundleName(), AnalyzeResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_BINOMIAL"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.enableCutPointText(this.mCutPointRadio.isSelected());
        this.enableOkPaste();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableOkPaste();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableCutPointText(this.mCutPointRadio.isSelected());
        this.enableOkPaste();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableOkPaste();
    }

    @Override
    public String generateSyntax() {
        String string;
        Boolean bl;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        stringBuffer.append(SyntaxUtil.getMainCommand("NPAR TESTS"));
        String string2 = this.mTargetVarList.getVariablesStringList();
        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/BINOMIAL") + " (" + this.mTestProportionText.getText() + ")=" + string2);
        if (this.mCutPointRadio.isSelected()) {
            stringBuffer.append(" (" + this.mCutPointText.getText() + ")");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_NTO_DESCRIPTIVE")) != null && bl.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/STATISTICS DESCRIPTIVES"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_NTO_QUARTILES")) != null && bl.booleanValue()) {
            if (stringBuffer.indexOf("STATISTICS") > 0) {
                stringBuffer.append(" QUARTILES ");
            } else {
                stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/STATISTICS QUARTILES "));
            }
        }
        stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/MISSING "));
        bl = dialogDataModel.getBoolean("IDS_NTO_TEST_BY_TEST");
        if (bl == null || bl.booleanValue()) {
            stringBuffer.append("ANALYSIS");
        } else {
            stringBuffer.append("LISTWISE");
        }
        bl = dialogDataModel.getBoolean("IDS_NTO_EXACT_MONTECARLO");
        if (bl != null && bl.booleanValue()) {
            string = dialogDataModel.getString("IDS_NTO_EXACT_PERCENTAGE");
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/METHOD=MC") + " CIN(" + string + ")");
            String string3 = dialogDataModel.getString("IDS_NTO_EXACT_NUMBER_OF_SAMPLES");
            stringBuffer.append(" SAMPLES(" + string3 + ")");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_NTO_EXACT_EXACT")) != null && bl.booleanValue()) {
            bl = dialogDataModel.getBoolean("IDS_NTO_EXACT_TIMELIMIT");
            if (bl != null && bl.booleanValue()) {
                string = dialogDataModel.getString("IDS_NTO_TIME_LIMIT");
                stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/METHOD=EXACT") + " TIMER(" + string + ")");
            } else {
                stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/METHOD=EXACT") + " TIMER(0)");
            }
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_ntbi";
    }

    @Override
    public final String getIActionKey() {
        return "analyze_nonparam_tests_binomial";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPaste();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        this.mExactButton = new JButton();
        if (LicenseManager.getLicenseManager().getStatus(LicenseOption.CYTEL) == LicenseManager.Status.VALID) {
            this.mExactButton.setAction(new ToggleButtonAction(EXACT_BUTTON_KEY){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BinomialDlg.this.runExactSubDialog();
                }
            });
            this.addOptionsPanelButton(jPanel, this.mExactButton);
        }
        this.mOptionsButton = new JButton();
        this.mOptionsButton.setAction(new ToggleButtonAction(OPTIONS_BUTTON_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BinomialDlg.this.runOptionsSubDialog();
            }
        });
        this.addOptionsPanelButton(jPanel, this.mOptionsButton);
        return jPanel;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupLists();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    protected void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetVarList.setMaxLimitOfList(48000);
        this.mTargetVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetScrollPane = new JScrollPane(this.mTargetVarList);
        this.mTargetScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mTargetVarList.setIdentifier(BINOMIAL_TARGET_LIST);
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mGroup = new SpssButtonGroup();
        ControlAction controlAction = new ToggleButtonAction(this, GET_FROM_DATA_KEY);
        this.mGetFromDataRadio = new JRadioButton(controlAction);
        this.mGroup.add(this.mGetFromDataRadio);
        controlAction = new ToggleButtonAction(this, CUT_POINT_KEY);
        this.mCutPointRadio = new JRadioButton(controlAction);
        this.mGroup.add(this.mCutPointRadio);
        controlAction = new TextFieldAction(this, CUT_POINT_KEY);
        this.mCutPointText = new FloatTextField(-9999.0, 99999.0, 4, false, true);
        this.mCutPointText.setAction((Action)controlAction);
        this.mCutPointText.setText(CUTPOINT_TEXT);
        this.mCutPointText.setColumns(4);
        this.mCutPointText.getDocument().addDocumentListener(this);
        this.mCutPointText.addFocusListener((FocusListener)new TextSelection());
        controlAction = new TextFieldAction(this, TEST_PROPORTION);
        this.mTestProportionText = new FloatTextField(0.001, 0.999, 3, true);
        this.mTestProportionText.setColumns(3);
        this.mTestProportionText.setText(TESTPROPORTION_TEXT);
        this.mTestProportionText.setAction((Action)controlAction);
        this.mTestProportionText.getDocument().addDocumentListener(this);
        this.mTestProportionText.addFocusListener((FocusListener)new TextSelection());
        this.mCutPointRadio.addItemListener(this);
        this.mGetFromDataRadio.addItemListener(this);
    }

    private JPanel setupLists() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_BINOMIAL_SOURCE_LIST_LABEL");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_BINOMIAL_TEST_VARIABLES_LIST");
        jLabel2.setLabelFor(this.mTargetVarList);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, null);
        n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mTargetScrollPane, gridBagConstraints, 2, 1, 2, 1, n, null);
        JPanel jPanel2 = this.setupDefineDichotomyPanel();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(n2, 0, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        insets2 = new Insets(n2, 0, 0, 0);
        JPanel jPanel3 = this.setupTestProportionPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 2, 2, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupDefineDichotomyPanel() {
        JPanel jPanel = new JPanel(true);
        int n = 23;
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_DEFINE_DICHOTOMY"));
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mGetFromDataRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mCutPointRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        Insets insets2 = new Insets(4, 0, 0, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mCutPointText, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupTestProportionPanel() {
        JPanel jPanel = new JPanel(true);
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_TEST_PROPORTION");
        jLabel.setLabelFor((Component)this.mTestProportionText);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        Insets insets = new Insets(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mTestProportionText, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private void runOptionsSubDialog() {
        this.runSubDialog(new NonParametricTestsOptions((BaseProcedureDialog)this, this.getResString("IDS_BINOMIAL_OPTIONS_TITLE"), "idh_ntbi_opt"));
    }

    private void runExactSubDialog() {
        this.runSubDialog(new NonParametricTestsExact(this));
    }

    private void enableOkPaste() {
        boolean bl = false;
        if (this.mTargetVarList.getModel().getSize() > 0 && this.mTestProportionText.getText().length() > 0) {
            bl = !this.mCutPointRadio.isSelected() || this.mCutPointText.getText().length() != 0;
        }
        if (this.mTestProportionText.getText().length() == 0) {
            bl = false;
        }
        if (this.mCutPointRadio.isSelected() && this.mCutPointText.getText().length() == 0) {
            bl = false;
        }
        super.enableOkPaste(bl);
    }

    private void enableCutPointText(boolean bl) {
        this.mCutPointText.setEnabled(bl);
        this.mCutPointText.setOpaque(bl);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetVarList);
        vector.add(this.mGroup);
        vector.add(this.mCutPointText);
        vector.add(this.mTestProportionText);
        if (LicenseManager.getLicenseManager().getStatus(LicenseOption.CYTEL) == LicenseManager.Status.VALID) {
            vector.add(this.mExactButton);
        }
        vector.add(this.mOptionsButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        super.setFocusTraversalPolicy((FocusTraversalPolicy)dialogFocusTraversalPolicy);
    }

    private void setDefaults() {
        this.mTargetVarList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
        this.mGetFromDataRadio.setSelected(true);
        this.mCutPointText.setText(CUTPOINT_TEXT);
        this.mCutPointText.setEnabled(false);
        this.mCutPointText.setOpaque(false);
        this.mTestProportionText.setText(TESTPROPORTION_TEXT);
    }

    class TextSelection
    extends FocusAdapter {
        TextSelection() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() == BinomialDlg.this.mTestProportionText) {
                BinomialDlg.this.mTestProportionText.setSelectionStart(0);
                BinomialDlg.this.mTestProportionText.setSelectionEnd(BinomialDlg.this.mTestProportionText.getText().length());
                BinomialDlg.this.mTestProportionText.requestFocus();
            } else if (focusEvent.getSource() == BinomialDlg.this.mCutPointText) {
                BinomialDlg.this.mCutPointText.setSelectionStart(0);
                BinomialDlg.this.mCutPointText.setSelectionEnd(BinomialDlg.this.mCutPointText.getText().length());
                BinomialDlg.this.mCutPointText.requestFocus();
            }
        }
    }
}

