/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.multiple_res.crosstabs;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ComponentsArrowButton;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.PlainListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.PlainListDropListener;
import com.spss.java_client.ui.dialogs.base.analyze.AnalyzeDefineRange;
import com.spss.java_client.ui.dialogs.base.analyze.multiple_res.IMRVariableSet;
import com.spss.java_client.ui.dialogs.base.analyze.multiple_res.MRVariableSet;
import com.spss.java_client.ui.dialogs.base.analyze.multiple_res.crosstabs.MRCrosstabsOptions;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IPlainListVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.util.CharacterUtil;
import com.spss.uitools.util.IOptionConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.URL;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MultiResCrossTabsDlg
extends BaseProcedureDialog
implements FocusListener,
ListDataListener,
ListSelectionListener,
ActionListener,
IPlainListVarMoveHandler {
    static final String IDS_OPTIONS_KEY = "IDS_MR_CROSSTABS_OPTIONS_3DOT";
    private static final String ROW_TARGET_VAR_LIST = "IDS_ROW_VAR_TARGET_LIST";
    private static final String COLUMN_TARGET_VAR_LIST = "IDS_COLUMN_VAR_TARGET_LIST";
    private static final String LAYER_TARGET_VAR_LIST = "IDS_LAYER_VAR_TARGET_LIST";
    private static final String MULT_RES_SET_LIST = "IDS_MULT_RES_SET_LIST";
    private SrcVariableList mSrcVarList;
    private PlainList mMultResSrcVarList;
    private PlainList mRowTargetVarList;
    private PlainList mColumnTargetVarList;
    private PlainList mLayerTargetVarList;
    private JScrollPane mSrcScrollPane;
    private JScrollPane mMultResSrcScrollPane;
    private JScrollPane mRowTargetScrollPane;
    private JScrollPane mColumnTargetScrollPane;
    private JScrollPane mLayerTargetScrollPane;
    private ComponentsArrowButton mRowArrowButton;
    private ComponentsArrowButton mColumnArrowButton;
    private ComponentsArrowButton mLayerArrowButton;
    private JButton mDefineRangeButton;
    private JLabel mRowLabel;
    private JLabel mColumnLabel;
    private JLabel mLayerLabel;
    private JLabel mMultResSetsLabel;
    private JButton mOptionsButton;
    private PlainList mCurrentTargetList;

    public MultiResCrossTabsDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle.getDefaultResourceBundleName(), AnalyzeResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_MR_CROSSTABS_TITLE"));
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
        this.loadMRVariableSets();
    }

    @Override
    public final String getIActionKey() {
        return "analyze_mult_resp_crosstabs";
    }

    @Override
    protected boolean okPastePressed() {
        boolean bl = super.okPastePressed();
        if (bl) {
            Vector<IMRVariableSet> vector = new Vector<IMRVariableSet>();
            Vector<TargetListData> vector2 = new Vector<TargetListData>();
            Vector<String> vector3 = new Vector<String>();
            this.fillLists(vector, vector2, vector3);
            int n = vector2.size();
            for (IMRVariableSet iMRVariableSet : vector) {
                n += iMRVariableSet.getVariableNames().size();
            }
            if (n > 100) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("IDS_MAX_VAR_WARNING"), VersionInfo.getAppVersionString());
                return false;
            }
        }
        return bl;
    }

    @Override
    public String generateSyntax() {
        Boolean bl;
        int n;
        int n2;
        String string2;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Vector<IMRVariableSet> vector = new Vector<IMRVariableSet>();
        Vector<TargetListData> vector2 = new Vector<TargetListData>();
        Vector<String> vector3 = new Vector<String>();
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("MULT RESPONSE"));
        this.fillLists(vector, vector2, vector3);
        if (vector.size() > 0) {
            stringBuffer.append(SyntaxUtil.getMainCommandParamters("GROUPS="));
            for (IMRVariableSet iMRVariableSet : vector) {
                stringBuffer.append("$").append(iMRVariableSet.getName(IMRVariableSet.ChangeCase.kNoChange)).append(" ");
                if (!iMRVariableSet.getLabel().trim().equals("")) {
                    stringBuffer.append(CharacterUtil.smartQuote((String)iMRVariableSet.getLabel())).append(" ");
                }
                Vector<String> vector4 = iMRVariableSet.getVariableNames(IMRVariableSet.ChangeCase.kNoChange);
                stringBuffer.append("(");
                for (String string2 : vector4) {
                    stringBuffer.append(string2).append(" ");
                }
                if (iMRVariableSet.getType() == IMRVariableSet.MRVariableSetType.kMR_Dichotomy) {
                    stringBuffer.append("(").append(iMRVariableSet.getValue()).append(")");
                }
                if (iMRVariableSet.getType() == IMRVariableSet.MRVariableSetType.kMR_Category) {
                    stringBuffer.append("(").append(iMRVariableSet.getRangeValue()).append(",").append(iMRVariableSet.getThroughValue()).append(")");
                }
                stringBuffer.append(")").append(" ");
            }
        }
        if ((n2 = vector2.size()) > 0) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/VARIABLES="));
            for (int i = 0; i < n2; ++i) {
                TargetListData targetListData = vector2.get(i);
                stringBuffer.append(targetListData.getSpssVar().getName()).append("(");
                stringBuffer.append(targetListData.getMinVal()).append(" ");
                stringBuffer.append(targetListData.getMaxVal()).append(")");
                stringBuffer.append(" ");
            }
        }
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/TABLES="));
        int n3 = 0;
        for (n = 0; n < ((DefaultListModel)this.mRowTargetVarList.getModel()).size(); ++n) {
            string2 = vector3.get(n3++);
            if (n == ((DefaultListModel)this.mRowTargetVarList.getModel()).size() - 1) {
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(string2).append(" ");
        }
        stringBuffer.append(" ").append("BY").append(" ");
        for (n = 0; n < ((DefaultListModel)this.mColumnTargetVarList.getModel()).size(); ++n) {
            string2 = vector3.get(n3++);
            if (n == ((DefaultListModel)this.mColumnTargetVarList.getModel()).size() - 1) {
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(string2).append(" ");
        }
        if (((DefaultListModel)this.mLayerTargetVarList.getModel()).size() > 0) {
            stringBuffer.append(" ").append("BY").append(" ");
            for (n = 0; n < ((DefaultListModel)this.mLayerTargetVarList.getModel()).size(); ++n) {
                string2 = vector3.get(n3++);
                if (n == ((DefaultListModel)this.mColumnTargetVarList.getModel()).size() - 1) {
                    stringBuffer.append(string2);
                    continue;
                }
                stringBuffer.append(string2).append(" ");
            }
        }
        if ((bl = dialogDataModel.getBoolean("IDS_MR_CROSSTABS_MATCH_VARIABLES")) != null && bl.booleanValue()) {
            stringBuffer.append(" ").append("(").append("PAIRED").append(")");
        }
        if ((dialogDataModel.getBoolean("IDS_MR_CROSSTABS_ROW") != null || dialogDataModel.getBoolean("IDS_MR_CROSSTABS_COLUMN") != null || dialogDataModel.getBoolean("IDS_MR_CROSSTABS_TOTAL") != null) && (dialogDataModel.getBoolean("IDS_MR_CROSSTABS_ROW").booleanValue() || dialogDataModel.getBoolean("IDS_MR_CROSSTABS_COLUMN").booleanValue() || dialogDataModel.getBoolean("IDS_MR_CROSSTABS_TOTAL").booleanValue())) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/CELLS="));
            bl = dialogDataModel.getBoolean("IDS_MR_CROSSTABS_ROW");
            if (bl != null && bl.booleanValue()) {
                stringBuffer.append("ROW").append(" ");
            }
            if ((bl = dialogDataModel.getBoolean("IDS_MR_CROSSTABS_COLUMN")) != null && bl.booleanValue()) {
                stringBuffer.append("COLUMN").append(" ");
            }
            if ((bl = dialogDataModel.getBoolean("IDS_MR_CROSSTABS_TOTAL")) != null && bl.booleanValue()) {
                stringBuffer.append("TOTAL");
            }
        }
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/BASE="));
        bl = dialogDataModel.getBoolean("IDS_MR_CROSSTABS_CASES");
        if (bl == null) {
            stringBuffer.append("CASES");
        }
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("CASES");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_MR_CROSSTABS_RESPONSES")) != null && bl.booleanValue()) {
            stringBuffer.append("RESPONSES");
        }
        if (dialogDataModel.getBoolean("IDS_MR_CROSSTABS_EXCLUDE_CASES_DICHOTOMIES") == null || dialogDataModel.getBoolean("IDS_MR_CROSSTABS_EXCLUDE_CASES_CATEGORIES") == null) {
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        if (!(dialogDataModel.getBoolean("IDS_MR_CROSSTABS_EXCLUDE_CASES_DICHOTOMIES") == null && dialogDataModel.getBoolean("IDS_MR_CROSSTABS_EXCLUDE_CASES_CATEGORIES") == null || dialogDataModel.getBoolean("IDS_MR_CROSSTABS_EXCLUDE_CASES_DICHOTOMIES").booleanValue() || dialogDataModel.getBoolean("IDS_MR_CROSSTABS_EXCLUDE_CASES_CATEGORIES").booleanValue())) {
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        if ((dialogDataModel.getBoolean("IDS_MR_CROSSTABS_EXCLUDE_CASES_DICHOTOMIES") != null || dialogDataModel.getBoolean("IDS_MR_CROSSTABS_EXCLUDE_CASES_CATEGORIES") != null) && (bl = Boolean.valueOf(dialogDataModel.getBoolean("IDS_MR_CROSSTABS_EXCLUDE_CASES_DICHOTOMIES") != false || dialogDataModel.getBoolean("IDS_MR_CROSSTABS_EXCLUDE_CASES_CATEGORIES") != false)).booleanValue()) {
            stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/MISSING="));
            if (dialogDataModel.getBoolean("IDS_MR_CROSSTABS_EXCLUDE_CASES_DICHOTOMIES").booleanValue()) {
                stringBuffer.append("MDGROUP");
            }
            if (dialogDataModel.getBoolean("IDS_MR_CROSSTABS_EXCLUDE_CASES_CATEGORIES").booleanValue()) {
                stringBuffer.append(" ").append("MRGROUP");
            }
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer.toString();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_mulc";
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mRowTargetVarList) {
            if (this.mRowTargetVarList.getModel().getSize() > 0 && this.mRowTargetVarList.getSelectedIndex() != -1) {
                this.defineRangeEnable(this.mRowTargetVarList);
            }
            this.stateOfArrowButton(this.mRowTargetVarList);
        } else if (focusEvent.getSource() == this.mColumnTargetVarList) {
            if (this.mColumnTargetVarList.getModel().getSize() > 0 && this.mColumnTargetVarList.getSelectedIndex() != -1) {
                this.defineRangeEnable(this.mColumnTargetVarList);
            }
            this.stateOfArrowButton(this.mColumnTargetVarList);
        } else if (focusEvent.getSource() == this.mLayerTargetVarList) {
            if (this.mLayerTargetVarList.getModel().getSize() > 0 && this.mLayerTargetVarList.getSelectedIndex() != -1) {
                this.defineRangeEnable(this.mLayerTargetVarList);
            }
            this.stateOfArrowButton(this.mLayerTargetVarList);
        } else if (focusEvent.getSource() == this.mSrcVarList) {
            if (this.mSrcVarList.getSelectedIndex() != -1) {
                this.mMultResSrcVarList.clearSelection();
                this.stateOfArrowButtons(true);
                this.mDefineRangeButton.setEnabled(false);
            } else if (this.mSrcVarList.getSelectedIndex() == -1 && this.mMultResSrcVarList.getSelectedIndex() == -1) {
                this.stateOfArrowButtons(false);
            } else if (this.mSrcVarList.getSelectedIndex() == -1 && this.mMultResSrcVarList.getSelectedIndex() != -1) {
                this.stateOfArrowButtons(true);
            }
        } else if (focusEvent.getSource() == this.mMultResSrcVarList) {
            if (this.mMultResSrcVarList.getSelectedIndex() != -1) {
                this.mSrcVarList.clearSelection();
                this.stateOfArrowButtons(true);
                this.mDefineRangeButton.setEnabled(false);
            } else if (this.mMultResSrcVarList.getSelectedIndex() == -1 && this.mSrcVarList.getSelectedIndex() == -1) {
                this.stateOfArrowButtons(false);
            } else if (this.mMultResSrcVarList.getSelectedIndex() == -1 && this.mSrcVarList.getSelectedIndex() != -1) {
                this.stateOfArrowButtons(true);
            }
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.checkOkPasteEnable());
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.checkOkPasteEnable());
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.checkOkPasteEnable());
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.mRowTargetVarList) {
            if (this.mRowTargetVarList.getSelectedIndex() != -1) {
                this.mCurrentTargetList = this.mRowTargetVarList;
                this.mSrcVarList.clearSelection();
                this.mMultResSrcVarList.clearSelection();
                this.mColumnTargetVarList.clearSelection();
                this.mLayerTargetVarList.clearSelection();
            }
            this.stateOfArrowButton(this.mRowTargetVarList);
            this.defineRangeEnable(this.mRowTargetVarList);
        } else if (listSelectionEvent.getSource() == this.mColumnTargetVarList) {
            if (this.mColumnTargetVarList.getSelectedIndex() != -1) {
                this.mCurrentTargetList = this.mColumnTargetVarList;
                this.mSrcVarList.clearSelection();
                this.mMultResSrcVarList.clearSelection();
                this.mRowTargetVarList.clearSelection();
                this.mLayerTargetVarList.clearSelection();
            }
            this.stateOfArrowButton(this.mColumnTargetVarList);
            this.defineRangeEnable(this.mColumnTargetVarList);
        } else if (listSelectionEvent.getSource() == this.mLayerTargetVarList) {
            if (this.mLayerTargetVarList.getSelectedIndex() != -1) {
                this.mCurrentTargetList = this.mLayerTargetVarList;
                this.mSrcVarList.clearSelection();
                this.mMultResSrcVarList.clearSelection();
                this.mRowTargetVarList.clearSelection();
                this.mColumnTargetVarList.clearSelection();
            }
            this.stateOfArrowButton(this.mLayerTargetVarList);
            this.defineRangeEnable(this.mLayerTargetVarList);
        } else if (listSelectionEvent.getSource() == this.mMultResSrcVarList) {
            if (this.mMultResSrcVarList.getSelectedIndex() != -1) {
                this.mSrcVarList.clearSelection();
                this.mRowTargetVarList.clearSelection();
                this.mColumnTargetVarList.clearSelection();
                this.mLayerTargetVarList.clearSelection();
                this.stateOfArrowButtons(true);
                this.mDefineRangeButton.setEnabled(false);
            } else if (this.mMultResSrcVarList.getSelectedIndex() == -1) {
                this.stateOfArrowButtons(false);
                this.mDefineRangeButton.setEnabled(false);
            }
        } else if (listSelectionEvent.getSource() == this.mSrcVarList) {
            if (this.mSrcVarList.getSelectedIndex() != -1) {
                this.mMultResSrcVarList.clearSelection();
                this.mRowTargetVarList.clearSelection();
                this.mColumnTargetVarList.clearSelection();
                this.mLayerTargetVarList.clearSelection();
                this.stateOfArrowButtons(true);
                this.mDefineRangeButton.setEnabled(false);
            } else if (this.mSrcVarList.getSelectedIndex() == -1) {
                this.stateOfArrowButtons(false);
                this.mDefineRangeButton.setEnabled(false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mRowArrowButton) {
            if (SpssArrowButton.ButtonOrientation.right == ((ComponentsArrowButton)actionEvent.getSource()).getArrowOrientation()) {
                if (this.mSrcVarList.getSelectedIndex() != -1) {
                    this.vitalSrcToTarget(this.mRowTargetVarList);
                } else if (this.mMultResSrcVarList.getSelectedIndex() != -1) {
                    this.multResToTargetList(this.mRowTargetVarList);
                }
            } else {
                this.vitalTargetToSrc(this.mRowTargetVarList);
            }
        }
        if (actionEvent.getSource() == this.mColumnArrowButton) {
            if (SpssArrowButton.ButtonOrientation.right == ((ComponentsArrowButton)actionEvent.getSource()).getArrowOrientation()) {
                if (this.mSrcVarList.getSelectedIndex() != -1) {
                    this.vitalSrcToTarget(this.mColumnTargetVarList);
                } else if (this.mMultResSrcVarList.getSelectedIndex() != -1) {
                    this.multResToTargetList(this.mColumnTargetVarList);
                }
            } else {
                this.vitalTargetToSrc(this.mColumnTargetVarList);
            }
        }
        if (actionEvent.getSource() == this.mLayerArrowButton) {
            if (SpssArrowButton.ButtonOrientation.right == ((ComponentsArrowButton)actionEvent.getSource()).getArrowOrientation()) {
                if (this.mSrcVarList.getSelectedIndex() != -1) {
                    this.vitalSrcToTarget(this.mLayerTargetVarList);
                } else if (this.mMultResSrcVarList.getSelectedIndex() != -1) {
                    this.multResToTargetList(this.mLayerTargetVarList);
                }
            } else {
                this.vitalTargetToSrc(this.mLayerTargetVarList);
            }
        }
        if (actionEvent.getSource() == this.mDefineRangeButton) {
            String string;
            DialogDataModel dialogDataModel;
            Object[] objectArray = this.mCurrentTargetList.getSelectedValues();
            if (objectArray != null) {
                dialogDataModel = this.getDialogDataModel();
                int n = objectArray.length;
                if (n > 1) {
                    dialogDataModel.putString("IDS_DEFINE_RANGE_MINIMUM", null);
                    dialogDataModel.putString("IDS_DEFINE_RANGE_MAXIMUM", null);
                }
                if (n == 1) {
                    string = ((TargetListData)objectArray[0]).getMinVal();
                    Object[] objectArray2 = ((TargetListData)objectArray[0]).getMaxVal();
                    if (string != null && !((TargetListData)objectArray[0]).getMinVal().equals("?")) {
                        dialogDataModel.putString("IDS_DEFINE_RANGE_MINIMUM", string);
                    } else {
                        dialogDataModel.putString("IDS_DEFINE_RANGE_MINIMUM", null);
                    }
                    if (objectArray2 != null && !((TargetListData)objectArray[0]).getMaxVal().equals("?")) {
                        dialogDataModel.putString("IDS_DEFINE_RANGE_MAXIMUM", (String)objectArray2);
                    } else {
                        dialogDataModel.putString("IDS_DEFINE_RANGE_MAXIMUM", null);
                    }
                }
            }
            this.runSubDialog(new AnalyzeDefineRange(this, this.getResString("IDS_MR_CROSSTABS_DEFINE_RANGE_TITLE"), "idh_mulc_def", -16383, 16383, false, false, false));
            if (objectArray != null) {
                dialogDataModel = this.getDialogDataModel();
                String string2 = dialogDataModel.getString("IDS_DEFINE_RANGE_MINIMUM");
                string = dialogDataModel.getString("IDS_DEFINE_RANGE_MAXIMUM");
                if (string2 != null && string != null) {
                    for (Object object : objectArray) {
                        ((TargetListData)object).setMinVal(string2);
                        ((TargetListData)object).setMaxVal(string);
                    }
                }
            }
            this.enableOkPaste(this.checkOkPasteEnable());
            this.mCurrentTargetList.updateUI();
        }
    }

    @Override
    public boolean isDragAllowed(JList jList, JList jList2, Object[] objectArray) {
        block9: {
            block8: {
                if (jList2 != this.mMultResSrcVarList) break block8;
                if (jList == this.mSrcVarList) {
                    return false;
                }
                if (jList != this.mRowTargetVarList && jList != this.mColumnTargetVarList && jList != this.mLayerTargetVarList) break block9;
                for (Object object : objectArray) {
                    if (object instanceof TargetListData) {
                        ISpssVariable iSpssVariable = ((TargetListData)object).getSpssVar();
                        if (iSpssVariable == null) continue;
                        return false;
                    }
                    return false;
                }
                break block9;
            }
            if (jList2 == this.mSrcVarList) {
                if (jList == this.mMultResSrcVarList) {
                    return false;
                }
                if (jList == this.mRowTargetVarList || jList == this.mColumnTargetVarList || jList == this.mLayerTargetVarList) {
                    for (Object object : objectArray) {
                        if (object instanceof TargetListData) {
                            ISpssVariable iSpssVariable = ((TargetListData)object).getSpssVar();
                            if (iSpssVariable != null) continue;
                            return false;
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public boolean preMoveVariables(Object[] objectArray, PlainList plainList) {
        return true;
    }

    @Override
    public Object[] getModifiedData(Object[] objectArray, JList jList, PlainList plainList) {
        Object[] objectArray2 = new Object[objectArray.length];
        if (jList == this.mSrcVarList) {
            int[] nArray = this.mSrcVarList.getSelectedIndices();
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = new TargetListData((ISpssVariable)objectArray[i], nArray[i]);
            }
            return objectArray2;
        }
        if (jList == this.mMultResSrcVarList) {
            if (plainList != this.mMultResSrcVarList) {
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray2[i] = new TargetListData((IMRVariableSet)objectArray[i]);
                }
                return objectArray2;
            }
        } else if ((jList == this.mRowTargetVarList || jList == this.mColumnTargetVarList || jList == this.mLayerTargetVarList) && plainList == this.mMultResSrcVarList) {
            int n = 0;
            for (Object object : objectArray) {
                ISpssVariable iSpssVariable;
                if (!(object instanceof TargetListData) || (iSpssVariable = ((TargetListData)object).getSpssVar()) != null) continue;
                objectArray2[n] = ((TargetListData)object).getMRSet();
                ++n;
            }
            if (n == objectArray.length) {
                return objectArray2;
            }
        }
        return objectArray;
    }

    public void loadMRVariableSets() {
        DialogDataModel dialogDataModel = new DialogDataModel();
        ProcedureDlgMgr.getMgr().loadPersistentState("analyze_mult_resp_def_sets", dialogDataModel);
        SerializableObject[] serializableObjectArray = dialogDataModel.getSerializableArray("MULTI_RES_DEFINE_SET_KEY");
        if (serializableObjectArray != null) {
            Vector<IMRVariableSet> vector = new Vector<IMRVariableSet>();
            for (SerializableObject serializableObject : serializableObjectArray) {
                if (!(serializableObject instanceof IMRVariableSet)) continue;
                vector.add((IMRVariableSet)serializableObject);
            }
            ((DefaultListModel)this.mMultResSrcVarList.getModel()).removeAllElements();
            DefaultListModel defaultListModel = (DefaultListModel)this.mMultResSrcVarList.getModel();
            vector = this.checkDefineSetVector(this.mRowTargetVarList, vector);
            vector = this.checkDefineSetVector(this.mColumnTargetVarList, vector);
            vector = this.checkDefineSetVector(this.mLayerTargetVarList, vector);
            for (IMRVariableSet iMRVariableSet : vector) {
                defaultListModel.addElement(iMRVariableSet);
            }
        }
    }

    @Override
    public void pack() {
        super.pack();
        if (this.getGlassPane() instanceof DragPane) {
            this.addDragAdapters();
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.createMainViewPanel(jPanel);
        this.setFocusTraversalPolicy();
        this.mSrcVarList.setSelectedIndex(0);
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, IDS_OPTIONS_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultiResCrossTabsDlg.this.runOptionsSubDialog();
            }
        };
        this.mOptionsButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mOptionsButton);
        return jPanel;
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.validateSerializableLists();
        this.loadMRVariableSets();
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected void validateSerializableLists() {
        this.validateLists(this.mRowTargetVarList);
        this.validateLists(this.mColumnTargetVarList);
        this.validateLists(this.mLayerTargetVarList);
        this.validateListHavingMRSet(this.mRowTargetVarList);
        this.validateListHavingMRSet(this.mColumnTargetVarList);
        this.validateListHavingMRSet(this.mLayerTargetVarList);
        this.validateListHavingMRSet(this.mMultResSrcVarList);
        this.enableOkPaste(this.checkOkPasteEnable());
    }

    private void addDragAdapters() {
        DragPane dragPane = (DragPane)this.getGlassPane();
        dragPane.addDropListener((IDropListener)new PlainListDropListener(this.mSrcVarList, this.mPlainListVarMoveHandler));
        PlainListDragAdapter plainListDragAdapter = new PlainListDragAdapter(this.mRowTargetVarList, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(this.mRowTargetVarList, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(this.mRowTargetVarList, this.mPlainListVarMoveHandler));
        plainListDragAdapter = new PlainListDragAdapter(this.mColumnTargetVarList, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(this.mColumnTargetVarList, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(this.mColumnTargetVarList, this.mPlainListVarMoveHandler));
        plainListDragAdapter = new PlainListDragAdapter(this.mLayerTargetVarList, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(this.mLayerTargetVarList, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(this.mLayerTargetVarList, this.mPlainListVarMoveHandler));
        plainListDragAdapter = new PlainListDragAdapter(this.mMultResSrcVarList, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(this.mMultResSrcVarList, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(this.mMultResSrcVarList, this.mPlainListVarMoveHandler));
    }

    private void stateOfArrowButton(PlainList plainList) {
        if (plainList == this.mRowTargetVarList) {
            this.mRowArrowButton.setEnabled(this.mRowTargetVarList.getModel().getSize() > 0 && this.mRowTargetVarList.getSelectedIndex() != -1);
            this.mRowArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            if (this.mRowTargetVarList.getSelectedIndex() != -1) {
                this.mColumnArrowButton.setEnabled(false);
                this.mLayerArrowButton.setEnabled(false);
            }
        } else if (plainList == this.mColumnTargetVarList) {
            this.mColumnArrowButton.setEnabled(this.mColumnTargetVarList.getModel().getSize() > 0 && this.mColumnTargetVarList.getSelectedIndex() != -1);
            this.mColumnArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            if (this.mColumnTargetVarList.getSelectedIndex() != -1) {
                this.mRowArrowButton.setEnabled(false);
                this.mLayerArrowButton.setEnabled(false);
            }
        } else if (plainList == this.mLayerTargetVarList) {
            this.mLayerArrowButton.setEnabled(this.mLayerTargetVarList.getModel().getSize() > 0 && this.mLayerTargetVarList.getSelectedIndex() != -1);
            this.mLayerArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            if (this.mLayerTargetVarList.getSelectedIndex() != -1) {
                this.mRowArrowButton.setEnabled(false);
                this.mColumnArrowButton.setEnabled(false);
            }
        }
    }

    private void stateOfArrowButtons(boolean bl) {
        this.mRowArrowButton.setEnabled(bl);
        this.mColumnArrowButton.setEnabled(bl);
        this.mLayerArrowButton.setEnabled(bl);
        this.mRowArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mColumnArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mLayerArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
    }

    private void validateListHavingMRSet(PlainList plainList) {
        Vector<IMRVariableSet> vector = new Vector<IMRVariableSet>();
        DialogDataModel dialogDataModel = new DialogDataModel();
        ProcedureDlgMgr.getMgr().loadPersistentState("analyze_mult_resp_def_sets", dialogDataModel);
        SerializableObject[] serializableObjectArray = dialogDataModel.getSerializableArray("MULTI_RES_DEFINE_SET_KEY");
        if (serializableObjectArray != null) {
            for (SerializableObject serializableObject : serializableObjectArray) {
                if (!(serializableObject instanceof IMRVariableSet)) continue;
                vector.add((IMRVariableSet)serializableObject);
            }
        }
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        block1: for (int i = plainList.getModel().getSize() - 1; i >= 0; --i) {
            Object object;
            Object object2;
            if (plainList.getModel().getElementAt(i) instanceof TargetListData) {
                object2 = (TargetListData)plainList.getModel().getElementAt(i);
                object = ((TargetListData)object2).getMRSet();
            } else {
                object = (IMRVariableSet)((DefaultListModel)plainList.getModel()).getElementAt(i);
            }
            if (object == null) continue;
            object2 = object.getVariableNames(IMRVariableSet.ChangeCase.kNoChange);
            int n = ((Vector)object2).size();
            for (int j = 0; j < n; ++j) {
                int n2 = iSpssDataSrc.findVarIndex((String)((Vector)object2).get(j));
                if (n2 != -1) continue;
                if (vector.contains(object)) {
                    vector.remove(object);
                    if (vector.size() == 0) {
                        this.dispose();
                    }
                }
                ((DefaultListModel)plainList.getModel()).removeElementAt(i);
                continue block1;
            }
        }
        MRVariableSet[] mRVariableSetArray = new MRVariableSet[vector.size()];
        this.getDialogDataModel().putSerializableArray("MULTI_RES_DEFINE_SET_KEY", vector.toArray(mRVariableSetArray));
        this.mRowTargetVarList.repaint();
        this.mColumnTargetVarList.repaint();
        this.mLayerTargetVarList.repaint();
    }

    private void validateLists(PlainList plainList) {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        for (int i = plainList.getModel().getSize() - 1; i >= 0; --i) {
            TargetListData targetListData = (TargetListData)plainList.getModel().getElementAt(i);
            ISpssVariable iSpssVariable = targetListData.getSpssVar();
            if (iSpssVariable != null) {
                int n = iSpssDataSrc.findVarIndex(targetListData.getVarName());
                boolean bl = iSpssDataSrc.isVariableInCurrentSet(iSpssVariable);
                if (n == -1) {
                    if (!bl) {
                        ((DefaultListModel)plainList.getModel()).removeElementAt(i);
                    } else {
                        targetListData.setVarName(iSpssVariable.getName());
                    }
                } else if (!this.mSrcVarList.canIncludeVariable(iSpssDataSrc.getVariable(n))) {
                    ((DefaultListModel)plainList.getModel()).removeElementAt(i);
                }
            }
            this.mSrcVarList.getModel().removeElement(iSpssVariable);
        }
        this.mRowTargetVarList.repaint();
        this.mColumnTargetVarList.repaint();
        this.mLayerTargetVarList.repaint();
    }

    private void runOptionsSubDialog() {
        this.runSubDialog(new MRCrosstabsOptions(this));
    }

    private void initVars() {
        ActionListener[] actionListenerArray;
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mSrcVarList.addFocusListener(this);
        this.mSrcVarList.addListSelectionListener(this);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        Dimension dimension = this.mSrcVarList.getMinimumSize();
        this.mSrcVarList.setMinimumSize(dimension);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mMultResSrcVarList = new PlainList(MULT_RES_SET_LIST);
        this.mMultResSrcVarList.setCellRenderer(new MRCrossTabsListCellRenderer());
        this.mMultResSrcVarList.getModel().addListDataListener(this);
        this.mMultResSrcVarList.addFocusListener(this);
        this.mMultResSrcVarList.addListSelectionListener(this);
        this.mMultResSrcScrollPane = new JScrollPane(this.mMultResSrcVarList);
        dimension = this.mMultResSrcVarList.getMinimumSize();
        dimension.height = 60;
        this.mMultResSrcVarList.setMinimumSize(dimension);
        this.mMultResSrcScrollPane.setPreferredSize(this.mMultResSrcVarList.getMinimumSize());
        this.mRowTargetVarList = new PlainList(ROW_TARGET_VAR_LIST);
        this.mRowTargetVarList.getModel().addListDataListener(this);
        this.mRowTargetVarList.addListSelectionListener(this);
        this.mRowTargetVarList.addFocusListener(this);
        this.mRowTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mRowTargetVarList.getFixedCellHeight() * 3 + 2));
        this.mRowTargetScrollPane = new JScrollPane(this.mRowTargetVarList);
        this.mRowTargetScrollPane.setPreferredSize(this.mRowTargetVarList.getMinimumSize());
        this.mRowTargetVarList.setName("RowTargetList");
        this.mColumnTargetVarList = new PlainList(COLUMN_TARGET_VAR_LIST);
        this.mColumnTargetVarList.getModel().addListDataListener(this);
        this.mColumnTargetVarList.addListSelectionListener(this);
        this.mColumnTargetVarList.addFocusListener(this);
        this.mColumnTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mColumnTargetVarList.getFixedCellHeight() * 3 + 2));
        this.mColumnTargetScrollPane = new JScrollPane(this.mColumnTargetVarList);
        this.mColumnTargetScrollPane.setPreferredSize(this.mColumnTargetVarList.getMinimumSize());
        this.mColumnTargetVarList.setName("ColumnTargetList");
        this.mLayerTargetVarList = new PlainList(LAYER_TARGET_VAR_LIST);
        this.mLayerTargetVarList.getModel().addListDataListener(this);
        this.mLayerTargetVarList.addListSelectionListener(this);
        this.mLayerTargetVarList.addFocusListener(this);
        this.mLayerTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mLayerTargetVarList.getFixedCellHeight() * 3 + 2));
        this.mLayerTargetScrollPane = new JScrollPane(this.mLayerTargetVarList);
        this.mLayerTargetScrollPane.setPreferredSize(this.mLayerTargetVarList.getMinimumSize());
        this.mLayerTargetVarList.setName("LayerTargetList");
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_MR_CROSSTABS_DEFINE_RANGE_3DOT");
        this.mDefineRangeButton = new JButton(toggleButtonAction);
        this.mDefineRangeButton.addActionListener(this);
        this.mRowArrowButton = new ComponentsArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mRowArrowButton.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mRowArrowButton.registerComponents(this.mRowTargetVarList, SpssArrowButton.ButtonOrientation.left);
        for (ActionListener actionListener : actionListenerArray = this.mRowArrowButton.getActionListeners()) {
            this.mRowArrowButton.removeActionListener(actionListener);
        }
        this.mRowArrowButton.addActionListener(this);
        this.mColumnArrowButton = new ComponentsArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mColumnArrowButton.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mColumnArrowButton.registerComponents(this.mColumnTargetVarList, SpssArrowButton.ButtonOrientation.left);
        for (ActionListener actionListener : actionListenerArray) {
            this.mColumnArrowButton.removeActionListener(actionListener);
        }
        this.mColumnArrowButton.addActionListener(this);
        this.mLayerArrowButton = new ComponentsArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mLayerArrowButton.registerComponents(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mLayerArrowButton.registerComponents(this.mLayerTargetVarList, SpssArrowButton.ButtonOrientation.left);
        for (ActionListener actionListener : actionListenerArray) {
            this.mLayerArrowButton.removeActionListener(actionListener);
        }
        this.mLayerArrowButton.addActionListener(this);
        this.mMultResSetsLabel = DialogUtil.createLabel(this, "IDS_MR_CROSSTABS_MULT_RESPONSE_SET");
        this.mMultResSetsLabel.setLabelFor(this.mMultResSrcVarList);
        this.mRowLabel = DialogUtil.createLabel(this, "IDS_MR_CROSSTABS_ROW_COLON");
        this.mRowLabel.setLabelFor(this.mRowTargetVarList);
        this.mColumnLabel = DialogUtil.createLabel(this, "IDS_MR_CROSSTABS_COLUMN_COLON");
        this.mColumnLabel.setLabelFor(this.mColumnTargetVarList);
        this.mLayerLabel = DialogUtil.createLabel(this, "IDS_MR_CROSSTABS_LAYER_COLON");
        this.mLayerLabel.setLabelFor(this.mLayerTargetVarList);
        this.mPlainListVarMoveHandler = this;
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.mMultResSrcVarList.ensureIndexIsVisible(0);
        ((DefaultListModel)this.mRowTargetVarList.getModel()).removeAllElements();
        ((DefaultListModel)this.mColumnTargetVarList.getModel()).removeAllElements();
        ((DefaultListModel)this.mLayerTargetVarList.getModel()).removeAllElements();
        this.mDefineRangeButton.setEnabled(false);
        this.mRowArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mColumnArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mLayerArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.enableOkPaste(false);
    }

    private JPanel createMultResponsePanel() {
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(""));
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(0, n, 0, n);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_MR_CROSSTABS_SRCLIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        insets.set(0, n, n, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mMultResSetsLabel, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(0, n, n, n);
        DialogUtil.addUsingGBL(jPanel, this.mMultResSrcScrollPane, gridBagConstraints, 0, 3, 1, 1, n2, insets);
        return jPanel;
    }

    private void createMainViewPanel(JPanel jPanel) {
        JPanel jPanel2 = this.createMultResponsePanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 7, n, null);
        Insets insets = DialogUtil.getArrowButtonInsets();
        Insets insets2 = new Insets(0, insets.left, 0, insets.right);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mRowArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mColumnArrowButton, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mLayerArrowButton, gridBagConstraints, 1, 5, 1, 1, n, insets2);
        n = 23;
        gridBagConstraints.fill = 0;
        Insets insets3 = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mRowLabel, gridBagConstraints, 2, 0, 1, 1, n, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        n = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mRowTargetScrollPane, gridBagConstraints, 2, 1, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 23;
        gridBagConstraints.fill = 0;
        insets3.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mColumnLabel, gridBagConstraints, 2, 2, 1, 1, n, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mColumnTargetScrollPane, gridBagConstraints, 2, 3, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mLayerLabel, gridBagConstraints, 2, 4, 1, 1, n, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mLayerTargetScrollPane, gridBagConstraints, 2, 5, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 23;
        int n3 = DialogUtil.getComponentGroupGap();
        insets3.set(n3, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDefineRangeButton, gridBagConstraints, 2, 6, 1, 1, n, insets3);
    }

    private boolean checkOkPasteEnable() {
        DefaultListModel defaultListModel = (DefaultListModel)this.mRowTargetVarList.getModel();
        DefaultListModel defaultListModel2 = (DefaultListModel)this.mColumnTargetVarList.getModel();
        DefaultListModel defaultListModel3 = (DefaultListModel)this.mLayerTargetVarList.getModel();
        int n = defaultListModel.size();
        int n2 = defaultListModel2.size();
        int n3 = defaultListModel3.size();
        if (n > 0 && n2 > 0) {
            TargetListData targetListData;
            int n4;
            for (n4 = 0; n4 < n; ++n4) {
                targetListData = (TargetListData)defaultListModel.get(n4);
                if (targetListData.getSpssVar() == null || targetListData.getMinVal().indexOf("?") == -1 && targetListData.getMaxVal().indexOf("?") == -1) continue;
                return false;
            }
            for (n4 = 0; n4 < n2; ++n4) {
                targetListData = (TargetListData)defaultListModel2.get(n4);
                if (targetListData.getSpssVar() == null || targetListData.getMinVal().indexOf("?") == -1 && targetListData.getMaxVal().indexOf("?") == -1) continue;
                return false;
            }
            for (n4 = 0; n4 < n3; ++n4) {
                targetListData = (TargetListData)defaultListModel3.get(n4);
                if (targetListData.getSpssVar() == null || targetListData.getMinVal().indexOf("?") == -1 && targetListData.getMaxVal().indexOf("?") == -1) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void defineRangeEnable(PlainList plainList) {
        Object[] objectArray = plainList.getSelectedValues();
        if (objectArray != null && objectArray.length == 1) {
            if (((TargetListData)objectArray[0]).getMRSet() != null) {
                this.mDefineRangeButton.setEnabled(false);
            }
            if (((TargetListData)objectArray[0]).getSpssVar() != null) {
                this.mDefineRangeButton.setEnabled(true);
            }
        } else if (objectArray != null && objectArray.length == 0) {
            this.mDefineRangeButton.setEnabled(false);
        } else if (objectArray != null) {
            for (Object object : objectArray) {
                if (((TargetListData)object).getSpssVar() == null) continue;
                this.mDefineRangeButton.setEnabled(true);
            }
        }
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mMultResSrcVarList);
        vector.add(this.mRowArrowButton);
        vector.add(this.mColumnArrowButton);
        vector.add(this.mLayerArrowButton);
        vector.add(this.mRowTargetVarList);
        vector.add(this.mColumnTargetVarList);
        vector.add(this.mLayerTargetVarList);
        vector.add(this.mDefineRangeButton);
        vector.add(this.mOptionsButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void vitalSrcToTarget(PlainList plainList) {
        DefaultListModel defaultListModel = (DefaultListModel)plainList.getModel();
        ISpssVariable[] iSpssVariableArray = this.mSrcVarList.getSelectedValues();
        int[] nArray = this.mSrcVarList.getSelectedIndices();
        this.mSrcVarList.clearSelection();
        int n = plainList.getModel().getSize();
        int n2 = n + iSpssVariableArray.length - 1;
        plainList.clearSelection();
        for (int i = 0; i < iSpssVariableArray.length; ++i) {
            TargetListData targetListData = new TargetListData(iSpssVariableArray[i], nArray[i]);
            defaultListModel.addElement(targetListData);
            this.mSrcVarList.getModel().removeElement(iSpssVariableArray[i]);
        }
        plainList.requestFocus();
        plainList.setSelectionInterval(n, n2);
    }

    private void vitalTargetToSrc(PlainList plainList) {
        DefaultListModel defaultListModel = (DefaultListModel)this.mMultResSrcVarList.getModel();
        DefaultListModel defaultListModel2 = (DefaultListModel)plainList.getModel();
        Object[] objectArray = plainList.getSelectedValues();
        int n = ((DefaultListModel)this.mMultResSrcVarList.getModel()).size();
        int[] nArray = new int[objectArray.length];
        int n2 = 0;
        int n3 = 0;
        for (Object i : objectArray) {
            TargetListData targetListData = (TargetListData)i;
            ISpssVariable iSpssVariable = targetListData.getSpssVar();
            if (iSpssVariable != null) {
                nArray[n3++] = targetListData.getIndexInSrc();
                this.mSrcVarList.getModel().addElement(iSpssVariable, true);
                ++n2;
            } else {
                IMRVariableSet iMRVariableSet = targetListData.getMRSet();
                defaultListModel.addElement(iMRVariableSet);
            }
            defaultListModel2.removeElement(i);
        }
        if (n3 > 0) {
            this.mSrcVarList.requestFocus();
            if (n2 != objectArray.length) {
                int[] n4 = new int[n2];
                System.arraycopy(nArray, 0, n4, 0, n4.length);
                this.mSrcVarList.setSelectedIndices(n4);
            } else {
                this.mSrcVarList.setSelectedIndices(nArray);
            }
        } else {
            int n4 = ((DefaultListModel)this.mMultResSrcVarList.getModel()).size();
            int n5 = n4 - n;
            int[] nArray2 = new int[n5];
            this.mMultResSrcVarList.requestFocus();
            for (int i = 0; i < n5; ++i) {
                nArray2[i] = n++;
            }
            if (objectArray.length > 0) {
                this.mMultResSrcVarList.setSelectedIndices(nArray2);
            }
        }
        plainList.clearSelection();
    }

    private void multResToTargetList(PlainList plainList) {
        DefaultListModel defaultListModel = (DefaultListModel)plainList.getModel();
        Object[] objectArray = this.mMultResSrcVarList.getSelectedValues();
        int n = plainList.getModel().getSize();
        int n2 = n + objectArray.length - 1;
        plainList.clearSelection();
        for (Object object : objectArray) {
            TargetListData targetListData = new TargetListData((IMRVariableSet)object);
            defaultListModel.addElement(targetListData);
            ((DefaultListModel)this.mMultResSrcVarList.getModel()).removeElement(object);
        }
        plainList.setSelectionInterval(n, n2);
        plainList.requestFocus();
    }

    private Vector<IMRVariableSet> checkDefineSetVector(PlainList plainList, Vector<IMRVariableSet> vector) {
        DefaultListModel defaultListModel = (DefaultListModel)plainList.getModel();
        Object[] objectArray = new Object[defaultListModel.size()];
        for (int i = 0; i < defaultListModel.size(); ++i) {
            objectArray[i] = defaultListModel.get(i);
        }
        for (Object object : objectArray) {
            TargetListData targetListData = (TargetListData)object;
            IMRVariableSet iMRVariableSet = targetListData.getMRSet();
            if (iMRVariableSet == null) continue;
            if (!vector.contains(iMRVariableSet)) {
                defaultListModel.removeElement(object);
                continue;
            }
            vector.remove(iMRVariableSet);
        }
        plainList.updateUI();
        return vector;
    }

    private void fillLists(Vector<IMRVariableSet> vector, Vector<TargetListData> vector2, Vector<String> vector3) {
        Object object;
        Object object2;
        Object object3;
        DefaultListModel defaultListModel = (DefaultListModel)this.mRowTargetVarList.getModel();
        for (int i = 0; i < defaultListModel.size(); ++i) {
            TargetListData targetListData = (TargetListData)defaultListModel.getElementAt(i);
            object3 = targetListData.getMRSet();
            object2 = targetListData.getSpssVar();
            if (object3 != null) {
                vector.add((IMRVariableSet)object3);
                vector3.add("$".concat(object3.getName(IMRVariableSet.ChangeCase.kNoChange)));
            }
            if (object2 == null) continue;
            vector2.add(targetListData);
            vector3.add(object2.getName());
        }
        DefaultListModel defaultListModel2 = (DefaultListModel)this.mColumnTargetVarList.getModel();
        for (int i = 0; i < defaultListModel2.size(); ++i) {
            object3 = (TargetListData)defaultListModel2.getElementAt(i);
            object2 = ((TargetListData)object3).getMRSet();
            object = ((TargetListData)object3).getSpssVar();
            if (object2 != null) {
                vector.add((IMRVariableSet)object2);
                vector3.add("$".concat(object2.getName(IMRVariableSet.ChangeCase.kNoChange)));
            }
            if (object == null) continue;
            vector2.add((TargetListData)object3);
            vector3.add(object.getName());
        }
        DefaultListModel defaultListModel3 = (DefaultListModel)this.mLayerTargetVarList.getModel();
        for (int i = 0; i < defaultListModel3.size(); ++i) {
            object2 = (TargetListData)defaultListModel3.getElementAt(i);
            object = ((TargetListData)object2).getMRSet();
            ISpssVariable iSpssVariable = ((TargetListData)object2).getSpssVar();
            if (object != null) {
                vector.add((IMRVariableSet)object);
                vector3.add("$".concat(object.getName(IMRVariableSet.ChangeCase.kNoChange)));
            }
            if (iSpssVariable == null) continue;
            vector2.add((TargetListData)object2);
            vector3.add(iSpssVariable.getName());
        }
    }

    public class TargetListData {
        String minVal;
        String maxVal;
        int indexInSrc;
        ISpssVariable spssVar = null;
        IMRVariableSet multResSet = null;
        String varName;

        public TargetListData(ISpssVariable iSpssVariable, int n) {
            this.varName = iSpssVariable.getName();
            this.spssVar = iSpssVariable;
            this.minVal = "?";
            this.maxVal = "?";
            this.indexInSrc = n;
        }

        public TargetListData(IMRVariableSet iMRVariableSet) {
            this.multResSet = iMRVariableSet;
        }

        public ISpssVariable getSpssVar() {
            return this.spssVar;
        }

        public void setSpssVar(ISpssVariable iSpssVariable) {
            this.spssVar = iSpssVariable;
        }

        public String getMinVal() {
            return this.minVal;
        }

        public String getMaxVal() {
            return this.maxVal;
        }

        public void setMinVal(String string) {
            this.minVal = string;
        }

        public void setMaxVal(String string) {
            this.maxVal = string;
        }

        public int getIndexInSrc() {
            return this.indexInSrc;
        }

        public IMRVariableSet getMRSet() {
            return this.multResSet;
        }

        public void setMRSet(IMRVariableSet iMRVariableSet) {
            this.multResSet = iMRVariableSet;
        }

        public String toString() {
            if (this.spssVar != null) {
                return this.spssVar.getName().concat("(").concat(this.minVal).concat(" ").concat(this.maxVal).concat(")");
            }
            if (this.multResSet != null) {
                return "$".concat(this.multResSet.getName(IMRVariableSet.ChangeCase.kNoChange));
            }
            return "";
        }

        public String getVarName() {
            return this.varName;
        }

        public void setVarName(String string) {
            this.varName = string;
        }
    }

    private class MRCrossTabsListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private Border mNoFocusBorder = new EmptyBorder(1, 1, 1, 1);
        private boolean mShowVarLabels;

        public MRCrossTabsListCellRenderer() {
            this.setBorder(this.mNoFocusBorder);
            this.setOpaque(true);
            Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
            Preferences preferences2 = preferences.node("options");
            Preferences preferences3 = preferences2.node("general");
            this.mShowVarLabels = preferences3.get("var_list_display", "").equals(IOptionConstants.VAR_LIST_DISPLAY_VALUES[0]);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string;
            URL uRL;
            if (this.mShowVarLabels) {
                uRL = this.getImageURL((IMRVariableSet)object);
                string = ((IMRVariableSet)object).getLabel() + "[$" + ((IMRVariableSet)object).getName(IMRVariableSet.ChangeCase.kNoChange) + "]";
            } else {
                uRL = this.getImageURL((IMRVariableSet)object);
                string = "$" + ((IMRVariableSet)object).getName(IMRVariableSet.ChangeCase.kNoChange);
            }
            this.setIcon(new ImageIcon(uRL));
            this.setText(string);
            if (bl) {
                if (jList.hasFocus()) {
                    this.setBackground(jList.getSelectionBackground());
                    this.setForeground(jList.getSelectionForeground());
                } else {
                    this.setBackground(Color.lightGray);
                    this.setForeground(Color.black);
                }
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            Border border = null;
            if (bl2) {
                if (bl) {
                    border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("List.focusCellHighlightBorder");
                }
            } else {
                border = this.mNoFocusBorder;
            }
            this.setBorder(border);
            this.setOpaque(true);
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }

        private URL getImageURL(IMRVariableSet iMRVariableSet) {
            URL uRL = null;
            if (iMRVariableSet.getType() == IMRVariableSet.MRVariableSetType.kMR_Dichotomy) {
                uRL = MultiResCrossTabsDlg.this.getResImageURL("IDS_MR_FREQ_DICHOTOMY_IMAGE");
            }
            if (iMRVariableSet.getType() == IMRVariableSet.MRVariableSetType.kMR_Category) {
                uRL = MultiResCrossTabsDlg.this.getResImageURL("IDS_MR_FREQ_CATEGORY_IMAGE");
            }
            return uRL;
        }
    }
}

