/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.multiple_res.crosstabs;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.multiple_res.crosstabs.MultiResCrossTabsDlg;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class MRCrosstabsOptions
extends BaseSubDialog
implements ItemListener {
    static final String ROW_CHECKBOX_KEY = "IDS_MR_CROSSTABS_ROW";
    static final String COLUMN_CHECKBOX_KEY = "IDS_MR_CROSSTABS_COLUMN";
    static final String TOTAL_CHECKBOX_KEY = "IDS_MR_CROSSTABS_TOTAL";
    static final String MATCH_VAR_CHECKBOX_KEY = "IDS_MR_CROSSTABS_MATCH_VARIABLES";
    static final String CASES_RADIO_KEY = "IDS_MR_CROSSTABS_CASES";
    static final String RESPONSES_RADIO_KEY = "IDS_MR_CROSSTABS_RESPONSES";
    static final String EXCLUDE_DICHO_CHECKBOX_KEY = "IDS_MR_CROSSTABS_EXCLUDE_CASES_DICHOTOMIES";
    static final String EXCLUDE_CATEGORY_CHECKBOX_KEY = "IDS_MR_CROSSTABS_EXCLUDE_CASES_CATEGORIES";
    private JCheckBox mRowCheck;
    private JCheckBox mColumnCheck;
    private JCheckBox mTotalCheck;
    private JCheckBox mMatchVariableCheck;
    private JRadioButton mCasesRadio;
    private JRadioButton mResponsesRadio;
    private JCheckBox mExcludeDichotomyCheck;
    private JCheckBox mExcludeCategoryCheck;
    private SpssButtonGroup mPercentPanelButtonGrp;

    public MRCrosstabsOptions(MultiResCrossTabsDlg multiResCrossTabsDlg) {
        super(multiResCrossTabsDlg, multiResCrossTabsDlg.getResString("IDS_MR_CROSSTABS_OPTIONS_SUBDIALOG_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_mulc_opt";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mMatchVariableCheck) {
            this.mCasesRadio.setEnabled(!this.mMatchVariableCheck.isSelected());
            this.mResponsesRadio.setSelected(this.mMatchVariableCheck.isSelected());
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupOptionsPanel(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, ROW_CHECKBOX_KEY);
        this.mRowCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, COLUMN_CHECKBOX_KEY);
        this.mColumnCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, TOTAL_CHECKBOX_KEY);
        this.mTotalCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, MATCH_VAR_CHECKBOX_KEY);
        this.mMatchVariableCheck = new JCheckBox(toggleButtonAction);
        this.mMatchVariableCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, CASES_RADIO_KEY);
        this.mCasesRadio = new JRadioButton(toggleButtonAction);
        this.mCasesRadio.setSelected(true);
        toggleButtonAction = new ToggleButtonAction(this, RESPONSES_RADIO_KEY);
        this.mResponsesRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, EXCLUDE_DICHO_CHECKBOX_KEY);
        this.mExcludeDichotomyCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, EXCLUDE_CATEGORY_CHECKBOX_KEY);
        this.mExcludeCategoryCheck = new JCheckBox(toggleButtonAction);
    }

    private void setupOptionsPanel(JPanel jPanel) {
        JComponent[] jComponentArray = new JComponent[]{this.mRowCheck, this.mColumnCheck, this.mTotalCheck};
        JPanel jPanel2 = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.xaxis, this.getResString("IDS_MR_CROSSTABS_CELL_PERCENTAGE"));
        DialogUtil.createButtonGroup(jPanel2);
        JComponent[] jComponentArray2 = new JComponent[]{this.mCasesRadio, this.mResponsesRadio};
        JPanel jPanel3 = PanelFactory.getBasicPanel(jComponentArray2, PanelFactory.PanelType.xaxis, this.getResString("IDS_MR_CROSSTABS_PERCENTAGE_BASED_ON"));
        this.mPercentPanelButtonGrp = DialogUtil.createButtonGroup(jPanel3);
        JComponent[] jComponentArray3 = new JComponent[]{this.mExcludeDichotomyCheck, this.mExcludeCategoryCheck};
        JPanel jPanel4 = PanelFactory.getBasicPanel(jComponentArray3, PanelFactory.PanelType.yaxis, this.getResString("IDS_MR_CROSSTABS_MISSING_VALUES"));
        DialogUtil.createButtonGroup(jPanel4);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n = DialogUtil.getComponentGroupGap();
        int n2 = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n2, null);
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(n, n - DialogUtil.getStandardControlInsets().left, 0, 0);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mMatchVariableCheck, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 3, 1, 1, n2, insets);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mRowCheck);
        vector.add(this.mColumnCheck);
        vector.add(this.mTotalCheck);
        vector.add(this.mMatchVariableCheck);
        vector.add(this.mPercentPanelButtonGrp);
        vector.add(this.mExcludeDichotomyCheck);
        vector.add(this.mExcludeCategoryCheck);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }
}

