/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.multiple_res;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.BasicACREvent;
import com.spss.java_client.ui.controls.BasicACRWidget;
import com.spss.java_client.ui.controls.FixedLengthDocument;
import com.spss.java_client.ui.controls.IBasicACRListener;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.multiple_res.IMRVariableSet;
import com.spss.java_client.ui.dialogs.base.analyze.multiple_res.MRFrequenciesDlg;
import com.spss.java_client.ui.dialogs.base.analyze.multiple_res.MRVariableSet;
import com.spss.java_client.ui.dialogs.base.analyze.multiple_res.crosstabs.MultiResCrossTabsDlg;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class MultiResDefineSetsDlg
extends BaseProcedureDialog
implements FocusListener,
DocumentListener,
ItemListener,
IBasicACRListener,
ListDataListener {
    public static final String MULTI_RES_DEFINE_SET_KEY = "MULTI_RES_DEFINE_SET_KEY";
    private static final int TEXT_FIELD_WIDTH = 2;
    private static final String COUNTED_VAL_TEXT = "IDS_COUNTED_VAL_TEXT";
    private static final String RANGE_TEXT = "IDS_RANGE_TEXT";
    private static final String THROUGH_TEXT = "IDS_THROUGH_TEXT";
    private static final String NAME_TEXT = "IDS_NAME_TEXT";
    private static final String LABEL_TEXT = "IDS_LABEL_TEXT";
    private static String BASIC_ACRWIDGET_ACTION_KEY = "IDS_BASIC_ACRWIDGET";
    private SrcVariableList mSrcVarList;
    private JScrollPane mSrcScrollPane;
    private TargetVariableList mVarInSetList;
    private JScrollPane mVarInSetScrollPane;
    private JLabel mVariablesInSetLabel;
    private ArrowButton mArrowButton;
    private JRadioButton mDichotomiesRadio;
    private JRadioButton mCategoriesRadio;
    private SpssButtonGroup mButtonGroup;
    private JLabel mCountedValLabel;
    private IntTextField mCountedValText;
    private JLabel mRangeLabel;
    private IntTextField mRangeText;
    private JLabel mThroughLabel;
    private IntTextField mThroughText;
    private JLabel mNameLabel;
    private JLabel mLabelLabel;
    private StringTextField mNameText;
    private StringTextField mLabelText;
    private JLabel mMultiResSetsLabel;
    private BasicACRWidget mMultiResSetsBasicACRWidget;
    private Vector<MRVariableSet> mVarSetVector;

    public MultiResDefineSetsDlg(JFrame jFrame) {
        super(jFrame, true, AnalyzeResBundle.getDefaultResourceBundleName(), AnalyzeResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_MR_DS_TITLE"));
        this.setDefaultCloseOperation(0);
    }

    @Override
    public final String getIActionKey() {
        return "analyze_mult_resp_def_sets";
    }

    @Override
    public String generateSyntax() {
        return null;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_mrse";
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        JTextField jTextField = (JTextField)focusEvent.getSource();
        jTextField.setSelectionStart(0);
        jTextField.setSelectionEnd(jTextField.getText().length());
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableAddChangeButtons();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableAddChangeButtons();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableAddChangeButtons();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mDichotomiesRadio) {
            this.enableVariablesTextField(true);
        } else {
            this.enableVariablesTextField(false);
        }
        this.enableAddChangeButtons();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableAddChangeButtons();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableAddChangeButtons();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableAddChangeButtons();
    }

    @Override
    public void acrEventOccured(BasicACREvent basicACREvent) {
        BasicACREvent.EventType eventType = basicACREvent.getEventType();
        boolean bl = this.mSrcVarList.getModel().getShowVarLabels();
        if (eventType.equals((Object)BasicACREvent.EventType.addButtonPress)) {
            this.acrAddButtonPressed();
            this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        } else if (eventType.equals((Object)BasicACREvent.EventType.removeButtonPress)) {
            this.acrRemoveButtonPressed();
            this.resetAllVars();
            this.mCountedValText.requestFocusInWindow();
        } else if (eventType.equals((Object)BasicACREvent.EventType.changeButtonPress)) {
            this.acrChangeButtonPressed();
        } else if (eventType.equals((Object)BasicACREvent.EventType.listSelectionValueChange) || eventType.equals((Object)BasicACREvent.EventType.listGotFocus)) {
            if (eventType.equals((Object)BasicACREvent.EventType.listGotFocus) && this.mMultiResSetsBasicACRWidget.getListSelectedIndex() == -1) {
                return;
            }
            if (eventType.equals((Object)BasicACREvent.EventType.listSelectionValueChange) && this.mMultiResSetsBasicACRWidget.getList().getValueIsAdjusting()) {
                return;
            }
            int n = this.mMultiResSetsBasicACRWidget.getListSelectedIndex();
            this.mNameText.getDocument().removeDocumentListener(this);
            this.mCountedValText.getDocument().removeDocumentListener(this);
            this.mRangeText.getDocument().removeDocumentListener(this);
            this.mThroughText.getDocument().removeDocumentListener(this);
            this.mVarInSetList.getModel().removeListDataListener(this);
            this.mVarInSetList.getModel().removeAll();
            this.mSrcVarList.getModel().removeAll();
            this.mSrcVarList.loadFromActiveDataset();
            this.mMultiResSetsBasicACRWidget.setAddEnabled(false);
            this.mMultiResSetsBasicACRWidget.setChangeEnabled(false);
            if (n > -1) {
                String string = this.mMultiResSetsBasicACRWidget.getListItemAt(n).toString().substring(1);
                for (MRVariableSet mRVariableSet : this.mVarSetVector) {
                    if (!mRVariableSet.getName().equalsIgnoreCase(string)) continue;
                    if (mRVariableSet.getType() == IMRVariableSet.MRVariableSetType.kMR_Dichotomy) {
                        this.mDichotomiesRadio.setSelected(true);
                        this.mRangeText.setText("");
                        this.mThroughText.setText("");
                        this.mCountedValText.setText(mRVariableSet.getValue());
                    } else {
                        this.mCategoriesRadio.setSelected(true);
                        this.mCountedValText.setText("");
                        this.mRangeText.setText(mRVariableSet.getRangeValue());
                        this.mThroughText.setText(mRVariableSet.getThroughValue());
                    }
                    this.mNameText.setText(string);
                    this.mLabelText.setText(mRVariableSet.getLabel());
                    Vector<String> vector = mRVariableSet.getVariableNames();
                    for (String string2 : vector) {
                        this.mVarInSetList.getModel().addElement(this.getSpssVar(string2));
                    }
                }
                for (int i = 0; i < this.mVarInSetList.getModel().getSize(); ++i) {
                    for (int j = 0; j < this.mSrcVarList.getModel().getSize(); ++j) {
                        if (!this.mSrcVarList.getModel().getElementAt(j).getName().equals(this.mVarInSetList.getModel().getElementAt(i).getName())) continue;
                        this.mSrcVarList.getModel().removeElementAt(j);
                    }
                }
                this.mMultiResSetsBasicACRWidget.setRemoveEnabled(true);
            } else {
                this.resetAllVars();
            }
            this.mNameText.getDocument().addDocumentListener(this);
            this.mCountedValText.getDocument().addDocumentListener(this);
            this.mRangeText.getDocument().addDocumentListener(this);
            this.mThroughText.getDocument().addDocumentListener(this);
            this.mVarInSetList.getModel().addListDataListener(this);
            this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        }
        this.mSrcVarList.setShowVarLabels(bl, false);
    }

    protected boolean canDispose() {
        return !this.showPendingChangesWarning();
    }

    @Override
    protected boolean canBeRecalled() {
        return false;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.addComponents(jPanel);
        this.setDefaults();
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(this.setTabTraversal(), false));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (MultiResDefineSetsDlg.this.showPendingChangesWarning()) {
                    return;
                }
                MultiResDefineSetsDlg.this.dispose();
            }
        });
        this.pack();
    }

    @Override
    protected boolean cancelPressed() {
        if (!this.showPendingChangesWarning()) {
            BaseProcedureDialog baseProcedureDialog = ProcedureDlgMgr.getMgr().getProcedureDialog("analyze_mult_resp_frequency");
            BaseProcedureDialog baseProcedureDialog2 = ProcedureDlgMgr.getMgr().getProcedureDialog("analyze_mult_resp_crosstabs");
            if (this.mVarSetVector.size() < 1) {
                if (baseProcedureDialog != null && baseProcedureDialog2 != null) {
                    int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_MR_DS_FREQ_CROSS_CLOSING_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eInformation, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
                    if (n == 3 || n == -1) {
                        return false;
                    }
                    baseProcedureDialog.dispose();
                    baseProcedureDialog2.dispose();
                } else if (baseProcedureDialog != null) {
                    int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_MR_DS_FREQ_CLOSING_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eInformation, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
                    if (n == 3 || n == -1) {
                        return false;
                    }
                    baseProcedureDialog.dispose();
                } else if (baseProcedureDialog2 != null) {
                    int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_MR_DS_CROSS_CLOSING_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eInformation, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
                    if (n == 3 || n == -1) {
                        return false;
                    }
                    baseProcedureDialog2.dispose();
                }
            }
            this.saveDialogState();
            ProcedureDlgMgr.getMgr().savePersistentState(this.getIActionKey(), this.getDialogDataModel());
            if (this.canBeRecalled()) {
                ProcedureDlgMgr.getMgr().addRecallItem(this.getTitle(), this.getIActionKey());
            }
            if (this.mVarSetVector.size() > 0) {
                if (baseProcedureDialog != null) {
                    ((MRFrequenciesDlg)baseProcedureDialog).loadMRVariableSets();
                }
                if (baseProcedureDialog2 != null) {
                    ((MultiResCrossTabsDlg)baseProcedureDialog2).loadMRVariableSets();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = super.setupCmdButtonPanel();
        jPanel.remove(this.getOkButton());
        jPanel.remove(this.getPasteButton());
        jPanel.remove(this.getResetButton());
        this.getCancelButton().setText(this.getResString("IDS_MR_DS_CLOSE_BUTTON"));
        this.getRootPane().setDefaultButton(this.getCancelButton());
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    @Override
    protected void saveDialogState() {
        SerializableObject[] serializableObjectArray = new SerializableObject[this.mVarSetVector.size()];
        this.getDialogDataModel().putSerializableArray(MULTI_RES_DEFINE_SET_KEY, this.mVarSetVector.toArray(serializableObjectArray));
    }

    @Override
    protected void loadDialogState() {
        SerializableObject[] serializableObjectArray = this.getDialogDataModel().getSerializableArray(MULTI_RES_DEFINE_SET_KEY);
        if (serializableObjectArray != null) {
            Vector<MRVariableSet> vector = new Vector<MRVariableSet>();
            for (SerializableObject serializableObject : serializableObjectArray) {
                if (!(serializableObject instanceof MRVariableSet)) continue;
                MRVariableSet mRVariableSet = (MRVariableSet)serializableObject;
                boolean bl = true;
                Vector<String> vector2 = mRVariableSet.getVariableNames();
                for (String string : vector2) {
                    if (this.getSpssVar(string) != null) continue;
                    bl = false;
                }
                if (!bl) continue;
                vector.add(mRVariableSet);
            }
            int n = this.mVarSetVector.size() - vector.size();
            this.mVarSetVector = vector;
            if (n > 0) {
                String string = String.format(ComponentState.getSPSSLocale(), this.getResString("ERR_MR_DS_DELETING_SETS_WARNING"), n);
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
                this.saveDialogState();
                ProcedureDlgMgr.getMgr().savePersistentState(this.getIActionKey(), this.getDialogDataModel());
            }
            int n2 = 0;
            for (MRVariableSet mRVariableSet : this.mVarSetVector) {
                this.mMultiResSetsBasicACRWidget.addListItemAt(n2++, "$" + mRVariableSet.getName(IMRVariableSet.ChangeCase.kNoChange));
            }
        }
        this.setVisible(true);
    }

    private void resetAllVars() {
        this.mNameText.setText("");
        this.mLabelText.setText("");
        this.mCountedValText.setText("");
        this.mRangeText.setText("");
        this.mThroughText.setText("");
        this.mDichotomiesRadio.setSelected(true);
        this.mVarInSetList.getModel().removeAll();
        this.mSrcVarList.getModel().removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mMultiResSetsBasicACRWidget.setAddEnabled(false);
        this.mMultiResSetsBasicACRWidget.setChangeEnabled(false);
        this.mMultiResSetsBasicACRWidget.setRemoveEnabled(false);
        this.mMultiResSetsBasicACRWidget.getList().clearSelection();
    }

    private ISpssVariable getSpssVar(String string) {
        ISpssVariable iSpssVariable = null;
        for (int i = 0; i < this.mSrcVarList.getModel().getSize(); ++i) {
            if (!this.mSrcVarList.getModel().getElementAt(i).getName().equalsIgnoreCase(string)) continue;
            iSpssVariable = this.mSrcVarList.getModel().getElementAt(i);
            break;
        }
        return iSpssVariable;
    }

    private boolean categoriesCheck() {
        int n;
        boolean bl = true;
        int n2 = Integer.parseInt(this.mRangeText.getText());
        if (n2 >= (n = Integer.parseInt(this.mThroughText.getText()))) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_MR_DS_SMALLER_RANGE_WARNING"), VersionInfo.getAppVersionString());
            this.mRangeText.setSelectionStart(0);
            this.mRangeText.setSelectionEnd(this.mRangeText.getText().length());
            this.mRangeText.requestFocusInWindow();
            bl = false;
        } else if (n - n2 + 1 > Short.MAX_VALUE) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_MR_DS_EXCEED_CATEGORY_WARNING"), VersionInfo.getAppVersionString());
            this.mRangeText.setSelectionStart(0);
            this.mRangeText.setSelectionEnd(this.mRangeText.getText().length());
            this.mRangeText.requestFocusInWindow();
            bl = false;
        }
        return bl;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mVarInSetList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mVarInSetList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mVarInSetList.setMaxLimitOfList(100);
        this.mVarInSetList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mVarInSetList.getFixedCellHeight() * 5 + 2));
        this.mVarInSetScrollPane = new JScrollPane(this.mVarInSetList);
        this.mVarInSetScrollPane.setPreferredSize(this.mVarInSetList.getMinimumSize());
        this.mVarInSetList.getModel().addListDataListener(this);
        this.mVariablesInSetLabel = DialogUtil.createLabel(this, "IDS_MR_DS_VARIABLES_IN_SET_LABEL");
        this.mVariablesInSetLabel.setLabelFor(this.mVarInSetList);
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mVarInSetList, SpssArrowButton.ButtonOrientation.left);
        ControlAction controlAction = new ToggleButtonAction(this, "IDS_MR_DS_DICHOTOMIES_RADIO");
        this.mDichotomiesRadio = new JRadioButton(controlAction);
        this.mDichotomiesRadio.addItemListener(this);
        controlAction = new ToggleButtonAction(this, "IDS_MR_DS_CATEGORIES_RADIO");
        this.mCategoriesRadio = new JRadioButton(controlAction);
        this.mCategoriesRadio.addItemListener(this);
        this.mButtonGroup = new SpssButtonGroup();
        this.mButtonGroup.add(this.mDichotomiesRadio);
        this.mButtonGroup.add(this.mCategoriesRadio);
        this.mCountedValLabel = DialogUtil.createLabel(this, "IDS_MR_DS_COUNTED_VALUE_LABEL");
        this.mRangeLabel = DialogUtil.createLabel(this, "IDS_MR_DS_RANGE_LABEL");
        this.mThroughLabel = DialogUtil.createLabel(this, "IDS_MR_DS_THROUGH_LABEL");
        this.mCountedValText = new IntTextField(-99, 999, false);
        this.mCountedValText.setColumns(2);
        controlAction = new TextFieldAction(this, COUNTED_VAL_TEXT);
        this.mCountedValText.setAction((Action)controlAction);
        this.mCountedValText.getDocument().addDocumentListener(this);
        this.mCountedValText.addFocusListener((FocusListener)this);
        this.mCountedValLabel.setLabelFor((Component)this.mCountedValText);
        this.mRangeText = new IntTextField(-9999999, 99999999, false);
        this.mRangeText.setColumns(2);
        controlAction = new TextFieldAction(this, RANGE_TEXT);
        this.mRangeText.setAction((Action)controlAction);
        this.mRangeLabel.setLabelFor((Component)this.mRangeText);
        this.mRangeText.getDocument().addDocumentListener(this);
        this.mRangeText.addFocusListener((FocusListener)this);
        this.mThroughText = new IntTextField(-9999999, 99999999, false);
        this.mThroughText.setColumns(2);
        controlAction = new TextFieldAction(this, THROUGH_TEXT);
        this.mThroughText.setAction((Action)controlAction);
        this.mThroughLabel.setLabelFor((Component)this.mThroughText);
        this.mThroughText.getDocument().addDocumentListener(this);
        this.mThroughText.addFocusListener((FocusListener)this);
        this.mNameLabel = DialogUtil.createLabel(this, "IDS_MR_DS_NAME_LABEL");
        this.mLabelLabel = DialogUtil.createLabel(this, "IDS_MR_DS_LABEL_LABEL");
        this.mNameText = new StringTextField();
        controlAction = new TextFieldAction(this, NAME_TEXT);
        this.mNameText.setAction(controlAction);
        this.mNameText.setDocument(new FixedLengthDocument(63));
        this.mNameLabel.setLabelFor((Component)((Object)this.mNameText));
        this.mNameText.getDocument().addDocumentListener(this);
        this.mNameText.addFocusListener(this);
        this.mLabelText = new StringTextField();
        controlAction = new TextFieldAction(this, LABEL_TEXT);
        this.mLabelText.setAction(controlAction);
        this.mLabelText.setDocument(new FixedLengthDocument(40));
        this.mLabelLabel.setLabelFor((Component)((Object)this.mLabelText));
        this.mLabelText.getDocument().addDocumentListener(this);
        this.mLabelText.addFocusListener(this);
        this.mMultiResSetsLabel = DialogUtil.createLabel(this, "IDS_MR_DS_MULT_RESPONSE_SETS_LABEL");
        this.mMultiResSetsBasicACRWidget = new BasicACRWidget(BASIC_ACRWIDGET_ACTION_KEY);
        this.mMultiResSetsBasicACRWidget.addBasicACRListener(this);
        this.mMultiResSetsLabel.setLabelFor(this.mMultiResSetsBasicACRWidget.getList());
        this.mVarSetVector = new Vector();
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mDichotomiesRadio.setSelected(true);
        this.mSrcVarList.setSelectedIndex(0);
    }

    private JPanel setupsetDefnPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_MR_DS_SET_DEFINITION_PANEL_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, DialogUtil.getGroupBoxInnerMargin(), insets.bottom, DialogUtil.getGroupBoxInnerMargin());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_MR_DS_SRCLIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets2.set(0, DialogUtil.getGroupBoxInnerMargin(), insets.bottom, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        Insets insets3 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 23;
        insets2.set(insets.top, DialogUtil.getGroupBoxInnerMargin(), insets.bottom, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, this.mVariablesInSetLabel, gridBagConstraints, 2, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets2.set(0, DialogUtil.getGroupBoxInnerMargin(), insets.bottom, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, this.mVarInSetScrollPane, gridBagConstraints, 2, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets2.set(DialogUtil.getComponentGroupGap(), insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.setupVariablesPanel(), gridBagConstraints, 0, 2, 3, 1, n, insets2);
        insets2.set(DialogUtil.getComponentGroupGap(), 0, DialogUtil.getGroupBoxInnerMargin(), 0);
        DialogUtil.addUsingGBL(jPanel, this.setupNameLabelPanel(), gridBagConstraints, 0, 3, 3, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupRangeThroughPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mRangeLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mRangeText, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mThroughLabel, gridBagConstraints, 2, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mThroughText, gridBagConstraints, 3, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupVariablesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_MR_DS_VARIABLES_ARE_CODED_AS_PANEL_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mDichotomiesRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        Insets insets2 = new Insets(DialogUtil.getGroupBoxInnerMargin(), insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mCountedValLabel, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mCountedValText, gridBagConstraints, 2, 0, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mCategoriesRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setupRangeThroughPanel(), gridBagConstraints, 1, 1, 2, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupNameLabelPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, insets.left * 2, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mNameLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        insets2.set(insets.top, insets.left * 2, insets.bottom, DialogUtil.getGroupBoxInnerMargin());
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mNameText), gridBagConstraints, 1, 0, 1, 1, n, insets2);
        insets2.set(insets.top, insets.left * 2, insets.bottom, insets.right);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mLabelLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets2.set(insets.top, insets.left * 2, insets.bottom, DialogUtil.getGroupBoxInnerMargin());
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mLabelText), gridBagConstraints, 1, 1, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupMultResSetsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = UIToolDialogUtil.getStandardDialogInsets();
        Insets insets2 = new Insets(0, insets.left * 8, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mMultiResSetsLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets2.set(0, insets.left, DialogUtil.getComponentGroupGap(), 0);
        DialogUtil.addUsingGBL(jPanel, this.mMultiResSetsBasicACRWidget, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        return jPanel;
    }

    private void addComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.setupsetDefnPanel(), gridBagConstraints, 0, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, this.setupMultResSetsPanel(), gridBagConstraints, 1, 0, 1, 1, n, null);
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_MR_DS_MULTILINE_LABEL"));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        jTextArea.setMinimumSize(new Dimension(300, 60));
        jTextArea.setPreferredSize(new Dimension(300, 60));
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getGroupBoxInnerMargin() * 4, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 1, 2, 1, n, insets);
        DialogUtil.normalizeLabelWidths(jPanel);
    }

    private void enableVariablesTextField(boolean bl) {
        this.mCountedValLabel.setEnabled(bl);
        this.mCountedValText.setEnabled(bl);
        this.mCountedValText.setOpaque(bl);
        this.mRangeLabel.setEnabled(!bl);
        this.mThroughLabel.setEnabled(!bl);
        this.mRangeText.setEnabled(!bl);
        this.mRangeText.setOpaque(!bl);
        this.mThroughText.setEnabled(!bl);
        this.mThroughText.setOpaque(!bl);
    }

    private boolean isValidVariableName() {
        boolean bl;
        if (this.mNameText.getText().length() > 0) {
            int n = VarNameValidator.validateSPSSName((String)this.mNameText.getText(), (boolean)true).asInt();
            if (n > 0 && n != 100) {
                DialogUtil.showBadSpssVarNameWarning(n, this);
                bl = false;
                this.mNameText.selectAll();
                this.mNameText.requestFocus();
            } else {
                bl = true;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private void enableAddChangeButtons() {
        boolean bl;
        this.mMultiResSetsBasicACRWidget.setRemoveEnabled(false);
        boolean bl2 = this.mNameText.getText().length() > 0;
        boolean bl3 = this.mCountedValText.getText().length() > 0;
        boolean bl4 = this.mRangeText.getText().length() > 0;
        boolean bl5 = this.mThroughText.getText().length() > 0;
        boolean bl6 = this.mVarInSetList.getModel().getSize() >= 2;
        boolean bl7 = this.mMultiResSetsBasicACRWidget.getListSelectedIndex() > -1;
        boolean bl8 = false;
        if (bl7) {
            bl8 = this.mMultiResSetsBasicACRWidget.getListItemAt(this.mMultiResSetsBasicACRWidget.getListSelectedIndex()).toString().substring(1).equals(this.mNameText.getText());
        }
        boolean bl9 = bl = this.mMultiResSetsBasicACRWidget.getList().getModel().getSize() <= 19;
        if (this.mDichotomiesRadio.isSelected()) {
            this.mMultiResSetsBasicACRWidget.setAddEnabled(bl3 && bl6 && bl2 && bl && !bl8);
            this.mMultiResSetsBasicACRWidget.setChangeEnabled(bl3 && bl6 && bl2 && bl && bl7);
        } else if (this.mCategoriesRadio.isSelected()) {
            this.mMultiResSetsBasicACRWidget.setAddEnabled(bl4 && bl5 && bl6 && bl2 && bl && !bl8);
            this.mMultiResSetsBasicACRWidget.setChangeEnabled(bl4 && bl5 && bl6 && bl2 && bl && bl7);
        }
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mVarInSetList);
        vector.add(this.mButtonGroup);
        vector.add(this.mCountedValText);
        vector.add(this.mRangeText);
        vector.add(this.mThroughText);
        vector.add(this.mNameText);
        vector.add(this.mLabelText);
        DialogUtil.addARCWidgetsToTabTraversalVector(this.mMultiResSetsBasicACRWidget, vector);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private void acrAddButtonPressed() {
        if (this.isValidVariableName()) {
            int n;
            String string = this.mNameText.getText();
            if (this.multListContains(string)) {
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_MR_DS_DUPLICATE_NAME_WARNING"), VersionInfo.getAppVersionString());
                this.mNameText.setSelectionStart(0);
                this.mNameText.setSelectionEnd(this.mNameText.getText().length());
                this.mNameText.requestFocusInWindow();
                return;
            }
            MRVariableSet mRVariableSet = new MRVariableSet();
            mRVariableSet.setName(string);
            mRVariableSet.setLabel(this.mLabelText.getText().trim());
            boolean bl = this.mDichotomiesRadio.isSelected();
            if (bl) {
                mRVariableSet.setType(IMRVariableSet.MRVariableSetType.kMR_Dichotomy);
                mRVariableSet.setValue(Integer.parseInt(this.mCountedValText.getText()) + "");
            } else {
                if (!this.categoriesCheck()) {
                    return;
                }
                mRVariableSet.setType(IMRVariableSet.MRVariableSetType.kMR_Category);
                mRVariableSet.setRangeValue(Integer.parseInt(this.mRangeText.getText()) + "");
                mRVariableSet.setThroughValue(Integer.parseInt(this.mThroughText.getText()) + "");
            }
            for (n = 0; n < this.mVarInSetList.getModel().getSize(); ++n) {
                mRVariableSet.addVariableName(this.mVarInSetList.getModel().getElementAt(n).getName());
            }
            this.mVarSetVector.add(mRVariableSet);
            n = this.mMultiResSetsBasicACRWidget.getList().getModel().getSize();
            this.mMultiResSetsBasicACRWidget.addListItemAt(n, "$" + string);
            this.resetAllVars();
            this.mCountedValText.requestFocusInWindow();
        }
    }

    private int acrRemoveButtonPressed() {
        int n = this.mMultiResSetsBasicACRWidget.getListSelectedIndex();
        String string = this.mMultiResSetsBasicACRWidget.getListItemAt(n).toString().substring(1);
        for (MRVariableSet mRVariableSet : this.mVarSetVector) {
            if (!mRVariableSet.getName().equalsIgnoreCase(string)) continue;
            this.mVarSetVector.remove(mRVariableSet);
            break;
        }
        this.mMultiResSetsBasicACRWidget.removeListItemAt(n);
        return n;
    }

    private void acrChangeButtonPressed() {
        if (this.isValidVariableName()) {
            String string = this.mNameText.getText();
            if (this.multListContains(string)) {
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_MR_DS_DUPLICATE_NAME_WARNING"), VersionInfo.getAppVersionString());
                this.mNameText.setSelectionStart(0);
                this.mNameText.setSelectionEnd(this.mNameText.getText().length());
                this.mNameText.requestFocusInWindow();
                return;
            }
            boolean bl = this.mDichotomiesRadio.isSelected();
            if (!bl && !this.categoriesCheck()) {
                return;
            }
            int n = this.mMultiResSetsBasicACRWidget.getListSelectedIndex();
            MRVariableSet mRVariableSet = this.mVarSetVector.get(n);
            if (!mRVariableSet.getName(IMRVariableSet.ChangeCase.kNoChange).equalsIgnoreCase(string)) {
                int n2;
                mRVariableSet = new MRVariableSet();
                mRVariableSet.setName(string);
                mRVariableSet.setLabel(this.mLabelText.getText().trim());
                if (bl) {
                    mRVariableSet.setType(IMRVariableSet.MRVariableSetType.kMR_Dichotomy);
                    mRVariableSet.setValue(Integer.parseInt(this.mCountedValText.getText()) + "");
                } else {
                    mRVariableSet.setType(IMRVariableSet.MRVariableSetType.kMR_Category);
                    mRVariableSet.setRangeValue(Integer.parseInt(this.mRangeText.getText()) + "");
                    mRVariableSet.setThroughValue(Integer.parseInt(this.mThroughText.getText()) + "");
                }
                for (n2 = 0; n2 < this.mVarInSetList.getModel().getSize(); ++n2) {
                    mRVariableSet.addVariableName(this.mVarInSetList.getModel().getElementAt(n2).getName());
                }
                n2 = this.acrRemoveButtonPressed();
                this.mVarSetVector.add(n2, mRVariableSet);
                this.mMultiResSetsBasicACRWidget.addListItemAt(n2, "$" + string);
                this.resetAllVars();
                this.mCountedValText.requestFocusInWindow();
            } else {
                mRVariableSet.setName(string);
                mRVariableSet.setLabel(this.mLabelText.getText().trim());
                if (bl) {
                    mRVariableSet.setType(IMRVariableSet.MRVariableSetType.kMR_Dichotomy);
                    mRVariableSet.setValue(Integer.parseInt(this.mCountedValText.getText()) + "");
                    mRVariableSet.setRangeValue("");
                    mRVariableSet.setThroughValue("");
                } else {
                    mRVariableSet.setType(IMRVariableSet.MRVariableSetType.kMR_Category);
                    mRVariableSet.setRangeValue(Integer.parseInt(this.mRangeText.getText()) + "");
                    mRVariableSet.setThroughValue(Integer.parseInt(this.mThroughText.getText()) + "");
                    mRVariableSet.setValue("");
                }
                Vector<String> vector = mRVariableSet.getVariableNames(IMRVariableSet.ChangeCase.kNoChange);
                for (String string2 : vector) {
                    mRVariableSet.deleteVariable(string2);
                }
                for (int i = 0; i < this.mVarInSetList.getModel().getSize(); ++i) {
                    mRVariableSet.addVariableName(this.mVarInSetList.getModel().getElementAt(i).getName());
                }
                this.mMultiResSetsBasicACRWidget.removeListItemAt(n);
                this.mMultiResSetsBasicACRWidget.addListItemAt(n, "$" + string);
                this.resetAllVars();
                this.mCountedValText.requestFocusInWindow();
            }
        }
    }

    private boolean multListContains(String string) {
        boolean bl = false;
        int n = this.mMultiResSetsBasicACRWidget.getListSelectedIndex();
        int n2 = this.mMultiResSetsBasicACRWidget.getList().getModel().getSize();
        for (int i = 0; i < n2; ++i) {
            if (i == n || !this.mMultiResSetsBasicACRWidget.getListItemAt(i).toString().substring(1).equalsIgnoreCase(string)) continue;
            bl = true;
        }
        return bl;
    }

    private boolean showPendingChangesWarning() {
        int n;
        boolean bl = false;
        if ((this.mMultiResSetsBasicACRWidget.isAddEnabled() || this.mMultiResSetsBasicACRWidget.isChangeEnabled()) && ((n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_MR_DS_PENDING_CHANGES_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) == 3 || n == -1)) {
            bl = true;
        }
        return bl;
    }
}

