/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.multiple_res;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.dialogs.base.analyze.multiple_res.IMRVariableSet;
import com.spss.shared.core_tools.utils.SerializableObject;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class MRVariableSet
implements IMRVariableSet,
SerializableObject {
    private IMRVariableSet.MRVariableSetType mType;
    private Vector<Boolean> mFlags;
    private String mName = "";
    private String mLabel = "";
    private String mValue = "";
    private Vector<String> mVariableNames = new Vector();
    private String mRange = "";
    private String mThrough = "";

    public MRVariableSet(String string) {
        int n;
        String string2 = string;
        this.mFlags = new Vector();
        for (n = 0; n < IMRVariableSet.SetFlags.kFlagCount.ordinal(); ++n) {
            this.mFlags.add(false);
        }
        int n2 = string.indexOf("\r");
        if (n2 > (n = string.indexOf("\n"))) {
            n2 = n;
        }
        if (n2 > string.length()) {
            n2 = string.length();
        }
        if (n > string.length()) {
            n = string.length();
        }
        if (n2 > 0) {
            string2 = string.substring(0, n2);
        } else if (n > 0) {
            string2 = string.substring(0, n);
        }
        if (this.isMrSetType(string2)) {
            this.buildMRSetFromString(this, string2);
        } else {
            this.buildVarSetFromString(this, string2);
        }
    }

    public MRVariableSet() {
        this.mType = IMRVariableSet.MRVariableSetType.kVarSet;
        this.mFlags = new Vector();
        for (int i = 0; i < IMRVariableSet.SetFlags.kFlagCount.ordinal(); ++i) {
            this.mFlags.add(false);
        }
    }

    @Override
    public String getName(IMRVariableSet.ChangeCase changeCase) {
        if (changeCase == IMRVariableSet.ChangeCase.kToLowerCase) {
            return this.mName.toLowerCase(ComponentState.getSPSSLocale());
        }
        if (changeCase == IMRVariableSet.ChangeCase.kToUpperCase) {
            return this.mName.toUpperCase(ComponentState.getSPSSLocale());
        }
        return this.mName;
    }

    @Override
    public String getName() {
        return this.getName(IMRVariableSet.ChangeCase.kToUpperCase);
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public String getLabel(ISpssDataSrc iSpssDataSrc) {
        String string = this.getLabel();
        if (this.qLabelSetByVariable()) {
            boolean bl = false;
            for (int i = 0; i < this.mVariableNames.size() && !bl; ++i) {
                String string2;
                int n = iSpssDataSrc.findVarIndex(this.mVariableNames.get(i));
                if (n < 0 || (string2 = iSpssDataSrc.getVariable(n).getLabel()) == null || string2.length() <= 0) continue;
                string = string2;
                bl = true;
            }
            if (!bl) {
                string = this.mVariableNames.get(0);
            }
        }
        return string;
    }

    @Override
    public IMRVariableSet.MRVariableSetType getType() {
        return this.mType;
    }

    @Override
    public boolean qIsEnhancedDichotomy() {
        return this.getType() == IMRVariableSet.MRVariableSetType.kMR_Dichotomy && this.qUseVariableCategoryLabels();
    }

    @Override
    public String getValue() {
        return this.mValue;
    }

    @Override
    public Vector<String> getVariableNames(IMRVariableSet.ChangeCase changeCase) {
        Vector<String> vector = new Vector<String>();
        for (String string : this.mVariableNames) {
            if (changeCase == IMRVariableSet.ChangeCase.kToLowerCase) {
                vector.add(string.toLowerCase(ComponentState.getSPSSLocale()));
                continue;
            }
            if (changeCase == IMRVariableSet.ChangeCase.kToUpperCase) {
                vector.add(string.toUpperCase(ComponentState.getSPSSLocale()));
                continue;
            }
            if (changeCase != IMRVariableSet.ChangeCase.kNoChange) continue;
            vector.add(string);
        }
        return vector;
    }

    @Override
    public Vector<String> getVariableNames() {
        return this.getVariableNames(IMRVariableSet.ChangeCase.kToUpperCase);
    }

    @Override
    public void setName(String string) {
        this.mName = string;
    }

    @Override
    public void setType(IMRVariableSet.MRVariableSetType mRVariableSetType) {
        this.mType = mRVariableSetType;
    }

    @Override
    public void setFlags(String string) {
        this.mFlags.clear();
        for (int i = 0; i < IMRVariableSet.SetFlags.kFlagCount.ordinal(); ++i) {
            if (i < string.length()) {
                boolean bl = string.charAt(i) != '0';
                this.mFlags.add(i, bl);
                continue;
            }
            this.mFlags.add(i, false);
        }
    }

    @Override
    public String getFlags() {
        int n;
        char[] cArray = new char[IMRVariableSet.SetFlags.kFlagCount.ordinal()];
        for (n = 0; n < IMRVariableSet.SetFlags.kFlagCount.ordinal(); ++n) {
            cArray[n] = 48;
        }
        for (n = 0; n < IMRVariableSet.SetFlags.kFlagCount.ordinal(); ++n) {
            if (!this.mFlags.get(n).booleanValue()) continue;
            cArray[n] = 49;
        }
        return new String(cArray);
    }

    @Override
    public void setLabel(String string) {
        this.mLabel = string;
    }

    @Override
    public void setValue(String string) {
        this.mValue = string;
    }

    @Override
    public void addVariableName(String string) {
        if (string != null && this.mVariableNames != null) {
            boolean bl = false;
            for (String string2 : this.mVariableNames) {
                if (!string2.equalsIgnoreCase(string)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.mVariableNames.add(string);
            }
        }
    }

    @Override
    public boolean isVariableInSet(String string) {
        boolean bl = false;
        if (string != null && this.mVariableNames != null) {
            for (String string2 : this.mVariableNames) {
                if (!string2.equalsIgnoreCase(string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    @Override
    public void deleteVariable(String string) {
        if (this.mVariableNames != null) {
            boolean bl = false;
            int n = 0;
            for (String string2 : this.mVariableNames) {
                if (string2.equalsIgnoreCase(string)) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (bl) {
                this.mVariableNames.removeElementAt(n);
            }
        }
    }

    @Override
    public boolean qLabelSetByVariable() {
        assert (this.mFlags != null && this.mFlags.size() == IMRVariableSet.SetFlags.kFlagCount.ordinal());
        return this.mFlags.get(IMRVariableSet.SetFlags.kLabelSetByVariable.ordinal());
    }

    @Override
    public void labelSetByVariable(boolean bl) {
        assert (this.mFlags != null && this.mFlags.size() == IMRVariableSet.SetFlags.kFlagCount.ordinal());
        this.mFlags.add(IMRVariableSet.SetFlags.kLabelSetByVariable.ordinal(), bl);
    }

    @Override
    public boolean qUseVariableCategoryLabels() {
        assert (this.mFlags != null && this.mFlags.size() == IMRVariableSet.SetFlags.kFlagCount.ordinal());
        return this.mFlags.get(IMRVariableSet.SetFlags.kLabelCatsByValue.ordinal());
    }

    @Override
    public void useVariableCategoryLabels(boolean bl) {
        assert (this.mFlags != null && this.mFlags.size() == IMRVariableSet.SetFlags.kFlagCount.ordinal());
        this.mFlags.add(IMRVariableSet.SetFlags.kLabelCatsByValue.ordinal(), bl);
    }

    @Override
    public int validate() {
        int n = 0;
        if (this.mType == IMRVariableSet.MRVariableSetType.kVarSet) {
            if (this.mName.length() > 64) {
                n = 50000;
            } else if (VarNameValidator.validateSPSSName((String)this.mName, (boolean)false) != VarNameValidator.ValidNameCode.SPSSNAME_STANDARD) {
                n = 50001;
            }
        } else if (this.mName.length() > 64) {
            n = 50000;
        } else if (VarNameValidator.validateSPSSName((String)this.mName, (boolean)false) != VarNameValidator.ValidNameCode.SPSSNAME_SYSTEM) {
            n = 50001;
        }
        if (n == 0 && this.mType == IMRVariableSet.MRVariableSetType.kMR_Dichotomy && this.mValue.length() > 8 && this.mValue.length() == 0) {
            n = 50002;
        }
        if (n == 0 && this.mVariableNames.size() < 2) {
            n = 50004;
        }
        return n;
    }

    @Override
    public String toExtension() {
        String string = this.mType == IMRVariableSet.MRVariableSetType.kVarSet ? this.variableSetToExtension(this) : (this.mType == IMRVariableSet.MRVariableSetType.kMR_Category ? this.categoryMRSetToExtension(this) : (this.mType == IMRVariableSet.MRVariableSetType.kMR_Dichotomy ? this.dichotomyMRSetToExtension(this) : ""));
        return string;
    }

    @Override
    public String getRangeValue() {
        return this.mRange;
    }

    @Override
    public void setRangeValue(String string) {
        this.mRange = string;
    }

    @Override
    public String getThroughValue() {
        return this.mThrough;
    }

    @Override
    public void setThroughValue(String string) {
        this.mThrough = string;
    }

    public String getClassName() {
        return "com.spss.java_client.ui.dialogs.base.analyze.multiple_res.MRVariableSet";
    }

    public boolean readVersionedObject(ObjectInputStream objectInputStream, int n) throws Exception {
        this.mType = IMRVariableSet.MRVariableSetType.fromInt(objectInputStream.readInt());
        this.mFlags = (Vector)objectInputStream.readObject();
        this.mName = objectInputStream.readUTF();
        this.mLabel = objectInputStream.readUTF();
        this.mValue = objectInputStream.readUTF();
        this.mVariableNames = (Vector)objectInputStream.readObject();
        this.mRange = objectInputStream.readUTF();
        this.mThrough = objectInputStream.readUTF();
        return true;
    }

    public boolean writeVersionedObject(ObjectOutputStream objectOutputStream, int n) throws Exception {
        objectOutputStream.writeInt(this.mType.ordinal());
        objectOutputStream.writeObject(this.mFlags);
        objectOutputStream.writeUTF(this.mName);
        objectOutputStream.writeUTF(this.mLabel);
        objectOutputStream.writeUTF(this.mValue);
        objectOutputStream.writeObject(this.mVariableNames);
        objectOutputStream.writeUTF(this.mRange);
        objectOutputStream.writeUTF(this.mThrough);
        return true;
    }

    private boolean isMrSetType(String string) {
        return string.length() > 0 && string.charAt(0) == '$';
    }

    private String ExtractToken(String string, String[] stringArray, char c) {
        String string2 = string;
        if (string.length() == 0) {
            stringArray[0] = "";
            return string2;
        }
        int n = string.indexOf(c);
        if (n > string.length()) {
            n = string.length();
        }
        if (n == -1) {
            stringArray[0] = string;
            return "";
        }
        stringArray[0] = string.substring(0, n);
        string2 = n < string.length() ? string.substring(n + 1) : "";
        return string2;
    }

    private String Extract(String string, String[] stringArray) {
        return this.ExtractToken(string, stringArray, ' ');
    }

    private String Extract(String string, char[] cArray) {
        String string2 = string;
        if (string.length() == 0) {
            cArray[0] = '\u0000';
        } else {
            cArray[0] = string.charAt(0);
            string2 = string.substring(1, string.length());
        }
        return string2;
    }

    private long getSize(String string, String[] stringArray) {
        String[] stringArray2 = new String[1];
        stringArray[0] = this.Extract(string, stringArray2);
        long l = Long.parseLong(stringArray2[0]);
        assert (l != 0L);
        return l;
    }

    private IMRVariableSet.MRVariableSetType convertToEnum(char c) {
        assert (c == 'D' || c == 'C' || c == 'E');
        IMRVariableSet.MRVariableSetType mRVariableSetType = c == 'D' || c == 'E' ? IMRVariableSet.MRVariableSetType.kMR_Dichotomy : IMRVariableSet.MRVariableSetType.kMR_Category;
        return mRVariableSetType;
    }

    private String getString(String string, int n, String[] stringArray) {
        assert (n <= string.length());
        String string2 = string.substring(0, n);
        stringArray[0] = string.substring(n, string.length());
        return string2;
    }

    private String populateNameVarSetType(MRVariableSet mRVariableSet, String string) {
        String[] stringArray = new String[1];
        String string2 = this.ExtractToken(string, stringArray, '=');
        mRVariableSet.setName(stringArray[0]);
        return string2;
    }

    private String populateVariables(MRVariableSet mRVariableSet, String string) {
        String[] stringArray = new String[1];
        String string2 = string;
        while (string2.length() > 0) {
            string2 = this.Extract(string2, stringArray);
            if (stringArray[0].length() <= 0) continue;
            mRVariableSet.addVariableName(stringArray[0]);
        }
        return string2;
    }

    private int buildVarSetFromString(MRVariableSet mRVariableSet, String string) {
        mRVariableSet.setType(IMRVariableSet.MRVariableSetType.kVarSet);
        String string2 = this.populateNameVarSetType(mRVariableSet, string);
        this.populateVariables(mRVariableSet, string2);
        return 0;
    }

    private String populateNameMRSetType(MRVariableSet mRVariableSet, String string) {
        String[] stringArray = new String[1];
        String string2 = this.ExtractToken(string, stringArray, '=');
        assert (stringArray[0].charAt(0) == '$');
        mRVariableSet.setName(stringArray[0]);
        return string2;
    }

    private String populateFlags(MRVariableSet mRVariableSet, String string) {
        char[] cArray = new char[1];
        String[] stringArray = new String[1];
        String string2 = this.Extract(string, cArray);
        assert (cArray[0] == ' ');
        string2 = this.Extract(string2, stringArray);
        mRVariableSet.setFlags(stringArray[0]);
        return string2;
    }

    private String PopulateType(MRVariableSet mRVariableSet, String string) {
        char[] cArray = new char[1];
        String string2 = this.Extract(string, cArray);
        assert (cArray[0] == 'D' || cArray[0] == 'C' || cArray[0] == 'E');
        IMRVariableSet.MRVariableSetType mRVariableSetType = this.convertToEnum(cArray[0]);
        mRVariableSet.setType(mRVariableSetType);
        if (cArray[0] == 'E') {
            string2 = this.populateFlags(mRVariableSet, string2);
        }
        return string2;
    }

    private String populateLabel(MRVariableSet mRVariableSet, String string) {
        char[] cArray = new char[1];
        String string2 = this.Extract(string, cArray);
        assert (cArray[0] == ' ');
        String[] stringArray = new String[1];
        string2 = this.Extract(string2, stringArray);
        int n = Integer.parseInt(stringArray[0]);
        String[] stringArray2 = new String[]{string2};
        assert (n != 0 || stringArray[0].charAt(0) == '0');
        if (n != 0) {
            mRVariableSet.setLabel(this.getString(string2, n, stringArray2));
        }
        string2 = this.Extract(stringArray2[0], cArray);
        assert (cArray[0] == ' ');
        return string2;
    }

    private String populateValue(MRVariableSet mRVariableSet, String string, int n) {
        String[] stringArray = new String[]{""};
        String string2 = this.getString(string, n, stringArray);
        mRVariableSet.setValue(string2);
        return stringArray[0];
    }

    private void buildMRSetFromString(MRVariableSet mRVariableSet, String string) {
        String string2 = this.populateNameMRSetType(mRVariableSet, string);
        string2 = this.PopulateType(mRVariableSet, string2);
        if (mRVariableSet.getType() == IMRVariableSet.MRVariableSetType.kMR_Dichotomy) {
            String[] stringArray = new String[1];
            int n = (int)this.getSize(string2, stringArray);
            string2 = this.populateValue(mRVariableSet, stringArray[0], n);
        }
        string2 = this.populateLabel(mRVariableSet, string2);
        this.populateVariables(mRVariableSet, string2);
    }

    private String varNamesToStream() {
        String string = " ";
        for (String string2 : this.mVariableNames) {
            string = string + string2 + " ";
        }
        if (this.mVariableNames.size() == 0) {
            string = "";
        }
        return string;
    }

    private String categoryMRSetToExtension(MRVariableSet mRVariableSet) {
        String string = "";
        assert (mRVariableSet.getName().charAt(0) == '$');
        string = string + mRVariableSet.getName(IMRVariableSet.ChangeCase.kNoChange);
        string = string + "=C ";
        string = string + mRVariableSet.getLabel().length() + " ";
        string = string + mRVariableSet.getLabel();
        string = string + this.varNamesToStream();
        string = string + '\n';
        return string;
    }

    private String dichotomyMRSetToExtension(MRVariableSet mRVariableSet) {
        String string = "";
        assert (mRVariableSet.getName().charAt(0) == '$');
        string = string + mRVariableSet.getName(IMRVariableSet.ChangeCase.kNoChange);
        if (mRVariableSet.qUseVariableCategoryLabels()) {
            string = string + "=E ";
            string = string + mRVariableSet.getFlags() + ' ';
        } else {
            string = string + "=D";
        }
        assert (mRVariableSet.getValue().length() > 0);
        string = string + mRVariableSet.getValue().length() + " ";
        string = string + mRVariableSet.getValue() + " ";
        if (mRVariableSet.qLabelSetByVariable()) {
            string = string + "0 ";
        } else {
            string = string + mRVariableSet.getLabel().length() + " ";
            string = string + mRVariableSet.getLabel();
        }
        string = string + this.varNamesToStream();
        string = string + '\n';
        return string;
    }

    private String variableSetToExtension(MRVariableSet mRVariableSet) {
        String string = "";
        string = string + mRVariableSet.getName(IMRVariableSet.ChangeCase.kNoChange);
        string = string + "=";
        string = string + this.varNamesToStream();
        string = string + '\n';
        return string;
    }
}

