/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.multiple_res;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.PlainListArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.drag_drop.PlainListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.PlainListDropListener;
import com.spss.java_client.ui.dialogs.base.analyze.multiple_res.IMRVariableSet;
import com.spss.java_client.ui.dialogs.base.analyze.multiple_res.MRVariableSet;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.util.CharacterUtil;
import com.spss.uitools.util.IOptionConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class MRFrequenciesDlg
extends BaseProcedureDialog
implements ListDataListener {
    private static final String SRC_VARIABLE_LIST = "MULT_RESPONSE_FRQ_SRC_LIST";
    private static final String TARGET_VARIABLE_LIST = "MULTIPLE_RESPONSE_FREQ_TARGET_LIST";
    private static final String EXCLUDE_DICHOTOMIES_CHECK_KEY = "IDS_MR_FREQ_EXCLUDED_CASE_WITHIN_DICHOTOMIES_CHECK";
    private static final String EXCLUDE_CATEGORIES_CHECK_KEY = "IDS_MR_FREQ_EXCLUDED_CASE_WITHIN_CATEGORIES_CHECK";
    private PlainList mSrcVarList;
    private PlainList mTargetVarList;
    private PlainListArrowButton mArrowButton;
    private JCheckBox mExcludeWithInDichotomiesCheck;
    private JCheckBox mExcludeWithInCategoriesCheck;

    public MRFrequenciesDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle.getDefaultResourceBundleName(), AnalyzeResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_MR_FREQUENCIES_TITLE"));
    }

    @Override
    public boolean okPastePressed() {
        boolean bl = true;
        if (this.checkVarCount()) {
            bl = false;
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("IDS_MAX_VAR_WARNING"), VersionInfo.getAppVersionString());
        }
        return bl;
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("MULT RESPONSE"));
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("\n" + SyntaxUtil.getSubCommand("/FREQUENCIES="));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("GROUPS="));
        DefaultListModel defaultListModel = (DefaultListModel)this.mTargetVarList.getModel();
        int n = defaultListModel.getSize();
        for (int i = 0; i < n; ++i) {
            MRVariableSet mRVariableSet = (MRVariableSet)defaultListModel.getElementAt(i);
            String string = mRVariableSet.getName(IMRVariableSet.ChangeCase.kNoChange);
            stringBuffer.append("$" + string);
            stringBuffer2.append("$" + string);
            if (!mRVariableSet.getLabel().equals("")) {
                stringBuffer.append(" " + CharacterUtil.smartQuote((String)mRVariableSet.getLabel()));
            }
            stringBuffer.append(" (");
            Vector<String> vector = mRVariableSet.getVariableNames(IMRVariableSet.ChangeCase.kToLowerCase);
            for (String string2 : vector) {
                stringBuffer.append(string2);
                stringBuffer.append(" ");
            }
            stringBuffer.append("(");
            if (mRVariableSet.getType().equals((Object)IMRVariableSet.MRVariableSetType.kMR_Dichotomy)) {
                stringBuffer.append(mRVariableSet.getValue());
            } else {
                stringBuffer.append(mRVariableSet.getRangeValue());
                stringBuffer.append(",");
                stringBuffer.append(mRVariableSet.getThroughValue());
            }
            stringBuffer.append("))");
            if (i >= n - 1) continue;
            stringBuffer.append(" ");
            stringBuffer2.append(" ");
        }
        stringBuffer.append(stringBuffer2.toString());
        String string = "";
        if (this.mExcludeWithInDichotomiesCheck.isSelected() || this.mExcludeWithInCategoriesCheck.isSelected()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/MISSING="));
            if (this.mExcludeWithInDichotomiesCheck.isSelected()) {
                string = "MDGROUP ";
            }
            if (this.mExcludeWithInCategoriesCheck.isSelected()) {
                string = string + "MRGROUP";
            }
            string = string.trim();
        }
        stringBuffer.append(string);
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getIActionKey() {
        return "analyze_mult_resp_frequency";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_mulf";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
        ((DefaultListModel)this.mTargetVarList.getModel()).removeAllElements();
        DefaultListModel defaultListModel = (DefaultListModel)this.mSrcVarList.getModel();
        defaultListModel.removeAllElements();
        DialogDataModel dialogDataModel = new DialogDataModel();
        ProcedureDlgMgr.getMgr().loadPersistentState("analyze_mult_resp_def_sets", dialogDataModel);
        SerializableObject[] serializableObjectArray = dialogDataModel.getSerializableArray("MULTI_RES_DEFINE_SET_KEY");
        if (serializableObjectArray != null) {
            for (SerializableObject serializableObject : serializableObjectArray) {
                if (!(serializableObject instanceof MRVariableSet)) continue;
                defaultListModel.addElement(serializableObject);
            }
        }
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.loadMRVariableSets();
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
    }

    public void loadMRVariableSets() {
        DialogDataModel dialogDataModel = new DialogDataModel();
        ProcedureDlgMgr.getMgr().loadPersistentState("analyze_mult_resp_def_sets", dialogDataModel);
        SerializableObject[] serializableObjectArray = dialogDataModel.getSerializableArray("MULTI_RES_DEFINE_SET_KEY");
        if (serializableObjectArray != null) {
            Vector<MRVariableSet> vector = new Vector<MRVariableSet>();
            for (SerializableObject serializableObject : serializableObjectArray) {
                if (!(serializableObject instanceof MRVariableSet)) continue;
                vector.add((MRVariableSet)serializableObject);
            }
            DefaultListModel defaultListModel = (DefaultListModel)this.mTargetVarList.getModel();
            int n = defaultListModel.getSize();
            ArrayList<MRVariableSet> arrayList = new ArrayList<MRVariableSet>();
            for (int i = 0; i < n; ++i) {
                arrayList.add((MRVariableSet)defaultListModel.getElementAt(i));
            }
            defaultListModel.removeAllElements();
            for (MRVariableSet object : arrayList) {
                if (!vector.contains(object)) continue;
                defaultListModel.addElement(object);
                vector.remove(object);
            }
            DefaultListModel defaultListModel2 = (DefaultListModel)this.mSrcVarList.getModel();
            defaultListModel2.removeAllElements();
            for (MRVariableSet mRVariableSet : vector) {
                defaultListModel2.addElement(mRVariableSet);
            }
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.setupViewPanel(), gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getComponentGroupGap();
        insets = new Insets(insets.top, insets.bottom, insets.bottom, 6 * n2);
        DialogUtil.addUsingGBL(jPanel, this.setupMissingValuesPanel(), gridBagConstraints, 0, 1, 2, 1, n, insets);
        this.setTabTraversalPolicy();
        this.pack();
    }

    private void setDefaults() {
        this.mSrcVarList.requestFocusInWindow();
        this.mSrcVarList.setSelectedIndex(0);
        this.mExcludeWithInCategoriesCheck.setSelected(false);
        this.mExcludeWithInDichotomiesCheck.setSelected(false);
    }

    @Override
    public void pack() {
        super.pack();
        if (this.getGlassPane() instanceof DragPane) {
            this.addDragAdapters();
        }
    }

    private void setTabTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetVarList);
        vector.add(this.mExcludeWithInDichotomiesCheck);
        vector.add(this.mExcludeWithInCategoriesCheck);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void initVars() {
        this.mSrcVarList = new PlainList(SRC_VARIABLE_LIST);
        this.mTargetVarList = new PlainList(TARGET_VARIABLE_LIST);
        this.mTargetVarList.getModel().addListDataListener(this);
        MRFrequnciesListCellRenderer mRFrequnciesListCellRenderer = new MRFrequnciesListCellRenderer();
        this.mSrcVarList.setCellRenderer(mRFrequnciesListCellRenderer);
        MRFrequnciesListCellRenderer mRFrequnciesListCellRenderer2 = new MRFrequnciesListCellRenderer();
        this.mTargetVarList.setCellRenderer(mRFrequnciesListCellRenderer2);
        this.mArrowButton = new PlainListArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, EXCLUDE_DICHOTOMIES_CHECK_KEY);
        this.mExcludeWithInDichotomiesCheck = new JCheckBox();
        this.mExcludeWithInDichotomiesCheck.setAction(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, EXCLUDE_CATEGORIES_CHECK_KEY);
        this.mExcludeWithInCategoriesCheck = new JCheckBox();
        this.mExcludeWithInCategoriesCheck.setAction(toggleButtonAction);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mExcludeWithInDichotomiesCheck);
        spssButtonGroup.add(this.mExcludeWithInCategoriesCheck);
    }

    private void addDragAdapters() {
        DragPane dragPane = (DragPane)this.getGlassPane();
        PlainListDragAdapter plainListDragAdapter = new PlainListDragAdapter(this.mSrcVarList, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(this.mSrcVarList, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(this.mSrcVarList, this.mPlainListVarMoveHandler));
        plainListDragAdapter = new PlainListDragAdapter(this.mTargetVarList, dragPane, "PlainList");
        DialogUtil.modifyMouseInputListeners(this.mTargetVarList, plainListDragAdapter);
        dragPane.addDropListener((IDropListener)new PlainListDropListener(this.mTargetVarList, this.mPlainListVarMoveHandler));
    }

    private JPanel setupViewPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_MR_FREQ_MULT_RESPONSE_SET_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_MR_FREQ_TABLES_FOR_LABEL");
        jLabel2.setLabelFor(this.mTargetVarList);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane2 = new JScrollPane(this.mTargetVarList);
        jScrollPane2.setPreferredSize(this.mTargetVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane2, gridBagConstraints, 2, 1, 1, 1, n, null);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        int n2 = DialogUtil.getComponentGroupGap();
        insets = new Insets(0, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupMissingValuesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_MR_FREQ_MISSING_VALUES_TITLE"));
        jPanel.setBorder(titledBorder);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mExcludeWithInDichotomiesCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mExcludeWithInCategoriesCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private boolean checkVarCount() {
        MRVariableSet mRVariableSet = null;
        Vector<String> vector = null;
        int n = 0;
        DefaultListModel defaultListModel = (DefaultListModel)this.mTargetVarList.getModel();
        int n2 = defaultListModel.getSize();
        for (int i = 0; i < n2; ++i) {
            mRVariableSet = (MRVariableSet)defaultListModel.getElementAt(i);
            vector = mRVariableSet.getVariableNames();
            n += vector.size();
        }
        return n > 100;
    }

    private class MRFrequnciesListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private Border mNoFocusBorder = new EmptyBorder(1, 1, 1, 1);
        private boolean mShowVarLabels;

        public MRFrequnciesListCellRenderer() {
            this.setBorder(this.mNoFocusBorder);
            this.setOpaque(true);
            Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
            Preferences preferences2 = preferences.node("options");
            Preferences preferences3 = preferences2.node("general");
            this.mShowVarLabels = preferences3.get("var_list_display", "").equals(IOptionConstants.VAR_LIST_DISPLAY_VALUES[0]);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2;
            URL uRL = null;
            String string = "";
            if (this.mShowVarLabels) {
                uRL = this.getImageURL((IMRVariableSet)object);
                object2 = ((IMRVariableSet)object).getLabel();
                if (!((String)object2).equals("")) {
                    string = string + (String)object2 + " ";
                }
                string = string + "[$" + ((IMRVariableSet)object).getName(IMRVariableSet.ChangeCase.kNoChange) + "]";
            } else {
                uRL = this.getImageURL((IMRVariableSet)object);
                string = "$" + ((IMRVariableSet)object).getName(IMRVariableSet.ChangeCase.kNoChange);
            }
            this.setIcon(new ImageIcon(uRL));
            this.setText(string);
            if (bl) {
                if (jList.hasFocus()) {
                    this.setBackground(jList.getSelectionBackground());
                    this.setForeground(jList.getSelectionForeground());
                } else {
                    this.setBackground(Color.lightGray);
                    this.setForeground(Color.black);
                }
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            object2 = null;
            if (bl2) {
                if (bl) {
                    object2 = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
                }
                if (object2 == null) {
                    object2 = UIManager.getBorder("List.focusCellHighlightBorder");
                }
            } else {
                object2 = this.mNoFocusBorder;
            }
            this.setBorder((Border)object2);
            this.setOpaque(true);
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }

        private URL getImageURL(IMRVariableSet iMRVariableSet) {
            URL uRL = null;
            if (iMRVariableSet.getType() == IMRVariableSet.MRVariableSetType.kMR_Dichotomy) {
                uRL = MRFrequenciesDlg.this.getResImageURL("IDS_MR_FREQ_DICHOTOMY_IMAGE");
            }
            if (iMRVariableSet.getType() == IMRVariableSet.MRVariableSetType.kMR_Category) {
                uRL = MRFrequenciesDlg.this.getResImageURL("IDS_MR_FREQ_CATEGORY_IMAGE");
            }
            return uRL;
        }
    }
}

