/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.generalized_estm_eqn;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.ListTravArrowButtonFactory;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.ExponentialDoc;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.GEEVarListDropListener;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.StatisticsTab;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.TypeOfModelTab;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.generalized_estm_eqn.GeneralizedEstimatingEquationsDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.Document;

public class RepeatedTab
extends BaseProcedureTab
implements ItemListener,
ListDataListener,
FocusListener {
    private static final int MAX_VAL_M_TEXT = Integer.MAX_VALUE;
    private static final int MIN_VAL_M_TEXT = 0;
    private static final String SORT_CASES_KEY = "IDS_GLM_SORT_CASE";
    private static final String ADJUST_ESTIMATOR_KEY = "IDS_GLM_ADJUST_ESTIMATOR";
    private static final String UPDATE_MATRIX_KEY = "IDS_GLM_UPDATE_MATRIX";
    private static final String CHANGES_IN_PARAM_KEY = "IDS_GLM_CHANGE_IN_PARAM";
    private static final String HESSIAN_CONVERGANCE_KEY = "IDS_GLM_HESSIAN_CONVERGENCE";
    private static final String ROBUST_KEY = "IDS_GLM_ROBUST_ESTIMATOR";
    private static final String MODEL_BASED_KEY = "IDS_GLM_MODEL_BASED_ESTIMATOR";
    private static final String MAX_ITERATION_DEFAULT_VALUE = "100";
    private static final String ITERATION_UPDATES_DEFAULT_VALUE = "1";
    private static final String SUBJECT_TARGET_LIST_KEY = "IDS_GLM_SUBJECT_TARGET_LIST_KEY";
    private static final String WITHIN_SUB_TARGET_LIST_KEY = "IDS_GLM_WITHIN_SUB_TARGET_LIST_KEY";
    private static final String STRUCTURE_COMBO_KEY = "IDS_GLM_STRUCTURE_COMBO_KEY";
    private static final String M_FIELD_KEY = "IDS_GLM_M_FIELD_KEY";
    private static final String MAX_ITERATION_FIELD_KEY = "IDS_GLM_MAX_ITERATION_FIELD_KEY";
    private static final String ITERATION_UPDATES_KEY = "IDS_GLM_ITERATION_UPDATES_KEY";
    private static final String CHANGE_IN_PARAM_FIELD_KEY = "IDS_GLM_CHANGE_IN_PARAM_FIELD_KEY";
    private static final String HESSIAN_FIELD_KEY = "IDS_GLM_HESSIAN_FIELD_KEY";
    private static final String TYPE_COMBO_KEY = "IDS_GLM_TYPE_COMBO_KEY";
    private static final String SOURCE_LIST_KEY = "IDS_GLM_VAR_SOURCE_LIST_KEY";
    private static final String CHANGE_IN_PARAM_DEFAULT_VAL = "1E-006";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mSubjectTargetVarList;
    private TargetVariableList mWithInSubjectTargetVarList;
    private ArrowButton mSubjectArrow;
    private ArrowButton mWithInSubjectArrow;
    private JPanel mSubjectUpAndDownArrowPanel;
    private JPanel mWithInSubjectUpAndDownArrowPanel;
    private JRadioButton mRobustRadio;
    private JRadioButton mModelBasedRadio;
    private JCheckBox mSortCasesCheck;
    private JCheckBox mAdjustEstimatorCheck;
    private JCheckBox mUpdateMatrixCheck;
    private JCheckBox mChangesInParamCheck;
    private JCheckBox mHessianCheck;
    private JLabel mMLabel;
    private JLabel mMaxIterationLabel;
    private JLabel mIterationUpdatesLabel;
    private JPanel mConvergencePanel;
    private JLabel mAtleastLabel;
    private JLabel mMinimumLabel;
    private JLabel mTypeLabel;
    private JLabel mAbsoluteLabel;
    private IntTextField mMField;
    private IntTextField mMaxIterationsField;
    private IntTextField mIterationsUpdatesField;
    private ContextEnabledTextField mChangeInParamField;
    private ContextEnabledTextField mHessianField;
    private JComboBox mStructureCombo;
    private JComboBox mTypeCombo;
    private SpssButtonGroup mCovarianceMatrixGrp;
    private Vector<Object> mComponent;
    ListTravArrowButtonFactory mSubListArrowButtonFactory;
    ListTravArrowButtonFactory mWithInSublistArrowButtonFactory;

    public RepeatedTab(BaseTabbedDialog baseTabbedDialog) {
        super(baseTabbedDialog, true);
    }

    public static JPanel setUpListPanel(JComponent[] jComponentArray) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(jComponentArray[2]);
        jScrollPane.setPreferredSize(jComponentArray[2].getMinimumSize());
        ((JLabel)jComponentArray[0]).setLabelFor(jComponentArray[2]);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 10;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, jComponentArray[1], gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jComponentArray[0], gridBagConstraints, 2, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 1, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = new Insets(0, DialogUtil.getComponentGroupGap(), 0, UIToolDialogUtil.getStandardDialogInsets().right);
        DialogUtil.addUsingGBL(jPanel, jComponentArray[3], gridBagConstraints, 3, 1, 1, 1, n, insets2);
        return jPanel;
    }

    @Override
    public void reset() {
        this.setDefaults();
        this.mSubjectTargetVarList.removeAll();
        this.mWithInSubjectTargetVarList.removeAll();
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mSrcVarList;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_gee_repeated";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mUpdateMatrixCheck) {
            if (itemEvent.getStateChange() == 1) {
                this.mIterationUpdatesLabel.setEnabled(true);
                this.mIterationsUpdatesField.setEnabled(true);
            } else {
                this.mIterationsUpdatesField.setEnabled(false);
                this.mIterationUpdatesLabel.setEnabled(false);
            }
        }
        this.enableComponent();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.setEnableSortCasesCheck(listDataEvent);
        this.mSortCasesCheck.setSelected(true);
        ((GeneralizedEstimatingEquationsDlg)this.mParent).getResponseTab().updateOkPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.setEnableSortCasesCheck(listDataEvent);
        ((GeneralizedEstimatingEquationsDlg)this.mParent).getResponseTab().updateOkPaste();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.setEnableSortCasesCheck(listDataEvent);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mHessianField)) {
            this.mHessianField.selectAll();
        } else if (focusEvent.getSource().equals(this.mMField)) {
            this.mMField.selectAll();
        } else if (focusEvent.getSource().equals(this.mChangeInParamField)) {
            this.mChangeInParamField.selectAll();
        } else if (focusEvent.getSource().equals(this.mMaxIterationsField)) {
            this.mMaxIterationsField.selectAll();
        } else if (focusEvent.getSource().equals(this.mIterationsUpdatesField)) {
            this.mIterationsUpdatesField.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    public TargetVariableList getSubjectVarList() {
        return this.mSubjectTargetVarList;
    }

    public TargetVariableList getWithInSubjectVarList() {
        return this.mWithInSubjectTargetVarList;
    }

    public void enableComponent() {
        boolean bl = this.mStructureCombo.getSelectedIndex() == 0;
        TypeOfModelTab typeOfModelTab = ((GeneralizedEstimatingEquationsDlg)this.mParent).getTypeOfModelTab();
        if (bl && typeOfModelTab != null) {
            bl = typeOfModelTab.isLinearSelected() || typeOfModelTab.isNormalSelected() && typeOfModelTab.isLinkSelected(this.getResStringArray("IDS_GLM_LINK_FUNCTION_VALUES2")[0]);
        }
        this.mMField.setEnabled(this.mStructureCombo.getSelectedIndex() == 3);
        this.mMField.setOpaque(this.mStructureCombo.getSelectedIndex() == 3);
        this.mMLabel.setEnabled(this.mStructureCombo.getSelectedIndex() == 3);
        this.mMaxIterationLabel.setEnabled(!bl);
        this.mMaxIterationsField.setEnabled(!bl);
        this.mUpdateMatrixCheck.setEnabled(!bl);
        this.mIterationsUpdatesField.setEnabled(this.mUpdateMatrixCheck.isEnabled() && this.mUpdateMatrixCheck.isSelected());
        this.mIterationsUpdatesField.setOpaque(this.mUpdateMatrixCheck.isEnabled() && this.mUpdateMatrixCheck.isSelected());
        this.mIterationUpdatesLabel.setEnabled(this.mUpdateMatrixCheck.isEnabled() && this.mUpdateMatrixCheck.isSelected());
        if (this.mConvergencePanel != null) {
            this.mConvergencePanel.getComponent(0).setEnabled(!bl);
        }
        this.mAtleastLabel.setEnabled(!bl);
        this.mChangesInParamCheck.setEnabled(!bl);
        boolean bl2 = this.mChangesInParamCheck.isSelected() && this.mChangesInParamCheck.isEnabled();
        this.mChangeInParamField.setEnabled(bl2);
        this.mMinimumLabel.setEnabled(bl2);
        this.mChangeInParamField.setOpaque(bl2);
        this.mTypeLabel.setEnabled(bl2);
        this.mTypeCombo.setEnabled(bl2);
        this.mHessianCheck.setEnabled(!bl);
        bl2 = this.mHessianCheck.isEnabled() && this.mHessianCheck.isSelected();
        this.mHessianField.setEnabled(bl2);
        this.mHessianField.setOpaque(bl2);
        this.mAbsoluteLabel.setEnabled(bl2);
    }

    public SrcVariableList getSrcVariableList() {
        return this.mSrcVarList;
    }

    public boolean isValidateTabFields() {
        double d;
        if (this.mStructureCombo.getSelectedIndex() == 3) {
            if (this.mMField.getText().equals("")) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_M_EMPTY_WARNING_MSG"), VersionInfo.getAppVersionString());
                this.setSelectionText((JTextField)this.mMField);
                return false;
            }
            if (this.mMField.isEnabled()) {
                d = Double.parseDouble(this.mMField.getText());
                if (d == 0.0) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_M_ZERO_WARNING_MSG"), VersionInfo.getAppVersionString());
                    this.setSelectionText((JTextField)this.mMField);
                    return false;
                }
                if (d > 2.147483647E9) {
                    return false;
                }
            }
        }
        if (this.mMaxIterationsField.isEnabled()) {
            if (this.mMaxIterationsField.getText().equals("")) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_MAX_ITER_EMPTY_WARNING_MSG"), VersionInfo.getAppVersionString());
                this.setSelectionText((JTextField)this.mMaxIterationsField);
                return false;
            }
            try {
                long l = Long.parseLong(this.mMaxIterationsField.getText());
                if (l < 0L || l > Integer.MAX_VALUE) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        if (this.mUpdateMatrixCheck.isEnabled()) {
            if (this.mIterationsUpdatesField.getText().equals("")) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_ITERATION_UPDATES_EMPTY_WARNING_MSG"), VersionInfo.getAppVersionString());
                this.setSelectionText((JTextField)this.mIterationsUpdatesField);
                return false;
            }
            d = Double.parseDouble(this.mIterationsUpdatesField.getText());
            if (d == 0.0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_ITERATION_UPDATES_ZERO_WARNING_MSG"), VersionInfo.getAppVersionString());
                this.setSelectionText((JTextField)this.mIterationsUpdatesField);
                return false;
            }
        }
        if (this.mMaxIterationsField.isEnabled() && this.mIterationsUpdatesField.isEnabled()) {
            d = Double.parseDouble(this.mMaxIterationsField.getText());
            double d2 = Double.parseDouble(this.mIterationsUpdatesField.getText());
            if (d2 > 2.147483647E9) {
                return false;
            }
            if (d < d2) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_MAX_ITERATION_GREATER_WARNING_MSG"), VersionInfo.getAppVersionString());
                this.setSelectionText((JTextField)this.mIterationsUpdatesField);
                return false;
            }
        }
        if (this.mChangesInParamCheck.isEnabled() && this.mChangesInParamCheck.isSelected()) {
            if (this.mChangeInParamField.getText().equals("")) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_CHANGE_IN_PARAM_EMPTY_WARNING_MSG"), VersionInfo.getAppVersionString());
                this.setSelectionText((JTextField)this.mChangeInParamField);
                return false;
            }
            if (DialogUtil.parseDouble(this.mChangeInParamField.getText()) == null) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_CHANGE_IN_PARAM_ZERO_WARNING_MSG"), VersionInfo.getAppVersionString());
                this.setSelectionText((JTextField)this.mChangeInParamField);
                return false;
            }
        }
        if (this.mHessianCheck.isEnabled() && this.mHessianCheck.isSelected()) {
            if (this.mHessianField.getText().equals("")) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_HESSIAN_CONVERGENCE_EMPTY_WARNING_MSG"), VersionInfo.getAppVersionString());
                this.setSelectionText((JTextField)this.mHessianField);
                return false;
            }
            if (DialogUtil.parseDouble(this.mHessianField.getText()) == null) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_HESSIAN_CONVERGENCE_ZERO_WARNING_MSG"), VersionInfo.getAppVersionString());
                this.setSelectionText((JTextField)this.mHessianField);
                return false;
            }
        }
        if (this.mStructureCombo.getSelectedIndex() != 0 && !this.mHessianCheck.isSelected() && !this.mChangesInParamCheck.isSelected()) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_ATLEAST_ONE_CONVERGENCE_WARNING_MSG"), VersionInfo.getAppVersionString());
            return false;
        }
        return true;
    }

    String getGeneratedSyntax() {
        this.enableComponent();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SyntaxUtil.getSubCommand("/REPEATED"));
        if (this.mSubjectTargetVarList.getModel().getSize() > 0) {
            stringBuffer.append(" SUBJECT=").append(this.getVariablesList(this.mSubjectTargetVarList));
        }
        if (this.mWithInSubjectTargetVarList.getModel().getSize() > 0) {
            stringBuffer.append(" WITHINSUBJECT=").append(this.getVariablesList(this.mWithInSubjectTargetVarList));
        }
        if (this.mSortCasesCheck.isSelected()) {
            stringBuffer.append(" SORT=YES");
        } else {
            stringBuffer.append(" SORT=NO");
        }
        Map map = RepeatedTab.getStructurenMap();
        String string = map.get(this.mStructureCombo.getSelectedIndex()).toString();
        stringBuffer.append(" CORRTYPE=").append(string);
        if (this.mStructureCombo.getSelectedIndex() == 3) {
            stringBuffer.append("(").append(this.mMField.getText()).append(")");
        }
        if (this.mAdjustEstimatorCheck.isSelected()) {
            stringBuffer.append(" ADJUSTCORR=YES");
        } else {
            stringBuffer.append(" ADJUSTCORR=NO");
        }
        if (this.mRobustRadio.isSelected()) {
            stringBuffer.append(" COVB=ROBUST");
        } else {
            stringBuffer.append(" COVB=MODEL");
        }
        if (this.mHessianCheck.isSelected() && this.mHessianCheck.isEnabled()) {
            stringBuffer.append(" HCONVERGE=").append(UIToolResUtil.removeLocale((String)this.mHessianField.getText()));
        }
        if (this.mMaxIterationsField.isEnabled() && this.mMaxIterationsField.getText().length() > 0) {
            stringBuffer.append(" MAXITERATIONS=").append(this.mMaxIterationsField.getText());
        }
        if (this.mChangesInParamCheck.isSelected() && this.mChangesInParamCheck.isEnabled()) {
            stringBuffer.append(" PCONVERGE=").append(UIToolResUtil.removeLocale((String)this.mChangeInParamField.getText().toLowerCase()));
            if (this.mTypeCombo.getSelectedIndex() == 0) {
                stringBuffer.append("(ABSOLUTE)");
            } else {
                stringBuffer.append("(RELATIVE)");
            }
        }
        if (this.mUpdateMatrixCheck.isSelected() && this.mUpdateMatrixCheck.isEnabled()) {
            stringBuffer.append(" UPDATECORR=").append(this.mIterationsUpdatesField.getText());
        }
        return stringBuffer.toString();
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.setDefaults();
        this.setFocusTraversalPolicy();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = 23;
        Insets insets = new Insets(2, UIToolDialogUtil.getStandardDialogInsets().left, UIToolDialogUtil.getStandardDialogInsets().bottom, 0);
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_GLM_SUBJECT_VARIABLE");
        JLabel jLabel2 = DialogUtil.createLabel(this.mParent, "IDS_GLM_VARIABLE_DOT");
        JComponent[] jComponentArray = new JComponent[]{jLabel2, this.mSrcVarList};
        DialogUtil.addUsingGBL(this, this.setUpSourceListPanel(jComponentArray), gridBagConstraints, 0, 0, 1, 5, n2, insets);
        insets.set(2, 0, 0, 0);
        JComponent[] jComponentArray2 = new JComponent[]{jLabel, this.mSubjectArrow, this.mSubjectTargetVarList, this.mSubjectUpAndDownArrowPanel};
        DialogUtil.addUsingGBL(this, RepeatedTab.setUpListPanel(jComponentArray2), gridBagConstraints, 1, 0, 1, 1, n2, insets);
        JLabel jLabel3 = DialogUtil.createLabel(this.mParent, "IDS_GLM_WITHIN_SUBJECT_VARS");
        JComponent[] jComponentArray3 = new JComponent[]{jLabel3, this.mWithInSubjectArrow, this.mWithInSubjectTargetVarList, this.mWithInSubjectUpAndDownArrowPanel};
        DialogUtil.addUsingGBL(this, RepeatedTab.setUpListPanel(jComponentArray3), gridBagConstraints, 1, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(n / 2, insets2.left, 0, UIToolDialogUtil.getStandardDialogInsets().right);
        DialogUtil.addUsingGBL(this, this.mSortCasesCheck, gridBagConstraints, 1, 2, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(this, this.setUpcovarianceMatrixPanel(), gridBagConstraints, 1, 3, 1, 1, n2, insets);
        insets.set(n / 2, insets2.left, UIToolDialogUtil.getStandardDialogInsets().bottom, UIToolDialogUtil.getStandardDialogInsets().right);
        DialogUtil.addUsingGBL(this, this.setUpWorkingCorrelationPanel(), gridBagConstraints, 1, 4, 1, 1, n2, insets);
    }

    @Override
    protected void aboutToShowTab() {
        Component component;
        if (((GeneralizedEstimatingEquationsDlg)this.mParent).getResponseTab() != null) {
            if (((GeneralizedEstimatingEquationsDlg)this.mParent).getResponseTab().getDependentVariableList().getModel().getSize() == 1) {
                this.mSrcVarList.getModel().removeElement(((GeneralizedEstimatingEquationsDlg)this.mParent).getResponseTab().getDependentVariableList().getModel().getElementAt(0));
            }
            if (((GeneralizedEstimatingEquationsDlg)this.mParent).getResponseTab().getTrialVariableList().getModel().getSize() == 1) {
                this.mSrcVarList.getModel().removeElement(((GeneralizedEstimatingEquationsDlg)this.mParent).getResponseTab().getTrialVariableList().getModel().getElementAt(0));
            }
        }
        if ((component = ((GeneralizedEstimatingEquationsDlg)((Object)this.getTopLevelAncestor())).getGlassPane()) instanceof DragPane) {
            DragPane dragPane = (DragPane)component;
            dragPane.getDropListeners().removeAllElements();
            dragPane.addDropListener((IDropListener)new GEEVarListDropListener(this.mSrcVarList));
            dragPane.addDropListener((IDropListener)new GEEVarListDropListener(this.mSubjectTargetVarList));
            dragPane.addDropListener((IDropListener)new GEEVarListDropListener(this.mWithInSubjectTargetVarList));
        }
        this.mSubjectArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mWithInSubjectArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
    }

    @Override
    protected boolean validateTab() {
        return this.isValidateTabFields();
    }

    private static Map getStructurenMap() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(0, "INDEPENDENT");
        hashMap.put(1, "AR(1)");
        hashMap.put(2, "EXCHANGEABLE");
        hashMap.put(3, "MDEPENDENT");
        hashMap.put(4, "UNSTRUCTURED");
        return hashMap;
    }

    private JPanel setUpSourceListPanel(JComponent[] jComponentArray) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ((JLabel)jComponentArray[0]).setLabelFor(jComponentArray[1]);
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jComponentArray[0], gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(jComponentArray[1]);
        jScrollPane.setPreferredSize(jComponentArray[1].getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        return jPanel;
    }

    private JPanel setUpcovarianceMatrixPanel() {
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n, 0, n);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 23;
        gridBagConstraints.fill = 0;
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_GLM_REPEATED_COVARIANCE_MATRIX"));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mRobustRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(0, n * 8, 0, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, this.mModelBasedRadio, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        return jPanel;
    }

    private JPanel setUpStructurePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = 23;
        gridBagConstraints.fill = 0;
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_GLM_STRUCTURE_DOT");
        jLabel.setLabelFor(this.mStructureCombo);
        Insets insets = new Insets(0, n, 0, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.mStructureCombo, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(0, n * 2, 0, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, this.mMLabel, gridBagConstraints, 2, 0, 1, 1, n2, insets);
        gridBagConstraints.weighty = 1.0;
        insets.set(0, n, 0, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMField, gridBagConstraints, 3, 0, 1, 1, n2, insets);
        insets.set(DialogUtil.getGroupBoxInnerMargin() / 2, n, 0, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, this.mAdjustEstimatorCheck, gridBagConstraints, 0, 1, 4, 1, n2, insets);
        return jPanel;
    }

    private JPanel setUpMaxIterationPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        Insets insets = new Insets(0, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mMaxIterationLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        insets.set(0, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxIterationsField, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        insets.set(DialogUtil.getGroupBoxInnerMargin() / 2, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mUpdateMatrixCheck, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        insets.set(DialogUtil.getGroupBoxInnerMargin() / 2, n * 2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mIterationUpdatesLabel, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(DialogUtil.getGroupBoxInnerMargin() / 2, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mIterationsUpdatesField, gridBagConstraints, 2, 1, 1, 1, n2, insets);
        return jPanel;
    }

    private JPanel setUpConvergenceCriterionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        Insets insets = new Insets(0, n, 0, 0);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mMinimumLabel, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.mTypeLabel, gridBagConstraints, 2, 0, 1, 1, n2, insets);
        insets.set(0, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mChangesInParamCheck, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        insets.set(0, n, 0, 0);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mChangeInParamField, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mTypeCombo, gridBagConstraints, 2, 1, 1, 1, n2, insets);
        insets.set(DialogUtil.getGroupBoxInnerMargin(), n, 2, 0);
        DialogUtil.addUsingGBL(jPanel, this.mHessianCheck, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        insets.set(DialogUtil.getGroupBoxInnerMargin(), n, 2, 0);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mHessianField, gridBagConstraints, 1, 2, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mAbsoluteLabel, gridBagConstraints, 2, 2, 1, 1, n2, insets);
        return jPanel;
    }

    private JPanel setUpWorkingCorrelationPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_GLM_WORKING_CORRELATION_MATRIX"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setUpStructurePanel(), gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel2 = new JPanel();
        DialogUtil.applyTopBorder(jPanel2);
        insets.set(n2 / 2, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(0, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setUpMaxIterationPanel(), gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        insets.set(n2, n2, 0, n2);
        this.mConvergencePanel = StatisticsTab.setUpLinePanel(this.getResString("IDS_GLM_CONVERGENCE_CRITERIA"));
        this.mConvergencePanel.getComponent(0).setEnabled(false);
        DialogUtil.addUsingGBL(jPanel, this.mConvergencePanel, gridBagConstraints, 0, 3, 1, 1, n, insets);
        insets.set(n2 / 2, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mAtleastLabel, gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        insets.set(n2 / 4, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setUpConvergenceCriterionPanel(), gridBagConstraints, 0, 5, 1, 1, n, insets);
        return jPanel;
    }

    private void setEnableSortCasesCheck(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource().equals(this.mWithInSubjectTargetVarList.getModel())) {
            this.mSortCasesCheck.setEnabled(this.mWithInSubjectTargetVarList.getModel().getSize() == 0);
        }
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mMField.setEnabled(false);
        this.mMField.setOpaque(false);
        this.mAdjustEstimatorCheck.setSelected(true);
        this.mUpdateMatrixCheck.setSelected(true);
        this.mChangesInParamCheck.setSelected(true);
        this.mMaxIterationsField.setText(MAX_ITERATION_DEFAULT_VALUE);
        this.mIterationsUpdatesField.setText(ITERATION_UPDATES_DEFAULT_VALUE);
        this.mChangeInParamField.setText(CHANGE_IN_PARAM_DEFAULT_VAL);
        this.mMaxIterationLabel.setEnabled(false);
        this.mMaxIterationsField.setEnabled(false);
        this.mUpdateMatrixCheck.setEnabled(false);
        if (this.mConvergencePanel != null) {
            this.mConvergencePanel.getComponent(0).setEnabled(false);
        }
        this.mAtleastLabel.setEnabled(false);
        this.mChangesInParamCheck.setEnabled(false);
        this.mHessianCheck.setEnabled(false);
        this.mSortCasesCheck.setSelected(true);
        this.mChangeInParamField.setEnabled(false);
        this.mTypeCombo.setEnabled(false);
        this.mChangeInParamField.setOpaque(true);
        this.mHessianField.setEnabled(false);
        this.mHessianField.setOpaque(true);
        this.mAbsoluteLabel.setEnabled(false);
        this.mMinimumLabel.setEnabled(false);
        this.mTypeLabel.setEnabled(false);
        this.mStructureCombo.setSelectedIndex(0);
        this.mTypeCombo.setSelectedIndex(0);
        this.mTypeCombo.setEnabled(false);
        this.mRobustRadio.setSelected(true);
        this.mMLabel.setEnabled(false);
        this.mMField.setText("");
        this.mHessianField.setText("");
        this.mSubjectArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mWithInSubjectArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mHessianCheck.setSelected(false);
        this.mHessianField.setText("");
        this.mHessianField.setEnabled(false);
        this.mHessianField.setOpaque(false);
        this.mAbsoluteLabel.setEnabled(false);
        this.mIterationsUpdatesField.setEnabled(false);
        this.mIterationsUpdatesField.setOpaque(false);
        this.mIterationUpdatesLabel.setEnabled(false);
    }

    private void setFocusTraversalPolicy() {
        this.mComponent.clear();
        this.mComponent.add(this.mSrcVarList);
        this.mComponent.add(this.mSubjectArrow);
        this.mComponent.add(this.mSubjectTargetVarList);
        this.mComponent.add(this.mSubListArrowButtonFactory.getUpArrowButton());
        this.mComponent.add(this.mSubListArrowButtonFactory.getDownArrowButton());
        this.mComponent.add(this.mWithInSubjectArrow);
        this.mComponent.add(this.mWithInSubjectTargetVarList);
        this.mComponent.add(this.mWithInSublistArrowButtonFactory.getUpArrowButton());
        this.mComponent.add(this.mWithInSublistArrowButtonFactory.getDownArrowButton());
        this.mComponent.add(this.mSortCasesCheck);
        this.mComponent.add(this.mCovarianceMatrixGrp);
        this.mComponent.add(this.mStructureCombo);
        this.mComponent.add(this.mMField);
        this.mComponent.add(this.mAdjustEstimatorCheck);
        this.mComponent.add(this.mMaxIterationsField);
        this.mComponent.add(this.mUpdateMatrixCheck);
        this.mComponent.add(this.mIterationsUpdatesField);
        this.mComponent.add(this.mChangesInParamCheck);
        this.mComponent.add(this.mChangeInParamField);
        this.mComponent.add(this.mTypeCombo);
        this.mComponent.add(this.mHessianCheck);
        this.mComponent.add(this.mHessianField);
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            this.mComponent.add(component);
        }
        this.setComponentOrder(this.mComponent);
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSubjectTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mSubjectTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mSubjectTargetVarList.getFixedCellHeight() * 3 + 2));
        this.mSubjectTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mWithInSubjectTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mWithInSubjectTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mWithInSubjectTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mWithInSubjectTargetVarList.getFixedCellHeight() * 3 + 2));
        this.mSubjectArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mSubjectArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mSubjectArrow.registerVariableList(this.mSubjectTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mWithInSubjectArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mWithInSubjectArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mWithInSubjectArrow.registerVariableList(this.mWithInSubjectTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mSubListArrowButtonFactory = new ListTravArrowButtonFactory(this.mSubjectTargetVarList, false);
        this.mSubjectUpAndDownArrowPanel = this.mSubListArrowButtonFactory.getArrowButtonPanel();
        this.mWithInSublistArrowButtonFactory = new ListTravArrowButtonFactory(this.mWithInSubjectTargetVarList, false);
        this.mWithInSubjectUpAndDownArrowPanel = this.mWithInSublistArrowButtonFactory.getArrowButtonPanel();
        this.mRobustRadio = DialogUtil.createRadioButton(this.mParent, ROBUST_KEY, null);
        this.mModelBasedRadio = DialogUtil.createRadioButton(this.mParent, MODEL_BASED_KEY, null);
        this.mCovarianceMatrixGrp = new SpssButtonGroup();
        this.mCovarianceMatrixGrp.add(this.mRobustRadio);
        this.mCovarianceMatrixGrp.add(this.mModelBasedRadio);
        this.mSortCasesCheck = DialogUtil.createCheckBox(this.mParent, SORT_CASES_KEY, null);
        this.mAdjustEstimatorCheck = DialogUtil.createCheckBox(this.mParent, ADJUST_ESTIMATOR_KEY, null);
        this.mUpdateMatrixCheck = DialogUtil.createCheckBox(this.mParent, UPDATE_MATRIX_KEY, null);
        this.mChangesInParamCheck = DialogUtil.createCheckBox(this.mParent, CHANGES_IN_PARAM_KEY, null);
        this.mHessianCheck = DialogUtil.createCheckBox(this.mParent, HESSIAN_CONVERGANCE_KEY, null);
        this.mStructureCombo = new JComboBox<String>(this.getResStringArray("IDS_GLM_STRUCTURE_VALUES"));
        this.mTypeCombo = new JComboBox<String>(this.getResStringArray("IDS_GLM_TYPE_VALUES"));
        this.mMLabel = DialogUtil.createLabel(this.mParent, "IDS_GLM_M_DOT");
        this.mMaxIterationLabel = DialogUtil.createLabel(this.mParent, "IDS_GLM_MAXIMUM_ITERATIONS");
        this.mIterationUpdatesLabel = DialogUtil.createLabel(this.mParent, "IDS_GLM_ITERATIONS_BETWEEN_UPDATES");
        this.mAtleastLabel = new JLabel(this.getResString("IDS_GLM_CONVERGENCE_CRITERIA_LABEL"));
        this.mMinimumLabel = new JLabel(this.getResString("IDS_GLM_MINIMUM_DOT"));
        this.mTypeLabel = DialogUtil.createLabel(this.mParent, "IDS_GLM_TYPE_DOT");
        this.mAbsoluteLabel = new JLabel(this.getResString("IDS_GLM_ABSOLUTE"));
        this.mMField = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mMField.setColumns(8);
        this.mMaxIterationsField = new IntTextField(true);
        this.mMaxIterationsField.setColumns(6);
        this.mIterationsUpdatesField = new IntTextField(true);
        this.mIterationsUpdatesField.setColumns(6);
        this.mChangeInParamField = new ContextEnabledTextField();
        this.mChangeInParamField.setColumns(6);
        this.mChangeInParamField.setDocument((Document)new ExponentialDoc());
        this.mHessianField = new ContextEnabledTextField();
        this.mHessianField.setColumns(6);
        this.mHessianField.setDocument((Document)new ExponentialDoc());
        this.mMLabel.setLabelFor((Component)this.mMField);
        this.mMaxIterationLabel.setLabelFor((Component)this.mMaxIterationsField);
        this.mIterationUpdatesLabel.setLabelFor((Component)this.mIterationsUpdatesField);
        this.mTypeLabel.setLabelFor(this.mTypeCombo);
        Dimension dimension = this.mStructureCombo.getMinimumSize();
        dimension.width += 15;
        this.mStructureCombo.setPreferredSize(dimension);
        dimension = this.mTypeCombo.getMinimumSize();
        dimension.width += 15;
        this.mTypeCombo.setPreferredSize(dimension);
        this.mStructureCombo.addItemListener(this);
        this.mUpdateMatrixCheck.addItemListener(this);
        this.mAdjustEstimatorCheck.addItemListener(this);
        this.mChangesInParamCheck.addItemListener(this);
        this.mHessianCheck.addItemListener(this);
        this.mWithInSubjectTargetVarList.getModel().addListDataListener(this);
        this.mSubjectTargetVarList.getModel().addListDataListener(this);
        this.mComponent = new Vector();
        this.mSrcVarList.setIdentifier(SOURCE_LIST_KEY);
        this.mWithInSubjectTargetVarList.setIdentifier(WITHIN_SUB_TARGET_LIST_KEY);
        this.mSubjectTargetVarList.setIdentifier(SUBJECT_TARGET_LIST_KEY);
        this.mStructureCombo.setAction(new ComboboxAction(this.mParent, STRUCTURE_COMBO_KEY));
        this.mTypeCombo.setAction(new ComboboxAction(this.mParent, TYPE_COMBO_KEY));
        this.mMField.setAction((Action)new TextFieldAction(this.mParent, M_FIELD_KEY));
        this.mIterationsUpdatesField.setAction((Action)new TextFieldAction(this.mParent, ITERATION_UPDATES_KEY));
        this.mMaxIterationsField.setAction((Action)new TextFieldAction(this.mParent, MAX_ITERATION_FIELD_KEY));
        this.mChangeInParamField.setAction((Action)new TextFieldAction(this.mParent, CHANGE_IN_PARAM_FIELD_KEY));
        this.mHessianField.setAction((Action)new TextFieldAction(this.mParent, HESSIAN_FIELD_KEY));
        this.mMField.addFocusListener((FocusListener)this);
        this.mIterationsUpdatesField.addFocusListener((FocusListener)this);
        this.mMaxIterationsField.addFocusListener((FocusListener)this);
        this.mChangeInParamField.addFocusListener((FocusListener)this);
        this.mHessianField.addFocusListener((FocusListener)this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RepeatedTab.this.mSrcVarList.setSelectedIndex(0);
                RepeatedTab.this.mSrcVarList.requestFocusInWindow();
            }
        });
    }

    private String getVariablesList(TargetVariableList targetVariableList) {
        String string = "";
        int n = targetVariableList.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            string = string + targetVariableList.getModel().getElementAt(i).getName();
            if (i >= n - 1) continue;
            string = string + "*";
        }
        return string;
    }

    private void setSelectionText(final JTextField jTextField) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jTextField.requestFocusInWindow();
            }
        });
        jTextField.setSelectionStart(0);
        jTextField.setSelectionEnd(jTextField.getText().length());
    }
}

