/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.generalized_estm_eqn;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.EMMeansTab;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.EstimationTab;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.ExportTab;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.GEEVarListDropListener;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.ModelTab;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.PredictorsTab;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.ResponseTab;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.SaveTab;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.StatisticsTab;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.TypeOfModelTab;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.generalized_estm_eqn.RepeatedTab;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle1;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.controls.drag_drop.DragPane;
import java.awt.Component;
import java.awt.Window;
import javax.swing.JFrame;

public class GeneralizedEstimatingEquationsDlg
extends BaseTabbedDialog {
    private EstimationTab estTab;
    private SaveTab saveTab;
    private ResponseTab mResTab;
    private ExportTab exportTab;
    private PredictorsTab mPredTab;
    private StatisticsTab mStatsTab;
    private ModelTab mModelTab;
    private EMMeansTab mEMeansTab;
    private RepeatedTab mRepeatedTab;
    public TypeOfModelTab mTypeOfModelTab;

    public GeneralizedEstimatingEquationsDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle1.getDefaultResourceBundleName(), AnalyzeResBundle1.getImageFolder());
        this.setTitle(this.getResString("IDS_GEE_TITLE"));
        this.setLocationRelativeTo(jFrame);
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
        this.mEMeansTab.loadTabState(this.getDialogDataModel(), this.getNameLabelOverride());
        this.exportTab.loadTabState(this.getDialogDataModel(), this.getNameLabelOverride());
    }

    @Override
    public void saveDialogState() {
        super.saveDialogState();
        this.mEMeansTab.saveTabState(this.getDialogDataModel());
    }

    @Override
    public String generateSyntax() {
        String string;
        String string2;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append("* ").append(this.getResString("IDS_GEM_SYNTAX_TITLE")).append(".");
        stringBuffer.append("\n");
        String string3 = this.saveTab.getDeleteVarsSyntax();
        if (string3.length() > 0) {
            stringBuffer.append(SyntaxUtil.getMainCommand(string3));
            stringBuffer.append("\n");
        }
        if ((string2 = this.exportTab.getNewDatasetName()).length() > 0) {
            stringBuffer.append("DATASET DECLARE ").append(string2).append(".\n");
        }
        stringBuffer.append(SyntaxUtil.getMainCommand("GENLIN"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mResTab.getGeneratedSyntaxForDependentVar()));
        String string4 = this.mPredTab.getByCommandSyntax();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        if (string4 != null) {
            stringBuffer.append(" ").append(string4);
            stringBuffer.append(this.getOrderCommand());
        }
        if ((string4 = this.mPredTab.getWithCommandSyntax()) != null) {
            stringBuffer.append(" ").append(string4);
        }
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/MODEL"));
        string4 = this.mModelTab.getModelCommandSyntax();
        if (string4.length() > 0) {
            stringBuffer.append(" ").append(string4);
        }
        stringBuffer.append(" ").append(this.mModelTab.getInterceptCommandSyntax());
        string4 = this.mPredTab.getOffsetCommandSyntax();
        if (string4 != null) {
            stringBuffer.append(" ").append(string4);
        }
        stringBuffer.append(this.mResTab.getGeneratedSyntaxForDistribution());
        stringBuffer.append("\n");
        stringBuffer.append(this.mTypeOfModelTab.getTypeOfModelTabSyntax());
        stringBuffer.append("\n");
        String string5 = this.estTab.getEstimationTabSyntax();
        if (!string5.equals("")) {
            stringBuffer.append(string5);
        }
        stringBuffer.append(this.mStatsTab.getGeneratedSyntaxForModelEffect());
        String string6 = this.mEMeansTab.getEMMeansCommandSyntax();
        if (string6.length() > 0) {
            stringBuffer.append("\n").append(string6);
        }
        if (string6.length() == 0) {
            stringBuffer.append("\n");
        }
        stringBuffer.append(this.mRepeatedTab.getGeneratedSyntax()).append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/MISSING CLASSMISSING="));
        Boolean bl = dialogDataModel.getBoolean("IDS_GLM_OPTIONS_EXCLUDE_RADIO");
        if (bl == null || bl.booleanValue()) {
            stringBuffer.append("EXCLUDE");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_GLM_OPTIONS_INCLUDE_RADIO")) != null && bl.booleanValue()) {
            stringBuffer.append("INCLUDE");
        }
        stringBuffer.append("\n");
        stringBuffer.append(this.mStatsTab.getGeneratedSyntaxForPrint());
        String string7 = this.saveTab.getSaveTabSyntax();
        if (!string7.equals("")) {
            stringBuffer.append("\n").append(string7);
        }
        if (!(string = this.exportTab.getExportTabSyntax()).equals("")) {
            stringBuffer.append("\n").append(string);
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append(this.exportTab.getPerAttributesSyntax());
        if (string2.length() > 0 && CommandLine.isClementineCaller() && RemoteFileChooser.enableSaveInModeler()) {
            stringBuffer.append("\nDATASET ACTIVATE " + string2);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean okPastePressed() {
        String string;
        ModelTab.loadValuesInModel();
        ModelTab.ensureConsistent();
        this.mEMeansTab.loadDisplayTable();
        if (!this.getRepeatedTab().isValidateTabFields()) {
            return false;
        }
        if (!this.getResponseTab().validateTab()) {
            return false;
        }
        if (!this.mModelTab.validateTab()) {
            return false;
        }
        if (ModelTab.getTargetListModel().getSize() < 1 && SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), string = this.mModelTab.isCheckBoxSelected() ? this.getResString("ERR_MODEL_NO_EFFECTS_SPECIFIED_MSG") : this.getResString("ERR_MODEL_NO_EFFECTS_NO_CHECK_SPECIFIED_MSG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.YES_NO_OPTION) == 2) {
            if (PredictorsTab.getFactorsTargetListModel().getSize() < 1 && PredictorsTab.getCovariateTargetListModel().getSize() < 1) {
                this.mTabbedPane.setSelectedIndex(1);
            } else {
                this.mTabbedPane.setSelectedIndex(2);
            }
            return false;
        }
        if (!this.mEMeansTab.isValidate()) {
            return false;
        }
        if (!this.saveTab.isValidate()) {
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    public String getIActionKey() {
        return "analyze_generalized_linear_model_gee";
    }

    @Override
    public void enableOkPaste(boolean bl) {
        super.enableOkPaste(bl);
    }

    public void updateOKPaste() {
        boolean bl = true;
        boolean bl2 = true;
        if (this.getTypeOfModelTab() != null && !this.getTypeOfModelTab().enableOKPaste()) {
            bl = false;
        }
        if (this.getResponseTab() != null && !this.getResponseTab().enableOKPaste()) {
            bl2 = false;
        }
        this.enableOkPaste(bl && bl2);
    }

    @Override
    public void pack() {
        super.pack();
        if (this.getGlassPane() instanceof DragPane) {
            DialogUtil.removeDragAdapters((DragPane)this.getGlassPane(), (Component)((Object)this));
            GEEVarListDropListener.addDragAdapters((DragPane)this.getGlassPane(), (Component)((Object)this), this.mVarMoveHandler, this);
        }
    }

    public RepeatedTab getRepeatedTab() {
        return this.mRepeatedTab;
    }

    public ResponseTab getResponseTab() {
        return this.mResTab;
    }

    public EstimationTab getEstimationTab() {
        return this.estTab;
    }

    public SaveTab getSaveTab() {
        return this.saveTab;
    }

    public StatisticsTab getStatisticsTab() {
        return this.mStatsTab;
    }

    public TypeOfModelTab getTypeOfModelTab() {
        return this.mTypeOfModelTab;
    }

    @Override
    protected void init() {
        super.init();
        this.estTab = new EstimationTab(this, false);
        this.saveTab = new SaveTab(this, false);
        this.mRepeatedTab = new RepeatedTab(this);
        this.mResTab = new ResponseTab(this, true);
        this.mTypeOfModelTab = new TypeOfModelTab(this, false);
        this.addTab(this.getResString("IDS_GLM_REPEATED"), this.mRepeatedTab);
        this.addTab(this.getResString("IDS_GLM_TYPE_OF_MODEL_TAB_TITLE"), this.mTypeOfModelTab);
        this.addTab(this.getResString("IDS_GLM_RESPONSE"), this.mResTab);
        this.mPredTab = new PredictorsTab(this, false);
        this.addTab(this.getResString("IDS_GLM_PREDICT_TAB_TITLE"), this.mPredTab);
        this.mModelTab = new ModelTab(this, PredictorsTab.getFactorsTargetListModel(), PredictorsTab.getCovariateTargetListModel(), false);
        this.addTab(this.getResString("IDS_COMPLEX_SAMPLES_COMMON_MODEL_MODEL_LABEL"), this.mModelTab);
        this.addTab(this.getResString("IDS_GLM_ESTIMATION_TAB_TITLE"), this.estTab);
        this.mStatsTab = new StatisticsTab(this, true);
        this.addTab(this.getResString("IDS_GLM_STATISTICS"), this.mStatsTab);
        this.mEMeansTab = new EMMeansTab(this, false);
        this.addTab(this.getResString("IDS_GLM_EMMEANS_TAB_TITLE"), this.mEMeansTab);
        this.addTab(this.getResString("IDS_GLM_SAVE_TAB_TITLE"), this.saveTab);
        this.exportTab = new ExportTab(this, false);
        this.addTab(this.getResString("IDS_GLM_EXPORT_TAB_TITLE"), this.exportTab);
        this.pack();
    }

    public boolean hasSplitVar() {
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        int n = iSpssDataSrc.getNSplitVars();
        return n > 0;
    }

    private StringBuffer getOrderCommand() {
        StringBuffer stringBuffer = new StringBuffer("");
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        stringBuffer.append(" (ORDER=");
        Boolean bl = dialogDataModel.getBoolean("IDS_GLM_OPTIONS_USE_DATA_ORDER_RADIO");
        if (bl != null && bl.booleanValue()) {
            if (this.hasSplitVar()) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_GLM_SPLIT_VARIABLE_WARN_MSG"), VersionInfo.getAppVersionString());
                stringBuffer.append("ASCENDING");
            } else {
                stringBuffer.append("DATA");
            }
        }
        if ((bl = dialogDataModel.getBoolean("IDS_GLM_OPTIONS_ASCENDING_RADIO")) == null || bl.booleanValue()) {
            stringBuffer.append("ASCENDING");
        }
        if ((bl = dialogDataModel.getBoolean("IDS_GLM_OPTIONS_DESCENDING_RADIO")) != null && bl.booleanValue()) {
            stringBuffer.append("DESCENDING");
        }
        stringBuffer.append(")");
        return stringBuffer;
    }
}

