/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.GeneralizedLinearModelsDlg;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.StatisticsTab;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.generalized_estm_eqn.GeneralizedEstimatingEquationsDlg;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TypeOfModelTab
extends BaseProcedureTab
implements ItemListener,
ActionListener,
FocusListener,
DocumentListener {
    private static final String PARAMETER_DEFAULT_VALUES = "1";
    private static final String TWEEDIE_PARAMETER_DEFAULT_VALUES = "1.5";
    public static final String RADIO_LINEAR = "IDS_GLM_TYPEOFMODEL_LINEAR";
    public static final String RADIO_GAMMA = "IDS_GLM_TYPEOFMODEL_GAMMA_LOGLINK";
    public static final String RADIO_POISSON = "IDS_GLM_TYPEOFMODEL_POISSON_LOGLINEAR";
    public static final String RADIO_NEGBIN = "IDS_GLM_TYPEOFMODEL_NEGBIN_LOGLINK";
    public static final String RADIO_TWEEDIE_LOGLINK = "IDS_GLM_TYPEOFMODEL_TWEEDIE_LOGLINK";
    public static final String RADIO_TWEEDIE_IDENTLINK = "IDS_GLM_TYPEOFMODEL_TWEEDIE_IDENTLINK";
    public static final String RADIO_CUSTOM = "IDS_GLM_TYPEOFMODEL_CUSTOM";
    public static final String RADIO_ORD_LOGISTIC = "IDS_GLM_TYPEOFMODEL_ORD_LOGISTIC";
    public static final String RADIO_ORD_PROBIT = "IDS_GLM_TYPEOFMODEL_ORD_PROBIT";
    public static final String RADIO_BIN_LOGISTIC = "IDS_GLM_TYPEOFMODEL_BIN_LOGISTIC";
    public static final String RADIO_BIN_PROBIT = "IDS_GLM_TYPEOFMODEL_BIN_PROBIT";
    public static final String RADIO_INTERVAL_SURVIVAL = "IDS_GLM_TYPEOFMODEL_INTERVAL_SURVIVAL";
    public static final String RADIO_SPECIFY_VALUE = "IDS_GLM_TYPEOFMODEL_SPECIFY_VAL";
    public static final String RADIO_ESTIMATE_VALUE = "IDS_GLM_TYPEOFMODEL_ESTIMATE_VALUE";
    public static final String DISTRIBUTION_KEY = "IDS_GLM_TYPEOFMODEL_DISTRIBUTION_DOT";
    public static final String LINK_FUNC_KEY = "IDS_GLM_TYPEOFMODEL_LINK_FUNC_DOT";
    public static final String VALUE_FIELD_KEY = "IDS_GLM_TYPEOFMODEL_VALUE_DOT";
    public static final String POWER_FIELD_KEY = "IDS_GLM_TYPEOFMODEL_POWER_DOT";
    public static final int DIST_RADIO_BINOMIAL = 0;
    public static final int DIST_RADIO_GAMMA = 1;
    public static final int DIST_RADIO_INV_GAUSS = 2;
    public static final int DIST_RADIO_MULTINOMIAL = 3;
    public static final int DIST_RADIO_NEG_BIN = 4;
    public static final int DIST_RADIO_NORMAL = 5;
    public static final int DIST_RADIO_POISSON = 6;
    public static final int DIST_RADIO_TWEEDIE = 7;
    private JLabel mChooseLabel;
    private JPanel mMainPanel;
    private JPanel mCustomPanel;
    private SpssButtonGroup mButtonGroup;
    private JRadioButton mLinearRadio;
    private JRadioButton mGammaRadio;
    private JRadioButton mPoissonRadio;
    private JRadioButton mNegBinLogLinkRadio;
    private JRadioButton mTweedieLogLinkRadio;
    private JRadioButton mTweedieIdentRadio;
    private JRadioButton mCustomRadio;
    private JRadioButton mOrdLogisticRadio;
    private JRadioButton mOrdProbitRadio;
    private JRadioButton mBinLogisticRadio;
    private JRadioButton mBinProbitRadio;
    private JRadioButton mIntervalRadio;
    private JLabel mDistributionLabel;
    public JComboBox mDistributionCombo;
    private JLabel mLinkFunctionLabel;
    private JComboBox mLinkFunctionCombo;
    private TitledBorder mParameterPanelBorder;
    private JRadioButton mSpecifyValueRadio;
    private JRadioButton mEstimateValueRadio;
    private SpssButtonGroup mParamButtonGroup;
    private JLabel mValueLabel;
    private FloatTextField mValueField;
    private JLabel mPowerLabel;
    private FloatTextField mPowerField;
    private JPanel mParameterPanel;
    private boolean mGLMTab;

    public TypeOfModelTab(BaseTabbedDialog baseTabbedDialog, boolean bl) {
        super(baseTabbedDialog, true);
        this.mGLMTab = bl;
        this.initialize();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mValueField) {
            this.mValueField.selectAll();
        }
        if (focusEvent.getSource() == this.mPowerField) {
            this.mPowerField.selectAll();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        super.validate();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        int n;
        int n2;
        if (itemEvent.getSource() == this.mCustomRadio) {
            this.enableCustomGroup();
        }
        if ((itemEvent.getSource() == this.mOrdLogisticRadio || itemEvent.getSource() == this.mOrdProbitRadio || this.mDistributionCombo.getSelectedItem().equals(this.getResString("IDS_GLM_DISTRIBUTION_MULTINOMIAL"))) && this.mGLMTab) {
            ((GeneralizedLinearModelsDlg)this.mParent).getResponseTab().enableCategoryCombo(true);
        }
        if (itemEvent.getSource().equals(this.mDistributionCombo)) {
            String[] stringArray;
            Object object;
            n2 = this.mDistributionCombo.getSelectedIndex();
            String string = (String)this.mLinkFunctionCombo.getSelectedItem();
            if (this.mDistributionCombo.getSelectedItem().equals(this.getResString("IDS_GLM_DISTRIBUTION_BINOMIAL"))) {
                object = this.mLinkFunctionCombo.getSelectedItem();
                this.mLinkFunctionCombo.removeItemListener(this);
                this.mLinkFunctionCombo.removeAllItems();
                stringArray = this.getResStringArray("IDS_GLM_LINK_FUNCTION_VALUES");
                for (int i = 0; i < stringArray.length; ++i) {
                    this.mLinkFunctionCombo.addItem(stringArray[i]);
                }
                this.mLinkFunctionCombo.addItemListener(this);
                if (object != null) {
                    this.mLinkFunctionCombo.setSelectedItem(object);
                }
            } else if (this.mDistributionCombo.getSelectedItem().equals(this.getResString("IDS_GLM_DISTRIBUTION_NEGATIVE_BIONOMIAL"))) {
                object = this.mLinkFunctionCombo.getSelectedItem();
                this.mLinkFunctionCombo.removeItemListener(this);
                this.mLinkFunctionCombo.removeAllItems();
                stringArray = this.getResStringArray("IDS_GLM_LINK_FUNCTION_VALUES1");
                for (int i = 0; i < stringArray.length; ++i) {
                    this.mLinkFunctionCombo.addItem(stringArray[i]);
                }
                this.mLinkFunctionCombo.addItemListener(this);
                if (object != null) {
                    this.mLinkFunctionCombo.setSelectedItem(object);
                }
            } else if (this.mDistributionCombo.getSelectedItem().equals(this.getResString("IDS_GLM_DISTRIBUTION_MULTINOMIAL"))) {
                object = this.mLinkFunctionCombo.getSelectedItem();
                this.mLinkFunctionCombo.removeItemListener(this);
                this.mLinkFunctionCombo.removeAllItems();
                stringArray = this.getResStringArray("IDS_GLM_LINK_FUNCTION_VALUES3");
                for (int i = 0; i < stringArray.length; ++i) {
                    this.mLinkFunctionCombo.addItem(stringArray[i]);
                }
                this.mLinkFunctionCombo.addItemListener(this);
                if (object != null) {
                    this.mLinkFunctionCombo.setSelectedItem(object);
                }
                if (!this.mGLMTab && ((GeneralizedEstimatingEquationsDlg)this.mParent).getStatisticsTab() != null) {
                    ((GeneralizedEstimatingEquationsDlg)this.mParent).getStatisticsTab().enableLogQuasiCombo(true);
                    ((GeneralizedEstimatingEquationsDlg)this.mParent).getStatisticsTab().enableGoodnessOfFitCheck(true);
                }
            } else {
                object = this.mLinkFunctionCombo.getSelectedItem();
                this.mLinkFunctionCombo.removeItemListener(this);
                this.mLinkFunctionCombo.removeAllItems();
                stringArray = this.getResStringArray("IDS_GLM_LINK_FUNCTION_VALUES2");
                for (int i = 0; i < stringArray.length; ++i) {
                    this.mLinkFunctionCombo.addItem(stringArray[i]);
                }
                this.mLinkFunctionCombo.addItemListener(this);
                if (object != null) {
                    this.mLinkFunctionCombo.setSelectedItem(object);
                }
                Dimension dimension = this.mLinkFunctionCombo.getPreferredSize();
                if (!this.mGLMTab && ((GeneralizedEstimatingEquationsDlg)this.mParent).getStatisticsTab() != null) {
                    ((GeneralizedEstimatingEquationsDlg)this.mParent).getStatisticsTab().enableLogQuasiCombo(false);
                    ((GeneralizedEstimatingEquationsDlg)this.mParent).getStatisticsTab().enableGoodnessOfFitCheck(false);
                }
            }
            object = this.getLinkFuncSel(n2, string);
            for (int i = 0; i < this.mLinkFunctionCombo.getItemCount(); ++i) {
                if (!this.mLinkFunctionCombo.getItemAt(i).equals(object)) continue;
                this.mLinkFunctionCombo.setSelectedIndex(i);
                break;
            }
            this.enableCustomGroup();
        }
        if (itemEvent.getSource().equals(this.mLinkFunctionCombo)) {
            this.enableCustomGroup();
        }
        n2 = this.isLinearSelected() || this.isNormalSelected() && this.isLinkSelected(this.getResStringArray("IDS_GLM_LINK_FUNCTION_VALUES2")[0]) ? 1 : 0;
        int n3 = n = this.mCustomRadio.isSelected() ? this.mDistributionCombo.getSelectedIndex() : -1;
        if (this.mGLMTab) {
            if (((GeneralizedLinearModelsDlg)this.mParent).estTab != null) {
                ((GeneralizedLinearModelsDlg)this.mParent).estTab.updateEstimationTab(n, this.getSelectedModelType());
                ((GeneralizedLinearModelsDlg)this.mParent).estTab.updateIteration(n2 == 0);
            }
            if (((GeneralizedLinearModelsDlg)this.mParent).saveTab != null) {
                ((GeneralizedLinearModelsDlg)this.mParent).saveTab.updateSaveTab(this.mDistributionCombo.getSelectedIndex(), this.getSelectedModelType());
            }
            if (((GeneralizedLinearModelsDlg)this.mParent).mResTab != null) {
                ((GeneralizedLinearModelsDlg)this.mParent).mResTab.enableComponent();
            }
        } else {
            if (((GeneralizedEstimatingEquationsDlg)this.mParent).getEstimationTab() != null) {
                ((GeneralizedEstimatingEquationsDlg)this.mParent).getEstimationTab().updateEstimationTab(n, this.getSelectedModelType());
                ((GeneralizedEstimatingEquationsDlg)this.mParent).getEstimationTab().updateIteration(n2 == 0);
            }
            if (((GeneralizedEstimatingEquationsDlg)this.mParent).getSaveTab() != null) {
                ((GeneralizedEstimatingEquationsDlg)this.mParent).getSaveTab().updateSaveTab(this.mDistributionCombo.getSelectedIndex(), this.getSelectedModelType());
            }
            if (((GeneralizedEstimatingEquationsDlg)this.mParent).getResponseTab() != null) {
                ((GeneralizedEstimatingEquationsDlg)this.mParent).getResponseTab().enableComponent();
            }
        }
        if (!this.mGLMTab) {
            ((GeneralizedEstimatingEquationsDlg)this.mParent).getRepeatedTab().enableComponent();
        }
        if (itemEvent.getSource() == this.mEstimateValueRadio) {
            this.mValueField.setEnabled(false);
            this.mValueLabel.setEnabled(false);
        }
        if (itemEvent.getSource() == this.mSpecifyValueRadio) {
            this.mValueField.setEnabled(true);
            this.mValueLabel.setEnabled(true);
        }
        boolean bl2 = bl = this.isNormalSelected() && this.isLinkSelected(this.getResStringArray("IDS_GLM_LINK_FUNCTION_VALUES2")[0]) || this.isLinearSelected();
        if (this.mGLMTab) {
            if (((GeneralizedLinearModelsDlg)this.mParent).estTab != null) {
                ((GeneralizedLinearModelsDlg)this.mParent).estTab.enableMethodList(!bl);
            }
        } else if (((GeneralizedEstimatingEquationsDlg)this.mParent).getEstimationTab() != null) {
            ((GeneralizedEstimatingEquationsDlg)this.mParent).getEstimationTab().enableMethodList(!bl);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateOkPaste();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateOkPaste();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateOkPaste();
    }

    public void updateOkPaste() {
        if (this.mGLMTab) {
            ((GeneralizedLinearModelsDlg)this.mParent).updateOKPaste();
        } else {
            ((GeneralizedEstimatingEquationsDlg)this.mParent).updateOKPaste();
        }
    }

    public boolean enableOKPaste() {
        boolean bl = true;
        boolean bl2 = true;
        if (this.mValueField.isEnabled() && this.mValueField.getText().length() == 0) {
            bl = false;
        }
        if (this.mPowerField.isEnabled() && this.mPowerField.getText().length() == 0) {
            bl2 = false;
        }
        return bl && bl2;
    }

    @Override
    protected void aboutToShowTab() {
    }

    @Override
    public String getDialogHelpID() {
        if (this.mGLMTab) {
            return "idh_idd_genlin_typeofmodel";
        }
        return "idh_idd_gee_typeofmodel";
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    public boolean isDistributionSelected() {
        String[] stringArray = this.getResStringArray("IDS_GLM_DISTRIBUTION_VALUES_1");
        return this.mDistributionCombo.getSelectedItem().toString().equals(stringArray[0].toString());
    }

    public int getDistributionSelectedIndex() {
        if (this.mDistributionCombo.isEnabled()) {
            return this.mDistributionCombo.getSelectedIndex();
        }
        return -1;
    }

    public boolean isMultinomialSelected() {
        return this.mDistributionCombo.isEnabled() && this.mDistributionCombo.getSelectedIndex() == 3;
    }

    public boolean isBinomialSelected() {
        return this.mDistributionCombo.isEnabled() && this.mDistributionCombo.getSelectedIndex() == 0;
    }

    public boolean isNegBinomialSelected() {
        return this.mDistributionCombo.isEnabled() && this.mDistributionCombo.getSelectedIndex() == 4;
    }

    public boolean isPoissonSelected() {
        return this.mDistributionCombo.isEnabled() && this.mDistributionCombo.getSelectedIndex() == 6;
    }

    public boolean isNormalSelected() {
        return this.mDistributionCombo.isEnabled() && this.mDistributionCombo.getSelectedIndex() == 5;
    }

    public boolean isGammaSelected() {
        return this.mDistributionCombo.isEnabled() && this.mDistributionCombo.getSelectedIndex() == 1;
    }

    public boolean isInvGaussianSelected() {
        return this.mDistributionCombo.isEnabled() && this.mDistributionCombo.getSelectedIndex() == 2;
    }

    public boolean isTweedieSelected() {
        return this.mDistributionCombo.isEnabled() && this.mDistributionCombo.getSelectedIndex() == 7;
    }

    public boolean isDistributionModeSelected(String string) {
        return string.equalsIgnoreCase((String)this.mDistributionCombo.getSelectedItem());
    }

    public boolean isOrdinalLogisticSelected() {
        return this.mOrdLogisticRadio.isSelected();
    }

    public boolean isOrdinalProbitSelected() {
        return this.mOrdProbitRadio.isSelected();
    }

    public boolean isBinaryLogisticSelected() {
        return this.mBinLogisticRadio.isSelected();
    }

    public boolean isBinaryProbitSelected() {
        return this.mBinProbitRadio.isSelected();
    }

    public boolean isIntervalCensoredSurvivalSelected() {
        return this.mIntervalRadio.isSelected();
    }

    public boolean isLinearSelected() {
        return this.mLinearRadio.isEnabled() && this.mLinearRadio.isSelected();
    }

    public boolean isGammaWithLogLinkSelected() {
        return this.mGammaRadio.isSelected();
    }

    public boolean isTweedieLogLinkSelected() {
        return this.mTweedieLogLinkRadio.isSelected();
    }

    public boolean isTweedieWithIdentLinkSelected() {
        return this.mTweedieIdentRadio.isSelected();
    }

    public boolean isNegativeBinLogLinkSelected() {
        return this.mNegBinLogLinkRadio.isSelected();
    }

    public String getSelectedModelType() {
        String string = "";
        if (this.mLinearRadio.isSelected()) {
            string = RADIO_LINEAR;
        } else if (this.mGammaRadio.isSelected()) {
            string = RADIO_GAMMA;
        } else if (this.mPoissonRadio.isSelected()) {
            string = RADIO_POISSON;
        } else if (this.mNegBinLogLinkRadio.isSelected()) {
            string = RADIO_NEGBIN;
        } else if (this.mTweedieLogLinkRadio.isSelected()) {
            string = RADIO_TWEEDIE_LOGLINK;
        } else if (this.mTweedieIdentRadio.isSelected()) {
            string = RADIO_TWEEDIE_IDENTLINK;
        } else if (this.mCustomRadio.isSelected()) {
            string = RADIO_CUSTOM;
        } else if (this.mOrdLogisticRadio.isSelected()) {
            string = RADIO_ORD_LOGISTIC;
        } else if (this.mOrdProbitRadio.isSelected()) {
            string = RADIO_ORD_PROBIT;
        } else if (this.mBinLogisticRadio.isSelected()) {
            string = RADIO_BIN_LOGISTIC;
        } else if (this.mBinProbitRadio.isSelected()) {
            string = RADIO_BIN_PROBIT;
        } else if (this.mIntervalRadio.isSelected()) {
            string = RADIO_INTERVAL_SURVIVAL;
        }
        return string;
    }

    public boolean isLinkSelected(String string) {
        String string2 = (String)this.mLinkFunctionCombo.getSelectedItem();
        return string.equalsIgnoreCase(string2);
    }

    private static Map getDistributionMap() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(0, "BINOMIAL");
        hashMap.put(1, "GAMMA");
        hashMap.put(2, "IGAUSS");
        hashMap.put(3, "MULTINOMIAL");
        hashMap.put(4, "NEGBIN");
        hashMap.put(5, "NORMAL");
        hashMap.put(6, "POISSON");
        hashMap.put(7, "TWEEDIE");
        return hashMap;
    }

    private static Map getLinkFunctionMapForBionomial() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(0, "IDENTITY");
        hashMap.put(1, "CLOGLOG");
        hashMap.put(2, "LOG");
        hashMap.put(3, "LOGC");
        hashMap.put(4, "LOGIT");
        hashMap.put(5, "NLOGLOG");
        hashMap.put(6, "ODDSPOWER");
        hashMap.put(7, "PROBIT");
        hashMap.put(8, "POWER");
        return hashMap;
    }

    private static Map getLinkFunctionMapForNegBionomial() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(0, "IDENTITY");
        hashMap.put(1, "LOG");
        hashMap.put(2, "NEGBIN");
        hashMap.put(3, "POWER");
        return hashMap;
    }

    private static Map getLinkFunctionMapForMultinomial() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(0, "CUMCAUCHIT");
        hashMap.put(1, "CUMCLOGLOG");
        hashMap.put(2, "CUMLOGIT");
        hashMap.put(3, "CUMNLOGLOG");
        hashMap.put(4, "CUMPROBIT");
        return hashMap;
    }

    private static Map getLinkFunctionMap() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(0, "IDENTITY");
        hashMap.put(1, "LOG");
        hashMap.put(2, "POWER");
        return hashMap;
    }

    public String getTypeOfModelTabSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.mLinearRadio.isSelected()) {
            stringBuffer.append(" DISTRIBUTION=NORMAL LINK=IDENTITY");
        } else if (this.mGammaRadio.isSelected()) {
            stringBuffer.append(" DISTRIBUTION=GAMMA LINK=LOG");
        } else if (this.mPoissonRadio.isSelected()) {
            stringBuffer.append(" DISTRIBUTION=POISSON LINK=LOG");
        } else if (this.mNegBinLogLinkRadio.isSelected()) {
            stringBuffer.append(" DISTRIBUTION=NEGBIN(1) LINK=LOG");
        } else if (this.mTweedieLogLinkRadio.isSelected()) {
            stringBuffer.append(" DISTRIBUTION=TWEEDIE(1.5) LINK=LOG");
        } else if (this.mTweedieIdentRadio.isSelected()) {
            stringBuffer.append(" DISTRIBUTION=TWEEDIE(1.5) LINK=IDENTITY");
        } else if (this.mOrdLogisticRadio.isSelected()) {
            stringBuffer.append(" DISTRIBUTION=MULTINOMIAL LINK=CUMLOGIT");
        } else if (this.mOrdProbitRadio.isSelected()) {
            stringBuffer.append(" DISTRIBUTION=MULTINOMIAL LINK=CUMPROBIT");
        } else if (this.mBinLogisticRadio.isSelected()) {
            stringBuffer.append(" DISTRIBUTION=BINOMIAL LINK=LOGIT");
        } else if (this.mBinProbitRadio.isSelected()) {
            stringBuffer.append(" DISTRIBUTION=BINOMIAL LINK=PROBIT");
        } else if (this.mIntervalRadio.isSelected()) {
            stringBuffer.append(" DISTRIBUTION=BINOMIAL LINK=CLOGLOG");
        } else if (this.mCustomRadio.isSelected()) {
            Map map;
            Map map2 = TypeOfModelTab.getDistributionMap();
            String string = map2.get(this.mDistributionCombo.getSelectedIndex()).toString();
            stringBuffer.append(" DISTRIBUTION=" + string);
            if (this.mDistributionCombo.getSelectedIndex() == 4) {
                if (this.mSpecifyValueRadio.isSelected()) {
                    stringBuffer.append("(" + this.mValueField.getText() + ")");
                } else {
                    stringBuffer.append("(MLE)");
                }
            }
            if (this.mDistributionCombo.getSelectedIndex() == 7 && this.mSpecifyValueRadio.isSelected()) {
                stringBuffer.append("(" + this.mValueField.getText() + ")");
            }
            switch (this.mDistributionCombo.getSelectedIndex()) {
                case 0: {
                    map = TypeOfModelTab.getLinkFunctionMapForBionomial();
                    break;
                }
                case 4: {
                    map = TypeOfModelTab.getLinkFunctionMapForNegBionomial();
                    break;
                }
                case 3: {
                    map = TypeOfModelTab.getLinkFunctionMapForMultinomial();
                    break;
                }
                default: {
                    map = TypeOfModelTab.getLinkFunctionMap();
                }
            }
            String string2 = map.get(this.mLinkFunctionCombo.getSelectedIndex()).toString();
            stringBuffer.append(" LINK=" + string2);
            if (this.mPowerField.isEnabled()) {
                stringBuffer.append("(" + this.mPowerField.getText() + ")");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    protected boolean validateTab() {
        String string;
        if (this.mValueField.isEnabled()) {
            string = this.mValueField.getText();
            if (string.length() == 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_TYPEOFMODEL_ERR_PARAM_VAL"), VersionInfo.getAppVersionString());
                this.mValueField.requestFocusInWindow();
                return false;
            }
            if (this.isDistributionModeSelected(this.getResString("IDS_GLM_DISTRIBUTION_NEGATIVE_BIONOMIAL")) && Double.valueOf(this.mValueField.getText()) < 0.0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_TYPEOFMODEL_ERR_PARAM_NUM"), VersionInfo.getAppVersionString());
                this.mValueField.requestFocusInWindow();
                return false;
            }
            if (this.isDistributionModeSelected(this.getResString("IDS_GLM_DISTRIBUTION_NEGATIVE_BIONOMIAL")) && Double.valueOf(this.mValueField.getText()) == 0.0 && this.mLinkFunctionCombo.getSelectedIndex() == 2) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_TYPEOFMODEL_NEGBIN_VAL"), VersionInfo.getAppVersionString());
                this.mLinkFunctionCombo.setSelectedIndex(1);
                this.mLinkFunctionCombo.requestFocusInWindow();
                return false;
            }
            if (this.isDistributionModeSelected(this.getResString("IDS_GLM_DISTRIBUTION_TWEEDIE")) && (Double.valueOf(this.mValueField.getText()) <= 1.0 || Double.valueOf(this.mValueField.getText()) >= 2.0)) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_TYPEOFMODEL_ERR_PARAM_RANGE"), VersionInfo.getAppVersionString());
                this.mValueField.requestFocusInWindow();
                GeneralizedLinearModelsDlg.setSelectionText((JComponent)this.mValueField);
                return false;
            }
        }
        if (this.mPowerField.isEnabled()) {
            string = this.mPowerField.getText();
            if (string.length() == 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_TYPEOFMODEL_ERR_POWER_VAL"), VersionInfo.getAppVersionString());
                this.mPowerField.requestFocusInWindow();
                return false;
            }
            if (Double.valueOf(this.mPowerField.getText()) == 0.0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_TYPEOFMODEL_ERR_POWER_ZERO"), VersionInfo.getAppVersionString());
                this.mPowerField.requestFocusInWindow();
                return false;
            }
        }
        return true;
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return null;
    }

    private void initialize() {
        this.initVars();
        this.mMainPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = UIToolDialogUtil.getStandardDialogInsets();
        Insets insets2 = new Insets(insets.top, insets.left, 0, insets.right);
        Insets insets3 = new Insets(0, insets2.left * 2, 0, insets2.right);
        gridBagConstraints.gridwidth = 2;
        DialogUtil.addUsingGBL(this, this.mChooseLabel, gridBagConstraints, 0, 0, 2, 1, n, insets2);
        gridBagConstraints.gridwidth = 1;
        URL uRL = ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_SCALE_VAR_IMAGE"));
        ImageIcon imageIcon = new ImageIcon(uRL);
        DialogUtil.addUsingGBL(this, StatisticsTab.setUpLinePanel(this.getResString("IDS_GLM_TYPEOFMODEL_SCALE_RESPONSE"), imageIcon), gridBagConstraints, 0, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(this, this.mLinearRadio, gridBagConstraints, 0, 2, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(this, this.mGammaRadio, gridBagConstraints, 0, 3, 1, 1, n, insets3);
        imageIcon = new ImageIcon(ResUtil.getImageResourceFullPath(AnalyzeResBundle.getImageFolder() + this.getResString("IDS_GLM_TYPEOFMODEL_COUNTS_IMG")));
        DialogUtil.addUsingGBL(this, StatisticsTab.setUpLinePanel(this.getResString("IDS_GLM_TYPEOFMODEL_COUNTS"), imageIcon), gridBagConstraints, 0, 4, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(this, this.mPoissonRadio, gridBagConstraints, 0, 5, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(this, this.mNegBinLogLinkRadio, gridBagConstraints, 0, 6, 1, 1, n, insets3);
        imageIcon = new ImageIcon(ResUtil.getImageResourceFullPath(AnalyzeResBundle.getImageFolder() + this.getResString("IDS_GLM_TYPEOFMODEL_MIXTURE_IMG")));
        DialogUtil.addUsingGBL(this, StatisticsTab.setUpLinePanel(this.getResString("IDS_GLM_TYPEOFMODEL_MIXTURE"), imageIcon), gridBagConstraints, 0, 7, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(this, this.mTweedieLogLinkRadio, gridBagConstraints, 0, 8, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(this, this.mTweedieIdentRadio, gridBagConstraints, 0, 9, 1, 1, n, insets3);
        imageIcon = new ImageIcon(ResUtil.getImageResourceFullPath(AnalyzeResBundle.getImageFolder() + this.getResString("IDS_GLM_TYPEOFMODEL_CUSTOM_IMG")));
        DialogUtil.addUsingGBL(this, StatisticsTab.setUpLinePanel(this.getResString(RADIO_CUSTOM), imageIcon), gridBagConstraints, 0, 10, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(this, this.mCustomRadio, gridBagConstraints, 0, 11, 1, 1, n, insets3);
        uRL = ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_ORDINAL_VAR_IMAGE"));
        imageIcon = new ImageIcon(uRL);
        DialogUtil.addUsingGBL(this, StatisticsTab.setUpLinePanel(this.getResString("IDS_GLM_TYPEOFMODEL_ORD_RESP"), imageIcon), gridBagConstraints, 1, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(this, this.mOrdLogisticRadio, gridBagConstraints, 1, 2, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(this, this.mOrdProbitRadio, gridBagConstraints, 1, 3, 1, 1, n, insets3);
        imageIcon = new ImageIcon(ResUtil.getImageResourceFullPath(AnalyzeResBundle.getImageFolder() + this.getResString("IDS_GLM_TYPEOFMODEL_BINARY_IMG")));
        DialogUtil.addUsingGBL(this, StatisticsTab.setUpLinePanel(this.getResString("IDS_GLM_TYPEOFMODEL_BIN_RESP_EVENTS"), imageIcon), gridBagConstraints, 1, 4, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(this, this.mBinLogisticRadio, gridBagConstraints, 1, 5, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(this, this.mBinProbitRadio, gridBagConstraints, 1, 6, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(this, this.mIntervalRadio, gridBagConstraints, 1, 7, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(this, this.mMainPanel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.gridwidth = 2;
        DialogUtil.addUsingGBL(this, this.setupCustomPanel(), gridBagConstraints, 0, 12, 2, 1, n, insets2);
        this.setDefaults();
        this.setFocusTraversalPolicy();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mButtonGroup);
        vector.add(this.mDistributionCombo);
        vector.add(this.mParamButtonGroup);
        vector.add(this.mValueField);
        vector.add(this.mLinkFunctionCombo);
        vector.add(this.mPowerField);
        JPanel jPanel = ((BaseTabbedDialog)this.mParent).getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private void setDefaults() {
        int n;
        this.mLinearRadio.setSelected(true);
        this.mSpecifyValueRadio.setSelected(true);
        this.mDistributionCombo.removeItemListener(this);
        if (this.mDistributionCombo.getItemCount() > 0) {
            this.mDistributionCombo.removeAllItems();
        }
        String[] stringArray = this.getResStringArray("IDS_GLM_DISTRIBUTION_VALUES_1");
        for (n = 0; n < stringArray.length; ++n) {
            this.mDistributionCombo.addItem(stringArray[n]);
        }
        this.mDistributionCombo.addItemListener(this);
        this.mLinkFunctionCombo.removeItemListener(this);
        this.mDistributionCombo.setSelectedIndex(5);
        if (this.mLinkFunctionCombo.getItemCount() > 0) {
            this.mLinkFunctionCombo.removeAllItems();
        }
        stringArray = this.getResStringArray("IDS_GLM_LINK_FUNCTION_VALUES2");
        for (n = 0; n < stringArray.length; ++n) {
            this.mLinkFunctionCombo.addItem(stringArray[n]);
        }
        this.mLinkFunctionCombo.addItemListener(this);
        this.mLinkFunctionCombo.setSelectedIndex(0);
        this.mValueField.setText(PARAMETER_DEFAULT_VALUES);
        this.mPowerField.setText("");
        this.enableCustomGroup();
    }

    private void enableCustomGroup() {
        boolean bl = this.mCustomRadio.isSelected();
        this.mDistributionLabel.setEnabled(bl);
        this.mDistributionCombo.setEnabled(bl);
        this.mLinkFunctionLabel.setEnabled(bl);
        this.mLinkFunctionCombo.setEnabled(bl);
        boolean bl2 = this.isDistributionModeSelected(this.getResString("IDS_GLM_DISTRIBUTION_TWEEDIE"));
        boolean bl3 = this.isDistributionModeSelected(this.getResString("IDS_GLM_DISTRIBUTION_NEGATIVE_BIONOMIAL"));
        DialogUtil.enableTitledBorder(this.mParameterPanelBorder, bl && (bl2 || bl3));
        this.mSpecifyValueRadio.setEnabled(bl && (bl2 || bl3));
        if (bl && bl2) {
            this.mSpecifyValueRadio.setSelected(true);
        }
        this.mValueLabel.setEnabled(bl && this.mSpecifyValueRadio.isEnabled() && this.mSpecifyValueRadio.isSelected());
        this.mValueField.setEnabled(bl && this.mSpecifyValueRadio.isEnabled() && this.mSpecifyValueRadio.isSelected());
        this.mEstimateValueRadio.setEnabled(bl && bl3);
        boolean bl4 = this.isLinkSelected(this.getResString("IDS_GLM_DISTRIBUTION_POWER")) || this.isLinkSelected(this.getResString("IDS_GLM_DISTRIBUTION_ODDS_POWER")) || this.isLinkSelected(this.getResString("IDS_GLM_DISTRIBUTION_TWEEDIE"));
        this.mPowerLabel.setEnabled(bl && bl4);
        this.mPowerField.setEnabled(bl && bl4);
        if (this.isDistributionModeSelected(this.getResString("IDS_GLM_DISTRIBUTION_TWEEDIE"))) {
            if (this.mValueField.getText().length() <= 0 || !(Double.valueOf(this.mValueField.getText()) > 1.0) || !(Double.valueOf(this.mValueField.getText()) < 2.0)) {
                this.mValueField.setText(TWEEDIE_PARAMETER_DEFAULT_VALUES);
            }
            if (this.mPowerField.isEnabled() && this.mPowerField.getText().length() == 0) {
                double d = 1.0 - Double.valueOf(this.mValueField.getText());
                String string = Double.toString(d);
                this.mPowerField.setText(string);
            }
        }
        this.repaint();
    }

    private String getLinkFuncSel(int n, String string) {
        String string2 = "";
        switch (n) {
            case 5: {
                if (string.equalsIgnoreCase(this.getResString("IDS_GLM_DISTRIBUTION_IDENTITY")) || string.equalsIgnoreCase(this.getResString("IDS_GLM_DISTRIBUTION_LOG")) || string.equalsIgnoreCase(this.getResString("IDS_GLM_DISTRIBUTION_POWER"))) {
                    string2 = string;
                    break;
                }
                string2 = this.getResString("IDS_GLM_DISTRIBUTION_IDENTITY");
                break;
            }
            case 0: {
                if (string.equalsIgnoreCase(this.getResString("IDS_GLM_DISTRIBUTION_IDENTITY")) || string.equalsIgnoreCase(this.getResString("IDS_GLM_DISTRIBUTION_COMP_LOGLOG")) || string.equalsIgnoreCase(this.getResString("IDS_GLM_DISTRIBUTION_LOG")) || string.equalsIgnoreCase(this.getResString("IDS_GLM_DISTRIBUTION_LOG_COMP")) || string.equalsIgnoreCase(this.getResString("IDS_GLM_DISTRIBUTION_LOGIT")) || string.equalsIgnoreCase(this.getResString("IDS_GLM_DISTRIBUTION_NEG_LOGLOG")) || string.equalsIgnoreCase(this.getResString("IDS_GLM_DISTRIBUTION_ODDS_POWER")) || string.equalsIgnoreCase(this.getResString("IDS_GLM_DISTRIBUTION_PROBIT")) || string.equalsIgnoreCase(this.getResString("IDS_GLM_DISTRIBUTION_POWER"))) {
                    string2 = string;
                    break;
                }
                string2 = this.getResString("IDS_GLM_DISTRIBUTION_LOGIT");
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                if (string.equalsIgnoreCase(this.getResString("IDS_GLM_DISTRIBUTION_IDENTITY")) || string.equalsIgnoreCase(this.getResString("IDS_GLM_DISTRIBUTION_LOG")) || string.equalsIgnoreCase(this.getResString("IDS_GLM_DISTRIBUTION_POWER"))) {
                    string2 = string;
                    break;
                }
                string2 = this.getResString("IDS_GLM_DISTRIBUTION_POWER");
                break;
            }
            case 3: {
                if (string.equalsIgnoreCase(this.getResString("IDS_GLM_DISTRIBUTION_CUM_CAUCHIT")) || string.equalsIgnoreCase(this.getResString("IDS_GLM_DISTRIBUTION_CUM_COMP_LOGLOG")) || string.equalsIgnoreCase(this.getResString("IDS_GLM_DISTRIBUTION_CUM_LOGIT")) || string.equalsIgnoreCase(this.getResString("IDS_GLM_DISTRIBUTION_CUM_NEG_LOGLOG")) || string.equalsIgnoreCase(this.getResString("IDS_GLM_DISTRIBUTION_CUM_PROBIT"))) {
                    string2 = string;
                    break;
                }
                string2 = this.getResString("IDS_GLM_DISTRIBUTION_CUM_LOGIT");
                break;
            }
            case 4: {
                if (string.equalsIgnoreCase(this.getResString("IDS_GLM_DISTRIBUTION_IDENTITY")) || string.equalsIgnoreCase(this.getResString("IDS_GLM_DISTRIBUTION_LOG")) || string.equalsIgnoreCase(this.getResString("IDS_GLM_DISTRIBUTION_NEGATIVE_BIONOMIAL")) || string.equalsIgnoreCase(this.getResString("IDS_GLM_DISTRIBUTION_POWER"))) {
                    string2 = string;
                    break;
                }
                string2 = this.getResString("IDS_GLM_DISTRIBUTION_LOG");
                break;
            }
            case 6: {
                if (string.equalsIgnoreCase(this.getResString("IDS_GLM_DISTRIBUTION_IDENTITY")) || string.equalsIgnoreCase(this.getResString("IDS_GLM_DISTRIBUTION_LOG")) || string.equalsIgnoreCase(this.getResString("IDS_GLM_DISTRIBUTION_POWER"))) {
                    string2 = string;
                    break;
                }
                string2 = this.getResString("IDS_GLM_DISTRIBUTION_LOG");
                break;
            }
        }
        return string2;
    }

    private void initVars() {
        this.mChooseLabel = new JLabel(this.getResString("IDS_GLM_TYPEOFMODEL_CHOOSE_ONE_LABEL"));
        this.mButtonGroup = new SpssButtonGroup();
        this.mLinearRadio = new JRadioButton(new ToggleButtonAction(this.mParent, RADIO_LINEAR));
        this.mLinearRadio.addItemListener(this);
        this.mGammaRadio = new JRadioButton(new ToggleButtonAction(this.mParent, RADIO_GAMMA));
        this.mGammaRadio.addItemListener(this);
        this.mPoissonRadio = new JRadioButton(new ToggleButtonAction(this.mParent, RADIO_POISSON));
        this.mPoissonRadio.addItemListener(this);
        this.mNegBinLogLinkRadio = new JRadioButton(new ToggleButtonAction(this.mParent, RADIO_NEGBIN));
        this.mNegBinLogLinkRadio.addItemListener(this);
        this.mCustomRadio = new JRadioButton(new ToggleButtonAction(this.mParent, RADIO_CUSTOM));
        this.mCustomRadio.addItemListener(this);
        this.mTweedieLogLinkRadio = new JRadioButton(new ToggleButtonAction(this.mParent, RADIO_TWEEDIE_LOGLINK));
        this.mTweedieLogLinkRadio.addItemListener(this);
        this.mTweedieIdentRadio = new JRadioButton(new ToggleButtonAction(this.mParent, RADIO_TWEEDIE_IDENTLINK));
        this.mTweedieIdentRadio.addItemListener(this);
        this.mOrdLogisticRadio = new JRadioButton(new ToggleButtonAction(this.mParent, RADIO_ORD_LOGISTIC));
        this.mOrdLogisticRadio.addItemListener(this);
        this.mOrdProbitRadio = new JRadioButton(new ToggleButtonAction(this.mParent, RADIO_ORD_PROBIT));
        this.mOrdProbitRadio.addItemListener(this);
        this.mBinLogisticRadio = new JRadioButton(new ToggleButtonAction(this.mParent, RADIO_BIN_LOGISTIC));
        this.mBinLogisticRadio.addItemListener(this);
        this.mBinProbitRadio = new JRadioButton(new ToggleButtonAction(this.mParent, RADIO_BIN_PROBIT));
        this.mBinProbitRadio.addItemListener(this);
        this.mIntervalRadio = new JRadioButton(new ToggleButtonAction(this.mParent, RADIO_INTERVAL_SURVIVAL));
        this.mIntervalRadio.addItemListener(this);
        this.mButtonGroup.add(this.mLinearRadio);
        this.mButtonGroup.add(this.mGammaRadio);
        this.mButtonGroup.add(this.mPoissonRadio);
        this.mButtonGroup.add(this.mNegBinLogLinkRadio);
        this.mButtonGroup.add(this.mTweedieLogLinkRadio);
        this.mButtonGroup.add(this.mTweedieIdentRadio);
        this.mButtonGroup.add(this.mCustomRadio);
        this.mButtonGroup.add(this.mOrdLogisticRadio);
        this.mButtonGroup.add(this.mOrdProbitRadio);
        this.mButtonGroup.add(this.mBinLogisticRadio);
        this.mButtonGroup.add(this.mBinProbitRadio);
        this.mButtonGroup.add(this.mIntervalRadio);
        this.mDistributionCombo = new JComboBox<String>(this.getResStringArray("IDS_GLM_DISTRIBUTION_VALUES_1"));
        this.mDistributionCombo.addItemListener(this);
        this.mDistributionCombo.setAction(new ComboboxAction(this.mParent, DISTRIBUTION_KEY));
        this.mLinkFunctionCombo = new JComboBox<String>(this.getResStringArray("IDS_GLM_LINK_FUNCTION_VALUES"));
        this.mLinkFunctionCombo.addItemListener(this);
        this.mLinkFunctionCombo.setAction(new ComboboxAction(this.mParent, LINK_FUNC_KEY));
        Dimension dimension = this.mLinkFunctionCombo.getMinimumSize();
        dimension.width += 75;
        this.mLinkFunctionCombo.setPreferredSize(dimension);
        this.mParamButtonGroup = new SpssButtonGroup();
        this.mSpecifyValueRadio = new JRadioButton(new ToggleButtonAction(this.mParent, RADIO_SPECIFY_VALUE));
        this.mSpecifyValueRadio.addItemListener(this);
        this.mEstimateValueRadio = new JRadioButton(new ToggleButtonAction(this.mParent, RADIO_ESTIMATE_VALUE));
        this.mEstimateValueRadio.addItemListener(this);
        this.mParamButtonGroup.add(this.mSpecifyValueRadio);
        this.mParamButtonGroup.add(this.mEstimateValueRadio);
        this.mValueLabel = DialogUtil.createLabel(this.mParent, VALUE_FIELD_KEY);
        this.mValueField = new FloatTextField(true);
        this.mValueLabel.setLabelFor((Component)this.mValueField);
        this.mValueField.getDocument().addDocumentListener(this);
        this.mValueField.addFocusListener((FocusListener)this);
        this.mValueField.setAction((Action)new TextFieldAction(this.mParent, VALUE_FIELD_KEY));
        this.mPowerLabel = DialogUtil.createLabel(this.mParent, POWER_FIELD_KEY);
        this.mPowerField = new FloatTextField(false);
        this.mPowerLabel.setLabelFor((Component)this.mPowerField);
        this.mPowerField.getDocument().addDocumentListener(this);
        this.mPowerField.addFocusListener((FocusListener)this);
        this.mPowerField.setAction((Action)new TextFieldAction(this.mParent, POWER_FIELD_KEY));
        Dimension dimension2 = this.mPowerField.getSize();
        dimension2.width *= 2;
        this.mPowerField.setMinimumSize(dimension2);
    }

    private JPanel setupCustomPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.mDistributionLabel = DialogUtil.createLabel(this.mParent, DISTRIBUTION_KEY);
        this.mLinkFunctionLabel = DialogUtil.createLabel(this.mParent, LINK_FUNC_KEY);
        this.mDistributionLabel.setLabelFor(this.mDistributionCombo);
        this.mLinkFunctionLabel.setLabelFor(this.mLinkFunctionCombo);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        Insets insets = new Insets(n2 - 4, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel2, this.mDistributionLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(n2 - 4, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel2, this.mDistributionCombo, gridBagConstraints, 1, 0, 1, 1, n, insets);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        insets.set(n2 - 4, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel3, this.mLinkFunctionLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(n2 - 4, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel3, this.mLinkFunctionCombo, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        this.mParameterPanel = new JPanel(true);
        this.mParameterPanel.setLayout(new GridBagLayout());
        this.mParameterPanelBorder = new TitledBorder(this.getResString("IDS_GLM_TYPEOFMODEL_PARAMETER"));
        this.mParameterPanel.setBorder(this.mParameterPanelBorder);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.fill = 2;
        Insets insets2 = DialogUtil.getStandardControlInsets();
        int n3 = 23;
        DialogUtil.addUsingGBL(this.mParameterPanel, this.mSpecifyValueRadio, gridBagConstraints2, 0, 0, 1, 1, n3, insets2);
        Insets insets3 = new Insets(insets2.top, insets2.left * 2, insets2.bottom, 0);
        JPanel jPanel4 = new JPanel(true);
        DialogUtil.addUsingGBL(jPanel4, this.mValueLabel, gridBagConstraints2, 0, 1, 1, 1, n3, insets3);
        insets3.set(insets2.top, 0, insets2.bottom, 0);
        DialogUtil.addUsingGBL(jPanel4, (JComponent)this.mValueField, gridBagConstraints2, 1, 1, 1, 1, n3, insets3);
        DialogUtil.addUsingGBL(this.mParameterPanel, jPanel4, gridBagConstraints2, 0, 2, 1, 1, n3, insets3);
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.weightx = 1.0;
        DialogUtil.addUsingGBL(this.mParameterPanel, this.mEstimateValueRadio, gridBagConstraints2, 0, 3, 1, 1, n3, insets2);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        insets.set(n2, n2 * 2 + 5, 0, n2);
        DialogUtil.addUsingGBL(jPanel5, this.mPowerLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        insets.set(n2, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel5, (JComponent)this.mPowerField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        insets.set(0, n2 * 4, 0, n2);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        insets.set(0, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets.set(n2, n2 * 7, 0, n2 * 3);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mParameterPanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(n2, n2 * 3, 0, n2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }
}

