/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssMultiLineCheckBox;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.GeneralizedLinearModelsDlg;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.generalized_estm_eqn.GeneralizedEstimatingEquationsDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.BootstrapDlg;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class StatisticsTab
extends BaseProcedureTab
implements ItemListener,
FocusListener {
    private static final int MAX_VAL_PRINT_INTERVAL = Integer.MAX_VALUE;
    private static final int MIN_VAL_PRINT_INTERVAL = 0;
    private static final String DEFAULT_TOLERANCE_LEVEL_VAL = ".0001";
    private static final String ANALYSIS_TYPE_KEY = "IDS_GLM_ANALYSIS_TYPE";
    private static final String LOG_LIKEHOOD_FUN_KEY = "IDS_GLM_LOG_LIKEHOOD";
    private static final String CONFIDENCE_INTERVAL_KEY = "IDS_GLM_CONFIDENCE_INTERVAL";
    private static final String PRINT_INTERVAL_KEY = "IDS_GLM_PRINT_INTERVAL";
    private static final String CONFIDENCE_INTERVAL_DEFAULT_VALUE = "95";
    private static final String PRINT_DEFAULT_VALUE = "1";
    private static final String CASE_PROCESSING_KEY = "IDS_GLM_CASE_PROCEESING";
    private static final String DESCRITPIVE_STAT_KEY = "IDS_GLM_DESCRIPTIVE_STATS";
    private static final String MODEL_INFO_KEY = "IDS_GLM_MODEL_INFO";
    private static final String GOODNESS_OF_FIT_STAT_KEY = "IDS_GLM_GOODNESS_OF_FIT_STAT";
    private static final String MODEL_SUMMARY_KEY = "IDS_GLM_MODEL_SUMMARY";
    private static final String PARAMETER_ESTIMATES_KEY = "IDS_GLM_PARAMETER_ESTIMATES";
    private static final String INCLUDE_EXPONENTIAL_KEY = "IDS_GLM_INCLUDE_EXPONENTIAL";
    private static final String COVARIANCE_MATRIX_KEY = "IDS_GLM_COVARIANCE_MATRIX";
    private static final String CORRELATION_MATRIX_KEY = "IDS_GLM_CORRELATION_MATRIX";
    private static final String WORKING_CORRELATION_KEY = "IDS_GLM_WORKING_CORRELATION";
    private static final String CONTRAST_COEFICIENT_KEY = "IDS_GLM_CONTRAST_COFFICIENT";
    private static final String GENERAL_ESTIMABLE_KEY = "IDS_GLM_GENERAL_ESTIMABLE";
    private static final String ITERATION_HISTORY_KEY = "IDS_GLM_ITERATION_HISTORY";
    private static final String LAGRANGE_MULTIPLIER_KEY = "IDS_GLM_LAGRANGE_MULTIPLIER";
    private static final String RADIO_WALD_CHISQUARE_KEY = "IDS_GLM_STATS_WALD";
    private static final String RADIO_LIKELIHOOD_KEY = "IDS_GLM_STATS_LIKELIHOOD_RATIO";
    private static final String RADIO_GENERALIZED_SCORE_KEY = "IDS_GEE_STATS_GENERALIZED_SCORE";
    private static final String RADIO_CI_WALD_KEY = "IDS_GLM_STATS_CI_WALD";
    private static final String RADIO_CI_PROFILE_KEY = "IDS_GLM_STATS_CI_PROF_LIKE";
    private static final String TOLERANCE_FIELD_KEY = "IDS_GLM_STATS_CI_TOLERANCE_LEVEL_DOT";
    private JCheckBox mParameterEstimatesCheck;
    private JCheckBox mIterationHistoryCheck;
    private JLabel mPrintLabel;
    private IntTextField mPrintField;
    private JCheckBox mIncludeExponentialCheck;
    private JComboBox mLogLikehoodFunCombo;
    private JCheckBox mLagrangeMultiplierCheck;
    private JCheckBox mCaseProcessingSummaryCheck;
    private JCheckBox mDescritiveStatsCheck;
    private JCheckBox mModelInfoCheck;
    private JCheckBox mGoodnessOfFitStatCheck;
    private JCheckBox mModelSummaryCheck;
    private JCheckBox mCovarianceMatrixCheck;
    private JCheckBox mCorrelationMatrixCheck;
    private JCheckBox mWorkingCorrelationMatrixCheck;
    private JCheckBox mContrastCoeffMatrixCheck;
    private JCheckBox mGeneralEstimableMatrixCheck;
    private JComboBox mAnalysisTypeCombo;
    private FloatTextField mConfidenceIntervalField;
    private Vector<Object> mComponent;
    private StringBuffer mSyntax;
    private SpssButtonGroup mPrintGroup;
    private boolean mIsGEE;
    private JLabel mLogLikehoodfuncLabel;
    private JRadioButton mChiSquareWaldRadio;
    private JRadioButton mChiSquareLikelihoodRadio;
    private JRadioButton mChiSquareGenScoreRadio;
    private JRadioButton mConfIntWaldRadio;
    private JRadioButton mProfileLikelihoodRadio;
    private JLabel mToleranceLevelLabel;
    private FloatTextField mToleranceLevelField;
    private SpssButtonGroup mChiSquareButtonGroup;
    private SpssButtonGroup mConfIntervalButtonGroup;
    private JButton mBootstrapButton;
    private boolean mIsBootstrapOK;

    public StatisticsTab(BaseTabbedDialog baseTabbedDialog, boolean bl) {
        super(baseTabbedDialog, true);
        this.mIsGEE = bl;
        this.initilaizePanel();
    }

    public static JPanel setUpLinePanel(String string) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(string);
        JPanel jPanel2 = new JPanel();
        DialogUtil.applyTopBorder(jPanel2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2 - 4, 0, 0, n2);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        insets.set(n2, n2, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    public static JPanel setUpLinePanel(String string, ImageIcon imageIcon) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(string);
        jLabel.setIcon(imageIcon);
        JPanel jPanel2 = new JPanel();
        DialogUtil.applyTopBorder(jPanel2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        Insets insets = new Insets(n2 - 4, n2, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    public static JPanel setUpRadioButtonLinePanel(JRadioButton jRadioButton, ImageIcon imageIcon) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jRadioButton.setIcon(imageIcon);
        JPanel jPanel2 = new JPanel();
        DialogUtil.applyTopBorder(jPanel2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, jRadioButton, gridBagConstraints, 0, 0, 1, 1, n, null);
        Insets insets = new Insets(n2 - 4, n2, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mConfidenceIntervalField)) {
            this.mConfidenceIntervalField.selectAll();
        }
        if (focusEvent.getSource().equals(this.mPrintField)) {
            this.mPrintField.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mPrintField)) {
            this.mPrintField.setSelectionStart(0);
            this.mPrintField.setSelectionEnd(0);
        }
    }

    @Override
    public void reset() {
        this.setDefaults();
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mAnalysisTypeCombo;
    }

    @Override
    public String getDialogHelpID() {
        if (this.mIsGEE) {
            return "idh_idd_gee_statistics";
        }
        return "idh_idd_genlin_statistics";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.mPrintField.setEnabled(this.mIterationHistoryCheck.isSelected());
        this.mPrintField.setOpaque(this.mIterationHistoryCheck.isSelected());
        this.mPrintLabel.setEnabled(this.mIterationHistoryCheck.isSelected());
        this.mIncludeExponentialCheck.setEnabled(this.mParameterEstimatesCheck.isSelected());
        if (!this.mIsGEE) {
            boolean bl = false;
            if (this.mProfileLikelihoodRadio.isSelected()) {
                bl = true;
            }
            this.mToleranceLevelLabel.setEnabled(bl);
            this.mToleranceLevelField.setEnabled(bl);
            this.mToleranceLevelField.setOpaque(bl);
        }
    }

    public String getGeneratedSyntaxForModelEffect() {
        this.mSyntax.delete(0, this.mSyntax.length());
        this.mSyntax.append(" ANALYSISTYPE=");
        if (this.mAnalysisTypeCombo.getSelectedIndex() == 0) {
            this.mSyntax.append(PRINT_DEFAULT_VALUE);
        } else if (this.mAnalysisTypeCombo.getSelectedIndex() == 1) {
            this.mSyntax.append("3");
        } else {
            this.mSyntax.append("ALL");
        }
        if (this.mChiSquareWaldRadio.isSelected()) {
            this.mSyntax.append("(WALD)");
        } else {
            this.mSyntax.append("(LR)");
        }
        this.mSyntax.append(" CILEVEL=" + this.mConfidenceIntervalField.getText());
        if (!this.mIsGEE) {
            if (this.mConfIntWaldRadio.isSelected()) {
                this.mSyntax.append(" CITYPE=WALD");
            } else {
                this.mSyntax.append(" CITYPE=PROFILE(" + this.mToleranceLevelField.getText() + ")");
            }
        }
        this.mSyntax.append(" LIKELIHOOD=");
        if (this.mLogLikehoodFunCombo.getSelectedIndex() == 0) {
            this.mSyntax.append("FULL");
        } else if (this.mLogLikehoodFunCombo.getSelectedIndex() == 1) {
            this.mSyntax.append("KERNEL");
        }
        return this.mSyntax.toString();
    }

    public String getGeneratedSyntaxForPrint() {
        boolean bl = false;
        if (!this.mIsGEE) {
            bl = ((GeneralizedLinearModelsDlg)this.mParent).estTab.getScaleMethod().equals(this.getResString("IDS_GLM_ESTIMATION_MAX_LIKELIHOOD_ESTIMATE"));
            DialogUtil.enableHTMLComponent(this.mLagrangeMultiplierCheck, !bl);
        }
        this.mSyntax.delete(0, this.mSyntax.length());
        Vector<String> vector = new Vector<String>();
        this.mSyntax.append(SyntaxUtil.getSubCommand("/PRINT"));
        boolean bl2 = this.mCaseProcessingSummaryCheck.isSelected();
        if (bl2) {
            vector.add("CPS");
        }
        if (bl2 = this.mDescritiveStatsCheck.isSelected()) {
            vector.add("DESCRIPTIVES");
        }
        if (bl2 = this.mModelInfoCheck.isSelected()) {
            vector.add("MODELINFO");
        }
        boolean bl3 = bl2 = this.mGoodnessOfFitStatCheck.isEnabled() && this.mGoodnessOfFitStatCheck.isSelected();
        if (bl2) {
            vector.add("FIT");
        }
        if (bl2 = this.mModelSummaryCheck.isSelected()) {
            vector.add("SUMMARY");
        }
        if (bl2 = this.mParameterEstimatesCheck.isSelected()) {
            vector.add("SOLUTION");
            boolean bl4 = bl2 = this.mIncludeExponentialCheck.isSelected() && this.mIncludeExponentialCheck.isEnabled();
            if (bl2) {
                vector.add("(EXPONENTIATED)");
            }
        }
        if (bl2 = this.mCovarianceMatrixCheck.isSelected()) {
            vector.add("COVB");
        }
        if (bl2 = this.mCorrelationMatrixCheck.isSelected()) {
            vector.add("CORB");
        }
        if (this.mIsGEE && (bl2 = this.mWorkingCorrelationMatrixCheck.isSelected())) {
            vector.add("WORKINGCORR");
        }
        if (bl2 = this.mContrastCoeffMatrixCheck.isSelected()) {
            vector.add("LMATRIX");
        }
        if (bl2 = this.mGeneralEstimableMatrixCheck.isSelected()) {
            vector.add("GEF");
        }
        if (bl2 = this.mIterationHistoryCheck.isSelected()) {
            vector.add("HISTORY(" + this.mPrintField.getText() + ")");
        }
        if (!this.mIsGEE) {
            boolean bl5 = bl2 = this.mLagrangeMultiplierCheck.isSelected() && this.mLagrangeMultiplierCheck.isEnabled();
            if (bl2) {
                vector.add("LAGRANGE");
            }
        }
        if (vector.size() == 0) {
            this.mSyntax.append(" NONE");
        } else {
            for (int i = 0; i < vector.size(); ++i) {
                this.mSyntax.append(" " + (String)vector.get(i));
            }
        }
        return this.mSyntax.toString();
    }

    @Override
    protected void aboutToShowTab() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!this.mIsGEE) {
            bl = ((GeneralizedLinearModelsDlg)this.mParent).estTab.getScaleMethod().equals(this.getResString("IDS_GLM_ESTIMATION_MAX_LIKELIHOOD_ESTIMATE"));
            bl2 = ((GeneralizedLinearModelsDlg)this.mParent).getTypeOfModelTab().isNormalSelected() || ((GeneralizedLinearModelsDlg)this.mParent).getTypeOfModelTab().isGammaSelected() || ((GeneralizedLinearModelsDlg)this.mParent).getTypeOfModelTab().isInvGaussianSelected() || ((GeneralizedLinearModelsDlg)this.mParent).getTypeOfModelTab().isTweedieSelected();
            bl3 = ((GeneralizedLinearModelsDlg)this.mParent).getTypeOfModelTab().isNegBinomialSelected() || ((GeneralizedLinearModelsDlg)this.mParent).getTypeOfModelTab().isNegativeBinLogLinkSelected();
            boolean bl4 = ((GeneralizedLinearModelsDlg)this.mParent).getTypeOfModelTab().isLinearSelected() || ((GeneralizedLinearModelsDlg)this.mParent).getTypeOfModelTab().isGammaWithLogLinkSelected() || ((GeneralizedLinearModelsDlg)this.mParent).getTypeOfModelTab().isTweedieLogLinkSelected() || ((GeneralizedLinearModelsDlg)this.mParent).getTypeOfModelTab().isTweedieWithIdentLinkSelected();
            DialogUtil.enableHTMLComponent(this.mLagrangeMultiplierCheck, !bl && bl2 || !bl && bl4 || bl3);
        } else if (((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab != null) {
            boolean bl5 = !((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab.isMultinomialSelected();
            this.enableLogQuasiCombo(bl5);
            bl5 = bl5 && !((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab.isOrdinalLogisticSelected() && !((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab.isOrdinalProbitSelected();
            this.mGoodnessOfFitStatCheck.setEnabled(bl5);
        }
    }

    public void enableLogQuasiCombo(boolean bl) {
        this.mLogLikehoodfuncLabel.setEnabled(bl);
        this.mLogLikehoodFunCombo.setEnabled(bl);
    }

    public void enableGoodnessOfFitCheck(boolean bl) {
        this.mGoodnessOfFitStatCheck.setEnabled(bl);
    }

    @Override
    public boolean validateTab() {
        String string = this.mConfidenceIntervalField.getText();
        if (string.equals("")) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_CONFIDENCE_INTERVAL_WARNING_MSG"), VersionInfo.getAppVersionString());
            GeneralizedLinearModelsDlg.setSelectionText((JComponent)this.mConfidenceIntervalField);
            return false;
        }
        double d = Double.parseDouble(string);
        if (d < 50.0 || d >= 100.0) {
            return false;
        }
        if (this.mPrintField.isEnabled() && this.mPrintField.getText().equals("")) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_PRINT_MAX_NTERVAL_WARN_MSG"), VersionInfo.getAppVersionString());
            GeneralizedLinearModelsDlg.setSelectionText((JComponent)this.mPrintField);
            return false;
        }
        if (this.mPrintField.isEnabled()) {
            try {
                long l = Long.parseLong(this.mPrintField.getText());
                if (l == 0L || l >= Integer.MAX_VALUE) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_PRINT_MAX_NTERVAL_WARN_MSG"), VersionInfo.getAppVersionString());
                    GeneralizedLinearModelsDlg.setSelectionText((JComponent)this.mPrintField);
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (!this.mIsGEE) {
            double d2;
            if (this.mToleranceLevelField.isEnabled() && this.mToleranceLevelField.getText().equals("")) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_STATS_TOLERANCE_NOVAL_MSG"), VersionInfo.getAppVersionString());
                GeneralizedLinearModelsDlg.setSelectionText((JComponent)this.mToleranceLevelField);
                return false;
            }
            if (this.mToleranceLevelField.isEnabled() && (d2 = Double.valueOf(this.mToleranceLevelField.getText()).doubleValue()) == 0.0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_STATS_TOLERANCE_VAL_ZERO_MSG"), VersionInfo.getAppVersionString());
                GeneralizedLinearModelsDlg.setSelectionText((JComponent)this.mToleranceLevelField);
                return false;
            }
        }
        return true;
    }

    protected void initilaizePanel() {
        super.initPanel();
        this.initVars();
        this.setDefaults();
        this.setFocusTraversalPolicy();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = 23;
        Insets insets = new Insets(UIToolDialogUtil.getStandardDialogInsets().top, UIToolDialogUtil.getStandardDialogInsets().left, 0, UIToolDialogUtil.getStandardDialogInsets().right);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, StatisticsTab.setUpLinePanel(this.getResString("IDS_GLM_MODEL_EFFECTS")), gridBagConstraints, 0, 0, 1, 1, n2, insets);
        insets.set(0, UIToolDialogUtil.getStandardDialogInsets().left, 0, UIToolDialogUtil.getStandardDialogInsets().right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this, this.setUpModelEffectsPanel(), gridBagConstraints, 0, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(n + 25, UIToolDialogUtil.getStandardDialogInsets().left, 0, UIToolDialogUtil.getStandardDialogInsets().right);
        DialogUtil.addUsingGBL(this, StatisticsTab.setUpLinePanel(this.getResString("IDS_GLM_PRINT")), gridBagConstraints, 0, 2, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(0, UIToolDialogUtil.getStandardDialogInsets().left, 0, UIToolDialogUtil.getStandardDialogInsets().right);
        DialogUtil.addUsingGBL(this, this.setUpPrintPanel(), gridBagConstraints, 0, 3, 1, 1, n2, insets);
    }

    private void setFocusTraversalPolicy() {
        this.mComponent.clear();
        this.mComponent.add(this.mAnalysisTypeCombo);
        if (!this.mIsGEE) {
            this.mComponent.add(this.mChiSquareWaldRadio);
            this.mComponent.add(this.mChiSquareLikelihoodRadio);
            this.mComponent.add(this.mConfidenceIntervalField);
            this.mComponent.add(this.mConfIntWaldRadio);
            this.mComponent.add(this.mProfileLikelihoodRadio);
            this.mComponent.add(this.mToleranceLevelField);
        } else {
            this.mComponent.add(this.mConfidenceIntervalField);
            this.mComponent.add(this.mChiSquareWaldRadio);
            this.mComponent.add(this.mChiSquareGenScoreRadio);
        }
        this.mComponent.add(this.mLogLikehoodFunCombo);
        if (!this.mIsGEE && this.mBootstrapButton != null) {
            this.mComponent.add(this.mBootstrapButton);
        }
        this.mComponent.add(this.mCaseProcessingSummaryCheck);
        this.mComponent.add(this.mDescritiveStatsCheck);
        this.mComponent.add(this.mModelInfoCheck);
        this.mComponent.add(this.mGoodnessOfFitStatCheck);
        this.mComponent.add(this.mModelSummaryCheck);
        this.mComponent.add(this.mParameterEstimatesCheck);
        this.mComponent.add(this.mIncludeExponentialCheck);
        this.mComponent.add(this.mCovarianceMatrixCheck);
        this.mComponent.add(this.mCorrelationMatrixCheck);
        if (this.mIsGEE) {
            this.mComponent.add(this.mWorkingCorrelationMatrixCheck);
        }
        this.mComponent.add(this.mContrastCoeffMatrixCheck);
        this.mComponent.add(this.mGeneralEstimableMatrixCheck);
        this.mComponent.add(this.mIterationHistoryCheck);
        this.mComponent.add(this.mPrintField);
        if (!this.mIsGEE) {
            this.mComponent.add(this.mLagrangeMultiplierCheck);
        }
        JPanel jPanel = null;
        jPanel = !this.mIsGEE ? ((GeneralizedLinearModelsDlg)this.mParent).getCmdButtonPanel() : ((GeneralizedEstimatingEquationsDlg)this.mParent).getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            this.mComponent.add(component);
        }
        this.setComponentOrder(this.mComponent);
    }

    private JPanel setUpModelEffectsPanel() {
        JPanel jPanel;
        Object object;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this.mParent, ANALYSIS_TYPE_KEY);
        jLabel.setLabelFor(this.mAnalysisTypeCombo);
        JLabel jLabel2 = DialogUtil.createLabel(this.mParent, CONFIDENCE_INTERVAL_KEY);
        jLabel2.setLabelFor((Component)this.mConfidenceIntervalField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, 0, 0, 0);
        insets.set(0, n2, 0, n2);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel3, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(0, n2, 0, n2 + 40);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel3, this.mAnalysisTypeCombo, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets.set(n2 - 4, n2, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel2, jPanel3, gridBagConstraints, 0, 0, 1, 1, n, insets);
        Insets insets2 = DialogUtil.getStandardControlInsets();
        int n3 = 23;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        if (!this.mIsGEE) {
            object = new JComponent[]{this.mChiSquareWaldRadio, this.mChiSquareLikelihoodRadio};
            jPanel = PanelFactory.getBasicPanel(object, PanelFactory.PanelType.yaxis, this.getResString("IDS_GLM_STATS_CHI_SQUARE_STATS"));
            this.mChiSquareButtonGroup = DialogUtil.createButtonGroup(jPanel);
            insets.set(n2, 0, n2, n2);
            DialogUtil.addUsingGBL(jPanel2, jPanel, gridBagConstraints, 0, 1, 1, 2, n3, insets);
        } else {
            object = new JComponent[]{this.mChiSquareWaldRadio, this.mChiSquareGenScoreRadio};
            jPanel = PanelFactory.getBasicPanel(object, PanelFactory.PanelType.yaxis, this.getResString("IDS_GLM_STATS_CHI_SQUARE_STATS"));
            this.mChiSquareButtonGroup = DialogUtil.createButtonGroup(jPanel);
            insets.set(n2, 0, n2, n2);
            DialogUtil.addUsingGBL(jPanel2, jPanel, gridBagConstraints, 0, 1, 1, 2, n3, insets);
        }
        object = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.0;
        insets.set(0, n2 * 2, 0, n2);
        DialogUtil.addUsingGBL((Container)object, jLabel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(0, n2, 0, n2 + 100);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL((Container)object, (JComponent)this.mConfidenceIntervalField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(n2 - 4, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)object, gridBagConstraints, 1, 0, 1, 1, n, insets);
        if (!this.mIsGEE) {
            jPanel = new JPanel(true);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            n = 23;
            gridBagConstraints3.fill = 2;
            jPanel.setLayout(new GridBagLayout());
            TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_GLM_STATS_CONF_INT_TYPE"));
            jPanel.setBorder(titledBorder);
            gridBagConstraints3.weighty = 1.0;
            DialogUtil.addUsingGBL(jPanel, this.mConfIntWaldRadio, gridBagConstraints3, 0, 0, 1, 1, n, insets2);
            DialogUtil.addUsingGBL(jPanel, this.mProfileLikelihoodRadio, gridBagConstraints3, 0, 1, 1, 1, n, insets2);
            Insets insets3 = DialogUtil.getStandardControlInsets();
            gridBagConstraints2.fill = 0;
            JPanel jPanel4 = new JPanel(true);
            insets.set(insets3.top, 4, n2, n2);
            DialogUtil.addUsingGBL(jPanel4, this.mToleranceLevelLabel, gridBagConstraints2, 0, 1, 1, 1, n3, insets);
            insets.set(insets3.top, n2, n2, insets3.right);
            gridBagConstraints3.fill = 0;
            DialogUtil.addUsingGBL(jPanel4, (JComponent)this.mToleranceLevelField, gridBagConstraints2, 1, 1, 1, 1, n3, insets);
            gridBagConstraints3.weightx = 1.0;
            insets.set(insets2.top, 30, insets2.bottom, insets2.right);
            DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints3, 0, 2, 1, 1, n3, insets);
            insets.set(n2, n2, n2, n2);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            DialogUtil.addUsingGBL(jPanel2, jPanel, gridBagConstraints, 1, 1, 1, 1, n, insets);
        }
        jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.0;
        insets.set(0, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mLogLikehoodfuncLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        insets.set(0, n2, 0, n2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mLogLikehoodFunCombo, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        int n4 = 0;
        if (!this.mIsGEE) {
            n4 = -3 * n2;
        }
        insets.set(n4, n2, n2, n2);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel2, jPanel, gridBagConstraints, 0, 3, 1, 1, n, insets);
        if (!this.mIsGEE && this.mIsBootstrapOK) {
            insets.set(-4, n2 + 2, 2, n2);
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(jPanel2, this.mBootstrapButton, gridBagConstraints, 1, 4, 1, 1, n, insets);
        }
        return jPanel2;
    }

    private JPanel setUpPrintPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, n2, insets.bottom, insets.right);
        Insets insets3 = new Insets(n2, n2 + 35, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mCaseProcessingSummaryCheck, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mDescritiveStatsCheck, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mModelInfoCheck, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mGoodnessOfFitStatCheck, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mModelSummaryCheck, gridBagConstraints, 0, 5, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mParameterEstimatesCheck, gridBagConstraints, 0, 6, 1, 1, n, insets2);
        insets3.set(insets.top, n2 + 10, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mIncludeExponentialCheck, gridBagConstraints, 0, 7, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mCovarianceMatrixCheck, gridBagConstraints, 0, 8, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mCorrelationMatrixCheck, gridBagConstraints, 0, 9, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        insets3.set(insets.top, n2 * 3, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mContrastCoeffMatrixCheck, gridBagConstraints, 1, 1, 2, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mGeneralEstimableMatrixCheck, gridBagConstraints, 1, 2, 2, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mIterationHistoryCheck, gridBagConstraints, 1, 3, 2, 1, n, insets3);
        insets3.set(0, n2 + 45, 0, 0);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mPrintLabel, gridBagConstraints, 1, 4, 1, 1, n, insets3);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        insets3.set(0, n2, 0, 0);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mPrintField, gridBagConstraints, 2, 4, 1, 1, n, insets3);
        insets3.set(insets.top, n2 * 3, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mLagrangeMultiplierCheck, gridBagConstraints, 1, 5, 2, 2, n, insets3);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mWorkingCorrelationMatrixCheck, gridBagConstraints, 0, 10, 1, 1, n, insets2);
        return jPanel;
    }

    private void setDefaults() {
        this.mChiSquareWaldRadio.setSelected(true);
        if (!this.mIsGEE) {
            this.mConfIntWaldRadio.setSelected(true);
            this.mToleranceLevelLabel.setEnabled(false);
            this.mToleranceLevelField.setEnabled(false);
            this.mToleranceLevelField.setOpaque(false);
            this.mToleranceLevelField.setText(DEFAULT_TOLERANCE_LEVEL_VAL);
        }
        this.mCaseProcessingSummaryCheck.setSelected(true);
        this.mDescritiveStatsCheck.setSelected(true);
        this.mModelInfoCheck.setSelected(true);
        this.mGoodnessOfFitStatCheck.setSelected(true);
        this.mModelSummaryCheck.setSelected(true);
        this.mParameterEstimatesCheck.setSelected(true);
        this.mCovarianceMatrixCheck.setSelected(false);
        this.mCorrelationMatrixCheck.setSelected(false);
        this.mContrastCoeffMatrixCheck.setSelected(false);
        this.mGeneralEstimableMatrixCheck.setSelected(false);
        this.mIterationHistoryCheck.setSelected(false);
        this.mLagrangeMultiplierCheck.setSelected(false);
        this.mLagrangeMultiplierCheck.setEnabled(false);
        this.mWorkingCorrelationMatrixCheck.setSelected(false);
        this.mConfidenceIntervalField.setText(CONFIDENCE_INTERVAL_DEFAULT_VALUE);
        this.mPrintField.setText(PRINT_DEFAULT_VALUE);
        this.mIncludeExponentialCheck.setSelected(false);
        this.mAnalysisTypeCombo.setSelectedIndex(1);
        this.mLogLikehoodFunCombo.setSelectedIndex(0);
        this.mLagrangeMultiplierCheck.setVisible(!this.mIsGEE);
        this.mWorkingCorrelationMatrixCheck.setVisible(this.mIsGEE);
        DialogUtil.enableHTMLComponent(this.mLagrangeMultiplierCheck, false);
    }

    private void initVars() {
        this.mParameterEstimatesCheck = DialogUtil.createCheckBox(this.mParent, PARAMETER_ESTIMATES_KEY, null);
        this.mIterationHistoryCheck = DialogUtil.createCheckBox(this.mParent, ITERATION_HISTORY_KEY, null);
        this.mIncludeExponentialCheck = DialogUtil.createCheckBox(this.mParent, INCLUDE_EXPONENTIAL_KEY, null);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, LAGRANGE_MULTIPLIER_KEY);
        this.mLagrangeMultiplierCheck = new SpssMultiLineCheckBox(toggleButtonAction);
        this.mCaseProcessingSummaryCheck = DialogUtil.createCheckBox(this.mParent, CASE_PROCESSING_KEY, null);
        this.mDescritiveStatsCheck = DialogUtil.createCheckBox(this.mParent, DESCRITPIVE_STAT_KEY, null);
        this.mModelInfoCheck = DialogUtil.createCheckBox(this.mParent, MODEL_INFO_KEY, null);
        this.mGoodnessOfFitStatCheck = DialogUtil.createCheckBox(this.mParent, GOODNESS_OF_FIT_STAT_KEY, null);
        this.mModelSummaryCheck = DialogUtil.createCheckBox(this.mParent, MODEL_SUMMARY_KEY, null);
        this.mCovarianceMatrixCheck = DialogUtil.createCheckBox(this.mParent, COVARIANCE_MATRIX_KEY, null);
        this.mCorrelationMatrixCheck = DialogUtil.createCheckBox(this.mParent, CORRELATION_MATRIX_KEY, null);
        this.mWorkingCorrelationMatrixCheck = DialogUtil.createCheckBox(this.mParent, WORKING_CORRELATION_KEY, null);
        this.mContrastCoeffMatrixCheck = DialogUtil.createCheckBox(this.mParent, CONTRAST_COEFICIENT_KEY, null);
        this.mGeneralEstimableMatrixCheck = DialogUtil.createCheckBox(this.mParent, GENERAL_ESTIMABLE_KEY, null);
        this.mPrintLabel = DialogUtil.createLabel(this.mParent, PRINT_INTERVAL_KEY);
        this.mPrintField = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mPrintLabel.setLabelFor((Component)this.mPrintField);
        this.mPrintField.setColumns(7);
        this.mLogLikehoodFunCombo = new JComboBox<String>(this.getResStringArray("IDS_GLM_LOG_LIKEHOOD_FUN_VALUES"));
        Dimension dimension = this.mLogLikehoodFunCombo.getMinimumSize();
        dimension.width += 10;
        this.mLogLikehoodFunCombo.setPreferredSize(dimension);
        this.mComponent = new Vector();
        this.mAnalysisTypeCombo = new JComboBox<String>(this.getResStringArray("IDS_GLM_ANALYSIS_TYPE_VALUES"));
        this.mConfidenceIntervalField = new FloatTextField(50.0, 100.0, 45, true);
        this.mConfidenceIntervalField.setIncludeMinRange(true);
        this.mConfidenceIntervalField.setIncludeMaxRange(false);
        this.mSyntax = new StringBuffer();
        this.mAnalysisTypeCombo.setAction(new ComboboxAction(this.mParent, ANALYSIS_TYPE_KEY));
        this.mLogLikehoodFunCombo.setAction(new ComboboxAction(this.mParent, LOG_LIKEHOOD_FUN_KEY));
        dimension = this.mAnalysisTypeCombo.getMinimumSize();
        dimension.width += 40;
        this.mAnalysisTypeCombo.setPreferredSize(dimension);
        this.mConfidenceIntervalField.setAction((Action)new TextFieldAction(this.mParent, CONFIDENCE_INTERVAL_KEY));
        this.mPrintField.setAction((Action)new TextFieldAction(this.mParent, PRINT_INTERVAL_KEY));
        this.mPrintField.addFocusListener((FocusListener)this);
        this.mConfidenceIntervalField.addFocusListener((FocusListener)this);
        this.mIterationHistoryCheck.addItemListener(this);
        this.mParameterEstimatesCheck.addItemListener(this);
        this.mPrintGroup = new SpssButtonGroup();
        this.mPrintGroup.add(this.mCaseProcessingSummaryCheck);
        this.mPrintGroup.add(this.mDescritiveStatsCheck);
        this.mPrintGroup.add(this.mModelInfoCheck);
        this.mPrintGroup.add(this.mGoodnessOfFitStatCheck);
        this.mPrintGroup.add(this.mModelSummaryCheck);
        this.mPrintGroup.add(this.mParameterEstimatesCheck);
        this.mPrintGroup.add(this.mCovarianceMatrixCheck);
        this.mPrintGroup.add(this.mCorrelationMatrixCheck);
        if (this.mIsGEE) {
            this.mPrintGroup.add(this.mWorkingCorrelationMatrixCheck);
        }
        this.mPrintGroup.add(this.mContrastCoeffMatrixCheck);
        this.mPrintGroup.add(this.mGeneralEstimableMatrixCheck);
        this.mPrintGroup.add(this.mIterationHistoryCheck);
        if (!this.mIsGEE) {
            this.mPrintGroup.add(this.mLagrangeMultiplierCheck);
        }
        String string = !this.mIsGEE ? "IDS_GLM_LOG_LIKEHOOD_FUN" : "IDS_GEE_STATS_LOG_QUASI_FN";
        this.mLogLikehoodfuncLabel = DialogUtil.createLabel(this.mParent, string);
        this.mLogLikehoodfuncLabel.setLabelFor(this.mLogLikehoodFunCombo);
        this.mChiSquareWaldRadio = new JRadioButton(new ToggleButtonAction(this.mParent, RADIO_WALD_CHISQUARE_KEY));
        this.mChiSquareWaldRadio.addItemListener(this);
        if (!this.mIsGEE) {
            this.mChiSquareLikelihoodRadio = new JRadioButton(new ToggleButtonAction(this.mParent, RADIO_LIKELIHOOD_KEY));
            this.mChiSquareLikelihoodRadio.addItemListener(this);
        } else {
            this.mChiSquareGenScoreRadio = new JRadioButton(new ToggleButtonAction(this.mParent, RADIO_GENERALIZED_SCORE_KEY));
            this.mChiSquareGenScoreRadio.addItemListener(this);
        }
        if (!this.mIsGEE) {
            this.mConfIntervalButtonGroup = new SpssButtonGroup();
            this.mConfIntWaldRadio = new JRadioButton(new ToggleButtonAction(this.mParent, RADIO_CI_WALD_KEY));
            this.mConfIntWaldRadio.addItemListener(this);
            this.mConfIntervalButtonGroup.add(this.mConfIntWaldRadio);
            this.mProfileLikelihoodRadio = new JRadioButton(new ToggleButtonAction(this.mParent, RADIO_CI_PROFILE_KEY));
            this.mProfileLikelihoodRadio.addItemListener(this);
            this.mConfIntervalButtonGroup.add(this.mProfileLikelihoodRadio);
            this.mToleranceLevelLabel = DialogUtil.createLabel(this.mParent, TOLERANCE_FIELD_KEY);
            this.mToleranceLevelField = new FloatTextField(true);
            this.mToleranceLevelLabel.setLabelFor((Component)this.mToleranceLevelField);
            this.mToleranceLevelField.addFocusListener((FocusListener)this);
            this.mToleranceLevelField.setAction((Action)new TextFieldAction(this.mParent, TOLERANCE_FIELD_KEY));
        }
        this.mIsBootstrapOK = false;
        if (VersionInfo.allowBootstrapping()) {
            this.mIsBootstrapOK = true;
            ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction("IDS_COMMON_BOOTSTRAPPING_GLM_BUTTON"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StatisticsTab.this.runBootstrapSubDialog();
                }
            };
            this.mBootstrapButton = new JButton(toggleButtonAction2);
            if (BootstrapDlg.isCurrentDatasetInMIMode()) {
                this.mBootstrapButton.setEnabled(false);
                this.mIsBootstrapOK = false;
            }
        }
    }

    private void runBootstrapSubDialog() {
        if (!this.mIsGEE) {
            ((GeneralizedLinearModelsDlg)this.mParent).runSubDialog(new BootstrapDlg((GeneralizedLinearModelsDlg)this.mParent));
        }
    }
}

