/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model;

import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.SaveTab;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class SaveTableModel
extends AbstractTableModel {
    protected static String[] COLUMN_NAMES = new String[4];
    private Vector<SaveTab.SaveTableItem> mData;
    private JTable mTable;
    private boolean mGLM;

    public SaveTableModel(Vector<SaveTab.SaveTableItem> vector, JTable jTable, boolean bl) {
        this.mData = vector;
        this.mTable = jTable;
        this.mGLM = bl;
    }

    @Override
    public int getRowCount() {
        return this.mGLM ? 14 : 8;
    }

    public int getSize() {
        return this.mData.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    public Object getValue(int n) {
        if (n < 0 || n >= this.getSize()) {
            return null;
        }
        return this.mData.get(n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        SaveTab.SaveTableItem saveTableItem = this.mData.get(n);
        switch (n2) {
            case 0: {
                return saveTableItem.getSave();
            }
            case 1: {
                return saveTableItem.getItemToSave();
            }
            case 2: {
                return saveTableItem.getVariableName();
            }
            case 3: {
                if (saveTableItem.getCatsEnabled()) {
                    return saveTableItem.getNumCategories();
                }
                return "";
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        SaveTab.SaveTableItem saveTableItem = this.mData.get(n);
        if (n2 == 0) {
            Boolean bl = (Boolean)object;
            saveTableItem.setSave(bl);
            this.mTable.repaint();
        } else if (n2 == 2) {
            saveTableItem.setVariableName(object.toString());
        } else if (n2 == 3) {
            try {
                Integer n3 = new Integer(object.toString());
                saveTableItem.setNumCategories(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        SaveTab.SaveTableItem saveTableItem = this.mData.get(n);
        if (n2 == 0) {
            return saveTableItem.isEnabled();
        }
        if (n2 == 2) {
            return saveTableItem.getSave();
        }
        return n2 == 3 && saveTableItem.getSave() && saveTableItem.getCatsEnabled();
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 0) {
            return Boolean.class;
        }
        return super.getColumnClass(n);
    }

    public Vector<SaveTab.SaveTableItem> getTableData() {
        return this.mData;
    }

    public void setTableData(Vector<SaveTab.SaveTableItem> vector) {
        this.mData = vector;
    }
}

