/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.GeneralizedLinearModelsDlg;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.SaveTableModel;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.generalized_estm_eqn.GeneralizedEstimatingEquationsDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.util.TraceSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.font.TextAttribute;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.EventObject;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;

public class SaveTab
extends BaseProcedureTab {
    private final int DISTRIBUTION_BINOMIAL_INDEX = 0;
    private final int DISTRIBUTION_MULTINOMIAL_INDEX = 3;
    private final int SAVE_ITEM_IDX = 3;
    private final int COOKS_DISTANCE_IDX = 6;
    private final int LEVERAGE_VAL_IDX = 7;
    private final int RAW_RESID_IDX = 8;
    private final int PEARSON_RESID_IDX = 9;
    private final int STD_PEARSON_RESID_IDX = 10;
    private final int DEV_RESID_IDX = 11;
    private final int STD_DEV_RESID_IDX = 12;
    private final int LIKE_RESID_IDX = 13;
    private final int GEE_RAW_RESID_IDX = 6;
    private final int GEE_PEARSON_RESID_IDX = 7;
    private final String DEFAULT_CATEGORIES = "25";
    public static final String DISABLED_CATEGORIES = "-1";
    private PlainTable mSaveTable;
    private JRadioButton mAddRadio;
    private JRadioButton mReplaceRadio;
    private SpssButtonGroup mRadioButtonGrp;
    private SaveTableModel mSaveTableModel;
    private boolean mGLM;
    private String[] saveSyntaxGLM = new String[]{"MEANPRED", "CIMEANPREDL", "CIMEANPREDU", "PREDVAL", "XBPRED", "XBSTDERROR", "COOK", "LEVERAGE", "RESID", "PEARSONRESID", "STDPEARSONRESID", "DEVIANCERESID", "STDDEVIANCERESID", "LIKELIHOODRESID"};
    private String[] saveSyntaxGEE = new String[]{"MEANPRED", "CIMEANPREDL", "CIMEANPREDU", "PREDVAL", "XBPRED", "XBSTDERROR", "RESID", "PEARSONRESID"};
    static final String ADD_SUFFIX_RADIO_BUTTON_KEY = "IDS_GLM_SAVE_ADD_SUFFIX_RADIO";
    static final String REPLACE_EXISTING_VARIABLE_RADIO_BUTTON_KEY = "IDS_GLM_SAVE_REPLACE_EXISTING_VAR_RADIO";
    static final int VAR_ROOT_COL_IND = 2;

    public SaveTab(BaseTabbedDialog baseTabbedDialog, boolean bl) {
        super(baseTabbedDialog, true);
        this.mGLM = bl;
        this.initialize();
    }

    @Override
    public String getDialogHelpID() {
        if (this.mGLM) {
            return "idh_idd_genlin_save";
        }
        return "idh_idd_gee_save";
    }

    public String getDeleteVarsSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.mReplaceRadio.isSelected()) {
            LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            SaveTableModel saveTableModel = (SaveTableModel)this.mSaveTable.getModel();
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < saveTableModel.getRowCount(); ++i) {
                String string;
                int n;
                SaveTableItem saveTableItem = (SaveTableItem)saveTableModel.getValue(i);
                if (!saveTableItem.getSave() || !saveTableItem.isEnabled() || (n = iSpssDataSrc.findVarIndex(string = saveTableItem.getVariableName())) <= -1) continue;
                vector.add(string);
            }
            if (vector.size() > 0) {
                stringBuffer.append("DELETE VARIABLES ");
                for (String string : vector) {
                    stringBuffer.append(" ").append(string);
                }
                stringBuffer.append(".");
            }
        }
        return stringBuffer.toString();
    }

    public String getSaveTabSyntax() {
        SaveTableModel saveTableModel = (SaveTableModel)this.mSaveTable.getModel();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < saveTableModel.getRowCount(); ++i) {
            SaveTableItem saveTableItem = (SaveTableItem)saveTableModel.getValue(i);
            if (!saveTableItem.getSave() || !saveTableItem.isEnabled()) continue;
            if (this.mGLM) {
                stringBuffer.append(" ").append(this.saveSyntaxGLM[i]);
            } else {
                stringBuffer.append(" ").append(this.saveSyntaxGEE[i]);
            }
            String string = saveTableItem.getNumCategories();
            string = !saveTableItem.getCatsEnabled() ? "" : ":" + string;
            String string2 = saveTableItem.getVariableName();
            if (!string2.equals(saveTableItem.getDefaultVariableName())) {
                stringBuffer.append("(").append(string2).append(string).append(")");
                continue;
            }
            if (string.length() <= 0) continue;
            stringBuffer.append("(").append(string).append(")");
        }
        if (stringBuffer.length() != 0) {
            stringBuffer.insert(0, SyntaxUtil.getSubCommand("/SAVE"));
        }
        return stringBuffer.toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
        this.mSaveTableModel = this.getSaveTableModel();
        this.mSaveTable.setModel(this.mSaveTableModel);
        this.fitTableToTab();
    }

    @Override
    public boolean validateTab() {
        return this.isValidate();
    }

    public boolean isValidate() {
        int n;
        Object object;
        boolean bl = true;
        SaveTableModel saveTableModel = (SaveTableModel)this.mSaveTable.getModel();
        int n2 = -1;
        int n3 = -1;
        StringBuffer stringBuffer = new StringBuffer("");
        try {
            object = new Vector();
            for (n = 0; n < this.mSaveTable.getModel().getRowCount(); ++n) {
                SaveTableItem saveTableItem = (SaveTableItem)saveTableModel.getValue(n);
                if (!saveTableItem.getSave() || !saveTableItem.isEnabled()) continue;
                for (int i = 0; i < this.mSaveTable.getModel().getColumnCount(); ++i) {
                    String string;
                    TableCellEditor tableCellEditor;
                    if (i == 2) {
                        tableCellEditor = this.mSaveTable.getCellEditor();
                        if (tableCellEditor != null) {
                            tableCellEditor.stopCellEditing();
                            this.mSaveTable.getSelectionModel().clearSelection();
                        }
                        if (!this.isLegalValue(string = this.mSaveTable.getModel().getValueAt(n, i).toString())) {
                            this.changeSelection(n, i);
                            return false;
                        }
                        ((Vector)object).add(string);
                        if (this.isDuplicateValue((Vector<String>)object)) {
                            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_SAVE_DUPLICATE_VALUE_MSG"), VersionInfo.getAppVersionString());
                            this.changeSelection(n, i);
                            return false;
                        }
                        if (!this.mAddRadio.isSelected() || string.equals(saveTableItem.getDefaultVariableName()) || !this.existsInDataset(string)) continue;
                        stringBuffer.append(string).append("\n");
                        if (n2 >= 0) continue;
                        n2 = n;
                        n3 = i;
                        continue;
                    }
                    if (i != 3) continue;
                    tableCellEditor = this.mSaveTable.getCellEditor();
                    if (tableCellEditor != null) {
                        tableCellEditor.stopCellEditing();
                        this.mSaveTable.getSelectionModel().clearSelection();
                    }
                    if (!saveTableItem.getCatsEnabled()) continue;
                    string = this.mSaveTable.getModel().getValueAt(n, i).toString();
                    try {
                        Integer n4 = new Integer(string);
                        if (n4 >= 1) continue;
                        SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_SAVE_NUM_CATEGORIES_ERR_MSG"), VersionInfo.getAppVersionString());
                        this.changeSelection(n, i);
                        return false;
                    }
                    catch (NumberFormatException numberFormatException) {
                        SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_SAVE_NUM_CATEGORIES_ERR_MSG"), VersionInfo.getAppVersionString());
                        this.changeSelection(n, i);
                        return false;
                    }
                }
            }
        }
        catch (Exception exception) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_SAVE_VALID_VALUE_MSG"), VersionInfo.getAppVersionString());
            bl = false;
        }
        if (stringBuffer.toString().length() > 0) {
            object = this.getResString("ERR_GLM_SAVE_EXISTING_VAR_NAME_MSG");
            n = SpssAlertOptionPane.showConfirmDialog((Window)this.mParent, (String)(object = String.format((String)object, stringBuffer.toString())), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION);
            if (n == 1) {
                this.mReplaceRadio.setSelected(true);
                return true;
            }
            this.changeSelection(n2, n3);
            return false;
        }
        return bl;
    }

    public void updateSaveTab(int n, String string) {
        DialogDataModel dialogDataModel = ((BaseTabbedDialog)this.mParent).getDialogDataModel();
        if (dialogDataModel != null) {
            SaveTableModel saveTableModel = null;
            SerializableObject[] serializableObjectArray = dialogDataModel.getSerializableArray("IDS_GLM_SAVE_TABLE_MODEL");
            if (serializableObjectArray != null) {
                Vector<SaveTableItem> vector = new Vector<SaveTableItem>();
                for (SerializableObject serializableObject : serializableObjectArray) {
                    try {
                        if (!(serializableObject instanceof SaveTableItem)) continue;
                        vector.add(((SaveTableItem)serializableObject).clone());
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        // empty catch block
                    }
                }
                saveTableModel = new SaveTableModel(vector, this.mSaveTable, this.mGLM);
            }
            if (saveTableModel == null) {
                saveTableModel = this.mSaveTableModel;
            }
            if (saveTableModel != null) {
                if (n == 0 || n == 3 || string.equalsIgnoreCase("IDS_GLM_TYPEOFMODEL_ORD_LOGISTIC") || string.equalsIgnoreCase("IDS_GLM_TYPEOFMODEL_ORD_PROBIT") || string.equalsIgnoreCase("IDS_GLM_TYPEOFMODEL_BIN_LOGISTIC") || string.equalsIgnoreCase("IDS_GLM_TYPEOFMODEL_BIN_PROBIT") || string.equalsIgnoreCase("IDS_GLM_TYPEOFMODEL_INTERVAL_SURVIVAL")) {
                    this.enableItem(saveTableModel, 3, true);
                } else {
                    this.enableItem(saveTableModel, 3, false);
                }
                this.enableItem(saveTableModel, 6, this.mGLM && !this.isOrdLogisticProbitMultinomial(n, string));
                this.enableItem(saveTableModel, 7, this.mGLM && !this.isOrdLogisticProbitMultinomial(n, string));
                int n2 = this.mGLM ? 8 : 6;
                this.enableItem(saveTableModel, n2, !this.isOrdLogisticProbitMultinomial(n, string));
                n2 = this.mGLM ? 9 : 7;
                this.enableItem(saveTableModel, n2, !this.isOrdLogisticProbitMultinomial(n, string));
                this.enableItem(saveTableModel, 10, this.mGLM && !this.isOrdLogisticProbitMultinomial(n, string));
                this.enableItem(saveTableModel, 11, this.mGLM && !this.isOrdLogisticProbitMultinomial(n, string));
                this.enableItem(saveTableModel, 12, this.mGLM && !this.isOrdLogisticProbitMultinomial(n, string));
                this.enableItem(saveTableModel, 13, this.mGLM && !this.isOrdLogisticProbitMultinomial(n, string));
                this.mSaveTable.setModel(saveTableModel);
            }
            this.updateGridContents(saveTableModel);
        }
        this.fitTableToTab();
    }

    private void enableItem(SaveTableModel saveTableModel, int n, boolean bl) {
        SaveTableItem saveTableItem = (SaveTableItem)saveTableModel.getValue(n);
        if (saveTableItem != null) {
            saveTableItem.setEnabled(bl);
        } else {
            TraceSettings.trace1((String)"Missing model item in SaveTab", (int)15);
        }
    }

    private boolean isOrdLogisticProbitMultinomial(int n, String string) {
        return n == 3 || string.equalsIgnoreCase("IDS_GLM_TYPEOFMODEL_ORD_LOGISTIC") || string.equalsIgnoreCase("IDS_GLM_TYPEOFMODEL_ORD_PROBIT");
    }

    private void updateGridContents(SaveTableModel saveTableModel) {
        boolean bl;
        if (this.mGLM) {
            bl = ((GeneralizedLinearModelsDlg)this.mParent).mTypeOfModelTab.isMultinomialSelected() || ((GeneralizedLinearModelsDlg)this.mParent).mTypeOfModelTab.isOrdinalLogisticSelected() || ((GeneralizedLinearModelsDlg)this.mParent).mTypeOfModelTab.isOrdinalProbitSelected();
        } else {
            boolean bl2 = bl = ((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab.isMultinomialSelected() || ((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab.isOrdinalLogisticSelected() || ((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab.isOrdinalProbitSelected();
        }
        if (bl) {
            this.setTableItemInfo(saveTableModel, 0, "IDS_GLM_SAVE_CUM_PRED_PROBABILITY", "IDS_GLM_SAVE_CUM_PRED_PROBABILITY_VARNAME", true);
            this.setTableItemInfo(saveTableModel, 1, "IDS_GLM_SAVE_CI_CUM_PRED_LOWER", "IDS_GLM_SAVE_CI_CUM_PRED_LOWER_VARNAME", true);
            this.setTableItemInfo(saveTableModel, 2, "IDS_GLM_SAVE_CI_CUM_PRED_UPPER", "IDS_GLM_SAVE_CI_CUM_PRED_UPPER_VARNAME", true);
            this.setTableItemInfo(saveTableModel, 4, "IDS_GLM_SAVE_XB_PREDICTED_ITEM", "IDS_GLM_SAVE_XB_PREDICTED_VARNAME", true);
            this.setTableItemInfo(saveTableModel, 5, "IDS_GLM_SAVE_XB_STDERROR_ITEM", "IDS_GLM_SAVE_XB_STDERROR_VARNAME", true);
        } else {
            this.setTableItemInfo(saveTableModel, 0, "IDS_GLM_SAVE_MEAN_PREDICTED_ITEM", "IDS_GLM_SAVE_MEAN_PREDICTED_VARNAME", false);
            this.setTableItemInfo(saveTableModel, 1, "IDS_GLM_SAVE_CIMEANPREDICTED_LOWER_ITEM", "IDS_GLM_SAVE_CIMEANPREDICTED_LOWER_VARNAME", false);
            this.setTableItemInfo(saveTableModel, 2, "IDS_GLM_SAVE_CIMEANPREDICTED_UPPER_ITEM", "IDS_GLM_SAVE_CIMEANPREDICTED_UPPER_VARNAME", false);
            this.setTableItemInfo(saveTableModel, 4, "IDS_GLM_SAVE_XB_PREDICTED_ITEM", "IDS_GLM_SAVE_XB_PREDICTED_VARNAME", false);
            this.setTableItemInfo(saveTableModel, 5, "IDS_GLM_SAVE_XB_STDERROR_ITEM", "IDS_GLM_SAVE_XB_STDERROR_VARNAME", false);
        }
    }

    private void setTableItemInfo(SaveTableModel saveTableModel, int n, String string, String string2, boolean bl) {
        if (saveTableModel != null && saveTableModel.getSize() > n) {
            SaveTableItem saveTableItem = (SaveTableItem)saveTableModel.getValue(n);
            saveTableItem.setItemToSave(this.getResString(string));
            if (saveTableItem.getVariableName().equals(saveTableItem.getDefaultVariableName())) {
                saveTableItem.setVariableName(this.getResString(string2));
            }
            saveTableItem.setDefaultVariableName(this.getResString(string2));
            saveTableItem.setCatsEnabled(bl);
            if (saveTableItem.getNumCategories().equals("25") || saveTableItem.getNumCategories().equals(DISABLED_CATEGORIES)) {
                saveTableItem.setNumCategories("25");
            }
        }
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return this.mSaveTable;
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
        super.saveTabState(dialogDataModel);
        Vector<SaveTableItem> vector = ((SaveTableModel)this.mSaveTable.getModel()).getTableData();
        SerializableObject[] serializableObjectArray = new SerializableObject[vector.size()];
        try {
            dialogDataModel.putSerializableArray("IDS_GLM_SAVE_TABLE_MODEL", vector.toArray(serializableObjectArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        DialogDataModel dialogDataModel = ((BaseTabbedDialog)this.mParent).getDialogDataModel();
        if (this.mGLM) {
            int n = ((GeneralizedLinearModelsDlg)this.mParent).getTypeOfModelTab().getDistributionSelectedIndex();
            String string = ((GeneralizedLinearModelsDlg)this.mParent).getTypeOfModelTab().getSelectedModelType();
            this.updateSaveTab(n, string);
        } else {
            int n = ((GeneralizedEstimatingEquationsDlg)this.mParent).getTypeOfModelTab().getDistributionSelectedIndex();
            String string = ((GeneralizedEstimatingEquationsDlg)this.mParent).getTypeOfModelTab().getSelectedModelType();
            this.updateSaveTab(n, string);
        }
        this.mSaveTable.selectFirstCell();
    }

    private boolean isLegalValue(String string) {
        boolean bl;
        int n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
        if (n > 0 && n != 100) {
            DialogUtil.showBadSpssVarNameWarning(n, this.mParent);
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    private boolean isDuplicateValue(Vector<String> vector) {
        Object[] objectArray = vector.toArray();
        for (int i = 0; i <= vector.toArray().length - 1; ++i) {
            for (int j = i + 1; j <= vector.toArray().length - 1; ++j) {
                if (!objectArray[i].toString().equals(objectArray[j].toString())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean existsInDataset(String string) {
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        return iSpssDataSrc.findVarIndex(string) >= 0;
    }

    private void changeSelection(final int n, final int n2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SaveTab.this.mSaveTable.changeSelection(n, n2, false, false);
                SaveTab.this.mSaveTable.editCellAt(n, n2, null);
                SaveTab.this.mSaveTable.requestFocusInWindow();
            }
        });
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSaveTable);
        vector.add(this.mRadioButtonGrp);
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private void fitTableToTab() {
        final PlainTable plainTable = this.mSaveTable;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableColumnModel tableColumnModel = plainTable.getColumnModel();
                TableColumn tableColumn = tableColumnModel.getColumn(0);
                tableColumn.setPreferredWidth(40);
                tableColumn = tableColumnModel.getColumn(1);
                tableColumn.setPreferredWidth(350);
                tableColumn = tableColumnModel.getColumn(2);
                tableColumn.setPreferredWidth(150);
                tableColumn = tableColumnModel.getColumn(3);
                tableColumn.setPreferredWidth(110);
                plainTable.revalidate();
            }
        });
    }

    private void initialize() {
        this.initVars();
        JScrollPane jScrollPane = new JScrollPane(this.mSaveTable, 21, 31);
        Dimension dimension = jScrollPane.getSize();
        dimension.height = 300;
        jScrollPane.setPreferredSize(dimension);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardDialogInsets();
        Insets insets2 = new Insets(insets.top, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(this, jScrollPane, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets2.set(n2, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(this, this.setupExistingVarPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets2);
        this.setDefaults();
        this.setFocusTraversalPolicy();
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, ADD_SUFFIX_RADIO_BUTTON_KEY);
        this.mAddRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, REPLACE_EXISTING_VARIABLE_RADIO_BUTTON_KEY);
        this.mReplaceRadio = new JRadioButton(toggleButtonAction);
        this.mRadioButtonGrp = new SpssButtonGroup();
        this.mRadioButtonGrp.add(this.mAddRadio);
        this.mRadioButtonGrp.add(this.mReplaceRadio);
        this.mSaveTable = new PlainTable(){

            @Override
            public boolean editCellAt(int n, int n2, EventObject eventObject) {
                boolean bl = super.editCellAt(n, n2, eventObject);
                final Component component = this.getEditorComponent();
                if (component != null && component instanceof JTextComponent) {
                    if (ComponentState.isBtdRtlOrLtr() && n2 == 2 && (JTextComponent)component != null && ((JTextComponent)component).getDocument() != null) {
                        if (ComponentState.getBTD() == 1) {
                            ((JTextComponent)component).getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                        } else {
                            ((JTextComponent)component).getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                        }
                    }
                    if (eventObject == null) {
                        ((JTextComponent)component).selectAll();
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((JTextComponent)component).selectAll();
                            }
                        });
                    }
                }
                return bl;
            }
        };
        this.mSaveTableModel = this.getSaveTableModel();
        SaveTableModel.COLUMN_NAMES[0] = this.getResString("IDS_GLM_SAVE_TABLE_COLUMN_SAVE");
        SaveTableModel.COLUMN_NAMES[1] = this.getResString("IDS_GLM_SAVE_TABLE_COLUMN_ITEM_TO_SAVE");
        SaveTableModel.COLUMN_NAMES[2] = this.getResString("IDS_GLM_SAVE_TABLE_COLUMN_VARIABLE_NAME");
        SaveTableModel.COLUMN_NAMES[3] = this.getResString("IDS_GLM_SAVE_TABLE_COLUMN_CATEGORIES");
        this.mSaveTable.setModel(this.mSaveTableModel);
        this.mSaveTable.setColumnSelectionAllowed(true);
        this.mSaveTable.setSelectionMode(0);
        this.mSaveTable.setRowSelectionAllowed(true);
        this.mSaveTable.setCellSelectionEnabled(true);
        this.mSaveTable.setAutoResizeMode(0);
        this.mSaveTable.setDefaultRenderer(Object.class, new SaveTableRenderer());
        JTableHeader jTableHeader = this.mSaveTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setDefaultRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = null;
                jLabel = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? (JLabel)super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (n2 == 0) {
                    jLabel.setHorizontalAlignment(0);
                } else {
                    jLabel.setHorizontalAlignment(2);
                }
                jLabel.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                jLabel.setBackground(jTable.getTableHeader().getBackground());
                jLabel.setForeground(jTable.getTableHeader().getForeground());
                return jLabel;
            }
        });
        TableColumnModel tableColumnModel = this.mSaveTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumnModel.getColumn(0).setCellRenderer(new CheckBoxRenderer());
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        };
        this.mSaveTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.mSaveTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "tabOut");
        this.mSaveTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 1), "tabIn");
        this.mSaveTable.getActionMap().put("tabIn", abstractAction2);
        this.mSaveTable.getActionMap().put("tabOut", abstractAction);
    }

    private SaveTableModel getSaveTableModel() {
        Vector<SaveTableItem> vector = new Vector<SaveTableItem>();
        SaveTableItem saveTableItem = new SaveTableItem(false, this.getResString("IDS_GLM_SAVE_MEAN_PREDICTED_ITEM"), this.getResString("IDS_GLM_SAVE_MEAN_PREDICTED_VARNAME"), DISABLED_CATEGORIES, this.mGLM, false);
        vector.addElement(saveTableItem);
        saveTableItem = new SaveTableItem(false, this.getResString("IDS_GLM_SAVE_CIMEANPREDICTED_LOWER_ITEM"), this.getResString("IDS_GLM_SAVE_CIMEANPREDICTED_LOWER_VARNAME"), DISABLED_CATEGORIES, this.mGLM, false);
        vector.addElement(saveTableItem);
        saveTableItem = new SaveTableItem(false, this.getResString("IDS_GLM_SAVE_CIMEANPREDICTED_UPPER_ITEM"), this.getResString("IDS_GLM_SAVE_CIMEANPREDICTED_UPPER_VARNAME"), DISABLED_CATEGORIES, this.mGLM, false);
        vector.addElement(saveTableItem);
        saveTableItem = new SaveTableItem(false, this.getResString("IDS_GLM_SAVE_PREDICTED_CATEGORY_ITEM"), this.getResString("IDS_GLM_SAVE_PREDICTED_CATEGORY_VARNAME"), DISABLED_CATEGORIES, this.mGLM, false);
        vector.addElement(saveTableItem);
        saveTableItem.setEnabled(false);
        saveTableItem = new SaveTableItem(false, this.getResString("IDS_GLM_SAVE_XB_PREDICTED_ITEM"), this.getResString("IDS_GLM_SAVE_XB_PREDICTED_VARNAME"), DISABLED_CATEGORIES, this.mGLM, false);
        vector.addElement(saveTableItem);
        saveTableItem = new SaveTableItem(false, this.getResString("IDS_GLM_SAVE_XB_STDERROR_ITEM"), this.getResString("IDS_GLM_SAVE_XB_STDERROR_VARNAME"), DISABLED_CATEGORIES, this.mGLM, false);
        vector.addElement(saveTableItem);
        if (this.mGLM) {
            saveTableItem = new SaveTableItem(false, this.getResString("IDS_GLM_SAVE_COOKS_DISTANCE_ITEM"), this.getResString("IDS_GLM_SAVE_COOKS_DISTANCE_VARNAME"), DISABLED_CATEGORIES, this.mGLM, false);
            vector.addElement(saveTableItem);
            saveTableItem = new SaveTableItem(false, this.getResString("IDS_GLM_SAVE_LEVERAGE_ITEM"), this.getResString("IDS_GLM_SAVE_LEVERAGE_VARNAME"), DISABLED_CATEGORIES, this.mGLM, false);
            vector.addElement(saveTableItem);
        }
        saveTableItem = new SaveTableItem(false, this.getResString("IDS_GLM_SAVE_RAW_RESIDUAL_ITEM"), this.getResString("IDS_GLM_SAVE_RAW_RESIDUAL_VARNAME"), DISABLED_CATEGORIES, this.mGLM, false);
        vector.addElement(saveTableItem);
        saveTableItem = new SaveTableItem(false, this.getResString("IDS_GLM_SAVE_PEARSON_RESIDUAL_ITEM"), this.getResString("IDS_GLM_SAVE_PEARSON_RESIDUAL_VARNAME"), DISABLED_CATEGORIES, this.mGLM, false);
        vector.addElement(saveTableItem);
        if (this.mGLM) {
            saveTableItem = new SaveTableItem(false, this.getResString("IDS_GLM_SAVE_STD_PEARSON_RESIDUAL_ITEM"), this.getResString("IDS_GLM_SAVE_STD_PEARSON_RESIDUAL_VARNAME"), DISABLED_CATEGORIES, this.mGLM, false);
            vector.addElement(saveTableItem);
            saveTableItem = new SaveTableItem(false, this.getResString("IDS_GLM_SAVE_DEV_RESIDUAL_ITEM"), this.getResString("IDS_GLM_SAVE_DEV_RESIDUAL_VARNAME"), DISABLED_CATEGORIES, this.mGLM, false);
            vector.addElement(saveTableItem);
            saveTableItem = new SaveTableItem(false, this.getResString("IDS_GLM_SAVE_STD_DEV_RESIDUAL_ITEM"), this.getResString("IDS_GLM_SAVE_STD_DEV_RESIDUAL_VARNAME"), DISABLED_CATEGORIES, this.mGLM, false);
            vector.addElement(saveTableItem);
            saveTableItem = new SaveTableItem(false, this.getResString("IDS_GLM_SAVE_LIKELIHOOD_ITEM"), this.getResString("IDS_GLM_SAVE_LIKELIHOOD_VARNAME"), DISABLED_CATEGORIES, this.mGLM, false);
            vector.addElement(saveTableItem);
        }
        return new SaveTableModel(vector, this.mSaveTable, this.mGLM);
    }

    private void setDefaults() {
        this.mAddRadio.setSelected(true);
    }

    private JPanel setupExistingVarPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_GLM_SAVE_EXISTING_VARIABLE_WITH_SAME_NAME"));
        jPanel.setBorder(titledBorder);
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        JLabel jLabel = new JLabel();
        jLabel.setIcon(new ImageIcon(uRL));
        JTextArea jTextArea = new JTextArea();
        jTextArea.setRows(3);
        jTextArea.setOpaque(false);
        jTextArea.setFont(this.mAddRadio.getFont());
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setText(this.getResString("IDS_GLM_SAVE_EXISTING_VARIABLE_DESC"));
        jTextArea.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mAddRadio, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mReplaceRadio, gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        Insets insets2 = new Insets(3, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets2.set(0, 0, DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        return jPanel;
    }

    class SaveTableRenderer
    extends DefaultTableCellRenderer {
        boolean mSave;
        Border mEmptyBorder = BorderFactory.createEmptyBorder();
        Border mHighLightBorder = UIManager.getBorder("Table.focusCellHighlightBorder");

        SaveTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = null;
            component = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            SaveTableModel saveTableModel = (SaveTableModel)jTable.getModel();
            SaveTableItem saveTableItem = (SaveTableItem)saveTableModel.getValue(n);
            if (n2 == 1) {
                if (saveTableItem.isEnabled()) {
                    component.setForeground(Color.black);
                    if (component.hasFocus() && component instanceof JLabel) {
                        ((JLabel)component).setBorder(this.mHighLightBorder);
                    }
                } else {
                    component.setForeground(Color.gray);
                    if (component instanceof JLabel) {
                        ((JLabel)component).setBorder(this.mEmptyBorder);
                    }
                }
            } else if (n2 == 2) {
                Object object2 = jTable.getValueAt(n, 0);
                if (object2 instanceof Boolean) {
                    this.mSave = (Boolean)object2;
                }
                if (this.mSave && saveTableItem.isEnabled()) {
                    component.setForeground(Color.black);
                    if (component.hasFocus() && component instanceof JLabel) {
                        ((JLabel)component).setBorder(this.mHighLightBorder);
                    }
                } else {
                    component.setForeground(Color.gray);
                    if (component instanceof JLabel) {
                        ((JLabel)component).setBorder(this.mEmptyBorder);
                    }
                }
            } else if (n2 == 3) {
                Object object3 = jTable.getValueAt(n, 0);
                if (object3 instanceof Boolean) {
                    this.mSave = (Boolean)object3;
                }
                if (this.mSave && saveTableItem.isEnabled()) {
                    component.setForeground(Color.black);
                    if (component.hasFocus() && component instanceof JLabel) {
                        ((JLabel)component).setBorder(this.mHighLightBorder);
                    }
                } else {
                    component.setForeground(Color.gray);
                    if (component instanceof JLabel) {
                        ((JLabel)component).setBorder(this.mEmptyBorder);
                    }
                }
            } else {
                component.setForeground(Color.black);
            }
            if (bl) {
                if (component.hasFocus()) {
                    component.setBackground(jTable.getSelectionBackground());
                }
            } else {
                component.setBackground(jTable.getBackground());
            }
            return component;
        }
    }

    class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        Border mEmptyBorder = BorderFactory.createEmptyBorder();
        Border mHighLightBorder = UIManager.getBorder("Table.focusCellHighlightBorder");

        public CheckBoxRenderer() {
            this.setBorder(null);
            this.setLayout(new FlowLayout(1, 0, 0));
            this.setBorder(this.mHighLightBorder);
            this.setBorderPainted(true);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setHorizontalAlignment(0);
            if (bl2) {
                this.setBorder(this.mHighLightBorder);
            } else {
                this.setBorder(this.mEmptyBorder);
            }
            this.setSelected(object != null && (Boolean)object != false);
            boolean bl3 = jTable.isCellEditable(n, n2);
            this.setEnabled(bl3);
            return this;
        }
    }

    public static class SaveTableItem
    implements SerializableObject,
    Cloneable {
        boolean mSave = false;
        boolean mEnable = true;
        boolean mDisplay = true;
        String mItemToSave = "";
        String mDefVariableName = "";
        String mVariableName = "";
        String mNumCategories = "";
        boolean mCatsEnabled = false;

        public SaveTableItem() {
            this.mSave = false;
            this.mItemToSave = "";
            this.mVariableName = "";
            this.mDefVariableName = "";
            this.mNumCategories = "";
            this.mDisplay = false;
            this.mCatsEnabled = false;
        }

        public SaveTableItem(boolean bl, String string, String string2, String string3, boolean bl2, boolean bl3) {
            this.mSave = bl;
            this.mItemToSave = string;
            this.mVariableName = string2;
            this.mDefVariableName = string2;
            this.mNumCategories = string3;
            this.mDisplay = bl2;
            this.mCatsEnabled = bl3;
        }

        public boolean getSave() {
            return this.mSave;
        }

        public void setSave(boolean bl) {
            this.mSave = bl;
        }

        public boolean isEnabled() {
            return this.mEnable;
        }

        public void setEnabled(boolean bl) {
            this.mEnable = bl;
        }

        public String getItemToSave() {
            return this.mItemToSave;
        }

        public void setItemToSave(String string) {
            this.mItemToSave = string;
        }

        public String getVariableName() {
            return this.mVariableName;
        }

        public String getDefaultVariableName() {
            return this.mDefVariableName;
        }

        public void setVariableName(String string) {
            this.mVariableName = string;
        }

        public void setDefaultVariableName(String string) {
            this.mDefVariableName = string;
        }

        public String getNumCategories() {
            return this.mNumCategories;
        }

        public void setNumCategories(String string) {
            this.mNumCategories = string;
        }

        public boolean getDisplay() {
            return this.mDisplay;
        }

        public boolean getCatsEnabled() {
            return this.mCatsEnabled;
        }

        public void setCatsEnabled(boolean bl) {
            this.mCatsEnabled = bl;
        }

        protected SaveTableItem clone() throws CloneNotSupportedException {
            SaveTableItem saveTableItem = (SaveTableItem)super.clone();
            saveTableItem.setDefaultVariableName(this.mDefVariableName);
            return saveTableItem;
        }

        public String getClassName() {
            return "com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.SaveTab$SaveTableItem";
        }

        public boolean writeVersionedObject(ObjectOutputStream objectOutputStream, int n) throws Exception {
            objectOutputStream.writeBoolean(this.mSave);
            objectOutputStream.writeBoolean(this.mEnable);
            objectOutputStream.writeBoolean(this.mDisplay);
            objectOutputStream.writeBoolean(this.mCatsEnabled);
            objectOutputStream.writeUTF(this.mItemToSave);
            objectOutputStream.writeUTF(this.mDefVariableName);
            objectOutputStream.writeUTF(this.mVariableName);
            objectOutputStream.writeUTF(this.mNumCategories);
            return true;
        }

        public boolean readVersionedObject(ObjectInputStream objectInputStream, int n) throws Exception {
            this.mSave = objectInputStream.readBoolean();
            this.mEnable = objectInputStream.readBoolean();
            this.mDisplay = objectInputStream.readBoolean();
            this.mCatsEnabled = objectInputStream.readBoolean();
            this.mItemToSave = objectInputStream.readUTF();
            this.mDefVariableName = objectInputStream.readUTF();
            this.mVariableName = objectInputStream.readUTF();
            this.mNumCategories = objectInputStream.readUTF();
            return true;
        }
    }
}

