/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListFilterUtil;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.VarListDropListener;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.GEEVarListDropListener;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.GeneralizedLinearModelsDlg;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.ReferenceCategory;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.StatisticsTab;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.generalized_estm_eqn.GeneralizedEstimatingEquationsDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.complex_samples.CommonReferenceCategory;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ResponseTab
extends BaseProcedureTab
implements ItemListener,
ListDataListener,
DocumentListener,
IVarMoveHandler,
FocusListener,
ListSelectionListener {
    private static final String PARAMETER_DEFAULT_VALUES = "1";
    private static final String CATEGORY_ORDER_KEY = "IDS_GLM_CATEGORY_ORDER";
    private static final String BINARY_RESPONSE_KEY = "IDS_GLM_BINARY_RESPONSE";
    private static final String NUMBER_OF_EVENTS_KEY = "IDS_GLM_NUM_OF_EVENTS";
    private static final String VARIABLE_KEY = "IDS_GLM_VARIABLE";
    private static final String FIXED_VALUE_KEY = "IDS_GLM_FIXED_VALUE";
    public static final String TARGET_DEPENDENT_LIST_KEY = "IDS_GLM_DEPENDENT_TARGET_VAR_LIST_KEY";
    private static final String TARGET_TRIAL_LIST_KEY = "IDS_GLM_TRIAL_TARGET_VAR_LIST_KEY";
    private static final String TARGET_SCALE_WEIGHT_LIST_KEY = "IDS_SCALE_WEIGHT_TARGET_VAR_LIST_KEY";
    static final String DISTRIBUTION_COMBO_KEY = "IDS_GLM_DISTRIBUTION_COMBO_KEY";
    static final String CATEGORY_COMBO_KEY = "IDS_GLM_CATEGORY_COMBO_KEY";
    private static final String SOURCE_LIST_KEY = "IDS_GLM_SOURCE_LIST_KEY";
    private static final String NUMBER_OF_TRIALS_KEY = "IDS_GLM_NO_OF_TRIALS_KEY";
    private static final String PARAMETER_FOR_NEG_KEY = "IDS_GLM_PARAMETER_FOR_NEG_KEY";
    private static final String POWER_KEY = "IDS_POWER_KEY";
    private static final String LINK_FUNCTION_KEY = "IDS_LINK_FUNCTION_KEY";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mDependentTargetVarList;
    private TargetVariableList mScaleWeightTargetVarList;
    private TargetVariableList mTrialsTargetVarList;
    private JRadioButton mBinaryResponseRadio;
    private JRadioButton mNumberOfEventsRadio;
    private JRadioButton mVariableRadio;
    private JRadioButton mFixedValueRadio;
    private JPanel mVarRepresentPanel;
    private JPanel mTrialsPanel;
    private JLabel mTrialsVarLabel;
    private JLabel mNumberOfTrialsLabel;
    private IntTextField mNumberOfTrialsField;
    JLabel mCategoryLabel;
    private JComboBox mCategoryOrderCombo;
    private ArrowButton mDependentVarArrow;
    private ArrowButton mTrialsArrow;
    private ArrowButton mScaleWeightArrow;
    private JButton mRefCategoryButton;
    ReferenceCategory mRefCategoryDialog;
    private SpssButtonGroup mTrialsGroup;
    private SpssButtonGroup mVarRepresentGroup;
    private Vector<Object> mComponent;
    private StringBuffer mSyntax;
    private boolean mIsGEE;

    public ResponseTab(BaseTabbedDialog baseTabbedDialog, boolean bl) {
        super(baseTabbedDialog, true);
        this.mIsGEE = bl;
        this.initializePanel();
    }

    public static JPanel setUpListPanel(JComponent[] jComponentArray) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(jComponentArray[2]);
        jScrollPane.setPreferredSize(jComponentArray[2].getMinimumSize());
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jComponentArray[0], gridBagConstraints, 1, 0, 1, 1, 23, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n - 3, 0, 0, DialogUtil.getArrowButtonInsets().right);
        DialogUtil.addUsingGBL(jPanel, jComponentArray[1], gridBagConstraints, 0, 0, 1, 2, 23, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.set(0, 0, 0, n * 10);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 1, 1, 1, 1, 23, insets);
        return jPanel;
    }

    @Override
    public void reset() {
        this.mDependentTargetVarList.removeAll();
        this.mScaleWeightTargetVarList.removeAll();
        this.mTrialsTargetVarList.removeAll();
        this.setDefaults();
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mSrcVarList;
    }

    @Override
    public String getDialogHelpID() {
        if (this.mIsGEE) {
            return "idh_idd_gee_response";
        }
        return "idh_idd_genlin_response";
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = listSelectionEvent.getFirstIndex();
        SpssVariable spssVariable = null;
        if (n > 0 && this.mSrcVarList.getModel().getSize() > n) {
            spssVariable = (SpssVariable)this.mSrcVarList.getModel().getElementAt(n);
        }
        if (spssVariable != null) {
            boolean bl = false;
            if (spssVariable.getType() == 0) {
                bl = true;
            }
            if (spssVariable.getType() > 0) {
                if (!this.mIsGEE && ((GeneralizedLinearModelsDlg)this.mParent).mTypeOfModelTab != null) {
                    boolean bl2 = bl = ((GeneralizedLinearModelsDlg)this.mParent).mTypeOfModelTab.isMultinomialSelected() || ((GeneralizedLinearModelsDlg)this.mParent).mTypeOfModelTab.isBinomialSelected();
                }
                if (this.mIsGEE && ((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab != null) {
                    bl = ((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab.isMultinomialSelected() || ((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab.isBinomialSelected();
                }
            }
            this.mDependentVarArrow.setEnabled(bl);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.setEnabledComponent();
        this.updateOkPaste();
        if (!this.mIsGEE) {
            if (((GeneralizedLinearModelsDlg)this.mParent).estTab != null) {
                // empty if block
            }
            if (((GeneralizedLinearModelsDlg)this.mParent).saveTab != null) {
                // empty if block
            }
        } else {
            if (((GeneralizedEstimatingEquationsDlg)this.mParent).getEstimationTab() != null) {
                // empty if block
            }
            if (((GeneralizedEstimatingEquationsDlg)this.mParent).getSaveTab() != null) {
                // empty if block
            }
        }
        if (this.mIsGEE) {
            ((GeneralizedEstimatingEquationsDlg)this.mParent).getRepeatedTab().enableComponent();
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource().equals(this.mDependentTargetVarList.getModel())) {
            if (this.mDependentTargetVarList.getModel().getSize() > 0) {
                SpssVariable spssVariable = (SpssVariable)this.mDependentTargetVarList.getModel().getElementAt(0);
            }
            if (this.mIsGEE && (listDataEvent.getSource().equals(this.mDependentTargetVarList.getModel()) || listDataEvent.getSource().equals(this.mTrialsTargetVarList))) {
                if (this.mDependentTargetVarList.getModel().getSize() == 1) {
                    ((GeneralizedEstimatingEquationsDlg)this.mParent).getRepeatedTab().getSrcVariableList().getModel().removeElement(this.mDependentTargetVarList.getModel().getElementAt(0));
                }
                if (this.mTrialsTargetVarList.getModel().getSize() == 1) {
                    ((GeneralizedEstimatingEquationsDlg)this.mParent).getRepeatedTab().getSrcVariableList().getModel().removeElement(this.mTrialsTargetVarList.getModel().getElementAt(0));
                }
            }
        }
        this.setEnabledComponent();
        this.updateOkPaste();
        if (this.mIsGEE) {
            ((GeneralizedEstimatingEquationsDlg)this.mParent).getRepeatedTab().enableComponent();
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.setEnabledComponent();
        this.updateOkPaste();
        if (this.mRefCategoryDialog != null && this.mRefCategoryDialog.mRefPanel.getValueComboBox() != null) {
            this.mRefCategoryDialog.mRefPanel.getValueComboBox().removeAllItems();
        }
        this.validateReferenceDataModel();
        if (this.mIsGEE) {
            ((GeneralizedEstimatingEquationsDlg)this.mParent).getRepeatedTab().enableComponent();
        }
    }

    public void enableCategoryCombo(boolean bl) {
        this.mCategoryOrderCombo.setEnabled(bl);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateOkPaste();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateOkPaste();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateOkPaste();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mNumberOfTrialsField)) {
            this.mNumberOfTrialsField.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
        String string;
        SpssVariable spssVariable;
        int n;
        VarListModel varListModel = null;
        if (this.mIsGEE) {
            varListModel = ((GeneralizedEstimatingEquationsDlg)this.mParent).getRepeatedTab().getSubjectVarList().getModel();
            for (n = 0; n < varListModel.getSize(); ++n) {
                spssVariable = (SpssVariable)varListModel.getElementAt(n);
                if (!spssVariable.getName().equals(((SpssVariable)iSpssVariableArray[0]).getName()) || variableList.equals(this.mScaleWeightTargetVarList)) continue;
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_SUBJECT_WARNING_MSG"), VersionInfo.getAppVersionString());
                return false;
            }
            varListModel = ((GeneralizedEstimatingEquationsDlg)this.mParent).getRepeatedTab().getWithInSubjectVarList().getModel();
            for (n = 0; n < varListModel.getSize(); ++n) {
                spssVariable = (SpssVariable)varListModel.getElementAt(n);
                if (!spssVariable.getName().equals(((SpssVariable)iSpssVariableArray[0]).getName()) || variableList.equals(this.mScaleWeightTargetVarList)) continue;
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_SUBJECT_WARNING_MSG"), VersionInfo.getAppVersionString());
                return false;
            }
        }
        if (variableList.equals(this.mDependentTargetVarList)) {
            boolean bl;
            n = 1;
            if (!this.mIsGEE && ((GeneralizedLinearModelsDlg)this.mParent).mTypeOfModelTab != null) {
                spssVariable = (SpssVariable)iSpssVariableArray[0];
                boolean bl2 = bl = spssVariable.getType() > 0;
                if (!(!bl || ((GeneralizedLinearModelsDlg)this.mParent).mTypeOfModelTab.isMultinomialSelected() || ((GeneralizedLinearModelsDlg)this.mParent).mTypeOfModelTab.isBinomialSelected() || ((GeneralizedLinearModelsDlg)this.mParent).mTypeOfModelTab.isOrdinalLogisticSelected() || ((GeneralizedLinearModelsDlg)this.mParent).mTypeOfModelTab.isOrdinalProbitSelected() || ((GeneralizedLinearModelsDlg)this.mParent).mTypeOfModelTab.isBinaryLogisticSelected() || ((GeneralizedLinearModelsDlg)this.mParent).mTypeOfModelTab.isBinaryProbitSelected() || ((GeneralizedLinearModelsDlg)this.mParent).mTypeOfModelTab.isIntervalCensoredSurvivalSelected())) {
                    n = 0;
                }
                if (n == 0) {
                    String string2 = this.getResString("ERR_GLM_RESPONSE_STRING_DEP_VARS_MSG");
                    SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, string2, VersionInfo.getAppVersionString());
                    return false;
                }
                if (bl && this.mNumberOfEventsRadio.isEnabled() && this.mNumberOfEventsRadio.isSelected()) {
                    String string3 = this.getResString("ERR_GLM_RESPONSE_EVENTS_TRIALS_MSG");
                    SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, string3, VersionInfo.getAppVersionString());
                    return false;
                }
            }
            if (this.mIsGEE && ((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab != null) {
                spssVariable = (SpssVariable)iSpssVariableArray[0];
                boolean bl3 = bl = spssVariable.getType() > 0;
                if (!(!bl || ((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab.isMultinomialSelected() || ((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab.isBinomialSelected() || ((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab.isOrdinalLogisticSelected() || ((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab.isOrdinalProbitSelected() || ((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab.isBinaryLogisticSelected() || ((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab.isBinaryProbitSelected() || ((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab.isIntervalCensoredSurvivalSelected())) {
                    n = 0;
                }
                if (n == 0) {
                    String string4 = this.getResString("ERR_GLM_RESPONSE_STRING_DEP_VARS_MSG");
                    SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, string4, VersionInfo.getAppVersionString());
                    return false;
                }
                if (bl && this.mNumberOfEventsRadio.isEnabled() && this.mNumberOfEventsRadio.isSelected()) {
                    String string5 = this.getResString("ERR_GLM_RESPONSE_EVENTS_TRIALS_MSG");
                    SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, string5, VersionInfo.getAppVersionString());
                    return false;
                }
            }
        }
        if (variableList.equals(this.mScaleWeightTargetVarList) && (string = VarListFilterUtil.getVarListFilterErrorMessage(variableList, iSpssVariableArray)) != null) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)this.mParent, string, VersionInfo.getAppVersionString());
            return false;
        }
        if (this.mIsGEE && this.mTrialsTargetVarList.getModel().getSize() > 0 && variableList.equals(this.mSrcVarList)) {
            ((GeneralizedEstimatingEquationsDlg)this.mParent).getRepeatedTab().getSrcVariableList().getModel().addElement(this.mTrialsTargetVarList.getModel().getElementAt(0));
        }
        if (this.mIsGEE && this.mDependentTargetVarList.getModel().getSize() > 0 && (variableList.equals(this.mSrcVarList) || variableList.equals(this.mScaleWeightTargetVarList) && iSpssVariableArray.length == 1 && this.mDependentTargetVarList.getModel().getElementAt(0).equals(iSpssVariableArray[0]))) {
            ((GeneralizedEstimatingEquationsDlg)this.mParent).getRepeatedTab().getSrcVariableList().getModel().addElement(this.mDependentTargetVarList.getModel().getElementAt(0));
        }
        return true;
    }

    private static Map getCatOrderMap() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(0, "ASCENDING");
        hashMap.put(1, "DESCENDING");
        hashMap.put(2, "DATA");
        return hashMap;
    }

    public String getGeneratedSyntaxForDependentVar() {
        Object object;
        DialogDataModel dialogDataModel = ((BaseProcedureDialog)this.mParent).getDialogDataModel();
        this.mSyntax.delete(0, this.mSyntax.length());
        this.mSyntax.append(this.mDependentTargetVarList.getVariablesStringList());
        if (this.mBinaryResponseRadio.isSelected() && this.mBinaryResponseRadio.isEnabled()) {
            this.mSyntax.append(" (REFERENCE=");
            if (this.mRefCategoryDialog != null) {
                if (this.mRefCategoryDialog.mRefPanel.isHighestValueSelected()) {
                    this.mSyntax.append("LAST)");
                } else if (this.mRefCategoryDialog.mRefPanel.isCustomRadioSelected()) {
                    if (this.mDependentTargetVarList.getModel().getElementAt(0).getType() > 0) {
                        this.mSyntax.append(CharacterUtil.smartQuote((String)dialogDataModel.getString("IDS_GLM_REF_CAT_COMBO_VALUE")) + ")");
                    } else {
                        this.mSyntax.append(dialogDataModel.getString("IDS_GLM_REF_CAT_COMBO_VALUE") + ")");
                    }
                } else {
                    this.mSyntax.append("FIRST)");
                }
            } else {
                object = dialogDataModel.getBoolean("IDS_GLM_LAST_VALUE");
                if (object == null || object != null && ((Boolean)object).booleanValue()) {
                    this.mSyntax.append("LAST)");
                } else if (dialogDataModel.getBoolean("IDS_GLM_FIRST_VALUE").booleanValue()) {
                    this.mSyntax.append("FIRST)");
                } else if (this.mDependentTargetVarList.getModel().getElementAt(0).getType() > 0) {
                    this.mSyntax.append(CharacterUtil.smartQuote((String)dialogDataModel.getString("IDS_GLM_REF_CAT_COMBO_VALUE")) + ")");
                } else {
                    this.mSyntax.append(dialogDataModel.getString("IDS_GLM_REF_CAT_COMBO_VALUE") + ")");
                }
            }
        }
        if (this.mNumberOfEventsRadio.isSelected() && this.mNumberOfEventsRadio.isEnabled()) {
            if (this.mVariableRadio.isSelected() && this.mVariableRadio.isEnabled()) {
                this.mSyntax.append(" OF " + this.mTrialsTargetVarList.getVariablesStringList());
            }
            if (this.mFixedValueRadio.isSelected() && this.mFixedValueRadio.isEnabled()) {
                this.mSyntax.append(" OF " + this.mNumberOfTrialsField.getText());
            }
        }
        if (this.mCategoryOrderCombo.isEnabled()) {
            object = ResponseTab.getCatOrderMap();
            String string = object.get(this.mCategoryOrderCombo.getSelectedIndex()).toString();
            this.mSyntax.append(" (ORDER=" + string + ")");
        }
        return this.mSyntax.toString();
    }

    public boolean isVariableRadioSelected() {
        return this.mVariableRadio.isSelected() && this.mVariableRadio.isEnabled();
    }

    public void updateOkPaste() {
        if (!this.mIsGEE) {
            ((GeneralizedLinearModelsDlg)this.mParent).updateOKPaste();
        } else {
            ((GeneralizedEstimatingEquationsDlg)this.mParent).updateOKPaste();
        }
    }

    public void enableComponent() {
        this.setEnabledComponent();
    }

    public boolean enableOKPaste() {
        boolean bl = false;
        boolean bl2 = this.mDependentTargetVarList.getModel().getSize() > 0;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = true;
        boolean bl6 = true;
        boolean bl7 = true;
        if (this.mVariableRadio.isEnabled() && this.mVariableRadio.isSelected()) {
            boolean bl8 = bl3 = this.mTrialsTargetVarList.getModel().getSize() > 0;
        }
        if (this.mFixedValueRadio.isEnabled() && this.mFixedValueRadio.isSelected()) {
            boolean bl9 = bl4 = this.mNumberOfTrialsField.getText().length() > 0;
        }
        if (this.mIsGEE) {
            bl7 = ((GeneralizedEstimatingEquationsDlg)this.mParent).getRepeatedTab().getSubjectVarList().getModel().getSize() > 0;
            bl = bl2 && bl3 && bl4 && bl5 && bl6 && bl7;
        } else {
            bl = bl2 && bl3 && bl4 && bl5 && bl6;
        }
        return bl;
    }

    public String getGeneratedSyntaxForDistribution() {
        this.mSyntax.delete(0, this.mSyntax.length());
        if (this.mScaleWeightTargetVarList.getModel().getSize() > 0) {
            this.mSyntax.append(" SCALEWEIGHT=" + this.mScaleWeightTargetVarList.getVariablesStringList());
        }
        return this.mSyntax.toString();
    }

    public TargetVariableList getDependentVariableList() {
        return this.mDependentTargetVarList;
    }

    public TargetVariableList getTrialVariableList() {
        return this.mTrialsTargetVarList;
    }

    public TargetVariableList getScaleWeightVariableList() {
        return this.mScaleWeightTargetVarList;
    }

    public int getDistributionSelectedIndex() {
        return 0;
    }

    SrcVariableList getSrcVariableList() {
        return this.mSrcVarList;
    }

    protected void initializePanel() {
        this.initVars();
        this.setDefaults();
        this.setFocusTraversalPolicy();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = DialogUtil.getArrowButtonInsets().left;
        int n3 = 23;
        Insets insets = new Insets(UIToolDialogUtil.getStandardDialogInsets().top, UIToolDialogUtil.getStandardDialogInsets().left, 0, 0);
        gridBagConstraints.weightx = 1.0;
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_GLM_VARIABLE_DOT");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(this, jLabel, gridBagConstraints, 0, 0, 1, 1, n3, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        insets.set(0, UIToolDialogUtil.getStandardDialogInsets().left, 0, 0);
        DialogUtil.addUsingGBL(this, jScrollPane, gridBagConstraints, 0, 1, 1, 7, n3, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel2 = DialogUtil.createLabel(this.mParent, "IDS_GLM_DEPENDENT_VARIABLE_DOT");
        jLabel2.setLabelFor(this.mDependentTargetVarList);
        JComponent[] jComponentArray = new JComponent[]{jLabel2, this.mDependentVarArrow, this.mDependentTargetVarList};
        insets.set(UIToolDialogUtil.getStandardDialogInsets().top, n2, 0, UIToolDialogUtil.getStandardDialogInsets().right);
        DialogUtil.addUsingGBL(this, StatisticsTab.setUpLinePanel(this.getResString("IDS_GLM_DEPENDENT_VARIABLE")), gridBagConstraints, 1, 0, 1, 1, n3, insets);
        insets.set(0, n2, 0, UIToolDialogUtil.getStandardDialogInsets().right);
        DialogUtil.addUsingGBL(this, ResponseTab.setUpListPanel(jComponentArray), gridBagConstraints, 1, 1, 1, 1, n3, insets);
        insets.set(n, n2, 0, UIToolDialogUtil.getStandardDialogInsets().right);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.mCategoryLabel = DialogUtil.createLabel(this.mParent, "IDS_GLM_CATEGORY_ORDER_DOT");
        this.mCategoryLabel.setLabelFor(this.mCategoryOrderCombo);
        DialogUtil.addUsingGBL(jPanel, this.mCategoryLabel, gridBagConstraints, 0, 0, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCategoryOrderCombo, gridBagConstraints, 1, 0, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 1, 2, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(this, this.setUpVariableRepresentsPanel(), gridBagConstraints, 1, 3, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(this, StatisticsTab.setUpLinePanel(this.getResString("IDS_GLM_SCALE_WEIGHT")), gridBagConstraints, 1, 4, 1, 1, n3, insets);
        JLabel jLabel3 = DialogUtil.createLabel(this.mParent, "IDS_GLM_SCALE_WEIGHT_VAR");
        jLabel3.setLabelFor(this.mScaleWeightTargetVarList);
        JComponent[] jComponentArray2 = new JComponent[]{jLabel3, this.mScaleWeightArrow, this.mScaleWeightTargetVarList};
        gridBagConstraints.weighty = 1.0;
        insets.set(n, n2, 0, UIToolDialogUtil.getStandardDialogInsets().right);
        DialogUtil.addUsingGBL(this, ResponseTab.setUpListPanel(jComponentArray2), gridBagConstraints, 1, 5, 1, 1, n3, insets);
    }

    @Override
    protected void aboutToShowTab() {
        SpssVariable spssVariable;
        super.aboutToShowTab();
        this.mTrialsArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mScaleWeightArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mDependentVarArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        Component component = this.mIsGEE ? ((GeneralizedEstimatingEquationsDlg)((Object)this.getTopLevelAncestor())).getGlassPane() : ((GeneralizedLinearModelsDlg)((Object)this.getTopLevelAncestor())).getGlassPane();
        if (component instanceof DragPane) {
            DragPane dragPane = (DragPane)component;
            dragPane.getDropListeners().removeAllElements();
            if (this.mIsGEE) {
                dragPane.addDropListener((IDropListener)new GEEVarListDropListener(this.mSrcVarList, null, (GeneralizedEstimatingEquationsDlg)this.mParent));
                dragPane.addDropListener((IDropListener)new GEEVarListDropListener(this.mDependentTargetVarList, this, (GeneralizedEstimatingEquationsDlg)this.mParent));
                dragPane.addDropListener((IDropListener)new GEEVarListDropListener(this.mScaleWeightTargetVarList, this, (GeneralizedEstimatingEquationsDlg)this.mParent));
                dragPane.addDropListener((IDropListener)new GEEVarListDropListener(this.mTrialsTargetVarList, this, (GeneralizedEstimatingEquationsDlg)this.mParent));
            } else {
                dragPane.addDropListener((IDropListener)new VarListDropListener(this.mSrcVarList));
                dragPane.addDropListener((IDropListener)new VarListDropListener(this.mDependentTargetVarList, this));
                dragPane.addDropListener((IDropListener)new VarListDropListener(this.mScaleWeightTargetVarList, this));
                dragPane.addDropListener((IDropListener)new VarListDropListener(this.mTrialsTargetVarList, this));
            }
        }
        boolean bl = false;
        if (this.mDependentTargetVarList.getModel().getSize() > 0 && (spssVariable = (SpssVariable)this.mDependentTargetVarList.getModel().getElementAt(0)).getType() > 0) {
            bl = true;
        }
        this.setEnabledComponent();
    }

    @Override
    public boolean validateTab() {
        if (this.mVariableRadio.isEnabled() && this.mVariableRadio.isSelected() && this.mTrialsTargetVarList.getModel().getSize() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_TRAILS_VAR_WARNING_MSG"), VersionInfo.getAppVersionString());
            this.mTrialsTargetVarList.grabFocus();
            return false;
        }
        if (this.mNumberOfTrialsField.isEnabled()) {
            if (this.mNumberOfTrialsField.getText().equals("")) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_NUMBER_OF_TRIALS_MSG"), VersionInfo.getAppVersionString());
                GeneralizedLinearModelsDlg.setSelectionText((JComponent)this.mNumberOfTrialsField);
                return false;
            }
            try {
                long l = Long.parseLong(this.mNumberOfTrialsField.getText());
                if (l == 0L) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_NUMBER_OF_TRIALS_NOT_ZERO_MSG"), VersionInfo.getAppVersionString());
                    GeneralizedLinearModelsDlg.setSelectionText((JComponent)this.mNumberOfTrialsField);
                    return false;
                }
                if (l <= 0L || l > Integer.MAX_VALUE) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return true;
    }

    private static Map getDistributionMap() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(0, "BINOMIAL");
        hashMap.put(1, "GAMMA");
        hashMap.put(2, "IGAUSS");
        hashMap.put(3, "NEGBIN");
        hashMap.put(4, "NORMAL");
        hashMap.put(5, "POISSON");
        return hashMap;
    }

    private static Map getLinkFunctionMapForBionomial() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(0, "IDENTITY");
        hashMap.put(1, "CLOGLOG");
        hashMap.put(2, "LOG");
        hashMap.put(3, "LOGC");
        hashMap.put(4, "LOGIT");
        hashMap.put(5, "NLOGLOG");
        hashMap.put(6, "ODDSPOWER");
        hashMap.put(7, "PROBIT");
        hashMap.put(8, "POWER");
        return hashMap;
    }

    private static Map getLinkFunctionMapForNegBionomial() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(0, "IDENTITY");
        hashMap.put(1, "LOG");
        hashMap.put(2, "NEGBIN");
        hashMap.put(3, "POWER");
        return hashMap;
    }

    private static Map getLinkFunctionMap() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(0, "IDENTITY");
        hashMap.put(1, "LOG");
        hashMap.put(2, "POWER");
        return hashMap;
    }

    private boolean enableTypeOfDepGroupBox() {
        boolean bl = false;
        if (!this.mIsGEE && ((GeneralizedLinearModelsDlg)this.mParent).mTypeOfModelTab != null) {
            boolean bl2 = ((GeneralizedLinearModelsDlg)this.mParent).mTypeOfModelTab.isBinaryLogisticSelected();
            boolean bl3 = ((GeneralizedLinearModelsDlg)this.mParent).mTypeOfModelTab.isBinaryProbitSelected();
            boolean bl4 = ((GeneralizedLinearModelsDlg)this.mParent).mTypeOfModelTab.isIntervalCensoredSurvivalSelected();
            boolean bl5 = ((GeneralizedLinearModelsDlg)this.mParent).mTypeOfModelTab.isBinomialSelected();
            bl = bl2 || bl3 || bl4 || bl5;
        } else if (this.mIsGEE && ((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab != null) {
            boolean bl6 = ((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab.isBinaryLogisticSelected();
            boolean bl7 = ((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab.isBinaryProbitSelected();
            boolean bl8 = ((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab.isIntervalCensoredSurvivalSelected();
            boolean bl9 = ((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab.isBinomialSelected();
            bl = bl6 || bl7 || bl8 || bl9;
        }
        return bl;
    }

    private void setEnabledComponent() {
        SpssVariable spssVariable;
        boolean bl = false;
        if (this.mDependentTargetVarList.getModel().getSize() > 0 && (spssVariable = (SpssVariable)this.mDependentTargetVarList.getModel().getElementAt(0)).getType() > 0) {
            bl = true;
        }
        boolean bl2 = false;
        boolean bl3 = this.enableTypeOfDepGroupBox();
        boolean bl4 = this.mDependentTargetVarList.getModel().getSize() == 1;
        boolean bl5 = this.enableTypeOfDepGroupBox();
        this.mBinaryResponseRadio.setEnabled(bl5);
        this.mNumberOfEventsRadio.setEnabled(bl5 && !bl);
        this.mRefCategoryButton.setEnabled(this.mBinaryResponseRadio.isSelected() && bl5 && bl4);
        this.mVariableRadio.setEnabled(this.mNumberOfEventsRadio.isSelected() && bl5 && this.mNumberOfEventsRadio.isEnabled() && !bl);
        this.mFixedValueRadio.setEnabled(this.mNumberOfEventsRadio.isSelected() && this.mNumberOfEventsRadio.isEnabled() && !bl);
        this.mTrialsArrow.setEnabled(this.mVariableRadio.isSelected() && this.mNumberOfEventsRadio.isSelected() && this.mNumberOfEventsRadio.isEnabled() && !bl);
        this.mTrialsTargetVarList.setEnabled(this.mVariableRadio.isSelected() && this.mNumberOfEventsRadio.isSelected() && this.mNumberOfEventsRadio.isEnabled() && !bl);
        this.mTrialsTargetVarList.setOpaque(this.mVariableRadio.isSelected() && this.mNumberOfEventsRadio.isSelected() && this.mNumberOfEventsRadio.isEnabled() && !bl);
        this.mTrialsVarLabel.setEnabled(this.mVariableRadio.isSelected() && this.mNumberOfEventsRadio.isSelected() && this.mNumberOfEventsRadio.isEnabled() && !bl);
        this.mNumberOfTrialsField.setEnabled(this.mFixedValueRadio.isSelected() && this.mNumberOfEventsRadio.isSelected() && this.mNumberOfEventsRadio.isEnabled() && !bl);
        this.mNumberOfTrialsLabel.setEnabled(this.mFixedValueRadio.isSelected() && this.mNumberOfEventsRadio.isSelected() && this.mNumberOfEventsRadio.isEnabled() && !bl);
        this.mNumberOfTrialsField.setOpaque(this.mFixedValueRadio.isSelected() && this.mNumberOfEventsRadio.isSelected() && this.mNumberOfEventsRadio.isEnabled() && !bl);
        DialogUtil.enableTitledBorder(this.mTrialsPanel, this.mNumberOfEventsRadio.isSelected() && !bl);
        DialogUtil.enableTitledBorder(this.mVarRepresentPanel, bl3);
        bl2 = false;
        if (!this.mIsGEE && ((GeneralizedLinearModelsDlg)this.mParent).mTypeOfModelTab != null) {
            boolean bl6 = bl2 = ((GeneralizedLinearModelsDlg)this.mParent).mTypeOfModelTab.isOrdinalProbitSelected() || ((GeneralizedLinearModelsDlg)this.mParent).mTypeOfModelTab.isOrdinalLogisticSelected() || ((GeneralizedLinearModelsDlg)this.mParent).mTypeOfModelTab.isMultinomialSelected();
            if (this.mCategoryLabel != null) {
                this.mCategoryLabel.setEnabled(bl2);
            }
            if (this.mCategoryOrderCombo != null) {
                this.mCategoryOrderCombo.setEnabled(bl2);
            }
        } else if (this.mIsGEE && ((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab != null) {
            boolean bl7 = bl2 = ((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab.isOrdinalProbitSelected() || ((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab.isOrdinalLogisticSelected() || ((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab.isMultinomialSelected();
            if (this.mCategoryLabel != null) {
                this.mCategoryLabel.setEnabled(bl2);
            }
            if (this.mCategoryOrderCombo != null) {
                this.mCategoryOrderCombo.setEnabled(bl2);
            }
        }
        this.repaint();
    }

    private void setFocusTraversalPolicy() {
        this.mComponent.clear();
        this.mComponent.add(this.mSrcVarList);
        this.mComponent.add(this.mDependentVarArrow);
        this.mComponent.add(this.mDependentTargetVarList);
        this.mComponent.add(this.mCategoryOrderCombo);
        this.mComponent.add(this.mVarRepresentGroup);
        this.mComponent.add(this.mRefCategoryButton);
        this.mComponent.add(this.mTrialsGroup);
        this.mComponent.add(this.mTrialsArrow);
        this.mComponent.add(this.mTrialsTargetVarList);
        this.mComponent.add(this.mNumberOfTrialsField);
        this.mComponent.add(this.mScaleWeightArrow);
        this.mComponent.add(this.mScaleWeightTargetVarList);
        JPanel jPanel = null;
        jPanel = !this.mIsGEE ? ((GeneralizedLinearModelsDlg)this.mParent).getCmdButtonPanel() : ((GeneralizedEstimatingEquationsDlg)this.mParent).getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            this.mComponent.add(component);
        }
        this.setComponentOrder(this.mComponent);
    }

    private void runReferenceCategorysSubDialog() {
        this.mRefCategoryDialog = this.mIsGEE ? new ReferenceCategory((BaseProcedureDialog)this.mParent, this.getResString("IDS_GEE_REFERENCE_CATEGORY_TITLE"), true, this.mIsGEE) : new ReferenceCategory((BaseProcedureDialog)this.mParent, this.getResString("IDS_GLM_REFERENCE_CATEGORY_TITLE"), true, this.mIsGEE);
        this.mRefCategoryDialog.mRefPanel.setLabelForHighestValueRadio("IDS_GLM_LAST_VALUE");
        this.mRefCategoryDialog.mRefPanel.setLabelForLowestValueRadio("IDS_GLM_FIRST_VALUE");
        this.mRefCategoryDialog.setVisible(true);
    }

    private JPanel setUpVariableRepresentsPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(this.mVarRepresentPanel, this.mBinaryResponseRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        Insets insets2 = new Insets(insets.top, n2 + 25, 0, 0);
        DialogUtil.addUsingGBL(this.mVarRepresentPanel, this.mRefCategoryButton, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(this.mVarRepresentPanel, this.mNumberOfEventsRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mTrialsTargetVarList);
        jScrollPane.setPreferredSize(this.mTrialsTargetVarList.getMinimumSize());
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        DialogUtil.addUsingGBL(this.mTrialsPanel, this.mVariableRadio, gridBagConstraints, 0, 0, 2, 1, n, insets);
        insets2.set(0, n2, 0, 0);
        DialogUtil.addUsingGBL(this.mTrialsPanel, this.mTrialsVarLabel, gridBagConstraints, 1, 1, 1, 1, n, null);
        insets2.set(n2 - 3, DialogUtil.getArrowButtonInsets().left, 0, DialogUtil.getArrowButtonInsets().right);
        DialogUtil.addUsingGBL(this.mTrialsPanel, this.mTrialsArrow, gridBagConstraints, 0, 1, 1, 2, n, insets2);
        insets2.set(0, 0, 0, n2 + 30);
        n = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(this.mTrialsPanel, jScrollPane, gridBagConstraints, 1, 2, 2, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        insets2.set(0, n2, 0, 0);
        DialogUtil.addUsingGBL(this.mTrialsPanel, this.mFixedValueRadio, gridBagConstraints, 0, 3, 2, 1, n, insets);
        insets2.set(0, 0, DialogUtil.getGroupBoxInnerMargin(), 0);
        DialogUtil.addUsingGBL(this.mTrialsPanel, this.mNumberOfTrialsLabel, gridBagConstraints, 1, 4, 1, 1, n, insets2);
        insets2.set(0, n2, DialogUtil.getGroupBoxInnerMargin(), 0);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mTrialsPanel, (JComponent)this.mNumberOfTrialsField, gridBagConstraints, 2, 4, 1, 1, n, insets2);
        insets2.set(insets.top, n2 + 25, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mVarRepresentPanel, this.mTrialsPanel, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        return this.mVarRepresentPanel;
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ResponseTab.this.mSrcVarList.setSelectedIndex(0);
            }
        });
        this.mSrcVarList.setSelectedIndex(0);
        DialogUtil.enableTitledBorder(this.mTrialsPanel, false);
        DialogUtil.enableTitledBorder(this.mVarRepresentPanel, false);
        this.repaint();
        this.mBinaryResponseRadio.setEnabled(false);
        this.mRefCategoryButton.setEnabled(false);
        this.mNumberOfEventsRadio.setEnabled(false);
        this.mVariableRadio.setEnabled(false);
        this.mTrialsVarLabel.setEnabled(false);
        this.mTrialsArrow.setEnabled(false);
        this.mTrialsTargetVarList.setEnabled(false);
        this.mFixedValueRadio.setEnabled(false);
        this.mNumberOfTrialsLabel.setEnabled(false);
        this.mNumberOfTrialsField.setEnabled(false);
        this.mBinaryResponseRadio.setSelected(true);
        this.mVariableRadio.setSelected(true);
        this.mCategoryOrderCombo.removeItemListener(this);
        if (this.mCategoryOrderCombo.getItemCount() > 0) {
            this.mCategoryOrderCombo.removeAllItems();
        }
        String[] stringArray = this.getResStringArray("IDS_GLM_CATEGORY_ORDER_VALUES");
        for (int i = 0; i < stringArray.length; ++i) {
            this.mCategoryOrderCombo.addItem(stringArray[i]);
        }
        this.mCategoryOrderCombo.addItemListener(this);
        this.mCategoryOrderCombo.setSelectedIndex(0);
        this.mNumberOfTrialsField.setText("");
        if (!this.mIsGEE) {
            ((GeneralizedLinearModelsDlg)this.mParent).enableOkPaste(false);
        } else {
            ((GeneralizedEstimatingEquationsDlg)this.mParent).enableOkPaste(false);
        }
        this.mDependentVarArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mTrialsArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mScaleWeightArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mCategoryOrderCombo.setEnabled(false);
    }

    private void initVars() {
        this.mCategoryOrderCombo = new JComboBox<String>(this.getResStringArray("IDS_GLM_CATEGORY_ORDER_VALUES"));
        this.mCategoryOrderCombo.setAction(new ComboboxAction(this.mParent, CATEGORY_COMBO_KEY));
        this.mBinaryResponseRadio = DialogUtil.createRadioButton(this.mParent, BINARY_RESPONSE_KEY, null);
        this.mNumberOfEventsRadio = DialogUtil.createRadioButton(this.mParent, NUMBER_OF_EVENTS_KEY, null);
        this.mVariableRadio = DialogUtil.createRadioButton(this.mParent, VARIABLE_KEY, null);
        this.mFixedValueRadio = DialogUtil.createRadioButton(this.mParent, FIXED_VALUE_KEY, null);
        this.mTrialsGroup = new SpssButtonGroup();
        this.mTrialsGroup.add(this.mVariableRadio);
        this.mTrialsGroup.add(this.mFixedValueRadio);
        this.mVarRepresentGroup = new SpssButtonGroup();
        this.mVarRepresentGroup.add(this.mBinaryResponseRadio);
        this.mVarRepresentGroup.add(this.mNumberOfEventsRadio);
        this.mVarRepresentPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_GLM_TYPE_OF_DEPENDENT_VAR"));
        this.mTrialsPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_GLM_TRIAL"));
        this.mTrialsVarLabel = DialogUtil.createLabel(this.mParent, "IDS_GLM_TRIALS_VARIABLE");
        this.mNumberOfTrialsLabel = DialogUtil.createLabel(this.mParent, "IDS_GLM_NUMBER_OF_TRIALS");
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.setSelectionMode(0);
        this.mSrcVarList.getSelectionModel().addListSelectionListener(this);
        this.mDependentTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mDependentTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mScaleWeightTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mScaleWeightTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mScaleWeightTargetVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mTrialsTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTrialsTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTrialsTargetVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mTrialsVarLabel.setLabelFor(this.mTrialsTargetVarList);
        this.mDependentVarArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mDependentVarArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mDependentVarArrow.registerVariableList(this.mDependentTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mDependentVarArrow.setVarMoveHandler(this);
        this.mTrialsArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mTrialsArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mTrialsArrow.registerVariableList(this.mTrialsTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mTrialsArrow.setVarMoveHandler(this);
        this.mScaleWeightArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mScaleWeightArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mScaleWeightArrow.registerVariableList(this.mScaleWeightTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mRefCategoryButton = new JButton();
        this.mNumberOfTrialsField = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mNumberOfTrialsField.setColumns(7);
        this.mNumberOfTrialsLabel.setLabelFor((Component)this.mNumberOfTrialsField);
        this.mVariableRadio.addItemListener(this);
        this.mFixedValueRadio.addItemListener(this);
        this.mNumberOfEventsRadio.addItemListener(this);
        this.mBinaryResponseRadio.addItemListener(this);
        this.mDependentTargetVarList.getModel().addListDataListener(this);
        this.mTrialsTargetVarList.getModel().addListDataListener(this);
        this.mNumberOfTrialsField.getDocument().addDocumentListener(this);
        this.mNumberOfTrialsField.addFocusListener((FocusListener)this);
        this.mDependentTargetVarList.setIdentifier(TARGET_DEPENDENT_LIST_KEY);
        this.mTrialsTargetVarList.setIdentifier(TARGET_TRIAL_LIST_KEY);
        this.mScaleWeightTargetVarList.setIdentifier(TARGET_SCALE_WEIGHT_LIST_KEY);
        this.mSrcVarList.setIdentifier(SOURCE_LIST_KEY);
        this.mNumberOfTrialsField.setAction((Action)new TextFieldAction(this.mParent, NUMBER_OF_TRIALS_KEY));
        this.mComponent = new Vector();
        this.mSyntax = new StringBuffer();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_GLM_REF_CATEGORY"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ResponseTab.this.runReferenceCategorysSubDialog();
            }
        };
        this.mRefCategoryButton = new JButton(toggleButtonAction);
    }

    private void validateReferenceDataModel() {
        DialogDataModel dialogDataModel = ((BaseProcedureDialog)this.mParent).getDialogDataModel();
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray("TARGET_DEPENDENT_LIST_KEY");
        if (iSpssVariableArray == null || iSpssVariableArray.length == 0) {
            dialogDataModel.putInteger(CommonReferenceCategory.VALUE_KEY, null);
            dialogDataModel.putString("IDS_GLM_REF_CAT_COMBO_VALUE", null);
            dialogDataModel.putBoolean("IDS_GLM_LAST_VALUE", true);
            dialogDataModel.putBoolean("IDS_GLM_FIRST_VALUE", null);
            dialogDataModel.putBoolean("IDS_LOGISTIC_REGRESSION_REF_CAT_CUSTOM_RADIOBUTTON", null);
        }
    }
}

