/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model;

import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.ListFocusTraversalPolicy;
import com.spss.java_client.ui.controls.ListTravArrowButtonFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.VarListDropListener;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.GEEVarListDropListener;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.GLMOptions;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.GeneralizedLinearModelsDlg;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.generalized_estm_eqn.GeneralizedEstimatingEquationsDlg;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class PredictorsTab
extends BaseProcedureTab
implements ItemListener,
FocusListener {
    static final String COVARIATES_TARGET_LIST_KEY = "COVARIATES_TARGET_LIST";
    static final String FACTORS_TARGET_LIST_KEY = "FACTORS_TARGET_LIST";
    static final String OFFSET_TARGET_LIST_KEY = "OFFSET_TARGET_LIST";
    static final String VARIABLE_RADIO_KEY = "IDS_GLM_PREDICT_VARIABLE_RADIO";
    static final String FIXED_VALUE_RADIO_KEY = "IDS_GLM_PREDICT_FIXED_VALUE_RADIO";
    static final String FIXED_VALUE_TEXT_KEY = "FIXED_VALUE_TEXT";
    private static final int LIST_HEIGHT = 50;
    private static final int LIST_WIDTH = 150;
    private SrcVariableList mVariableSrcList;
    private JScrollPane mSrcScrollPane;
    private static TargetVariableList mFactorTargetVarList;
    private static TargetVariableList mCovariatesTargetVarList;
    private TargetVariableList mOffsetTargetVarList;
    private JScrollPane mOffsetTargetVarListScrollPane;
    private JScrollPane mFactorTargetVarListScrollPane;
    private JScrollPane mCovariatesTargetVarListScrollPane;
    private JButton mOptionsButton;
    private JRadioButton mVariableRadio;
    private JRadioButton mFixedValueRadio;
    private JLabel mOffsetLabel;
    private JLabel mValueLabel;
    private FloatTextField mFixedValueText;
    private ArrowButton mFactorArrowButton;
    private ArrowButton mCovariatesArrowButton;
    private ArrowButton mOffsetVariableArrowButton;
    private JPanel mFactorUpAndDownArrowButtonPanel;
    private JPanel mCovariatesUpAndDownArrowButtonPanel;
    private JSeparator mSeparator;
    private SpssButtonGroup mGroup;
    private ListTravArrowButtonFactory mArrowButtonFactors;
    private ListTravArrowButtonFactory mArrowButtonCovariates;
    private boolean mGLM;

    public PredictorsTab(BaseTabbedDialog baseTabbedDialog, boolean bl) {
        super(baseTabbedDialog, true);
        this.mGLM = bl;
        this.initialize();
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mVariableSrcList;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PredictorsTab.this.mFixedValueText.selectAll();
                PredictorsTab.this.mFixedValueText.requestFocusInWindow();
            }
        });
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.mFixedValueText.setSelectionStart(0);
        this.mFixedValueText.setSelectionEnd(0);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mVariableRadio)) {
            if (this.mVariableRadio.isSelected()) {
                if (this.mOffsetVariableArrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.left) {
                    if (this.mOffsetTargetVarList.getModel().getSize() == 1) {
                        this.mOffsetVariableArrowButton.setEnabled(true);
                    }
                } else if (this.mVariableSrcList.getSelectedIndices().length == 1) {
                    if (this.mOffsetTargetVarList.getModel().getSize() == 0 && this.mOffsetVariableArrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.right) {
                        this.mOffsetVariableArrowButton.setEnabled(true);
                    }
                } else {
                    this.mOffsetVariableArrowButton.setEnabled(false);
                }
                this.mOffsetTargetVarList.setEnabled(true);
                this.mOffsetTargetVarList.setOpaque(true);
                this.mOffsetLabel.setEnabled(true);
            } else {
                this.mOffsetTargetVarList.setEnabled(false);
                this.mOffsetTargetVarList.setOpaque(false);
                this.mOffsetLabel.setEnabled(false);
            }
        }
        if (itemEvent.getSource().equals(this.mFixedValueRadio)) {
            this.mOffsetVariableArrowButton.setEnabled(false);
            this.mValueLabel.setEnabled(this.mFixedValueRadio.isSelected());
            this.mFixedValueText.setEnabled(this.mFixedValueRadio.isSelected());
            this.mFixedValueText.setOpaque(this.mFixedValueRadio.isSelected());
        }
    }

    @Override
    public String getDialogHelpID() {
        if (this.mGLM) {
            return "idh_idd_genlin_predictors";
        }
        return "idh_idd_gee_predictors";
    }

    public static VarListModel getFactorsTargetListModel() {
        return mFactorTargetVarList.getModel();
    }

    public static VarListModel getCovariateTargetListModel() {
        return mCovariatesTargetVarList.getModel();
    }

    public TargetVariableList getFactorTargetList() {
        return mFactorTargetVarList;
    }

    public TargetVariableList getCovariateTargetList() {
        return mCovariatesTargetVarList;
    }

    public TargetVariableList getOffsetTargetList() {
        return this.mOffsetTargetVarList;
    }

    public String getByCommandSyntax() {
        String string = mFactorTargetVarList.getVariablesStringList();
        if (string.length() > 0) {
            return "BY " + string;
        }
        return null;
    }

    public String getWithCommandSyntax() {
        String string = mCovariatesTargetVarList.getVariablesStringList();
        if (string.length() > 0) {
            return "WITH " + string;
        }
        return null;
    }

    public String getOffsetCommandSyntax() {
        String string;
        if (this.mVariableRadio.isSelected()) {
            String string2 = this.mOffsetTargetVarList.getVariablesStringList();
            if (string2.length() > 0) {
                return "OFFSET=" + string2;
            }
        } else if (this.mFixedValueRadio.isSelected() && (string = this.mFixedValueText.getText()).length() > 0) {
            return "OFFSET=" + string;
        }
        return null;
    }

    @Override
    public void reset() {
        mFactorTargetVarList.getModel().removeAll();
        mCovariatesTargetVarList.getModel().removeAll();
        this.mOffsetTargetVarList.getModel().removeAll();
        this.setDefaults();
    }

    @Override
    protected void aboutToShowTab() {
        this.mFactorArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mCovariatesArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mOffsetVariableArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        Vector<Object> vector = this.setFocusTraversalPolicy();
        ListFocusTraversalPolicy listFocusTraversalPolicy = new ListFocusTraversalPolicy(new ListTravArrowButtonFactory[]{this.mArrowButtonFactors, this.mArrowButtonCovariates}, vector, false);
        this.setFocusTraversalPolicy(listFocusTraversalPolicy);
        Component component = this.mGLM ? ((GeneralizedLinearModelsDlg)((Object)this.getTopLevelAncestor())).getGlassPane() : ((GeneralizedEstimatingEquationsDlg)((Object)this.getTopLevelAncestor())).getGlassPane();
        if (component instanceof DragPane) {
            DragPane dragPane = (DragPane)component;
            dragPane.getDropListeners().removeAllElements();
            if (this.mGLM) {
                dragPane.addDropListener((IDropListener)new VarListDropListener(mFactorTargetVarList));
                dragPane.addDropListener((IDropListener)new VarListDropListener(mCovariatesTargetVarList));
                dragPane.addDropListener((IDropListener)new VarListDropListener(this.mOffsetTargetVarList));
                dragPane.addDropListener((IDropListener)new VarListDropListener(this.mVariableSrcList));
            } else {
                dragPane.addDropListener((IDropListener)new GEEVarListDropListener(mFactorTargetVarList, null, (GeneralizedEstimatingEquationsDlg)this.mParent));
                dragPane.addDropListener((IDropListener)new GEEVarListDropListener(mCovariatesTargetVarList, null, (GeneralizedEstimatingEquationsDlg)this.mParent));
                dragPane.addDropListener((IDropListener)new GEEVarListDropListener(this.mOffsetTargetVarList, null, (GeneralizedEstimatingEquationsDlg)this.mParent));
                dragPane.addDropListener((IDropListener)new GEEVarListDropListener(this.mVariableSrcList, null, (GeneralizedEstimatingEquationsDlg)this.mParent));
            }
        }
    }

    private void initialize() {
        this.initVars();
        this.setDefaults();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        Insets insets = UIToolDialogUtil.getStandardDialogInsets();
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom, 0);
        Insets insets3 = DialogUtil.getStandardControlInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(this, this.setupListPanel(), gridBagConstraints, 0, 0, 1, 5, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        ImageIcon imageIcon = new ImageIcon(ResUtil.getImageResourceFullPath(AnalyzeResBundle.getImageFolder() + this.getResString("IDS_GLM_PREDICT_FACTOR_IMG")));
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_GLM_PREDICT_FACTOR_LABEL");
        jLabel.setIcon(imageIcon);
        jLabel.setLabelFor(mFactorTargetVarList);
        JComponent[] jComponentArray = new JComponent[]{this.mFactorArrowButton, jLabel, this.mFactorTargetVarListScrollPane, this.mFactorUpAndDownArrowButtonPanel};
        insets2.set(insets.top, 0, 0, insets.right);
        DialogUtil.addUsingGBL(this, this.setupTargetlistPanel(jComponentArray), gridBagConstraints, 1, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 23;
        insets2.set(n2, 7 * n2, n2, n2);
        DialogUtil.addUsingGBL(this, this.mOptionsButton, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(this, this.mSeparator, gridBagConstraints, 1, 2, 2, 1, n, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        imageIcon = new ImageIcon(ResUtil.getImageResourceFullPath(AnalyzeResBundle.getImageFolder() + this.getResString("IDS_GLM_PREDICT_COVARIATES_IMG")));
        JLabel jLabel2 = DialogUtil.createLabel(this.mParent, "IDS_GLM_PREDICT_COVARIATES_LABEL");
        jLabel2.setIcon(imageIcon);
        jLabel2.setLabelFor(mCovariatesTargetVarList);
        JComponent[] jComponentArray2 = new JComponent[]{this.mCovariatesArrowButton, jLabel2, this.mCovariatesTargetVarListScrollPane, this.mCovariatesUpAndDownArrowButtonPanel};
        insets2.set(n2, 0, 0, insets.right);
        DialogUtil.addUsingGBL(this, this.setupTargetlistPanel(jComponentArray2), gridBagConstraints, 1, 3, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        n = 23;
        insets2.set(0, 0, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(this, this.setupOffsetPanel(), gridBagConstraints, 1, 4, 2, 1, n, insets2);
    }

    private JPanel setupTargetlistPanel(JComponent[] jComponentArray) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 10;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, jComponentArray[0], gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jComponentArray[1], gridBagConstraints, 1, 0, 1, 1, n, null);
        n = 25;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jComponentArray[2], gridBagConstraints, 1, 1, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        DialogUtil.addUsingGBL(jPanel, jComponentArray[3], gridBagConstraints, 2, 1, 1, 1, n, null);
        return jPanel;
    }

    private Vector<Object> setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mVariableSrcList);
        vector.add(this.mFactorArrowButton);
        vector.add(this.mCovariatesArrowButton);
        vector.add(mFactorTargetVarList);
        vector.add(this.mArrowButtonFactors.getUpArrowButton());
        vector.add(this.mArrowButtonFactors.getDownArrowButton());
        vector.add(this.mOptionsButton);
        vector.add(mCovariatesTargetVarList);
        vector.add(this.mArrowButtonCovariates.getUpArrowButton());
        vector.add(this.mArrowButtonCovariates.getDownArrowButton());
        vector.add(this.mGroup);
        vector.add(this.mOffsetVariableArrowButton);
        vector.add(this.mOffsetTargetVarList);
        vector.add(this.mFixedValueText);
        this.setComponentOrder(vector);
        return vector;
    }

    private JPanel setupListPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_GLM_PREDICT_VARIABLES_LABEL");
        jLabel.setLabelFor(this.mVariableSrcList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupOffsetPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_GLM_PREDICT_OFFSET_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, this.mVariableRadio, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mOffsetLabel, gridBagConstraints, 1, 1, 1, 1, n, null);
        Insets insets2 = new Insets(n2, 15, 2, 20);
        DialogUtil.addUsingGBL(jPanel, this.mOffsetVariableArrowButton, gridBagConstraints, 0, 1, 1, 2, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        n = 23;
        insets2.set(0, 0, 0, 3 * n2 + 4);
        DialogUtil.addUsingGBL(jPanel, this.mOffsetTargetVarListScrollPane, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mFixedValueRadio, gridBagConstraints, 0, 3, 2, 1, n, null);
        insets2.set(0, 15, 0, 18);
        DialogUtil.addUsingGBL(jPanel, this.mValueLabel, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        n = 23;
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        insets2.set(0, 0, n3, 3 * n2 + 4);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mFixedValueText, gridBagConstraints, 1, 4, 1, 1, n, insets2);
        this.mGroup = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private void setDefaults() {
        this.mVariableSrcList.loadFromActiveDataset();
        if (this.mVariableSrcList.getModel().getSize() > 0) {
            this.mVariableSrcList.setSelectedIndex(0);
        }
        this.mVariableRadio.setSelected(true);
        this.mValueLabel.setEnabled(false);
        this.mFixedValueText.setEnabled(false);
        this.mFixedValueText.setOpaque(false);
        this.mFixedValueText.setText("");
        this.mFactorArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mCovariatesArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mOffsetVariableArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
    }

    private void initVars() {
        this.mVariableSrcList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        if (this.mGLM) {
            if (((GeneralizedLinearModelsDlg)this.mParent).mResTab != null) {
                this.mVariableSrcList.setModel(((GeneralizedLinearModelsDlg)this.mParent).mResTab.getSrcVariableList().getModel());
            }
        } else if (((GeneralizedEstimatingEquationsDlg)this.mParent).getRepeatedTab() != null) {
            this.mVariableSrcList.setModel(((GeneralizedEstimatingEquationsDlg)this.mParent).getResponseTab().getSrcVariableList().getModel());
        }
        this.mSrcScrollPane = new JScrollPane(this.mVariableSrcList);
        this.mSrcScrollPane.setPreferredSize(this.mVariableSrcList.getMinimumSize());
        this.mSrcScrollPane.setHorizontalScrollBarPolicy(30);
        this.mSrcScrollPane.setVerticalScrollBarPolicy(20);
        mFactorTargetVarList = new TargetVariableList();
        mFactorTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        mFactorTargetVarList.setIdentifier(FACTORS_TARGET_LIST_KEY);
        mFactorTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), mFactorTargetVarList.getFixedCellHeight() * 6 + 2));
        this.mFactorTargetVarListScrollPane = new JScrollPane(mFactorTargetVarList);
        this.mFactorTargetVarListScrollPane.setPreferredSize(new Dimension(150, 50));
        mCovariatesTargetVarList = new TargetVariableList();
        mCovariatesTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        mCovariatesTargetVarList.addVarFilter(new SpssVarFilter(8, true, false));
        mCovariatesTargetVarList.setIdentifier(COVARIATES_TARGET_LIST_KEY);
        mCovariatesTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), mCovariatesTargetVarList.getFixedCellHeight() * 6 + 2));
        this.mCovariatesTargetVarListScrollPane = new JScrollPane(mCovariatesTargetVarList);
        this.mCovariatesTargetVarListScrollPane.setPreferredSize(new Dimension(150, 50));
        this.mOffsetTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mOffsetTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mOffsetTargetVarList.setIdentifier(OFFSET_TARGET_LIST_KEY);
        this.mOffsetTargetVarList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mOffsetTargetVarListScrollPane = new JScrollPane(this.mOffsetTargetVarList);
        this.mOffsetTargetVarListScrollPane.setPreferredSize(this.mOffsetTargetVarList.getMinimumSize());
        this.mOffsetTargetVarListScrollPane.setHorizontalScrollBarPolicy(31);
        this.mOffsetTargetVarListScrollPane.setVerticalScrollBarPolicy(21);
        this.mFactorArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.left);
        this.mFactorArrowButton.registerVariableList(this.mVariableSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mFactorArrowButton.registerVariableList(mFactorTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mCovariatesArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mCovariatesArrowButton.registerVariableList(this.mVariableSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mCovariatesArrowButton.registerVariableList(mCovariatesTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mOffsetVariableArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mOffsetVariableArrowButton.registerVariableList(this.mVariableSrcList, SpssArrowButton.ButtonOrientation.right);
        this.mOffsetVariableArrowButton.registerVariableList(this.mOffsetTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mArrowButtonFactors = new ListTravArrowButtonFactory(mFactorTargetVarList, false);
        this.mFactorUpAndDownArrowButtonPanel = this.mArrowButtonFactors.getArrowButtonPanel();
        this.mArrowButtonCovariates = new ListTravArrowButtonFactory(mCovariatesTargetVarList, false);
        this.mCovariatesUpAndDownArrowButtonPanel = this.mArrowButtonCovariates.getArrowButtonPanel();
        ControlAction controlAction = new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PredictorsTab.this.mGLM) {
                    boolean bl = ((GeneralizedLinearModelsDlg)PredictorsTab.this.mParent).hasSplitVar();
                    new GLMOptions((BaseProcedureDialog)PredictorsTab.this.mParent, PredictorsTab.this.getResString("IDS_GLM_OPTIONS_TITLE"), bl).setVisible(true);
                } else {
                    boolean bl = ((GeneralizedEstimatingEquationsDlg)PredictorsTab.this.mParent).hasSplitVar();
                    new GLMOptions((BaseProcedureDialog)PredictorsTab.this.mParent, PredictorsTab.this.getResString("IDS_GEE_OPTIONS_TITLE"), bl).setVisible(true);
                }
            }
        };
        this.mOptionsButton = new JButton(controlAction);
        controlAction = new ToggleButtonAction(this.mParent, VARIABLE_RADIO_KEY);
        this.mVariableRadio = new JRadioButton(controlAction);
        this.mVariableRadio.addItemListener(this);
        controlAction = new ToggleButtonAction(this.mParent, FIXED_VALUE_RADIO_KEY);
        this.mFixedValueRadio = new JRadioButton(controlAction);
        this.mOffsetLabel = DialogUtil.createLabel(this.mParent, "IDS_GLM_PREDICT_OFFSET_VAR_LABEL");
        this.mOffsetLabel.setLabelFor(this.mOffsetTargetVarList);
        this.mFixedValueRadio.addItemListener(this);
        controlAction = new TextFieldAction(this.mParent, FIXED_VALUE_TEXT_KEY);
        this.mFixedValueText = new FloatTextField();
        this.mFixedValueText.setAction((Action)controlAction);
        this.mFixedValueText.addFocusListener((FocusListener)this);
        this.mValueLabel = DialogUtil.createLabel(this.mParent, "IDS_GLM_PREDICT_VALUE_LABEL");
        this.mValueLabel.setLabelFor((Component)this.mFixedValueText);
        this.mSeparator = new JSeparator();
    }
}

