/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssCovariateVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssFactorVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.ComponentsArrowButton;
import com.spss.java_client.ui.controls.ListTravArrowButtonFactory;
import com.spss.java_client.ui.controls.ModelTermsList;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableCombinations;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.AbstractDropListener;
import com.spss.java_client.ui.controls.drag_drop.ListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.TermsListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.TermsListDropListener;
import com.spss.java_client.ui.controls.drag_drop.VarListDropListener;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.GeneralizedLinearModelsDlg;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.generalized_estm_eqn.GeneralizedEstimatingEquationsDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.border.SpssBaseTitleBorder;
import com.spss.uitools.controls.drag_drop.ComponentDragAdapter;
import com.spss.uitools.controls.drag_drop.DragDropAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.DropEvent;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ModelTab
extends BaseProcedureTab
implements ActionListener,
FocusListener,
ListSelectionListener,
ListDataListener {
    public IDropListener listener;
    static final String BUILD_TERMS_COMBO_KEY = "IDS_BUILD_TERMS";
    static final String COMMON_MODEL_INCLUDE_MODEL = "IDS_COMPLEX_SAMPLES_COMMON_MODEL_INCLUDE_CHECKBOX";
    public static String MODEL_TERMS_KEY = "IDS_MODEL_TERMS";
    static final String COMMON_MODEL_TERM = "IDS_COMMON_MODEL_TERM";
    protected static TargetVariableList mFactorsVarList;
    protected static ModelTermsList mTermsVarList;
    protected static VarListModel mFactorsModel;
    protected static VarListModel mCovModel;
    protected JPanel mFactorTermPanel;
    protected JComboBox mBuildTermCombo;
    protected ComponentsArrowButton mArrowButton;
    protected Vector<Object> mTabOrder;
    protected JLabel mFactorsLbl;
    protected JLabel mTermsLbl;
    final int MAIN_EFFECTS = 0;
    final int INTERACTION = 1;
    final int FACTORIAL = 2;
    final int ALL_TWO_WAY = 3;
    final int ALL_THREE_WAY = 4;
    final int ALL_FOUR_WAY = 5;
    final int ALL_FIVE_WAY = 6;
    private String[] mBuildTermItems;
    private JPanel mUpDownArrowButton;
    private ArrowButton mNestedTermArrow;
    private StringTextField mTermTextField;
    private JButton mByButton;
    private JButton mWithinButton;
    private JButton mAddModelButton;
    private JButton mClearButton;
    private JCheckBox mIncludeModelCheck;
    private JLabel mTermLabel;
    private JLabel lblCount;
    private ListTravArrowButtonFactory mListArrowButtonFactory;
    private ArrayList<String> mAddedElements;
    private boolean mErrorFlag;
    private boolean mGLM;
    private boolean mIsSetText;
    private boolean mFlag = false;

    public ModelTab(BaseTabbedDialog baseTabbedDialog, VarListModel varListModel, VarListModel varListModel2, boolean bl) {
        super(baseTabbedDialog, true);
        mFactorsModel = varListModel;
        mCovModel = varListModel2;
        this.mGLM = bl;
        ModelTab.loadValuesInModel();
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return mFactorsVarList;
    }

    public static ListModel getTargetListModel() {
        return mTermsVarList.getModel();
    }

    public boolean isCheckBoxSelected() {
        return this.mIncludeModelCheck.isSelected();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updateCountLabel();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (mTermsVarList.getModel().getSize() < 1) {
            this.mArrowButton.setEnabled(false);
        }
        this.updateCountLabel();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updateCountLabel();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (mFactorsVarList.getSelectedIndex() >= 0) {
            this.setNestedArrowButtonEnable();
            this.mArrowButton.setEnabled(true);
        } else {
            this.setNestedArrowButtonEnable();
            this.mArrowButton.setEnabled(false);
        }
    }

    @Override
    public String getDialogHelpID() {
        if (this.mGLM) {
            return "idh_idd_genlin_model";
        }
        return "idh_idd_gee_model";
    }

    @Override
    public void reset() {
        this.setDefaults();
        mFactorsVarList.getModel().removeAll();
        ((DefaultListModel)mTermsVarList.getModel()).clear();
        this.mTermTextField.setText("");
        this.updateUI();
    }

    public String getModelCommandSyntax() {
        String string = "";
        if (mTermsVarList.getModel().getSize() > 0) {
            for (int i = 0; i < mTermsVarList.getModel().getSize(); ++i) {
                string = string + mTermsVarList.getModel().getElementAt(i) + " ";
            }
        }
        return string.trim();
    }

    public String getInterceptCommandSyntax() {
        String string = "";
        if (this.isIncludeModeCheckEnabled()) {
            string = "INTERCEPT=";
            if (this.mIncludeModelCheck.isSelected()) {
                string = string + "YES";
                return string;
            }
            return string + "NO";
        }
        return string;
    }

    public static void loadValuesInModel() {
        int n;
        int n2;
        VarListModel varListModel = mFactorsVarList.getModel();
        varListModel.removeAll();
        if (mFactorsModel != null) {
            n2 = mFactorsModel.getSize();
            for (n = 0; n < n2; ++n) {
                varListModel.addElement((ISpssVariable)new SpssFactorVariable((SpssVariable)mFactorsModel.getElementAt(n)));
            }
        }
        if (mCovModel != null) {
            n2 = mCovModel.getSize();
            for (n = 0; n < n2; ++n) {
                varListModel.addElement((ISpssVariable)new SpssCovariateVariable((SpssVariable)mCovModel.getElementAt(n)));
            }
        }
        if (varListModel.getSize() > 0) {
            mFactorsVarList.setSelectedIndex(0);
        }
    }

    public static void ensureConsistent() {
        int n;
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = mFactorsVarList.getModel().getSize();
        for (n = 0; n < n2; ++n) {
            hashSet.add(mFactorsVarList.getModel().getElementAt(n).getName());
        }
        n2 = mTermsVarList.getModel().getSize();
        for (n = n2 - 1; n >= 0; --n) {
            Object e = mTermsVarList.getModel().getElementAt(n);
            if (!(e instanceof String)) continue;
            String string = (String)e;
            Set<String> set = ModelTab.parseTermString(string);
            set.removeAll(hashSet);
            if (set.size() <= 0) continue;
            DefaultListModel defaultListModel = (DefaultListModel)mTermsVarList.getModel();
            defaultListModel.removeElement(string);
        }
    }

    @Override
    public boolean validateTab() {
        if (this.mTermTextField.getText().trim().length() > 0 && this.mAddModelButton.isEnabled()) {
            if (SpssAlertOptionPane.showConfirmDialog((Window)this.mParent, this.getResString("ERR_COMPLEX_SAMPLES_COMMON_MODEL_TERM_EXIST_CONTINUE_MSG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.YES_NO_OPTION) == 2) {
                return false;
            }
            String string = this.mTermTextField.getText().trim();
            if (string.length() > 0) {
                DefaultListModel defaultListModel = (DefaultListModel)mTermsVarList.getModel();
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string);
                this.filterUniqueItems(arrayList, defaultListModel);
                if (arrayList.size() == 0) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_MODEL_DUPLICATE_MSG1"), VersionInfo.getAppVersionString());
                } else {
                    defaultListModel.addElement(string);
                }
                this.mTermTextField.setText("");
            }
        } else if (this.mTermTextField.getText().trim().length() > 0 && !this.mAddModelButton.isEnabled()) {
            if (SpssAlertOptionPane.showConfirmDialog((Window)this.mParent, this.getResString("ERR_COMPLEX_SAMPLES_COMMON_MODEL_TERM_EXIST_CONTINUE_ERR_MSG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.YES_NO_OPTION) == 2) {
                return false;
            }
            this.mTermTextField.setText("");
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2;
        String[] stringArray;
        ISpssVariable[] iSpssVariableArray;
        Object object3 = actionEvent.getSource();
        if (object3 == this.mArrowButton) {
            if (this.mArrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.right) {
                int n;
                iSpssVariableArray = (ISpssVariable[])mTermsVarList.getModel();
                stringArray = mFactorsVarList.getSelectedValues();
                if (stringArray == null || stringArray.length == 0) {
                    return;
                }
                object2 = new ArrayList();
                for (String string : stringArray) {
                    ((ArrayList)object2).add(string.getName());
                }
                object = new Vector();
                for (ISpssVariable object42 : stringArray) {
                    ((Vector)object).add(object42.getName());
                }
                String[] stringArray2 = null;
                ArrayList<String> arrayList = new ArrayList<String>();
                int n2 = this.mBuildTermCombo.getSelectedIndex();
                switch (n2) {
                    case 0: {
                        String[] n4 = stringArray;
                        int n3 = n4.length;
                        for (n = 0; n < n3; ++n) {
                            String string = n4[n];
                            arrayList.add(string.getName());
                        }
                        break;
                    }
                    case 1: {
                        void var10_16;
                        String string = "";
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (i == stringArray.length - 1) {
                                String string2 = (String)var10_16 + stringArray[i].getName();
                                continue;
                            }
                            String string3 = (String)var10_16 + stringArray[i].getName() + "*";
                        }
                        if (stringArray.length <= 0) break;
                        arrayList.add((String)var10_16);
                        break;
                    }
                    case 2: {
                        VariableCombinations variableCombinations = new VariableCombinations((Vector<String>)object, 1, ((Vector)object).size());
                        for (String string : variableCombinations.sortByDependentElements((Vector<String>)object, variableCombinations.getCombinations())) {
                            arrayList.add(string);
                        }
                        break;
                    }
                    case 3: {
                        for (String string : stringArray2 = this.get2WayItems((ArrayList<String>)object2)) {
                            arrayList.add(string);
                        }
                        break;
                    }
                    case 4: {
                        for (String string : stringArray2 = this.get3WayItems((ArrayList<String>)object2)) {
                            arrayList.add(string);
                        }
                        break;
                    }
                    case 5: {
                        for (String string : stringArray2 = this.get4WayItems((ArrayList<String>)object2)) {
                            arrayList.add(string);
                        }
                        break;
                    }
                    case 6: {
                        for (String string : stringArray2 = this.get5WayItems((ArrayList<String>)object2)) {
                            arrayList.add(string);
                        }
                        break;
                    }
                }
                int n4 = arrayList.size();
                this.filterUniqueItems(arrayList, (DefaultListModel)iSpssVariableArray);
                if (arrayList.size() == 0) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_MODEL_DUPLICATE_MSG1"), VersionInfo.getAppVersionString());
                    mFactorsVarList.requestFocus();
                    return;
                }
                if (arrayList.size() < n4) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_MODEL_DUPLICATE_MSG2"), VersionInfo.getAppVersionString());
                }
                Object object4 = arrayList.iterator();
                while (object4.hasNext()) {
                    iSpssVariableArray.addElement(object4.next());
                }
                object4 = new int[arrayList.size()];
                for (n = 0; n < arrayList.size(); ++n) {
                    int n5 = iSpssVariableArray.indexOf(arrayList.get(n));
                    if (n5 <= -1) continue;
                    object4[n] = n5;
                }
                mTermsVarList.setSelectedIndices((int[])object4);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        mTermsVarList.requestFocus();
                    }
                });
            } else if (this.mArrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.left) {
                this.removeSelectedModelItems();
            }
        }
        if (actionEvent.getSource() == this.mNestedTermArrow) {
            this.mErrorFlag = false;
            this.mIsSetText = false;
            iSpssVariableArray = mFactorsVarList.getSelectedValues();
            if (iSpssVariableArray.length > 1) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_COMPLEX_SAMPLES_COMMON_MODEL_ONLY_ONE_VAR_MSG"), VersionInfo.getAppVersionString());
                return;
            }
            stringArray = (String[])mFactorsVarList.getSelectedValue();
            object2 = stringArray.getName();
            object = new ArrayList();
            ((ArrayList)object).add(object2);
            ((ArrayList)object).removeAll(this.mAddedElements);
            if (this.isPresentInFactorsList((ISpssVariable)stringArray) && ((ArrayList)object).size() == 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_COMPLEX_SAMPLES_COMMON_MODEL_FACTOR_UNIQUE_MSG"), VersionInfo.getAppVersionString());
                return;
            }
            if (this.mTermTextField.getText().trim().length() == 0) {
                this.mTermTextField.setText((String)object2);
            } else {
                this.mTermTextField.setText(this.getElementNameAddedText(this.mTermTextField.getText(), (String)object2, this.isPresentInCovariatesList((ISpssVariable)stringArray)));
            }
            if (!this.mErrorFlag) {
                this.setAllButtonsEnabled(true);
                this.mNestedTermArrow.setEnabled(false);
            }
            this.mAddedElements.add((String)object2);
            this.mIsSetText = true;
        }
    }

    private void removeSelectedModelItems() {
        String[] stringArray;
        DefaultListModel defaultListModel = (DefaultListModel)mTermsVarList.getModel();
        for (String string : stringArray = mTermsVarList.getSelectedValues()) {
            defaultListModel.removeElement(string);
        }
        if (defaultListModel.size() > 0) {
            mTermsVarList.setSelectedIndex(0);
            mTermsVarList.requestFocus();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object == mFactorsVarList) {
            this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        } else if (object == mTermsVarList) {
            this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
        } else if (object.equals(this.mTermTextField) && !this.mIsSetText) {
            this.mTermTextField.selectAll();
        } else {
            this.mTermTextField.setSelectionStart(0);
            this.mTermTextField.setSelectionEnd(0);
            this.mIsSetText = false;
        }
        this.setArrowButtonEnableStatus();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.mTermTextField.setSelectionStart(0);
        this.mTermTextField.setSelectionEnd(0);
    }

    protected void filterUniqueItems(ArrayList<String> arrayList, DefaultListModel defaultListModel) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        if (arrayList.get(0).contains("(") || arrayList.get(0).contains("*")) {
            StringTokenizer stringTokenizer = new StringTokenizer(arrayList.get(0), "*()");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken().toString();
                arrayList4.add(string);
            }
        }
        int n = defaultListModel.getSize();
        for (int i = 0; i < n; ++i) {
            String string = (String)defaultListModel.getElementAt(i);
            arrayList2.add(string);
            arrayList3.clear();
            if (string.contains("(") || string.contains("*")) {
                StringTokenizer stringTokenizer = new StringTokenizer(ModelTab.getTargetListModel().getElementAt(i).toString(), "*()");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken().toString();
                    arrayList3.add(string2);
                }
            }
            Collections.sort(arrayList4);
            Collections.sort(arrayList3);
            if (arrayList3.size() > 0 && arrayList4.size() > 0 && arrayList3.size() == arrayList4.size() && arrayList3.containsAll(arrayList4)) {
                arrayList.remove(0);
                continue;
            }
            if (arrayList3.size() != 0 || arrayList4.size() != 0) continue;
            arrayList.removeAll(arrayList2);
        }
    }

    protected void setArrowButtonEnableStatus() {
        if (this.mArrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.right) {
            this.mArrowButton.setEnabled(mFactorsVarList.getSelectedIndex() >= 0);
        } else if (this.mArrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.left) {
            this.mArrowButton.setEnabled(mTermsVarList.getSelectedIndex() >= 0);
        }
    }

    protected String[] get2WayItems(ArrayList<String> arrayList) {
        String[] stringArray;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = arrayList.size();
        if (n < 2) {
            stringArray = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                if (i == 0) {
                    stringArray.append(arrayList.get(i));
                    continue;
                }
                stringArray.append("*").append(arrayList.get(i));
            }
            arrayList2.add(stringArray.toString());
        } else {
            for (int i = 0; i < n; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(arrayList.get(i)).append("*");
                    stringBuffer.append(arrayList.get(j));
                    arrayList2.add(stringBuffer.toString());
                }
            }
        }
        stringArray = new String[arrayList2.size()];
        arrayList2.toArray(stringArray);
        return stringArray;
    }

    protected String[] get3WayItems(ArrayList<String> arrayList) {
        String[] stringArray;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = arrayList.size();
        if (n < 3) {
            stringArray = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                if (i == 0) {
                    stringArray.append(arrayList.get(i));
                    continue;
                }
                stringArray.append("*").append(arrayList.get(i));
            }
            arrayList2.add(stringArray.toString());
        } else {
            for (int i = 0; i < n; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    for (int k = j + 1; k < n; ++k) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(arrayList.get(i)).append("*");
                        stringBuffer.append(arrayList.get(j)).append("*");
                        stringBuffer.append(arrayList.get(k));
                        arrayList2.add(stringBuffer.toString());
                    }
                }
            }
        }
        stringArray = new String[arrayList2.size()];
        arrayList2.toArray(stringArray);
        return stringArray;
    }

    protected String[] get4WayItems(ArrayList<String> arrayList) {
        String[] stringArray;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = arrayList.size();
        if (n < 4) {
            stringArray = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                if (i == 0) {
                    stringArray.append(arrayList.get(i));
                    continue;
                }
                stringArray.append("*").append(arrayList.get(i));
            }
            arrayList2.add(stringArray.toString());
        } else {
            for (int i = 0; i < n; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    for (int k = j + 1; k < n; ++k) {
                        for (int i2 = k + 1; i2 < n; ++i2) {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(arrayList.get(i)).append("*");
                            stringBuffer.append(arrayList.get(j)).append("*");
                            stringBuffer.append(arrayList.get(k)).append("*");
                            stringBuffer.append(arrayList.get(i2));
                            arrayList2.add(stringBuffer.toString());
                        }
                    }
                }
            }
        }
        stringArray = new String[arrayList2.size()];
        arrayList2.toArray(stringArray);
        return stringArray;
    }

    protected String[] get5WayItems(ArrayList<String> arrayList) {
        String[] stringArray;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = arrayList.size();
        if (n < 5) {
            stringArray = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                if (i == 0) {
                    stringArray.append(arrayList.get(i));
                    continue;
                }
                stringArray.append("*").append(arrayList.get(i));
            }
            arrayList2.add(stringArray.toString());
        } else {
            for (int i = 0; i < n; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    for (int k = j + 1; k < n; ++k) {
                        for (int i2 = k + 1; i2 < n; ++i2) {
                            for (int i3 = i2 + 1; i3 < n; ++i3) {
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append(arrayList.get(i)).append("*");
                                stringBuffer.append(arrayList.get(j)).append("*");
                                stringBuffer.append(arrayList.get(k)).append("*");
                                stringBuffer.append(arrayList.get(i2)).append("*");
                                stringBuffer.append(arrayList.get(i3));
                                arrayList2.add(stringBuffer.toString());
                            }
                        }
                    }
                }
            }
        }
        stringArray = new String[arrayList2.size()];
        arrayList2.toArray(stringArray);
        return stringArray;
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.setupSpecifyModelEffectsPanel();
    }

    @Override
    protected void aboutToShowTab() {
        mFactorsVarList.setShowVarLabels(false, false);
        this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        ModelTab.loadValuesInModel();
        ModelTab.ensureConsistent();
        Component component = this.mGLM ? ((GeneralizedLinearModelsDlg)((Object)this.getTopLevelAncestor())).getGlassPane() : ((GeneralizedEstimatingEquationsDlg)((Object)this.getTopLevelAncestor())).getGlassPane();
        if (component instanceof DragPane) {
            DragPane dragPane = (DragPane)component;
            dragPane.getDropListeners().removeAllElements();
            this.addDragAdapters(dragPane, mTermsVarList);
            dragPane.addDropListener((IDropListener)new TermsListDropListener(mTermsVarList, this.mArrowButton));
            dragPane.addDropListener((IDropListener)new RemoveModelsDropListener(mFactorsVarList));
            this.addTermsTextFieldDropListener((DragPane)component, this.mTermTextField);
        }
        this.mIncludeModelCheck.setEnabled(this.isIncludeModeCheckEnabled());
        this.setFocusTraversalPolicy();
    }

    private boolean isIncludeModeCheckEnabled() {
        boolean bl = true;
        if (this.mGLM && ((GeneralizedLinearModelsDlg)this.mParent).mTypeOfModelTab != null) {
            bl = !((GeneralizedLinearModelsDlg)this.mParent).mTypeOfModelTab.isMultinomialSelected() && !((GeneralizedLinearModelsDlg)this.mParent).mTypeOfModelTab.isOrdinalLogisticSelected() && !((GeneralizedLinearModelsDlg)this.mParent).mTypeOfModelTab.isOrdinalProbitSelected();
        } else if (!this.mGLM && ((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab != null) {
            bl = !((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab.isMultinomialSelected() && !((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab.isOrdinalLogisticSelected() && !((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab.isOrdinalProbitSelected();
        }
        return bl;
    }

    public IDropListener getIDropListener() {
        return this.listener;
    }

    @Override
    protected void validateSerializableLists() {
        ModelTab.loadValuesInModel();
        ModelTab.ensureConsistent();
    }

    protected String getTermsListLabel() {
        return this.getResString("IDS_MODEL_TERMS");
    }

    protected String getFactorListLabel() {
        return this.getResString("IDS_MODEL_FACTORS");
    }

    protected String getBuildTermLabel() {
        return this.getResString("IDS_MODEL_BUILD");
    }

    private void addDragAdapters(DragPane dragPane, Component component) {
        block11: {
            block10: {
                int n;
                if (!(component instanceof JList)) break block10;
                JList jList = (JList)component;
                MouseListener[] mouseListenerArray = jList.getMouseListeners();
                MouseMotionListener[] mouseMotionListenerArray = jList.getMouseMotionListeners();
                ComponentDragAdapter componentDragAdapter = null;
                if (jList instanceof VariableList) {
                    componentDragAdapter = new ListDragAdapter(jList, dragPane, "VariableList");
                } else if (jList instanceof ModelTermsList) {
                    componentDragAdapter = new TermsListDragAdapter((ModelTermsList)jList, dragPane, "TermsList");
                }
                int n2 = -1;
                for (n = 0; n < mouseListenerArray.length; ++n) {
                    jList.removeMouseListener(mouseListenerArray[n]);
                    if (!mouseListenerArray[n].getClass().getSimpleName().equals("ListDragGestureRecognizer")) continue;
                    n2 = n;
                }
                for (n = 0; n < mouseListenerArray.length; ++n) {
                    if (n == n2) {
                        jList.addMouseListener((MouseListener)componentDragAdapter);
                        continue;
                    }
                    if (mouseListenerArray[n] instanceof ListDragAdapter) continue;
                    jList.addMouseListener(mouseListenerArray[n]);
                }
                n2 = -1;
                for (n = 0; n < mouseMotionListenerArray.length; ++n) {
                    jList.removeMouseMotionListener(mouseMotionListenerArray[n]);
                    if (!mouseMotionListenerArray[n].getClass().getSimpleName().equals("ListDragGestureRecognizer")) continue;
                    n2 = n;
                }
                for (n = 0; n < mouseMotionListenerArray.length; ++n) {
                    if (n == n2) {
                        jList.addMouseMotionListener((MouseMotionListener)componentDragAdapter);
                        continue;
                    }
                    if (mouseMotionListenerArray[n] instanceof ListDragAdapter) continue;
                    jList.addMouseMotionListener(mouseMotionListenerArray[n]);
                }
                break block11;
            }
            if (!(component instanceof Container)) break block11;
            Container container = (Container)component;
            for (Component component2 : container.getComponents()) {
                this.addDragAdapters(dragPane, component2);
            }
        }
    }

    private void setFocusTraversalPolicy() {
        this.mTabOrder = new Vector();
        this.mTabOrder.add(mFactorsVarList);
        this.mTabOrder.add(this.mBuildTermCombo);
        this.mTabOrder.add(this.mArrowButton);
        this.mTabOrder.add(mTermsVarList);
        this.mTabOrder.add(this.mListArrowButtonFactory.getUpArrowButton());
        this.mTabOrder.add(this.mListArrowButtonFactory.getDownArrowButton());
        this.mTabOrder.add(this.mNestedTermArrow);
        this.mTabOrder.add(this.mTermTextField);
        this.mTabOrder.add(this.mByButton);
        this.mTabOrder.add(this.mWithinButton);
        this.mTabOrder.add(this.mAddModelButton);
        this.mTabOrder.add(this.mClearButton);
        this.mTabOrder.add(this.mIncludeModelCheck);
        this.setComponentOrder(this.mTabOrder);
    }

    private void initVars() {
        this.mFactorTermPanel = new JPanel();
        this.mFactorTermPanel.setLayout(new GridBagLayout());
        this.mFactorsLbl = DialogUtil.createLabel(this.mParent, "IDS_MODEL_FACTORS");
        mFactorsVarList = new TargetVariableList();
        mFactorsVarList.setLoadFromPersistent(false);
        mFactorsVarList.setDragEnabled(true);
        mFactorsVarList.setShowVarLabels(false, false);
        Dimension dimension = new Dimension(DialogUtil.getVarListWidth(), DialogUtil.getVarListHeight());
        mFactorsVarList.setMinimumSize(dimension);
        mFactorsVarList.addListSelectionListener(this);
        this.mArrowButton = new ComponentsArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.setAlignmentX(0.5f);
        this.mBuildTermItems = new String[]{this.getResString("IDS_MODEL_MAIN_EFFECTS"), this.getResString("IDS_MODEL_INTERACTION"), this.getResString("IDS_MODEL_FACTORIAL"), this.getResString("IDS_MODEL_2_WAY"), this.getResString("IDS_MODEL_3_WAY"), this.getResString("IDS_MODEL_4_WAY"), this.getResString("IDS_MODEL_5_WAY")};
        this.mBuildTermCombo = new JComboBox<String>(this.mBuildTermItems);
        ComboboxAction comboboxAction = new ComboboxAction(this.mParent, BUILD_TERMS_COMBO_KEY);
        this.mBuildTermCombo.setAction(comboboxAction);
        this.mBuildTermCombo.setMaximumRowCount(6);
        this.mTermsLbl = DialogUtil.createLabel(this.mParent, "IDS_MODEL_TERMS");
        mTermsVarList = new ModelTermsList(MODEL_TERMS_KEY);
        mTermsVarList.setModel(new DefaultListModel());
        mTermsVarList.getModel().addListDataListener(this);
        mTermsVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), mTermsVarList.getFixedCellHeight() * 17 + 2));
        mTermsVarList.addFocusListener(this);
        this.mTermsLbl.setLabelFor(mTermsVarList);
        this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerComponents(mFactorsVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerComponents(mTermsVarList, SpssArrowButton.ButtonOrientation.left);
        this.mArrowButton.addActionListener(this);
        ControlAction controlAction = new ToggleButtonAction(this.mParent, COMMON_MODEL_INCLUDE_MODEL);
        this.mIncludeModelCheck = new JCheckBox(controlAction);
        controlAction = new TextFieldAction(this.mParent, COMMON_MODEL_TERM);
        this.mTermTextField = new StringTextField();
        this.mTermTextField.setAction(controlAction);
        this.mTermTextField.addFocusListener(this);
        this.mTermTextField.setFocusable(true);
        this.mListArrowButtonFactory = new ListTravArrowButtonFactory(mTermsVarList, false);
        this.mUpDownArrowButton = this.mListArrowButtonFactory.getArrowButtonPanel();
        this.mNestedTermArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.down);
        this.mNestedTermArrow.addActionListener(this);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_MODEL_BY_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelTab.this.mTermTextField.setText(ModelTab.this.getInteractionAddedText(ModelTab.this.mTermTextField.getText(), "*"));
                ModelTab.this.setOnlyFunctionsEnabled(false);
                ModelTab.this.mNestedTermArrow.setEnabled(true);
            }
        };
        ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_MODEL_WITHIN_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelTab.this.mTermTextField.setText(ModelTab.this.getInteractionAddedText(ModelTab.this.mTermTextField.getText(), "()"));
                ModelTab.this.setOnlyFunctionsEnabled(false);
                ModelTab.this.mNestedTermArrow.setEnabled(true);
                ModelTab.this.mFlag = true;
            }
        };
        ToggleButtonAction toggleButtonAction3 = new ToggleButtonAction(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_MODEL_ADDTOMODEL_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = ModelTab.this.mTermTextField.getText().trim();
                if (string.length() > 0) {
                    DefaultListModel defaultListModel = (DefaultListModel)mTermsVarList.getModel();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(string);
                    ModelTab.this.filterUniqueItems(arrayList, defaultListModel);
                    if (arrayList.size() == 0) {
                        SpssAlertOptionPane.showWarningMessageDialog((Window)ModelTab.this.mParent, ModelTab.this.getResString("ERR_MODEL_DUPLICATE_MSG1"), VersionInfo.getAppVersionString());
                        return;
                    }
                    defaultListModel.addElement(string);
                    ModelTab.this.mTermTextField.setText("");
                    ModelTab.this.mAddedElements.clear();
                    ModelTab.this.setAllButtonsEnabled(false);
                    ModelTab.this.mNestedTermArrow.setEnabled(true);
                    mTermsVarList.setSelectedIndex(defaultListModel.getSize() - 1);
                    mTermsVarList.requestFocusInWindow();
                }
            }
        };
        ToggleButtonAction toggleButtonAction4 = new ToggleButtonAction(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_MODEL_CLEAR_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelTab.this.mTermTextField.setText("");
                ModelTab.this.mAddedElements.clear();
                ModelTab.this.setAllButtonsEnabled(false);
                ModelTab.this.mNestedTermArrow.setEnabled(true);
                ModelTab.this.mFlag = false;
            }
        };
        this.mByButton = new JButton(toggleButtonAction);
        this.mWithinButton = new JButton(toggleButtonAction2);
        this.mAddModelButton = new JButton(toggleButtonAction3);
        this.mClearButton = new JButton(toggleButtonAction4);
        this.mAddedElements = new ArrayList();
    }

    private void setNestedArrowButtonEnable() {
        String string = this.mTermTextField.getText().trim();
        if (string.length() == 0) {
            this.mNestedTermArrow.setEnabled(true);
        } else if (string.endsWith(")") || string.endsWith("*")) {
            this.mNestedTermArrow.setEnabled(true);
        } else {
            this.mNestedTermArrow.setEnabled(false);
        }
        if (this.mFlag) {
            boolean bl = ModelTab.checkTermText(string);
            this.mNestedTermArrow.setEnabled(bl);
        }
    }

    private static boolean checkTermText(String string) {
        int n = string.length();
        if (n == 0 || string.charAt(n - 1) == '*') {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != ')' || string.charAt(i - 1) != '(' && string.charAt(i - 1) != '*') continue;
            return true;
        }
        return false;
    }

    private void setupSpecifyModelEffectsPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        int n = 21;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mFactorTermPanel, this.mFactorsLbl, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets = new Insets(0, 0, 0, 0);
        JScrollPane jScrollPane = new JScrollPane(mFactorsVarList);
        jScrollPane.setPreferredSize(mFactorsVarList.getMinimumSize());
        mFactorsVarList.addFocusListener(this);
        this.mFactorsLbl.setLabelFor(mFactorsVarList);
        SpssBaseTitleBorder spssBaseTitleBorder = new SpssBaseTitleBorder((LayoutManager)new GridBagLayout());
        spssBaseTitleBorder.setBorder(BorderFactory.createTitledBorder(this.getBuildTermLabel()));
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(this.mFactorTermPanel, (JComponent)spssBaseTitleBorder, gridBagConstraints, 1, 0, 1, 2, n, new Insets(0, n2, 0, n2));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_MODEL_TYPE");
        jLabel.setLabelFor(this.mBuildTermCombo);
        DialogUtil.addUsingGBL((Container)spssBaseTitleBorder, jLabel, gridBagConstraints2, 0, 0, 1, 1, n, new Insets(0, 5, 0, 5));
        DialogUtil.addUsingGBL((Container)spssBaseTitleBorder, this.mBuildTermCombo, gridBagConstraints2, 0, 1, 1, 1, n, new Insets(5, 5, 0, 5));
        DialogUtil.addUsingGBL((Container)spssBaseTitleBorder, this.mArrowButton, gridBagConstraints2, 0, 2, 1, 1, 10, new Insets(10, 0, 5, 5));
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mFactorTermPanel, this.mTermsLbl, gridBagConstraints, 2, 0, 1, 1, n, insets);
        JScrollPane jScrollPane2 = new JScrollPane(mTermsVarList);
        jScrollPane2.setPreferredSize(new Dimension(2 * ModelTab.mFactorsVarList.getMinimumSize().width, ModelTab.mFactorsVarList.getMinimumSize().height));
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        insets = new Insets(0, n2, 0, 0);
        DialogUtil.addUsingGBL(this.mFactorTermPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mFactorTermPanel, jScrollPane2, gridBagConstraints, 2, 1, 1, 2, n, null);
        gridBagConstraints.weighty = 0.0;
        n = 23;
        gridBagConstraints.fill = 0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        insets = new Insets(insets2.top, 3 * insets2.left, 0, insets2.right);
        DialogUtil.addUsingGBL(this.mFactorTermPanel, this.mNestedTermArrow, gridBagConstraints, 0, 2, 1, 1, n, insets);
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel2 = new JLabel(this.getResString("IDS_COMPLEX_SAMPLES_COMMON_MODEL_NUMBER_EFFECTS_MODEL_LABEL"));
        this.lblCount = new JLabel();
        gridBagConstraints.weighty = 0.0;
        n = 21;
        insets = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets = new Insets(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.lblCount, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mFactorTermPanel, jPanel, gridBagConstraints, 2, 3, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets = new Insets(n2, 2 * n2, 0, n2);
        DialogUtil.addUsingGBL(this, this.mFactorTermPanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets = new Insets(n2, 0, n2, n2);
        n = 23;
        DialogUtil.addUsingGBL(this.mFactorTermPanel, this.mUpDownArrowButton, gridBagConstraints, 3, 1, 1, 1, n, insets);
        JPanel jPanel2 = this.setupNestedTermPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        insets = new Insets(0, n2, n2, n2);
        DialogUtil.addUsingGBL(this.mFactorTermPanel, jPanel2, gridBagConstraints, 0, 4, 4, 1, n, insets);
        this.mFactorTermPanel.setBorder(new TitledBorder(this.getResString("IDS_COMPLEX_SAMPLES_COMMON_MODEL_SPECIFY_LABEL")));
        insets = new Insets(0, 4 * n2, n2, n2);
        DialogUtil.addUsingGBL(this, this.mIncludeModelCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        this.setDefaults();
    }

    private void setDefaults() {
        this.mByButton.setEnabled(false);
        this.mWithinButton.setEnabled(false);
        this.mAddModelButton.setEnabled(false);
        this.mClearButton.setEnabled(false);
        this.mTermTextField.setEditable(false);
        this.mTermTextField.setOpaque(false);
        this.mTermTextField.setFocusable(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ModelTab.this.mNestedTermArrow.setEnabled(false);
            }
        });
        this.mTermLabel.setEnabled(true);
        this.mIncludeModelCheck.setSelected(true);
        this.mFlag = false;
        this.mBuildTermCombo.setSelectedIndex(0);
        if (mFactorsVarList.getModel().getSize() > 0) {
            mFactorsVarList.setSelectedIndex(0);
        } else {
            this.mArrowButton.setEnabled(false);
        }
        this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.updateCountLabel();
        this.mAddedElements.clear();
    }

    private JPanel setupNestedTermPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(new TitledBorder(this.getResString("IDS_COMPLEX_SAMPLES_COMMON_MODEL_BUILD_NESTED_LABEL")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        int n2 = 23;
        Insets insets = new Insets(0, n, 0, n);
        gridBagConstraints.fill = 0;
        this.mTermLabel = DialogUtil.createLabel(this.mParent, "IDS_COMPLEX_SAMPLES_COMMON_MODEL_BUILD_TERM_LABEL");
        DialogUtil.addUsingGBL(jPanel, this.mTermLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        this.mTermLabel.setLabelFor((Component)((Object)this.mTermTextField));
        gridBagConstraints.weightx = 1.0;
        n2 = 23;
        insets = new Insets(n, n, 0, n);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mTermTextField), gridBagConstraints, 0, 1, 5, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets = new Insets(n, n, n, n);
        DialogUtil.addUsingGBL(jPanel, this.mByButton, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mWithinButton, gridBagConstraints, 1, 2, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mAddModelButton, gridBagConstraints, 3, 2, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel, this.mClearButton, gridBagConstraints, 4, 2, 1, 1, n2, insets);
        UIToolDialogUtil.normalizeButtonWidths((JPanel)jPanel);
        return jPanel;
    }

    private void updateCountLabel() {
        this.lblCount.setText("" + mTermsVarList.getModel().getSize());
    }

    private String getInteractionAddedText(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = stringBuffer.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (c == '(' || c == ')' || c == '*') continue;
            stringBuffer.insert(i + 1, string2);
            break;
        }
        return stringBuffer.toString();
    }

    private void setAllButtonsEnabled(boolean bl) {
        this.mByButton.setEnabled(bl);
        this.mWithinButton.setEnabled(bl);
        this.mAddModelButton.setEnabled(bl);
        this.mClearButton.setEnabled(bl);
    }

    private static Set<String> parseTermString(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "*()");
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken());
        }
        return hashSet;
    }

    private boolean isPresentInFactorsList(ISpssVariable iSpssVariable) {
        for (int i = 0; i < mFactorsModel.getSize(); ++i) {
            ISpssVariable iSpssVariable2 = mFactorsModel.getElementAt(i);
            if (iSpssVariable2.getName() != iSpssVariable.getName() || iSpssVariable2.getLabel() != iSpssVariable.getLabel()) continue;
            return true;
        }
        return false;
    }

    private boolean isPresentInCovariatesList(ISpssVariable iSpssVariable) {
        for (int i = 0; i < mCovModel.getSize(); ++i) {
            ISpssVariable iSpssVariable2 = mCovModel.getElementAt(i);
            if (iSpssVariable2.getName() != iSpssVariable.getName() || iSpssVariable2.getLabel() != iSpssVariable.getLabel()) continue;
            return true;
        }
        return false;
    }

    private String getElementNameAddedText(String string, String string2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string.lastIndexOf("(");
        int n2 = string.lastIndexOf("*");
        if (n2 > n) {
            if (bl && !string.endsWith("*")) {
                this.mErrorFlag = true;
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_COMPLEX_SAMPLES_COMMON_MODEL_NO_NESTING_COVAR_MSG"), VersionInfo.getAppVersionString());
                return stringBuffer.toString();
            }
            stringBuffer.insert(n2 + 1, string2);
        } else if (n2 < n) {
            if (bl) {
                this.mErrorFlag = true;
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_COMPLEX_SAMPLES_COMMON_MODEL_NO_NESTING_COVAR_MSG"), VersionInfo.getAppVersionString());
                return stringBuffer.toString();
            }
            stringBuffer.insert(n + 1, string2);
        }
        return stringBuffer.toString();
    }

    private void setOnlyFunctionsEnabled(boolean bl) {
        this.mByButton.setEnabled(bl);
        this.mWithinButton.setEnabled(bl);
        this.mAddModelButton.setEnabled(bl);
    }

    private void addTermsTextFieldDropListener(DragPane dragPane, StringTextField stringTextField) {
        dragPane.addDropListener((IDropListener)new TermsTextFieldDropListener((JTextField)((Object)stringTextField)));
    }

    class TermsTextFieldDropListener
    extends AbstractDropListener {
        public TermsTextFieldDropListener(JTextField jTextField) {
            super(jTextField);
        }

        @Override
        public Cursor dragItemOver(Point point, DragDropAdapter dragDropAdapter) {
            boolean bl;
            Cursor cursor = null;
            Point point2 = (Point)point.clone();
            SwingUtilities.convertPointFromScreen(point2, this.mDropTarget);
            boolean bl2 = bl = this.canDrop(dragDropAdapter) && this.contains(point);
            if (bl) {
                JTextField jTextField = (JTextField)this.mDropTarget;
                jTextField.setCaretPosition(jTextField.viewToModel(point2));
                jTextField.getCaret().setVisible(true);
                cursor = Cursor.getPredefinedCursor(0);
            } else {
                ((JTextField)this.mDropTarget).getCaret().setVisible(false);
                cursor = DragPane.getNoDropCursor();
            }
            return cursor;
        }

        @Override
        public boolean canDrop(DragDropAdapter dragDropAdapter) {
            VariableList.TransferData transferData;
            ISpssVariable[] iSpssVariableArray;
            boolean bl = false;
            if (!this.mDropTarget.isEnabled() || !this.mDropTarget.isShowing()) {
                return bl;
            }
            Object object = dragDropAdapter.getTransferData();
            if (object instanceof VariableList.TransferData && (iSpssVariableArray = (transferData = (VariableList.TransferData)object).getVariables()) != null && iSpssVariableArray.length > 0 && this.mDropTarget instanceof JTextField) {
                return iSpssVariableArray.length <= 1;
            }
            return bl;
        }

        @Override
        public void itemDropped(DropEvent dropEvent) {
            Component component = dropEvent.getSource();
            if (this.mLastPosition != null) {
                this.mLastPosition = null;
                if (this.mTimer != null) {
                    this.mTimer.stop();
                }
            }
            boolean bl = this.contains(dropEvent.getDropLocation()) && this.canDrop(dropEvent.getDragSourceAdapter());
            Point point = (Point)dropEvent.getDropLocation().clone();
            SwingUtilities.convertPointFromScreen(point, this.mDropTarget);
            if (bl && this.mDropTarget != null && component instanceof VariableList) {
                VariableList variableList = (VariableList)component;
                Object object = dropEvent.getTransferData();
                if (object == null || !(object instanceof VariableList.TransferData)) {
                    return;
                }
                VariableList.TransferData transferData = (VariableList.TransferData)object;
                ISpssVariable[] iSpssVariableArray = transferData.getVariables();
                JTextField jTextField = (JTextField)this.mDropTarget;
                int n = jTextField.viewToModel(point);
                this.importData(iSpssVariableArray, variableList, n);
            }
        }

        @Override
        protected void importData(Object object, JComponent jComponent, int n) {
            final JTextField jTextField = (JTextField)this.mDropTarget;
            if (object instanceof ISpssVariable[] && ((ISpssVariable[])object).length == 1 && jComponent instanceof VariableList) {
                ISpssVariable iSpssVariable = ((ISpssVariable[])object)[0];
                String string = iSpssVariable.getName();
                if (ModelTab.this.mNestedTermArrow.isEnabled()) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(string);
                    arrayList.removeAll(ModelTab.this.mAddedElements);
                    if (ModelTab.this.isPresentInFactorsList(iSpssVariable) && arrayList.size() == 0) {
                        SpssAlertOptionPane.showWarningMessageDialog((Window)ModelTab.this.mParent, ModelTab.this.getResString("ERR_COMPLEX_SAMPLES_COMMON_MODEL_FACTOR_UNIQUE_MSG"), VersionInfo.getAppVersionString());
                        return;
                    }
                    if (ModelTab.this.mTermTextField.getText().trim().length() == 0) {
                        ModelTab.this.mTermTextField.setText(string);
                    } else {
                        ModelTab.this.mTermTextField.setText(ModelTab.this.getElementNameAddedText(ModelTab.this.mTermTextField.getText(), string, ModelTab.this.isPresentInCovariatesList(iSpssVariable)));
                    }
                    if (!ModelTab.this.mErrorFlag) {
                        ModelTab.this.setAllButtonsEnabled(true);
                        ModelTab.this.mNestedTermArrow.setEnabled(false);
                    }
                    ModelTab.this.mAddedElements.add(string);
                    ModelTab.this.mIsSetText = true;
                } else if (!ModelTab.this.mTermTextField.getText().endsWith("*") && !ModelTab.this.mTermTextField.getText().endsWith("()")) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)ModelTab.this.mParent, ModelTab.this.getResString("ERR_GLM_MODEL_VAR_CAN_NOT_BE_ADDED_WITHOUT_OPERATOR_MSG"), VersionInfo.getAppVersionString());
                    return;
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    jTextField.requestFocus();
                }
            });
        }

        @Override
        protected void showDropFeedback(Point point) {
        }

        @Override
        protected void setHighlightBorder(boolean bl) {
        }

        @Override
        protected void finish(JComponent jComponent, int n, int[] nArray, int n2) {
        }
    }

    private class RemoveModelsDropListener
    extends VarListDropListener {
        public RemoveModelsDropListener(VariableList variableList) {
            super(variableList);
            this.mDropTarget = variableList;
        }

        @Override
        public void itemDropped(DropEvent dropEvent) {
            if (dropEvent.getSource() instanceof ModelTermsList && !this.overSourceList(dropEvent.getDropLocation())) {
                ModelTab.this.removeSelectedModelItems();
            }
        }

        private boolean overSourceList(Point point) {
            Container container;
            for (container = this.mDropTarget.getParent(); container != null && !(container instanceof JDialog); container = container.getParent()) {
            }
            if (container != null) {
                Point point2 = (Point)point.clone();
                SwingUtilities.convertPointFromScreen(point2, container);
                Component component = container.findComponentAt(point2);
                return component instanceof ModelTermsList;
            }
            return false;
        }

        @Override
        public Cursor dragItemOver(Point point, DragDropAdapter dragDropAdapter) {
            Cursor cursor = null;
            Point point2 = (Point)point.clone();
            SwingUtilities.convertPointFromScreen(point2, this.mDropTarget);
            boolean bl = true;
            bl = this.overSourceList(point);
            cursor = Cursor.getPredefinedCursor(12);
            this.mDropTarget.getFocusHighlighter().setHighlightBorder(bl);
            if (this.mCanImport) {
                this.checkAutoScroll(point2);
            }
            return cursor;
        }
    }
}

