/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListFilterUtil;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.ListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.VarListDropListener;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.GeneralizedLinearModelsDlg;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.DropEvent;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class GZLMVarListDropListener
extends VarListDropListener {
    private VariableList mDropTarget = null;
    private Timer mTimer = null;
    private Point mLastPosition = null;
    private IVarMoveHandler mVarMoveHandler;
    private GeneralizedLinearModelsDlg mParent;

    public GZLMVarListDropListener(VariableList variableList) {
        super(variableList);
        this.mDropTarget = variableList;
    }

    public GZLMVarListDropListener(VariableList variableList, IVarMoveHandler iVarMoveHandler, GeneralizedLinearModelsDlg generalizedLinearModelsDlg) {
        super(variableList, iVarMoveHandler);
        this.mDropTarget = variableList;
        this.mVarMoveHandler = iVarMoveHandler;
        this.mParent = generalizedLinearModelsDlg;
    }

    public static void addDragAdapters(DragPane dragPane, Component component, IVarMoveHandler iVarMoveHandler, GeneralizedLinearModelsDlg generalizedLinearModelsDlg) {
        if (component instanceof VariableList) {
            VariableList variableList = (VariableList)component;
            ListDragAdapter listDragAdapter = new ListDragAdapter(variableList, dragPane, "VariableList");
            DialogUtil.modifyMouseInputListeners(variableList, listDragAdapter);
            dragPane.addDropListener((IDropListener)new GZLMVarListDropListener(variableList, iVarMoveHandler, generalizedLinearModelsDlg));
        } else if (component instanceof Container) {
            Container container = (Container)component;
            for (Component component2 : container.getComponents()) {
                GZLMVarListDropListener.addDragAdapters(dragPane, component2, iVarMoveHandler, generalizedLinearModelsDlg);
            }
        }
    }

    @Override
    public void itemDropped(DropEvent dropEvent) {
        boolean bl;
        Component component = dropEvent.getSource();
        if (this.mLastPosition != null) {
            this.mLastPosition = null;
            if (this.mTimer != null) {
                this.mTimer.stop();
            }
        }
        this.mDropTarget.getFocusHighlighter().setHighlightBorder(false);
        boolean bl2 = bl = this.contains(dropEvent.getDropLocation()) && this.canDrop(dropEvent.getDragSourceAdapter());
        if (bl && this.mDropTarget != null && component instanceof VariableList) {
            VariableList variableList = (VariableList)component;
            Object object = dropEvent.getTransferData();
            if (object == null) {
                return;
            }
            if (!(object instanceof VariableList.TransferData)) {
                assert (false);
                return;
            }
            VariableList.TransferData transferData = (VariableList.TransferData)object;
            ISpssVariable[] iSpssVariableArray = transferData.getVariables();
            if (this.mVarMoveHandler != null && !this.mVarMoveHandler.preMoveVariables(iSpssVariableArray, this.mDropTarget)) {
                return;
            }
            int[] nArray = transferData.getSelectedIndices();
            VarListModel varListModel = this.mDropTarget.getModel();
            Point point = (Point)dropEvent.getDropLocation().clone();
            SwingUtilities.convertPointFromScreen(point, this.mDropTarget);
            int n = this.mDropTarget.locationToIndex(point);
            if (this.dropOnSource(variableList, n, nArray, point)) {
                return;
            }
            int n2 = varListModel.getSize();
            if (n < 0) {
                n = n2;
            } else {
                if (!this.mDropTarget.itemInUpperHalf(point)) {
                    ++n;
                }
                if (n > n2) {
                    n = n2;
                }
            }
            if (!this.showFilterError(this.mDropTarget, iSpssVariableArray, (Window)((Object)this.mParent))) {
                return;
            }
            if (this.mDropTarget instanceof TargetVariableList && !((TargetVariableList)this.mDropTarget).isDataSource() && this.mDropTarget.mMaxLimitOfList != -1 && iSpssVariableArray.length + this.mDropTarget.getModel().getSize() > this.mDropTarget.mMaxLimitOfList) {
                String string = String.format(ComponentState.getSPSSLocale(), ResUtil.getCommonDlgString("ERR_LIST_MAX_LIMIT_EXCEEDED_WARNING"), this.mDropTarget.mMaxLimitOfList);
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mParent), string, VersionInfo.getAppVersionString());
                final VariableList variableList2 = variableList;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        variableList2.requestFocus();
                    }
                });
                return;
            }
            this.importData(iSpssVariableArray, variableList, n);
            if (!this.mSwapFlag) {
                this.finish(variableList, iSpssVariableArray.length, nArray, n);
            }
            this.mSwapFlag = false;
        }
    }

    private boolean showFilterError(VariableList variableList, ISpssVariable[] iSpssVariableArray, Window window) {
        String string = VarListFilterUtil.getVarListFilterErrorMessage(variableList, iSpssVariableArray);
        if (string != null) {
            SpssAlertOptionPane.showInformationMessageDialog(window, string, VersionInfo.getAppVersionString());
            return false;
        }
        return true;
    }

    private boolean dropOnSource(VariableList variableList, int n, int[] nArray, Point point) {
        boolean bl;
        boolean bl2 = bl = variableList == this.mDropTarget && nArray != null;
        if (bl) {
            boolean bl3;
            boolean bl4 = bl3 = n >= nArray[0] && n <= nArray[nArray.length - 1];
            if (!bl3) {
                boolean bl5 = this.mDropTarget.itemInUpperHalf(point);
                if (n == nArray[0] - 1) {
                    bl3 = !bl5;
                } else if (n == nArray[nArray.length - 1] + 1) {
                    bl3 = bl5;
                }
            }
            if (bl3) {
                return true;
            }
        }
        return false;
    }
}

