/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.documents.data.DatasetNameValidator;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.GeneralizedLinearModelsDlg;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.generalized_estm_eqn.GeneralizedEstimatingEquationsDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

public class ExportTab
extends BaseProcedureTab
implements ItemListener,
ActionListener,
FocusListener {
    static final String EXPORT_MODEL_AS_DATA_KEY = "IDS_GLM_EXPORT_TAB_EXPORT_MODEL_AS_DATA_CHECK";
    static final String EXPORT_MODEL_AS_XML_KEY = "IDS_GLM_EXPORT_TAB_EXPORT_MODEL_AS_XML_CHECK";
    static final String DATASET_RADIO_KEY = "IDS_GLM_EXPORT_DATASET_RADIO";
    static final String DATA_FILE_RADIO_KEY = "IDS_GLM_EXPORT_DATA_FILE_RADIO";
    static final String DATA_COVARIANCE_RADIO_KEY = "IDS_GLM_EXPORT_DATA_COVARIANCE_MATRIX_RADIO";
    static final String DATA_CORRELATION_RADIO_KEY = "IDS_GLM_EXPORT_DATA_CORRELATION_MATRIX_RADIO";
    static final String XML_COVARIANCE_RADIO_KEY = "IDS_GLM_EXPORT_XML_COVARIANCE_MATRIX_RADIO";
    static final String XML_ESTIMATES_RADIO_KEY = "IDS_GLM_EXPORT_XML_ESTIMATES_ONLY_RADIO";
    static final String DATA_FILE_BUTTON_KEY = "IDS_GLM_EXPORT_DATA_FILE_BUTTON";
    static final String XML_FILE_BUTTON_KEY = "IDS_GLM_EXPORT_EXPORT_AS_XML_FILE_BUTTON";
    static final String DATASET_NAME_TEXTFIELD_KEY = "IDS_GLM_EXPORT_DATASET_NAME_TEXTFIELD_KEY";
    private JCheckBox mExportModelAsDataCheck;
    private JCheckBox mExportModelAsXMLCheck;
    private JRadioButton mDatasetRadio;
    private JRadioButton mDataFileRadio;
    private JRadioButton mDataCovarianceRadio;
    private JRadioButton mDataCorrelationRadio;
    private JRadioButton mXMLCovarianceRadio;
    private JRadioButton mXMLEstimatesRadio;
    private JButton mDataFileButton;
    private JButton mXMLFileButton;
    private StringTextField mDataSetName;
    private FileTextField mDataFilePath;
    private FileTextField mXMLFilePath;
    private JLabel mDatasetNameLabel;
    private TitledBorder mDestinationPanelBorder;
    private TitledBorder mExportDataPanelBorder;
    private TitledBorder mExportXMLPanelBorder;
    private SpssButtonGroup mDataRadioGrp;
    private SpssButtonGroup mDestinationRadioGrp;
    private SpssButtonGroup mXMLRadioGrp;
    private boolean mGLMTab;
    private String mPerAttributesSyntax;

    public ExportTab(BaseTabbedDialog baseTabbedDialog, boolean bl) {
        super(baseTabbedDialog, true);
        this.mGLMTab = bl;
        this.initialize();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mDataSetName) {
            this.mDataSetName.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mExportModelAsDataCheck) {
            this.enableExportModelAsDataGroup(this.mExportModelAsDataCheck.isSelected());
        }
        if (itemEvent.getSource() == this.mExportModelAsXMLCheck) {
            this.enableExportModelAsXMLGroup(this.mExportModelAsXMLCheck.isSelected());
        }
        if (itemEvent.getSource() == this.mDatasetRadio) {
            this.mDatasetNameLabel.setEnabled(this.mDatasetRadio.isSelected());
            this.mDataSetName.setEnabled(this.mDatasetRadio.isSelected());
            this.mDataSetName.setOpaque(this.mDatasetRadio.isSelected());
        }
        if (itemEvent.getSource() == this.mDataFileRadio) {
            this.mDataFileButton.setEnabled(this.mDataFileRadio.isSelected());
            this.mDataFilePath.setEnabled(this.mDataFileRadio.isSelected());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mDataFileButton) {
            this.showSaveDialog(0);
        }
        if (actionEvent.getSource() == this.mXMLFileButton) {
            this.showSaveDialog(1);
        }
    }

    @Override
    public String getDialogHelpID() {
        if (this.mGLMTab) {
            return "idh_idd_genlin_export";
        }
        return "idh_idd_gee_export";
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    public String getNewDatasetName() {
        String string = "";
        if (this.mExportModelAsDataCheck.isSelected() && this.mDatasetRadio.isSelected()) {
            string = this.mDataSetName.getText();
        }
        return string;
    }

    public String getExportTabSyntax() {
        String string;
        String string2 = null;
        String string3 = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.mExportModelAsDataCheck.isSelected()) {
            if (this.mDataCovarianceRadio.isSelected()) {
                stringBuffer.append(" COVB=");
            } else {
                stringBuffer.append(" CORB=");
            }
            if (this.mDatasetRadio.isSelected()) {
                stringBuffer.append(this.mDataSetName.getText());
            } else {
                string2 = this.mDataFilePath.getText();
                stringBuffer.append(CharacterUtil.smartQuote((String)string2));
            }
        }
        if (this.mExportModelAsXMLCheck.isSelected() && (string3 = this.mXMLFilePath.getText()) != null && string3.length() > 0) {
            if (this.mXMLCovarianceRadio.isSelected()) {
                stringBuffer.append(" MODEL=");
            } else {
                stringBuffer.append(" PARAMETER=");
            }
            stringBuffer.append(CharacterUtil.smartQuote((String)string3));
        }
        if (stringBuffer.length() > 0) {
            stringBuffer = stringBuffer.insert(0, SyntaxUtil.getSubCommand("/OUTFILE"));
        }
        this.mPerAttributesSyntax = "";
        PesFile pesFile = PES_Repository.getPesFile(string2);
        if (pesFile != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            this.mPerAttributesSyntax = this.mPerAttributesSyntax + string;
        }
        if ((pesFile = PES_Repository.getPesFile((String)string3)) != null && (string = pesFile.getPerAttributesSyntax()) != null) {
            this.mPerAttributesSyntax = this.mPerAttributesSyntax + string;
        }
        return stringBuffer.toString();
    }

    public String getPerAttributesSyntax() {
        return this.mPerAttributesSyntax;
    }

    @Override
    protected boolean validateTab() {
        String string;
        if (this.mExportModelAsDataCheck.isSelected()) {
            if (this.mDatasetRadio.isSelected()) {
                string = this.mDataSetName.getText();
                if (string.equals("")) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_EXPORT_SPECIFY_DATASET_MSG"), VersionInfo.getAppVersionString());
                    return false;
                }
                int n = DatasetNameValidator.validateDatasetName((String)string, (Component)this);
                if (n == 0) {
                    return false;
                }
            } else {
                string = this.mDataFilePath.getText();
                if (string.equals("")) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_EXPORT_SPECIFY_FILE_MSG"), VersionInfo.getAppVersionString());
                    return false;
                }
            }
        }
        if (this.mExportModelAsXMLCheck.isSelected() && (string = this.mXMLFilePath.getText()).equals("")) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_EXPORT_SPECIFY_FILE_MSG"), VersionInfo.getAppVersionString());
            return false;
        }
        return true;
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        return this.mExportModelAsDataCheck;
    }

    private void initialize() {
        this.initVars();
        JPanel jPanel = new JPanel();
        DialogUtil.applyTopBorder(jPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = UIToolDialogUtil.getStandardDialogInsets();
        Insets insets2 = new Insets(insets.top, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(this, this.mExportModelAsDataCheck, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        insets2.set(n2, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(this, this.setupDestinationPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets2);
        insets2.set(n2, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(this, this.setupExportAsDataPanel(), gridBagConstraints, 0, 2, 1, 1, n, insets2);
        insets2.set(n2, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        insets2.set(0, insets.left, DialogUtil.getStandardControlInsets().bottom, insets.right);
        DialogUtil.addUsingGBL(this, this.mExportModelAsXMLCheck, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        gridBagConstraints.fill = 0;
        insets2.set(0, insets.left + 20, 0, 0);
        DialogUtil.addUsingGBL(this, this.mXMLFileButton, gridBagConstraints, 0, 5, 1, 1, n, insets2);
        gridBagConstraints.fill = 2;
        insets2.set(0, insets.left + 20 + this.mXMLFileButton.getMaximumSize().width + n2, 0, insets.right);
        DialogUtil.addUsingGBL(this, (JComponent)((Object)this.mXMLFilePath), gridBagConstraints, 0, 5, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        insets2.set(n2, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(this, this.setupExportAsXMLPanel(), gridBagConstraints, 0, 6, 1, 1, n, insets2);
        this.setDefaults();
        this.setFocusTraversalPolicy();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mExportModelAsDataCheck);
        vector.add(this.mDestinationRadioGrp);
        vector.add(this.mDataSetName);
        vector.add(this.mDataFileButton);
        vector.add(this.mDataRadioGrp);
        vector.add(this.mExportModelAsXMLCheck);
        vector.add(this.mXMLFileButton);
        vector.add(this.mXMLRadioGrp);
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    @Override
    public void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        if (!RemoteFileChooser.enableSaveInModeler()) {
            String string = dialogDataModel.getString("EXPORT_XML_FILE_PATH");
            if (string != null && string.length() > 0) {
                this.mExportModelAsXMLCheck.setSelected(true);
                this.mXMLFilePath.setText(string);
            } else {
                this.mExportModelAsXMLCheck.setSelected(false);
            }
        }
    }

    private void setDefaults() {
        this.mDatasetRadio.setSelected(true);
        this.mDataCovarianceRadio.setSelected(true);
        this.mXMLCovarianceRadio.setSelected(true);
        this.mDataSetName.setText("");
        this.mDataFilePath.setText("");
        this.mXMLFilePath.setText("");
        this.enableExportModelAsDataGroup(false);
        this.enableExportModelAsXMLGroup(false);
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mExportModelAsDataCheck.setEnabled(false);
            this.mXMLFileButton.setEnabled(false);
            this.mExportModelAsXMLCheck.setSelected(true);
            this.mExportModelAsXMLCheck.setEnabled(false);
            this.enableExportModelAsXMLGroup(true);
            DialogDataModel dialogDataModel = this.getDialogDataModel();
            if (dialogDataModel != null) {
                String string = dialogDataModel.getString("EXPORT_XML_FILE_PATH");
                this.mXMLFilePath.setText(string);
            }
        }
    }

    private DialogDataModel getDialogDataModel() {
        DialogDataModel dialogDataModel = null;
        if (this.mParent instanceof GeneralizedLinearModelsDlg) {
            dialogDataModel = ((GeneralizedLinearModelsDlg)this.mParent).getDialogDataModel();
        }
        if (this.mParent instanceof GeneralizedEstimatingEquationsDlg) {
            dialogDataModel = ((GeneralizedEstimatingEquationsDlg)this.mParent).getDialogDataModel();
        }
        return dialogDataModel;
    }

    private void enableExportModelAsDataGroup(boolean bl) {
        this.mDatasetRadio.setEnabled(bl);
        this.mDataFileRadio.setEnabled(bl);
        this.mDataFileButton.setEnabled(this.mDataFileRadio.isEnabled() && this.mDataFileRadio.isSelected());
        this.mDataFilePath.setEnabled(this.mDataFileButton.isEnabled());
        this.mDataCovarianceRadio.setEnabled(bl);
        this.mDataCorrelationRadio.setEnabled(bl);
        this.mDataSetName.setEnabled(this.mDatasetRadio.isEnabled() && this.mDatasetRadio.isSelected());
        this.mDataSetName.setOpaque(this.mDataSetName.isEnabled());
        this.mDatasetNameLabel.setEnabled(this.mDatasetRadio.isEnabled() && this.mDatasetRadio.isSelected());
        DialogUtil.enableTitledBorder(this.mDestinationPanelBorder, bl);
        DialogUtil.enableTitledBorder(this.mExportDataPanelBorder, bl);
        this.repaint();
    }

    private void enableExportModelAsXMLGroup(boolean bl) {
        this.mXMLFileButton.setEnabled(this.mExportModelAsXMLCheck.isEnabled() && this.mExportModelAsXMLCheck.isSelected());
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mXMLFileButton.setEnabled(false);
        }
        this.mXMLFilePath.setEnabled(this.mXMLFileButton.isEnabled());
        this.mXMLCovarianceRadio.setEnabled(bl);
        this.mXMLEstimatesRadio.setEnabled(bl);
        DialogUtil.enableTitledBorder(this.mExportXMLPanelBorder, bl);
        this.repaint();
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, EXPORT_MODEL_AS_DATA_KEY);
        this.mExportModelAsDataCheck = new JCheckBox(toggleButtonAction);
        this.mExportModelAsDataCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, EXPORT_MODEL_AS_XML_KEY);
        this.mExportModelAsXMLCheck = new JCheckBox(toggleButtonAction);
        this.mExportModelAsXMLCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, DATASET_RADIO_KEY);
        this.mDatasetRadio = new JRadioButton(toggleButtonAction);
        this.mDatasetRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, DATA_FILE_RADIO_KEY);
        this.mDataFileRadio = new JRadioButton(toggleButtonAction);
        this.mDataFileRadio.addItemListener(this);
        this.mDestinationRadioGrp = new SpssButtonGroup();
        this.mDestinationRadioGrp.add(this.mDatasetRadio);
        this.mDestinationRadioGrp.add(this.mDataFileRadio);
        toggleButtonAction = new ToggleButtonAction(this.mParent, DATA_COVARIANCE_RADIO_KEY);
        this.mDataCovarianceRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, DATA_CORRELATION_RADIO_KEY);
        this.mDataCorrelationRadio = new JRadioButton(toggleButtonAction);
        this.mDataRadioGrp = new SpssButtonGroup();
        this.mDataRadioGrp.add(this.mDataCovarianceRadio);
        this.mDataRadioGrp.add(this.mDataCorrelationRadio);
        toggleButtonAction = new ToggleButtonAction(this.mParent, XML_COVARIANCE_RADIO_KEY);
        this.mXMLCovarianceRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, XML_ESTIMATES_RADIO_KEY);
        this.mXMLEstimatesRadio = new JRadioButton(toggleButtonAction);
        this.mXMLRadioGrp = new SpssButtonGroup();
        this.mXMLRadioGrp.add(this.mXMLCovarianceRadio);
        this.mXMLRadioGrp.add(this.mXMLEstimatesRadio);
        this.mDataFileButton = DialogUtil.createButton(this.mParent, DATA_FILE_BUTTON_KEY, this);
        this.mXMLFileButton = DialogUtil.createButton(this.mParent, XML_FILE_BUTTON_KEY, this);
        this.mDataSetName = new StringTextField(8);
        this.mDataSetName.setAction(new TextFieldAction(this.mParent, DATASET_NAME_TEXTFIELD_KEY));
        this.mDataSetName.addFocusListener(this);
        this.mDatasetNameLabel = DialogUtil.createLabel(this.mParent, "IDS_GLM_EXPORT_NAME_LABEL");
        this.mDatasetNameLabel.setLabelFor((Component)((Object)this.mDataSetName));
        this.mDataFilePath = new FileTextField();
        this.mDataFilePath.setEditable(false);
        this.mDataFilePath.setOpaque(false);
        this.mDataFilePath.setBorder(BorderFactory.createEmptyBorder());
        this.mDataFilePath.setAction(new TextFieldAction(this.mParent, "IDS_GLM_EXPORT_DATA_FILE_PATH"));
        this.mXMLFilePath = new FileTextField();
        this.mXMLFilePath.setEditable(false);
        this.mXMLFilePath.setOpaque(false);
        this.mXMLFilePath.setBorder(BorderFactory.createEmptyBorder());
        this.mXMLFilePath.setAction(new TextFieldAction(this.mParent, "EXPORT_XML_FILE_PATH"));
    }

    private JPanel setupDestinationPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        this.mDestinationPanelBorder = new TitledBorder(this.getResString("IDS_GLM_EXPORT_DESTINATION"));
        jPanel.setBorder(this.mDestinationPanelBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mDatasetRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets2 = new Insets(insets.top, insets.left + 20, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mDatasetNameLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.fill = 2;
        insets2.set(insets.top, insets.left + 20 + this.mDatasetNameLabel.getPreferredSize().width + n2, insets.bottom, insets.right + n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mDataSetName), gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mDataFileRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        insets2.set(insets.top, insets.left + 20, n2, insets.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mDataFileButton, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        UIToolDialogUtil.normalizeButtonWidths((JPanel)jPanel);
        gridBagConstraints.fill = 2;
        insets2.set(insets.top, insets.left + 20 + this.mDataFileButton.getMaximumSize().width + n2, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mDataFilePath), gridBagConstraints, 0, 3, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupExportAsDataPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        this.mExportDataPanelBorder = new TitledBorder(this.getResString("IDS_GLM_EXPORT_TAB_EXPORT_AS_DATA"));
        jPanel.setBorder(this.mExportDataPanelBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mDataCovarianceRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mDataCorrelationRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupExportAsXMLPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        this.mExportXMLPanelBorder = new TitledBorder(this.getResString("IDS_GLM_EXPORT_TAB_EXPORT_AS_XML_CHECK"));
        jPanel.setBorder(this.mExportXMLPanelBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mXMLCovarianceRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mXMLEstimatesRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void showSaveDialog(int n) {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), true);
        if (this.mGLMTab) {
            remoteFileChooser.setDialogTitle(this.getResString("IDS_GLM_EXPORT_SAVE_DIALOG_TITLE"));
        } else {
            remoteFileChooser.setDialogTitle(this.getResString("IDS_GEE_EXPORT_SAVE_DIALOG_TITLE"));
        }
        if (n == 0) {
            remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(this.getResString("IDS_GLM_SPSS_DATA_FILE_FILTER"), this.getResString("IDS_GLM_SPSS_DATA_FILE_FILTER_EXTN")));
        } else {
            remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(this.getResString("IDS_GLM_EXPORT_XML_FILE_FILTER"), this.getResString("IDS_GLM_EXPORT_XML_FILE_FILTER_EXTN")));
        }
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        int n2 = remoteFileChooser.showSaveDialog((Component)this.mParent);
        if (n2 == 0) {
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            String string = remoteFileChooser.getSelectedFilePath();
            if (n == 0) {
                if (!string.endsWith(this.getResString("IDS_GLM_SPSS_DATA_FILE_FILTER_EXTN"))) {
                    string = string + this.getResString("IDS_GLM_SPSS_DATA_FILE_FILTER_EXTN");
                }
                this.mDataFilePath.setText(string);
            } else {
                if (!string.endsWith(this.getResString("IDS_GLM_EXPORT_XML_FILE_FILTER_EXTN"))) {
                    string = string + this.getResString("IDS_GLM_EXPORT_XML_FILE_FILTER_EXTN");
                }
                this.mXMLFilePath.setText(string);
            }
        }
    }
}

