/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssMultiLineCheckBox;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.EstimationInitialValues;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.ExponentialDoc;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.GeneralizedLinearModelsDlg;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.generalized_estm_eqn.GeneralizedEstimatingEquationsDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;
import javax.swing.text.Document;

public class EstimationTab
extends BaseProcedureTab
implements ActionListener,
ItemListener,
FocusListener {
    final int MAX_LIKLIHOOD_ESTIMATE = 0;
    final int DEVIANCE = 1;
    final int PEARSON_CHI_SQUARE = 2;
    final int FIXED_VALUE = 3;
    private JLabel mMethodLabel;
    private JComboBox mMethodCombo;
    private JLabel mMaxFisherLabel;
    private JLabel mValueLabel;
    private JRadioButton mModelEstimatorRadio;
    private JRadioButton mRobustEstimatorRadio;
    private JCheckBox mInitialValCheck;
    private JButton mInitialValButton;
    private IntTextField mMaxFisherEdit;
    private FloatTextField mValueEdit;
    private JComboBox mScaleMethodCombo;
    private JLabel mScaleMethodLabel;
    private JLabel mMaxIterationLabel;
    private JLabel mMaxStepHalvingLabel;
    private JCheckBox mDataPtSeparationCheck;
    private JLabel mStartingIterationLabel;
    private IntTextField mMaxIterationEdit;
    private IntTextField mMaxStepHalvingEdit;
    private IntTextField mStartingIterationEdit;
    private JLabel mConvergenceLabel;
    private JLabel mConvCriterionLabel;
    private JLabel mMinLabel;
    private JLabel mTypeLabel;
    private JLabel mToleranceLabel;
    private JComboBox mToleranceCombo;
    private JCheckBox mChangeParamCheck;
    private JCheckBox mChangeLogCheck;
    private JCheckBox mHessianCheck;
    private ContextEnabledTextField mChangeParamEdit;
    private ContextEnabledTextField mChangeLogEdit;
    private ContextEnabledTextField mHessianEdit;
    private JComboBox mChangeParamCombo;
    private JComboBox mChangeLogCombo;
    private JComboBox mHessianCombo;
    private SpssButtonGroup mCovarianceRadioGrp;
    private boolean mShowCovarMatrixPanel;
    private JPanel mIterationPanel;
    private FileTextField mInitialValuePath;

    public EstimationTab(BaseTabbedDialog baseTabbedDialog, boolean bl) {
        super(baseTabbedDialog, true);
        this.mShowCovarMatrixPanel = bl;
        this.initialize();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mMaxFisherEdit) {
            GeneralizedLinearModelsDlg.setSelectionText((JComponent)this.mMaxFisherEdit);
        }
        if (focusEvent.getSource() == this.mValueEdit) {
            GeneralizedLinearModelsDlg.setSelectionText((JComponent)this.mValueEdit);
        }
        if (focusEvent.getSource() == this.mMaxIterationEdit) {
            GeneralizedLinearModelsDlg.setSelectionText((JComponent)this.mMaxIterationEdit);
        }
        if (focusEvent.getSource() == this.mMaxStepHalvingEdit) {
            GeneralizedLinearModelsDlg.setSelectionText((JComponent)this.mMaxStepHalvingEdit);
        }
        if (focusEvent.getSource() == this.mStartingIterationEdit) {
            GeneralizedLinearModelsDlg.setSelectionText((JComponent)this.mStartingIterationEdit);
        }
        if (focusEvent.getSource() == this.mChangeParamEdit) {
            GeneralizedLinearModelsDlg.setSelectionText((JComponent)this.mChangeParamEdit);
        }
        if (focusEvent.getSource() == this.mChangeLogEdit) {
            GeneralizedLinearModelsDlg.setSelectionText((JComponent)this.mChangeLogEdit);
        }
        if (focusEvent.getSource() == this.mHessianEdit) {
            GeneralizedLinearModelsDlg.setSelectionText((JComponent)this.mHessianEdit);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        if (itemEvent.getSource() == this.mInitialValCheck) {
            bl = this.mInitialValCheck.isSelected();
            this.mInitialValButton.setEnabled(bl);
            this.mInitialValuePath.setEnabled(bl);
        }
        if (itemEvent.getSource() == this.mChangeParamCheck) {
            bl = this.mChangeParamCheck.isSelected();
            this.mChangeParamEdit.setEnabled(bl);
            this.mChangeParamEdit.setOpaque(bl);
            this.mChangeParamCombo.setEnabled(bl);
        }
        if (itemEvent.getSource() == this.mChangeLogCheck) {
            bl = this.mChangeLogCheck.isSelected();
            this.mChangeLogEdit.setEnabled(bl);
            this.mChangeLogEdit.setOpaque(bl);
            this.mChangeLogCombo.setEnabled(bl);
        }
        if (itemEvent.getSource() == this.mHessianCheck) {
            bl = this.mHessianCheck.isSelected();
            this.mHessianEdit.setEnabled(bl);
            this.mHessianEdit.setOpaque(bl);
            this.mHessianCombo.setEnabled(bl);
        }
        if (itemEvent.getSource() == this.mDataPtSeparationCheck) {
            bl = this.mDataPtSeparationCheck.isSelected();
            this.mStartingIterationEdit.setEnabled(bl);
            this.mStartingIterationEdit.setOpaque(bl);
            this.mStartingIterationLabel.setEnabled(bl);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mInitialValButton) {
            EstimationInitialValues estimationInitialValues = new EstimationInitialValues((BaseProcedureDialog)this.mParent, this.mShowCovarMatrixPanel ? this.getResString("IDS_GLM_INITIAL_VALUES_TITLE") : this.getResString("IDS_GEE_INITIAL_VALUES_TITLE"), true);
            estimationInitialValues.setVisible(true);
            DialogDataModel dialogDataModel = ((BaseTabbedDialog)this.mParent).getDialogDataModel();
            Boolean bl = dialogDataModel.getBoolean("IDS_GLM_INITIAL_VALUES_DATASET_RADIO");
            String string = bl != null && bl != false ? dialogDataModel.getString("IDS_GLM_ESTIMATION_INTIAL_VALUES_DATASET_NAME_EDIT") : dialogDataModel.getString("IDS_GLM_ESTIMATION_INTIAL_VALUES_FILE_NAME_EDIT");
            if (string != null) {
                this.mInitialValuePath.setText(string);
            }
        }
        if (actionEvent.getSource() == this.mMethodCombo) {
            boolean bl = this.mMethodCombo.isEnabled() && this.mMethodCombo.getSelectedIndex() == 0;
            this.mMaxFisherLabel.setEnabled(bl);
            this.mMaxFisherEdit.setEnabled(bl);
            this.mMaxFisherEdit.setOpaque(bl);
        }
        if (actionEvent.getSource() == this.mScaleMethodCombo) {
            boolean bl = this.mScaleMethodCombo.getSelectedIndex() == this.mScaleMethodCombo.getItemCount() - 1;
            this.mValueLabel.setEnabled(bl);
            this.mValueEdit.setEnabled(bl);
            this.mValueEdit.setOpaque(bl);
        }
    }

    public String getEstimationTabSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SyntaxUtil.getSubCommand("/CRITERIA"));
        if (this.mMethodCombo.isEnabled()) {
            stringBuffer.append(this.getMethodCommand());
        }
        stringBuffer.append(this.getScaleCommand());
        if (this.mShowCovarMatrixPanel) {
            stringBuffer.append(this.getCovbCommand());
        }
        if (this.mMaxIterationEdit.isEnabled()) {
            stringBuffer.append(" MAXITERATIONS=").append(this.mMaxIterationEdit.getText());
        }
        if (this.mMaxStepHalvingEdit.isEnabled()) {
            stringBuffer.append(" MAXSTEPHALVING=").append(this.mMaxStepHalvingEdit.getText());
        }
        if (this.mDataPtSeparationCheck.isEnabled() && this.mDataPtSeparationCheck.isSelected()) {
            stringBuffer.append(" CHECKSEP=").append(this.mStartingIterationEdit.getText());
        }
        if (this.mChangeParamCheck.isSelected()) {
            stringBuffer.append(" PCONVERGE=").append(UIToolResUtil.removeLocale((String)this.mChangeParamEdit.getText())).append("(").append(this.getType(this.mChangeParamCombo.getSelectedIndex())).append(")");
        }
        if (this.mChangeLogCheck.isSelected()) {
            stringBuffer.append(" LCONVERGE=").append(UIToolResUtil.removeLocale((String)this.mChangeLogEdit.getText())).append("(").append(this.getType(this.mChangeLogCombo.getSelectedIndex())).append(")");
        }
        if (this.mHessianCheck.isSelected()) {
            stringBuffer.append(" HCONVERGE=").append(UIToolResUtil.removeLocale((String)this.mHessianEdit.getText())).append("(").append(this.getType(this.mHessianCombo.getSelectedIndex())).append(")");
        }
        if (this.mInitialValCheck.isSelected()) {
            stringBuffer.append(this.getInitialCommand());
        }
        stringBuffer.append(" SINGULAR=").append(this.mToleranceCombo.getSelectedItem());
        return stringBuffer.toString();
    }

    private String getType(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "ABSOLUTE";
                break;
            }
            case 1: {
                string = "RELATIVE";
            }
        }
        return string;
    }

    @Override
    public String getDialogHelpID() {
        if (this.mShowCovarMatrixPanel) {
            return "idh_idd_genlin_estimation";
        }
        return "idh_idd_gee_estimation";
    }

    public void updateEstimationTab(int n, String string) {
        boolean bl = true;
        if (n >= 0) {
            String string2 = this.getResStringArray("IDS_GLM_DISTRIBUTION_VALUES_1")[n];
            if (string2 != null && string2.equalsIgnoreCase(this.getResString("IDS_GLM_DISTRIBUTION_NORMAL"))) {
                bl = false;
            }
        } else if (!(string.equalsIgnoreCase("IDS_GLM_TYPEOFMODEL_ORD_LOGISTIC") || string.equalsIgnoreCase("IDS_GLM_TYPEOFMODEL_ORD_PROBIT") || string.equalsIgnoreCase("IDS_GLM_TYPEOFMODEL_BIN_LOGISTIC") || string.equalsIgnoreCase("IDS_GLM_TYPEOFMODEL_BIN_PROBIT") || string.equalsIgnoreCase("IDS_GLM_TYPEOFMODEL_INTERVAL_SURVIVAL"))) {
            bl = false;
        }
        this.enableEstimationTab(n, string, bl);
    }

    public void enableMethodList(boolean bl) {
        this.mMethodCombo.setEnabled(bl);
        this.mMethodLabel.setEnabled(bl);
        if (bl && this.mMethodCombo.getSelectedIndex() == 0) {
            this.mMaxFisherLabel.setEnabled(true);
            this.mMaxFisherEdit.setEnabled(true);
        } else {
            this.mMaxFisherLabel.setEnabled(false);
            this.mMaxFisherEdit.setEnabled(false);
        }
    }

    public String getScaleMethod() {
        return this.mScaleMethodCombo.getSelectedItem().toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.mInitialValuePath.getText() != null) {
            this.mInitialValuePath.setText(this.mInitialValuePath.getText());
        }
        super.paint(graphics);
    }

    public boolean isMaxLikelihoodSelected() {
        return this.getScaleMethod().equalsIgnoreCase(this.getResString("IDS_GLM_ESTIMATION_MAX_LIKELIHOOD_ESTIMATE"));
    }

    @Override
    protected boolean validateTab() {
        if (this.mMethodCombo.isEnabled() && this.mMethodCombo.getSelectedIndex() == 0) {
            if (this.mMaxFisherEdit.getText().equals("")) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_ESTIMATION_MAX_FISHER_EMPTY_MSG"), VersionInfo.getAppVersionString());
                GeneralizedLinearModelsDlg.setSelectionText((JComponent)this.mMaxFisherEdit);
                return false;
            }
            try {
                long l = Long.parseLong(this.mMaxFisherEdit.getText());
                if (l < 1L || l > Integer.MAX_VALUE) {
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (this.mScaleMethodCombo.getSelectedIndex() == this.mScaleMethodCombo.getItemCount() - 1) {
            if (this.mValueEdit.getText().equals("")) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_ESTIMATION_VALUE_EMPTY_MSG"), VersionInfo.getAppVersionString());
                GeneralizedLinearModelsDlg.setSelectionText((JComponent)this.mValueEdit);
                return false;
            }
            double d = Double.parseDouble(this.mValueEdit.getText());
            if (d <= 0.0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_ESTIMATION_VALUE_SHOULD_BE_GREATER_THAN_ZERO_MSG"), VersionInfo.getAppVersionString());
                GeneralizedLinearModelsDlg.setSelectionText((JComponent)this.mValueEdit);
                return false;
            }
        }
        if (this.mMaxIterationEdit.isEnabled()) {
            if (this.mMaxIterationEdit.getText().equals("")) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_ESTIMATION_MAX_ITERATIONS_EMPTY_MSG"), VersionInfo.getAppVersionString());
                GeneralizedLinearModelsDlg.setSelectionText((JComponent)this.mMaxIterationEdit);
                return false;
            }
            try {
                int n = Integer.parseInt(this.mMaxIterationEdit.getText());
                if (n < 0) {
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (this.mMaxStepHalvingEdit.isEnabled()) {
            if (this.mMaxStepHalvingEdit.getText().equals("")) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_ESTIMATION_MAX_STEP_HALVING_EMPTY_MSG"), VersionInfo.getAppVersionString());
                GeneralizedLinearModelsDlg.setSelectionText((JComponent)this.mMaxStepHalvingEdit);
                return false;
            }
            try {
                int n = Integer.parseInt(this.mMaxStepHalvingEdit.getText());
                if (n < 1) {
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (!this.isTextFieldValidate()) {
            return false;
        }
        DialogDataModel dialogDataModel = ((BaseTabbedDialog)this.mParent).getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean("IDS_GLM_INITIAL_VALUES_DATASET_RADIO");
        if (bl != null && bl.booleanValue()) {
            String string = dialogDataModel.getString("IDS_GLM_ESTIMATION_INTIAL_VALUES_DATASET_NAME_EDIT");
            DataMgr dataMgr = DataMgr.getDataMgr();
            int n = dataMgr.dataSourceCount();
            boolean bl2 = false;
            for (int i = 0; i < n; ++i) {
                ISpssDataSrc iSpssDataSrc = dataMgr.getDataSource(i);
                if (!iSpssDataSrc.getDatasetName().equalsIgnoreCase(string)) continue;
                bl2 = true;
            }
            if (!bl2) {
                SpssAlertOptionPane.showWarningMessageDialog(this, String.format(ComponentState.getSPSSLocale(), this.getResString("ERR_GLM_INITIAL_VALUES_DATASET_DOES_NOT_EXISTS_MSG"), string), VersionInfo.getAppVersionString());
                return false;
            }
        }
        return true;
    }

    @Override
    protected JComponent getDefaultFocusComponent() {
        String string;
        int n = this.mShowCovarMatrixPanel ? ((GeneralizedLinearModelsDlg)this.mParent).mResTab.getDistributionSelectedIndex() : ((GeneralizedEstimatingEquationsDlg)this.mParent).getResponseTab().getDistributionSelectedIndex();
        if (n != -1 && (string = this.getResStringArray("IDS_GLM_DISTRIBUTION_VALUES")[n]) != null && string.equalsIgnoreCase(this.getResString("IDS_GLM_DISTRIBUTION_NORMAL"))) {
            return this.mScaleMethodCombo;
        }
        return this.mMethodCombo;
    }

    @Override
    protected void aboutToShowTab() {
        super.aboutToShowTab();
        this.setFocusTraversalPolicy();
    }

    public void updateIteration(boolean bl) {
        DialogUtil.enableAllComponents(this.mIterationPanel, bl);
        if (bl) {
            String string;
            int n = -1;
            if (this.mShowCovarMatrixPanel) {
                if (((GeneralizedLinearModelsDlg)this.mParent).getTypeOfModelTab().mDistributionCombo.isEnabled()) {
                    n = ((GeneralizedLinearModelsDlg)this.mParent).getTypeOfModelTab().mDistributionCombo.getSelectedIndex();
                }
                string = ((GeneralizedLinearModelsDlg)this.mParent).getTypeOfModelTab().getSelectedModelType();
            } else {
                if (((GeneralizedEstimatingEquationsDlg)this.mParent).getTypeOfModelTab().mDistributionCombo.isEnabled()) {
                    n = ((GeneralizedEstimatingEquationsDlg)this.mParent).getTypeOfModelTab().mDistributionCombo.getSelectedIndex();
                }
                string = ((GeneralizedEstimatingEquationsDlg)this.mParent).getTypeOfModelTab().getSelectedModelType();
            }
            this.enableEstimationTab(n, string, true);
        }
    }

    private boolean isTextFieldValidate() {
        boolean bl;
        if (this.mDataPtSeparationCheck.isEnabled() && this.mDataPtSeparationCheck.isSelected()) {
            int n;
            if (this.mStartingIterationEdit.getText().equals("")) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_ESTIMATION_STARTING_ITERATION_EMPTY_MSG"), VersionInfo.getAppVersionString());
                GeneralizedLinearModelsDlg.setSelectionText((JComponent)this.mStartingIterationEdit);
                return false;
            }
            try {
                n = Integer.parseInt(this.mStartingIterationEdit.getText());
                if (n < 1) {
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
            n = Integer.parseInt(this.mStartingIterationEdit.getText());
            int n2 = Integer.parseInt(this.mMaxIterationEdit.getText());
            if (n >= n2) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_ESTIAMTION_START_ITERATION_SHOULDBE_LESS_THAN_MAX_ITERATIONS_MSG"), VersionInfo.getAppVersionString());
                GeneralizedLinearModelsDlg.setSelectionText((JComponent)this.mStartingIterationEdit);
                return false;
            }
        }
        if (this.mChangeParamCheck.isEnabled() && this.mChangeParamCheck.isSelected()) {
            String string = this.mChangeParamEdit.getText();
            if (string.equals("")) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_ESTIMATION_CHANGE_PARAM_EDIT_EMPTY_MSG"), VersionInfo.getAppVersionString());
                GeneralizedLinearModelsDlg.setSelectionText((JComponent)this.mChangeParamEdit);
                return false;
            }
            if (DialogUtil.parseDouble(string) == null) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_CHANGE_IN_PARAM_ZERO_WARNING_MSG"), VersionInfo.getAppVersionString());
                GeneralizedLinearModelsDlg.setSelectionText((JComponent)this.mChangeParamEdit);
                return false;
            }
        }
        if (this.mChangeLogCheck.isEnabled() && this.mChangeLogCheck.isSelected()) {
            String string = this.mChangeLogEdit.getText();
            if (string.equals("")) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_ESTIMATION_CHANGE_LOG_EMPTY_MSG"), VersionInfo.getAppVersionString());
                GeneralizedLinearModelsDlg.setSelectionText((JComponent)this.mChangeLogEdit);
                return false;
            }
            if (DialogUtil.parseDouble(string) == null) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_ESTIMATION_CHANGE_LOG_EQUAL_ZERO_MSG"), VersionInfo.getAppVersionString());
                GeneralizedLinearModelsDlg.setSelectionText((JComponent)this.mChangeLogEdit);
                return false;
            }
        }
        if (this.mHessianCheck.isEnabled() && this.mHessianCheck.isSelected()) {
            String string = this.mHessianEdit.getText();
            if (string.equals("")) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_ESTIMATION_HESSIAN_EDIT_EMPTY_MSG"), VersionInfo.getAppVersionString());
                GeneralizedLinearModelsDlg.setSelectionText((JComponent)this.mHessianEdit);
                return false;
            }
            if (DialogUtil.parseDouble(string) == null) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_HESSIAN_CONVERGENCE_ZERO_WARNING_MSG"), VersionInfo.getAppVersionString());
                GeneralizedLinearModelsDlg.setSelectionText((JComponent)this.mHessianEdit);
                return false;
            }
        }
        boolean bl2 = bl = this.mIterationPanel.isEnabled() && (this.mChangeParamCheck.isSelected() || this.mChangeLogCheck.isSelected() || this.mHessianCheck.isSelected());
        if (!bl) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_ESTIAMTION_ATLEAST_ONE_CRITERION_MUST_BE_USED_MSG"), VersionInfo.getAppVersionString());
            return false;
        }
        if (this.mInitialValCheck.isSelected() && this.mInitialValuePath.getText().equals("")) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_ESTIAMTION_INITIAL_VALUES_EDIT_EMPTY_MSG"), VersionInfo.getAppVersionString());
            GeneralizedLinearModelsDlg.setSelectionText((JComponent)((Object)this.mInitialValuePath));
            return false;
        }
        return true;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mMethodCombo);
        vector.add(this.mMaxFisherEdit);
        vector.add(this.mScaleMethodCombo);
        vector.add(this.mValueEdit);
        if (this.mShowCovarMatrixPanel) {
            vector.add(this.mCovarianceRadioGrp);
        }
        vector.add(this.mInitialValCheck);
        vector.add(this.mInitialValButton);
        vector.add(this.mMaxIterationEdit);
        vector.add(this.mMaxStepHalvingEdit);
        vector.add(this.mDataPtSeparationCheck);
        vector.add(this.mStartingIterationEdit);
        vector.add(this.mChangeParamCheck);
        vector.add(this.mChangeParamEdit);
        vector.add(this.mChangeParamCombo);
        vector.add(this.mChangeLogCheck);
        vector.add(this.mChangeLogEdit);
        vector.add(this.mChangeLogCombo);
        vector.add(this.mHessianCheck);
        vector.add(this.mHessianEdit);
        vector.add(this.mHessianCombo);
        vector.add(this.mToleranceCombo);
        JPanel jPanel = this.mParent.getCmdButtonPanel();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        this.setComponentOrder(vector);
    }

    private void enableEstimationTab(int n, String string, boolean bl) {
        boolean bl2;
        this.mMethodLabel.setEnabled(bl);
        if (bl) {
            boolean bl3 = this.mChangeParamCheck.isEnabled() && this.mChangeParamCheck.isSelected();
            this.mChangeParamEdit.setEnabled(bl3);
            this.mChangeParamEdit.setOpaque(bl3);
            this.mChangeParamCombo.setEnabled(bl3);
            bl3 = this.mChangeLogCheck.isEnabled() && this.mChangeLogCheck.isSelected();
            this.mChangeLogEdit.setEnabled(bl3);
            this.mChangeLogEdit.setOpaque(bl3);
            this.mChangeLogCombo.setEnabled(bl3);
            bl3 = this.mHessianCheck.isEnabled() && this.mHessianCheck.isSelected();
            this.mHessianEdit.setEnabled(bl3);
            this.mHessianEdit.setOpaque(bl3);
            this.mHessianCombo.setEnabled(bl3);
            bl3 = n == 0 || n == 3 || string.equalsIgnoreCase("IDS_GLM_TYPEOFMODEL_ORD_LOGISTIC") || string.equalsIgnoreCase("IDS_GLM_TYPEOFMODEL_ORD_PROBIT") || string.equalsIgnoreCase("IDS_GLM_TYPEOFMODEL_BIN_LOGISTIC") || string.equalsIgnoreCase("IDS_GLM_TYPEOFMODEL_BIN_PROBIT") || string.equalsIgnoreCase("IDS_GLM_TYPEOFMODEL_INTERVAL_SURVIVAL");
            this.mDataPtSeparationCheck.setEnabled(bl3);
            bl2 = bl3 && this.mDataPtSeparationCheck.isSelected();
            this.mStartingIterationEdit.setEnabled(bl2);
            this.mStartingIterationEdit.setOpaque(bl2);
            this.mStartingIterationLabel.setEnabled(bl2);
        }
        if (n == 0 || n == 3 || n == 4 || n == 6 || string.equalsIgnoreCase("IDS_GLM_TYPEOFMODEL_POISSON_LOGLINEAR") || string.equalsIgnoreCase("IDS_GLM_TYPEOFMODEL_NEGBIN_LOGLINK") || string.equalsIgnoreCase("IDS_GLM_TYPEOFMODEL_ORD_LOGISTIC") || string.equalsIgnoreCase("IDS_GLM_TYPEOFMODEL_ORD_PROBIT") || string.equalsIgnoreCase("IDS_GLM_TYPEOFMODEL_BIN_LOGISTIC") || string.equalsIgnoreCase("IDS_GLM_TYPEOFMODEL_BIN_PROBIT") || string.equalsIgnoreCase("IDS_GLM_TYPEOFMODEL_INTERVAL_SURVIVAL")) {
            if (this.mScaleMethodCombo.getItemCount() == 4) {
                bl2 = this.mScaleMethodCombo.getSelectedIndex() == 0;
                this.mScaleMethodCombo.removeItemAt(0);
                if (bl2) {
                    this.mScaleMethodCombo.setSelectedIndex(this.mScaleMethodCombo.getItemCount() - 1);
                } else {
                    DialogDataModel dialogDataModel = ((BaseTabbedDialog)this.mParent).getDialogDataModel();
                    Integer n2 = dialogDataModel.getInteger("IDS_GLM_ESTIMATION_SCALE_PARAM_METHOD_COMBO_KEY");
                    if (n2 != null && n2 < this.mScaleMethodCombo.getItemCount()) {
                        this.mScaleMethodCombo.setSelectedIndex(n2);
                    }
                }
            }
        } else if (this.mScaleMethodCombo.getItemCount() == 3) {
            this.mScaleMethodCombo.insertItemAt(this.getResString("IDS_GLM_ESTIMATION_MAX_LIKELIHOOD_ESTIMATE"), 0);
        } else if (this.mScaleMethodCombo.getItemCount() == 4) {
            this.mScaleMethodCombo.setSelectedIndex(0);
        }
    }

    private void initialize() {
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = UIToolDialogUtil.getStandardDialogInsets();
        Insets insets2 = new Insets(insets.top, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(this, this.setupParameterEstimationPanel(), gridBagConstraints, 0, 0, 2, 1, n, insets2);
        insets2.set(n2, insets.left, 0, insets.right);
        this.mIterationPanel = this.setupIterationPanel();
        DialogUtil.addUsingGBL(this, this.mIterationPanel, gridBagConstraints, 0, 1, 2, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets2.set(n2, insets.left * 2, insets.bottom, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(this, this.mToleranceLabel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets2.set(n2, 0, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(this, this.mToleranceCombo, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        this.setDefaults();
        this.mScaleMethodCombo.setMinimumSize(this.mScaleMethodCombo.getMinimumSize());
    }

    private void setDefaults() {
        this.mDataPtSeparationCheck.setSelected(false);
        this.mInitialValCheck.setSelected(false);
        this.mInitialValCheck.setEnabled(true);
        this.mInitialValButton.setEnabled(false);
        this.mInitialValuePath.setText("");
        this.mChangeLogEdit.setEnabled(false);
        this.mChangeLogEdit.setOpaque(false);
        this.mChangeLogEdit.setText("");
        this.mChangeLogCombo.setEnabled(false);
        this.mHessianEdit.setEnabled(false);
        this.mHessianEdit.setOpaque(false);
        this.mHessianEdit.setText("");
        this.mHessianCombo.setEnabled(false);
        this.mStartingIterationLabel.setEnabled(false);
        this.mStartingIterationEdit.setEnabled(false);
        this.mStartingIterationEdit.setOpaque(false);
        if (this.mShowCovarMatrixPanel) {
            this.mModelEstimatorRadio.setSelected(true);
        }
        this.mChangeParamCheck.setSelected(true);
        this.mChangeLogCheck.setSelected(false);
        this.mHessianCheck.setSelected(false);
        this.mMaxFisherEdit.setText("1");
        this.mValueEdit.setText("1");
        this.mMaxIterationEdit.setText("100");
        this.mMaxStepHalvingEdit.setText("5");
        this.mStartingIterationEdit.setText("20");
        this.mChangeParamEdit.setText("1E-006");
        this.mToleranceCombo.setSelectedIndex(5);
        this.mMethodCombo.setSelectedIndex(0);
        this.mScaleMethodCombo.setSelectedIndex(0);
        this.mChangeParamCombo.setSelectedIndex(0);
        this.mChangeLogCombo.setSelectedIndex(0);
        this.mHessianCombo.setSelectedIndex(0);
    }

    private void initVars() {
        this.mMethodLabel = DialogUtil.createLabel(this.mParent, "IDS_GLM_ESTIMATION_METHOD_LABEL");
        this.mMaxFisherLabel = DialogUtil.createLabel(this.mParent, "IDS_GLM_ESTIMATION_MAX_FISHER_SCORING_LABEL");
        this.mValueLabel = DialogUtil.createLabel(this.mParent, "IDS_GLM_ESTIMATION_VALUE_LABEL");
        this.mScaleMethodLabel = DialogUtil.createLabel(this.mParent, "IDS_GLM_ESTIMATION_SCALE_PARAMETER_METHOD_LABEL");
        this.mMaxIterationLabel = DialogUtil.createLabel(this.mParent, "IDS_GLM_ESTIMATION_MAXIMUM_ITERATIONS_LABEL");
        this.mMaxStepHalvingLabel = DialogUtil.createLabel(this.mParent, "IDS_GLM_ESTIMATION_MAXIMUM_STEP_HALVING_LABEL");
        this.mStartingIterationLabel = DialogUtil.createLabel(this.mParent, "IDS_GLM_ESTIMATION_STARTING_ITERATION_LABEL");
        this.mConvergenceLabel = new JLabel(this.getResString("IDS_GLM_ESTIMATION_CONVERGENCE_CRITERIA_LABEL"));
        this.mConvCriterionLabel = new JLabel(this.getResString("ERR_GLM_ESTIMATION_ONE_CRITERION_WITH_MIN_GREATER_THAN_ZERO_LABEL"));
        this.mMinLabel = new JLabel(this.getResString("IDS_GLM_ESTIMATION_MINIMUM_LABEL"));
        this.mTypeLabel = new JLabel(this.getResString("IDS_GLM_ESTIMATION_TYPE_LABEL"));
        this.mToleranceLabel = DialogUtil.createLabel(this.mParent, "IDS_GLM_ESTIMATION_SINGULARITY_TOLERANCE_LABEL");
        this.mMethodCombo = new JComboBox<String>(this.getResStringArray("IDS_GLM_ESTIMATION_METHOD_COMBO_ITEMS"));
        this.mMethodCombo.setAction(new ComboboxAction(this.mParent, "IDS_GLM_ESTIMATION_METHOD_COMBO_KEY"));
        this.mMethodLabel.setLabelFor(this.mMethodCombo);
        this.mScaleMethodCombo = new JComboBox<String>(this.getResStringArray("IDS_GLM_ESTIMATION_SCALE_PARAM_METHOD_COMBO_ITEMS"));
        this.mScaleMethodCombo.setAction(new ComboboxAction(this.mParent, "IDS_GLM_ESTIMATION_SCALE_PARAM_METHOD_COMBO_KEY"));
        this.mScaleMethodLabel.setLabelFor(this.mScaleMethodCombo);
        this.mToleranceCombo = new JComboBox<String>(this.getResStringArray("IDS_GLM_ESTIMATION_TOLERANCE_COMBO_ITEMS"));
        this.mToleranceCombo.setAction(new ComboboxAction(this.mParent, "IDS_GLM_ESTIMATION_TOLERANCE_COMBO_KEY"));
        this.mMethodCombo.addActionListener(this);
        this.mToleranceLabel.setLabelFor(this.mToleranceCombo);
        this.mScaleMethodCombo.addActionListener(this);
        this.mChangeParamCombo = new JComboBox<String>(this.getResStringArray("IDS_GLM_ESTIMATION_CONVERGENCE_CRITERION_COMBO_ITEMS"));
        this.mChangeParamCombo.setAction(new ComboboxAction(this.mParent, "IDS_GLM_ESTIMATION_CHANGE_PARAM_COMBO_KEY"));
        this.mChangeLogCombo = new JComboBox<String>(this.getResStringArray("IDS_GLM_ESTIMATION_CONVERGENCE_CRITERION_COMBO_ITEMS"));
        this.mChangeLogCombo.setAction(new ComboboxAction(this.mParent, "IDS_GLM_ESTIMATION_CHANGE_LOG_COMBO_KEY"));
        this.mHessianCombo = new JComboBox<String>(this.getResStringArray("IDS_GLM_ESTIMATION_CONVERGENCE_CRITERION_COMBO_ITEMS"));
        this.mHessianCombo.setAction(new ComboboxAction(this.mParent, "IDS_GLM_ESTIMATION_HESSIAN_COMBO_KEY"));
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_GLM_ESTIMATION_MODEL_BASED_ESTIMETER");
        this.mModelEstimatorRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_GLM_ESTIMATION_ROBUST_ESTIMATOR");
        this.mRobustEstimatorRadio = new JRadioButton(toggleButtonAction);
        this.mCovarianceRadioGrp = new SpssButtonGroup();
        this.mCovarianceRadioGrp.add(this.mModelEstimatorRadio);
        this.mCovarianceRadioGrp.add(this.mRobustEstimatorRadio);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_GLM_ESTIMATION_GET_INITIAL_VALUE_CHECKBOX");
        this.mInitialValCheck = new SpssMultiLineCheckBox(toggleButtonAction);
        this.mInitialValCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_GLM_ESTIMATION_CHECK_FOR_SEPARATION_CHECKBOX");
        this.mDataPtSeparationCheck = new JCheckBox(toggleButtonAction);
        this.mDataPtSeparationCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_GLM_ESTIMATION_CHANGE_IN_PARAMETER_ITERATIONS_CHECKBOX");
        this.mChangeParamCheck = new JCheckBox(toggleButtonAction);
        this.mChangeParamCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_GLM_ESTIMATION_CHANGE_IN_LOG_LIKELIHOOD_CHECKBOX");
        this.mChangeLogCheck = new JCheckBox(toggleButtonAction);
        this.mChangeLogCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_GLM_ESTIMATION_HESSION_CONVERGENCE_CHECKBOX");
        this.mHessianCheck = new JCheckBox(toggleButtonAction);
        this.mHessianCheck.addItemListener(this);
        this.mInitialValButton = DialogUtil.createButton(this.mParent, "IDS_GLM_ESTIMATION_INITIAL_VALUE_BUTTON", this);
        this.mMaxFisherEdit = new IntTextField(1, Integer.MAX_VALUE, true);
        this.mMaxFisherEdit.setAction((Action)new TextFieldAction(this.mParent, "IDS_GLM_ESTIMATION_MAXIMUM_FISHER_ITERATIONS_EDIT_KEY"));
        this.mMaxFisherEdit.setColumns(5);
        this.mMaxFisherEdit.addFocusListener((FocusListener)this);
        this.mMaxFisherLabel.setLabelFor((Component)this.mMaxFisherEdit);
        this.mValueEdit = new FloatTextField(true);
        this.mValueEdit.setAction((Action)new TextFieldAction(this.mParent, "IDS_GLM_ESTIMATION_VALUE_EDIT_KEY"));
        this.mValueEdit.setColumns(5);
        this.mValueEdit.addFocusListener((FocusListener)this);
        this.mValueLabel.setLabelFor((Component)this.mValueEdit);
        this.mMaxIterationEdit = new IntTextField(0, Integer.MAX_VALUE, true);
        this.mMaxIterationEdit.setAction((Action)new TextFieldAction(this.mParent, "IDS_GLM_ESTIMATION_MAXIMUM_ITERATIONS_EDIT_KEY"));
        this.mMaxIterationEdit.setColumns(5);
        this.mMaxIterationEdit.addFocusListener((FocusListener)this);
        this.mMaxIterationLabel.setLabelFor((Component)this.mMaxIterationEdit);
        this.mMaxStepHalvingEdit = new IntTextField(1, Integer.MAX_VALUE, true);
        this.mMaxStepHalvingEdit.setAction((Action)new TextFieldAction(this.mParent, "IDS_GLM_ESTIMATION_MAXIMUM_STEP_HALVING_EDIT_KEY"));
        this.mMaxStepHalvingEdit.setColumns(5);
        this.mMaxStepHalvingEdit.addFocusListener((FocusListener)this);
        this.mMaxStepHalvingLabel.setLabelFor((Component)this.mMaxStepHalvingEdit);
        this.mStartingIterationEdit = new IntTextField(1, Integer.MAX_VALUE, true);
        this.mStartingIterationEdit.setAction((Action)new TextFieldAction(this.mParent, "IDS_GLM_ESTIMATION_STARTING_ITERATION_EDIT_KEY"));
        this.mStartingIterationEdit.setColumns(5);
        this.mStartingIterationEdit.addFocusListener((FocusListener)this);
        this.mStartingIterationLabel.setLabelFor((Component)this.mStartingIterationEdit);
        this.mChangeParamEdit = new ContextEnabledTextField();
        this.mChangeParamEdit.setAction((Action)new TextFieldAction(this.mParent, "IDS_GLM_ESTIMATION_CHANGE_PARAM_EDIT_KEY"));
        this.mChangeParamEdit.setColumns(10);
        this.mChangeParamEdit.setDocument((Document)new ExponentialDoc());
        this.mChangeParamEdit.addFocusListener((FocusListener)this);
        this.mChangeLogEdit = new ContextEnabledTextField();
        this.mChangeLogEdit.setAction((Action)new TextFieldAction(this.mParent, "IDS_GLM_ESTIMATION_CHANGE_LOG_EDIT_KEY"));
        this.mChangeLogEdit.setColumns(10);
        this.mChangeLogEdit.setDocument((Document)new ExponentialDoc());
        this.mChangeLogEdit.addFocusListener((FocusListener)this);
        this.mHessianEdit = new ContextEnabledTextField();
        this.mHessianEdit.setAction((Action)new TextFieldAction(this.mParent, "IDS_GLM_ESTIMATION_HESSIAN_EDIT_KEY"));
        this.mHessianEdit.setColumns(10);
        this.mHessianEdit.setDocument((Document)new ExponentialDoc());
        this.mHessianEdit.addFocusListener((FocusListener)this);
        this.mInitialValuePath = new FileTextField();
        this.mInitialValuePath.setAction(new TextFieldAction(this.mParent, "IDS_GLM_ESTIMATION_INITIAL_VALUE_EDIT_KEY"));
        this.mInitialValuePath.setEditable(false);
        this.mInitialValuePath.setOpaque(false);
        this.mInitialValuePath.setBorder(BorderFactory.createEmptyBorder());
    }

    private JPanel setupParameterEstimationPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_GLM_ESTIMATION_PARAMETER_ESTIMATION"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = 23;
        int n3 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n * 2, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.setupMethodPanel(), gridBagConstraints, 0, 0, 1, 1, n2, insets);
        insets.set(n + 15, n + 50, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.setupMaxFisherPanel(), gridBagConstraints, 0, 1, 1, 1, n2, insets);
        insets.set(n + 3, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.setupScaleMethodPanel(), gridBagConstraints, 0, 2, 1, 1, n2, insets);
        insets.set(n, n + 50, n, n);
        DialogUtil.addUsingGBL(jPanel, this.setupValuePanel(), gridBagConstraints, 0, 3, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(0, n, n, n);
        if (this.mShowCovarMatrixPanel) {
            DialogUtil.addUsingGBL(jPanel, this.setupCovarianceMatrixPanel(), gridBagConstraints, 1, 0, 1, 2, n2, insets);
        }
        insets.set(0, n, n, n);
        DialogUtil.addUsingGBL(jPanel, this.mInitialValCheck, gridBagConstraints, 1, 2, 1, 1, n2, insets);
        gridBagConstraints.fill = 0;
        insets.set(0, n + 20, n, n);
        DialogUtil.addUsingGBL(jPanel, this.mInitialValButton, gridBagConstraints, 1, 3, 1, 1, n2, insets);
        insets.set(3, n + 20 + this.mInitialValButton.getMaximumSize().width + n3, n, n);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mInitialValuePath), gridBagConstraints, 1, 3, 1, 1, n2, insets);
        return jPanel;
    }

    private JPanel setupIterationPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_GLM_ESTIMATION_ITERATIONS"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = 23;
        Insets insets = new Insets(n, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.setupMaxIterationPanel(), gridBagConstraints, 0, 0, 1, 1, n2, insets);
        insets.set(n, n, n, n);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.setupConvergencePanel(), gridBagConstraints, 0, 1, 1, 1, n2, insets);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.setupMinTypePanel(), gridBagConstraints, 0, 2, 1, 1, n2, insets);
        return jPanel;
    }

    private JPanel setupCovarianceMatrixPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_GLM_ESTIMATION_COVARIANCE_MATRIX"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mModelEstimatorRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mRobustEstimatorRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupMaxFisherPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mMaxFisherLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        n = 24;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxFisherEdit, gridBagConstraints, 1, 0, 1, 1, n, new Insets(0, DialogUtil.getComponentGroupGap(), 0, 0));
        return jPanel;
    }

    private JPanel setupValuePanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mValueLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        n = 24;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mValueEdit, gridBagConstraints, 1, 0, 1, 1, n, null);
        return jPanel;
    }

    private JPanel setupMethodPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mMethodLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        n = 24;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mMethodCombo, gridBagConstraints, 1, 0, 1, 1, n, null);
        return jPanel;
    }

    private JPanel setupScaleMethodPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mScaleMethodLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        n = 24;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mScaleMethodCombo, gridBagConstraints, 1, 0, 1, 1, n, new Insets(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0));
        return jPanel;
    }

    private JPanel setupMaxIterationPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = new JPanel(true);
        jPanel2.setLayout(new GridBagLayout());
        JPanel jPanel3 = new JPanel(true);
        jPanel3.setLayout(new GridBagLayout());
        JSeparator jSeparator = new JSeparator(1);
        JPanel jPanel4 = new JPanel(true);
        jPanel4.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.gray));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = 23;
        Insets insets2 = new Insets(0, 0, n, n);
        DialogUtil.addUsingGBL(jPanel2, this.mMaxIterationLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        insets2.set(0, n, n, 0);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mMaxIterationEdit, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel2, this.mMaxStepHalvingLabel, gridBagConstraints, 0, 1, 1, 1, n2, null);
        insets2.set(0, n, n, 0);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mMaxStepHalvingEdit, gridBagConstraints, 1, 1, 1, 1, n2, insets2);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n2, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 3;
        insets2.set(0, n * 5, 0, n * 5);
        DialogUtil.addUsingGBL(jPanel, jSeparator, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel3, this.mDataPtSeparationCheck, gridBagConstraints, 0, 0, 2, 1, n2, insets);
        insets2.set(n, n * 5 + 20, 0, 0);
        DialogUtil.addUsingGBL(jPanel3, this.mStartingIterationLabel, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        insets2.set(n, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel3, (JComponent)this.mStartingIterationEdit, gridBagConstraints, 1, 1, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 2, 0, 1, 1, n2, null);
        return jPanel;
    }

    private JPanel setupConvergencePanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        DialogUtil.applyTopBorder(jPanel2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mConvergenceLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, new Insets(n2 * 2, n2, 0, 0));
        DialogUtil.addUsingGBL(jPanel, this.mConvCriterionLabel, gridBagConstraints, 0, 1, 2, 1, n, new Insets(n2, 0, 0, 0));
        return jPanel;
    }

    private JPanel setupMinTypePanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, n2, n2, 0);
        DialogUtil.addUsingGBL(jPanel, this.mMinLabel, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2.set(0, n2 * 2, n2, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTypeLabel, gridBagConstraints, 2, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mChangeParamCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets2.set(2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mChangeParamEdit, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2.set(1, n2 * 2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mChangeParamCombo, gridBagConstraints, 2, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mChangeLogCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        insets2.set(2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mChangeLogEdit, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2.set(1, n2 * 2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mChangeLogCombo, gridBagConstraints, 2, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mHessianCheck, gridBagConstraints, 0, 3, 1, 1, n, insets);
        insets2.set(2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mHessianEdit, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2.set(1, n2 * 2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mHessianCombo, gridBagConstraints, 2, 3, 1, 1, n, insets2);
        return jPanel;
    }

    private StringBuffer getCovbCommand() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(" COVB=");
        if (this.mModelEstimatorRadio.isSelected()) {
            stringBuffer.append("MODEL");
        } else {
            stringBuffer.append("ROBUST");
        }
        return stringBuffer;
    }

    private StringBuffer getMethodCommand() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(" METHOD=");
        int n = this.mMethodCombo.getSelectedIndex();
        if (n == 0) {
            stringBuffer.append("FISHER(").append(this.mMaxFisherEdit.getText()).append(")");
        } else if (n == 1) {
            stringBuffer.append("FISHER");
        } else {
            stringBuffer.append("NEWTON");
        }
        return stringBuffer;
    }

    private StringBuffer getScaleCommand() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(" SCALE=");
        int n = this.mScaleMethodCombo.getSelectedIndex();
        if (this.mScaleMethodCombo.getItemCount() == 3) {
            ++n;
        }
        switch (n) {
            case 0: {
                stringBuffer.append("MLE");
                break;
            }
            case 1: {
                stringBuffer.append("DEVIANCE");
                break;
            }
            case 2: {
                stringBuffer.append("PEARSON");
                break;
            }
            case 3: {
                stringBuffer.append(this.mValueEdit.getText());
            }
        }
        return stringBuffer;
    }

    private StringBuffer getInitialCommand() {
        StringBuffer stringBuffer = new StringBuffer("");
        DialogDataModel dialogDataModel = ((BaseTabbedDialog)this.mParent).getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean("IDS_GLM_INITIAL_VALUES_DATASET_RADIO");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("\n  INITIAL=").append(this.mInitialValuePath.getText());
        } else {
            stringBuffer.append("\n  INITIAL=").append(CharacterUtil.smartQuote((String)this.mInitialValuePath.getText()));
        }
        return stringBuffer;
    }
}

