/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model;

import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.IDataDocument;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.FileValidator;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class EstimationInitialValues
extends BaseSubDialog
implements ItemListener,
ActionListener,
DocumentListener,
FocusListener {
    static final String DATASET_RADIO_BUTTON = "IDS_GLM_INITIAL_VALUES_DATASET_RADIO";
    static final String FILE_RADIO_BUTTON = "IDS_GLM_INITIAL_VALUES_FILE_RADIO";
    static final String DATASET_NAME_EDIT_KEY = "IDS_GLM_ESTIMATION_INTIAL_VALUES_DATASET_NAME_EDIT";
    static final String FILE_NAME_EDIT_KEY = "IDS_GLM_ESTIMATION_INTIAL_VALUES_FILE_NAME_EDIT";
    private JRadioButton mDataSetRadio;
    private JRadioButton mFileRadio;
    private JLabel mDataSetNameLabel;
    private JLabel mFileNameLabel;
    private JComboBox mDataSetNameCombo;
    private FileTextField mFileNameEdit;
    private JButton mBrowseButton;
    private SpssButtonGroup mRadioButtonGrp;

    public EstimationInitialValues(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
        Dimension dimension = this.getSize();
        this.setSize(new Dimension(dimension.width + 50, dimension.height));
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        if (itemEvent.getSource() == this.mDataSetRadio) {
            bl = this.mDataSetRadio.isSelected();
            this.mDataSetNameCombo.setEnabled(bl);
            this.mDataSetNameCombo.setOpaque(bl);
            this.mDataSetNameLabel.setEnabled(bl);
            this.canEnableContinue();
        }
        if (itemEvent.getSource() == this.mFileRadio) {
            bl = this.mFileRadio.isSelected();
            this.mFileNameEdit.setEnabled(bl);
            this.mFileNameEdit.setOpaque(bl);
            this.mFileNameLabel.setEnabled(bl);
            this.mBrowseButton.setEnabled(bl);
            this.canEnableContinue();
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_genlin_init_values";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mBrowseButton) {
            this.showOpenDialog();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mDataSetNameCombo) {
            // empty if block
        }
        if (focusEvent.getSource() == this.mFileNameEdit) {
            this.mFileNameEdit.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.canEnableContinue();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.canEnableContinue();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.canEnableContinue();
    }

    @Override
    public boolean continuePressed() {
        if (this.mDataSetRadio.isSelected()) {
            String string = this.mDataSetNameCombo.getSelectedItem().toString();
            DataMgr dataMgr = DataMgr.getDataMgr();
            int n = dataMgr.dataSourceCount();
            for (int i = 0; i < n; ++i) {
                ISpssDataSrc iSpssDataSrc = dataMgr.getDataSource(i);
                if (!iSpssDataSrc.getDatasetName().equalsIgnoreCase(string)) continue;
                return true;
            }
            return false;
        }
        String string = this.mFileNameEdit.getText();
        short s = FileValidator.evaluateOpenFile((Component)((Object)this), string, true, true);
        if (s == 1 || s == 2 || s == 5) {
            this.mFileNameEdit.requestFocus();
            this.mFileNameEdit.selectAll();
        }
        return s == 0 || s == 3 || s == 4;
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        if (this.mDataSetRadio.isSelected()) {
            this.mFileNameEdit.setText("");
            dialogDataModel.putString(DATASET_NAME_EDIT_KEY, this.mDataSetNameCombo.getSelectedItem().toString());
        } else {
            dialogDataModel.putString(DATASET_NAME_EDIT_KEY, "");
        }
        return super.saveState(dialogDataModel);
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.setupInitialValuesPanel(), gridBagConstraints, 0, 0, 1, 1, n, null);
        this.setDefaults();
        this.pack();
        this.setFocusTraversalPolicy();
        this.canEnableContinue();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mRadioButtonGrp);
        vector.add(this.mDataSetNameCombo);
        vector.add(this.mFileNameEdit);
        vector.add(this.mBrowseButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void canEnableContinue() {
        if (!this.mDataSetRadio.isSelected()) {
            this.enableContinue(!this.mFileNameEdit.getText().equals(""));
        }
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, DATASET_RADIO_BUTTON);
        this.mDataSetRadio = new JRadioButton(toggleButtonAction);
        this.mDataSetRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, FILE_RADIO_BUTTON);
        this.mFileRadio = new JRadioButton(toggleButtonAction);
        this.mFileRadio.addItemListener(this);
        this.mRadioButtonGrp = new SpssButtonGroup();
        this.mRadioButtonGrp.add(this.mDataSetRadio);
        this.mRadioButtonGrp.add(this.mFileRadio);
        this.mDataSetNameLabel = DialogUtil.createLabel(this, "IDS_GLM_INITIAL_VALUES_DATASET_NAME_LABEL");
        this.mFileNameLabel = DialogUtil.createLabel(this, "IDS_GLM_INITIAL_VALUES_FILE_NAME_RADIO");
        this.mDataSetNameLabel.setLabelFor(this.mDataSetNameCombo);
        this.mFileNameEdit = new FileTextField();
        this.mFileNameEdit.setAction(new TextFieldAction(this, FILE_NAME_EDIT_KEY));
        this.mFileNameEdit.getDocument().addDocumentListener(this);
        this.mFileNameEdit.addFocusListener(this);
        this.mFileNameLabel.setLabelFor((Component)((Object)this.mFileNameEdit));
        this.mBrowseButton = DialogUtil.createButton(this, "IDS_GLM_INITIAL_VALUES_BROWSE_BUTTON", this);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        SpssFrame[] spssFrameArray = SpssFrameMgr.getSpssFrameMgr().getOpenDocuments();
        DataMgr dataMgr = DataMgr.getDataMgr();
        if (spssFrameArray != null) {
            for (int i = 0; i < spssFrameArray.length; ++i) {
                if (spssFrameArray[i].docType() != DocType.DE_DOC || spssFrameArray[i] == SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC)) continue;
                DataFrame dataFrame = (DataFrame)spssFrameArray[i];
                IDataDocument iDataDocument = dataMgr.findDataDocument(dataFrame.getDatasetId());
                String string = iDataDocument.getDatasetName();
                defaultComboBoxModel.addElement(string);
            }
        }
        this.mDataSetNameCombo = new JComboBox(defaultComboBoxModel);
        this.mDataSetNameCombo.setAction(new ComboboxAction(this, DATASET_NAME_EDIT_KEY));
        this.mDataSetNameCombo.addFocusListener(this);
        if (defaultComboBoxModel.getSize() == 0) {
            this.mDataSetRadio.setEnabled(false);
            this.mDataSetNameCombo.setEnabled(false);
            this.mDataSetNameLabel.setEnabled(false);
            this.mFileRadio.setEnabled(true);
            this.mFileRadio.setSelected(true);
        }
    }

    private void setDefaults() {
        if (this.mDataSetNameCombo.getItemCount() == 0) {
            this.mDataSetRadio.setEnabled(false);
            this.mDataSetNameCombo.setEnabled(false);
            this.mDataSetNameLabel.setEnabled(false);
            this.mFileRadio.setEnabled(true);
            this.mFileRadio.setSelected(true);
        } else {
            this.mDataSetRadio.setSelected(true);
            this.mFileNameEdit.setEnabled(false);
            this.mFileNameEdit.setOpaque(false);
            this.mBrowseButton.setEnabled(false);
        }
    }

    private JPanel setupInitialValuesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_GLM_INITIAL_VALUES_PANEL_TITLE"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        DialogUtil.addUsingGBL(jPanel, this.mDataSetRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        Insets insets2 = new Insets(insets.top, insets.left + 20, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mDataSetNameLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        int n3 = DialogUtil.getComponentGroupGap();
        insets2.set(insets.top, insets.left + 20, insets.bottom, n2);
        DialogUtil.addUsingGBL(jPanel, this.mDataSetNameCombo, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mFileRadio, gridBagConstraints, 0, 3, 1, 1, n, insets);
        insets2.set(insets.top, insets.left + 20, insets.bottom, n2);
        DialogUtil.addUsingGBL(jPanel, this.mFileNameLabel, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        insets2.set(insets.top, insets.left + 20, n3, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFileNameEdit), gridBagConstraints, 0, 5, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        n = 24;
        insets2.set(insets.top, insets.left, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton, gridBagConstraints, 0, 6, 1, 1, n, insets2);
        UIToolDialogUtil.normalizeButtonWidths((JPanel)jPanel);
        return jPanel;
    }

    private void showOpenDialog() {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), true);
        remoteFileChooser.setDialogTitle(this.getResString("IDS_GLM_INITIAL_VALUES_OPEN_DLG_TITLE"));
        remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(this.getResString("IDS_GLM_SPSS_DATA_FILE_FILTER"), this.getResString("IDS_GLM_SPSS_DATA_FILE_FILTER_EXTN")));
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        int n = remoteFileChooser.showOpenDialog((Component)((Object)this));
        if (n == 0) {
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            String string = remoteFileChooser.getSelectedFilePath();
            if (!string.endsWith(this.getResString("IDS_GLM_SPSS_DATA_FILE_FILTER_EXTN"))) {
                string = string + this.getResString("IDS_GLM_SPSS_DATA_FILE_FILTER_EXTN");
            }
            this.mFileNameEdit.setText(string);
        }
    }
}

