/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.ComponentsArrowButton;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.GLMComboBoxModel;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.GeneralizedLinearModelsDlg;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.ModelTab;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.PredictorsTab;
import com.spss.java_client.ui.dialogs.base.analyze.generalized_lin_model.generalized_estm_eqn.GeneralizedEstimatingEquationsDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.controls.FloatComboBox;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;

public class EMMeansTab
extends BaseProcedureTab
implements ActionListener,
ListSelectionListener,
ItemListener,
FocusListener,
KeyListener {
    static final String ADJUSTMENT_COMBO = "ADJUSTMENT_COMBO_KEY";
    static final int FACTOR_TABLE_HEIGHT = 160;
    static final int FACTOR_TABLE_WIDTH = 120;
    static final int DISPLAY_TABLE_HEIGHT = 400;
    static final int DISPLAY_TABLE_WIDTH = 350;
    static final int TABLE_ROW = 100;
    static final int TABLE_ROWHEIGHT = 100;
    static final String DISPLAY_CHECK = "IDS_GLM_DISPLAY_MEAN_CHECK";
    static final String CONTRAST_CHOICE = "IDS_GLM_CONTRAST_CHOICE";
    static final String CATEGORY_CHOICE = "IDS_GLM_CATEGORY_CHOICE";
    public static final String SOURCE_KEY = "IDS_SOURCE_KEY";
    private PlainTable mFactorsTable;
    private PlainTable mDisplayMeansTable;
    private DefaultTableModel mDisplayMeansTableModel;
    private JScrollPane mFactorsScrollPane;
    private JScrollPane mDisplayScrollPane;
    private ComponentsArrowButton mArrowButton;
    private JButton mByButton;
    private JRadioButton mComputeMeansResponseRadio;
    private JRadioButton mComputeMeansLinearRadio;
    private JLabel mAdjustmentLabel;
    private JComboBox mAdjustmentCombo;
    private JCheckBox mDisplayMeanCheck;
    private HashMap<String, SerializableObject> mMapOfModels;
    private FloatComboBox mCategoryCombo;
    private ContrastCellEditor mContrastEditor;
    private ContrastCellRenderer mContrastRenderer;
    private CategoryCellEditor mCategoryEditor;
    private CategoryCellRenderer mCategoryRenderer;
    private int mRow;
    private SpssButtonGroup mGroup;
    private Vector<String> mFactorVector;
    private Vector<String> mUnCheckedCVector;
    private DialogDataModel mDialogDataModel;
    private boolean mGLM;
    private JLabel mFactorsLabel;
    private JLabel mDisplayMeanLabel;
    private JPanel mScalePanel;
    protected DecimalFormatSymbols mSymbol;
    private char mDecimalSeparator;
    private ArrayList<String> mValueLabels = new ArrayList();
    private Hashtable<String, VarAndVarValueLabels> mVarValueLabels = new Hashtable();

    public EMMeansTab(BaseTabbedDialog baseTabbedDialog, boolean bl) {
        super(baseTabbedDialog, true);
        this.mGLM = bl;
        this.mVarValueLabels.clear();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n != 127) {
            this.mCategoryCombo.setEditable(true);
            this.mCategoryCombo.getEditor().selectAll();
            this.mCategoryCombo.getEditor().setItem(Character.valueOf(keyEvent.getKeyChar()));
        }
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return this.mFactorsTable;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mFactorsTable)) {
            this.mDisplayMeansTable.getSelectionModel().clearSelection();
            this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        }
        if (focusEvent.getSource().equals(this.mDisplayMeansTable)) {
            this.mFactorsTable.getSelectionModel().clearSelection();
            this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    public void enableTab(boolean bl) {
        this.mFactorsLabel.setEnabled(bl);
        this.mFactorsTable.setEnabled(bl);
        DialogUtil.enableTitledBorder(this.mScalePanel, bl);
        this.mComputeMeansResponseRadio.setEnabled(bl);
        this.mComputeMeansLinearRadio.setEnabled(bl);
        this.mAdjustmentLabel.setEnabled(bl);
        this.mAdjustmentCombo.setEnabled(bl);
        this.mArrowButton.setEnabled(bl);
        this.mByButton.setEnabled(bl && this.mFactorsTable.getSelectedRowCount() > 1);
        this.mDisplayMeanLabel.setEnabled(bl);
        this.mDisplayMeansTable.setEnabled(bl);
        this.mDisplayMeanCheck.setEnabled(bl);
    }

    public String getEMMeansCommandSyntax() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (!this.tabIsEnabled()) {
            return stringBuffer.toString();
        }
        if (this.mDisplayMeanCheck.isSelected()) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/EMMEANS "));
            this.getScaleSyntax(stringBuffer);
            stringBuffer.append("\n");
        }
        int n = this.mDisplayMeansTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string = this.mDisplayMeansTable.getModel().getValueAt(i, 0).toString();
            String string2 = this.mDisplayMeansTableModel.getValueAt(i, 0).toString();
            stringBuffer.append(SyntaxUtil.getSubCommand("/EMMEANS "));
            stringBuffer.append("TABLES=");
            stringBuffer.append(string2);
            stringBuffer.append(" ");
            this.getScaleSyntax(stringBuffer);
            if (!this.mDisplayMeansTable.getModel().getValueAt(i, 1).toString().equals(this.getResString("IDS_GLM_EMMEANS_NONE_STRING"))) {
                stringBuffer.append(" COMPARE=");
                stringBuffer.append(string);
            }
            if (this.mDisplayMeansTable.getModel().getValueAt(i, 1).toString().equals(this.getResString("IDS_GLM_EMMEANS_SIMPLE_STRING"))) {
                stringBuffer.append(" CONTRAST=SIMPLE(");
                if (this.checkStringVariable(string.trim())) {
                    stringBuffer.append("'").append(this.getFirstPartOfCategoryCombo(this.mDisplayMeansTable.getModel().getValueAt(i, 2).toString())).append("'");
                } else {
                    stringBuffer.append(this.getFirstPartOfCategoryCombo(this.mDisplayMeansTable.getModel().getValueAt(i, 2).toString()));
                }
                stringBuffer.append(")");
            } else {
                stringBuffer.append(this.getContrastCommand(i));
            }
            if (this.isAdjustComboEnable()) {
                stringBuffer.append(this.getPadjustCommand());
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private void getScaleSyntax(StringBuffer stringBuffer) {
        stringBuffer.append("SCALE=");
        if (this.mComputeMeansResponseRadio.isSelected()) {
            stringBuffer.append("ORIGINAL");
        } else if (this.mComputeMeansLinearRadio.isSelected()) {
            stringBuffer.append("TRANSFORMED");
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.isAdjustComboEnable();
        this.repaint();
    }

    @Override
    protected void validateTableData() {
        ModelTab.loadValuesInModel();
        ModelTab.ensureConsistent();
        this.loadDataToFactorAndInteractions();
        this.getValueAtDisplayTable();
        this.repaint();
        if (this.mFactorsTable.getRowCount() < 1) {
            this.mArrowButton.setEnabled(false);
        } else {
            this.mFactorsTable.getSelectionModel().setSelectionInterval(0, 0);
            this.mFactorsTable.requestFocusInWindow();
        }
        this.invalidate();
        this.revalidate();
    }

    private void getValueAtDisplayTable() {
        if (this.mFactorVector == null || this.mFactorVector.size() < 1) {
            while (this.mDisplayMeansTable.getModel().getRowCount() > 0) {
                this.mDisplayMeansTableModel.removeRow(0);
            }
            return;
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.mDisplayMeansTable.getModel().getRowCount(); ++i) {
            block2: for (int j = 0; j < this.mDisplayMeansTable.getModel().getColumnCount(); ++j) {
                if (j != 0) continue;
                String string = this.mDisplayMeansTable.getModel().getValueAt(i, 0).toString();
                if (string.contains("*") && !this.mFactorVector.contains(string)) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "*");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        vector.add(string2);
                    }
                    for (int k = 0; k < vector.size(); ++k) {
                        if (this.mFactorVector.contains(vector.elementAt(k))) continue;
                        this.mDisplayMeansTableModel.removeRow(i--);
                        continue block2;
                    }
                    continue;
                }
                if (this.mFactorVector.contains(string) || this.mDisplayMeansTableModel.getRowCount() <= 0) continue;
                this.mDisplayMeansTableModel.removeRow(i--);
            }
        }
        this.mDisplayMeansTable.setModel(this.mDisplayMeansTableModel);
        this.mDisplayMeansTable.repaint();
    }

    private boolean isAdjustComboEnable() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.mDisplayMeansTable.getModel().getRowCount(); ++n) {
            for (int i = 0; i < this.mDisplayMeansTable.getModel().getColumnCount(); ++i) {
                if (i != 1 || this.mDisplayMeansTable.getModel().getValueAt(n, 1).toString().equals(this.getResString("IDS_GLM_EMMEANS_NONE_STRING"))) continue;
                n2 = 1;
                this.mDisplayMeansTable.changeSelection(n, i, false, false);
            }
        }
        n = n2;
        SwingUtilities.invokeLater(new Runnable(n != 0){
            final /* synthetic */ boolean val$state;
            {
                this.val$state = bl;
            }

            @Override
            public void run() {
                EMMeansTab.this.mAdjustmentLabel.setEnabled(this.val$state);
                EMMeansTab.this.mAdjustmentCombo.setEnabled(this.val$state);
            }
        });
        this.mAdjustmentCombo.invalidate();
        this.mAdjustmentCombo.revalidate();
        this.mAdjustmentCombo.updateUI();
        return n2 != 0;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.mArrowButton.setEnabled(true);
        if (this.mFactorsTable.getSelectedRowCount() > 1) {
            this.mByButton.setEnabled(true);
        } else {
            this.mByButton.setEnabled(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.mByButton)) {
            int[] nArray;
            StringBuffer stringBuffer = new StringBuffer("");
            for (int n : nArray = this.mFactorsTable.getSelectedRows()) {
                String string = this.mFactorsTable.getModel().getValueAt(n, 1).toString();
                stringBuffer.append(string);
                stringBuffer.append("*");
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            Object[] objectArray = new Object[]{stringBuffer.toString(), this.getResString("IDS_GLM_EMMEANS_NONE_STRING"), ""};
            if (!this.tableHasColumnName(stringBuffer.toString())) {
                this.mDisplayMeansTableModel.addRow(objectArray);
                this.mDisplayMeansTable.setRowSelectionInterval(this.mDisplayMeansTable.getRowCount() - 1, this.mDisplayMeansTable.getRowCount() - 1);
            }
            this.mFactorsTable.getSelectionModel().clearSelection();
        } else if (actionEvent.getSource().equals(this.mArrowButton)) {
            if (this.mArrowButton.getArrowOrientation() == SpssArrowButton.ButtonOrientation.right) {
                void var5_11;
                int[] nArray = this.mFactorsTable.getSelectedRows();
                this.repaint();
                int[] nArray2 = nArray;
                int n = nArray2.length;
                boolean i = false;
                while (var5_11 < n) {
                    int n2 = nArray2[var5_11];
                    String string = this.mFactorsTable.getModel().getValueAt(n2, 1).toString();
                    Object[] objectArray = new Object[]{string, "None", ""};
                    this.mDisplayMeansTableModel.addRow(objectArray);
                    this.mDisplayMeansTable.setRowSelectionInterval(this.mDisplayMeansTable.getRowCount() - 1, this.mDisplayMeansTable.getRowCount() - 1);
                    this.mFactorsTable.getSelectionModel().clearSelection();
                    ++var5_11;
                }
                this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            } else {
                if (this.mDisplayMeansTable.getSelectedRowCount() >= 1) {
                    void var5_13;
                    this.repaint();
                    int[] nArray = this.mDisplayMeansTable.getSelectedRows();
                    int n = nArray.length - 1;
                    while (var5_13 >= 0) {
                        String string = this.mDisplayMeansTableModel.getValueAt(nArray[var5_13], 0).toString();
                        String string2 = this.mDisplayMeansTableModel.getValueAt(nArray[var5_13], 1).toString();
                        this.mDisplayMeansTableModel.removeRow(nArray[var5_13]);
                        this.removeKeyFromMap(string + string2 + nArray[var5_13]);
                        --var5_13;
                    }
                    this.mFactorsTable.getSelectionModel().setSelectionInterval(0, 0);
                }
                this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
            }
        }
    }

    @Override
    public void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        this.mDialogDataModel = dialogDataModel;
    }

    @Override
    public void saveTabState(DialogDataModel dialogDataModel) {
        for (int i = 0; i < this.mDisplayMeansTableModel.getRowCount(); ++i) {
            String string = this.mDisplayMeansTableModel.getValueAt(i, 0).toString();
            ISpssVariable iSpssVariable = this.convertIntoIspssVariable(string);
            for (int j = 0; j < this.mDisplayMeansTableModel.getColumnCount(); ++j) {
                if (j <= 1 || !this.mDisplayMeansTableModel.getValueAt(i, 1).toString().equals(this.getResString("IDS_GLM_EMMEANS_SIMPLE_STRING"))) continue;
                Object object = this.mDisplayMeansTableModel.getValueAt(i, 2);
                if (!iSpssVariable.getFormat().getFormatType().isNumericFormat()) continue;
                String string2 = String.valueOf(object);
                this.mDisplayMeansTableModel.setValueAt(string2.replace(this.mDecimalSeparator, '.'), i, 2);
            }
        }
        Vector<Vector> vector = this.mDisplayMeansTableModel.getDataVector();
        dialogDataModel.putObject("IDS_TABLE_MODEL", vector);
        dialogDataModel.putSerializableMap("IDS_MODELS", this.mMapOfModels);
    }

    @Override
    public String getDialogHelpID() {
        if (this.mGLM) {
            return "idh_idd_genlin_emmeans";
        }
        return "idh_idd_gee_emmeans";
    }

    @Override
    public void reset() {
        this.mFactorVector.removeAllElements();
        this.mVarValueLabels.clear();
        for (int i = this.mDisplayMeansTable.getRowCount() - 1; i >= 0; --i) {
            this.mDisplayMeansTableModel.removeRow(i);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JTableHeader jTableHeader = EMMeansTab.this.mFactorsTable.getTableHeader();
                EMMeansTab.this.mFactorsTable.setBackground(jTableHeader.getBackground());
            }
        });
        this.updateUI();
        this.setDefaults();
    }

    @Override
    public boolean validateTab() {
        return this.isValidate();
    }

    public boolean isValidate() {
        for (int i = 0; i < this.mDisplayMeansTable.getModel().getRowCount(); ++i) {
            for (int j = 0; j < this.mDisplayMeansTable.getModel().getColumnCount(); ++j) {
                VarAndVarValueLabels varAndVarValueLabels;
                TableCellEditor tableCellEditor = this.mDisplayMeansTable.getCellEditor();
                if (tableCellEditor != null) {
                    tableCellEditor.stopCellEditing();
                    this.mDisplayMeansTable.getSelectionModel().clearSelection();
                }
                if (j != 2 || !this.mDisplayMeansTable.getModel().getValueAt(i, 1).toString().equals(this.getResString("IDS_GLM_EMMEANS_SIMPLE_STRING"))) continue;
                ISpssVariable iSpssVariable = this.convertIntoIspssVariable(this.mDisplayMeansTable.getModel().getValueAt(i, 0).toString());
                if (this.mVarValueLabels.size() != this.mDisplayMeansTable.getModel().getRowCount()) {
                    this.createValueLabels(iSpssVariable);
                }
                if ((varAndVarValueLabels = this.mVarValueLabels.get(iSpssVariable.getName())) == null) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_EMMEANS_REF_CATE_MSG1"), VersionInfo.getAppVersionString());
                    return false;
                }
                String string = varAndVarValueLabels.getValue(this.mDisplayMeansTable.getModel().getValueAt(i, 2).toString());
                OBS oBS = new OBS();
                boolean bl = CellValueFormatter.stringToObs((String)string, (SPSS_Format)iSpssVariable.getFormat(), (OBS)oBS);
                if (string != null && string.length() == 0) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_EMMEANS_REF_CATE_MSG1"), VersionInfo.getAppVersionString());
                    this.mDisplayMeansTable.changeSelection(i, 2, false, false);
                    return false;
                }
                if (!bl) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_GLM_EMMEANS_REF_CATE_MSG2"), VersionInfo.getAppVersionString());
                    this.mDisplayMeansTable.changeSelection(i, 2, false, false);
                    return false;
                }
                if (string == null) {
                    string = this.mDisplayMeansTable.getModel().getValueAt(i, 2).toString();
                    oBS = new OBS();
                    CellValueFormatter.stringToObs((String)string, (SPSS_Format)iSpssVariable.getFormat(), (OBS)oBS);
                }
                if (this.includeMissingValue() || !iSpssVariable.isMissing(oBS)) continue;
                int n = SpssAlertOptionPane.showConfirmDialog((Window)this.mParent, this.getResString("ERR_GLM_EMMEANS_REF_CATE_MSG3"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION);
                if (n == 1) {
                    this.setUserMissingValueInclude();
                    return true;
                }
                this.mDisplayMeansTable.changeSelection(i, 2, false, false);
                return false;
            }
        }
        return true;
    }

    @Override
    protected void aboutToShowTab() {
        this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.validateTableData();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EMMeansTab.this.mFactorsTable.setBackground(Color.WHITE);
                if (EMMeansTab.this.mFactorsTable.getRowCount() < 1) {
                    EMMeansTab.this.mArrowButton.setEnabled(false);
                }
            }
        });
        this.mFactorsTable.setModel(new TableModel(this.mFactorVector));
        this.loadDisplayTable();
        this.getValueAtDisplayTable();
        this.isAdjustComboEnable();
        this.enableTab(this.tabIsEnabled());
        this.invalidate();
        this.revalidate();
    }

    private boolean tabIsEnabled() {
        boolean bl = this.mGLM ? !((GeneralizedLinearModelsDlg)this.mParent).mTypeOfModelTab.isMultinomialSelected() && !((GeneralizedLinearModelsDlg)this.mParent).mTypeOfModelTab.isOrdinalLogisticSelected() && !((GeneralizedLinearModelsDlg)this.mParent).mTypeOfModelTab.isOrdinalProbitSelected() : !((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab.isMultinomialSelected() && !((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab.isOrdinalLogisticSelected() && !((GeneralizedEstimatingEquationsDlg)this.mParent).mTypeOfModelTab.isOrdinalProbitSelected();
        return bl;
    }

    private void loadDataToFactorAndInteractions() {
        Object object;
        int n;
        int n2;
        this.mFactorVector.removeAllElements();
        this.mUnCheckedCVector.removeAllElements();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        for (int i = 0; i < PredictorsTab.getFactorsTargetListModel().getSize(); ++i) {
            vector.add(i, PredictorsTab.getFactorsTargetListModel().getElementAt(i).getName());
        }
        Vector<String> vector4 = new Vector<String>();
        for (n2 = 0; n2 < PredictorsTab.getCovariateTargetListModel().getSize(); ++n2) {
            vector4.add(n2, PredictorsTab.getCovariateTargetListModel().getElementAt(n2).getName());
        }
        n2 = 0;
        for (n = 0; n < ModelTab.getTargetListModel().getSize(); ++n) {
            String string;
            String string2 = ModelTab.getTargetListModel().getElementAt(n).toString();
            if (!string2.contains("(")) {
                object = new StringTokenizer(ModelTab.getTargetListModel().getElementAt(n).toString(), "*");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    n2 = 0;
                    string = ((StringTokenizer)object).nextToken();
                    try {
                        if (vector4.contains(string)) {
                            n2 = 1;
                            continue;
                        }
                        vector2.addElement(string);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        n2 = 0;
                    }
                }
                if (n2 != 0) continue;
                this.mFactorVector.addElement(string2);
                this.mUnCheckedCVector.add("CHK");
                continue;
            }
            if (!string2.contains("(")) continue;
            object = new StringTokenizer(ModelTab.getTargetListModel().getElementAt(n).toString(), "*()");
            while (((StringTokenizer)object).hasMoreTokens()) {
                string = ((StringTokenizer)object).nextToken();
                vector3.add(string);
            }
        }
        n = PredictorsTab.getFactorsTargetListModel().getSize();
        if (!vector2.containsAll(vector)) {
            for (int i = 0; i < n; ++i) {
                object = PredictorsTab.getFactorsTargetListModel().getElementAt(i).getName();
                if (this.mFactorVector.contains(object)) continue;
                if (vector3.size() > 0) {
                    if (vector3.contains(object)) continue;
                    if (vector2.size() > 0) {
                        if (vector2.contains(object)) continue;
                        this.mFactorVector.add((String)object);
                        this.mUnCheckedCVector.add("UNCHK");
                        continue;
                    }
                    this.mFactorVector.add((String)object);
                    this.mUnCheckedCVector.add("UNCHK");
                    continue;
                }
                if (vector2.size() > 0) {
                    if (vector2.contains(object)) continue;
                    this.mFactorVector.add((String)object);
                    this.mUnCheckedCVector.add("UNCHK");
                    continue;
                }
                this.mFactorVector.add((String)object);
                this.mUnCheckedCVector.add("UNCHK");
            }
        }
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.initVars();
        this.setDefaults();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = UIToolDialogUtil.getStandardDialogInsets();
        Insets insets2 = new Insets(insets.top, insets.left, 0, 0);
        this.mFactorsLabel = DialogUtil.createLabel(this.mParent, "IDS_GLM_EMMEANS_FACTORS_INTERACTIONS_LABEL");
        this.mFactorsLabel.setLabelFor(this.mFactorsTable);
        DialogUtil.addUsingGBL(this, this.mFactorsLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.fill = 1;
        insets2.set(0, insets.left, n2, 0);
        DialogUtil.addUsingGBL(this, this.mFactorsScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        JComponent[] jComponentArray = new JComponent[]{this.mComputeMeansResponseRadio, this.mComputeMeansLinearRadio};
        this.mScalePanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_GLM_EMMEANS_SCALE_TITLE"));
        this.mGroup = DialogUtil.createButtonGroup(this.mScalePanel);
        insets2.set(0, insets.left, n2, 0);
        DialogUtil.addUsingGBL(this, this.mScalePanel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        insets2.set(0, insets.left, 0, 0);
        DialogUtil.addUsingGBL(this, this.mAdjustmentLabel, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        insets2.set(0, insets.left, n2, 0);
        DialogUtil.addUsingGBL(this, this.mAdjustmentCombo, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        n = 10;
        Insets insets3 = DialogUtil.getArrowButtonInsets();
        insets2.set(insets3.top, insets3.left, insets3.bottom, insets3.right);
        DialogUtil.addUsingGBL(this, this.setupButtonPanel(), gridBagConstraints, 1, 1, 1, 1, n, insets2);
        this.mDisplayMeanLabel = DialogUtil.createLabel(this.mParent, "IDS_GLM_EMMEANS_DISPLAY_MEANS_LABEL");
        this.mDisplayMeanLabel.setLabelFor(this.mDisplayMeansTable);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 23;
        insets2.set(insets.top, 0, 0, insets.right);
        DialogUtil.addUsingGBL(this, this.mDisplayMeanLabel, gridBagConstraints, 2, 0, 3, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets2.set(0, 0, n2, insets.right);
        DialogUtil.addUsingGBL(this, this.mDisplayScrollPane, gridBagConstraints, 2, 1, 3, 3, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets2.set(0, 0, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(this, this.mDisplayMeanCheck, gridBagConstraints, 2, 4, 3, 1, n, insets2);
        this.setFocusTraversalPolicy();
    }

    public void loadDisplayTable() {
        Vector vector = (Vector)this.mDialogDataModel.getObject("IDS_TABLE_MODEL");
        HashMap<String, SerializableObject> hashMap = this.mDialogDataModel.getSerializableMap("IDS_MODELS");
        if (vector != null) {
            Vector<String> vector2 = new Vector<String>();
            vector2.add(this.getResString("IDS_GLM_EMMEANS_DISPLAY_TERM_COL"));
            vector2.add(this.getResString("IDS_GLM_EMMEANS_DISPLAY_CONTRAST_COL"));
            vector2.add(this.getResString("IDS_GLM_EMMEANS_DISPLAY_CATEGORY_COL"));
            this.mDisplayMeansTableModel.setDataVector(vector, vector2);
            for (int i = 0; i < this.mDisplayMeansTableModel.getRowCount(); ++i) {
                String string = this.mDisplayMeansTableModel.getValueAt(i, 0).toString();
                ISpssVariable iSpssVariable = this.convertIntoIspssVariable(string);
                for (int j = 0; j < this.mDisplayMeansTableModel.getColumnCount(); ++j) {
                    if (j <= 1 || !this.mDisplayMeansTableModel.getValueAt(i, 1).toString().equals(this.getResString("IDS_GLM_EMMEANS_SIMPLE_STRING"))) continue;
                    Object object = this.mDisplayMeansTableModel.getValueAt(i, 2);
                    if (!iSpssVariable.getFormat().getFormatType().isNumericFormat()) continue;
                    String string2 = String.valueOf(object);
                    if (this.mDecimalSeparator == '.') continue;
                    this.mDisplayMeansTableModel.setValueAt(string2.replace('.', this.mDecimalSeparator), i, 2);
                }
            }
        }
        if (hashMap != null) {
            this.mMapOfModels = hashMap;
            this.mDisplayMeansTable.setModel(this.mDisplayMeansTableModel);
            this.mDisplayMeansTable.getColumnModel().getColumn(1).setCellRenderer(this.mContrastRenderer);
            this.mDisplayMeansTable.getColumnModel().getColumn(1).setCellEditor(this.mContrastEditor);
            this.mDisplayMeansTable.getColumnModel().getColumn(2).setCellRenderer(this.mCategoryRenderer);
            this.mDisplayMeansTable.getColumnModel().getColumn(2).setCellEditor(this.mCategoryEditor);
        }
    }

    private void setDefaults() {
        this.mComputeMeansResponseRadio.setSelected(true);
        this.mAdjustmentLabel.setEnabled(false);
        this.mAdjustmentCombo.setEnabled(false);
        this.mAdjustmentCombo.setSelectedIndex(0);
        this.mByButton.setEnabled(false);
        this.mArrowButton.setEnabled(false);
        this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mDisplayMeanCheck.setSelected(false);
    }

    private void initVars() {
        this.mRow = 0;
        this.mFactorVector = new Vector();
        this.mUnCheckedCVector = new Vector();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("");
        this.mMapOfModels = new HashMap();
        this.mFactorsTable = new PlainTable(new TableModel(this.mFactorVector));
        this.mFactorsTable.getSelectionModel().addListSelectionListener(this);
        this.mFactorsTable.setDefaultRenderer(Object.class, new TableRenderer());
        this.mFactorsTable.setPreferredScrollableViewportSize(new Dimension(120, 160));
        this.mFactorsTable.setRowHeight(100, 100);
        this.mFactorsTable.getTableHeader().setReorderingAllowed(false);
        this.mFactorsTable.getTableHeader().setResizingAllowed(true);
        this.mFactorsTable.setShowGrid(false);
        this.mFactorsTable.setGridColor(Color.darkGray);
        this.mFactorsTable.getTableHeader().setReorderingAllowed(false);
        this.mFactorsTable.addFocusListener(this);
        this.mFactorsScrollPane = new JScrollPane(this.mFactorsTable);
        this.mFactorsScrollPane.setHorizontalScrollBarPolicy(30);
        this.mFactorsScrollPane.setVerticalScrollBarPolicy(20);
        Vector vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        vector2.add(this.getResString("IDS_GLM_EMMEANS_DISPLAY_TERM_COL"));
        vector2.add(this.getResString("IDS_GLM_EMMEANS_DISPLAY_CONTRAST_COL"));
        vector2.add(this.getResString("IDS_GLM_EMMEANS_DISPLAY_CATEGORY_COL"));
        this.mDisplayMeansTableModel = new DefaultTableModel(vector, vector2){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 != 0;
            }
        };
        this.mDisplayMeansTable = new PlainTable(this.mDisplayMeansTableModel);
        this.mDisplayMeansTable.setPreferredScrollableViewportSize(new Dimension(350, 400));
        this.mDisplayMeansTable.setColumnSelectionAllowed(true);
        this.mDisplayMeansTable.setRowSelectionAllowed(true);
        this.mDisplayMeansTable.setRowHeight(100, 100);
        this.mDisplayMeansTable.getTableHeader().setReorderingAllowed(false);
        this.mDisplayMeansTable.getTableHeader().setResizingAllowed(true);
        this.mDisplayMeansTable.setGridColor(Color.darkGray);
        this.mDisplayMeansTable.getTableHeader().setReorderingAllowed(false);
        this.mDisplayMeansTable.addFocusListener(this);
        this.mDisplayMeansTable.getSelectionModel().addListSelectionListener(this);
        this.mDisplayMeansTable.setDefaultRenderer(Object.class, new DisplayTableRenderer());
        this.mDisplayScrollPane = new JScrollPane(this.mDisplayMeansTable);
        this.mDisplayScrollPane.setHorizontalScrollBarPolicy(31);
        this.mDisplayScrollPane.setVerticalScrollBarPolicy(20);
        this.mArrowButton = new ComponentsArrowButton();
        this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerComponents(this.mFactorsTable, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerComponents(this.mDisplayMeansTable, SpssArrowButton.ButtonOrientation.left);
        this.mArrowButton.addActionListener(this);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_GLM_EMMEANS_BY_BUTTON");
        this.mByButton = new JButton(toggleButtonAction);
        this.mByButton.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_GLM_EMMEANS_COMPUTE_FOR_RESPONSE_RADIO");
        this.mComputeMeansResponseRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_GLM_EMMEANS_COMPUTE_FOR_LINEAR_RADIO");
        this.mComputeMeansLinearRadio = new JRadioButton(toggleButtonAction);
        this.mAdjustmentCombo = new JComboBox<String>(this.getResStringArray("IDS_GLM_EMMEANS_ADJUSTMENT_COMBO_VALUES"));
        this.mAdjustmentCombo.setAction(new ComboboxAction(this.mParent, ADJUSTMENT_COMBO));
        this.mAdjustmentLabel = DialogUtil.createLabel(this.mParent, "IDS_GLM_EMMEANS_ADJUSTMENT_LABEL");
        this.mAdjustmentLabel.setLabelFor(this.mAdjustmentCombo);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_GLM_EMMEANS_DISPLAY_MEAN_CHECK");
        this.mDisplayMeanCheck = new JCheckBox(toggleButtonAction);
        ComboboxAction comboboxAction = new ComboboxAction(this.mParent, CATEGORY_CHOICE);
        this.mCategoryCombo = new FloatComboBox();
        this.mCategoryCombo.setModel((ComboBoxModel)new GLMComboBoxModel(arrayList.toArray(), this.mDisplayMeansTable));
        this.mCategoryCombo.setMaximumRowCount(5);
        this.mCategoryCombo.setAction((Action)comboboxAction);
        this.mCategoryCombo.addKeyListener((KeyListener)this);
        this.mCategoryCombo.setEnabled(false);
        JComboBox jComboBox = new JComboBox();
        comboboxAction = new ComboboxAction(this.mParent, CONTRAST_CHOICE);
        jComboBox.setModel(new GLMComboBoxModel(arrayList.toArray(), this.mDisplayMeansTable));
        jComboBox.setMaximumRowCount(5);
        jComboBox.addItemListener(this);
        jComboBox.setAction(comboboxAction);
        this.mContrastRenderer = new ContrastCellRenderer();
        this.mContrastEditor = new ContrastCellEditor(jComboBox);
        this.mDisplayMeansTable.getColumnModel().getColumn(1).setCellRenderer(this.mContrastRenderer);
        this.mDisplayMeansTable.getColumnModel().getColumn(1).setCellEditor(this.mContrastEditor);
        this.mCategoryRenderer = new CategoryCellRenderer();
        this.mCategoryEditor = new CategoryCellEditor(this.mCategoryCombo);
        this.mDisplayMeansTable.getColumnModel().getColumn(2).setCellRenderer(this.mCategoryRenderer);
        this.mDisplayMeansTable.getColumnModel().getColumn(2).setCellEditor(this.mCategoryEditor);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        };
        this.mDisplayMeansTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "tabOut");
        this.mDisplayMeansTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 1), "tabIn");
        this.mDisplayMeansTable.getActionMap().put("tabIn", abstractAction2);
        this.mDisplayMeansTable.getActionMap().put("tabOut", abstractAction);
        this.mFactorsTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "tabOut");
        this.mFactorsTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 1), "tabIn");
        this.mFactorsTable.getActionMap().put("tabIn", abstractAction2);
        this.mFactorsTable.getActionMap().put("tabOut", abstractAction);
        this.mDisplayMeansTable.setRowHeight(20);
        if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
            this.mDisplayMeansTable.setRowHeight(this.mDisplayMeansTable.getRowHeight() + 5);
        }
        this.mSymbol = new DecimalFormatSymbols(UIToolResUtil.getSPSSLocale());
        this.mDecimalSeparator = this.mSymbol.getDecimalSeparator();
    }

    private JPanel setupButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 10;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 0, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, this.mByButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mFactorsTable);
        vector.add(this.mArrowButton);
        vector.add(this.mByButton);
        vector.add(this.mDisplayMeansTable);
        vector.add(this.mGroup);
        vector.add(this.mAdjustmentCombo);
        vector.add(this.mDisplayMeanCheck);
        this.setComponentOrder(vector);
    }

    private void removeKeyFromMap(String string) {
        this.mMapOfModels.remove(string.trim());
    }

    public String getFirstPartOfCategoryCombo(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (stringTokenizer.hasMoreElements()) {
            return stringTokenizer.nextElement().toString();
        }
        return null;
    }

    private ISpssVariable convertIntoIspssVariable(String string) {
        Vector<SpssVariable> vector = this.getFactorInteractionList();
        for (SpssVariable spssVariable : vector) {
            if (!spssVariable.getName().equals(string)) continue;
            return spssVariable;
        }
        return null;
    }

    private ArrayList<String> getMissingValues(ISpssVariable iSpssVariable) {
        SPSS_Format sPSS_Format = iSpssVariable.getFormat();
        FormatType formatType = sPSS_Format.getFormatType();
        boolean bl = formatType.isStringFormat() || formatType.isDateOrTimeFormat();
        IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
        int n = 0;
        Object[] objectArray = new String[iValueLabelMap.size()];
        Set set = iValueLabelMap.getValueLabelEntries();
        for (Map.Entry entry : set) {
            OBS oBS = (OBS)entry.getKey();
            String string = (String)entry.getValue();
            if (oBS.isEmpty()) continue;
            String string2 = bl ? oBS.getString().trim() : CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)sPSS_Format);
            objectArray[n] = string2 + " " + string;
            ++n;
        }
        Arrays.sort(objectArray);
        ArrayList arrayList = new ArrayList();
        arrayList.add("");
        arrayList.addAll(Arrays.asList(objectArray));
        if (arrayList.size() > 1) {
            arrayList.remove(0);
        }
        return arrayList;
    }

    private void createValueLabels(ISpssVariable iSpssVariable) {
        boolean bl = this.includeMissingValue();
        this.mValueLabels.clear();
        VarAndVarValueLabels varAndVarValueLabels = this.mVarValueLabels.get(iSpssVariable.getName());
        if (varAndVarValueLabels != null) {
            this.mValueLabels = this.mVarValueLabels.get(iSpssVariable.getName()).getValueLabels();
            if (this.mValueLabels.size() == 0) {
                this.mValueLabels.add(" ");
            }
            return;
        }
        varAndVarValueLabels = new VarAndVarValueLabels(iSpssVariable.getName());
        IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
        Set set = iValueLabelMap.getValueLabelEntries();
        SPSS_Format sPSS_Format = iSpssVariable.getFormat();
        FormatType formatType = sPSS_Format.getFormatType();
        boolean bl2 = formatType.isStringFormat();
        if (set.size() > 0) {
            for (Map.Entry entry : set) {
                String string;
                OBS oBS = (OBS)entry.getKey();
                if (!bl && iSpssVariable.isMissing(oBS)) continue;
                StringBuffer stringBuffer = new StringBuffer();
                if (bl2) {
                    string = CharacterUtil.rightTrim((String)oBS.getString());
                    stringBuffer.append(string);
                } else {
                    string = CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)sPSS_Format);
                    stringBuffer.append(string);
                }
                stringBuffer.append(" ");
                stringBuffer.append((String)entry.getValue());
                this.mValueLabels.add(stringBuffer.toString());
                varAndVarValueLabels.addValueLabel(stringBuffer.toString(), string);
            }
            this.mVarValueLabels.put(iSpssVariable.getName(), varAndVarValueLabels);
        }
        if (this.mValueLabels.size() == 0) {
            this.mValueLabels.add(" ");
            this.mVarValueLabels.put(iSpssVariable.getName(), varAndVarValueLabels);
        }
    }

    private Vector<SpssVariable> getFactorInteractionList() {
        Vector<SpssVariable> vector = new Vector<SpssVariable>();
        for (int i = 0; i < PredictorsTab.getFactorsTargetListModel().getSize(); ++i) {
            vector.add((SpssVariable)PredictorsTab.getFactorsTargetListModel().getElementAt(i));
        }
        return vector;
    }

    private StringBuffer getPadjustCommand() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(" PADJUST=");
        if (this.mAdjustmentCombo.getSelectedIndex() == 0) {
            stringBuffer.append("LSD");
        }
        if (this.mAdjustmentCombo.getSelectedIndex() == 1) {
            stringBuffer.append("BONFERRONI");
        }
        if (this.mAdjustmentCombo.getSelectedIndex() == 2) {
            stringBuffer.append("SEQBONFERRONI");
        }
        if (this.mAdjustmentCombo.getSelectedIndex() == 3) {
            stringBuffer.append("SIDAK");
        }
        if (this.mAdjustmentCombo.getSelectedIndex() == 4) {
            stringBuffer.append("SEQSIDAK");
        }
        return stringBuffer;
    }

    private StringBuffer getContrastCommand(int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = this.mDisplayMeansTable.getModel().getValueAt(n, 1).toString();
        if (string.equals(this.getResString("IDS_GLM_EMMEANS_PAIRWISE_STRING"))) {
            stringBuffer.append(" CONTRAST=PAIRWISE");
        }
        if (string.equals(this.getResString("IDS_GLM_EMMEANS_DEVIATION_STRING"))) {
            stringBuffer.append(" CONTRAST=DEVIATION");
        }
        if (string.equals(this.getResString("IDS_GLM_EMMEANS_DIFFERENCE_STRING"))) {
            stringBuffer.append(" CONTRAST=DIFFERENCE");
        }
        if (string.equals(this.getResString("IDS_GLM_EMMEANS_HELMERT_STRING"))) {
            stringBuffer.append(" CONTRAST=HELMERT");
        }
        if (string.equals(this.getResString("IDS_GLM_EMMEANS_REPEATED_STRING"))) {
            stringBuffer.append(" CONTRAST=REPEATED");
        }
        if (string.equals(this.getResString("IDS_GLM_EMMEANS_POLYNOMIAL_STRING"))) {
            stringBuffer.append(" CONTRAST=POLYNOMIAL");
        }
        return stringBuffer;
    }

    private boolean checkStringVariable(String string) {
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            LocallyUniqueId locallyUniqueId = ((DataFrame)spssFrame).getDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            int n = iSpssDataSrc.columnCount();
            for (int i = 0; i < n; ++i) {
                ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
                String string2 = iSpssVariable.getName();
                if (!string.equals(string2) || iSpssVariable.getType() == 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean includeMissingValue() {
        DialogDataModel dialogDataModel = this.mGLM ? ((GeneralizedLinearModelsDlg)this.mParent).getDialogDataModel() : ((GeneralizedEstimatingEquationsDlg)this.mParent).getDialogDataModel();
        if (dialogDataModel != null) {
            Boolean bl = dialogDataModel.getBoolean("IDS_GLM_OPTIONS_INCLUDE_RADIO");
            return bl != null && bl != false;
        }
        return false;
    }

    private void setUserMissingValueInclude() {
        DialogDataModel dialogDataModel = this.mGLM ? ((GeneralizedLinearModelsDlg)this.mParent).getDialogDataModel() : ((GeneralizedEstimatingEquationsDlg)this.mParent).getDialogDataModel();
        if (dialogDataModel != null) {
            dialogDataModel.putBoolean("IDS_GLM_OPTIONS_INCLUDE_RADIO", true);
            dialogDataModel.putBoolean("IDS_GLM_OPTIONS_EXCLUDE_RADIO", false);
        }
    }

    public boolean tableHasColumnName(String string) {
        int n = this.mDisplayMeansTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.mDisplayMeansTableModel.getValueAt(i, 0).toString())) continue;
            return true;
        }
        return false;
    }

    private class VarAndVarValueLabels {
        private String mVarName;
        private Hashtable<String, String> mValueLabelAndValueTable = new Hashtable();
        private ArrayList<String> mValueLabels = new ArrayList();

        public VarAndVarValueLabels(String string) {
            this.mVarName = string;
        }

        public void addValueLabel(String string, String string2) {
            this.mValueLabelAndValueTable.put(string, string2);
            this.mValueLabels.add(string);
        }

        public ArrayList<String> getValueLabels() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : this.mValueLabels) {
                arrayList.add(string);
            }
            return arrayList;
        }

        public String getValue(String string) {
            return this.mValueLabelAndValueTable.get(string);
        }

        public String getVarName() {
            return this.mVarName;
        }
    }

    class CategoryCellEditor
    extends DefaultCellEditor {
        FloatComboBox comboToHold;

        public CategoryCellEditor(FloatComboBox floatComboBox) {
            super((JComboBox<?>)floatComboBox);
            this.comboToHold = floatComboBox;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string = EMMeansTab.this.mDisplayMeansTableModel.getValueAt(n, 0).toString();
            String string2 = EMMeansTab.this.mDisplayMeansTableModel.getValueAt(n, 1).toString();
            ISpssVariable iSpssVariable = EMMeansTab.this.convertIntoIspssVariable(string);
            if (iSpssVariable == null) {
                return null;
            }
            if (iSpssVariable.getFormat().getFormatType().isNumericFormat()) {
                this.comboToHold.setDocument(true);
            } else {
                this.comboToHold.setDocument(false);
            }
            if (string2.equals(EMMeansTab.this.getResString("IDS_GLM_EMMEANS_SIMPLE_STRING"))) {
                EMMeansTab.this.createValueLabels(iSpssVariable);
                this.comboToHold.setEnabled(true);
                String string3 = (string + string2 + n).trim();
                if (EMMeansTab.this.mMapOfModels.containsKey(string3)) {
                    EMMeansTab.this.mMapOfModels.remove(string3);
                }
                EMMeansTab.this.mMapOfModels.put(string3, new GLMComboBoxModel(EMMeansTab.this.mValueLabels.toArray(), EMMeansTab.this.mDisplayMeansTable));
                this.comboToHold.setModel((ComboBoxModel)((GLMComboBoxModel)EMMeansTab.this.mMapOfModels.get(string3)));
                if (ComponentState.isBtdRtlOrLtr() && object != null && object.toString().length() > 0) {
                    ((GLMComboBoxModel)this.comboToHold.getModel()).setSelectedItem(ComponentState.prepareStringForBidiRendering((String)object.toString()), n, 2);
                } else {
                    ((GLMComboBoxModel)this.comboToHold.getModel()).setSelectedItem(object.toString(), n, 2);
                }
                if (this.comboToHold.getModel().getSize() == 1 && this.comboToHold.getModel().getElementAt(0).equals("")) {
                    this.comboToHold.setEditable(true);
                } else {
                    this.comboToHold.setEditable(false);
                }
            } else {
                ((GLMComboBoxModel)this.comboToHold.getModel()).setSelectedItem("", n, 2);
                this.comboToHold.setEditable(false);
                this.comboToHold.setEnabled(false);
            }
            EMMeansTab.this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            return this.comboToHold;
        }
    }

    class CategoryCellRenderer
    extends DefaultTableCellRenderer {
        CategoryCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Color color = EMMeansTab.this.mArrowButton.getBackground();
            String string = EMMeansTab.this.mDisplayMeansTableModel.getValueAt(n, 1).toString();
            String string2 = EMMeansTab.this.mDisplayMeansTableModel.getValueAt(n, 0).toString();
            if (ComponentState.isBtdRtlOrLtr()) {
                if (string != null && string.length() > 0) {
                    string = ComponentState.removeBidiDirectionMarks((String)string);
                }
                if (string2 != null && string2.length() > 0) {
                    string2 = ComponentState.removeBidiDirectionMarks((String)string2);
                }
            }
            if (object != null) {
                if (!string.equals(EMMeansTab.this.getResString("IDS_GLM_EMMEANS_SIMPLE_STRING"))) {
                    if (ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0) {
                        super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2);
                    } else {
                        super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    }
                    this.setBackground(color);
                    this.setText("");
                } else {
                    this.setBackground(Color.WHITE);
                    super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    VarAndVarValueLabels varAndVarValueLabels = (VarAndVarValueLabels)EMMeansTab.this.mVarValueLabels.get(string2);
                    if (varAndVarValueLabels != null) {
                        String string3 = varAndVarValueLabels.getValue(object.toString());
                        if (string3 != null) {
                            this.setText(string3);
                        } else {
                            this.setText(object.toString());
                        }
                    } else {
                        this.setText(object.toString());
                    }
                }
            }
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }
    }

    class ContrastCellRenderer
    extends DefaultTableCellRenderer {
        ContrastCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null) {
                this.setText(object.toString());
            }
            if (EMMeansTab.this.mRow == n) {
                if (EMMeansTab.this.mDisplayMeansTableModel.getValueAt(n, n2 + 1) == null || EMMeansTab.this.mDisplayMeansTableModel.getValueAt(n, n2 + 1).toString().equals("")) {
                    EMMeansTab.this.mDisplayMeansTableModel.setValueAt("", n, n2 + 1);
                }
                if (object != null && !object.toString().equals(EMMeansTab.this.getResString("IDS_GLM_EMMEANS_SIMPLE_STRING"))) {
                    EMMeansTab.this.mDisplayMeansTableModel.setValueAt("", n, n2 + 1);
                }
            }
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }
    }

    class ContrastCellEditor
    extends DefaultCellEditor {
        JComboBox mComboToHold;

        public ContrastCellEditor(JComboBox jComboBox) {
            super(jComboBox);
            this.mComboToHold = jComboBox;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string = EMMeansTab.this.mDisplayMeansTableModel.getValueAt(n, 0).toString();
            if (string.contains("*")) {
                EMMeansTab.this.mRow = n;
                this.mComboToHold.setModel(new GLMComboBoxModel(EMMeansTab.this.mParent.getResStringArray("IDS_GLM_EMMEANS_PAIRWISE_COMBO_VALUES"), EMMeansTab.this.mDisplayMeansTable));
                if (ComponentState.isBtdRtlOrLtr() && object != null && object.toString().length() > 0) {
                    ((GLMComboBoxModel)this.mComboToHold.getModel()).setSelectedItem(ComponentState.prepareStringForBidiRendering((String)object.toString()), n, 1);
                } else {
                    ((GLMComboBoxModel)this.mComboToHold.getModel()).setSelectedItem(object.toString(), n, 1);
                }
                EMMeansTab.this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            } else {
                EMMeansTab.this.mRow = n;
                this.mComboToHold.setModel(new GLMComboBoxModel(EMMeansTab.this.mParent.getResStringArray("IDS_GLM_EMMEANS_COMBO_VALUES"), EMMeansTab.this.mDisplayMeansTable));
                if (ComponentState.isBtdRtlOrLtr() && object != null && object.toString().length() > 0) {
                    ((GLMComboBoxModel)this.mComboToHold.getModel()).setSelectedItem(ComponentState.prepareStringForBidiRendering((String)object.toString()), n, 1);
                } else {
                    ((GLMComboBoxModel)this.mComboToHold.getModel()).setSelectedItem(object.toString(), n, 1);
                }
                EMMeansTab.this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            }
            return this.mComboToHold;
        }
    }

    class FactorTableVar {
        SpssVariable name;

        public FactorTableVar(SpssVariable spssVariable) {
            this.name = spssVariable;
        }

        public SpssVariable getSpssVar() {
            return this.name;
        }
    }

    class TableModel
    extends AbstractTableModel {
        private Vector<String> model;

        public TableModel(Vector<String> vector) {
            this.model = vector;
        }

        @Override
        public int getRowCount() {
            return this.model.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 1) {
                return this.model.get(n);
            }
            return "";
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return EMMeansTab.this.getResString("IDS_GLM_EMMEANS_M_COL");
                }
                case 1: {
                    return EMMeansTab.this.getResString("IDS_GLM_EMMEANS_TERM_COL");
                }
            }
            return "";
        }

        public Vector<String> getData() {
            return this.model;
        }

        public void setData(Vector<String> vector) {
            this.model = vector;
        }
    }

    class TableRenderer
    extends DefaultTableCellRenderer {
        JLabel label;

        TableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.label = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? (JLabel)super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (n2 == 0) {
                if (((String)EMMeansTab.this.mUnCheckedCVector.get(n)).equals("CHK")) {
                    URL uRL = EMMeansTab.this.getResImageURL("IDS_GLM_EMMEANS_CHEKED_IMAGE_KEY");
                    this.label.setIcon(new ImageIcon(uRL));
                } else {
                    URL uRL = EMMeansTab.this.getResImageURL("IDS_GLM_EMMEANS_UNCHEKED_IMAGE_KEY");
                    this.label.setIcon(new ImageIcon(uRL));
                }
                this.label.setHorizontalAlignment(0);
            } else if (n2 == 1) {
                this.label.setIcon(null);
                if (ComponentState.isBtdRtlOrLtr() && object != null && object.toString().length() > 0) {
                    this.label.setText(ComponentState.prepareStringForBidiRendering((String)object.toString()));
                } else {
                    this.label.setText(object.toString());
                }
                this.label.setHorizontalAlignment(2);
            } else {
                this.label.setIcon(null);
            }
            return this.label;
        }
    }

    class DisplayTableRenderer
    extends DefaultTableCellRenderer {
        JLabel label;

        DisplayTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.label = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? (JLabel)super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jTable.getTableHeader().setFont(this.getFont().deriveFont(1));
            if (n2 == 0) {
                this.setBackground(jTable.getTableHeader().getBackground());
                this.setForeground(jTable.getTableHeader().getForeground());
            }
            return this.label;
        }
    }
}

