/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.desc_stats.ratio;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.ACRWidget;
import com.spss.java_client.ui.controls.BasicACREvent;
import com.spss.java_client.ui.controls.BasicACRWidget;
import com.spss.java_client.ui.controls.IBasicACRListener;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RatioStatistics
extends BaseSubDialog
implements IBasicACRListener,
DocumentListener,
FocusListener {
    static final String MEDIAN_KEY = "IDS_RATIO_STAT_MEDIAN_CHECK";
    static final String MEAN_KEY = "IDS_RATIO_STAT_MEAN_CHECK";
    static final String WEIGHTED_MEAN_KEY = "IDS_RATIO_STAT_WEIGHTED_MEAN_CHECK";
    static final String CONFIDENCE_INTERVAL_KEY = "IDS_RATIO_STAT_CONF_INTERVAL_CHECK";
    static final String AAD_KEY = "IDS_RATIO_STAT_AAD_CHECK";
    static final String COD_KEY = "IDS_RATIO_STAT_COD_CHECK";
    static final String PRD_KEY = "IDS_RATIO_STAT_PRD_CHECK";
    static final String MEDIAN_CENTERED_COV_KEY = "IDS_RATIO_STAT_MEDIAN_CENTERED_COV_CHECK";
    static final String MEAN_CENTERED_COV_KEY = "IDS_RATIO_STAT_MEAN_CENTERED_COV_CHECK";
    static final String STANDARD_DEVIATION_KEY = "IDS_RATIO_STAT_STD_DEV_CHECK";
    static final String RANGE_KEY = "IDS_RATIO_STAT_RANGE_CHECK";
    static final String MINIMUM_KEY = "IDS_RATIO_STAT_MINIMUM_CHECK";
    static final String MAXIMUM_KEY = "IDS_RATIO_STAT_MAXIMUM_CHECK";
    static String BASIC_ACRWIDGET_ACTION_KEY = "IDS_BASIC_ACRWIDGET";
    private static final String LOW_PROPORTION_KEY = "IDS_RATIO_STAT_LOW_PROP_LABEL";
    private static final String RATIO_STAT_PAIRS_KEY = "IDS_RATIO_STAT_PAIRS_LABEL";
    private static final String RATIO_STAT_PER_OF_MEDIAN_KEY = "IDS_RATIO_STAT_PER_OF_MEDIAN_LABEL";
    private static final String HIGH_PROPORTION_KEY = "IDS_RATIO_STAT_HIGH_PROP_LABEL";
    private static final String PERCENTAGES_KEY = "IDS_RATIO_STAT_PERCENTAGES_LABEL";
    private static Boolean mSaved = false;
    private static final String CONF_INT_PER_STATE_KEY = "IDS_CONF_INT_PER";
    private static String mDefaultConfInterval = "95";
    private JPanel mCentTendPanel;
    private JPanel mDispersionPanel;
    private JPanel mConcIndexPanel;
    private JCheckBox mMedianCheck;
    private JCheckBox mMeanCheck;
    private JCheckBox mWeightedMeanCheck;
    private SpssButtonGroup mCentralTendButtonGroup;
    private JCheckBox mConfIntCheck;
    private FloatTextField mConfIntEdit;
    private JLabel mPercentLabel;
    private JCheckBox mAadCheck;
    private JCheckBox mCodCheck;
    private JCheckBox mPrdCheck;
    private JCheckBox mMedCenteredCheck;
    private JCheckBox mMeanCenteredCheck;
    private JCheckBox mStdDeviationCheck;
    private JCheckBox mRangeCheck;
    private JCheckBox mMinCheck;
    private JCheckBox mMaxCheck;
    private JLabel mPairsLabel;
    private JLabel mLowPropLabel;
    private JLabel mHighPropLabel;
    private JLabel mPercentagesLabel;
    private JLabel mPerOfMedLabel;
    private FloatTextField mLowPropEdit;
    private FloatTextField mHighPropEdit;
    private FloatTextField mRatioWithinEdit;
    private BasicACRWidget mRatioBetACRWidget;
    private ACRWidget mRatioWithinACRWidget;

    public RatioStatistics(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_RATIO_STAT"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_rato_sta";
    }

    @Override
    public boolean continuePressed() {
        boolean bl = false;
        if (!this.showWarning()) {
            bl = true;
        }
        return bl;
    }

    public static Boolean getSavedFlag() {
        return mSaved;
    }

    public static void setSavedFlag(Boolean bl) {
        mSaved = bl;
    }

    @Override
    public void acrEventOccured(BasicACREvent basicACREvent) {
        int n;
        BasicACREvent.EventType eventType = basicACREvent.getEventType();
        if (eventType.equals((Object)BasicACREvent.EventType.addButtonPress)) {
            String string = this.mLowPropEdit.getText();
            String string2 = this.mHighPropEdit.getText();
            if (Double.parseDouble(string) == 0.0 && Double.parseDouble(string2) == 0.0) {
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_RATIO_STAT_LOW_HIGH_PROP_OUTOFRANGE_WARNING"), VersionInfo.getAppVersionString());
                this.mHighPropEdit.setSelectionStart(0);
                this.mHighPropEdit.setSelectionEnd(this.mHighPropEdit.getText().length());
                this.mHighPropEdit.requestFocusInWindow();
                return;
            }
            if (!(Double.parseDouble(string2) >= Double.parseDouble(string))) {
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_RATIO_STAT_LOW_HIGH_PROP_WARNING"), VersionInfo.getAppVersionString());
                this.mLowPropEdit.setSelectionStart(0);
                this.mLowPropEdit.setSelectionEnd(this.mLowPropEdit.getText().length());
                this.mLowPropEdit.requestFocusInWindow();
                return;
            }
            String string3 = string + " - " + string2;
            for (int i = 0; i < this.mRatioBetACRWidget.getListItemCount(); ++i) {
                Object object = this.mRatioBetACRWidget.getListItemAt(i);
                if (!string3.equals(object)) continue;
                this.mRatioBetACRWidget.getList().requestFocus();
                this.mRatioBetACRWidget.getList().setSelectedIndex(i);
                return;
            }
            if (this.mRatioBetACRWidget.getListSelectedIndex() > -1) {
                this.mRatioBetACRWidget.clearItemListSelection();
            }
            this.mRatioBetACRWidget.addListItemAt(this.mRatioBetACRWidget.getListItemCount(), string3);
            this.mRatioBetACRWidget.requestFocusInWindow();
            this.mLowPropEdit.setText("");
            this.mHighPropEdit.setText("");
        } else if (eventType.equals((Object)BasicACREvent.EventType.listSelectionValueChange)) {
            if (this.mRatioBetACRWidget.getList().getValueIsAdjusting()) {
                return;
            }
            int n2 = this.mRatioBetACRWidget.getListSelectedIndex();
            this.mRatioBetACRWidget.setAddEnabled(false);
            this.mRatioBetACRWidget.setChangeEnabled(false);
            this.mRatioBetACRWidget.setRemoveEnabled(n2 > -1);
            if (n2 > -1) {
                String string = this.mRatioBetACRWidget.getListItemAt(n2).toString();
                int n3 = string.indexOf("-");
                String string4 = string.substring(0, n3 - 1);
                String string5 = string.substring(n3 + 2);
                this.mLowPropEdit.getDocument().removeDocumentListener(this);
                this.mHighPropEdit.getDocument().removeDocumentListener(this);
                this.mLowPropEdit.setText(string4);
                this.mHighPropEdit.setText(string5);
                this.mLowPropEdit.getDocument().addDocumentListener(this);
                this.mHighPropEdit.getDocument().addDocumentListener(this);
            }
        } else if (eventType.equals((Object)BasicACREvent.EventType.changeButtonPress)) {
            DefaultListModel defaultListModel;
            int n4 = this.mRatioBetACRWidget.getListSelectedIndex();
            String string = this.mLowPropEdit.getText();
            String string6 = this.mHighPropEdit.getText();
            if (Double.parseDouble(string) == 0.0 && Double.parseDouble(string6) == 0.0) {
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_RATIO_STAT_LOW_HIGH_PROP_OUTOFRANGE_WARNING"), VersionInfo.getAppVersionString());
                this.mHighPropEdit.setSelectionStart(0);
                this.mHighPropEdit.setSelectionEnd(this.mHighPropEdit.getText().length());
                this.mHighPropEdit.requestFocusInWindow();
                return;
            }
            if (!(Double.parseDouble(string6) >= Double.parseDouble(string))) {
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_RATIO_STAT_LOW_HIGH_PROP_WARNING"), VersionInfo.getAppVersionString());
                this.mLowPropEdit.setSelectionStart(0);
                this.mLowPropEdit.setSelectionEnd(this.mLowPropEdit.getText().length());
                this.mLowPropEdit.requestFocusInWindow();
                return;
            }
            String string7 = string + " - " + string6;
            this.mLowPropEdit.setText("");
            this.mHighPropEdit.setText("");
            if (n4 > -1 && string.length() > -1 && string6.length() > -1 && !(defaultListModel = (DefaultListModel)this.mRatioBetACRWidget.getList().getModel()).contains(string7)) {
                this.mRatioBetACRWidget.removeListItemAt(n4);
                this.mRatioBetACRWidget.addListItemAt(n4, string7);
                this.mRatioBetACRWidget.requestFocusInWindow();
            }
        } else if (eventType.equals((Object)BasicACREvent.EventType.removeButtonPress) && (n = this.mRatioBetACRWidget.getListSelectedIndex()) > -1) {
            this.mLowPropEdit.setText("");
            this.mHighPropEdit.setText("");
            this.mRatioBetACRWidget.removeListItemAt(n);
            this.mRatioBetACRWidget.requestFocusInWindow();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.floatFieldTextChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.floatFieldTextChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.floatFieldTextChanged();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        JTextField jTextField = (JTextField)focusEvent.getSource();
        jTextField.selectAll();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        int n;
        if ((this.mRatioBetACRWidget.isAddEnabled() || this.mRatioWithinACRWidget.isAddEnabled()) && (n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), ResUtil.getCommonDlgString("ERR_ACR_CONTINUE_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) == 3) {
            return false;
        }
        if (this.mConfIntCheck.isSelected()) {
            dialogDataModel.putBoolean(CONF_INT_PER_STATE_KEY, true);
        } else {
            dialogDataModel.putBoolean(CONF_INT_PER_STATE_KEY, false);
        }
        mSaved = true;
        return super.saveState(dialogDataModel);
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        if (mSaved.booleanValue()) {
            Boolean bl = dialogDataModel.getBoolean(CONF_INT_PER_STATE_KEY);
            if (bl != null && bl.booleanValue()) {
                this.mConfIntEdit.setEnabled(true);
                this.mConfIntEdit.setOpaque(true);
                this.mPercentLabel.setEnabled(true);
            } else {
                this.mConfIntEdit.setEnabled(false);
                this.mConfIntEdit.setOpaque(false);
                this.mPercentLabel.setEnabled(false);
            }
            this.mLowPropEdit.setText("");
            this.mHighPropEdit.setText("");
            this.mRatioBetACRWidget.setAddEnabled(false);
            this.mRatioBetACRWidget.setChangeEnabled(false);
            this.mRatioBetACRWidget.setRemoveEnabled(false);
            this.mRatioWithinEdit.setText("");
            this.pack();
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.mCentTendPanel = this.setupTendancyPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mCentTendPanel, gridBagConstraints, 0, 0, 1, 1, n, null);
        this.mDispersionPanel = this.setupDispersionPanel();
        Insets insets = new Insets(0, DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDispersionPanel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.createButtonGroup(this.mDispersionPanel);
        this.mConcIndexPanel = this.setupConcIndexPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mConcIndexPanel, gridBagConstraints, 0, 1, 2, 1, n, insets);
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(this.setTabTraversal(), false));
        this.pack();
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, MEDIAN_KEY);
        this.mMedianCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, MEAN_KEY);
        this.mMeanCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, WEIGHTED_MEAN_KEY);
        this.mWeightedMeanCheck = new JCheckBox(toggleButtonAction);
        this.mCentralTendButtonGroup = new SpssButtonGroup();
        this.mCentralTendButtonGroup.add(this.mMedianCheck);
        this.mCentralTendButtonGroup.add(this.mMeanCheck);
        this.mCentralTendButtonGroup.add(this.mWeightedMeanCheck);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, CONFIDENCE_INTERVAL_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                if (jCheckBox.isSelected()) {
                    RatioStatistics.this.mConfIntEdit.setEnabled(true);
                    RatioStatistics.this.mConfIntEdit.setOpaque(true);
                    RatioStatistics.this.mPercentLabel.setEnabled(true);
                } else {
                    RatioStatistics.this.mConfIntEdit.setEnabled(false);
                    RatioStatistics.this.mConfIntEdit.setOpaque(false);
                    RatioStatistics.this.mPercentLabel.setEnabled(false);
                }
            }
        };
        this.mConfIntCheck = new JCheckBox(toggleButtonAction);
        this.mConfIntEdit = new FloatTextField(0.0, 99.99, 4, true);
        this.mConfIntEdit.setAction((Action)new TextFieldAction(this.mParentDlg, CONFIDENCE_INTERVAL_KEY));
        this.mPercentLabel = DialogUtil.createLabel(this, "IDS_RATIO_STAT_PERCENT_LABEL");
        this.mPercentLabel.setLabelFor((Component)this.mConfIntEdit);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, AAD_KEY);
        this.mAadCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, COD_KEY);
        this.mCodCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, PRD_KEY);
        this.mPrdCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, MEDIAN_CENTERED_COV_KEY);
        this.mMedCenteredCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, MEAN_CENTERED_COV_KEY);
        this.mMeanCenteredCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, STANDARD_DEVIATION_KEY);
        this.mStdDeviationCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, RANGE_KEY);
        this.mRangeCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, MINIMUM_KEY);
        this.mMinCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, MAXIMUM_KEY);
        this.mMaxCheck = new JCheckBox(toggleButtonAction);
        this.mPairsLabel = DialogUtil.createLabel(this, RATIO_STAT_PAIRS_KEY);
        this.mLowPropLabel = DialogUtil.createLabel(this, LOW_PROPORTION_KEY);
        this.mHighPropLabel = DialogUtil.createLabel(this, HIGH_PROPORTION_KEY);
        this.setLabelSizeToEqual(this.mLowPropLabel, this.mHighPropLabel);
        this.mPercentagesLabel = DialogUtil.createLabel(this, PERCENTAGES_KEY);
        this.mPerOfMedLabel = DialogUtil.createLabel(this, RATIO_STAT_PER_OF_MEDIAN_KEY);
        this.mLowPropEdit = new FloatTextField(0.0, 99999.0, 4, true);
        this.mLowPropEdit.setAction((Action)new TextFieldAction(this.mParentDlg, LOW_PROPORTION_KEY));
        this.mLowPropEdit.getDocument().addDocumentListener(this);
        this.mLowPropLabel.setLabelFor((Component)this.mLowPropEdit);
        this.mLowPropEdit.setColumns(6);
        this.mHighPropEdit = new FloatTextField(0.0, 99999.0, 4, true);
        this.mHighPropEdit.setAction((Action)new TextFieldAction(this.mParentDlg, HIGH_PROPORTION_KEY));
        this.mHighPropEdit.getDocument().addDocumentListener(this);
        this.mHighPropLabel.setLabelFor((Component)this.mHighPropEdit);
        this.mHighPropEdit.setColumns(6);
        this.mRatioWithinEdit = new FloatTextField(0.0, 100.0, 4, true);
        this.mRatioWithinEdit.setAction((Action)new TextFieldAction(this.mParentDlg, PERCENTAGES_KEY));
        this.mPerOfMedLabel.setLabelFor((Component)this.mRatioWithinEdit);
        this.mRatioBetACRWidget = new BasicACRWidget(BASIC_ACRWIDGET_ACTION_KEY);
        this.mRatioBetACRWidget.getList().setCellRenderer(new CustomWidgetListCellRenderer());
        this.mRatioBetACRWidget.addBasicACRListener(this);
        this.mRatioBetACRWidget.setAllowDuplicates(false);
        this.mPairsLabel.setLabelFor(this.mRatioBetACRWidget.getList());
        this.mRatioWithinACRWidget = new ACRWidget((JTextField)this.mRatioWithinEdit);
        this.mPercentagesLabel.setLabelFor(this.mRatioWithinACRWidget.getList());
        this.mConfIntEdit.addFocusListener((FocusListener)this);
        this.mLowPropEdit.addFocusListener((FocusListener)this);
        this.mHighPropEdit.addFocusListener((FocusListener)this);
        this.mRatioWithinEdit.addFocusListener((FocusListener)this);
    }

    private void setDefaults() {
        this.mConfIntEdit.setEnabled(false);
        this.mConfIntEdit.setOpaque(false);
        this.mConfIntEdit.setText(mDefaultConfInterval);
        this.mPercentLabel.setEnabled(false);
        this.mCodCheck.setSelected(true);
        this.mPrdCheck.setSelected(true);
        this.mMedCenteredCheck.setSelected(true);
    }

    private void floatFieldTextChanged() {
        boolean bl = this.mLowPropEdit.getText().length() > 0;
        boolean bl2 = this.mHighPropEdit.getText().length() > 0;
        this.mRatioBetACRWidget.setAddEnabled(bl && bl2);
        int n = this.mRatioBetACRWidget.getListSelectedIndex();
        this.mRatioBetACRWidget.setChangeEnabled(bl && bl2 && n > -1);
        this.mRatioBetACRWidget.setRemoveEnabled(false);
    }

    private JPanel setupTendancyPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_RATIO_STAT_CENT_TEND"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mMedianCheck, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mMeanCheck, gridBagConstraints, 0, 1, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mWeightedMeanCheck, gridBagConstraints, 0, 2, 2, 1, n, insets);
        JPanel jPanel2 = this.setupLinePanel();
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 4, 2, 1, n, insets);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mConfIntCheck, gridBagConstraints, 0, 5, 2, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        Insets insets2 = new Insets(insets.top, DialogUtil.getComponentGroupGap() * 3, DialogUtil.getGroupBoxInnerMargin(), 0);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mPercentLabel, gridBagConstraints, 0, 6, 1, 1, n, insets2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        insets2.set(insets.top, insets.left, insets.bottom, insets.right * 25);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mConfIntEdit, gridBagConstraints, 1, 6, 2, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupLinePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, Color.GRAY));
        return jPanel;
    }

    private JPanel setupDispersionPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_RATIO_STAT_DISPERSION"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mAadCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCodCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mPrdCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mMedCenteredCheck, gridBagConstraints, 0, 3, 1, 1, n, insets);
        Insets insets2 = new Insets(insets.top, insets.left, DialogUtil.getGroupBoxInnerMargin() + insets.bottom * 2, insets.right);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mMeanCenteredCheck, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets2.set(insets.top, insets.left * 8, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mStdDeviationCheck, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mRangeCheck, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mMinCheck, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mMaxCheck, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupConcIndexPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_RATIO_STAT_CONC_INDEX"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap());
        int n = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.setupBetweenProportionsPanel(), gridBagConstraints, 0, 0, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.setupWithinPercentageOfMedianPanel(), gridBagConstraints, 1, 0, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupBetweenProportionsPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_RATIO_STAT_BETWEEN_PROPORTIONS"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, DialogUtil.getComponentGroupGap(), insets.bottom, DialogUtil.getComponentGroupGap());
        int n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mLowPropLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mLowPropEdit, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mHighPropLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mHighPropEdit, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        int n2 = (int)this.mRatioBetACRWidget.getListboxLocation().getX();
        insets2 = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap() + n2, insets.bottom, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, this.mPairsLabel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets2 = new Insets(insets.top, DialogUtil.getComponentGroupGap(), insets.bottom, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, this.mRatioBetACRWidget, gridBagConstraints, 0, 3, 2, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupWithinPercentageOfMedianPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_RATIO_STAT_WITHIN_PERCENTAGE_OF_MEDIAN"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, DialogUtil.getComponentGroupGap(), insets.bottom, DialogUtil.getComponentGroupGap());
        int n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mPerOfMedLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mRatioWithinEdit, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        JLabel jLabel = new JLabel(" ");
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        int n2 = (int)this.mRatioWithinACRWidget.getListboxLocation().getX();
        insets2 = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap() + n2, insets.bottom, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, this.mPercentagesLabel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets2 = new Insets(insets.top, DialogUtil.getComponentGroupGap(), insets.bottom, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, this.mRatioWithinACRWidget, gridBagConstraints, 0, 3, 2, 1, n, insets2);
        return jPanel;
    }

    private void setLabelSizeToEqual(JLabel jLabel, JLabel jLabel2) {
        Dimension dimension = jLabel.getPreferredSize();
        Dimension dimension2 = jLabel2.getPreferredSize();
        int n = dimension2.width;
        int n2 = dimension2.height;
        if (dimension.width > dimension2.width) {
            n = dimension.width;
        }
        if (dimension.height > dimension2.height) {
            n2 = dimension.width;
        }
        jLabel.setPreferredSize(new Dimension(n, n2));
        jLabel2.setPreferredSize(new Dimension(n, n2));
    }

    private boolean showWarning() {
        boolean bl = false;
        if (this.mConfIntCheck.isSelected()) {
            if (this.mMedianCheck.isSelected() || this.mMeanCheck.isSelected() || this.mWeightedMeanCheck.isSelected()) {
                if (this.mConfIntEdit.getText().trim().equals("")) {
                    bl = true;
                    SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_RATIO_STAT_CONF_INT_WARNING"), VersionInfo.getAppVersionString());
                    this.mConfIntEdit.requestFocusInWindow();
                }
            } else {
                bl = true;
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_RATIO_STAT_MED_MEAN_WMEAN_WARNING"), VersionInfo.getAppVersionString());
            }
        }
        return bl;
    }

    private Vector<Object> setTabTraversal() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mMedianCheck);
        vector.add(this.mMeanCheck);
        vector.add(this.mWeightedMeanCheck);
        vector.add(this.mConfIntCheck);
        vector.add(this.mConfIntEdit);
        vector.add(this.mAadCheck);
        vector.add(this.mCodCheck);
        vector.add(this.mPrdCheck);
        vector.add(this.mMedCenteredCheck);
        vector.add(this.mMeanCenteredCheck);
        vector.add(this.mStdDeviationCheck);
        vector.add(this.mRangeCheck);
        vector.add(this.mMinCheck);
        vector.add(this.mMaxCheck);
        vector.add(this.mLowPropEdit);
        vector.add(this.mHighPropEdit);
        Component[] componentArray = new Component[3];
        JPanel jPanel = (JPanel)this.mRatioBetACRWidget.getComponent(0);
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            componentArray[i] = jPanel.getComponent(i);
        }
        vector.add(componentArray[0]);
        vector.add(componentArray[1]);
        vector.add(componentArray[2]);
        vector.add(this.mRatioBetACRWidget.getList());
        vector.add(this.mRatioWithinEdit);
        Component[] componentArray2 = new Component[3];
        for (n = 0; n < this.mRatioWithinACRWidget.getComponentCount() - 1; ++n) {
            componentArray2[n] = this.mRatioWithinACRWidget.getComponent(n);
        }
        vector.add(componentArray2[0]);
        vector.add(componentArray2[1]);
        vector.add(componentArray2[2]);
        vector.add(this.mRatioWithinACRWidget.getList());
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        return vector;
    }

    class CustomWidgetListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        protected Border mNoFocusBorder = new EmptyBorder(1, 1, 1, 1);

        CustomWidgetListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = object.toString();
            int n2 = string.indexOf("-");
            String string2 = string.substring(0, n2 - 1);
            String string3 = string.substring(n2 + 2);
            string2 = UIToolResUtil.addLocale((String)string2);
            string3 = UIToolResUtil.addLocale((String)string3);
            this.setText(string2 + " - " + string3);
            if (jList.isEnabled()) {
                this.setOpaque(true);
                if (bl) {
                    if (jList.hasFocus()) {
                        this.setBackground(jList.getSelectionBackground());
                        this.setForeground(jList.getSelectionForeground());
                    } else {
                        this.setBackground(Color.lightGray);
                        this.setForeground(Color.black);
                    }
                } else {
                    this.setBackground(jList.getBackground());
                    this.setForeground(jList.getForeground());
                }
            } else {
                this.setOpaque(false);
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            Border border = null;
            if (bl2 && jList.isEnabled()) {
                if (bl) {
                    border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("List.focusCellHighlightBorder");
                }
            } else {
                border = this.mNoFocusBorder;
            }
            this.setBorder(border);
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }
    }
}

