/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.desc_stats.ratio;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.desc_stats.ratio.RatioStatistics;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.filechooser.FileFilter;

public class RatioDlg
extends BaseProcedureDialog
implements ListDataListener {
    private static final String FILE_KEY = "IDS_RATIO_FILE_BUTTON";
    private static final String STATISTICS_KEY = "IDS_COMMON_STATS_3DOT";
    private static final String DISPLAY_RES_KEY = "IDS_RATIO_DISPLAY_CHECK";
    private static final String SAVE_RES_KEY = "IDS_RATIO_SAVE_RES_FILE";
    private static final String SORT_BY_GROUP_KEY = "IDS_RATIO_SORT_CHECK";
    private static final String ASC_ORDER_KEY = "IDS_RATIO_ASC_RADIO";
    private static final String DESC_ORDER_KEY = "IDS_RATIO_DESC_RADIO";
    private static final String STAT_BASIC_ACRWIDGET_KEY = "BCOC";
    private static final String STAT_ACRWIDGET_KEY = "WCOC";
    private static final Integer ZERO = 0;
    private static final int FILE_TEXT_FIELD_TOP_INSET = 8;
    private static final String NUM_TARGETLIST_KEY = "TARGET_LIST_NUM";
    private static final String DENOM_TARGETLIST_KEY = "TARGET_LIST_DENOM";
    private static final String GROUP_TARGETLIST_KEY = "TARGET_LIST_GROUP";
    private static final String FILE_TEXT_FIELD_STATE_KEY = "IDS_FILE_TEXT_FIELD";
    private JPanel mMainPanel;
    private JPanel mFileStatisticsPanel;
    private SrcVariableList mSrcVarList;
    private JScrollPane mSrcScrollPane;
    private JScrollPane mNumScrollPane;
    private JScrollPane mDenomScrollPane;
    private JScrollPane mGroupScrollPane;
    private TargetVariableList mNumTargetVarList;
    private TargetVariableList mDenomTargetVarList;
    private TargetVariableList mGroupTargetVarList;
    private JLabel mNumLabel;
    private JLabel mDenomLabel;
    private JLabel mGroupLabel;
    private JCheckBox mDispResCheck;
    private JCheckBox mSaveResCheck;
    private SpssButtonGroup mDispSaveButtonGroup;
    private JCheckBox mSortGroupCheck;
    private JRadioButton mAscRadio;
    private JRadioButton mDescRadio;
    private ArrowButton mNumArrowButton;
    private ArrowButton mDenomArrowButton;
    private ArrowButton mGroupArrowButton;
    private SpssButtonGroup mAscDescButtonGroup;
    private JButton mFileButton;
    private JButton mStatisticsButton;
    private FileTextField mFileTextField;
    private String[] keyString = new String[13];

    public RatioDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle.getDefaultResourceBundleName(), AnalyzeResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_RATIO"));
    }

    @Override
    public final String getIActionKey() {
        return "analyze_desc_stat_ratio";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_rato";
    }

    @Override
    public boolean okPastePressed() {
        if (this.showWarning()) {
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("RATIO STATISTICS"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mNumTargetVarList.getVariablesStringList()));
        stringBuffer.append(" WITH ");
        stringBuffer.append(this.mDenomTargetVarList.getVariablesStringList());
        String string = this.mGroupTargetVarList.getVariablesStringList();
        if (!string.equals("")) {
            stringBuffer.append(" BY ");
            stringBuffer.append(string);
            stringBuffer.append(" (");
            if (this.mSortGroupCheck.isSelected()) {
                if (this.mAscRadio.isSelected()) {
                    stringBuffer.append("ASCENDING");
                } else if (this.mDescRadio.isSelected()) {
                    stringBuffer.append("DESCENDING");
                }
            } else {
                stringBuffer.append("NOSORT");
            }
            stringBuffer.append(")");
        }
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/MISSING=EXCLUDE"));
        StringBuffer stringBuffer2 = new StringBuffer("");
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        HashMap<String, String> hashMap = this.getStatMap();
        Boolean bl = null;
        boolean bl2 = false;
        for (Map.Entry<String, String> objectArray : hashMap.entrySet()) {
            bl = dialogDataModel.getBoolean(objectArray.getKey());
            if (bl == null) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            for (int i = 0; i < this.keyString.length; ++i) {
                Object[] objectArray;
                int n;
                Object[] objectArray2;
                if (i == 1 && (objectArray2 = dialogDataModel.getArray(RatioStatistics.BASIC_ACRWIDGET_ACTION_KEY)).length > 0) {
                    stringBuffer2.append(STAT_BASIC_ACRWIDGET_KEY);
                    for (Object object : objectArray2) {
                        stringBuffer2.append("(");
                        String string2 = object.toString();
                        int n2 = string2.indexOf("-");
                        String string3 = string2.substring(0, n2 - 1);
                        stringBuffer2.append(string3);
                        stringBuffer2.append(',');
                        String string4 = string2.substring(n2 + 2);
                        stringBuffer2.append(string4);
                        stringBuffer2.append(") ");
                    }
                    stringBuffer2.append(" ");
                }
                if (i == 12 && (n = (objectArray = dialogDataModel.getArray("LIST_ACTION")).length) > 0) {
                    int n3 = 0;
                    stringBuffer2.append(STAT_ACRWIDGET_KEY);
                    stringBuffer2.append("(");
                    for (Object object : objectArray) {
                        stringBuffer2.append(object.toString());
                        if (++n3 == n) continue;
                        stringBuffer2.append(" ");
                    }
                    stringBuffer2.append(") ");
                }
                if (!dialogDataModel.getBoolean(this.keyString[i]).booleanValue()) continue;
                stringBuffer2.append(hashMap.get(this.keyString[i]));
                if (this.keyString[i].equals("IDS_RATIO_STAT_CONF_INTERVAL_CHECK")) {
                    stringBuffer2.append("(");
                    stringBuffer2.append(dialogDataModel.getString("IDS_RATIO_STAT_CONF_INTERVAL_CHECK"));
                    stringBuffer2.append(")");
                }
                stringBuffer2.append(" ");
            }
            stringBuffer2.deleteCharAt(stringBuffer2.length() - 1);
        } else {
            stringBuffer2.append("COD MDCOV PRD");
        }
        if (this.mSaveResCheck.isSelected()) {
            StringBuffer stringBuffer3 = new StringBuffer("");
            stringBuffer3.append("\n");
            stringBuffer3.append(SyntaxUtil.getSubCommand("/OUTFILE("));
            stringBuffer3.append(CharacterUtil.smartQuote((String)this.mFileTextField.getText()));
            stringBuffer3.append(")=");
            stringBuffer3.append(stringBuffer2);
            stringBuffer.append(stringBuffer3);
        }
        if (this.mDispResCheck.isSelected()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/PRINT="));
            stringBuffer.append(stringBuffer2);
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mNumTargetVarList.getModel().getSize() > 0 && this.mDenomTargetVarList.getModel().getSize() > 0);
        if (this.mGroupTargetVarList.getModel().getSize() > 0) {
            if (this.mSortGroupCheck.isSelected()) {
                this.setSortByGroupEnabled(true, true);
            } else {
                this.setSortByGroupEnabled(true, false);
            }
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mNumTargetVarList.getModel().getSize() > 0 && this.mDenomTargetVarList.getModel().getSize() > 0);
        if (this.mGroupTargetVarList.getModel().getSize() == 0) {
            this.setSortByGroupEnabled(false, false);
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void reset() {
        super.reset();
        this.mNumTargetVarList.removeAll();
        this.mDenomTargetVarList.removeAll();
        this.mGroupTargetVarList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.requestFocusInWindow();
        this.mSaveResCheck.setSelected(false);
        this.mStatisticsButton.setEnabled(true);
        RatioStatistics.setSavedFlag(false);
        this.enableOkPaste(false);
        this.setDefaults();
    }

    public void paint(Graphics graphics) {
        this.mFileTextField.setText(this.mFileTextField.getText());
        super.paint(graphics);
        super.validate();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.mMainPanel = this.setupMainPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mMainPanel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 0.0;
        this.mFileStatisticsPanel = this.setupFileStatisticsPanel();
        Insets insets = new Insets(0, DialogUtil.getComponentGroupGap() * 3, 0, 0);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mFileStatisticsPanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(this.setTabTraversal(), false));
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        if (this.mSaveResCheck.isSelected()) {
            this.mFileButton.setEnabled(true);
            this.mFileTextField.setEnabled(true);
        } else {
            this.mFileButton.setEnabled(false);
            this.mFileTextField.setEnabled(false);
        }
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mSaveResCheck.setSelected(false);
            this.mSaveResCheck.setEnabled(false);
            this.mFileButton.setEnabled(false);
        }
        if (this.mSortGroupCheck.isEnabled() && this.mSortGroupCheck.isSelected()) {
            this.mAscRadio.setEnabled(true);
            this.mDescRadio.setEnabled(true);
        } else {
            this.mAscRadio.setEnabled(false);
            this.mDescRadio.setEnabled(false);
        }
        this.mSrcVarList.setSelectedIndex(0);
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mNumTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mNumTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mNumTargetVarList.setIdentifier(NUM_TARGETLIST_KEY);
        this.mNumTargetVarList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mNumScrollPane = new JScrollPane(this.mNumTargetVarList);
        this.mNumScrollPane.setPreferredSize(this.mNumTargetVarList.getMinimumSize());
        this.mNumScrollPane.setHorizontalScrollBarPolicy(31);
        this.mNumScrollPane.setVerticalScrollBarPolicy(21);
        this.mDenomTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mDenomTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mDenomTargetVarList.setIdentifier(DENOM_TARGETLIST_KEY);
        this.mDenomTargetVarList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mDenomScrollPane = new JScrollPane(this.mDenomTargetVarList);
        this.mDenomScrollPane.setPreferredSize(this.mDenomTargetVarList.getMinimumSize());
        this.mDenomScrollPane.setHorizontalScrollBarPolicy(31);
        this.mDenomScrollPane.setVerticalScrollBarPolicy(21);
        this.mGroupTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mGroupTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mGroupTargetVarList.setIdentifier(GROUP_TARGETLIST_KEY);
        this.mGroupScrollPane = new JScrollPane(this.mGroupTargetVarList);
        this.mGroupScrollPane.setPreferredSize(this.mGroupTargetVarList.getMinimumSize());
        this.mGroupScrollPane.setHorizontalScrollBarPolicy(31);
        this.mGroupScrollPane.setVerticalScrollBarPolicy(21);
        this.mNumLabel = DialogUtil.createLabel(this, "IDS_RATIO_NUMERATOR_COLON");
        this.mNumLabel.setLabelFor(this.mNumTargetVarList);
        this.mDenomLabel = DialogUtil.createLabel(this, "IDS_RATIO_DENOMINATOR_COLON");
        this.mDenomLabel.setLabelFor(this.mDenomTargetVarList);
        this.mGroupLabel = DialogUtil.createLabel(this, "IDS_RATIO_GROUPVAR_COLON");
        this.mGroupLabel.setLabelFor(this.mGroupTargetVarList);
        this.mNumArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mNumArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mNumArrowButton.registerVariableList(this.mNumTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mDenomArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mDenomArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mDenomArrowButton.registerVariableList(this.mDenomTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mGroupArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mGroupArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mGroupArrowButton.registerVariableList(this.mGroupTargetVarList, SpssArrowButton.ButtonOrientation.left);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, SORT_BY_GROUP_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                if (jCheckBox.isSelected()) {
                    RatioDlg.this.setSortByGroupEnabled(true, true);
                } else {
                    RatioDlg.this.setSortByGroupEnabled(true, false);
                }
            }
        };
        this.mSortGroupCheck = new JCheckBox(toggleButtonAction);
        ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction(this, ASC_ORDER_KEY);
        this.mAscRadio = new JRadioButton(toggleButtonAction2);
        toggleButtonAction2 = new ToggleButtonAction(this, DESC_ORDER_KEY);
        this.mDescRadio = new JRadioButton(toggleButtonAction2);
        this.mAscDescButtonGroup = new SpssButtonGroup();
        this.mAscDescButtonGroup.add(this.mAscRadio);
        this.mAscDescButtonGroup.add(this.mDescRadio);
        ToggleButtonAction toggleButtonAction3 = new ToggleButtonAction(this, DISPLAY_RES_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                if (jCheckBox.isSelected()) {
                    RatioDlg.this.mStatisticsButton.setEnabled(true);
                } else if (RatioDlg.this.mSaveResCheck.isSelected()) {
                    RatioDlg.this.mStatisticsButton.setEnabled(true);
                } else {
                    RatioDlg.this.mStatisticsButton.setEnabled(false);
                }
            }
        };
        this.mDispResCheck = new JCheckBox(toggleButtonAction3);
        ToggleButtonAction toggleButtonAction4 = new ToggleButtonAction(this, SAVE_RES_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                if (jCheckBox.isSelected()) {
                    RatioDlg.this.mFileButton.setEnabled(true);
                    RatioDlg.this.mFileTextField.setEnabled(true);
                    RatioDlg.this.mStatisticsButton.setEnabled(true);
                } else {
                    RatioDlg.this.mFileButton.setEnabled(false);
                    RatioDlg.this.mFileTextField.setEnabled(false);
                    if (RatioDlg.this.mDispResCheck.isSelected()) {
                        RatioDlg.this.mStatisticsButton.setEnabled(true);
                    } else {
                        RatioDlg.this.mStatisticsButton.setEnabled(false);
                    }
                }
            }
        };
        this.mSaveResCheck = new JCheckBox(toggleButtonAction4);
        this.mDispSaveButtonGroup = new SpssButtonGroup();
        this.mDispSaveButtonGroup.add(this.mDispResCheck);
        this.mDispSaveButtonGroup.add(this.mSaveResCheck);
        ToggleButtonAction toggleButtonAction5 = new ToggleButtonAction(STATISTICS_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RatioDlg.this.runRatioStatsSubDialog();
            }
        };
        this.mStatisticsButton = new JButton(toggleButtonAction5);
        this.mFileTextField = new FileTextField();
        this.mFileTextField.setAction(new TextFieldAction(this, FILE_TEXT_FIELD_STATE_KEY));
        this.mFileTextField.setOpaque(false);
        this.mFileTextField.setEditable(false);
        this.mFileTextField.setBorder(BorderFactory.createEmptyBorder());
        ToggleButtonAction toggleButtonAction6 = new ToggleButtonAction(this, FILE_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
                remoteFileChooser.setDialogTitle(RatioDlg.this.getResString("IDS_RATIO_FILE_CHOOSER_TITLE"));
                RefFileFilter refFileFilter = new RefFileFilter(RatioDlg.this.getResString("IDS_FILE_FILTER_DESC"), RatioDlg.this.getResString("IDS_SAVE_FILE_EXTENSION"));
                remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
                remoteFileChooser.setAcceptAllFileFilterUsed(false);
                int n = remoteFileChooser.showSaveDialog((Component)((Object)RatioDlg.this));
                if (n == 0) {
                    FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                    String string = remoteFileChooser.getSelectedFilePath();
                    if (!string.endsWith(RatioDlg.this.getResString("IDS_SAVE_FILE_EXTENSION"))) {
                        string = string + RatioDlg.this.getResString("IDS_SAVE_FILE_EXTENSION");
                    }
                    RatioDlg.this.mFileTextField.setText(string);
                } else {
                    ComponentState.trace1((String)"No Selection", (int)15);
                }
            }
        };
        this.mFileButton = new JButton(toggleButtonAction6);
        this.mNumTargetVarList.getModel().addListDataListener(this);
        this.mDenomTargetVarList.getModel().addListDataListener(this);
        this.mGroupTargetVarList.getModel().addListDataListener(this);
    }

    private void setDefaults() {
        this.mSrcVarList.setSelectedIndex(ZERO);
        this.mSortGroupCheck.setSelected(true);
        this.mAscRadio.setSelected(true);
        this.mDispResCheck.setSelected(true);
        this.mFileTextField.setText("");
        this.mFileButton.setEnabled(false);
        this.mFileTextField.setEnabled(false);
        this.setSortByGroupEnabled(false, false);
    }

    private boolean showWarning() {
        boolean bl = false;
        if (!this.mDispResCheck.isSelected() && !this.mSaveResCheck.isSelected()) {
            bl = true;
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_RATIO_DISPSAVE_WARNING"), VersionInfo.getAppVersionString());
        } else if (this.mSaveResCheck.isSelected() && this.mFileTextField.getText().trim().equals("")) {
            bl = true;
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_RATIO_FILE_WARNING"), VersionInfo.getAppVersionString());
        } else {
            DialogDataModel dialogDataModel = this.getDialogDataModel();
            HashMap<String, String> hashMap = this.getStatMap();
            Boolean bl2 = null;
            boolean bl3 = false;
            int n = 0;
            for (Map.Entry<String, String> entry : hashMap.entrySet()) {
                bl2 = dialogDataModel.getBoolean(entry.getKey());
                if (bl2 != null) {
                    bl3 = true;
                    if (bl2.booleanValue()) break;
                }
                ++n;
            }
            if (bl3 && n == hashMap.size()) {
                bl = true;
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_RATIO_STATISTICS_WARNING"), VersionInfo.getAppVersionString());
            }
        }
        return bl;
    }

    private void setSortByGroupEnabled(boolean bl, boolean bl2) {
        this.mSortGroupCheck.setEnabled(bl);
        this.mAscRadio.setEnabled(bl2);
        this.mDescRadio.setEnabled(bl2);
    }

    private JPanel setupMainPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = new Insets(0, 0, DialogUtil.getComponentGroupGap(), 0);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_RATIO_SRCLIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 8, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mNumLabel, gridBagConstraints, 2, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        Insets insets3 = new Insets(0, insets2.left, 0, insets2.right);
        n = 20;
        DialogUtil.addUsingGBL(jPanel, this.mNumArrowButton, gridBagConstraints, 1, 0, 1, 2, n, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mNumScrollPane, gridBagConstraints, 2, 1, 1, 1, n, null);
        gridBagConstraints.fill = 2;
        Insets insets4 = DialogUtil.getStandardControlInsets();
        insets.set(insets4.left * 2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDenomLabel, gridBagConstraints, 2, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        n = 20;
        DialogUtil.addUsingGBL(jPanel, this.mDenomArrowButton, gridBagConstraints, 1, 2, 1, 2, n, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mDenomScrollPane, gridBagConstraints, 2, 3, 1, 1, n, null);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mGroupLabel, gridBagConstraints, 2, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        n = 20;
        DialogUtil.addUsingGBL(jPanel, this.mGroupArrowButton, gridBagConstraints, 1, 4, 1, 2, n, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mGroupScrollPane, gridBagConstraints, 2, 5, 1, 1, n, null);
        insets.set(insets4.left * 2, 0, 0, insets4.right);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSortGroupCheck, gridBagConstraints, 2, 6, 1, 1, n, insets);
        insets.set(insets4.top, DialogUtil.getComponentGroupGap() * 2, 0, insets4.right);
        DialogUtil.addUsingGBL(jPanel, this.mAscRadio, gridBagConstraints, 2, 7, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(insets4.top, DialogUtil.getComponentGroupGap() * 2, DialogUtil.getComponentGroupGap(), insets4.right);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mDescRadio, gridBagConstraints, 2, 8, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mDispResCheck, gridBagConstraints, 0, 9, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, this.mSaveResCheck, gridBagConstraints, 0, 10, 1, 1, n, null);
        return jPanel;
    }

    private JPanel setupFileStatisticsPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        int n = 23;
        Insets insets = DialogUtil.getStandardButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mFileButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        n = 19;
        insets = new Insets(8, DialogUtil.getComponentGroupGap(), 0, DialogUtil.getComponentGroupGap());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFileTextField), gridBagConstraints, 1, 0, 3, 1, n, insets);
        n = 23;
        Insets insets2 = DialogUtil.getStandardButtonInsets();
        insets.set(insets2.top, 0, insets2.bottom, insets2.right);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mStatisticsButton, gridBagConstraints, 4, 0, 1, 1, n, insets);
        DialogUtil.normalizeButtonWidths((JPanel)jPanel);
        return jPanel;
    }

    private void runRatioStatsSubDialog() {
        this.runSubDialog(new RatioStatistics(this));
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mNumArrowButton);
        vector.add(this.mDenomArrowButton);
        vector.add(this.mGroupArrowButton);
        vector.add(this.mNumTargetVarList);
        vector.add(this.mDenomTargetVarList);
        vector.add(this.mGroupTargetVarList);
        vector.add(this.mSortGroupCheck);
        vector.add(this.mAscDescButtonGroup);
        vector.add(this.mDispResCheck);
        vector.add(this.mSaveResCheck);
        vector.add(this.mFileButton);
        vector.add(this.mStatisticsButton);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private HashMap<String, String> getStatMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("IDS_RATIO_STAT_AAD_CHECK", "AAD");
        this.keyString[0] = "IDS_RATIO_STAT_AAD_CHECK";
        hashMap.put("IDS_RATIO_STAT_CONF_INTERVAL_CHECK", "CIN");
        this.keyString[1] = "IDS_RATIO_STAT_CONF_INTERVAL_CHECK";
        hashMap.put("IDS_RATIO_STAT_COD_CHECK", "COD");
        this.keyString[2] = "IDS_RATIO_STAT_COD_CHECK";
        hashMap.put("IDS_RATIO_STAT_MAXIMUM_CHECK", "MAX");
        this.keyString[3] = "IDS_RATIO_STAT_MAXIMUM_CHECK";
        hashMap.put("IDS_RATIO_STAT_MEDIAN_CENTERED_COV_CHECK", "MDCOV");
        this.keyString[4] = "IDS_RATIO_STAT_MEDIAN_CENTERED_COV_CHECK";
        hashMap.put("IDS_RATIO_STAT_MEAN_CHECK", "MEAN");
        this.keyString[5] = "IDS_RATIO_STAT_MEAN_CHECK";
        hashMap.put("IDS_RATIO_STAT_MEDIAN_CHECK", "MEDIAN");
        this.keyString[6] = "IDS_RATIO_STAT_MEDIAN_CHECK";
        hashMap.put("IDS_RATIO_STAT_MINIMUM_CHECK", "MIN");
        this.keyString[7] = "IDS_RATIO_STAT_MINIMUM_CHECK";
        hashMap.put("IDS_RATIO_STAT_MEAN_CENTERED_COV_CHECK", "MNCOV");
        this.keyString[8] = "IDS_RATIO_STAT_MEAN_CENTERED_COV_CHECK";
        hashMap.put("IDS_RATIO_STAT_PRD_CHECK", "PRD");
        this.keyString[9] = "IDS_RATIO_STAT_PRD_CHECK";
        hashMap.put("IDS_RATIO_STAT_RANGE_CHECK", "RANGE");
        this.keyString[10] = "IDS_RATIO_STAT_RANGE_CHECK";
        hashMap.put("IDS_RATIO_STAT_STD_DEV_CHECK", "STDDEV");
        this.keyString[11] = "IDS_RATIO_STAT_STD_DEV_CHECK";
        hashMap.put("IDS_RATIO_STAT_WEIGHTED_MEAN_CHECK", "WGTMEAN");
        this.keyString[12] = "IDS_RATIO_STAT_WEIGHTED_MEAN_CHECK";
        hashMap.put(RatioStatistics.BASIC_ACRWIDGET_ACTION_KEY, STAT_BASIC_ACRWIDGET_KEY);
        return hashMap;
    }
}

