/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.desc_stats.frequencies;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.desc_stats.frequencies.FreqCharts;
import com.spss.java_client.ui.dialogs.base.analyze.desc_stats.frequencies.FreqFormat;
import com.spss.java_client.ui.dialogs.base.analyze.desc_stats.frequencies.FreqStatistics;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BootstrapDlg;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.post_processing_output.TableStyleDlg;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class FrequenciesDlg
extends BaseProcedureDialog
implements ListDataListener {
    private static final String FREQ_TABLE_KEY = "IDS_FREQ_TABLE_CHECK";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetVarList;
    private JCheckBox mFreqCheck;
    private ArrowButton mArrowButton;
    private JButton mStatisticsButton;
    private JButton mChartButton;
    private JButton mFormatButton;
    private JButton mBootstrappingButton;
    private JButton mTableStyleButton;
    private boolean mIsBootstrapOK;
    private BootstrapDlg mBootstrapDlg;

    public FrequenciesDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle.getDefaultResourceBundleName(), AnalyzeResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_FREQUENCIES"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public boolean okPastePressed() {
        if (this.mIsBootstrapOK && BootstrapDlg.isStrataVariableListEmpty(this)) {
            this.runBootstrapSubDialog();
            return false;
        }
        return super.okPastePressed();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String generateSyntax() {
        String string;
        void var9_29;
        void var8_13;
        Object[] objectArray;
        String string2;
        Object object;
        String string3 = SyntaxUtil.startSyntax().toString();
        String string4 = this.mTargetVarList.getVariablesStringList();
        DialogDataModel dialogDataModel = (DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY);
        if (this.mIsBootstrapOK && dialogDataModel != null) {
            object = "";
            string3 = string3 + BootstrapDlg.getBootstrapSyntax((String)object, string4, dialogDataModel);
        }
        string3 = string3 + SyntaxUtil.getMainCommand("FREQUENCIES").toString();
        string3 = string3 + SyntaxUtil.getMainCommandParamters("VARIABLES=");
        string3 = string3 + string4;
        object = this.getDialogDataModel();
        Boolean bl = ((DialogDataModel)object).getBoolean(FREQ_TABLE_KEY);
        if (bl != null && !bl.booleanValue()) {
            string3 = string3 + "\n";
            string3 = string3 + SyntaxUtil.getSubCommand("/FORMAT=NOTABLE").toString();
        }
        if ((bl = ((DialogDataModel)object).getBoolean("IDS_QUARTILES")) != null && bl.booleanValue()) {
            string3 = string3 + "\n";
            string3 = string3 + SyntaxUtil.getSubCommand("/NTILES=4");
        }
        if ((bl = ((DialogDataModel)object).getBoolean("IDS_CUT_PTS_FOR")) != null && bl.booleanValue()) {
            string3 = string3 + "\n";
            string3 = string3 + SyntaxUtil.getSubCommand("/NTILES=");
            string3 = string3 + ((DialogDataModel)object).getString("IDS_CUT_PTS_EDIT");
        }
        if ((bl = ((DialogDataModel)object).getBoolean("IDS_PTILES")) != null && bl.booleanValue()) {
            string2 = "";
            for (Object object2 : objectArray = ((DialogDataModel)object).getArray("LIST_ACTION")) {
                string2 = string2 + object2.toString() + " ";
            }
            string3 = string3 + "\n";
            string3 = string3 + SyntaxUtil.getSubCommand("/PERCENTILES=");
            string3 = string3 + string2;
        }
        string2 = "";
        objectArray = this.getStatMap();
        for (Map.Entry<String, String> entry : objectArray.entrySet()) {
            if (entry.getKey().equals("IDS_MEDIAN") && FreqFormat.orderByCounts((DialogDataModel)object) || (bl = ((DialogDataModel)object).getBoolean(entry.getKey())) == null || !bl.booleanValue()) continue;
            string2 = string2 + entry.getValue() + " ";
        }
        if ((string2 = string2.trim()).length() > 0) {
            string3 = string3 + "\n";
            string3 = string3 + SyntaxUtil.getSubCommand("/STATISTICS=");
            string3 = string3 + string2;
        }
        if ((bl = ((DialogDataModel)object).getBoolean("IDS_GRP_MID_PTS")) != null && bl.booleanValue()) {
            string3 = string3 + "\n";
            string3 = string3 + SyntaxUtil.getSubCommand("/GROUPED=");
            string3 = string3 + string4;
        }
        String string5 = "";
        bl = ((DialogDataModel)object).getBoolean("IDS_FREQ_RADIO");
        if (bl != null && bl.booleanValue()) {
            String string6 = " FREQ";
        } else {
            String string7 = " PERCENT";
        }
        bl = ((DialogDataModel)object).getBoolean("IDS_BAR_RADIO");
        if (bl != null && bl.booleanValue()) {
            string3 = string3 + "\n";
            string3 = string3 + SyntaxUtil.getSubCommand("/BARCHART");
            string3 = string3 + (String)var8_13;
        }
        if ((bl = ((DialogDataModel)object).getBoolean("IDS_PIE_RADIO")) != null && bl.booleanValue()) {
            string3 = string3 + "\n";
            string3 = string3 + SyntaxUtil.getSubCommand("/PIECHART");
            string3 = string3 + (String)var8_13;
        }
        String string8 = "";
        bl = ((DialogDataModel)object).getBoolean("IDS_HISTO_CURVE");
        if (bl != null && bl.booleanValue()) {
            String string9 = " NORMAL";
        }
        if ((bl = ((DialogDataModel)object).getBoolean("IDS_HISTO_RADIO")) != null && bl.booleanValue()) {
            void var8_16;
            string3 = string3 + "\n";
            string3 = string3 + SyntaxUtil.getSubCommand("/HISTOGRAM");
            string3 = string3 + (String)var8_16;
        }
        String string10 = "";
        bl = ((DialogDataModel)object).getBoolean("IDS_AS_COUNTS_RADIO");
        if (bl != null && bl.booleanValue()) {
            String string11 = "AFREQ";
        }
        if ((bl = ((DialogDataModel)object).getBoolean("IDS_DES_COUNTS_RADIO")) != null && bl.booleanValue()) {
            String string12 = "DFREQ";
        }
        if ((bl = ((DialogDataModel)object).getBoolean("IDS_DESCENDING_RADIO")) != null && bl.booleanValue()) {
            String string13 = "DVALUE";
        }
        if ((bl = ((DialogDataModel)object).getBoolean("IDS_SUPPRESS_TABLES_CHECK")) != null && bl.booleanValue()) {
            void var9_27;
            void var9_25;
            String string14 = ((DialogDataModel)object).getString("IDS_MAX_CATS_EDIT");
            if (var9_25.length() > 0) {
                String string15 = (String)var9_25 + " ";
            }
            String string16 = (String)var9_27 + "LIMIT(" + string14 + ")";
        }
        if (var9_29.length() > 0) {
            string3 = string3 + "\n";
            string3 = string3 + SyntaxUtil.getSubCommand("/FORMAT=");
            string3 = string3 + (String)var9_29;
        }
        string3 = string3 + "\n";
        string3 = string3 + SyntaxUtil.getSubCommand("/ORDER=");
        bl = ((DialogDataModel)object).getBoolean("IDS_ORG_OUTPUT_RADIO");
        string3 = bl != null && bl != false ? string3 + "VARIABLE" : string3 + "ANALYSIS";
        string3 = string3 + SyntaxUtil.terminateSyntax();
        if (this.mIsBootstrapOK && dialogDataModel != null) {
            string3 = string3 + BootstrapDlg.getRestoreSyntax(dialogDataModel);
        }
        if ((string = TableStyleDlg.generateSyntax((DialogDataModel)object, TableStyleDlg.ConditionalFormatDlgType.Frequencies)) != null) {
            string3 = string3 + string;
            string3 = string3 + SyntaxUtil.terminateSyntax();
        }
        return string3;
    }

    @Override
    public final String getIActionKey() {
        return "analyze_desc_stat_frequency";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_freq";
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetVarList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mFreqCheck.setSelected(true);
        this.setDefaults();
        this.mBootstrapDlg.reset();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(true);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0);
    }

    boolean checkOutputSelections(boolean bl) {
        String[] stringArray;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        boolean bl2 = this.mFreqCheck.isSelected();
        if (!bl2) {
            stringArray = dialogDataModel.getBoolean("IDS_NONE_RADIO");
            boolean bl3 = bl2 = stringArray != null && !stringArray.booleanValue();
        }
        if (!bl2) {
            for (String string : stringArray = new String[]{"IDS_QUARTILES", "IDS_CUT_PTS_FOR", "IDS_GRP_MID_PTS", "IDS_KURT", "IDS_MAX", "IDS_MEAN", "IDS_MEDIAN", "IDS_MIN", "IDS_MODE", "IDS_PTILES", "IDS_RANGE", "IDS_SE_MEAN", "IDS_SKEWNESS", "IDS_STDDEV", "IDS_SUM", "IDS_DESC_FREQ_STATS_VARIANCE"}) {
                Boolean bl4 = dialogDataModel.getBoolean(string);
                if (bl4 == null || !bl4.booleanValue()) continue;
                bl2 = true;
                break;
            }
        }
        if (bl && !bl2) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_NO_OUTPUT_WARNING"), VersionInfo.getAppVersionString());
        }
        return bl2;
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        if (this.mSrcVarList.getModel().getSize() > 0) {
            this.mSrcVarList.setSelectedIndex(0);
        }
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.setupLists(jPanel);
        this.setDefaults();
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_COMMON_STATS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrequenciesDlg.this.runStatsSubDialog();
            }
        };
        this.mStatisticsButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mStatisticsButton);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_CHARTS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrequenciesDlg.this.runChartsSubDialog();
            }
        };
        this.mChartButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mChartButton);
        toggleButtonAction = new ToggleButtonAction("IDS_COMMON_FORMAT_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrequenciesDlg.this.runFormatSubDialog();
            }
        };
        this.mFormatButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mFormatButton);
        toggleButtonAction = new ToggleButtonAction("IDS_TABLE_STYLE_BUTTON_FREQUENCIES"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrequenciesDlg.this.runConditionalSubDialog();
            }
        };
        this.mTableStyleButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mTableStyleButton);
        this.mIsBootstrapOK = false;
        if (VersionInfo.allowBootstrapping()) {
            this.mIsBootstrapOK = true;
            toggleButtonAction = new ToggleButtonAction("IDS_COMMON_BOOTSTRAPPING_BUTTON"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FrequenciesDlg.this.runBootstrapSubDialog();
                }
            };
            this.mBootstrappingButton = new JButton(toggleButtonAction);
            this.addOptionsPanelButton(jPanel, this.mBootstrappingButton);
            if (BootstrapDlg.isCurrentDatasetInMIMode()) {
                this.mBootstrappingButton.setEnabled(false);
                this.mIsBootstrapOK = false;
            }
        }
        return jPanel;
    }

    private void setDefaults() {
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
    }

    private void setupLists(JPanel jPanel) {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.loadFromActiveDataset();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_DESC_STATS_FREQ_SOURCE_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(0, 0, 0, 0);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcVarList);
        jScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_VARIABLES_COLON");
        gridBagConstraints.weightx = 1.0;
        n = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, insets);
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.setMaxLimitOfList(500);
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jScrollPane = new JScrollPane(this.mTargetVarList);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 7 + 2));
        jScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 2, 1, 1, 1, n, insets);
        this.mTargetVarList.getModel().addListDataListener(this);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, FREQ_TABLE_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrequenciesDlg.this.checkOutputSelections(true);
            }
        };
        this.mFreqCheck = new JCheckBox(toggleButtonAction);
        insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mFreqCheck, gridBagConstraints, 0, 2, 3, 1, n, insets);
        this.mFreqCheck.setSelected(true);
        jLabel2.setLabelFor(this.mTargetVarList);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
    }

    private void runStatsSubDialog() {
        this.runSubDialog(new FreqStatistics(this));
    }

    private void runChartsSubDialog() {
        this.runSubDialog(new FreqCharts(this));
    }

    private void runFormatSubDialog() {
        this.runSubDialog(new FreqFormat(this));
    }

    private void runConditionalSubDialog() {
        this.runSubDialog(new TableStyleDlg(this, TableStyleDlg.ConditionalFormatDlgType.Frequencies));
    }

    private void runBootstrapSubDialog() {
        this.mBootstrapDlg = new BootstrapDlg(this);
        this.runSubDialog(this.mBootstrapDlg);
    }

    private HashMap<String, String> getStatMap() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("IDS_STDDEV", "STDDEV");
        linkedHashMap.put("IDS_DESC_FREQ_STATS_VARIANCE", "VARIANCE");
        linkedHashMap.put("IDS_RANGE", "RANGE");
        linkedHashMap.put("IDS_MIN", "MINIMUM");
        linkedHashMap.put("IDS_MAX", "MAXIMUM");
        linkedHashMap.put("IDS_SE_MEAN", "SEMEAN");
        linkedHashMap.put("IDS_MEAN", "MEAN");
        linkedHashMap.put("IDS_MEDIAN", "MEDIAN");
        linkedHashMap.put("IDS_MODE", "MODE");
        linkedHashMap.put("IDS_SUM", "SUM");
        linkedHashMap.put("IDS_SKEWNESS", "SKEWNESS SESKEW");
        linkedHashMap.put("IDS_KURT", "KURTOSIS SEKURT");
        return linkedHashMap;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetVarList);
        vector.add(this.mFreqCheck);
        vector.add(this.mStatisticsButton);
        vector.add(this.mChartButton);
        vector.add(this.mFormatButton);
        if (this.mTableStyleButton != null) {
            vector.add(this.mTableStyleButton);
        }
        if (this.mBootstrappingButton != null) {
            vector.add(this.mBootstrappingButton);
        }
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }
}

