/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.desc_stats.frequencies;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.ACREvent;
import com.spss.java_client.ui.controls.ACRWidget;
import com.spss.java_client.ui.controls.IACRListener;
import com.spss.java_client.ui.dialogs.base.analyze.desc_stats.frequencies.FreqFormat;
import com.spss.java_client.ui.dialogs.base.analyze.desc_stats.frequencies.FrequenciesDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class FreqStatistics
extends BaseSubDialog
implements ItemListener,
DocumentListener,
IACRListener {
    static final String QUARTILES_KEY = "IDS_QUARTILES";
    static final String CUT_POINTS_KEY = "IDS_CUT_PTS_FOR";
    static final String CUT_PTS_EDIT_KEY = "IDS_CUT_PTS_EDIT";
    static final String PTILES_KEY = "IDS_PTILES";
    static final String PTILES_EDIT_KEY = "IDS_PTILES_EDIT";
    static final String MEAN_KEY = "IDS_MEAN";
    static final String MEDIAN_KEY = "IDS_MEDIAN";
    static final String MODE_KEY = "IDS_MODE";
    static final String SUM_KEY = "IDS_SUM";
    static final String STDDEV_KEY = "IDS_STDDEV";
    static final String VARIANCE_KEY = "IDS_DESC_FREQ_STATS_VARIANCE";
    static final String RANGE_KEY = "IDS_RANGE";
    static final String MINIMUM_KEY = "IDS_MIN";
    static final String MAXIMUM_KEY = "IDS_MAX";
    static final String SE_MEAN_KEY = "IDS_SE_MEAN";
    static final String SKEWNESS_KEY = "IDS_SKEWNESS";
    static final String KURTOSIS_KEY = "IDS_KURT";
    static final String GROUP_MIDPOINTS_KEY = "IDS_GRP_MID_PTS";
    private JCheckBox mMedianCheck;
    private JCheckBox mCutPointsCheck;
    private IntTextField mCutPointsEdit;
    private JCheckBox mPTilesCheck;
    private FloatTextField mPercentilesEdit;
    private ACRWidget mACRWidget;
    private JCheckBox mGrpMidPtsCheck;
    private JCheckBox mQuartilesCheck;
    private JCheckBox mMeanCheck;
    private JCheckBox mModeCheck;
    private JCheckBox mSumCheck;
    private JCheckBox mStddevCheck;
    private JCheckBox mVarianceCheck;
    private JCheckBox mRangeCheck;
    private JCheckBox mMinimumCheck;
    private JCheckBox mMaximumCheck;
    private JCheckBox mSeMeanCheck;
    private JCheckBox mSkewnessCheck;
    private JCheckBox mKurtosisCheck;

    FreqStatistics(FrequenciesDlg frequenciesDlg) {
        super(frequenciesDlg, frequenciesDlg.getResString("IDS_FREQ_STATS_TITLE"), true);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        Object object = itemEvent.getItem();
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (object == this.mCutPointsCheck) {
            this.mCutPointsEdit.setEnabled(bl);
            this.mCutPointsEdit.setOpaque(bl);
            this.updateContinueButton();
        } else if (object == this.mPTilesCheck) {
            this.mPercentilesEdit.setEnabled(bl);
            this.mPercentilesEdit.setOpaque(bl);
            this.mACRWidget.setEnabled(bl);
            this.updateContinueButton();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void listChanged(ACREvent aCREvent) {
        this.updateContinueButton();
    }

    @Override
    public boolean continuePressed() {
        boolean bl;
        boolean bl2 = bl = this.mPercentilesEdit.getText().length() > 0;
        if (bl && 0 != SpssAlertOptionPane.showConfirmDialog(this.getOwner(), ResUtil.getCommonDlgString("ERR_ACR_CONTINUE_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) {
            return false;
        }
        this.saveState(((BaseProcedureDialog)((Object)this.getParent())).getDialogDataModel());
        ((FrequenciesDlg)this.mParentDlg).checkOutputSelections(true);
        this.mPercentilesEdit.setText("");
        return true;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_freq_stat";
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.setupPTilePanel(jPanel);
        this.setupTendancyPanel(jPanel);
        this.setupDispersionPanel(jPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets.bottom = DialogUtil.getComponentGroupGap();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, GROUP_MIDPOINTS_KEY);
        this.mGrpMidPtsCheck = new JCheckBox(toggleButtonAction);
        DialogUtil.addUsingGBL(jPanel, this.mGrpMidPtsCheck, gridBagConstraints, 1, 1, 1, 1, n, insets);
        this.setupDistributionPanel(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        return super.saveState(dialogDataModel);
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        if (this.mMedianCheck != null) {
            this.mMedianCheck.setEnabled(!FreqFormat.orderByCounts(dialogDataModel));
        }
    }

    private void setupPTilePanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(true);
        jPanel2.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_PTILE_VALUES"));
        jPanel2.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, QUARTILES_KEY);
        this.mQuartilesCheck = new JCheckBox(toggleButtonAction);
        DialogUtil.addUsingGBL(jPanel2, this.mQuartilesCheck, gridBagConstraints, 0, 0, 3, 1, n, insets);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, CUT_POINTS_KEY);
        this.mCutPointsCheck = new JCheckBox(toggleButtonAction);
        this.mCutPointsCheck.addItemListener(this);
        DialogUtil.addUsingGBL(jPanel2, this.mCutPointsCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.mCutPointsEdit = new IntTextField(2, 100, true);
        this.mCutPointsEdit.setAction((Action)new TextFieldAction(this.mParentDlg, CUT_PTS_EDIT_KEY));
        Dimension dimension = (Dimension)this.mCutPointsEdit.getPreferredSize().clone();
        dimension.width = 60;
        this.mCutPointsEdit.setPreferredSize(dimension);
        gridBagConstraints.weightx = 1.0;
        Insets insets2 = new Insets(insets.top, 0, insets.bottom, 2);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mCutPointsEdit, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        this.mCutPointsEdit.setText("10");
        this.mCutPointsEdit.setEnabled(false);
        this.mCutPointsEdit.setOpaque(false);
        this.mCutPointsEdit.getDocument().addDocumentListener(this);
        JLabel jLabel = new JLabel(this.getResString("IDS_CUT_PTS_EDIT_LABEL"), 2);
        jLabel.setLabelFor((Component)this.mCutPointsEdit);
        insets2 = new Insets(insets.top + 2, insets.left, 0, n2);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 2, 1, 1, 1, n, insets2);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, PTILES_KEY);
        this.mPTilesCheck = new JCheckBox(toggleButtonAction);
        this.mPTilesCheck.addItemListener(this);
        DialogUtil.addUsingGBL(jPanel2, this.mPTilesCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        this.mPercentilesEdit = new FloatTextField(0.0, 100.0, 4, true);
        this.mPercentilesEdit.setAction((Action)new TextFieldAction(this.mParentDlg, PTILES_EDIT_KEY));
        dimension = (Dimension)this.mPercentilesEdit.getPreferredSize().clone();
        dimension.width = 60;
        this.mPercentilesEdit.setPreferredSize(dimension);
        gridBagConstraints.weightx = 1.0;
        insets2 = new Insets(insets.top, 0, insets.bottom, 2);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mPercentilesEdit, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        this.mPercentilesEdit.setEnabled(false);
        this.mPercentilesEdit.setOpaque(false);
        this.mACRWidget = new ACRWidget((JTextField)this.mPercentilesEdit);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets2 = new Insets(insets.top, 20, n2, n2);
        DialogUtil.addUsingGBL(jPanel2, this.mACRWidget, gridBagConstraints, 0, 3, 3, 1, n, insets2);
        this.mACRWidget.addACRListener(this);
        this.addListDataListenerToACRList();
        DialogUtil.createButtonGroup(jPanel2);
        n = 23;
        int n3 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.fill = 1;
        insets2 = new Insets(0, 0, n3, n3);
        this.mACRWidget.getList().setEnabled(false);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 2, n, insets2);
    }

    private void setupTendancyPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(true);
        jPanel2.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_CENTRAL_TENDANCY"));
        jPanel2.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, MEAN_KEY);
        this.mMeanCheck = new JCheckBox(toggleButtonAction);
        DialogUtil.addUsingGBL(jPanel2, this.mMeanCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, MEDIAN_KEY);
        this.mMedianCheck = new JCheckBox(toggleButtonAction);
        DialogUtil.addUsingGBL(jPanel2, this.mMedianCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, MODE_KEY);
        this.mModeCheck = new JCheckBox(toggleButtonAction);
        DialogUtil.addUsingGBL(jPanel2, this.mModeCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, SUM_KEY);
        this.mSumCheck = new JCheckBox(toggleButtonAction);
        DialogUtil.addUsingGBL(jPanel2, this.mSumCheck, gridBagConstraints, 0, 3, 1, 1, n, insets);
        DialogUtil.createButtonGroup(jPanel2);
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(0, 0, n2, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets2);
    }

    private void setupDispersionPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(true);
        jPanel2.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_DISPERSION"));
        jPanel2.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, STDDEV_KEY);
        this.mStddevCheck = new JCheckBox(toggleButtonAction);
        DialogUtil.addUsingGBL(jPanel2, this.mStddevCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, VARIANCE_KEY);
        this.mVarianceCheck = new JCheckBox(toggleButtonAction);
        DialogUtil.addUsingGBL(jPanel2, this.mVarianceCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, RANGE_KEY);
        this.mRangeCheck = new JCheckBox(toggleButtonAction);
        DialogUtil.addUsingGBL(jPanel2, this.mRangeCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, MINIMUM_KEY);
        this.mMinimumCheck = new JCheckBox(toggleButtonAction);
        DialogUtil.addUsingGBL(jPanel2, this.mMinimumCheck, gridBagConstraints, 1, 0, 1, 1, n, insets);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, MAXIMUM_KEY);
        this.mMaximumCheck = new JCheckBox(toggleButtonAction);
        DialogUtil.addUsingGBL(jPanel2, this.mMaximumCheck, gridBagConstraints, 1, 1, 1, 1, n, insets);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, SE_MEAN_KEY);
        this.mSeMeanCheck = new JCheckBox(toggleButtonAction);
        DialogUtil.addUsingGBL(jPanel2, this.mSeMeanCheck, gridBagConstraints, 1, 2, 1, 1, n, insets);
        DialogUtil.createButtonGroup(jPanel2);
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(0, 0, 0, n2);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets2);
    }

    private void setupDistributionPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(true);
        jPanel2.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_DISTRIBUTION"));
        jPanel2.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, SKEWNESS_KEY);
        this.mSkewnessCheck = new JCheckBox(toggleButtonAction);
        DialogUtil.addUsingGBL(jPanel2, this.mSkewnessCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, KURTOSIS_KEY);
        this.mKurtosisCheck = new JCheckBox(toggleButtonAction);
        DialogUtil.addUsingGBL(jPanel2, this.mKurtosisCheck, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.createButtonGroup(jPanel2);
        Insets insets2 = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 2, 1, 1, n, insets2);
    }

    private void updateContinueButton() {
        boolean bl = true;
        if (this.mCutPointsCheck.isSelected()) {
            boolean bl2 = bl = this.mCutPointsEdit.getText().length() > 0;
        }
        if (bl && this.mPTilesCheck.isSelected()) {
            bl = this.mACRWidget.getList().getModel().getSize() > 0;
        }
        this.enableContinue(bl);
    }

    private void addListDataListenerToACRList() {
        this.mACRWidget.getList().getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                if (listDataEvent.getSource() instanceof DefaultListModel) {
                    DefaultListModel defaultListModel = (DefaultListModel)listDataEvent.getSource();
                    defaultListModel.removeListDataListener(this);
                    Object[] objectArray = defaultListModel.toArray();
                    float[] fArray = new float[objectArray.length];
                    for (int i = 0; i < objectArray.length; ++i) {
                        fArray[i] = Float.parseFloat((String)objectArray[i]);
                    }
                    Arrays.sort(fArray);
                    defaultListModel.removeAllElements();
                    for (float f : fArray) {
                        defaultListModel.addElement(Float.toString(f));
                    }
                    defaultListModel.addListDataListener(this);
                }
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
            }

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
            }
        });
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mQuartilesCheck);
        vector.add(this.mCutPointsCheck);
        vector.add(this.mCutPointsEdit);
        vector.add(this.mPTilesCheck);
        vector.add(this.mPercentilesEdit);
        Component[] componentArray = new Component[3];
        for (n = 0; n < this.mACRWidget.getComponentCount() - 1; ++n) {
            componentArray[n] = this.mACRWidget.getComponent(n);
        }
        vector.add(componentArray[0]);
        vector.add(componentArray[1]);
        vector.add(componentArray[2]);
        vector.add(this.mACRWidget.getList());
        vector.add(this.mStddevCheck);
        vector.add(this.mVarianceCheck);
        vector.add(this.mRangeCheck);
        vector.add(this.mMinimumCheck);
        vector.add(this.mMaximumCheck);
        vector.add(this.mSeMeanCheck);
        vector.add(this.mMeanCheck);
        vector.add(this.mMedianCheck);
        vector.add(this.mModeCheck);
        vector.add(this.mSumCheck);
        vector.add(this.mGrpMidPtsCheck);
        vector.add(this.mSkewnessCheck);
        vector.add(this.mKurtosisCheck);
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }
}

