/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.desc_stats.frequencies;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.desc_stats.frequencies.FrequenciesDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class FreqCharts
extends BaseSubDialog
implements ItemListener {
    static final String NONE_RADIO_KEY = "IDS_NONE_RADIO";
    static final String BAR_CHART_RADIO_KEY = "IDS_BAR_RADIO";
    static final String PIE_CHART_RADIO_KEY = "IDS_PIE_RADIO";
    static final String HISTOGRAM_RADIO_KEY = "IDS_HISTO_RADIO";
    static final String HISTOGRAM_CURVE_KEY = "IDS_HISTO_CURVE";
    static final String FREQUENCIES_RADIO_KEY = "IDS_FREQ_RADIO";
    static final String PERCENTAGES_RADIO_KEY = "IDS_PCT_RADIO";
    private JRadioButton mNoneRadio;
    private JRadioButton mHistogramRadio;
    private JCheckBox mHistoCurveCheck;
    private JPanel mChartValuesPanel;
    private JRadioButton mFreqRadio;
    private JRadioButton mPctRadio;
    private JRadioButton mBarchartRadio;
    private JRadioButton mPichartRadio;
    private SpssButtonGroup mChartTypeButtonGroup;
    private SpssButtonGroup mChartValueButtonGroup;

    public FreqCharts(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_FREQ_CHARTS_TITLE"), true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.mHistoCurveCheck.setEnabled(this.mHistogramRadio.isSelected());
        this.mFreqRadio.setEnabled(this.mPichartRadio.isSelected() || this.mBarchartRadio.isSelected());
        this.mPctRadio.setEnabled(this.mPichartRadio.isSelected() || this.mBarchartRadio.isSelected());
        this.mChartValuesPanel.setEnabled(this.mPichartRadio.isSelected() || this.mBarchartRadio.isSelected());
        this.mHistoCurveCheck.setEnabled(this.mHistogramRadio.isSelected());
    }

    @Override
    public boolean continuePressed() {
        if (this.mNoneRadio.isSelected()) {
            ((BaseProcedureDialog)((Object)this.getParent())).getDialogDataModel().putBoolean(NONE_RADIO_KEY, true);
            ((FrequenciesDlg)this.mParentDlg).checkOutputSelections(true);
        }
        return true;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_freq_chart";
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.setupChartTypePanel(jPanel);
        this.setupChartValuesPanel(jPanel);
        this.setDefaults();
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void setDefaults() {
        this.mHistoCurveCheck.setEnabled(this.mHistogramRadio.isSelected());
        this.mFreqRadio.setEnabled(this.mPichartRadio.isSelected() || this.mBarchartRadio.isSelected());
        this.mPctRadio.setEnabled(this.mPichartRadio.isSelected() || this.mBarchartRadio.isSelected());
        this.mChartValuesPanel.setEnabled(this.mPichartRadio.isSelected() || this.mBarchartRadio.isSelected());
        this.mHistoCurveCheck.setEnabled(this.mHistogramRadio.isSelected());
    }

    private void setupChartTypePanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(true);
        jPanel2.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_CHART_TYPE"));
        jPanel2.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        this.mChartTypeButtonGroup = new SpssButtonGroup();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, NONE_RADIO_KEY);
        this.mNoneRadio = new JRadioButton(toggleButtonAction);
        DialogUtil.addUsingGBL(jPanel2, this.mNoneRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mChartTypeButtonGroup.add(this.mNoneRadio);
        this.mNoneRadio.setSelected(true);
        this.mNoneRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, BAR_CHART_RADIO_KEY);
        this.mBarchartRadio = new JRadioButton(toggleButtonAction);
        DialogUtil.addUsingGBL(jPanel2, this.mBarchartRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.mChartTypeButtonGroup.add(this.mBarchartRadio);
        this.mBarchartRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, PIE_CHART_RADIO_KEY);
        this.mPichartRadio = new JRadioButton(toggleButtonAction);
        DialogUtil.addUsingGBL(jPanel2, this.mPichartRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        this.mChartTypeButtonGroup.add(this.mPichartRadio);
        this.mPichartRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, HISTOGRAM_RADIO_KEY);
        this.mHistogramRadio = new JRadioButton(toggleButtonAction);
        DialogUtil.addUsingGBL(jPanel2, this.mHistogramRadio, gridBagConstraints, 0, 3, 1, 1, n, insets);
        this.mChartTypeButtonGroup.add(this.mHistogramRadio);
        this.mHistogramRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, HISTOGRAM_CURVE_KEY);
        this.mHistoCurveCheck = new JCheckBox(toggleButtonAction);
        Insets insets2 = new Insets(insets.top, insets.left + 20, insets.bottom, insets.right);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel2, this.mHistoCurveCheck, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        this.mHistoCurveCheck.setEnabled(false);
        int n2 = DialogUtil.getComponentGroupGap();
        insets2 = new Insets(0, 0, n2, 0);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets2);
    }

    private void setupChartValuesPanel(JPanel jPanel) {
        this.mChartValuesPanel = new JPanel(true);
        this.mChartValuesPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_CHART_VALUES"));
        this.mChartValuesPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        this.mChartValueButtonGroup = new SpssButtonGroup();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, FREQUENCIES_RADIO_KEY);
        this.mFreqRadio = new JRadioButton(toggleButtonAction);
        DialogUtil.addUsingGBL(this.mChartValuesPanel, this.mFreqRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mChartValueButtonGroup.add(this.mFreqRadio);
        this.mFreqRadio.setSelected(true);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, PERCENTAGES_RADIO_KEY);
        this.mPctRadio = new JRadioButton(toggleButtonAction);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(this.mChartValuesPanel, this.mPctRadio, gridBagConstraints, 1, 0, 1, 1, n, insets);
        this.mChartValueButtonGroup.add(this.mPctRadio);
        Insets insets2 = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mChartValuesPanel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mChartTypeButtonGroup);
        vector.add(this.mHistoCurveCheck);
        vector.add(this.mChartValueButtonGroup);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }
}

