/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.desc_stats.explore;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.desc_stats.explore.ExploreOptions;
import com.spss.java_client.ui.dialogs.base.analyze.desc_stats.explore.ExplorePlots;
import com.spss.java_client.ui.dialogs.base.analyze.desc_stats.explore.ExploreStatistics;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BootstrapDlg;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ExploreDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener {
    private static final String DISPBOTH_KEY = "IDS_EXPLORE_DISPBOTH";
    private static final String DISPSTATS_KEY = "IDS_EXPLORE_DISPSTATS";
    private static final String DISPPLOTS_KEY = "IDS_EXPLORE_DISPPLOTS";
    static final String TARGETLISTDEPENDENTKEY = "TARGET_LIST_DEPENDENT";
    static final String TARGETLISTFACTORKEY = "TARGET_LIST_FACTOR";
    static final String TARGETLISTLABELCASEKEY = "TARGET_LIST_LABELCASE";
    static final String EXPLORE_PLOTS_KEY = "IDS_EXPLORE_PLOTS_3DOTS";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetDependList;
    private TargetVariableList mTargetFactorList;
    private TargetVariableList mTargetLabelList;
    private JRadioButton mExpBothRadio;
    private JRadioButton mExpStatsRadio;
    private JRadioButton mExpPlotsRadio;
    private JScrollPane mScrollPaneSourcelist;
    private JScrollPane mScrollPaneDependentlist;
    private JScrollPane mScrollPaneLabellist;
    private JScrollPane mScrollPaneFactorlist;
    private ArrowButton mArrowButtonDependlist;
    private JLabel mDependList;
    private ArrowButton mArrowButtonFactorlist;
    private JLabel mFactorList;
    private ArrowButton mArrowButtonLabellist;
    private JLabel mLabelList;
    private SpssButtonGroup mGroupDisp;
    private static boolean mValChk = false;
    private static JButton mStat;
    private static JButton mPlots;
    private static JButton mOpt;
    private JButton mBootstrappingButton;
    private StringBuffer mSyntax;
    private Insets mInsets;
    private boolean mIsBootstrapOK;

    public ExploreDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle.getDefaultResourceBundleName(), AnalyzeResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_EXPLORE"));
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mExpStatsRadio) {
            mStat.setEnabled(true);
            mPlots.setEnabled(false);
        }
        if (object == this.mExpPlotsRadio) {
            mPlots.setEnabled(true);
            mStat.setEnabled(false);
        }
        if (object == this.mExpBothRadio) {
            mStat.setEnabled(true);
            mPlots.setEnabled(true);
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_exam";
    }

    @Override
    public boolean okPastePressed() {
        if (this.mIsBootstrapOK && BootstrapDlg.isStrataVariableListEmpty(this)) {
            this.runBootstrapSubDialog();
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    public String generateSyntax() {
        DialogDataModel dialogDataModel;
        Boolean bl;
        String string;
        String string2;
        this.mSyntax.delete(0, this.mSyntax.length());
        DialogDataModel dialogDataModel2 = (DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY);
        if (this.mIsBootstrapOK && dialogDataModel2 != null) {
            string2 = this.mTargetDependList.getVariablesStringList();
            string = this.mTargetFactorList.getVariablesStringList();
            this.mSyntax.append(BootstrapDlg.getBootstrapSyntax(string2, string, dialogDataModel2));
        }
        this.mSyntax.append(SyntaxUtil.getMainCommand("EXAMINE"));
        string2 = this.mTargetDependList.getVariablesStringList();
        string = this.mTargetFactorList.getVariablesStringList();
        String string3 = this.mTargetLabelList.getVariablesStringList();
        this.mSyntax.append(SyntaxUtil.getMainCommandParamters("VARIABLES="));
        this.mSyntax.append(string2);
        int n = string.length();
        if (n != 0) {
            this.mSyntax.append(" BY " + string);
        }
        if ((n = string3.length()) != 0) {
            this.mSyntax.append("\n");
            this.mSyntax.append(SyntaxUtil.getSubCommand("/ID="));
            this.mSyntax.append(string3);
        }
        if ((bl = (dialogDataModel = this.getDialogDataModel()).getBoolean(DISPSTATS_KEY)) != null && bl.booleanValue()) {
            this.mSyntax.append("\n");
            this.mSyntax.append(SyntaxUtil.getSubCommand("/PLOT NONE"));
        }
        this.generatePlotsSyntax();
        this.generateStatisticsSyntax();
        this.generateOptionsSyntax();
        this.mSyntax.append("\n");
        this.mSyntax.append(SyntaxUtil.getSubCommand("/NOTOTAL"));
        this.mSyntax.append(SyntaxUtil.terminateSyntax());
        if (this.mIsBootstrapOK && dialogDataModel2 != null) {
            this.mSyntax.append(BootstrapDlg.getRestoreSyntax(dialogDataModel2));
        }
        return this.mSyntax.toString();
    }

    public void generatePlotsSyntax() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean(DISPSTATS_KEY);
        if (bl != null && !bl.booleanValue()) {
            String string;
            int n;
            bl = dialogDataModel.getBoolean("IDS_EXPLORE_PLOTS_FACTORLEVEL");
            if (bl != null && bl.booleanValue()) {
                this.mSyntax.append("\n");
                this.mSyntax.append(SyntaxUtil.getSubCommand("/PLOT BOXPLOT"));
                bl = dialogDataModel.getBoolean("IDS_EXPLORE_PLOTS_SALCHECK");
                if (bl != null && bl.booleanValue()) {
                    this.mSyntax.append(" STEMLEAF");
                }
                if ((bl = dialogDataModel.getBoolean("IDS_EXPLORE_PLOTS_HISTOCHECK")) != null && bl.booleanValue()) {
                    this.mSyntax.append(" HISTOGRAM");
                }
                if ((bl = dialogDataModel.getBoolean("IDS_EXPLORE_PLOTS_NORMCHECK")) != null && bl.booleanValue()) {
                    this.mSyntax.append(" NPPLOT");
                }
                bl = dialogDataModel.getBoolean("IDS_EXPLORE_PLOTS_NONELEVENE");
                bl = dialogDataModel.getBoolean("IDS_EXPLORE_PLOTS_POWEREST");
                if (bl != null && bl.booleanValue()) {
                    this.mSyntax.append(" SPREADLEVEL");
                }
                if ((bl = dialogDataModel.getBoolean("IDS_EXPLORE_PLOTS_TRANSFORMED")) != null && bl.booleanValue()) {
                    n = dialogDataModel.getInteger("IDS_EXPLORE_PLOTS_COMBOTEXT");
                    string = "0";
                    switch (n) {
                        case 0: {
                            string = "0";
                            break;
                        }
                        case 4: {
                            string = "2";
                            break;
                        }
                        case 5: {
                            string = "3";
                            break;
                        }
                        case 3: {
                            string = "0.5";
                            break;
                        }
                        case 1: {
                            string = "-0.5";
                            break;
                        }
                        case 2: {
                            string = "-1";
                            break;
                        }
                        default: {
                            string = "0";
                        }
                    }
                    this.mSyntax.append(" SPREADLEVEL(" + string + ")");
                }
                if ((bl = dialogDataModel.getBoolean("IDS_EXPLORE_PLOTS_UNTRANSFORMED")) != null && bl.booleanValue()) {
                    this.mSyntax.append(" SPREADLEVEL(1)");
                }
                this.mSyntax.append("\n");
                this.mSyntax.append(SyntaxUtil.getSubCommand("/COMPARE GROUPS"));
            } else if (bl == null && (this.mExpPlotsRadio.isSelected() || this.mExpBothRadio.isSelected())) {
                this.mSyntax.append("\n");
                this.mSyntax.append(SyntaxUtil.getSubCommand("/PLOT BOXPLOT"));
                this.mSyntax.append(" STEMLEAF");
                this.mSyntax.append("\n");
                this.mSyntax.append(SyntaxUtil.getSubCommand("/COMPARE GROUPS"));
            }
            bl = dialogDataModel.getBoolean("IDS_EXPLORE_PLOTS_DEPENDENTTOGETHER");
            if (bl != null && bl.booleanValue()) {
                this.mSyntax.append("\n");
                this.mSyntax.append(SyntaxUtil.getSubCommand("/PLOT BOXPLOT"));
                bl = dialogDataModel.getBoolean("IDS_EXPLORE_PLOTS_SALCHECK");
                if (bl != null && bl.booleanValue()) {
                    this.mSyntax.append(" STEMLEAF");
                }
                if ((bl = dialogDataModel.getBoolean("IDS_EXPLORE_PLOTS_HISTOCHECK")) != null && bl.booleanValue()) {
                    this.mSyntax.append(" HISTOGRAM");
                }
                if ((bl = dialogDataModel.getBoolean("IDS_EXPLORE_PLOTS_NORMCHECK")) != null && bl.booleanValue()) {
                    this.mSyntax.append(" NPPLOT");
                }
                bl = dialogDataModel.getBoolean("IDS_EXPLORE_PLOTS_NONELEVENE");
                bl = dialogDataModel.getBoolean("IDS_EXPLORE_PLOTS_POWEREST");
                if (bl != null && bl.booleanValue()) {
                    this.mSyntax.append(" SPREADLEVEL");
                }
                if ((bl = dialogDataModel.getBoolean("IDS_EXPLORE_PLOTS_TRANSFORMED")) != null && bl.booleanValue()) {
                    n = dialogDataModel.getInteger("IDS_EXPLORE_PLOTS_COMBOTEXT");
                    string = "0";
                    switch (n) {
                        case 0: {
                            string = "0";
                            break;
                        }
                        case 4: {
                            string = "2";
                            break;
                        }
                        case 5: {
                            string = "3";
                            break;
                        }
                        case 3: {
                            string = "0.5";
                            break;
                        }
                        case 1: {
                            string = "-0.5";
                            break;
                        }
                        case 2: {
                            string = "-1";
                            break;
                        }
                        default: {
                            string = "0";
                        }
                    }
                    this.mSyntax.append(" SPREADLEVEL(" + string + ")");
                }
                if ((bl = dialogDataModel.getBoolean("IDS_EXPLORE_PLOTS_UNTRANSFORMED")) != null && bl.booleanValue()) {
                    this.mSyntax.append(" SPREADLEVEL(1)");
                }
                this.mSyntax.append("\n");
                this.mSyntax.append(SyntaxUtil.getSubCommand("/COMPARE VARIABLES"));
            }
            if ((bl = dialogDataModel.getBoolean("IDS_EXPLORE_PLOTS_BOXPLOTSNONE")) != null && bl.booleanValue()) {
                this.mSyntax.append("\n");
                this.mSyntax.append(SyntaxUtil.getSubCommand("/PLOT"));
                bl = dialogDataModel.getBoolean("IDS_EXPLORE_PLOTS_SALCHECK");
                if (bl != null && bl.booleanValue()) {
                    this.mSyntax.append(" STEMLEAF");
                }
                if ((bl = dialogDataModel.getBoolean("IDS_EXPLORE_PLOTS_HISTOCHECK")) != null && bl.booleanValue()) {
                    this.mSyntax.append(" HISTOGRAM");
                }
                if ((bl = dialogDataModel.getBoolean("IDS_EXPLORE_PLOTS_NORMCHECK")) != null && bl.booleanValue()) {
                    this.mSyntax.append(" NPPLOT");
                }
                bl = dialogDataModel.getBoolean("IDS_EXPLORE_PLOTS_NONELEVENE");
                bl = dialogDataModel.getBoolean("IDS_EXPLORE_PLOTS_POWEREST");
                if (bl != null && bl.booleanValue()) {
                    this.mSyntax.append(" SPREADLEVEL");
                }
                if ((bl = dialogDataModel.getBoolean("IDS_EXPLORE_PLOTS_TRANSFORMED")) != null && bl.booleanValue()) {
                    n = dialogDataModel.getInteger("IDS_EXPLORE_PLOTS_COMBOTEXT");
                    string = "0";
                    switch (n) {
                        case 0: {
                            string = "0";
                            break;
                        }
                        case 4: {
                            string = "2";
                            break;
                        }
                        case 5: {
                            string = "3";
                            break;
                        }
                        case 3: {
                            string = "0.5";
                            break;
                        }
                        case 1: {
                            string = "-0.5";
                            break;
                        }
                        case 2: {
                            string = "-1";
                            break;
                        }
                        default: {
                            string = "0";
                        }
                    }
                    this.mSyntax.append(" SPREADLEVEL(" + string + ")");
                }
                if ((bl = dialogDataModel.getBoolean("IDS_EXPLORE_PLOTS_UNTRANSFORMED")) != null && bl.booleanValue()) {
                    this.mSyntax.append(" SPREADLEVEL(1)");
                }
            }
        }
    }

    public void generateStatisticsSyntax() {
        Boolean bl;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        dialogDataModel = this.getDialogDataModel();
        Boolean bl2 = dialogDataModel.getBoolean(DISPPLOTS_KEY);
        if (bl2 != null && bl2.booleanValue()) {
            this.mSyntax.append("\n");
            this.mSyntax.append(SyntaxUtil.getSubCommand("/STATISTICS NONE"));
            bl = dialogDataModel.getBoolean("IDS_EXPLORE_DESCRIPTIVES");
            if (bl == null) {
                this.mSyntax.append("\n");
                this.mSyntax.append(SyntaxUtil.getSubCommand("/CINTERVAL 95"));
            } else if (bl.booleanValue()) {
                this.mSyntax.append("\n");
                this.mSyntax.append(SyntaxUtil.getSubCommand("/CINTERVAL "));
                this.mSyntax.append(dialogDataModel.getString("IDS_EXPLORE_STATS_MEAN"));
            }
        }
        if ((bl2 = dialogDataModel.getBoolean(DISPPLOTS_KEY)) != null && !bl2.booleanValue()) {
            bl2 = dialogDataModel.getBoolean("IDS_EXPLORE_MESTIMATES");
            if (bl2 != null && bl2.booleanValue()) {
                this.mSyntax.append("\n");
                this.mSyntax.append(SyntaxUtil.getSubCommand("/MESTIMATORS HUBER(1.339) ANDREW(1.34) HAMPEL(1.7,3.4,8.5) TUKEY(4.685)"));
            }
            if ((bl2 = dialogDataModel.getBoolean("IDS_EXPLORE_PERCENTILES")) != null && bl2.booleanValue()) {
                this.mSyntax.append("\n");
                this.mSyntax.append(SyntaxUtil.getSubCommand("/PERCENTILES(5,10,25,50,75,90,95) HAVERAGE"));
            }
            if ((bl2 = dialogDataModel.getBoolean("IDS_EXPLORE_DESCRIPTIVES")) != null && bl2.booleanValue()) {
                this.mSyntax.append("\n");
                this.mSyntax.append(SyntaxUtil.getSubCommand("/STATISTICS DESCRIPTIVES"));
                bl2 = dialogDataModel.getBoolean("IDS_EXPLORE_OUTLIERS");
                if (bl2 != null && bl2.booleanValue()) {
                    this.mSyntax.append(" EXTREME");
                }
                this.mSyntax.append("\n");
                this.mSyntax.append(SyntaxUtil.getSubCommand("/CINTERVAL "));
                this.mSyntax.append(dialogDataModel.getString("IDS_EXPLORE_STATS_MEAN"));
            } else if (bl2 == null && (this.mExpStatsRadio.isSelected() || this.mExpBothRadio.isSelected())) {
                this.mSyntax.append("\n");
                this.mSyntax.append(SyntaxUtil.getSubCommand("/STATISTICS DESCRIPTIVES"));
                this.mSyntax.append("\n");
                this.mSyntax.append(SyntaxUtil.getSubCommand("/CINTERVAL 95"));
            }
            bl2 = dialogDataModel.getBoolean("IDS_EXPLORE_OUTLIERS");
            bl = dialogDataModel.getBoolean("IDS_EXPLORE_DESCRIPTIVES");
            if (bl2 != null && bl2.booleanValue() && bl != null && !bl.booleanValue()) {
                this.mSyntax.append("\n");
                this.mSyntax.append(SyntaxUtil.getSubCommand("/STATISTICS EXTREME"));
            }
            bl2 = dialogDataModel.getBoolean("IDS_EXPLORE_DESCRIPTIVES");
            bl = dialogDataModel.getBoolean("IDS_EXPLORE_OUTLIERS");
            if (bl2 != null && !bl2.booleanValue() && bl != null && !bl.booleanValue()) {
                this.mSyntax.append("\n");
                this.mSyntax.append(SyntaxUtil.getSubCommand("/STATISTICS NONE"));
            }
        }
    }

    public void generateOptionsSyntax() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean("IDS_EXPLORE_OPTIONS_LISTWISE");
        if (bl != null && bl.booleanValue()) {
            this.mSyntax.append("\n");
            this.mSyntax.append(SyntaxUtil.getSubCommand("/MISSING LISTWISE"));
        } else if (bl == null) {
            this.mSyntax.append("\n");
            this.mSyntax.append(SyntaxUtil.getSubCommand("/MISSING LISTWISE"));
        }
        bl = dialogDataModel.getBoolean("IDS_EXPLORE_OPTIONS_PAIRWISE");
        if (bl != null && bl.booleanValue()) {
            this.mSyntax.append("\n");
            this.mSyntax.append(SyntaxUtil.getSubCommand("/MISSING PAIRWISE"));
        }
        if ((bl = dialogDataModel.getBoolean("IDS_EXPLORE_OPTIONS_REPORTVAL")) != null && bl.booleanValue()) {
            this.mSyntax.append("\n");
            this.mSyntax.append(SyntaxUtil.getSubCommand("/MISSING REPORT"));
        }
    }

    @Override
    public final String getIActionKey() {
        return "analyze_desc_stat_explore";
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetDependList.removeAll();
        this.mTargetFactorList.removeAll();
        this.mTargetLabelList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.setDefaults();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetDependList.getModel().getSize() > 0);
        if (this.mTargetFactorList.getModel().getSize() > 0) {
            mValChk = true;
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetDependList.getModel().getSize() > 0);
        if (this.mTargetFactorList.getModel().getSize() == 0) {
            mValChk = false;
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetDependList.getModel().getSize() > 0);
        mValChk = this.mTargetFactorList.getModel().getSize() > 0;
    }

    public static boolean getValChk() {
        return mValChk;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        this.mInsets = new Insets(0, 0, 0, 0);
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupLists();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, 23, null);
        JPanel jPanel3 = this.setupDisplayPanel();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.mInsets.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, 23, this.mInsets);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        String string = "IDS_COMMON_STATS_3DOT";
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(string){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExploreDlg.this.runStatsSubDialog();
            }
        };
        mStat = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, mStat);
        string = "IDS_COMMON_PLOTS_BUTTON";
        toggleButtonAction = new ToggleButtonAction(string){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExploreDlg.this.runPlotsSubDialog();
            }
        };
        mPlots = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, mPlots);
        string = "IDS_COMMON_OPTIONS_3DOT";
        toggleButtonAction = new ToggleButtonAction(string){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExploreDlg.this.runOptionsSubDialog();
            }
        };
        mOpt = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, mOpt);
        this.mIsBootstrapOK = false;
        if (VersionInfo.allowBootstrapping()) {
            this.mIsBootstrapOK = true;
            string = "IDS_COMMON_BOOTSTRAPPING_BUTTON";
            toggleButtonAction = new ToggleButtonAction(string){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExploreDlg.this.runBootstrapSubDialog();
                }
            };
            this.mBootstrappingButton = new JButton(toggleButtonAction);
            this.addOptionsPanelButton(jPanel, this.mBootstrappingButton);
            if (BootstrapDlg.isCurrentDatasetInMIMode()) {
                this.mBootstrappingButton.setEnabled(false);
                this.mIsBootstrapOK = false;
            }
        }
        return jPanel;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcVarList.loadFromActiveDataset();
        this.mScrollPaneSourcelist = new JScrollPane(this.mSrcVarList);
        this.mScrollPaneSourcelist.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mArrowButtonDependlist = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mDependList = DialogUtil.createLabel(this, "IDS_EXPLORE_DEPENDENTLIST_COLON");
        this.mTargetDependList = new TargetVariableList();
        this.mTargetDependList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mScrollPaneDependentlist = new JScrollPane(this.mTargetDependList);
        this.mTargetDependList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetDependList.getFixedCellHeight() * 2 + 2));
        this.mScrollPaneDependentlist.setPreferredSize(this.mTargetDependList.getMinimumSize());
        this.mTargetDependList.getModel().addListDataListener(this);
        this.mTargetDependList.setIdentifier(TARGETLISTDEPENDENTKEY);
        this.mTargetDependList.addVarFilter(new SpssVarFilter(8, true, false));
        this.mArrowButtonFactorlist = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mFactorList = DialogUtil.createLabel(this, "IDS_EXPLORE_FACTORLIST_COLON");
        this.mTargetFactorList = new TargetVariableList();
        this.mTargetFactorList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mScrollPaneFactorlist = new JScrollPane(this.mTargetFactorList);
        this.mTargetFactorList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetFactorList.getFixedCellHeight() * 2 + 2));
        this.mScrollPaneFactorlist.setPreferredSize(this.mTargetFactorList.getMinimumSize());
        this.mTargetFactorList.getModel().addListDataListener(this);
        this.mTargetFactorList.setIdentifier(TARGETLISTFACTORKEY);
        this.mArrowButtonLabellist = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mLabelList = DialogUtil.createLabel(this, "IDS_EXPLORE_LABELLIST_COLON");
        this.mTargetLabelList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTargetLabelList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mScrollPaneLabellist = new JScrollPane(this.mTargetLabelList);
        this.mScrollPaneLabellist.setPreferredSize(this.mTargetLabelList.getMinimumSize());
        this.mScrollPaneLabellist.setHorizontalScrollBarPolicy(31);
        this.mScrollPaneLabellist.setVerticalScrollBarPolicy(21);
        this.mTargetLabelList.getModel().addListDataListener(this);
        this.mTargetLabelList.setIdentifier(TARGETLISTLABELCASEKEY);
        this.mDependList.setLabelFor(this.mTargetDependList);
        this.mFactorList.setLabelFor(this.mTargetFactorList);
        this.mLabelList.setLabelFor(this.mTargetLabelList);
        this.mArrowButtonDependlist.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButtonDependlist.registerVariableList(this.mTargetDependList, SpssArrowButton.ButtonOrientation.left);
        this.mArrowButtonFactorlist.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButtonFactorlist.registerVariableList(this.mTargetFactorList, SpssArrowButton.ButtonOrientation.left);
        this.mArrowButtonLabellist.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButtonLabellist.registerVariableList(this.mTargetLabelList, SpssArrowButton.ButtonOrientation.left);
        this.mGroupDisp = new SpssButtonGroup();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, DISPBOTH_KEY);
        this.mExpBothRadio = new JRadioButton(toggleButtonAction);
        this.mGroupDisp.add(this.mExpBothRadio);
        this.mExpBothRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, DISPSTATS_KEY);
        this.mExpStatsRadio = new JRadioButton(toggleButtonAction);
        this.mGroupDisp.add(this.mExpStatsRadio);
        this.mExpStatsRadio.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, DISPPLOTS_KEY);
        this.mExpPlotsRadio = new JRadioButton(toggleButtonAction);
        this.mGroupDisp.add(this.mExpPlotsRadio);
        this.mExpPlotsRadio.addItemListener(this);
        this.mSyntax = new StringBuffer();
    }

    private void setDefaults() {
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
        this.mExpBothRadio.setSelected(true);
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButtonDependlist);
        vector.add(this.mArrowButtonFactorlist);
        vector.add(this.mArrowButtonLabellist);
        vector.add(this.mTargetDependList);
        vector.add(this.mTargetFactorList);
        vector.add(this.mTargetLabelList);
        vector.add(this.mGroupDisp);
        vector.add(mStat);
        vector.add(mPlots);
        vector.add(mOpt);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private JPanel setupLists() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_DESC_STATS_EXPLORE_SOURCE_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mScrollPaneSourcelist, gridBagConstraints, 0, 1, 1, 5, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButtonDependlist, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        n = 21;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mDependList, gridBagConstraints, 2, 0, 1, 1, n, null);
        n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mScrollPaneDependentlist, gridBagConstraints, 2, 1, 1, 1, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButtonFactorlist, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 21;
        gridBagConstraints.fill = 2;
        this.mInsets.set(DialogUtil.getGroupBoxInnerMargin(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mFactorList, gridBagConstraints, 2, 2, 1, 1, n, this.mInsets);
        n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mScrollPaneFactorlist, gridBagConstraints, 2, 3, 1, 1, n, null);
        n = 20;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets3 = DialogUtil.getArrowButtonInsets();
        this.mInsets.set(0, insets3.left, 0, insets3.right);
        DialogUtil.addUsingGBL(jPanel, this.mArrowButtonLabellist, gridBagConstraints, 1, 4, 1, 2, n, this.mInsets);
        gridBagConstraints.weightx = 1.0;
        n = 20;
        gridBagConstraints.fill = 2;
        this.mInsets.set(DialogUtil.getGroupBoxInnerMargin(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mLabelList, gridBagConstraints, 2, 4, 1, 1, n, this.mInsets);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mScrollPaneLabellist, gridBagConstraints, 2, 5, 1, 1, n, null);
        return jPanel;
    }

    private JPanel setupDisplayPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_EXPLORE_DISPLAY"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mExpBothRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mExpStatsRadio, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mExpPlotsRadio, gridBagConstraints, 2, 0, 1, 1, n, insets);
        return jPanel;
    }

    private void runStatsSubDialog() {
        this.runSubDialog(new ExploreStatistics(this));
    }

    private void runPlotsSubDialog() {
        this.runSubDialog(new ExplorePlots(this));
    }

    private void runOptionsSubDialog() {
        this.runSubDialog(new ExploreOptions(this));
    }

    private void runBootstrapSubDialog() {
        this.runSubDialog(new BootstrapDlg(this));
    }
}

