/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.desc_stats.descriptives;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.desc_stats.descriptives.DescriptivesOptions;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BootstrapDlg;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.post_processing_output.TableStyleDlg;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DescriptivesDlg
extends BaseProcedureDialog
implements ListDataListener {
    static final String DESCRIPTIVES_CHECK_KEY = "IDS_DESCRIPTIVES_CHECK";
    static final String IDS_OPTIONS_KEY = "IDS_COMMON_OPTIONS_3DOT";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetVarList;
    private JScrollPane mSrcScrollPane;
    private JScrollPane mTargetScrollPane;
    private ArrowButton mArrowButton;
    private JLabel mVarLabel;
    private JCheckBox mStdValueCheck;
    private boolean mIsBootstrapOK;

    public DescriptivesDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle.getDefaultResourceBundleName(), AnalyzeResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_DESCRIPTIVES"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetVarList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.mStdValueCheck.setSelected(false);
        this.enableOkPaste(false);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_desc";
    }

    @Override
    public String getIActionKey() {
        return "analyze_desc_stat_descriptive";
    }

    @Override
    public boolean okPastePressed() {
        if (this.mIsBootstrapOK && BootstrapDlg.isStrataVariableListEmpty(this)) {
            this.runBootstrapSubDialog();
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    public String generateSyntax() {
        Object object;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        String string = this.mTargetVarList.getVariablesStringList();
        DialogDataModel dialogDataModel = (DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY);
        if (this.mIsBootstrapOK && dialogDataModel != null) {
            object = "";
            stringBuffer.append(BootstrapDlg.getBootstrapSyntax((String)object, string, dialogDataModel));
        }
        stringBuffer.append(SyntaxUtil.getMainCommand("DESCRIPTIVES"));
        DialogDataModel dialogDataModel2 = this.getDialogDataModel();
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("VARIABLES="));
        stringBuffer.append(string);
        object = dialogDataModel2.getBoolean(DESCRIPTIVES_CHECK_KEY);
        if (object != null && ((Boolean)object).booleanValue()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/SAVE"));
        }
        String string2 = "";
        HashMap<String, String> hashMap = this.getOptionsMap();
        Object object2 = hashMap.entrySet().iterator();
        while (object2.hasNext()) {
            Map.Entry<String, String> entry = object2.next();
            object = dialogDataModel2.getBoolean(entry.getKey());
            if (object == null && entry.getKey().equals("IDS_MEAN")) {
                string2 = string2 + entry.getValue() + " ";
            } else if (object == null && entry.getKey().equals("IDS_STDDEV")) {
                string2 = string2 + entry.getValue() + " ";
            } else if (object == null && entry.getKey().equals("IDS_MINIMUM")) {
                string2 = string2 + entry.getValue() + " ";
            } else if (object == null && entry.getKey().equals("IDS_MAX")) {
                string2 = string2 + entry.getValue() + " ";
            }
            if (object == null || !((Boolean)object).booleanValue()) continue;
            string2 = string2 + entry.getValue() + " ";
        }
        if ((string2 = string2.trim()).length() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/STATISTICS="));
            stringBuffer.append(string2);
        }
        if ((object = dialogDataModel2.getBoolean("IDS_ALPHABETIC_RADIO")) != null && ((Boolean)object).booleanValue()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/SORT=NAME (A)"));
        }
        if ((object = dialogDataModel2.getBoolean("IDS_ASCENDING_MEANS_RADIO")) != null && ((Boolean)object).booleanValue()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/SORT=MEAN (A)"));
        }
        if ((object = dialogDataModel2.getBoolean("IDS_DESCENDING_MEANS_RADIO")) != null && ((Boolean)object).booleanValue()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/SORT=MEAN (D)"));
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        if (this.mIsBootstrapOK && dialogDataModel != null) {
            stringBuffer.append(BootstrapDlg.getRestoreSyntax(dialogDataModel));
        }
        if ((object2 = TableStyleDlg.generateSyntax(dialogDataModel2, TableStyleDlg.ConditionalFormatDlgType.Descriptives)) != null) {
            stringBuffer.append((String)object2);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer.toString();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste(true);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0);
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(IDS_OPTIONS_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DescriptivesDlg.this.runOptionsSubDialog();
            }
        };
        JButton jButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, jButton);
        ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction("IDS_TABLE_STYLE_BUTTON_DESCRIPTIVES"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DescriptivesDlg.this.runConditionalSubDialog();
            }
        };
        this.addOptionsPanelButton(jPanel, new JButton(toggleButtonAction2));
        this.mIsBootstrapOK = false;
        if (VersionInfo.allowBootstrapping()) {
            this.mIsBootstrapOK = true;
            toggleButtonAction = new ToggleButtonAction("IDS_COMMON_BOOTSTRAPPING_BUTTON"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DescriptivesDlg.this.runBootstrapSubDialog();
                }
            };
            JButton jButton2 = new JButton(toggleButtonAction);
            this.addOptionsPanelButton(jPanel, jButton2);
            if (BootstrapDlg.isCurrentDatasetInMIMode()) {
                jButton2.setEnabled(false);
                this.mIsBootstrapOK = false;
            }
        }
        return jPanel;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        JPanel jPanel = this.getViewPanel();
        this.setupLists(jPanel);
        this.pack();
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        SpssVarFilter spssVarFilter = new SpssVarFilter(8, false);
        this.mSrcVarList.addVarFilter(spssVarFilter);
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mTargetVarList.addVarFilter(spssVarFilter);
        this.mTargetScrollPane = new JScrollPane(this.mTargetVarList);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 6 + 2));
        this.mTargetScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mVarLabel = DialogUtil.createLabel(this, "IDS_VARIABLES_COLON");
        this.mVarLabel.setLabelFor(this.mTargetVarList);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, DESCRIPTIVES_CHECK_KEY);
        this.mStdValueCheck = new JCheckBox(toggleButtonAction);
        this.mStdValueCheck.setSelected(false);
        this.mSrcVarList.setSelectedIndex(0);
    }

    private HashMap<String, String> getOptionsMap() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("IDS_MEAN", "MEAN");
        linkedHashMap.put("IDS_SUM", "SUM");
        linkedHashMap.put("IDS_STDDEV", "STDDEV");
        linkedHashMap.put("IDS_DESC_VARIANCE", "VARIANCE");
        linkedHashMap.put("IDS_DESC_RANGE", "RANGE");
        linkedHashMap.put("IDS_MINIMUM", "MIN");
        linkedHashMap.put("IDS_MAX", "MAX");
        linkedHashMap.put("IDS_SE_MEAN", "SEMEAN");
        linkedHashMap.put("IDS_KURT", "KURTOSIS");
        linkedHashMap.put("IDS_SKEWNESS", "SKEWNESS");
        return linkedHashMap;
    }

    private Vector<Object> setTabTraversal() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetVarList);
        vector.add(this.mStdValueCheck);
        for (n = 0; n < this.mOptionButtonPanel.getComponentCount(); ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        return vector;
    }

    private void setupLists(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_DESC_STATS_DESCRIPTIVE_SOURCE_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(0, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 21;
        gridBagConstraints.fill = 2;
        insets = new Insets(0, 0, 0, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, this.mVarLabel, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mTargetScrollPane, gridBagConstraints, 2, 1, 1, 1, n, insets);
        insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mStdValueCheck, gridBagConstraints, 0, 2, 3, 1, n, insets);
    }

    private void runOptionsSubDialog() {
        this.runSubDialog(new DescriptivesOptions(this));
    }

    private void runConditionalSubDialog() {
        this.runSubDialog(new TableStyleDlg(this, TableStyleDlg.ConditionalFormatDlgType.Descriptives));
    }

    private void runBootstrapSubDialog() {
        this.runSubDialog(new BootstrapDlg(this));
    }
}

