/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.desc_stats.crosstabs;

import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.dialogs.base.analyze.desc_stats.crosstabs.CrossTabsDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class CrossTabsStats
extends BaseSubDialog
implements ItemListener,
DocumentListener {
    public static final double RATIO_MIN_VALUE = 0.0;
    public static final double RATIO_MAX_VALUE = 9.9999999E7;
    static final String CHI_SQUARE = "IDS_CHISQUARE";
    static final String CORRELATIONS = "IDS_CROSSTABS_CORRELATIONS";
    static final String CONT_COEFF = "IDS_CONT_COEFF";
    static final String PHI_CRAMERS = "IDS_PHI_CRAMMER";
    static final String LAMBDA = "IDS_LAMBDA";
    static final String UNCERT_COEFF = "IDS_UNCERT_COEFF";
    static final String GAMMA = "IDS_GAMMA";
    static final String SOMMERS = "IDS_SOMMERS";
    static final String KENDALL_B = "IDS_KENDALLS_B";
    static final String KENDALL_C = "IDS_KENDALLS_C";
    static final String ETA = "IDS_ETA";
    static final String KAPPA = "IDS_KAPPA";
    static final String RISK = "IDS_RISK";
    static final String MCNEMARS = "IDS_MCNEMARS";
    static final String CONCHRANS = "IDS_C_M_STATS";
    static final String RATIO = "IDS_TEST_COMMON_RATIO_KEY";
    private FloatTextField mRatio;
    private JLabel mRatioLabel;
    private JCheckBox mConchCheck;
    private JCheckBox mEtaCheck;
    private JCheckBox mChiSqrCheck;
    private JCheckBox mCorrelCheck;
    private JPanel mNominalPanel;
    private JPanel mOrdinalPanel;
    private JPanel mKRMcheckBoxPanel;

    public CrossTabsStats(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_STATISTICS_TITLE"), true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.mRatioLabel.setEnabled(this.mConchCheck.isSelected());
        this.mRatio.setEnabled(this.mConchCheck.isSelected());
        this.mRatio.setOpaque(this.mConchCheck.isSelected());
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContinue());
    }

    @Override
    public boolean continuePressed() {
        boolean bl = true;
        if (((CrossTabsDlg)this.mParentDlg).isSupressTableChecked()) {
            this.saveState(this.mParentDlg.getDialogDataModel());
            if (!((CrossTabsDlg)this.mParentDlg).isAnyStatsRequested()) {
                this.dispose();
                ((CrossTabsDlg)this.mParentDlg).showInfoDialog(this.getResString("ERR_SHOW_INFO_MESSAGE"));
            }
        }
        return bl;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_xtab_statistics";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupChiSqAndCorrelationCheckPanel(jPanel);
        this.setupmNominalPanel();
        this.setupmOrdinalPanel();
        JPanel jPanel2 = this.setupNominalIntervalPanel();
        this.setupmKRMcheckBoxPanel();
        JPanel jPanel3 = this.setupCochransCheckBoxPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weighty = 1.0;
        Insets insets = new Insets(n2, 0, n2, n2);
        DialogUtil.createButtonGroup(this.mNominalPanel);
        DialogUtil.addUsingGBL(jPanel, this.mNominalPanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets = new Insets(n2, 0, n2, 0);
        DialogUtil.createButtonGroup(this.mOrdinalPanel);
        DialogUtil.addUsingGBL(jPanel, this.mOrdinalPanel, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        insets = new Insets(0, 0, n2, n2);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        insets = new Insets(0, 0, n2, 0);
        DialogUtil.createButtonGroup(this.mKRMcheckBoxPanel);
        DialogUtil.addUsingGBL(jPanel, this.mKRMcheckBoxPanel, gridBagConstraints, 1, 2, 1, 1, n, insets);
        insets = new Insets(0, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 3, 2, 1, n, insets);
        this.pack();
        this.setFocusTraversalPolicy();
    }

    private void initVars() {
        ControlAction controlAction = new ToggleButtonAction(this.mParentDlg, CONCHRANS);
        this.mConchCheck = new JCheckBox(controlAction);
        this.mConchCheck.addItemListener(this);
        controlAction = new ToggleButtonAction(this.mParentDlg, CHI_SQUARE);
        this.mChiSqrCheck = new JCheckBox(controlAction);
        controlAction = new ToggleButtonAction(this.mParentDlg, CORRELATIONS);
        this.mCorrelCheck = new JCheckBox(controlAction);
        controlAction = new ToggleButtonAction(this.mParentDlg, ETA);
        this.mEtaCheck = new JCheckBox(controlAction);
        this.mRatioLabel = DialogUtil.createLabel(this, "IDS_ODD_RATIO");
        this.mRatioLabel.setEnabled(false);
        controlAction = new TextFieldAction(this.mParentDlg, RATIO);
        this.mRatio = new FloatTextField(1.0E-6, 9.9999999E7, 6, true);
        this.mRatio.setAction((Action)controlAction);
        this.mRatio.setEnabled(false);
        this.mRatio.setColumns(4);
        this.mRatio.setDocument((Document)new FixedLengthNumericDocument(8, true, true));
        this.mRatio.setText("1");
        this.mRatio.getDocument().addDocumentListener(this);
        this.mRatio.setOpaque(false);
        this.mRatioLabel.setLabelFor((Component)this.mRatio);
        this.mNominalPanel = new JPanel();
        this.mNominalPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_NOMINAL"));
        this.mNominalPanel.setBorder(titledBorder);
        this.mOrdinalPanel = new JPanel();
        this.mOrdinalPanel.setLayout(new GridBagLayout());
        titledBorder = new TitledBorder(this.getResString("IDS_ORDINAL"));
        this.mOrdinalPanel.setBorder(titledBorder);
        this.mKRMcheckBoxPanel = new JPanel();
        this.mKRMcheckBoxPanel.setLayout(new GridBagLayout());
    }

    private boolean isAnyCheckBoxChecked() {
        int n;
        if (this.mChiSqrCheck.isSelected() || this.mCorrelCheck.isSelected() || this.mEtaCheck.isSelected()) {
            return true;
        }
        int n2 = this.mNominalPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            if (!((JCheckBox)this.mNominalPanel.getComponent(n)).isSelected()) continue;
            return true;
        }
        n2 = this.mOrdinalPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            if (!((JCheckBox)this.mOrdinalPanel.getComponent(n)).isSelected()) continue;
            return true;
        }
        n2 = this.mKRMcheckBoxPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            if (!((JCheckBox)this.mKRMcheckBoxPanel.getComponent(n)).isSelected()) continue;
            return true;
        }
        return false;
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mChiSqrCheck);
        int n2 = this.mNominalPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            vector.add(this.mNominalPanel.getComponent(n));
        }
        vector.add(this.mEtaCheck);
        vector.add(this.mCorrelCheck);
        n2 = this.mOrdinalPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            vector.add(this.mOrdinalPanel.getComponent(n));
        }
        n2 = this.mKRMcheckBoxPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            vector.add(this.mKRMcheckBoxPanel.getComponent(n));
        }
        vector.add(this.mConchCheck);
        vector.add(this.mRatio);
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private boolean canEnableContinue() {
        boolean bl;
        boolean bl2 = bl = !this.mConchCheck.isSelected();
        if (!bl) {
            bl = this.mRatio.getText().length() > 0;
        }
        return bl;
    }

    private void setupChiSqAndCorrelationCheckPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mChiSqrCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCorrelCheck, gridBagConstraints, 1, 0, 1, 1, n, insets);
    }

    private void setupmKRMcheckBoxPanel() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, KAPPA);
        JCheckBox jCheckBox = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, RISK);
        JCheckBox jCheckBox2 = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, MCNEMARS);
        JCheckBox jCheckBox3 = new JCheckBox(toggleButtonAction);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(this.mKRMcheckBoxPanel, jCheckBox, gridBagConstraints, 1, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mKRMcheckBoxPanel, jCheckBox2, gridBagConstraints, 1, 3, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.mKRMcheckBoxPanel, jCheckBox3, gridBagConstraints, 1, 4, 1, 1, n, insets);
    }

    private JPanel setupCochransCheckBoxPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, this.mConchCheck, gridBagConstraints, 0, 5, 1, 1, n, insets);
        insets = new Insets(insets.top, insets.left + 20, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mRatioLabel, gridBagConstraints, 0, 6, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        insets = new Insets(insets.top, insets.left + this.mRatioLabel.getPreferredSize().width + n2, insets.bottom, insets.right);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mRatio, gridBagConstraints, 0, 6, 1, 1, n, insets);
        return jPanel;
    }

    private void setupmNominalPanel() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, CONT_COEFF);
        JCheckBox jCheckBox = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, PHI_CRAMERS);
        JCheckBox jCheckBox2 = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, LAMBDA);
        JCheckBox jCheckBox3 = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, UNCERT_COEFF);
        JCheckBox jCheckBox4 = new JCheckBox(toggleButtonAction);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(this.mNominalPanel, jCheckBox, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mNominalPanel, jCheckBox2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mNominalPanel, jCheckBox3, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.mNominalPanel, jCheckBox4, gridBagConstraints, 0, 3, 1, 1, n, insets);
    }

    private void setupmOrdinalPanel() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, GAMMA);
        JCheckBox jCheckBox = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, SOMMERS);
        JCheckBox jCheckBox2 = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, KENDALL_B);
        JCheckBox jCheckBox3 = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, KENDALL_C);
        JCheckBox jCheckBox4 = new JCheckBox(toggleButtonAction);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(this.mOrdinalPanel, jCheckBox, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mOrdinalPanel, jCheckBox2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mOrdinalPanel, jCheckBox3, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.mOrdinalPanel, jCheckBox4, gridBagConstraints, 0, 3, 1, 1, n, insets);
    }

    private JPanel setupNominalIntervalPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_NOMINAL_INTV"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mEtaCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        return jPanel;
    }
}

