/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.desc_stats.crosstabs;

import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class CrossTabsExact
extends BaseSubDialog
implements ItemListener,
DocumentListener {
    public static final double MIN_VALUE = 0.001;
    public static final int SAMPLES_MIN_VALUE = 1;
    public static final double CONFI_LEVEL_MAX_VALUE = 99.9;
    public static final int SAMPLES_MAX_VALUE = 1000000000;
    public static final int TIME_LIMIT_MIN_VALUE = 0;
    public static final int TIME_LIMIT_MAX_VALUE = 9999999;
    static final String ASYMPTOTIC_RADIO = "IDS_ASYMPTOTIC_RADIO";
    static final String MONTE_CARLO_RADIO = "IDS_MONTE_CARLO_RADIO";
    static final String EXACT_RADIO = "IDS_EXACT_RADIO";
    static final String TIME_LIMIT_CHECK = "IDS_TIME_LIMIT_CHECK";
    static final String TIME_LIMIT = "IDS_TIME_LIMIT";
    static final String CONFIDENCE_PERCENT = "IDS_CONFIDENCE_PERCENT";
    static final String NUMBER_SAMPLES = "IDS_NUMBER_SAMPLE";
    private FloatTextField mConfiLevel;
    private IntTextField mSamples;
    private JCheckBox mTimeCheck;
    private IntTextField mTime;
    private JRadioButton mMontoRadio;
    private JRadioButton mExactRadio;
    private SpssButtonGroup mRadioGroup;

    public CrossTabsExact(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_EXACT_TITLE"), true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.enableMonteCarloGroup(this.mMontoRadio.isSelected());
        this.enableExactGroup(this.mExactRadio.isSelected());
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContForExactRadio() && this.canEnableContForMCRadio());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContForExactRadio() && this.canEnableContForMCRadio());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.canEnableContForExactRadio() && this.canEnableContForMCRadio());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_exact";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        this.pack();
        this.setFocusTraversalPolicy();
    }

    private void initVars() {
        ControlAction controlAction = new ToggleButtonAction(this.mParentDlg, MONTE_CARLO_RADIO);
        this.mMontoRadio = new JRadioButton(controlAction);
        this.mMontoRadio.addItemListener(this);
        controlAction = new TextFieldAction(this.mParentDlg, CONFIDENCE_PERCENT);
        this.mConfiLevel = new FloatTextField(0.001, 99.9, 1);
        this.mConfiLevel.setAction((Action)controlAction);
        this.mConfiLevel.setEnabled(false);
        this.mConfiLevel.setOpaque(false);
        this.mConfiLevel.setColumns(4);
        this.mConfiLevel.setMinimumSize(new Dimension(36, 19));
        this.mConfiLevel.setDocument((Document)new FixedLengthNumericDocument(4, true, true));
        this.mConfiLevel.setText("99");
        this.mConfiLevel.getDocument().addDocumentListener(this);
        controlAction = new TextFieldAction(this.mParentDlg, NUMBER_SAMPLES);
        this.mSamples = new IntTextField(1, 1000000000, true);
        this.mSamples.setAction((Action)controlAction);
        this.mSamples.setText("10000");
        this.mSamples.setColumns(8);
        this.mSamples.setEnabled(false);
        this.mSamples.setOpaque(false);
        this.mSamples.setMinimumSize(new Dimension(75, 19));
        this.mSamples.getDocument().addDocumentListener(this);
        controlAction = new ToggleButtonAction(this.mParentDlg, EXACT_RADIO);
        this.mExactRadio = new JRadioButton(controlAction);
        this.mExactRadio.addItemListener(this);
        controlAction = new ToggleButtonAction(this.mParentDlg, TIME_LIMIT_CHECK);
        this.mTimeCheck = new JCheckBox(controlAction);
        this.mTimeCheck.setEnabled(false);
        this.mTimeCheck.setSelected(true);
        this.mTimeCheck.addItemListener(this);
        controlAction = new TextFieldAction(this.mParentDlg, TIME_LIMIT);
        this.mTime = new IntTextField(0, 9999999, true);
        this.mTime.setText("5");
        this.mTime.setAction((Action)controlAction);
        this.mTime.setColumns(6);
        this.mTime.setEnabled(false);
        this.mTime.setOpaque(false);
        this.mTime.setMinimumSize(new Dimension(60, 19));
        this.mTime.getDocument().addDocumentListener(this);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mRadioGroup);
        vector.add(this.mConfiLevel);
        vector.add(this.mSamples);
        vector.add(this.mTimeCheck);
        vector.add(this.mTime);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private boolean canEnableContForMCRadio() {
        boolean bl;
        boolean bl2 = bl = !this.mMontoRadio.isSelected();
        if (!bl) {
            bl = this.mConfiLevel.getText().length() > 0 && this.mSamples.getText().length() > 0;
        }
        return bl;
    }

    private boolean canEnableContForExactRadio() {
        boolean bl;
        boolean bl2 = bl = !this.mExactRadio.isSelected();
        if (!bl) {
            bl = this.mTime.getText().length() > 0;
        }
        return bl;
    }

    private JPanel setupPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, ASYMPTOTIC_RADIO);
        JRadioButton jRadioButton = new JRadioButton(toggleButtonAction);
        jRadioButton.setSelected(true);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_CROSSTABS_CONFIDENCE_LEVEL");
        jLabel.setLabelFor((Component)this.mConfiLevel);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_SAMPLE_NO_LABEL");
        jLabel2.setLabelFor((Component)this.mSamples);
        JLabel jLabel3 = new JLabel(this.getResString("IDS_PERCENT_LABEL"));
        JLabel jLabel4 = new JLabel(this.getResString("IDS_MINUTE_LABEL"));
        JTextArea jTextArea = new JTextArea();
        jTextArea.setRows(2);
        jTextArea.setFont(jLabel4.getFont());
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setText(this.getResString("IDS_EXACT_METHOD_LABEL"));
        jTextArea.setFocusable(false);
        JTextArea jTextArea2 = new JTextArea();
        jTextArea2.setOpaque(false);
        jTextArea2.setRows(3);
        jTextArea2.setFont(jLabel4.getFont());
        jTextArea2.setLineWrap(true);
        jTextArea2.setWrapStyleWord(true);
        jTextArea2.setText(this.getResString("IDS_NON_ASYMPTOTIC_METHOD_LABEL"));
        jTextArea2.setFocusable(false);
        this.mRadioGroup = new SpssButtonGroup();
        this.mRadioGroup.add(jRadioButton);
        this.mRadioGroup.add(this.mMontoRadio);
        this.mRadioGroup.add(this.mExactRadio);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, jRadioButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mMontoRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        Insets insets2 = new Insets(insets.top, insets.left + 30, insets.bottom, insets.right);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        n = 24;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mConfiLevel, gridBagConstraints, 1, 2, 1, 1, n, insets);
        n = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 2, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        n = 10;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 24;
        gridBagConstraints.fill = 0;
        insets = new Insets(insets.top + 2, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mSamples, gridBagConstraints, 1, 3, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        n = 23;
        insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mExactRadio, gridBagConstraints, 0, 4, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mTimeCheck, gridBagConstraints, 0, 5, 1, 1, n, insets2);
        n = 24;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mTime, gridBagConstraints, 1, 5, 1, 1, n, insets);
        n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 10;
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 2, 5, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        n = 23;
        insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 6, 3, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jTextArea2, gridBagConstraints, 0, 7, 3, 1, n, insets);
        return jPanel;
    }

    private void enableExactGroup(boolean bl) {
        this.mTimeCheck.setEnabled(bl);
        this.mTime.setEnabled(bl && this.mTimeCheck.isSelected());
        this.mTime.setOpaque(bl && this.mTimeCheck.isSelected());
    }

    private void enableMonteCarloGroup(boolean bl) {
        this.mConfiLevel.setEnabled(bl);
        this.mConfiLevel.setOpaque(bl);
        this.mSamples.setEnabled(bl);
        this.mSamples.setOpaque(bl);
    }
}

