/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.desc_stats.crosstabs;

import com.spss.java_client.core.common.LicenseOption;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.license.LicenseManager;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.LayeredListWidget;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.desc_stats.crosstabs.CrossTabsCells;
import com.spss.java_client.ui.dialogs.base.analyze.desc_stats.crosstabs.CrossTabsExact;
import com.spss.java_client.ui.dialogs.base.analyze.desc_stats.crosstabs.CrossTabsFormat;
import com.spss.java_client.ui.dialogs.base.analyze.desc_stats.crosstabs.CrossTabsStats;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BootstrapDlg;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.post_processing_output.TableStyleDlg;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.drag_drop.DragPane;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class CrossTabsDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener {
    public static final int MIN_LAYER = 1;
    public static final int MAX_NUMBER_OF_LAYER = 8;
    public static final int MAX_ELEMENTS = 76;
    public static final int LAYERED_LIST_MAX_ELEMENTS = 6;
    public static final String LAYERED_LIST_IDENTIFIER = "LINEAR_LAYERED_LIST";
    static final String ROW_LIST = "IDS_CROSSTABS_ROW_LIST";
    static final String COLUMN_LIST = "IDS_CROSSTABS_COLUMN_LIST";
    static final String LAYER_LIST = "IDS_CROSSTABS_LAYER_LIST";
    static final String EXACT_BUTTON = "IDS_COMMON_EXACT_BUTTON";
    static final String STATISTICS_BUTTON = "IDS_COMMON_STATS_3DOT";
    static final String CELLS_BUTTON = "IDS_CELLS_BUTTON";
    static final String FORMAT_BUTTON = "IDS_COMMON_FORMAT_3DOT";
    static final String LAYER_COUNT_KEY = "IDS_LAYER_COUNT";
    static final String LAYERS_KEY = "IDS_LAYERS";
    static final String CURRENT_LAYER_KEY = "IDS_CURRENT_LAYER";
    static final String BAR_CHART = "IDS_CLUSTERED_BAR_CHART";
    static final String SUPRESS_TABLES = "IDS_SUPRESS_TABLES";
    static final String DISPLAY_IN_TABLE_LAYER = "IDS_DISPLAY_IN_TABLE_LAYER";
    static final String PREVIOUS_BUTTON = "IDS_PREVIOUS_BUTTON";
    static final String NEXT_BUTTON = "IDS_NEXT_BUTTON";
    private JButton mCellsButton;
    private JButton mFormatButton;
    private JCheckBox mBarChartCheck;
    private JCheckBox mDisplayInTableLayerCheck;
    private JCheckBox mSupressTableCheck;
    private ArrowButton mRowListArrow;
    private ArrowButton mColListArrow;
    private JScrollPane mColScrollPane;
    private JScrollPane mRowScrollPane;
    private JScrollPane mSrcScrollPane;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mRowList;
    private TargetVariableList mColList;
    private LayeredListWidget mLayerWidget;
    private boolean mIsBootstrapOK;

    public CrossTabsDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle.getDefaultResourceBundleName(), AnalyzeResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_CROSSTABS"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void pack() {
        super.pack();
        if (this.getGlassPane() instanceof DragPane) {
            DialogUtil.removeDragAdapters((DragPane)this.getGlassPane(), (Component)((Object)this));
            DialogUtil.addDragAdapters((DragPane)this.getGlassPane(), (Component)((Object)this), this.mLayerWidget.getVarMoveHandler());
        }
    }

    @Override
    public boolean okPastePressed() {
        if (this.mIsBootstrapOK && BootstrapDlg.isStrataVariableListEmpty(this)) {
            this.runSubDialog(new BootstrapDlg(this));
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    public String generateSyntax() {
        String string;
        Map.Entry<String, String> entry22;
        Object object3;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        String string2 = this.mRowList.getVariablesStringList();
        String string22 = this.mColList.getVariablesStringList();
        ArrayList<VarListModel> arrayList = this.mLayerWidget.getVarListModels();
        Iterator<VarListModel> iterator = arrayList.iterator();
        DialogDataModel dialogDataModel = (DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY);
        if (this.mIsBootstrapOK && dialogDataModel != null) {
            Object object4;
            object3 = "";
            while (iterator.hasNext()) {
                object4 = iterator.next();
                if (((VarListModel)object4).getSize() <= 0) continue;
                for (int i = 0; i < ((VarListModel)object4).getSize(); ++i) {
                    object3 = (String)object3 + ((VarListModel)object4).getElementAt(i).getName() + " ";
                }
            }
            object4 = string2 + " " + string22 + " " + (String)object3;
            stringBuffer.append(BootstrapDlg.getBootstrapSyntax("", (String)object4, dialogDataModel));
            iterator = arrayList.iterator();
        }
        stringBuffer.append(SyntaxUtil.getMainCommand("CROSSTABS"));
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/TABLES="));
        stringBuffer.append(string2);
        stringBuffer.append(" BY ");
        stringBuffer.append(string22);
        while (iterator.hasNext()) {
            object3 = iterator.next();
            if (((VarListModel)object3).getSize() <= 0) continue;
            stringBuffer.append(" BY");
            for (int i = 0; i < ((VarListModel)object3).getSize(); ++i) {
                stringBuffer.append(" ").append(((VarListModel)object3).getElementAt(i).getName());
            }
        }
        object3 = this.getDialogDataModel();
        Boolean bl = ((DialogDataModel)object3).getBoolean(DISPLAY_IN_TABLE_LAYER);
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/SHOWDIM=2"));
        }
        bl = ((DialogDataModel)object3).getBoolean(BAR_CHART) != false && ((DialogDataModel)object3).getBoolean(SUPRESS_TABLES) != false || ((DialogDataModel)object3).getBoolean(SUPRESS_TABLES) != false;
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/FORMAT="));
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("NOTABLES");
        } else {
            bl = ((DialogDataModel)object3).getBoolean("IDS_DESCENDING");
            if (bl != null && bl.booleanValue()) {
                stringBuffer.append("DVALUE TABLES");
            } else {
                stringBuffer.append("AVALUE TABLES");
            }
        }
        String string3 = "";
        Map<String, String> map = this.getStatsCheckMap();
        for (Map.Entry<String, String> entry22 : map.entrySet()) {
            bl = ((DialogDataModel)object3).getBoolean(entry22.getKey());
            if (bl == null || !bl.booleanValue()) continue;
            string3 = string3 + (String)entry22.getValue() + " ";
        }
        boolean bl2 = true;
        if (string3.length() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/STATISTICS="));
            stringBuffer.append(string3);
            bl2 = false;
        }
        if ((bl = ((DialogDataModel)object3).getBoolean("IDS_C_M_STATS")) != null && bl.booleanValue()) {
            if (bl2) {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/STATISTICS="));
            }
            if (!((String)((Object)(entry22 = ((DialogDataModel)object3).getString("IDS_TEST_COMMON_RATIO_KEY")))).equals("")) {
                stringBuffer.append("CMH(").append((String)((Object)entry22)).append(")");
            } else {
                stringBuffer.append("CMH(1)");
            }
        }
        entry22 = "";
        map = this.getCellsCheckMap();
        for (Map.Entry<String, String> object22 : map.entrySet()) {
            bl = ((DialogDataModel)object3).getBoolean(object22.getKey());
            if (bl == null || !bl.booleanValue()) continue;
            entry22 = (String)((Object)entry22) + object22.getValue() + " ";
        }
        if (!this.mSupressTableCheck.isSelected()) {
            if (((String)((Object)entry22)).length() > 0) {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/CELLS="));
                stringBuffer.append((String)((Object)entry22));
            } else {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/CELLS=COUNT"));
            }
        }
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/COUNT "));
        Object object5 = "";
        map = this.getCellsRadioMap();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            bl = ((DialogDataModel)object3).getBoolean(entry.getKey());
            if (bl == null || !bl.booleanValue()) continue;
            object5 = entry.getValue() + "";
            break;
        }
        if (((String)object5).length() > 0) {
            stringBuffer.append((String)object5);
        } else {
            stringBuffer.append("ROUND CELL");
        }
        bl = ((DialogDataModel)object3).getBoolean("IDS_HIDE_SMALL");
        if (bl != null && bl.booleanValue()) {
            stringBuffer.append("\n");
            String string4 = ((DialogDataModel)object3).getString("IDS_LESS_THAN");
            stringBuffer.append(SyntaxUtil.getSubCommand(String.format("/HIDESMALLCOUNTS COUNT=%s", string4)));
        }
        if ((bl = ((DialogDataModel)object3).getBoolean(BAR_CHART)) != null && bl.booleanValue()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/BARCHART"));
        }
        if ((bl = ((DialogDataModel)object3).getBoolean("IDS_MONTE_CARLO_RADIO")) != null && bl.booleanValue()) {
            Map.Entry<String, String> entry;
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/METHOD=MC "));
            String string5 = ((DialogDataModel)object3).getString("IDS_CONFIDENCE_PERCENT");
            if (!string5.equals("")) {
                stringBuffer.append("CIN(").append(string5).append(") ");
            } else {
                stringBuffer.append("CIN(99) ");
            }
            entry = ((DialogDataModel)object3).getString("IDS_NUMBER_SAMPLE");
            if (!((String)((Object)entry)).equals("")) {
                stringBuffer.append("SAMPLES(").append((String)((Object)entry)).append(")");
            } else {
                stringBuffer.append("SAMPLES(10000)");
            }
        }
        if ((bl = ((DialogDataModel)object3).getBoolean("IDS_EXACT_RADIO")) != null && bl.booleanValue()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/METHOD=EXACT "));
            if (((DialogDataModel)object3).getBoolean("IDS_TIME_LIMIT_CHECK").booleanValue()) {
                String string6 = ((DialogDataModel)object3).getString("IDS_TIME_LIMIT");
                if (!string6.equals("")) {
                    stringBuffer.append("TIMER(").append(string6).append(")");
                }
            } else {
                stringBuffer.append("TIMER(0)");
            }
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        if (this.mIsBootstrapOK && dialogDataModel != null) {
            stringBuffer.append(BootstrapDlg.getRestoreSyntax((DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY)));
        }
        if ((string = TableStyleDlg.generateSyntax((DialogDataModel)object3, TableStyleDlg.ConditionalFormatDlgType.CrossTabs)) != null) {
            stringBuffer.append(string);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer.toString();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updateOkPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updateOkPaste();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updateOkPaste();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.mCellsButton.setEnabled(!this.mSupressTableCheck.isSelected());
        this.mFormatButton.setEnabled(!this.mSupressTableCheck.isSelected());
        if (!this.mBarChartCheck.isSelected() && this.mSupressTableCheck.isSelected() && !this.isAnyStatsRequested()) {
            this.showInfoDialog(this.getResString("ERR_SHOW_INFO_MESSAGE"));
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.mSrcVarList.loadFromActiveDataset();
        this.mRowList.removeAll();
        this.mColList.removeAll();
        this.mLayerWidget.resetLayeredListWidget();
        this.mSupressTableCheck.setSelected(false);
        this.mBarChartCheck.setSelected(false);
        this.mDisplayInTableLayerCheck.setSelected(false);
        this.enableOkPaste(false);
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_xtab";
    }

    @Override
    public String getIActionKey() {
        return "analyze_desc_stat_crosstab";
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
        this.mLayerWidget.loadListState(this.getDialogDataModel());
        this.mDisplayInTableLayerCheck.setEnabled(this.AreVariablesInLayerWidget());
        this.mSupressTableCheck.addItemListener(this);
        this.mCellsButton.setEnabled(!this.mSupressTableCheck.isSelected());
        this.mFormatButton.setEnabled(!this.mSupressTableCheck.isSelected());
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    @Override
    public void saveDialogState() {
        super.saveDialogState();
        this.mLayerWidget.saveListState(this.getDialogDataModel());
    }

    public boolean isSupressTableChecked() {
        return !this.mBarChartCheck.isSelected() && this.mSupressTableCheck.isSelected();
    }

    public boolean isDisplayInTableLayerChecked() {
        return this.mDisplayInTableLayerCheck.isSelected();
    }

    public void showInfoDialog(String string) {
        SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel);
        this.updateOkPaste();
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        ToggleButtonAction toggleButtonAction;
        JPanel jPanel = super.setupOptionsButtonPanel();
        if (LicenseManager.getLicenseManager().getStatus(LicenseOption.CYTEL) == LicenseManager.Status.VALID) {
            toggleButtonAction = new ToggleButtonAction(EXACT_BUTTON){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CrossTabsDlg.this.runExactSubDialog();
                }
            };
            this.addOptionsPanelButton(jPanel, new JButton(toggleButtonAction));
        }
        toggleButtonAction = new ToggleButtonAction(STATISTICS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CrossTabsDlg.this.runStatsSubDlg();
            }
        };
        this.addOptionsPanelButton(jPanel, new JButton(toggleButtonAction));
        toggleButtonAction = new ToggleButtonAction(this, CELLS_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CrossTabsDlg.this.runCellsSubDlg();
            }
        };
        this.mCellsButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mCellsButton);
        toggleButtonAction = new ToggleButtonAction(FORMAT_BUTTON){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CrossTabsDlg.this.runFormatSubDlg();
            }
        };
        this.mFormatButton = new JButton(toggleButtonAction);
        this.addOptionsPanelButton(jPanel, this.mFormatButton);
        toggleButtonAction = new ToggleButtonAction("IDS_TABLE_STYLE_BUTTON_CROSSTABS"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CrossTabsDlg.this.runConditionalSubDialog();
            }
        };
        this.addOptionsPanelButton(jPanel, new JButton(toggleButtonAction));
        this.mIsBootstrapOK = false;
        if (VersionInfo.allowBootstrapping()) {
            this.mIsBootstrapOK = true;
            toggleButtonAction = new ToggleButtonAction("IDS_COMMON_BOOTSTRAPPING_BUTTON_CROSS_TABLE"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CrossTabsDlg.this.runbootstrapSubDlg();
                }
            };
            JButton jButton = new JButton(toggleButtonAction);
            this.addOptionsPanelButton(jPanel, jButton);
            if (BootstrapDlg.isCurrentDatasetInMIMode()) {
                jButton.setEnabled(false);
                this.mIsBootstrapOK = false;
            }
        }
        return jPanel;
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_DESC_STATS_FREQ_SOURCE_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mRowListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mRowList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mRowList.setIdentifier(ROW_LIST);
        this.mRowList.setMaxLimitOfList(76);
        this.mRowScrollPane = new JScrollPane(this.mRowList);
        this.mRowScrollPane.setPreferredSize(this.mRowList.getMinimumSize());
        this.mColListArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mColList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mColList.setIdentifier(COLUMN_LIST);
        this.mColList.setMaxLimitOfList(76);
        this.mColScrollPane = new JScrollPane(this.mColList);
        this.mColScrollPane.setPreferredSize(this.mColList.getMinimumSize());
        this.mRowList.getModel().addListDataListener(this);
        this.mColList.getModel().addListDataListener(this);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, BAR_CHART);
        this.mBarChartCheck = new JCheckBox(toggleButtonAction);
        this.mBarChartCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this, SUPRESS_TABLES);
        this.mSupressTableCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, DISPLAY_IN_TABLE_LAYER);
        this.mDisplayInTableLayerCheck = new JCheckBox(toggleButtonAction);
        this.initializeLayerPanel();
        this.mLayerWidget.setMaxNoOfLayers(8);
        this.mLayerWidget.setSrcList(this.mSrcVarList);
        this.mLayerWidget.setMaxNoOfItemsPerLayers(6);
        this.mLayerWidget.setMaxNoOfItemsInLayers(76);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mBarChartCheck);
        spssButtonGroup.add(this.mSupressTableCheck);
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mRowListArrow);
        vector.add(this.mColListArrow);
        vector.add(this.mRowList);
        vector.add(this.mColList);
        Vector<Object> vector2 = this.mLayerWidget.getTraversalComponent();
        Component[] componentArray = new Component[vector2.size()];
        Iterator<Object> iterator = vector2.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            componentArray[n2] = (Component)iterator.next();
            ++n2;
        }
        vector.add(componentArray[0]);
        vector.add(componentArray[1]);
        vector.add(componentArray[2]);
        vector.add(componentArray[3]);
        vector.add(this.mDisplayInTableLayerCheck);
        vector.add(this.mBarChartCheck);
        vector.add(this.mSupressTableCheck);
        int n3 = this.mOptionButtonPanel.getComponentCount();
        for (n = 0; n < n3; ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void updateOkPaste() {
        this.enableOkPaste(this.mRowList.getModel().getSize() > 0 && this.mColList.getModel().getSize() > 0);
    }

    private void setupViewPanel(JPanel jPanel) {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_ROWS_LABEL");
        jLabel.setLabelFor(this.mRowList);
        this.mRowListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mRowListArrow.registerVariableList(this.mRowList, SpssArrowButton.ButtonOrientation.left);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_COLS_LABEL");
        jLabel2.setLabelFor(this.mColList);
        this.mColListArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mColListArrow.registerVariableList(this.mColList, SpssArrowButton.ButtonOrientation.left);
        Insets insets = DialogUtil.getArrowButtonInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_CROSSTABS_SOURCE_LIST_LABEL");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 4, n, null);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        DialogUtil.addUsingGBL(jPanel, this.mRowListArrow, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        Insets insets2 = new Insets(0, 1, 0, 9);
        n = 23;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mRowScrollPane, gridBagConstraints, 2, 1, 1, 1, n, insets2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        Insets insets3 = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 2, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        DialogUtil.addUsingGBL(jPanel, this.mColListArrow, gridBagConstraints, 1, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mColScrollPane, gridBagConstraints, 2, 3, 1, 1, n, insets2);
        Insets insets4 = DialogUtil.getStandardControlInsets();
        Insets insets5 = new Insets(5, 6, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mLayerWidget, gridBagConstraints, 1, 4, 2, 1, n, insets5);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets5 = new Insets(0, insets4.left, insets4.bottom, insets4.right);
        DialogUtil.addUsingGBL(jPanel, this.mBarChartCheck, gridBagConstraints, 0, 6, 1, 1, n, insets5);
        insets5 = new Insets(insets4.top, insets4.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSupressTableCheck, gridBagConstraints, 0, 7, 1, 1, n, insets5);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets5 = new Insets(2, 9, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDisplayInTableLayerCheck, gridBagConstraints, 1, 5, 2, 1, n, insets5);
    }

    private void runExactSubDialog() {
        this.runSubDialog(new CrossTabsExact(this));
    }

    private void runStatsSubDlg() {
        this.runSubDialog(new CrossTabsStats(this));
    }

    private void runCellsSubDlg() {
        this.runSubDialog(new CrossTabsCells(this));
    }

    private void runFormatSubDlg() {
        this.runSubDialog(new CrossTabsFormat(this));
    }

    private void runbootstrapSubDlg() {
        this.runSubDialog(new BootstrapDlg(this));
    }

    private void runConditionalSubDialog() {
        this.runSubDialog(new TableStyleDlg(this, TableStyleDlg.ConditionalFormatDlgType.CrossTabs));
    }

    private Map<String, String> getStatsCheckMap() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("IDS_CHISQUARE", "CHISQ");
        linkedHashMap.put("IDS_CONT_COEFF", "CC");
        linkedHashMap.put("IDS_PHI_CRAMMER", "PHI");
        linkedHashMap.put("IDS_LAMBDA", "LAMBDA");
        linkedHashMap.put("IDS_UNCERT_COEFF", "UC");
        linkedHashMap.put("IDS_ETA", "ETA");
        linkedHashMap.put("IDS_CROSSTABS_CORRELATIONS", "CORR");
        linkedHashMap.put("IDS_GAMMA", "GAMMA");
        linkedHashMap.put("IDS_SOMMERS", "D");
        linkedHashMap.put("IDS_KENDALLS_B", "BTAU");
        linkedHashMap.put("IDS_KENDALLS_C", "CTAU");
        linkedHashMap.put("IDS_KAPPA", "KAPPA");
        linkedHashMap.put("IDS_RISK", "RISK");
        linkedHashMap.put("IDS_MCNEMARS", "MCNEMAR");
        return linkedHashMap;
    }

    private Map<String, String> getCellsCheckMap() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("IDS_OBSERVED", "COUNT");
        linkedHashMap.put("IDS_EXPECTED", "EXPECTED");
        linkedHashMap.put("IDS_ROW", "ROW");
        linkedHashMap.put("IDS_COLUMN", "COLUMN");
        linkedHashMap.put("IDS_TOTAL", "TOTAL");
        linkedHashMap.put("IDS_UNSTANDARDIZED", "RESID");
        linkedHashMap.put("IDS_STANDARDIZED", "SRESID");
        linkedHashMap.put("IDS_ADJUSTED", "ASRESID");
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean("IDS_COMPARE_COLUMN_PROPORTIONS");
        if (bl != null && bl.booleanValue() && (bl = dialogDataModel.getBoolean("IDS_ADJUST_P_VALUES")) != null) {
            if (bl.booleanValue()) {
                linkedHashMap.put("IDS_COMPARE_COLUMN_PROPORTIONS", "BPROP");
            } else {
                linkedHashMap.put("IDS_COMPARE_COLUMN_PROPORTIONS", "PROP");
            }
        }
        return linkedHashMap;
    }

    private HashMap<String, String> getCellsRadioMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("IDS_ROUND_CELL", "ROUND CELL");
        hashMap.put("IDS_ROUND_CASE", "ROUND CASE");
        hashMap.put("IDS_TRUNCATE_CELL", "TRUNCATE CELL");
        hashMap.put("IDS_TRUNCATE_CASE", "TRUNCATE CASE");
        hashMap.put("IDS_NO_ADJ", "ASIS");
        return hashMap;
    }

    public boolean isAnyStatsRequested() {
        boolean bl = false;
        String[] stringArray = new String[]{"IDS_CHISQUARE", "IDS_CONT_COEFF", "IDS_PHI_CRAMMER", "IDS_LAMBDA", "IDS_UNCERT_COEFF", "IDS_ETA", "IDS_CROSSTABS_CORRELATIONS", "IDS_GAMMA", "IDS_SOMMERS", "IDS_KENDALLS_B", "IDS_KENDALLS_C", "IDS_KAPPA", "IDS_RISK"};
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        for (String string : stringArray) {
            Boolean bl2 = dialogDataModel.getBoolean(string);
            if (bl2 == null || !bl2.booleanValue()) continue;
            bl = true;
        }
        return bl;
    }

    private boolean AreVariablesInLayerWidget() {
        ArrayList<VarListModel> arrayList = this.mLayerWidget.getVarListModels();
        Iterator<VarListModel> iterator = arrayList.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            VarListModel varListModel = iterator.next();
            if (varListModel.getSize() <= 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void initializeLayerPanel() {
        this.mLayerWidget = new LayeredListWidget(this.getResString("IDS_REG_LINEAR_INDEPENDENT_LABEL"), this){

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                super.intervalAdded(listDataEvent);
                CrossTabsDlg.this.mDisplayInTableLayerCheck.setEnabled(CrossTabsDlg.this.AreVariablesInLayerWidget());
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                super.intervalRemoved(listDataEvent);
                CrossTabsDlg.this.mDisplayInTableLayerCheck.setEnabled(CrossTabsDlg.this.AreVariablesInLayerWidget());
            }

            @Override
            protected void moreOperationOnNext() {
                super.moreOperationOnNext();
            }

            @Override
            protected void moreOperationOnPrevious() {
                super.moreOperationOnPrevious();
            }

            @Override
            protected void setIndependentBorder() {
                this.mBorderTitle = CrossTabsDlg.this.getResString("IDS_REG_LINEAR_LAYERED_TITLE");
                super.setIndependentBorder();
            }

            @Override
            protected JPanel setupIndependentPanel() {
                this.mVarList.setIdentifier(CrossTabsDlg.LAYERED_LIST_IDENTIFIER);
                this.mBorderTitle = CrossTabsDlg.this.getResString("IDS_REG_LINEAR_LAYERED_TITLE");
                this.mArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 2;
                int n = 23;
                Insets insets = new Insets(2, 8, 3, 0);
                this.mLayeredListPanel = new JPanel(new GridBagLayout());
                String string = this.mBorderTitle + (this.getCurrentLayer() + 1) + ResUtil.getCommonDlgString("IDS_LAYER_WIDGET_INDEPENDENT_LAYER_TITLE2") + (this.getNoOfLayers() + 1);
                this.mLayeredListPanel.setBorder(new TitledBorder(string));
                DialogUtil.addUsingGBL(this.mLayeredListPanel, this.setupButtonPanel(), gridBagConstraints, 0, 0, 3, 1, n, insets);
                this.mIndependentListLabel = new JLabel(string);
                this.mIndependentListLabel.setLabelFor(this.mVarList);
                insets.set(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.fill = 0;
                Insets insets2 = (Insets)DialogUtil.getArrowButtonInsets().clone();
                insets2.top += insets2.top;
                insets2.bottom += insets2.bottom;
                insets2.right = 1;
                DialogUtil.addUsingGBL(this.mLayeredListPanel, this.mArrow, gridBagConstraints, 0, 2, 1, 1, 10, insets2);
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 1;
                this.mVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
                JScrollPane jScrollPane = new JScrollPane(this.mVarList);
                jScrollPane.setPreferredSize(this.mVarList.getMinimumSize());
                insets.set(DialogUtil.getComponentGroupGap(), 1, DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin() - 4);
                DialogUtil.addUsingGBL(this.mLayeredListPanel, jScrollPane, gridBagConstraints, 1, 2, 2, 1, n, insets);
                this.mArrow.registerVariableList(this.mVarList, SpssArrowButton.ButtonOrientation.left);
                return this.mLayeredListPanel;
            }
        };
    }
}

