/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.data_reduction.factor;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.data_reduction.factor.FactorDlg;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class FactorScores
extends BaseSubDialog
implements ActionListener {
    private JCheckBox mSaveVarCheckbox;
    private JRadioButton mRegressionRadio;
    private JRadioButton mBartlettRadio;
    private JRadioButton mAndersonRadio;
    private SpssButtonGroup mMethodButtonGrp;
    private JCheckBox mDisplayFactorCheckbox;
    private GridBagConstraints mGridConstraints;

    public FactorScores(FactorDlg factorDlg) {
        super(factorDlg, factorDlg.getResString("IDS_FA_SCORES_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_fact_sco";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mSaveVarCheckbox && this.mSaveVarCheckbox.isSelected()) {
            this.mRegressionRadio.setEnabled(true);
            this.mBartlettRadio.setEnabled(true);
            this.mAndersonRadio.setEnabled(true);
        } else if (object == this.mSaveVarCheckbox && !this.mSaveVarCheckbox.isSelected()) {
            this.mRegressionRadio.setEnabled(false);
            this.mBartlettRadio.setEnabled(false);
            this.mAndersonRadio.setEnabled(false);
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupScoresPanel();
        JPanel jPanel3 = this.setupMethodPanel();
        JPanel jPanel4 = this.setupLowerScoresPanel();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mGridConstraints, 0, 0, 1, 1, n, null);
        this.mGridConstraints.weighty = 1.0;
        Insets insets = new Insets(n2, n2 * 4, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, this.mGridConstraints, 0, 1, 1, 1, n, insets);
        this.mGridConstraints.weighty = 0.0;
        insets.set(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel4, this.mGridConstraints, 0, 2, 1, 1, n, insets);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        Boolean bl = dialogDataModel.getBoolean("IDS_FA_SAVE_AS_VAR");
        if (bl != null && bl.booleanValue()) {
            this.mRegressionRadio.setEnabled(true);
            this.mBartlettRadio.setEnabled(true);
            this.mAndersonRadio.setEnabled(true);
        }
        super.loadState(dialogDataModel);
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, "IDS_FA_REGRESSION");
        this.mRegressionRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, "IDS_FA_BARTLETT");
        this.mBartlettRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, "IDS_FA_ANDERSON_RUBIN");
        this.mAndersonRadio = new JRadioButton(toggleButtonAction);
        this.mMethodButtonGrp = new SpssButtonGroup();
        this.mMethodButtonGrp.add(this.mRegressionRadio);
        this.mMethodButtonGrp.add(this.mBartlettRadio);
        this.mMethodButtonGrp.add(this.mAndersonRadio);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, "IDS_FA_SAVE_AS_VAR");
        this.mSaveVarCheckbox = new JCheckBox(toggleButtonAction);
        this.mSaveVarCheckbox.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, "IDS_FA_DISPLAY_FACTOR");
        this.mDisplayFactorCheckbox = new JCheckBox(toggleButtonAction);
        this.mDisplayFactorCheckbox.addActionListener(this);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mSaveVarCheckbox);
        spssButtonGroup.add(this.mDisplayFactorCheckbox);
        this.mGridConstraints = new GridBagConstraints();
    }

    private void setDefaults() {
        this.mRegressionRadio.setSelected(true);
        this.mDisplayFactorCheckbox.setSelected(false);
        this.mSaveVarCheckbox.setSelected(false);
        this.mRegressionRadio.setEnabled(false);
        this.mBartlettRadio.setEnabled(false);
        this.mAndersonRadio.setEnabled(false);
        if (!RemoteFileChooser.enableSaveInModeler()) {
            this.mSaveVarCheckbox.setEnabled(false);
        }
    }

    private JPanel setupScoresPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        int n = 23;
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 1.0;
        this.mGridConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSaveVarCheckbox, this.mGridConstraints, 0, 0, 1, 1, n, null);
        return jPanel;
    }

    private JPanel setupMethodPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_FA_METHOD_SCORES_PANEL")));
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 2;
        Insets insets2 = new Insets(insets.top, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mRegressionRadio, this.mGridConstraints, 0, 0, 1, 1, n, insets2);
        insets2.set(insets.top, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mBartlettRadio, this.mGridConstraints, 0, 1, 1, 1, n, insets2);
        this.mGridConstraints.weighty = 1.0;
        insets2.set(insets.top, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mAndersonRadio, this.mGridConstraints, 0, 2, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupLowerScoresPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        int n = 23;
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 1.0;
        this.mGridConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mDisplayFactorCheckbox, this.mGridConstraints, 0, 0, 1, 1, n, null);
        return jPanel;
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSaveVarCheckbox);
        vector.add(this.mMethodButtonGrp);
        vector.add(this.mDisplayFactorCheckbox);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            if (!(this.mCmdButtonPanel.getComponent(i) instanceof JButton)) continue;
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }
}

