/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.data_reduction.factor;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.data_reduction.factor.FactorDlg;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Formatter;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FactorOptions
extends BaseSubDialog
implements ActionListener,
DocumentListener,
FocusListener {
    private static final String DEF_SUPPRESS_VAL = ".10";
    private static final double MIN_SUPPRESS = 0.0;
    private static final double MAX_SUPPRESS = 1.0;
    private static final int PRECISION_SUPPRESS = 4;
    private JRadioButton mExcludeListWiseRadio;
    private JRadioButton mExcludePairWiseRadio;
    private JRadioButton mReplaceMeanRadio;
    private SpssButtonGroup mMissingValuesButtonGrp;
    private JCheckBox mSortSizeCheckbox;
    private JCheckBox mSuppressValuesCheckbox;
    private FloatTextField mSuppressValuesTxt;
    private GridBagConstraints mGridConstraints;

    public FactorOptions(FactorDlg factorDlg) {
        super(factorDlg, factorDlg.getResString("IDS_FA_OPTIONS_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_fact_opt";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mSuppressValuesCheckbox && this.mSuppressValuesCheckbox.isSelected()) {
            this.mSuppressValuesTxt.setEnabled(true);
            this.mSuppressValuesTxt.setOpaque(true);
            if (this.mSuppressValuesTxt.getText().length() == 0) {
                this.enableContinue(false);
            }
        } else if (object == this.mSuppressValuesCheckbox && !this.mSuppressValuesCheckbox.isSelected()) {
            this.mSuppressValuesTxt.setEnabled(false);
            this.mSuppressValuesTxt.setOpaque(false);
            this.enableContinue(true);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.mSuppressValuesTxt.getText().length() > 0) {
            this.enableContinue(true);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.mSuppressValuesTxt.getText().length() == 0) {
            this.enableContinue(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mSuppressValuesTxt)) {
            this.mSuppressValuesTxt.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupMissingValuesPanel();
        JPanel jPanel3 = this.setupCoefficientPanel();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = 23;
        this.mGridConstraints.fill = 1;
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mGridConstraints, 0, 0, 1, 1, n2, null);
        Insets insets = new Insets(n, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, this.mGridConstraints, 0, 1, 1, 1, n2, insets);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        Boolean bl = dialogDataModel.getBoolean("IDS_FA_SUPPRESS_VALUES");
        if (bl != null && bl.booleanValue()) {
            this.mSuppressValuesTxt.setEnabled(true);
            this.mSuppressValuesTxt.setOpaque(true);
        }
        super.loadState(dialogDataModel);
    }

    private void initVars() {
        ControlAction controlAction = new ToggleButtonAction(this.mParentDlg, "IDS_FA_EXCLUDE_CASES_LISTWISE");
        this.mExcludeListWiseRadio = new JRadioButton(controlAction);
        controlAction = new ToggleButtonAction(this.mParentDlg, "IDS_FA_EXCLUDE_CASES_PAIRWISE");
        this.mExcludePairWiseRadio = new JRadioButton(controlAction);
        controlAction = new ToggleButtonAction(this.mParentDlg, "IDS_FA_REPLACE_MEAN");
        this.mReplaceMeanRadio = new JRadioButton(controlAction);
        this.mMissingValuesButtonGrp = new SpssButtonGroup();
        this.mMissingValuesButtonGrp.add(this.mExcludeListWiseRadio);
        this.mMissingValuesButtonGrp.add(this.mExcludePairWiseRadio);
        this.mMissingValuesButtonGrp.add(this.mReplaceMeanRadio);
        controlAction = new ToggleButtonAction(this.mParentDlg, "IDS_FA_SORTED_SIZE");
        this.mSortSizeCheckbox = new JCheckBox(controlAction);
        controlAction = new ToggleButtonAction(this.mParentDlg, "IDS_FA_SUPPRESS_VALUES");
        this.mSuppressValuesCheckbox = new JCheckBox(controlAction);
        this.mSuppressValuesCheckbox.addActionListener(this);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mSortSizeCheckbox);
        spssButtonGroup.add(this.mSuppressValuesCheckbox);
        this.mSuppressValuesTxt = new FloatTextField(0.0, 1.0, 4);
        controlAction = new TextFieldAction(this.mParentDlg, "IDS_SUPPRESS_VALUES_TXT");
        this.mSuppressValuesTxt.setAction((Action)controlAction);
        this.mSuppressValuesTxt.getDocument().addDocumentListener(this);
        this.mSuppressValuesTxt.addFocusListener((FocusListener)this);
        this.mGridConstraints = new GridBagConstraints();
    }

    private void setDefaults() {
        this.mExcludeListWiseRadio.setSelected(true);
        this.mSortSizeCheckbox.setSelected(false);
        this.mSuppressValuesCheckbox.setSelected(false);
        Formatter formatter = new Formatter().format(ResUtil.getLocale(), DEF_SUPPRESS_VAL, new Object[0]);
        this.mSuppressValuesTxt.setText(formatter.toString());
        this.mSuppressValuesTxt.setEnabled(false);
        this.mSuppressValuesTxt.setOpaque(false);
    }

    private JPanel setupMissingValuesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_FA_MISSING_VALUES_PANEL")));
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 2;
        Insets insets2 = new Insets(insets.top, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mExcludeListWiseRadio, this.mGridConstraints, 0, 0, 1, 1, n, insets2);
        insets2.set(insets.top, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mExcludePairWiseRadio, this.mGridConstraints, 0, 1, 1, 1, n, insets2);
        this.mGridConstraints.weighty = 1.0;
        insets2.set(insets.top, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mReplaceMeanRadio, this.mGridConstraints, 0, 2, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupCoefficientPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_FA_COEFFICIENT_DISPLAY_PANEL")));
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n3 = DialogUtil.getComponentGroupGap();
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 0;
        Insets insets2 = new Insets(insets.top, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mSortSizeCheckbox, this.mGridConstraints, 0, 0, 2, 1, n, insets2);
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.weighty = 1.0;
        insets2.set(insets.left, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSuppressValuesCheckbox, this.mGridConstraints, 0, 1, 1, 1, n, insets2);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_FA_ABSOLUTE_VALUE_LABEL");
        jLabel.setLabelFor((Component)this.mSuppressValuesTxt);
        this.mGridConstraints.weighty = 0.0;
        n = 22;
        insets2.set(insets.left, n2, n2, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, this.mGridConstraints, 0, 2, 1, 1, n, insets2);
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 1.0;
        n = 21;
        insets2.set(n2, n3, n2, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mSuppressValuesTxt, this.mGridConstraints, 1, 2, 1, 1, n, insets2);
        return jPanel;
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mMissingValuesButtonGrp);
        vector.add(this.mSortSizeCheckbox);
        vector.add(this.mSuppressValuesCheckbox);
        vector.add(this.mSuppressValuesTxt);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            if (!(this.mCmdButtonPanel.getComponent(i) instanceof JButton)) continue;
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }
}

