/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.data_reduction.factor;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.data_reduction.factor.FactorDlg;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FactorExtraction
extends BaseSubDialog
implements FocusListener,
ItemListener,
DocumentListener {
    private static final String DEF_EIGEN_VAL = "1";
    private static final String DEF_MAX_ITR = "25";
    private static final double MIN_EIGEN = 0.0;
    private static final double MAX_EIGEN = 9999.0;
    private static final int PRECISION_EIGEN = 3;
    private static final int MIN_FACTOR = 1;
    private static final int MAX_FACTOR = 9999;
    private static final int MIN_ITERATION = 1;
    private static final int MAX_ITERATION = 9999;
    private JLabel mMethodLabel;
    private JComboBox mMethodCombo;
    private JRadioButton mCorrelationRadio;
    private JRadioButton mCovarianceRadio;
    private SpssButtonGroup mAnalyseButtonGrp;
    private JCheckBox mUnrotatedCheckbox;
    private JCheckBox mScreeCheckbox;
    private JRadioButton mEigenRadio;
    private JRadioButton mFactorRadio;
    private SpssButtonGroup mExtractButtonGrp;
    private FloatTextField mEigenTxt;
    private JLabel mEigenLabel;
    private IntTextField mFactorTxt;
    private JLabel mMaxIterationLabel;
    private IntTextField mMaxIterarationTxt;
    private GridBagConstraints mGridConstraints;

    public FactorExtraction(FactorDlg factorDlg) {
        super(factorDlg, factorDlg.getResString("IDS_FA_EXTRACTION_TITLE"), true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_fact_ext";
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mMaxIterarationTxt)) {
            this.mMaxIterarationTxt.selectAll();
        } else if (focusEvent.getSource().equals(this.mEigenTxt)) {
            this.mEigenTxt.selectAll();
        } else if (focusEvent.getSource().equals(this.mFactorTxt)) {
            this.mFactorTxt.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mCovarianceRadio) {
            this.mEigenLabel.setVisible(true);
        } else if (object == this.mCorrelationRadio) {
            this.mEigenLabel.setVisible(false);
        } else if (object == this.mMethodCombo) {
            int n = this.mMethodCombo.getSelectedIndex();
            if (n == 0 || n == 4 || n == 6) {
                this.mCovarianceRadio.setEnabled(true);
                this.mCorrelationRadio.setEnabled(true);
            } else {
                this.mCorrelationRadio.setSelected(true);
                this.mCovarianceRadio.setEnabled(false);
                this.mCorrelationRadio.setEnabled(false);
                this.mEigenLabel.setVisible(false);
            }
        } else if (object == this.mFactorRadio) {
            this.mEigenTxt.setEnabled(false);
            this.mEigenTxt.setOpaque(false);
            this.mFactorTxt.setEnabled(true);
            this.mFactorTxt.setOpaque(true);
            if (this.mFactorRadio.isSelected() && (this.mFactorTxt.getText().length() == 0 || this.mMaxIterarationTxt.getText().length() == 0)) {
                this.enableContinue(false);
            } else {
                this.enableContinue(true);
            }
        } else if (object == this.mEigenRadio) {
            this.mEigenTxt.setEnabled(true);
            this.mEigenTxt.setOpaque(true);
            if (this.mEigenRadio.isSelected() && (this.mEigenTxt.getText().length() == 0 || this.mMaxIterarationTxt.getText().length() == 0)) {
                this.enableContinue(false);
            } else {
                this.enableContinue(true);
            }
            this.mFactorTxt.setEnabled(false);
            this.mFactorTxt.setOpaque(false);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.mEigenRadio.isSelected() && this.mEigenTxt.getText().length() > 0 && this.mMaxIterarationTxt.getText().length() > 0) {
            this.enableContinue(true);
        }
        if (this.mFactorRadio.isSelected() && this.mFactorTxt.getText().length() > 0 && this.mMaxIterarationTxt.getText().length() > 0) {
            this.enableContinue(true);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.mEigenRadio.isSelected() && (this.mEigenTxt.getText().length() == 0 || this.mMaxIterarationTxt.getText().length() == 0)) {
            this.enableContinue(false);
        }
        if (this.mFactorRadio.isSelected() && (this.mFactorTxt.getText().length() == 0 || this.mMaxIterarationTxt.getText().length() == 0)) {
            this.enableContinue(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupExtractionPanel();
        JPanel jPanel3 = this.setupAnalyzePanel();
        JPanel jPanel4 = this.setupDisplayPanel();
        JPanel jPanel5 = this.setupExtractPanel();
        JPanel jPanel6 = this.setupLowerExtractionPanel();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        int n3 = 23;
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 1;
        Insets insets = new Insets(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mGridConstraints, 0, 0, 2, 1, n3, insets);
        this.mGridConstraints.weighty = 1.0;
        insets.set(n, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, this.mGridConstraints, 0, 1, 1, 1, n3, insets);
        insets.set(n, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel4, this.mGridConstraints, 1, 1, 1, 1, n3, insets);
        insets.set(n, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel5, this.mGridConstraints, 0, 2, 2, 1, n3, insets);
        this.mGridConstraints.weighty = 0.0;
        insets.set(n, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel6, this.mGridConstraints, 0, 3, 2, 1, n3, insets);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        Boolean bl = dialogDataModel.getBoolean("IDS_FA_EIGEN_VALUES");
        Boolean bl2 = dialogDataModel.getBoolean("IDS_FA_NO_OF_FACTORS");
        Boolean bl3 = dialogDataModel.getBoolean("IDS_FA_COVARIANCE");
        if (bl != null && bl.booleanValue()) {
            this.mEigenTxt.setEnabled(true);
            this.mEigenTxt.setOpaque(true);
            this.mFactorTxt.setEnabled(false);
            this.mFactorTxt.setOpaque(false);
        }
        if (bl2 != null && bl2.booleanValue()) {
            this.mFactorTxt.setEnabled(true);
            this.mFactorTxt.setOpaque(true);
            this.mEigenTxt.setEnabled(false);
            this.mEigenTxt.setOpaque(false);
        }
        if (bl3 != null && bl3.booleanValue()) {
            this.mEigenLabel.setVisible(true);
        }
    }

    private void initVars() {
        this.mMethodLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_FA_METHOD");
        String[] stringArray = new String[]{this.getResString("IDS_FA_PRINCIPAL_COMP"), this.getResString("IDS_FA_UNWEIGHT_LEAST_SQR"), this.getResString("IDS_FA_GENERALIZED_LEAST_SQR"), this.getResString("IDS_FA_MAX_LIKELIHOOD"), this.getResString("IDS_FA_PRINCIPAL_AXIS_FACTORING"), this.getResString("IDS_FA_ALPHA_FACTORING"), this.getResString("IDS_FA_IMAGE_FACTORING")};
        this.mMethodCombo = new JComboBox<String>(stringArray);
        this.mMethodLabel.setLabelFor(this.mMethodCombo);
        ControlAction controlAction = new ComboboxAction(this.mParentDlg, "IDS_METHOD_COMBO");
        this.mMethodCombo.setAction(controlAction);
        this.mMethodCombo.setFont(this.mMethodLabel.getFont());
        this.mMethodCombo.addItemListener(this);
        controlAction = new ToggleButtonAction(this.mParentDlg, "IDS_FA_CORRELATION");
        this.mCorrelationRadio = new JRadioButton(controlAction);
        controlAction = new ToggleButtonAction(this.mParentDlg, "IDS_FA_COVARIANCE");
        this.mCovarianceRadio = new JRadioButton(controlAction);
        this.mAnalyseButtonGrp = new SpssButtonGroup();
        this.mAnalyseButtonGrp.add(this.mCorrelationRadio);
        this.mAnalyseButtonGrp.add(this.mCovarianceRadio);
        this.mCovarianceRadio.addItemListener(this);
        this.mCorrelationRadio.addItemListener(this);
        controlAction = new ToggleButtonAction(this.mParentDlg, "IDS_FA_UNROTATED_FACTOR_SOL");
        this.mUnrotatedCheckbox = new JCheckBox(controlAction);
        controlAction = new ToggleButtonAction(this.mParentDlg, "IDS_FA_SCREE_PLOT");
        this.mScreeCheckbox = new JCheckBox(controlAction);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mUnrotatedCheckbox);
        spssButtonGroup.add(this.mScreeCheckbox);
        controlAction = new ToggleButtonAction(this.mParentDlg, "IDS_FA_EIGEN_VALUES");
        this.mEigenRadio = new JRadioButton(controlAction);
        controlAction = new ToggleButtonAction(this.mParentDlg, "IDS_FA_NO_OF_FACTORS");
        this.mFactorRadio = new JRadioButton(controlAction);
        this.mExtractButtonGrp = new SpssButtonGroup();
        this.mExtractButtonGrp.add(this.mEigenRadio);
        this.mExtractButtonGrp.add(this.mFactorRadio);
        this.mEigenRadio.addItemListener(this);
        this.mFactorRadio.addItemListener(this);
        this.mEigenTxt = new FloatTextField(0.0, 9999.0, 3, true);
        this.mEigenTxt.setColumns(3);
        this.mEigenTxt.setText(DEF_EIGEN_VAL);
        controlAction = new TextFieldAction(this.mParentDlg, "IDS_EIGEN_VALUES_TXT");
        this.mEigenTxt.setAction((Action)controlAction);
        this.mEigenTxt.getDocument().addDocumentListener(this);
        this.mEigenTxt.addFocusListener((FocusListener)this);
        this.mEigenTxt.setMinimumSize(this.mEigenTxt.getPreferredSize());
        this.mFactorTxt = new IntTextField(1, 9999, true);
        controlAction = new TextFieldAction(this.mParentDlg, "IDS_NO_OF_FACTORS_TXT");
        this.mFactorTxt.setAction((Action)controlAction);
        this.mFactorTxt.getDocument().addDocumentListener(this);
        this.mFactorTxt.addFocusListener((FocusListener)this);
        this.mFactorTxt.setMinimumSize(this.mFactorTxt.getPreferredSize());
        this.mEigenLabel = new JLabel(this.getResString("IDS_FA_EIGEN1_VALUES"));
        this.mMaxIterationLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_FA_MAX_ITERATION");
        this.mMaxIterarationTxt = new IntTextField(1, 9999, true);
        this.mMaxIterarationTxt.setText(DEF_MAX_ITR);
        this.mMaxIterarationTxt.addFocusListener((FocusListener)this);
        this.mMaxIterarationTxt.getDocument().addDocumentListener(this);
        this.mMaxIterationLabel.setLabelFor((Component)this.mMaxIterarationTxt);
        controlAction = new TextFieldAction(this.mParentDlg, "IDS_MAX_ITERATION_TXT");
        this.mMaxIterarationTxt.setAction((Action)controlAction);
        this.mMaxIterarationTxt.setMinimumSize(this.mMaxIterarationTxt.getPreferredSize());
        this.mGridConstraints = new GridBagConstraints();
    }

    private void setDefaults() {
        this.mMethodCombo.setSelectedIndex(0);
        this.mCorrelationRadio.setSelected(true);
        this.mUnrotatedCheckbox.setSelected(true);
        this.mScreeCheckbox.setSelected(false);
        this.mEigenRadio.setSelected(false);
        this.mFactorRadio.setSelected(false);
        this.mEigenRadio.setSelected(true);
        this.mFactorTxt.setEnabled(false);
        this.mFactorTxt.setOpaque(false);
        this.mEigenLabel.setVisible(false);
    }

    private JPanel setupExtractionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        int n = 21;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mMethodLabel, this.mGridConstraints, 0, 0, 1, 1, n, null);
        n = 23;
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.fill = 0;
        Insets insets = new Insets(0, DialogUtil.getComponentGroupGap(), 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mMethodCombo, this.mGridConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupAnalyzePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_FA_ANALYZE_PANEL")));
        int n = 23;
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 0;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mCorrelationRadio, this.mGridConstraints, 0, 0, 1, 1, n, insets2);
        this.mGridConstraints.weighty = 1.0;
        insets2.set(insets.top, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mCovarianceRadio, this.mGridConstraints, 0, 1, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupDisplayPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_FA_DISPLAY_PANEL")));
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 0;
        Insets insets2 = new Insets(insets.top, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mUnrotatedCheckbox, this.mGridConstraints, 0, 0, 1, 1, n, insets2);
        this.mGridConstraints.weighty = 1.0;
        insets2.set(insets.top, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mScreeCheckbox, this.mGridConstraints, 0, 1, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupExtractPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_FA_EXTRACT_PANEL")));
        int n = 21;
        jPanel.setPreferredSize(new Dimension(410, 150));
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n3 = DialogUtil.getSubCheckboxGroupIndent();
        int n4 = DialogUtil.getComponentGroupGap();
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 2;
        Insets insets2 = new Insets(insets.top, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mEigenRadio, this.mGridConstraints, 0, 0, 1, 1, n, insets2);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_FA_EIGEN_VALUES_LABEL");
        jLabel.setLabelFor((Component)this.mEigenTxt);
        insets2.set(insets.top, n2 + n3, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, this.mGridConstraints, 0, 1, 1, 1, n, insets2);
        this.mGridConstraints.fill = 0;
        n = 23;
        insets2.set(insets.top, n4, 0, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mEigenTxt, this.mGridConstraints, 1, 1, 1, 1, n, insets2);
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.fill = 2;
        insets2.set(insets.top, 0, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mEigenLabel, this.mGridConstraints, 2, 1, 1, 1, n, insets2);
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.fill = 0;
        insets2.set(insets.top, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mFactorRadio, this.mGridConstraints, 0, 2, 1, 1, n, insets2);
        this.mGridConstraints.weighty = 1.0;
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_FA_FACTORS_LABEL");
        jLabel2.setLabelFor((Component)this.mFactorTxt);
        this.mGridConstraints.fill = 0;
        insets2.set(0, n2 + n3, n2, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel2, this.mGridConstraints, 0, 3, 1, 1, n, insets2);
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.fill = 0;
        insets2.set(0, n4, n2, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mFactorTxt, this.mGridConstraints, 1, 3, 2, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupLowerExtractionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        int n = 21;
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mMaxIterationLabel, this.mGridConstraints, 0, 0, 1, 1, n, null);
        n = 23;
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.fill = 0;
        Insets insets = new Insets(0, DialogUtil.getComponentGroupGap(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxIterarationTxt, this.mGridConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mMethodCombo);
        vector.add(this.mAnalyseButtonGrp);
        vector.add(this.mUnrotatedCheckbox);
        vector.add(this.mScreeCheckbox);
        vector.add(this.mExtractButtonGrp);
        vector.add(this.mEigenTxt);
        vector.add(this.mFactorTxt);
        vector.add(this.mMaxIterarationTxt);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            if (!(this.mCmdButtonPanel.getComponent(i) instanceof JButton)) continue;
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }
}

