/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.data_reduction.factor;

import com.spss.java_client.core.common.ORIGINATOR_ID;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.ISpssVarFormatter;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.data_reduction.factor.FactorDescriptives;
import com.spss.java_client.ui.dialogs.base.analyze.data_reduction.factor.FactorExtraction;
import com.spss.java_client.ui.dialogs.base.analyze.data_reduction.factor.FactorOptions;
import com.spss.java_client.ui.dialogs.base.analyze.data_reduction.factor.FactorRotation;
import com.spss.java_client.ui.dialogs.base.analyze.data_reduction.factor.FactorScores;
import com.spss.java_client.ui.dialogs.base.analyze.data_reduction.factor.FactorValues;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormatSymbols;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class FactorDlg
extends BaseProcedureDialog
implements ListDataListener,
FocusListener,
IVarMoveHandler {
    protected DecimalFormatSymbols mSymbol = new DecimalFormatSymbols(UIToolResUtil.getSPSSLocale());
    private final String[] comboSyntaxStrings = new String[]{"PC", "ULS", "GLS", "ML", "PAF", "ALPHA", "IMAGE"};
    private static boolean sValueEntered = true;
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetVarList;
    private ArrowButton mVariableArrow;
    private ArrowButton mSelectionVariableArrow;
    private JLabel mVariablesLabel;
    private JLabel mSelectionLabel;
    private TargetVariableList mValueTargetList;
    private JButton mDescriptivesButton;
    private JButton mExtractionButton;
    private JButton mRotationButton;
    private JButton mScoresButton;
    private JButton mOptionsButton;
    private JButton mValuesButton;
    private JScrollPane mSrcScrollPane;
    private JScrollPane mTargetScrollPane;
    private JScrollPane mTextScrollPane;
    private LinkedHashMap<String, String> syntaxMap;
    private ValueListFormatter mFormatter;
    private GridBagConstraints mGridConstraints;

    public FactorDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle.getDefaultResourceBundleName(), AnalyzeResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_FA_FACTOR_ANALYSIS"));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_fact";
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetVarList.removeAll();
        this.mValueTargetList.removeAll();
        this.enableOkPaste(false);
        this.setDefaults();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mValueTargetList) {
            if (this.mValueTargetList.getModel().getSize() == 1) {
                this.mValuesButton.setEnabled(true);
            } else if (this.mValueTargetList.getModel().getSize() == 0) {
                this.mValuesButton.setEnabled(false);
            }
        } else if (focusEvent.getSource() == this.mSrcVarList) {
            this.mValuesButton.setEnabled(false);
        } else if (focusEvent.getSource() == this.mTargetVarList) {
            this.mValuesButton.setEnabled(false);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public String getIActionKey() {
        return "analyze_data_reduction_factor";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mValueTargetList.getModel()) {
            this.mValuesButton.setEnabled(true);
            sValueEntered = false;
        }
        this.enableOkPaste(this.canEnableOkPaste());
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() == this.mValueTargetList.getModel()) {
            this.mValuesButton.setEnabled(false);
            sValueEntered = true;
            this.getDialogDataModel().putString("IDS_SELECTION_VARIABLE_TXT", null);
        }
        this.enableOkPaste(this.canEnableOkPaste());
    }

    public boolean canEnableOkPaste() {
        boolean bl = false;
        if (this.mTargetVarList.getModel().getSize() == 1 || this.mTargetVarList.getModel().getSize() == 0) {
            bl = false;
        } else if (this.mTargetVarList.getModel().getSize() >= 2 && sValueEntered) {
            bl = true;
        } else if (this.mTargetVarList.getModel().getSize() >= 2 && !sValueEntered && this.mValueTargetList.getModel().getSize() == 0) {
            bl = true;
        }
        return bl;
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public String generateSyntax() {
        ISpssVariable iSpssVariable;
        Boolean bl;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("FACTOR"));
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        if (dialogDataModel.getBoolean("IDS_FA_EXCLUDE_CASES_LISTWISE") == null && dialogDataModel.getBoolean("IDS_FA_EXCLUDE_CASES_PAIRWISE") == null && dialogDataModel.getBoolean("IDS_FA_REPLACE_MEAN") == null) {
            dialogDataModel.putBoolean("IDS_FA_EXCLUDE_CASES_LISTWISE", true);
        }
        if ((bl = dialogDataModel.getBoolean("IDS_FA_INITIAL_SOL")) == null || bl.booleanValue()) {
            dialogDataModel.putBoolean("IDS_FA_INITIAL_SOL", true);
        } else if (!bl.booleanValue()) {
            dialogDataModel.putBoolean("IDS_FA_INITIAL_SOL", false);
        }
        Boolean bl2 = dialogDataModel.getBoolean("IDS_FA_UNROTATED_FACTOR_SOL");
        if (bl2 == null || bl2.booleanValue()) {
            dialogDataModel.putBoolean("IDS_FA_UNROTATED_FACTOR_SOL", true);
        } else if (!bl2.booleanValue()) {
            dialogDataModel.putBoolean("IDS_FA_UNROTATED_FACTOR_SOL", false);
        }
        if (dialogDataModel.getString("IDS_EIGEN_VALUES_TXT") == null && dialogDataModel.getString("IDS_NO_OF_FACTORS_TXT") == null) {
            dialogDataModel.putString("IDS_EIGEN_VALUES_TXT", "1");
        }
        if (dialogDataModel.getBoolean("IDS_FA_EIGEN_VALUES") == null && dialogDataModel.getBoolean("IDS_FA_NO_OF_FACTORS") == null) {
            dialogDataModel.putString("IDS_EIGEN_VALUES_TXT", "1");
        }
        if (dialogDataModel.getString("IDS_MAX_ITERATION_TXT") == null) {
            dialogDataModel.putString("IDS_MAX_ITERATION_TXT", "25");
        }
        if (dialogDataModel.getInteger("IDS_METHOD_COMBO") == null) {
            dialogDataModel.putInteger("IDS_METHOD_COMBO", 0);
        }
        if (dialogDataModel.getBoolean("IDS_FA_NONE") == null && dialogDataModel.getBoolean("IDS_FA_QUARTIMAX") == null && dialogDataModel.getBoolean("IDS_FA_VARIMAX") == null && dialogDataModel.getBoolean("IDS_FA_EQUAMAX") == null && dialogDataModel.getBoolean("IDS_FA_DIRECT") == null && dialogDataModel.getBoolean("IDS_FA_PROMAX") == null) {
            dialogDataModel.putBoolean("IDS_FA_NONE", true);
        }
        if (dialogDataModel.getBoolean("IDS_FA_CORRELATION") == null && dialogDataModel.getBoolean("IDS_FA_COVARIANCE") == null) {
            dialogDataModel.putBoolean("IDS_FA_CORRELATION", true);
        }
        if (dialogDataModel.getBoolean("IDS_FA_EIGEN_VALUES") != null && !dialogDataModel.getBoolean("IDS_FA_EIGEN_VALUES").booleanValue()) {
            string2 = dialogDataModel.getString("IDS_EIGEN_VALUES_TXT");
            string = dialogDataModel.getString("IDS_NO_OF_FACTORS_TXT");
            dialogDataModel.putString("IDS_EIGEN_VALUES_TXT", null);
        } else if (dialogDataModel.getBoolean("IDS_FA_NO_OF_FACTORS") != null && !dialogDataModel.getBoolean("IDS_FA_NO_OF_FACTORS").booleanValue()) {
            string = dialogDataModel.getString("IDS_NO_OF_FACTORS_TXT");
            string2 = dialogDataModel.getString("IDS_EIGEN_VALUES_TXT");
            dialogDataModel.putString("IDS_NO_OF_FACTORS_TXT", null);
        }
        if (dialogDataModel.getBoolean("IDS_FA_CORRELATION") == null || !dialogDataModel.getBoolean("IDS_FA_CORRELATION").booleanValue()) {
            dialogDataModel.putBoolean("IDS_FA_CORRELATION", null);
        } else if (dialogDataModel.getBoolean("IDS_FA_COVARIANCE") == null || !dialogDataModel.getBoolean("IDS_FA_COVARIANCE").booleanValue()) {
            dialogDataModel.putBoolean("IDS_FA_COVARIANCE", null);
        }
        if (dialogDataModel.getInteger("IDS_METHOD_COMBO") == 1 || dialogDataModel.getInteger("IDS_METHOD_COMBO") == 2 || dialogDataModel.getInteger("IDS_METHOD_COMBO") == 3 || dialogDataModel.getInteger("IDS_METHOD_COMBO") == 5) {
            dialogDataModel.putBoolean("IDS_FA_CORRELATION", null);
            dialogDataModel.putBoolean("IDS_FA_COVARIANCE", null);
        }
        if (dialogDataModel.getBoolean("IDS_FA_DIRECT") != null && !dialogDataModel.getBoolean("IDS_FA_DIRECT").booleanValue()) {
            string3 = dialogDataModel.getString("IDS_DELTA_TXT");
            string4 = dialogDataModel.getString("IDS_KAPPA_TXT");
            dialogDataModel.putString("IDS_DELTA_TXT", null);
        } else if (dialogDataModel.getBoolean("IDS_FA_PROMAX") != null && !dialogDataModel.getBoolean("IDS_FA_PROMAX").booleanValue()) {
            string3 = dialogDataModel.getString("IDS_DELTA_TXT");
            string4 = dialogDataModel.getString("IDS_KAPPA_TXT");
            dialogDataModel.putString("IDS_KAPPA_TXT", null);
        }
        if (dialogDataModel.getBoolean("IDS_FA_NONE") == null || dialogDataModel.getBoolean("IDS_FA_NONE").booleanValue()) {
            dialogDataModel.putString("IDS_MAX_ITERATION_CONV_TXT", null);
            dialogDataModel.putBoolean("IDS_FA_ROTATED_SOLUTION", null);
        }
        if (dialogDataModel.getBoolean("IDS_FA_SUPPRESS_VALUES") == null || !dialogDataModel.getBoolean("IDS_FA_SUPPRESS_VALUES").booleanValue()) {
            dialogDataModel.putString("IDS_SUPPRESS_VALUES_TXT", null);
        }
        if (dialogDataModel.getBoolean("IDS_FA_SAVE_AS_VAR") == null || !dialogDataModel.getBoolean("IDS_FA_SAVE_AS_VAR").booleanValue()) {
            dialogDataModel.putBoolean("IDS_FA_REGRESSION", null);
            dialogDataModel.putBoolean("IDS_FA_BARTLETT", null);
            dialogDataModel.putBoolean("IDS_FA_ANDERSON_RUBIN", null);
        }
        String string5 = this.mTargetVarList.getVariablesStringList();
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/VARIABLES "));
        stringBuffer.append(string5);
        stringBuffer.append(" ");
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/ANALYSIS "));
        stringBuffer.append(string5);
        String string6 = this.mValueTargetList.getVariablesStringList();
        String string7 = dialogDataModel.getString("IDS_SELECTION_VARIABLE_TXT");
        if (string7 != null) {
            boolean bl3 = false;
            if (this.mValueTargetList.getModel().getSize() > 0 && (iSpssVariable = this.mValueTargetList.getModel().getElementAt(0)).getType() > 0) {
                bl3 = true;
            }
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/SELECT=")).append(string6);
            if (bl3) {
                stringBuffer.append("(").append(CharacterUtil.smartQuote((String)string7)).append(")");
            } else {
                stringBuffer.append("(").append(string7).append(")");
            }
        }
        LinkedHashMap<String, String> linkedHashMap = this.getResourceSyntaxMap();
        iSpssVariable = this.getSyntaxMap();
        for (Map.Entry<String, String> entry : linkedHashMap.entrySet()) {
            int n;
            int n2;
            int n3;
            String string8;
            if (entry.getKey().equals("IDS_FA_ROTATED_SOLUTION")) {
                this.syntaxMap.put("ROTATION", "/PRINT");
            } else if (entry.getKey().equals("IDS_FA_LOADING_PLOT")) {
                this.syntaxMap.put("ROTATION", "/PLOT");
            } else if (entry.getKey().equals("IDS_FA_COEFFICIENTS")) {
                this.syntaxMap.put("CORRELATION", "/PRINT");
            } else if (entry.getKey().equals("IDS_FA_CORRELATION")) {
                this.syntaxMap.put("CORRELATION", "/METHOD=");
            }
            Boolean bl4 = dialogDataModel.getBoolean(entry.getKey());
            String string9 = dialogDataModel.getString(entry.getKey());
            Integer n4 = dialogDataModel.getInteger(entry.getKey());
            if (string9 != null && !entry.getKey().equals("IDS_METHOD_COMBO")) {
                for (Map.Entry entry2 : iSpssVariable.entrySet()) {
                    int n5;
                    if (!entry.getValue().equals(entry2.getKey())) continue;
                    string8 = (String)entry2.getValue();
                    n3 = stringBuffer.indexOf(string8);
                    n2 = string8.length();
                    if (n3 == -1) {
                        stringBuffer.append("\n");
                        stringBuffer.append("  ").append(string8);
                        String string10 = (String)entry2.getKey();
                        n = string10.indexOf("(");
                        int n6 = string10.indexOf(")");
                        String string11 = string10.substring(n + 1, n6);
                        stringBuffer.append(string10.replace(string11, string9));
                        continue;
                    }
                    int n7 = stringBuffer.indexOf("/EXTRACTION");
                    if (n7 == -1) {
                        n = n3 + n2;
                        int n8 = stringBuffer.indexOf("/", n);
                        String string12 = (String)entry2.getKey();
                        int n9 = string12.indexOf("(");
                        n5 = string12.indexOf(")");
                        String string13 = string12.substring(n9 + 1, n5);
                        if (n8 == -1) {
                            stringBuffer.append(string12.replace(string13, string9));
                            continue;
                        }
                        stringBuffer.insert(n8 - 2, string12.replace(string13, string9));
                        continue;
                    }
                    n = stringBuffer.indexOf("/CRITERIA", n7);
                    if (n == -1) {
                        if (((String)entry2.getKey()).equals(" ITERATE(Ritr)") && string9.equals("")) continue;
                        stringBuffer.append("\n");
                        stringBuffer.append("  ").append(string8);
                        String string14 = (String)entry2.getKey();
                        int n10 = string14.indexOf("(");
                        int n11 = string14.indexOf(")");
                        String string15 = string14.substring(n10 + 1, n11);
                        stringBuffer.append(string14.replace(string15, string9));
                        continue;
                    }
                    int n12 = n + n2;
                    int n13 = stringBuffer.indexOf("/", n12);
                    String string16 = (String)entry2.getKey();
                    n5 = string16.indexOf("(");
                    int n14 = string16.indexOf(")");
                    String string17 = string16.substring(n5 + 1, n14);
                    if (n13 == -1) {
                        stringBuffer.append(string16.replace(string17, string9));
                        continue;
                    }
                    stringBuffer.insert(n13 - 2, string16.replace(string17, string9));
                }
            }
            if (bl4 != null && bl4.booleanValue()) {
                for (Map.Entry entry2 : iSpssVariable.entrySet()) {
                    if (!entry.getValue().equals(entry2.getKey())) continue;
                    string8 = (String)entry2.getValue();
                    if (string8.equals(" /MISSING")) {
                        n3 = stringBuffer.indexOf(string8);
                        if (n3 == -1) {
                            n2 = stringBuffer.indexOf("/ANALYSIS");
                            stringBuffer.insert(n2 - 4, "\n " + string8);
                            n2 = stringBuffer.indexOf("/ANALYSIS");
                            stringBuffer.insert(n2 - 4, " " + (String)entry2.getKey());
                            continue;
                        }
                        n2 = stringBuffer.indexOf("/ANALYSIS");
                        stringBuffer.insert(n2 - 4, (String)entry2.getKey());
                        continue;
                    }
                    n3 = stringBuffer.indexOf(string8);
                    n2 = string8.length();
                    if (n3 == -1) {
                        stringBuffer.append("\n");
                        stringBuffer.append("  ").append(string8);
                        if (string8.equals("/METHOD=")) {
                            stringBuffer.append((String)entry2.getKey());
                            continue;
                        }
                        stringBuffer.append(" ").append((String)entry2.getKey());
                        if (!((String)entry2.getKey()).equals("PROMAX")) continue;
                        String string18 = dialogDataModel.getString("IDS_KAPPA_TXT");
                        stringBuffer.append("(").append(string18).append(")");
                        continue;
                    }
                    int n15 = n3 + n2;
                    n = stringBuffer.indexOf("/", n15);
                    if (n == -1) {
                        stringBuffer.append(" ").append((String)entry2.getKey());
                        continue;
                    }
                    stringBuffer.insert(n - 2, (String)entry2.getKey());
                }
            }
            if (n4 == null) continue;
            for (Map.Entry entry2 : iSpssVariable.entrySet()) {
                if (!entry.getValue().equals(entry2.getKey()) || (n3 = stringBuffer.indexOf(string8 = (String)entry2.getValue())) != -1) continue;
                stringBuffer.append("\n");
                stringBuffer.append("  ").append(string8);
                stringBuffer.append(" ").append(this.comboSyntaxStrings[n4]);
            }
        }
        dialogDataModel.putString("IDS_EIGEN_VALUES_TXT", string2);
        dialogDataModel.putString("IDS_NO_OF_FACTORS_TXT", string);
        dialogDataModel.putString("IDS_DELTA_TXT", string3);
        dialogDataModel.putString("IDS_KAPPA_TXT", string4);
        super.saveDialogState();
        stringBuffer.append(".\n");
        return stringBuffer.toString();
    }

    @Override
    public boolean preMoveVariables(ISpssVariable[] iSpssVariableArray, VariableList variableList) {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        if (variableList.equals(this.mValueTargetList)) {
            dialogDataModel.putString("IDS_SELECTION_VARIABLE_TXT", null);
        }
        return true;
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_FA_DESCRIPTIVES"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FactorDlg.this.runDescriptivesSubDialog();
            }
        };
        ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction(this, "IDS_FA_EXTRACTION"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FactorDlg.this.runExtractionSubDialog();
            }
        };
        ToggleButtonAction toggleButtonAction3 = new ToggleButtonAction(this, "IDS_FA_ROTATION"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FactorDlg.this.runRotationSubDialog();
            }
        };
        ToggleButtonAction toggleButtonAction4 = new ToggleButtonAction(this, "IDS_FA_SCORES"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FactorDlg.this.runScoresSubDialog();
            }
        };
        ToggleButtonAction toggleButtonAction5 = new ToggleButtonAction("IDS_COMMON_OPTIONS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FactorDlg.this.runOptionsSubDialog();
            }
        };
        this.mDescriptivesButton = new JButton(toggleButtonAction);
        this.mExtractionButton = new JButton(toggleButtonAction2);
        this.mRotationButton = new JButton(toggleButtonAction3);
        this.mScoresButton = new JButton(toggleButtonAction4);
        this.mOptionsButton = new JButton(toggleButtonAction5);
        this.addOptionsPanelButton(jPanel, this.mDescriptivesButton);
        this.addOptionsPanelButton(jPanel, this.mExtractionButton);
        this.addOptionsPanelButton(jPanel, this.mRotationButton);
        this.addOptionsPanelButton(jPanel, this.mScoresButton);
        this.addOptionsPanelButton(jPanel, this.mOptionsButton);
        DialogUtil.normalizeButtonWidths((JPanel)jPanel);
        return jPanel;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupMainPanel(jPanel);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        sValueEntered = true;
        this.enableOkPaste(this.canEnableOkPaste());
        this.mSrcVarList.setSelectedIndex(0);
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList();
        this.mSrcVarList.setIdentifier("SourceListIdentifier");
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mSrcVarList.getModel().addListDataListener(this);
        this.mSrcVarList.addFocusListener(this);
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 7 + 2));
        this.mTargetVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetVarList.setIdentifier("TargetListIdentifier");
        this.mTargetScrollPane = new JScrollPane(this.mTargetVarList);
        this.mTargetScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mTargetVarList.addFocusListener(this);
        this.mVariableArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mVariableArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mVariableArrow.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mValueTargetList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mValueTargetList.setIdentifier("ValueListIdentifier");
        this.mTextScrollPane = new JScrollPane(this.mValueTargetList);
        this.mTextScrollPane.setPreferredSize(this.mValueTargetList.getMinimumSize());
        this.mTextScrollPane.setVerticalScrollBarPolicy(21);
        this.mTextScrollPane.setHorizontalScrollBarPolicy(31);
        this.mValueTargetList.getModel().addListDataListener(this);
        this.mValueTargetList.addFocusListener(this);
        this.mValueTargetList.setShowIcon(false);
        this.mFormatter = new ValueListFormatter();
        this.mValueTargetList.setCellRenderer(new CustomVarListCellRenderer(this.mFormatter));
        this.mVarMoveHandler = this;
        this.mSelectionVariableArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mSelectionVariableArrow.setVarMoveHandler(this.mVarMoveHandler);
        this.mSelectionVariableArrow.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mSelectionVariableArrow.registerVariableList(this.mValueTargetList, SpssArrowButton.ButtonOrientation.left);
        this.mVariablesLabel = DialogUtil.createLabel(this, "IDS_FA_SELECTION_VARIABLE");
        this.mVariablesLabel.setLabelFor(this.mValueTargetList);
        this.mSelectionLabel = DialogUtil.createLabel(this, "IDS_FA_VARIABLES");
        this.mSelectionLabel.setLabelFor(this.mTargetVarList);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_FA_VALUES"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ISpssVariable iSpssVariable = FactorDlg.this.mValueTargetList.getModel().getElementAt(0);
                if (iSpssVariable.getType() != 0) {
                    FactorDlg.this.getDialogDataModel().putBoolean("STRING", true);
                } else {
                    FactorDlg.this.getDialogDataModel().putBoolean("STRING", false);
                }
                FactorDlg.this.runSubDialog(new FactorValues(FactorDlg.this));
                String string = FactorDlg.this.mFormatter.getDisplayText(FactorDlg.this.mValueTargetList.getModel().getElementAt(0));
                Character c = Character.valueOf(string.charAt(0));
                if (c.equals(Character.valueOf('?'))) {
                    sValueEntered = false;
                    FactorDlg.this.enableOkPaste(FactorDlg.this.canEnableOkPaste());
                } else {
                    sValueEntered = true;
                    FactorDlg.this.enableOkPaste(FactorDlg.this.canEnableOkPaste());
                }
                FactorDlg.this.mValueTargetList.repaint();
                FactorDlg.this.getDialogDataModel().putBoolean("STRING", null);
            }
        };
        this.mValuesButton = new JButton(toggleButtonAction);
        this.mGridConstraints = new GridBagConstraints();
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.mValuesButton.setEnabled(false);
    }

    private void setupMainPanel(JPanel jPanel) {
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.weighty = 0.0;
        int n = 23;
        this.mGridConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getArrowButtonInsets();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_FA_SRCLIST_LABEL");
        jLabel.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel, this.mGridConstraints, 0, 0, 1, 1, n, null);
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.weighty = 1.0;
        this.mGridConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, this.mGridConstraints, 0, 1, 1, 6, n, null);
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 2;
        Insets insets2 = new Insets(0, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSelectionLabel, this.mGridConstraints, 2, 0, 1, 1, n, insets2);
        this.mGridConstraints.weighty = 1.0;
        this.mGridConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mTargetScrollPane, this.mGridConstraints, 2, 1, 1, 3, n, insets2);
        n = 10;
        this.mGridConstraints.weightx = 0.0;
        this.mGridConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mVariableArrow, this.mGridConstraints, 1, 2, 1, 1, n, insets2);
        n = 23;
        this.mGridConstraints.weighty = 0.0;
        this.mGridConstraints.fill = 2;
        insets2.set(n2, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mVariablesLabel, this.mGridConstraints, 2, 4, 1, 1, n, insets2);
        insets2.set(0, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTextScrollPane, this.mGridConstraints, 2, 5, 1, 1, n, insets2);
        this.mGridConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mSelectionVariableArrow, this.mGridConstraints, 1, 4, 1, 2, 20, insets2);
        this.mGridConstraints.weightx = 1.0;
        this.mGridConstraints.fill = 0;
        insets2.set(n3, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mValuesButton, this.mGridConstraints, 2, 6, 1, 1, n, insets2);
    }

    private LinkedHashMap<String, String> getResourceSyntaxMap() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("IDS_FA_UNIVAR_DESC", "UNIVARIATE");
        linkedHashMap.put("IDS_FA_INITIAL_SOL", "INITIAL");
        linkedHashMap.put("IDS_FA_COEFFICIENTS", "CORRELATION");
        linkedHashMap.put("IDS_FA_SIGNIFICANCE_LVL", "SIG");
        linkedHashMap.put("IDS_FA_DETERMINANT", "DET");
        linkedHashMap.put("IDS_FA_KMO", "KMO");
        linkedHashMap.put("IDS_FA_INVERSE", "INV");
        linkedHashMap.put("IDS_FA_REPRODUCED", "REPR");
        linkedHashMap.put("IDS_FA_ANTI_IMAGE", "AIC");
        linkedHashMap.put("IDS_FA_EXCLUDE_CASES_LISTWISE", "LISTWISE");
        linkedHashMap.put("IDS_FA_EXCLUDE_CASES_PAIRWISE", "PAIRWISE");
        linkedHashMap.put("IDS_FA_REPLACE_MEAN", "MEANSUB");
        linkedHashMap.put("IDS_FA_UNROTATED_FACTOR_SOL", "EXTRACTION");
        linkedHashMap.put("IDS_FA_ROTATED_SOLUTION", "ROTATION");
        linkedHashMap.put("IDS_FA_DISPLAY_FACTOR", "FSCORE");
        linkedHashMap.put("IDS_FA_SORTED_SIZE", "SORT");
        linkedHashMap.put("IDS_SUPPRESS_VALUES_TXT", " BLANK(value)");
        linkedHashMap.put("IDS_FA_SCREE_PLOT", "EIGEN");
        linkedHashMap.put("IDS_FA_LOADING_PLOT", "ROTATION");
        linkedHashMap.put("IDS_EIGEN_VALUES_TXT", " MINEIGEN(eigenvalue)");
        linkedHashMap.put("IDS_NO_OF_FACTORS_TXT", " FACTORS(facvalue)");
        linkedHashMap.put("IDS_MAX_ITERATION_TXT", " ITERATE(itr)");
        linkedHashMap.put("IDS_METHOD_COMBO", "MTDCMBO");
        linkedHashMap.put("IDS_MAX_ITERATION_CONV_TXT", " ITERATE(Ritr)");
        linkedHashMap.put("IDS_DELTA_TXT", " DELTA(delta)");
        linkedHashMap.put("IDS_FA_NONE", "NOROTATE");
        linkedHashMap.put("IDS_FA_QUARTIMAX", "QUARTIMAX");
        linkedHashMap.put("IDS_FA_VARIMAX", "VARIMAX");
        linkedHashMap.put("IDS_FA_EQUAMAX", "EQUAMAX");
        linkedHashMap.put("IDS_FA_DIRECT", "OBLIMIN");
        linkedHashMap.put("IDS_FA_PROMAX", "PROMAX");
        linkedHashMap.put("IDS_FA_REGRESSION", "REG(ALL)");
        linkedHashMap.put("IDS_FA_BARTLETT", "BART(ALL)");
        linkedHashMap.put("IDS_FA_ANDERSON_RUBIN", "AR(ALL)");
        linkedHashMap.put("IDS_FA_CORRELATION", "CORRELATION");
        linkedHashMap.put("IDS_FA_COVARIANCE", "COVARIANCE");
        return linkedHashMap;
    }

    private LinkedHashMap<String, String> getSyntaxMap() {
        this.syntaxMap = new LinkedHashMap();
        this.syntaxMap.put("UNIVARIATE", "/PRINT");
        this.syntaxMap.put("INITIAL", "/PRINT");
        this.syntaxMap.put("CORRELATION", "/PRINT");
        this.syntaxMap.put("SIG", "/PRINT");
        this.syntaxMap.put("DET", "/PRINT");
        this.syntaxMap.put("KMO", "/PRINT");
        this.syntaxMap.put("INV", "/PRINT");
        this.syntaxMap.put("REPR", "/PRINT");
        this.syntaxMap.put("AIC", "/PRINT");
        this.syntaxMap.put("LISTWISE", " /MISSING");
        this.syntaxMap.put("PAIRWISE", " /MISSING");
        this.syntaxMap.put("MEANSUB", " /MISSING");
        this.syntaxMap.put("EXTRACTION", "/PRINT");
        this.syntaxMap.put("ROTATION", "/PRINT");
        this.syntaxMap.put("FSCORE", "/PRINT");
        this.syntaxMap.put("SORT", "/FORMAT");
        this.syntaxMap.put(" BLANK(value)", "/FORMAT");
        this.syntaxMap.put("EIGEN", "/PLOT");
        this.syntaxMap.put("ROTATION", "/PLOT");
        this.syntaxMap.put(" MINEIGEN(eigenvalue)", "/CRITERIA");
        this.syntaxMap.put(" FACTORS(facvalue)", "/CRITERIA");
        this.syntaxMap.put(" ITERATE(itr)", "/CRITERIA");
        this.syntaxMap.put("MTDCMBO", "/EXTRACTION");
        this.syntaxMap.put(" ITERATE(Ritr)", "/CRITERIA");
        this.syntaxMap.put(" DELTA(delta)", "/CRITERIA");
        this.syntaxMap.put("NOROTATE", "/ROTATION");
        this.syntaxMap.put("QUARTIMAX", "/ROTATION");
        this.syntaxMap.put("VARIMAX", "/ROTATION");
        this.syntaxMap.put("EQUAMAX", "/ROTATION");
        this.syntaxMap.put("OBLIMIN", "/ROTATION");
        this.syntaxMap.put("PROMAX", "/ROTATION");
        this.syntaxMap.put("REG(ALL)", "/SAVE");
        this.syntaxMap.put("BART(ALL)", "/SAVE");
        this.syntaxMap.put("AR(ALL)", "/SAVE");
        this.syntaxMap.put("CORRELATION", "/METHOD=");
        this.syntaxMap.put("COVARIANCE", "/METHOD=");
        return this.syntaxMap;
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mVariableArrow);
        vector.add(this.mSelectionVariableArrow);
        vector.add(this.mTargetVarList);
        vector.add(this.mValueTargetList);
        vector.add(this.mValuesButton);
        vector.add(this.mDescriptivesButton);
        vector.add(this.mExtractionButton);
        vector.add(this.mRotationButton);
        vector.add(this.mScoresButton);
        vector.add(this.mOptionsButton);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            if (!(this.mCmdButtonPanel.getComponent(i) instanceof JButton)) continue;
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    private void runDescriptivesSubDialog() {
        this.runSubDialog(new FactorDescriptives(this));
    }

    private void runExtractionSubDialog() {
        this.runSubDialog(new FactorExtraction(this));
    }

    private void runRotationSubDialog() {
        this.runSubDialog(new FactorRotation(this));
    }

    private void runScoresSubDialog() {
        this.runSubDialog(new FactorScores(this));
    }

    private void runOptionsSubDialog() {
        this.runSubDialog(new FactorOptions(this));
    }

    private String addLocale(String string) {
        String string2 = null;
        if (string != null) {
            string2 = string;
            if (this.mSymbol.getDecimalSeparator() != '.') {
                string2 = string.replace('.', this.mSymbol.getDecimalSeparator());
            }
            if (this.mSymbol.getMinusSign() != '-') {
                string2 = string2.replace('-', this.mSymbol.getMinusSign());
            }
            string2 = string2.trim();
        }
        return string2;
    }

    @Override
    protected BaseProcedureDialog.DataViewObserverAdapter createDataSourceObserver() {
        return new CustomDataViewObserverAdapter();
    }

    class CustomDataViewObserverAdapter
    extends BaseProcedureDialog.DataViewObserverAdapter {
        CustomDataViewObserverAdapter() {
            super(FactorDlg.this);
        }

        @Override
        public void notifyVariableModified(ORIGINATOR_ID oRIGINATOR_ID, int n) {
            super.notifyVariableModified(oRIGINATOR_ID, n);
            if (ProcedureDlgMgr.getMgr().anyProcedureDialogsRunning(true)) {
                FactorDlg.this.getDialogDataModel().putString("IDS_SELECTION_VARIABLE_TXT", null);
                FactorDlg.this.mValueTargetList.repaint();
            }
        }
    }

    class ValueListFormatter
    implements ISpssVarFormatter {
        ValueListFormatter() {
        }

        @Override
        public String getDisplayText(ISpssVariable iSpssVariable) {
            DialogDataModel dialogDataModel = FactorDlg.this.getDialogDataModel();
            String string = dialogDataModel.getString("IDS_SELECTION_VARIABLE_TXT");
            if (string != null) {
                if (iSpssVariable.getType() == 0) {
                    string = FactorDlg.this.addLocale(string);
                    return iSpssVariable.getName() + "=" + string;
                }
                if (iSpssVariable.getType() != 0) {
                    return iSpssVariable.getName() + "=" + CharacterUtil.smartQuote((String)string);
                }
            }
            return iSpssVariable.getName() + "=?";
        }

        @Override
        public boolean getShowIcons() {
            return false;
        }

        @Override
        public TargetVariableList getVarList() {
            return FactorDlg.this.mValueTargetList;
        }
    }
}

