/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.correlate.partial;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.correlate.partial.PartialOptions;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BootstrapDlg;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class PartialDlg
extends BaseProcedureDialog
implements ListDataListener {
    static final int MAX_LIMIT_OF_VARIABLE_LIST = 10000;
    static final int MAX_LIMIT_OF_CONTROLLING_LIST = 100;
    static final String ONETAILED_KEY = "IDS_PARTIAL_ONETAIL";
    static final String TWOTAILED_KEY = "IDS_PARTIAL_TWOTAIL";
    static final String FLAGSIGNIFICANT_KEY = "IDS_PARTIAL_FLAGSIGNIFICANT";
    static final String PARTIAL_OPTIONS_KEY = "IDS_COMMON_OPTIONS_3DOT";
    static final String PAARTIAL_VARIABLE_LIST = "IDS_PARTIAL_VARIABLE_LIST";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mVariableTargetVarList;
    private TargetVariableList mControllingTargetVarList;
    private JScrollPane mSrcScrollPane;
    private JScrollPane mVariableTargetScrollPane;
    private JScrollPane mControllingTargetScrollPane;
    private ArrowButton mVariablesArrowButton;
    private ArrowButton mControllingArrowButton;
    private JPanel mTestofsignPanel;
    private JRadioButton mTwoTailed;
    private JRadioButton mOneTailed;
    private SpssButtonGroup mGroup;
    private JCheckBox mFlagsignCheck;
    private boolean mIsBootstrapOK;

    public PartialDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle.getDefaultResourceBundleName(), AnalyzeResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_PARTIAL"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_part";
    }

    @Override
    public final String getIActionKey() {
        return "analyze_correlate_partial";
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    public boolean okPastePressed() {
        if (this.mIsBootstrapOK && BootstrapDlg.isStrataVariableListEmpty(this)) {
            this.runSubDialog(new BootstrapDlg(this));
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    public String generateSyntax() {
        Object object;
        Object object2;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        String string = this.mVariableTargetVarList.getVariablesStringList();
        String string2 = this.mControllingTargetVarList.getVariablesStringList();
        DialogDataModel dialogDataModel = (DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY);
        if (this.mIsBootstrapOK && dialogDataModel != null) {
            object2 = "";
            object = string + " " + string2;
            stringBuffer.append(BootstrapDlg.getBootstrapSyntax((String)object2, (String)object, dialogDataModel));
        }
        object2 = this.getDialogDataModel();
        stringBuffer.append(SyntaxUtil.getMainCommand("PARTIAL CORR"));
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/VARIABLES="));
        stringBuffer.append(string + " BY ");
        stringBuffer.append(string2);
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/SIGNIFICANCE="));
        object = ((DialogDataModel)object2).getBoolean(ONETAILED_KEY);
        if (object != null && ((Boolean)object).booleanValue()) {
            stringBuffer.append("ONETAIL");
        } else {
            stringBuffer.append("TWOTAIL");
        }
        object = ((DialogDataModel)object2).getBoolean(FLAGSIGNIFICANT_KEY);
        if (object != null && !((Boolean)object).booleanValue()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/FORMAT=CONDENSED"));
        }
        if ((object = ((DialogDataModel)object2).getBoolean("IDS_PARTIAL_MEANS_STANDARD_DEVIATIONS")) != null && ((Boolean)object).booleanValue()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/STATISTICS=DESCRIPTIVES"));
        }
        if ((object = ((DialogDataModel)object2).getBoolean("IDS_PARTIAL_ZERO_ORDER")) != null && ((Boolean)object).booleanValue()) {
            if (stringBuffer.indexOf("STATISTICS") > 0) {
                stringBuffer.append(" CORR ");
            } else {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/STATISTICS=CORR"));
            }
        }
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/MISSING="));
        object = ((DialogDataModel)object2).getBoolean("IDS_PARTIAL_LISTWISE");
        if (object == null || ((Boolean)object).booleanValue()) {
            stringBuffer.append("LISTWISE");
        } else {
            stringBuffer.append("ANALYSIS");
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        if (this.mIsBootstrapOK && dialogDataModel != null) {
            stringBuffer.append(BootstrapDlg.getRestoreSyntax((DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY)));
        }
        return stringBuffer.toString();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPaste();
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupLists();
        this.mTestofsignPanel = this.setupTestOfSignPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mTestofsignPanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mFlagsignCheck, gridBagConstraints, 0, 2, 1, 1, n, null);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    protected void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mVariableTargetVarList = new TargetVariableList();
        this.mVariableTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mVariableTargetVarList.setMaxLimitOfList(10000);
        this.mVariableTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mVariableTargetVarList.getFixedCellHeight() * 3 + 2));
        this.mVariableTargetScrollPane = new JScrollPane(this.mVariableTargetVarList);
        this.mVariableTargetScrollPane.setPreferredSize(this.mVariableTargetVarList.getMinimumSize());
        this.mVariableTargetVarList.setIdentifier(PAARTIAL_VARIABLE_LIST);
        this.mVariableTargetVarList.getModel().addListDataListener(this);
        this.mVariableTargetVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mControllingTargetVarList = new TargetVariableList();
        this.mControllingTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mControllingTargetVarList.setMaxLimitOfList(100);
        this.mControllingTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mControllingTargetVarList.getFixedCellHeight() * 3 + 2));
        this.mControllingTargetScrollPane = new JScrollPane(this.mControllingTargetVarList);
        this.mControllingTargetScrollPane.setPreferredSize(this.mControllingTargetVarList.getMinimumSize());
        this.mControllingTargetVarList.getModel().addListDataListener(this);
        this.mControllingTargetVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mVariablesArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mVariablesArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mVariablesArrowButton.registerVariableList(this.mVariableTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mControllingArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mControllingArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mControllingArrowButton.registerVariableList(this.mControllingTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mTestofsignPanel = new JPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, TWOTAILED_KEY);
        this.mTwoTailed = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, ONETAILED_KEY);
        this.mOneTailed = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, FLAGSIGNIFICANT_KEY);
        this.mFlagsignCheck = new JCheckBox(toggleButtonAction);
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(PARTIAL_OPTIONS_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PartialDlg.this.runOptionsSubDialog();
            }
        };
        this.addOptionsPanelButton(jPanel, new JButton(toggleButtonAction));
        this.mIsBootstrapOK = false;
        if (VersionInfo.allowBootstrapping()) {
            this.mIsBootstrapOK = true;
            toggleButtonAction = new ToggleButtonAction("IDS_COMMON_BOOTSTRAPPING_BUTTON"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PartialDlg.this.runBoostrapSubDialog();
                }
            };
            JButton jButton = new JButton(toggleButtonAction);
            this.addOptionsPanelButton(jPanel, jButton);
            if (BootstrapDlg.isCurrentDatasetInMIMode()) {
                jButton.setEnabled(false);
                this.mIsBootstrapOK = false;
            }
        }
        return jPanel;
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
        this.mVariableTargetVarList.getModel().removeAll();
        this.mControllingTargetVarList.getModel().removeAll();
        this.mTwoTailed.setSelected(true);
        this.mFlagsignCheck.setSelected(true);
    }

    private void runOptionsSubDialog() {
        this.runSubDialog(new PartialOptions(this));
    }

    private void runBoostrapSubDialog() {
        this.runSubDialog(new BootstrapDlg(this));
    }

    private void enableOkPaste() {
        boolean bl = false;
        if (this.mVariableTargetVarList.getModel().getSize() > 1 && this.mControllingTargetVarList.getModel().getSize() > 0) {
            bl = true;
        }
        super.enableOkPaste(bl);
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mVariablesArrowButton);
        vector.add(this.mControllingArrowButton);
        vector.add(this.mVariableTargetVarList);
        vector.add(this.mControllingTargetVarList);
        vector.add(this.mGroup);
        vector.add(this.mFlagsignCheck);
        int n2 = this.mOptionButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            if (!(this.mOptionButtonPanel.getComponent(n) instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private JPanel setupLists() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_PARTIAL_SOURCE_LIST_LABEL");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 3, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mVariablesArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_PARTIAL_VARIABLES");
        jLabel2.setLabelFor(this.mVariableTargetVarList);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, null);
        n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mVariableTargetScrollPane, gridBagConstraints, 2, 1, 1, 1, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mControllingArrowButton, gridBagConstraints, 1, 3, 1, 1, n, insets);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_PARTIAL_CONTROLLING");
        jLabel3.setLabelFor(this.mControllingTargetVarList);
        Insets insets2 = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 2, 2, 1, 1, n, insets2);
        n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mControllingTargetScrollPane, gridBagConstraints, 2, 3, 1, 1, n, null);
        return jPanel;
    }

    private JPanel setupTestOfSignPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mTwoTailed, this.mOneTailed};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.xaxis, this.getResString("IDS_TEST_SIGNIFICANCE"));
        this.mGroup = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }
}

