/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.correlate.distances;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.correlate.distances.DistancesDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DistancesSimilarity
extends BaseSubDialog
implements ItemListener,
DocumentListener {
    static final String STD_VALUE_KEY = "STD_KEY_SIMILARITY_DIS";
    static final String INTERVAL_VALUE_KEY = "INTERVAL_KEY_SIMILARITY_DIS";
    static final String BINARY_VALUE_KEY = "BINARY_KEY_SIMILARITY_DIS";
    static final String CASE_KEY = "IDS_BY_CASE";
    static final String VARIABLE_KEY = "IDS_BY_VARIABLE";
    static final String INTERVAL_KEY = "IDS_INTERVAL";
    static final String ABSOLUTE_KEY = "IDS_ABS_VALUES";
    static final String CHANGE_SIGN_KEY = "IDS_CHANGE_SIGN";
    static final String RESCALE_KEY = "IDS_RESCALE";
    static final String BINARY_KEY = "IDS_BINARY";
    static final String PRESNT_KEY = "IDS_PRESENT1_DIS";
    static final String ABSENT_KEY = "IDS_ABESNT_DIS";
    private static final String PRESENT_DEFAULT_VALUE = "1";
    private static final String ABSENT_DEFAULT_VALUE = "0";
    private JRadioButton mIntervalRadioButton;
    private JRadioButton mBinaryRadioButton;
    private JRadioButton mVariableRadioButton;
    private JRadioButton mCaseRadioButton;
    private JComboBox mIntervalComboBox;
    private JComboBox mBinaryComboBox;
    private JComboBox mStandarizeComboBox;
    private JLabel mPresentLabel;
    private JLabel mAbsentLabel;
    private JLabel mStandarizeLabel;
    private IntTextField mPresentTextField;
    private IntTextField mAbsentTextField;
    private JPanel mMeasurePanel;
    private JPanel mTransformValuesPanel;
    private JPanel mTransformMeasuresPanel;
    private String mMeasureLabelValue;
    private SpssButtonGroup mradioGroup;
    private SpssButtonGroup mradioGroupForMeasure;
    JLabel mIntervalMeasureLabel;
    JLabel mBinaryMeasureLabel;

    public DistancesSimilarity(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
        this.setLocationRelativeTo(this.getParent());
    }

    public static Map getIntervalMap() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(0, " CORRELATION");
        hashMap.put(1, " COSINE");
        return hashMap;
    }

    public static Map getStdMap() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(0, " NONE");
        hashMap.put(1, " Z");
        hashMap.put(2, " RANGE");
        hashMap.put(3, " RESCALE");
        hashMap.put(4, " MAX");
        hashMap.put(5, " MEAN");
        hashMap.put(6, " SD");
        return hashMap;
    }

    public static Map getBinMap() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(0, " RR");
        hashMap.put(1, " SM");
        hashMap.put(2, " JACCARD");
        hashMap.put(3, " DICE");
        hashMap.put(4, " RT");
        hashMap.put(5, " SS1");
        hashMap.put(6, " SS2");
        hashMap.put(7, " SS3");
        hashMap.put(8, " K1");
        hashMap.put(9, " K2");
        hashMap.put(10, " SS4");
        hashMap.put(11, " HAMANN");
        hashMap.put(12, " LAMBDA");
        hashMap.put(13, " D");
        hashMap.put(14, " Y");
        hashMap.put(15, " Q");
        hashMap.put(16, " OCHIAI");
        hashMap.put(17, " SS5");
        hashMap.put(18, " PHI");
        hashMap.put(19, " DISPER");
        return hashMap;
    }

    @Override
    public boolean continuePressed() {
        ((DistancesDlg)this.mParentDlg).setSimilarityMeasureLabel(this.mMeasureLabelValue);
        return true;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_prox_sim";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.mIntervalComboBox.setEnabled(this.mIntervalRadioButton.isSelected());
        this.mStandarizeComboBox.setEnabled(this.mIntervalRadioButton.isSelected());
        this.mBinaryComboBox.setEnabled(this.mBinaryRadioButton.isSelected());
        this.mPresentLabel.setEnabled(this.mBinaryRadioButton.isSelected());
        this.mAbsentLabel.setEnabled(this.mBinaryRadioButton.isSelected());
        this.mPresentTextField.setEnabled(this.mBinaryRadioButton.isSelected());
        this.mPresentTextField.setOpaque(this.mBinaryRadioButton.isSelected());
        this.mAbsentTextField.setEnabled(this.mBinaryRadioButton.isSelected());
        this.mAbsentTextField.setOpaque(this.mBinaryRadioButton.isSelected());
        this.mIntervalMeasureLabel.setEnabled(this.mIntervalRadioButton.isSelected());
        this.mBinaryMeasureLabel.setEnabled(this.mBinaryRadioButton.isSelected());
        this.mStandarizeLabel.setEnabled(this.mIntervalRadioButton.isSelected());
        if (this.mStandarizeComboBox.getSelectedItem().equals(this.getResString("IDS_NONE")) || this.mBinaryRadioButton.isSelected()) {
            this.mVariableRadioButton.setEnabled(false);
            this.mCaseRadioButton.setEnabled(false);
        } else {
            this.mVariableRadioButton.setEnabled(true);
            this.mCaseRadioButton.setEnabled(true);
        }
        if (this.mIntervalRadioButton.isSelected()) {
            this.mMeasureLabelValue = this.mIntervalComboBox.getSelectedItem().toString();
        }
        if (this.mBinaryRadioButton.isSelected()) {
            this.mMeasureLabelValue = this.mBinaryComboBox.getSelectedItem().toString();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setUpUI(jPanel);
        this.setDefaults();
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void setUpUI(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, n2, 0);
        this.setUpMeasurePanel();
        DialogUtil.addUsingGBL(jPanel, this.mMeasurePanel, gridBagConstraints, 0, 0, 2, 1, n, insets);
        this.setUpTransformValuesPanel();
        insets.set(0, 0, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mTransformValuesPanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.setUpTransformMeasuresPanel();
        insets.set(0, 0, n2, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTransformMeasuresPanel, gridBagConstraints, 1, 1, 1, 1, n, insets);
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mradioGroupForMeasure);
        vector.add(this.mIntervalComboBox);
        vector.add(this.mBinaryComboBox);
        vector.add(this.mPresentTextField);
        vector.add(this.mAbsentTextField);
        vector.add(this.mStandarizeComboBox);
        vector.add(this.mradioGroup);
        int n2 = this.mTransformMeasuresPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            vector.add(this.mTransformMeasuresPanel.getComponent(n));
        }
        n2 = this.mCmdButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setUpMeasurePanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(this.mMeasurePanel, this.mIntervalRadioButton, gridBagConstraints, 0, 0, 1, 1, n, null);
        Insets insets = new Insets(0, n2 + 40, 0, 0);
        DialogUtil.addUsingGBL(this.mMeasurePanel, this.mIntervalMeasureLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        n = 23;
        insets.set(0, n2, 0, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mMeasurePanel, this.mIntervalComboBox, gridBagConstraints, 1, 1, 4, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mMeasurePanel, this.mBinaryRadioButton, gridBagConstraints, 0, 2, 1, 1, n, null);
        insets.set(0, n2 + 40, 0, 0);
        DialogUtil.addUsingGBL(this.mMeasurePanel, this.mBinaryMeasureLabel, gridBagConstraints, 0, 3, 1, 1, n, insets);
        n = 23;
        insets.set(0, n2, 0, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mMeasurePanel, this.mBinaryComboBox, gridBagConstraints, 1, 3, 4, 1, n, insets);
        insets.set(n2, n2 + 30, n2, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.mMeasurePanel, this.mPresentLabel, gridBagConstraints, 1, 4, 1, 1, n, insets);
        insets.set(n2, n2, n2, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mMeasurePanel, (JComponent)this.mPresentTextField, gridBagConstraints, 2, 4, 1, 1, n, insets);
        insets.set(n2, n2 + 30, n2, 0);
        n = 24;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mMeasurePanel, this.mAbsentLabel, gridBagConstraints, 3, 4, 1, 1, n, insets);
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mMeasurePanel, (JComponent)this.mAbsentTextField, gridBagConstraints, 4, 4, 1, 1, n, insets);
    }

    private void setUpTransformMeasuresPanel() {
        JCheckBox jCheckBox = new JCheckBox(new ToggleButtonAction(this, ABSOLUTE_KEY));
        JCheckBox jCheckBox2 = new JCheckBox(new ToggleButtonAction(this, CHANGE_SIGN_KEY));
        JCheckBox jCheckBox3 = new JCheckBox(new ToggleButtonAction(this, RESCALE_KEY));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(this.mTransformMeasuresPanel, jCheckBox, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mTransformMeasuresPanel, jCheckBox2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.mTransformMeasuresPanel, jCheckBox3, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.createButtonGroup(this.mTransformMeasuresPanel);
    }

    private void setUpTransformValuesPanel() {
        this.mradioGroup.add(this.mVariableRadioButton);
        this.mradioGroup.add(this.mCaseRadioButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 10;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(this.mTransformValuesPanel, this.mStandarizeLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets = new Insets(0, 0, 0, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mTransformValuesPanel, this.mStandarizeComboBox, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets = DialogUtil.getStandardControlInsets();
        n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mTransformValuesPanel, this.mVariableRadioButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.mTransformValuesPanel, this.mCaseRadioButton, gridBagConstraints, 1, 2, 1, 1, n, insets);
    }

    private void updateContinueButton() {
        this.enableContinue(this.mPresentTextField.getText().length() > 0 && this.mAbsentTextField.getText().length() > 0);
    }

    private void setDefaults() {
        this.mIntervalRadioButton.setSelected(true);
        this.mBinaryComboBox.setEnabled(false);
        this.mPresentLabel.setEnabled(false);
        this.mAbsentLabel.setEnabled(false);
        this.mPresentTextField.setEnabled(false);
        this.mPresentTextField.setOpaque(false);
        this.mAbsentTextField.setEnabled(false);
        this.mAbsentTextField.setOpaque(false);
        this.mVariableRadioButton.setEnabled(false);
        this.mCaseRadioButton.setEnabled(false);
        this.mPresentTextField.setText(PRESENT_DEFAULT_VALUE);
        this.mAbsentTextField.setText(ABSENT_DEFAULT_VALUE);
    }

    private void initVars() {
        this.mIntervalRadioButton = new JRadioButton(new ToggleButtonAction(this, INTERVAL_KEY));
        this.mBinaryRadioButton = new JRadioButton(new ToggleButtonAction(this, BINARY_KEY));
        this.mVariableRadioButton = new JRadioButton(new ToggleButtonAction(this, VARIABLE_KEY));
        this.mCaseRadioButton = new JRadioButton(new ToggleButtonAction(this, CASE_KEY));
        String[] stringArray = this.getResStringArray("IDS_INTERVAL_COMBO_VALUES");
        this.mIntervalComboBox = new JComboBox<String>(stringArray);
        stringArray = this.getResStringArray("IDS_BINARY_COMBO_VALUES");
        this.mBinaryComboBox = new JComboBox<String>(stringArray);
        stringArray = this.getResStringArray("IDS_STANDARDIZE_COMBO_VALUES");
        this.mStandarizeComboBox = new JComboBox<String>(stringArray);
        this.mradioGroupForMeasure = new SpssButtonGroup();
        this.mPresentLabel = DialogUtil.createLabel(this, "IDS_PRESENT");
        this.mAbsentLabel = DialogUtil.createLabel(this, "IDS_ABESNT");
        this.mStandarizeLabel = DialogUtil.createLabel(this, "IDS_STANDARADIZE");
        this.mVariableRadioButton.setSelected(true);
        this.mPresentTextField = new IntTextField(-99, 999, false);
        this.mAbsentTextField = new IntTextField(-99, 999, false);
        this.mPresentTextField.setSize(3, 1);
        this.mAbsentTextField.setSize(3, 1);
        this.mradioGroupForMeasure.add(this.mIntervalRadioButton);
        this.mradioGroupForMeasure.add(this.mBinaryRadioButton);
        this.mMeasurePanel = new JPanel(new GridBagLayout());
        this.mMeasurePanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_MEASURE")));
        this.mTransformValuesPanel = new JPanel(new GridBagLayout());
        this.mTransformValuesPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_TVALUES")));
        this.mTransformMeasuresPanel = new JPanel(new GridBagLayout());
        this.mTransformMeasuresPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_TMEASURE")));
        this.mradioGroup = new SpssButtonGroup();
        this.mIntervalRadioButton.addItemListener(this);
        this.mBinaryRadioButton.addItemListener(this);
        this.mStandarizeComboBox.addItemListener(this);
        this.mIntervalComboBox.addItemListener(this);
        this.mBinaryComboBox.addItemListener(this);
        this.mStandarizeComboBox.setAction(new ComboboxAction(this.mParentDlg, STD_VALUE_KEY));
        this.mIntervalComboBox.setAction(new ComboboxAction(this.mParentDlg, INTERVAL_VALUE_KEY));
        this.mBinaryComboBox.setAction(new ComboboxAction(this.mParentDlg, BINARY_VALUE_KEY));
        this.mPresentLabel.setLabelFor((Component)this.mPresentTextField);
        this.mAbsentLabel.setLabelFor((Component)this.mAbsentTextField);
        this.mStandarizeLabel.setLabelFor(this.mStandarizeComboBox);
        this.mIntervalMeasureLabel = DialogUtil.createLabel(this, "IDS_MEASURE_DISS_DOT");
        this.mBinaryMeasureLabel = DialogUtil.createLabel(this, "IDS_MEASURE_DISS_DOT");
        this.mIntervalMeasureLabel.setLabelFor(this.mIntervalComboBox);
        this.mBinaryMeasureLabel.setLabelFor(this.mBinaryComboBox);
        this.mPresentTextField.setAction((Action)new TextFieldAction(this.mParentDlg, PRESNT_KEY));
        this.mAbsentTextField.setAction((Action)new TextFieldAction(this.mParentDlg, ABSENT_KEY));
        this.mPresentTextField.getDocument().addDocumentListener(this);
        this.mAbsentTextField.getDocument().addDocumentListener(this);
        this.mBinaryComboBox.setMaximumRowCount(20);
    }
}

