/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.correlate.distances;

import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.correlate.distances.DistancesDissimilarity;
import com.spss.java_client.ui.dialogs.base.analyze.correlate.distances.DistancesSimilarity;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DistancesDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener,
ActionListener {
    public static final String TARGET_LIST_KEY = "IDS_DIS_TARGET_VAR_KEY";
    public static final String TARGET_CASE_LIST_KEY = "IDS_DIS_CASE_TARGET_VAR_KEY";
    public static final String MEASURE_LABEL_KEY = "IDS_DIS_MEASURE_LABEL_KEY12";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetVarList;
    private JScrollPane mSrcScrollPane;
    private JScrollPane mTargetScrollPane;
    private JScrollPane mTargetCaseScrollPane;
    private ArrowButton mArrowButton;
    private ArrowButton mArrowButtonForCase;
    private JRadioButton mCasesRadioButton;
    private JRadioButton mVariablesRadioButton;
    private JRadioButton mDissimilaritiesRadioButton;
    private JRadioButton mSimilaritiesRadioButton;
    private JLabel mMeasuresLabel;
    private TargetVariableList mTargetCaseVariableList;
    private JButton mMeasureButton;
    private JLabel mItemCaseLabel;
    private boolean flag = false;
    private String mSimilarityValue;
    private String mDisimilarityValue;
    private SpssButtonGroup mCompbuttongroup;
    private SpssButtonGroup mMeabuttongroup;

    public DistancesDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle.getDefaultResourceBundleName(), AnalyzeResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_DISTANCES"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_prox";
    }

    @Override
    public String generateSyntax() {
        Object object;
        String string;
        Map map;
        int n;
        Boolean bl;
        Boolean bl2;
        Boolean bl3;
        Boolean bl4;
        Boolean bl5;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("PROXIMITIES"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters(this.mTargetVarList.getVariablesStringList()));
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        stringBuffer.append("\n");
        Boolean bl6 = dialogDataModel.getBoolean("IDS_BETWEEN_CASES");
        if (bl6 != null && bl6.booleanValue() && this.mTargetCaseVariableList.getVariablesStringList().length() != 0) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/ID="));
            stringBuffer.append(this.mTargetCaseVariableList.getVariablesStringList());
            stringBuffer.append("\n");
        }
        stringBuffer.append(SyntaxUtil.getSubCommand("/VIEW="));
        bl6 = dialogDataModel.getBoolean("IDS_BETWEEN_CASES");
        if (bl6 != null && bl6.booleanValue()) {
            stringBuffer.append("CASE");
        }
        if ((bl6 = dialogDataModel.getBoolean("IDS_BETWEEN_VARIABLE")) != null && bl6.booleanValue()) {
            stringBuffer.append("VARIABLE");
        }
        if ((bl6 = dialogDataModel.getBoolean("IDS_SIMILARTIES")) != null && bl6.booleanValue()) {
            bl5 = dialogDataModel.getBoolean("IDS_INTERVAL");
            bl4 = dialogDataModel.getBoolean("IDS_ABS_VALUES");
            bl3 = dialogDataModel.getBoolean("IDS_CHANGE_SIGN");
            bl2 = dialogDataModel.getBoolean("IDS_RESCALE");
            bl = dialogDataModel.getBoolean("IDS_BINARY");
            if (bl5 != null && bl5 != false || bl4 != null && bl4 != false || bl3 != null && bl3 != false || bl2 != null && bl2 != false || bl != null && bl.booleanValue()) {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/MEASURE="));
                if (bl4 != null && bl4.booleanValue()) {
                    stringBuffer.append("ABSOLUTE ");
                }
                if (bl3 != null && bl3.booleanValue()) {
                    stringBuffer.append("REVERSE ");
                }
                if (bl2 != null && bl2.booleanValue()) {
                    stringBuffer.append("RESCALE ");
                }
                if (bl5 != null && bl5.booleanValue()) {
                    n = dialogDataModel.getInteger("INTERVAL_KEY_SIMILARITY_DIS");
                    map = DistancesSimilarity.getIntervalMap();
                    string = map.get(n).toString().trim();
                    stringBuffer.append(string);
                }
                if (bl != null && bl.booleanValue()) {
                    n = dialogDataModel.getInteger("BINARY_KEY_SIMILARITY_DIS");
                    map = DistancesSimilarity.getBinMap();
                    string = map.get(n).toString().trim();
                    stringBuffer.append(string);
                    stringBuffer.append(" (");
                    string = dialogDataModel.getString("IDS_PRESENT1_DIS");
                    stringBuffer.append(string);
                    stringBuffer.append(",");
                    string = dialogDataModel.getString("IDS_ABESNT_DIS");
                    stringBuffer.append(string);
                    stringBuffer.append(")");
                }
            } else {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/MEASURE=CORRELATION"));
            }
            bl6 = dialogDataModel.getBoolean("IDS_INTERVAL");
            object = "";
            if (bl6 != null && bl6.booleanValue()) {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/STANDARDIZE="));
                bl6 = dialogDataModel.getBoolean("IDS_BY_CASE");
                if (bl6 != null && bl6.booleanValue()) {
                    object = "CASE";
                }
                if ((bl6 = dialogDataModel.getBoolean("IDS_BY_VARIABLE")) != null && bl6.booleanValue()) {
                    object = "VARIABLE";
                }
                n = dialogDataModel.getInteger("STD_KEY_SIMILARITY_DIS");
                map = DistancesSimilarity.getStdMap();
                string = map.get(n).toString();
                if (!string.trim().equals("NONE")) {
                    stringBuffer.append((String)object + string);
                } else {
                    stringBuffer.append(string);
                }
            } else if (bl == null || !bl.booleanValue()) {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/STANDARDIZE=NONE"));
            }
        }
        if ((bl6 = dialogDataModel.getBoolean("IDS_DISSIMILARITIES")) != null && bl6.booleanValue()) {
            bl5 = dialogDataModel.getBoolean("IDS_DISS_INTERVAL");
            bl4 = dialogDataModel.getBoolean("IDS_DISS_ABS_VALUES");
            bl3 = dialogDataModel.getBoolean("IDS_DISS_CHANGE_SIGN");
            bl2 = dialogDataModel.getBoolean("IDS_DISS_RESCALE");
            bl = dialogDataModel.getBoolean("IDS_DISS_BINARY");
            object = dialogDataModel.getBoolean("IDS_COUNTS");
            if (bl5 != null && bl5 != false || bl4 != null && bl4 != false || bl3 != null && bl3 != false || bl2 != null && bl2 != false || bl != null && bl != false || object != null && ((Boolean)object).booleanValue()) {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/MEASURE="));
                if (bl4 != null && bl4.booleanValue()) {
                    stringBuffer.append("ABSOLUTE ");
                }
                if (bl3 != null && bl3.booleanValue()) {
                    stringBuffer.append("REVERSE ");
                }
                if (bl2 != null && bl2.booleanValue()) {
                    stringBuffer.append("RESCALE ");
                }
                if (bl5 != null && bl5.booleanValue()) {
                    n = dialogDataModel.getInteger("INTERVAL_KEY_SIMILARITY");
                    map = DistancesDissimilarity.getIntervalMap();
                    string = map.get(n).toString().trim();
                    stringBuffer.append(string);
                    int n2 = dialogDataModel.getInteger("POWER_KEY");
                    int n3 = dialogDataModel.getInteger("ROOT_KEY");
                    if (n == 5) {
                        stringBuffer.append("(");
                        stringBuffer.append(n2 + 1);
                        stringBuffer.append(",");
                        stringBuffer.append(n3 + 1);
                        stringBuffer.append(")");
                    }
                    if (n == 4) {
                        stringBuffer.append("(");
                        stringBuffer.append(n2 + 1);
                        stringBuffer.append(")");
                    }
                }
                if (object != null && ((Boolean)object).booleanValue()) {
                    n = dialogDataModel.getInteger("COUNT_KEY");
                    map = DistancesDissimilarity.getCountMap();
                    string = map.get(n).toString().trim();
                    stringBuffer.append(string);
                }
                if (bl != null && bl.booleanValue()) {
                    n = dialogDataModel.getInteger("BINARY_KEY_SIMILARITY");
                    map = DistancesDissimilarity.getBinMap();
                    string = map.get(n).toString().trim();
                    stringBuffer.append(string);
                    stringBuffer.append(" (");
                    string = dialogDataModel.getString("IDS_PRESENT1661");
                    stringBuffer.append(string);
                    stringBuffer.append(",");
                    string = dialogDataModel.getString("IDS_ABESNT2266");
                    stringBuffer.append(string);
                    stringBuffer.append(")");
                }
            } else {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/MEASURE=EUCLID"));
            }
            if (bl5 != null && bl5.booleanValue() || object != null && ((Boolean)object).booleanValue()) {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/STANDARDIZE="));
                bl6 = dialogDataModel.getBoolean("IDS_DISS_BY_CASE");
                String string2 = "";
                if (bl6 != null && bl6.booleanValue()) {
                    string2 = "CASE";
                }
                if ((bl6 = dialogDataModel.getBoolean("IDS_DISS_BY_VARIABLE")) != null && bl6.booleanValue()) {
                    string2 = "VARIABLE";
                }
                n = dialogDataModel.getInteger("STD_KEY_SIMILARITY1233");
                map = DistancesDissimilarity.getStdMap();
                string = map.get(n).toString();
                if (!string.trim().equals("NONE")) {
                    stringBuffer.append(string2 + string);
                } else {
                    stringBuffer.append(string);
                }
            } else if (bl == null || !bl.booleanValue()) {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/STANDARDIZE=NONE"));
            }
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getIActionKey() {
        return "analyze_correlate_distances";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updateOkPasteButton();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updateOkPasteButton();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updateOkPasteButton();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.mCasesRadioButton.isSelected()) {
            this.setEnabledComponents(true);
            this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0);
            this.flag = false;
        }
        if (this.mVariablesRadioButton.isSelected()) {
            this.mArrowButtonForCase.setEnabled(false);
            this.setEnabledComponents(false);
            this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 1);
            this.flag = true;
        }
        if (this.mDissimilaritiesRadioButton.isSelected()) {
            if (this.mDisimilarityValue == null) {
                this.mMeasuresLabel.setText(this.getResString("IDS_EUCLIDEAN_DIS"));
            } else {
                this.mMeasuresLabel.setText(this.mDisimilarityValue);
            }
        }
        if (this.mSimilaritiesRadioButton.isSelected()) {
            if (this.mSimilarityValue == null) {
                this.mMeasuresLabel.setText(this.getResString("IDS_PEARSON_CORRR"));
            } else {
                this.mMeasuresLabel.setText(this.mSimilarityValue);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.mMeasureButton) && this.mSimilaritiesRadioButton.isSelected()) {
            this.runSubDialog(new DistancesSimilarity(this, this.getResString("IDS_DISTANCE_SIMILARITY"), true));
        } else {
            this.runSubDialog(new DistancesDissimilarity(this, this.getResString("IDS_DISTANCE_DISSIMILARTY"), true));
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.mTargetVarList.removeAll();
        this.mTargetCaseVariableList.removeAll();
        this.setDefaults();
    }

    public void setDissimilarityMeasureLabel(String string) {
        this.mMeasuresLabel.setText(string);
        this.mDisimilarityValue = string;
    }

    public void setSimilarityMeasureLabel(String string) {
        this.mMeasuresLabel.setText(string);
        this.mSimilarityValue = string;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupComponents(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    private void updateOkPasteButton() {
        if (this.flag) {
            this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 1);
        } else {
            this.enableOkPaste(this.mTargetVarList.getModel().getSize() > 0);
        }
    }

    private void setupComponents(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_VARIABLES");
        jLabel.setLabelFor(this.mTargetVarList);
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_CORRELATE_DISTANCES_SOURCE_LABEL");
        jLabel2.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 5, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        Insets insets2 = new Insets(0, 0, n2, 0);
        DialogUtil.addUsingGBL(jPanel, this.mTargetScrollPane, gridBagConstraints, 2, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 20;
        insets = new Insets(0, DialogUtil.getArrowButtonInsets().left, 0, DialogUtil.getArrowButtonInsets().right);
        DialogUtil.addUsingGBL(jPanel, this.mArrowButtonForCase, gridBagConstraints, 1, 2, 1, 2, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mItemCaseLabel, gridBagConstraints, 2, 2, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, this.mTargetCaseScrollPane, gridBagConstraints, 2, 3, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        insets2 = new Insets(n2, DialogUtil.getArrowButtonInsets().left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setUpComputeDistanesPanel(), gridBagConstraints, 1, 4, 2, 1, n, insets2);
        insets2 = new Insets(n2, DialogUtil.getArrowButtonInsets().left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setUpMeasuresPanel(), gridBagConstraints, 1, 5, 2, 1, n, insets2);
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetVarList);
        vector.add(this.mArrowButtonForCase);
        vector.add(this.mTargetCaseVariableList);
        vector.add(this.mCompbuttongroup);
        vector.add(this.mMeabuttongroup);
        vector.add(this.mMeasureButton);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private JPanel setUpComputeDistanesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_COMPUTE_DISTANCE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.mCompbuttongroup.add(this.mCasesRadioButton);
        this.mCompbuttongroup.add(this.mVariablesRadioButton);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mCasesRadioButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mVariablesRadioButton, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setUpMeasuresPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_MEASURE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.mMeabuttongroup.add(this.mDissimilaritiesRadioButton);
        this.mMeabuttongroup.add(this.mSimilaritiesRadioButton);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mDissimilaritiesRadioButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mSimilaritiesRadioButton, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setUpSubMeasuresPanel(), gridBagConstraints, 0, 1, 2, 1, n, null);
        return jPanel;
    }

    private JPanel setUpSubMeasuresPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mMeasureButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        insets = new Insets(DialogUtil.getComponentGroupGap() - 4, 3, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mMeasuresLabel, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void setDefaults() {
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.mCasesRadioButton.setSelected(true);
        this.mDissimilaritiesRadioButton.setSelected(true);
        this.enableOkPaste(false);
        this.mSimilarityValue = this.getResString("IDS_PEARSON_CORRR");
        this.mDisimilarityValue = this.getResString("IDS_EUCLIDEAN_DIS");
        this.mMeasuresLabel.setText(this.getResString("IDS_EUCLIDEAN_DIS"));
    }

    private void setEnabledComponents(boolean bl) {
        this.mItemCaseLabel.setEnabled(bl);
        this.mTargetCaseVariableList.setEnabled(bl);
        this.mTargetCaseVariableList.setOpaque(bl);
        this.mArrowButtonForCase.setEnabled(bl);
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.normal);
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mTargetVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mItemCaseLabel = DialogUtil.createLabel(this, "IDS_CASES");
        this.mTargetScrollPane = new JScrollPane(this.mTargetVarList);
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 5 + 2));
        this.mTargetScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mTargetCaseVariableList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mTargetCaseVariableList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetCaseVariableList.getModel().addListDataListener(this);
        this.mItemCaseLabel.setLabelFor(this.mTargetCaseVariableList);
        this.mTargetCaseScrollPane = new JScrollPane(this.mTargetCaseVariableList);
        this.mTargetCaseScrollPane.setPreferredSize(this.mTargetCaseVariableList.getMinimumSize());
        this.mTargetCaseScrollPane.setHorizontalScrollBarPolicy(31);
        this.mTargetCaseScrollPane.setVerticalScrollBarPolicy(21);
        this.mArrowButtonForCase = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButtonForCase.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButtonForCase.registerVariableList(this.mTargetCaseVariableList, SpssArrowButton.ButtonOrientation.left);
        this.mCasesRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_BETWEEN_CASES"));
        this.mVariablesRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_BETWEEN_VARIABLE"));
        this.mCasesRadioButton.addItemListener(this);
        this.mVariablesRadioButton.addItemListener(this);
        this.mSimilaritiesRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_SIMILARTIES"));
        this.mDissimilaritiesRadioButton = new JRadioButton(new ToggleButtonAction(this, "IDS_DISSIMILARITIES"));
        this.mDissimilaritiesRadioButton.addItemListener(this);
        this.mSimilaritiesRadioButton.addItemListener(this);
        this.mMeasuresLabel = new JLabel(this.getResString("IDS_EUCLIDEAN_DIS"));
        this.mMeasuresLabel.setBorder(BorderFactory.createEmptyBorder());
        this.mMeasuresLabel.setOpaque(false);
        this.mMeasuresLabel.setPreferredSize(this.mMeasuresLabel.getMinimumSize());
        this.mMeasureButton = new JButton(new ToggleButtonAction(this, "IDS_MEASURES_DOT"));
        this.mMeasureButton.addActionListener(this);
        this.mTargetCaseVariableList.addVarFilter(new SpssVarFilter(8, false, false));
        this.mCompbuttongroup = new SpssButtonGroup();
        this.mMeabuttongroup = new SpssButtonGroup();
        this.mTargetVarList.setIdentifier(TARGET_LIST_KEY);
        this.mTargetCaseVariableList.setIdentifier(TARGET_CASE_LIST_KEY);
    }
}

