/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.correlate.distances;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.correlate.distances.DistancesDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DistancesDissimilarity
extends BaseSubDialog
implements ItemListener,
DocumentListener {
    static final String STD_VALUE_KEY = "STD_KEY_SIMILARITY1233";
    static final String INTERVAL_VALUE_KEY = "INTERVAL_KEY_SIMILARITY";
    static final String BINARY_VALUE_KEY = "BINARY_KEY_SIMILARITY";
    static final String CASE_KEY = "IDS_DISS_BY_CASE";
    static final String VARIABLE_KEY = "IDS_DISS_BY_VARIABLE";
    static final String INTERVAL_KEY = "IDS_DISS_INTERVAL";
    static final String ABSOLUTE_KEY = "IDS_DISS_ABS_VALUES";
    static final String CHANGE_SIGN_KEY = "IDS_DISS_CHANGE_SIGN";
    static final String RESCALE_KEY = "IDS_DISS_RESCALE";
    static final String BINARY_KEY = "IDS_DISS_BINARY";
    static final String PRESNT_KEY = "IDS_PRESENT1661";
    static final String ABSENT_KEY = "IDS_ABESNT2266";
    static final String COUNT_KEY = "IDS_COUNTS";
    static final String COUNT_VALUE_KEY = "COUNT_KEY";
    static final String ROOT_VALUE_KEY = "ROOT_KEY";
    static final String POWER_VALUE_KEY = "POWER_KEY";
    private static final String PRESENT_DEFAULT_VALUE = "1";
    private static final String ABSENT_DEFAULT_VALUE = "0";
    private JRadioButton mIntervalRadioButton;
    private JRadioButton mBinaryRadioButton;
    private JRadioButton mCountsRadioButton;
    private JRadioButton mVariableRadioButton;
    private JRadioButton mCaseRadioButton;
    private JComboBox mIntervalComboBox;
    private JComboBox mBinaryComboBox;
    private JComboBox mStandarizeComboBox;
    private JComboBox mCountsComboBox;
    private JComboBox mPowerComboBox;
    private JComboBox mRootComboBox;
    private JLabel mPresentLabel;
    private JLabel mAbsentLabel;
    private JLabel mStandarizeLabel;
    private JLabel mPowerLabel;
    private JLabel mRootLabel;
    private IntTextField mPresentTextField;
    private IntTextField mAbsentTextField;
    private JPanel mMeasurePanel;
    private JPanel mTransformValuesPanel;
    private JPanel mTransformMeasuresPanel;
    private String mMeasureLabelValue;
    private SpssButtonGroup mradioGroup;
    private SpssButtonGroup mradioGroupForMeasure;
    JLabel mIntervalMeasureLabel;
    JLabel mCountMeasureLabel;
    JLabel mBinaryMeasureLabel;

    public static Map getIntervalMap() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(0, " EUCLID");
        hashMap.put(1, " SEUCLID");
        hashMap.put(2, " CHEBYCHEV");
        hashMap.put(3, " BLOCK");
        hashMap.put(4, " MINKOWSKI");
        hashMap.put(5, " POWER");
        return hashMap;
    }

    public static Map getStdMap() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(0, " NONE");
        hashMap.put(1, " Z");
        hashMap.put(2, " RANGE");
        hashMap.put(3, " RESCALE");
        hashMap.put(4, " MAX");
        hashMap.put(5, " MEAN");
        hashMap.put(6, " SD");
        return hashMap;
    }

    public static Map getCountMap() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(0, " CHISQ");
        hashMap.put(1, " PH2");
        return hashMap;
    }

    public static Map getBinMap() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(0, " BEUCLID");
        hashMap.put(1, " BSEUCLID");
        hashMap.put(2, " SIZE");
        hashMap.put(3, " PATTERN");
        hashMap.put(4, " VARIANCE");
        hashMap.put(5, " BSHAPE");
        hashMap.put(6, " BLWMN");
        return hashMap;
    }

    public DistancesDissimilarity(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_prox_dis";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.mIntervalComboBox.setEnabled(this.mIntervalRadioButton.isSelected());
        this.mBinaryComboBox.setEnabled(this.mBinaryRadioButton.isSelected());
        this.mPresentLabel.setEnabled(this.mBinaryRadioButton.isSelected());
        this.mAbsentLabel.setEnabled(this.mBinaryRadioButton.isSelected());
        this.mPresentTextField.setEnabled(this.mBinaryRadioButton.isSelected());
        this.mPresentTextField.setOpaque(this.mBinaryRadioButton.isSelected());
        this.mAbsentTextField.setEnabled(this.mBinaryRadioButton.isSelected());
        this.mAbsentTextField.setOpaque(this.mBinaryRadioButton.isSelected());
        this.mCountsComboBox.setEnabled(this.mCountsRadioButton.isSelected());
        this.mIntervalMeasureLabel.setEnabled(this.mIntervalRadioButton.isSelected());
        this.mBinaryMeasureLabel.setEnabled(this.mBinaryRadioButton.isSelected());
        this.mCountMeasureLabel.setEnabled(this.mCountsRadioButton.isSelected());
        if (this.mStandarizeComboBox.getSelectedItem().equals(this.getResString("IDS_NONE")) || this.mBinaryRadioButton.isSelected()) {
            this.mVariableRadioButton.setEnabled(false);
            this.mCaseRadioButton.setEnabled(false);
        } else {
            this.mVariableRadioButton.setEnabled(true);
            this.mCaseRadioButton.setEnabled(true);
        }
        this.mStandarizeComboBox.setEnabled(this.mCountsRadioButton.isSelected() || this.mIntervalRadioButton.isSelected());
        this.mStandarizeLabel.setEnabled(this.mCountsRadioButton.isSelected() || this.mIntervalRadioButton.isSelected());
        int n = 5;
        if (this.mIntervalComboBox.getSelectedItem().equals(this.getResString("IDS_MINKOWSKI"))) {
            n = 0;
        }
        if (this.mIntervalComboBox.getSelectedItem().equals(this.getResString("IDS_CUSTOMIZED"))) {
            n = 1;
        }
        switch (n) {
            case 0: {
                this.mPowerComboBox.setEnabled(true);
                this.mPowerLabel.setEnabled(true);
                this.mRootComboBox.setEnabled(false);
                this.mRootLabel.setEnabled(false);
                break;
            }
            case 1: {
                this.mRootComboBox.setEnabled(true);
                this.mPowerComboBox.setEnabled(true);
                this.mPowerLabel.setEnabled(true);
                this.mRootLabel.setEnabled(true);
                break;
            }
            default: {
                this.mRootComboBox.setEnabled(false);
                this.mPowerComboBox.setEnabled(false);
                this.mPowerLabel.setEnabled(false);
                this.mRootLabel.setEnabled(false);
            }
        }
        if (this.mIntervalRadioButton.isSelected()) {
            this.mMeasureLabelValue = this.mIntervalComboBox.getSelectedItem().toString();
        }
        if (this.mBinaryRadioButton.isSelected()) {
            this.mMeasureLabelValue = this.mBinaryComboBox.getSelectedItem().toString();
            if (this.mMeasureLabelValue.equals(this.getResString("IDS_DISS_EULI_DIS"))) {
                this.mMeasureLabelValue = this.getResString("IDS_DISS_BIN_EUCLIDEAN");
            }
            if (this.mMeasureLabelValue.equals(this.getResString("IDS_DISS_SQR_EULI_DIS"))) {
                this.mMeasureLabelValue = this.getResString("IDS_DISS_SQUARED_DIS");
            }
        }
        if (this.mCountsRadioButton.isSelected()) {
            this.mMeasureLabelValue = this.mCountsComboBox.getSelectedItem().toString();
        }
        if (this.mBinaryRadioButton.isSelected() || this.mCountsRadioButton.isSelected()) {
            this.mRootComboBox.setEnabled(false);
            this.mPowerComboBox.setEnabled(false);
            this.mPowerLabel.setEnabled(false);
            this.mRootLabel.setEnabled(false);
        }
        this.updateContinueButton();
    }

    @Override
    public boolean continuePressed() {
        ((DistancesDlg)this.mParentDlg).setDissimilarityMeasureLabel(this.mMeasureLabelValue);
        return true;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton();
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        this.setUpUI(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mradioGroupForMeasure);
        vector.add(this.mIntervalComboBox);
        vector.add(this.mBinaryComboBox);
        vector.add(this.mCountsComboBox);
        vector.add(this.mPresentTextField);
        vector.add(this.mAbsentTextField);
        vector.add(this.mStandarizeComboBox);
        vector.add(this.mradioGroup);
        int n2 = this.mTransformMeasuresPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            vector.add(this.mTransformMeasuresPanel.getComponent(n));
        }
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setUpUI(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        Insets insets = new Insets(0, 0, DialogUtil.getComponentGroupGap(), 0);
        this.setUpMeasurePanel();
        DialogUtil.addUsingGBL(jPanel, this.mMeasurePanel, gridBagConstraints, 0, 0, 2, 1, n, insets);
        this.setUpTransformValuesPanel();
        insets.set(0, 0, DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, this.mTransformValuesPanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.setUpTransformMeasuresPanel();
        insets.set(0, 0, DialogUtil.getComponentGroupGap(), 0);
        DialogUtil.addUsingGBL(jPanel, this.mTransformMeasuresPanel, gridBagConstraints, 1, 1, 1, 1, n, insets);
    }

    private void setUpMeasurePanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(this.mMeasurePanel, this.mIntervalRadioButton, gridBagConstraints, 0, 0, 1, 1, n, null);
        Insets insets = new Insets(0, n2 + 40, 0, 0);
        DialogUtil.addUsingGBL(this.mMeasurePanel, this.mIntervalMeasureLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        n = 23;
        insets.set(0, n2, 0, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mMeasurePanel, this.mIntervalComboBox, gridBagConstraints, 1, 1, 4, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2 + 40, 0, 0);
        DialogUtil.addUsingGBL(this.mMeasurePanel, this.mPowerLabel, gridBagConstraints, 1, 2, 1, 1, n, insets);
        insets.set(n2, n2, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mMeasurePanel, this.mPowerComboBox, gridBagConstraints, 2, 2, 1, 1, n, insets);
        insets.set(n2, n2 + 70, 0, 0);
        n = 24;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mMeasurePanel, this.mRootLabel, gridBagConstraints, 3, 2, 1, 1, n, insets);
        insets.set(n2, n2, 0, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mMeasurePanel, this.mRootComboBox, gridBagConstraints, 4, 2, 1, 1, n, insets);
        n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mMeasurePanel, this.mCountsRadioButton, gridBagConstraints, 0, 3, 1, 1, n, null);
        insets.set(0, n2 + 40, 0, 0);
        DialogUtil.addUsingGBL(this.mMeasurePanel, this.mCountMeasureLabel, gridBagConstraints, 0, 4, 1, 1, n, insets);
        insets.set(0, n2, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mMeasurePanel, this.mCountsComboBox, gridBagConstraints, 1, 4, 4, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mMeasurePanel, this.mBinaryRadioButton, gridBagConstraints, 0, 5, 1, 1, n, null);
        insets.set(0, n2 + 40, 0, 0);
        DialogUtil.addUsingGBL(this.mMeasurePanel, this.mBinaryMeasureLabel, gridBagConstraints, 0, 6, 1, 1, n, insets);
        n = 23;
        insets.set(0, n2, 0, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mMeasurePanel, this.mBinaryComboBox, gridBagConstraints, 1, 6, 4, 1, n, insets);
        insets.set(n2, n2 + 35, 0, 0);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mMeasurePanel, this.mPresentLabel, gridBagConstraints, 1, 7, 1, 1, n, insets);
        insets.set(n2, n2, n2, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mMeasurePanel, (JComponent)this.mPresentTextField, gridBagConstraints, 2, 7, 1, 1, n, insets);
        n = 24;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2 + 30, n2, 0);
        DialogUtil.addUsingGBL(this.mMeasurePanel, this.mAbsentLabel, gridBagConstraints, 3, 7, 1, 1, n, insets);
        insets.set(n2, n2, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mMeasurePanel, (JComponent)this.mAbsentTextField, gridBagConstraints, 4, 7, 1, 1, n, insets);
    }

    private JPanel setUpTransformMeasuresPanel() {
        JCheckBox jCheckBox = new JCheckBox(new ToggleButtonAction(this, ABSOLUTE_KEY));
        JCheckBox jCheckBox2 = new JCheckBox(new ToggleButtonAction(this, CHANGE_SIGN_KEY));
        JCheckBox jCheckBox3 = new JCheckBox(new ToggleButtonAction(this, RESCALE_KEY));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(this.mTransformMeasuresPanel, jCheckBox, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mTransformMeasuresPanel, jCheckBox2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.mTransformMeasuresPanel, jCheckBox3, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.createButtonGroup(this.mTransformMeasuresPanel);
        return this.mMeasurePanel;
    }

    private JPanel setUpTransformValuesPanel() {
        this.mradioGroup.add(this.mVariableRadioButton);
        this.mradioGroup.add(this.mCaseRadioButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 10;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(this.mTransformValuesPanel, this.mStandarizeLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets = new Insets(0, 0, 0, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mTransformValuesPanel, this.mStandarizeComboBox, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets = DialogUtil.getStandardControlInsets();
        n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mTransformValuesPanel, this.mVariableRadioButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.mTransformValuesPanel, this.mCaseRadioButton, gridBagConstraints, 1, 2, 1, 1, n, insets);
        return this.mMeasurePanel;
    }

    private void updateContinueButton() {
        if (this.mBinaryRadioButton.isSelected()) {
            this.enableContinue(this.mPresentTextField.getText().length() > 0 && this.mAbsentTextField.getText().length() > 0);
        } else {
            this.enableContinue(true);
        }
    }

    private void setDefaults() {
        this.mIntervalRadioButton.setSelected(true);
        this.mBinaryComboBox.setEnabled(false);
        this.mPresentLabel.setEnabled(false);
        this.mAbsentLabel.setEnabled(false);
        this.mPresentTextField.setEnabled(false);
        this.mPresentTextField.setOpaque(false);
        this.mAbsentTextField.setEnabled(false);
        this.mAbsentTextField.setOpaque(false);
        this.mVariableRadioButton.setEnabled(false);
        this.mCaseRadioButton.setEnabled(false);
        this.mRootComboBox.setSelectedIndex(1);
        this.mPowerComboBox.setSelectedIndex(1);
        this.mRootComboBox.setEnabled(false);
        this.mPowerComboBox.setEnabled(false);
        this.mPowerLabel.setEnabled(false);
        this.mRootLabel.setEnabled(false);
        this.mCountsComboBox.setEnabled(false);
        this.mPresentTextField.setText(PRESENT_DEFAULT_VALUE);
        this.mAbsentTextField.setText(ABSENT_DEFAULT_VALUE);
    }

    private void initVars() {
        this.mIntervalRadioButton = new JRadioButton(new ToggleButtonAction(this, INTERVAL_KEY));
        this.mBinaryRadioButton = new JRadioButton(new ToggleButtonAction(this, BINARY_KEY));
        this.mCountsRadioButton = new JRadioButton(new ToggleButtonAction(this, COUNT_KEY));
        this.mVariableRadioButton = new JRadioButton(new ToggleButtonAction(this, VARIABLE_KEY));
        this.mCaseRadioButton = new JRadioButton(new ToggleButtonAction(this, CASE_KEY));
        this.mVariableRadioButton.setSelected(true);
        String[] stringArray = this.getResStringArray("IDS_DISS_INTERVAL_COMBO_VALUES");
        this.mIntervalComboBox = new JComboBox<String>(stringArray);
        stringArray = this.getResStringArray("IDS_DISS_BINARY_COMBO_VALUES");
        this.mBinaryComboBox = new JComboBox<String>(stringArray);
        stringArray = this.getResStringArray("IDS_STANDARDIZE_COMBO_VALUES");
        this.mStandarizeComboBox = new JComboBox<String>(stringArray);
        stringArray = this.getResStringArray("IDS_DISS_COUNTS_COMBO_VALUES");
        this.mCountsComboBox = new JComboBox<String>(stringArray);
        stringArray = new String[]{PRESENT_DEFAULT_VALUE, "2", "3", "4"};
        this.mPowerComboBox = new JComboBox<String>(stringArray);
        this.mRootComboBox = new JComboBox<String>(stringArray);
        this.mPresentLabel = DialogUtil.createLabel(this, "IDS_PRESENT");
        this.mAbsentLabel = DialogUtil.createLabel(this, "IDS_ABESNT");
        this.mStandarizeLabel = DialogUtil.createLabel(this, "IDS_STANDARADIZE");
        this.mradioGroupForMeasure = new SpssButtonGroup();
        this.mPowerLabel = DialogUtil.createLabel(this, "IDS_POWER");
        this.mRootLabel = DialogUtil.createLabel(this, "IDS_ROOT");
        this.mPresentTextField = new IntTextField(-99, 999, false);
        this.mAbsentTextField = new IntTextField(-99, 999, false);
        this.mPresentTextField.setSize(3, 1);
        this.mAbsentTextField.setSize(3, 1);
        this.mradioGroup = new SpssButtonGroup();
        this.mMeasurePanel = new JPanel(new GridBagLayout());
        this.mMeasurePanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_MEASURE")));
        this.mTransformValuesPanel = new JPanel(new GridBagLayout());
        this.mTransformValuesPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_TVALUES")));
        this.mTransformMeasuresPanel = new JPanel(new GridBagLayout());
        this.mTransformMeasuresPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_TMEASURE")));
        this.mIntervalRadioButton.addItemListener(this);
        this.mBinaryRadioButton.addItemListener(this);
        this.mStandarizeComboBox.addItemListener(this);
        this.mCountsRadioButton.addItemListener(this);
        this.mIntervalComboBox.addItemListener(this);
        this.mPresentTextField.getDocument().addDocumentListener(this);
        this.mAbsentTextField.getDocument().addDocumentListener(this);
        this.mIntervalComboBox.addItemListener(this);
        this.mBinaryComboBox.addItemListener(this);
        this.mCountsComboBox.addItemListener(this);
        this.mAbsentTextField.setMaximumSize(new Dimension(3, 1));
        this.mRootLabel.setLabelFor(this.mRootComboBox);
        this.mPowerLabel.setLabelFor(this.mPowerComboBox);
        this.mStandarizeLabel.setLabelFor(this.mStandarizeComboBox);
        this.mPresentLabel.setLabelFor((Component)this.mPresentTextField);
        this.mAbsentLabel.setLabelFor((Component)this.mAbsentTextField);
        this.mradioGroupForMeasure.add(this.mIntervalRadioButton);
        this.mradioGroupForMeasure.add(this.mCountsRadioButton);
        this.mradioGroupForMeasure.add(this.mBinaryRadioButton);
        this.mIntervalMeasureLabel = DialogUtil.createLabel(this, "IDS_MEASURE_DISS_DOT");
        this.mCountMeasureLabel = DialogUtil.createLabel(this, "IDS_MEASURE_DISS_DOT");
        this.mBinaryMeasureLabel = DialogUtil.createLabel(this, "IDS_MEASURE_DISS_DOT");
        this.mIntervalMeasureLabel.setLabelFor(this.mIntervalComboBox);
        this.mCountMeasureLabel.setLabelFor(this.mCountsComboBox);
        this.mBinaryMeasureLabel.setLabelFor(this.mBinaryComboBox);
        this.mStandarizeComboBox.setAction(new ComboboxAction(this.mParentDlg, STD_VALUE_KEY));
        this.mIntervalComboBox.setAction(new ComboboxAction(this.mParentDlg, INTERVAL_VALUE_KEY));
        this.mBinaryComboBox.setAction(new ComboboxAction(this.mParentDlg, BINARY_VALUE_KEY));
        this.mCountsComboBox.setAction(new ComboboxAction(this.mParentDlg, COUNT_VALUE_KEY));
        this.mRootComboBox.setAction(new ComboboxAction(this.mParentDlg, ROOT_VALUE_KEY));
        this.mPowerComboBox.setAction(new ComboboxAction(this.mParentDlg, POWER_VALUE_KEY));
        this.mPresentTextField.setAction((Action)new TextFieldAction(this.mParentDlg, PRESNT_KEY));
        this.mAbsentTextField.setAction((Action)new TextFieldAction(this.mParentDlg, ABSENT_KEY));
    }
}

