/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.correlate.bivariate;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.analyze.correlate.bivariate.BivariateDlg;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class BivariateOptions
extends BaseSubDialog {
    static final String MEANS_KEY = "IDS_MEANS_STANDARD_DEVIATIONS";
    static final String CROSS_KEY = "IDS_CROSS";
    static final String PAIRWISE_KEY = "IDS_PAIRWISE";
    static final String LISTWISE_KEY = "IDS_LISTWISE";
    private JCheckBox mMeansCheck;
    private JCheckBox mCrossCheck;
    private SpssButtonGroup mGroup;
    private JRadioButton mListWiseRadio;
    private JRadioButton mPairWiseRadio;

    public BivariateOptions(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_BIVARIATE_OPTIONS_TITLE"), true);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_corr_stat";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupStatisticsPanel();
        JPanel jPanel3 = this.setupMisingValuePanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, 0, n2, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, null);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    protected void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, MEANS_KEY);
        this.mMeansCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, CROSS_KEY);
        this.mCrossCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, PAIRWISE_KEY);
        this.mPairWiseRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParentDlg, LISTWISE_KEY);
        this.mListWiseRadio = new JRadioButton(toggleButtonAction);
    }

    private void setDefaults() {
        this.mPairWiseRadio.setSelected(true);
        Boolean bl = ((BivariateDlg)this.mParentDlg).isPearsonChecked();
        if (!bl.booleanValue()) {
            this.mMeansCheck.setEnabled(false);
            this.mCrossCheck.setEnabled(false);
        }
    }

    private JPanel setupStatisticsPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mMeansCheck, this.mCrossCheck};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_OPTIONS_STATISTICS"));
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupMisingValuePanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mPairWiseRadio, this.mListWiseRadio};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_OPTIONS_MISSINGVALUE"));
        this.mGroup = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mMeansCheck);
        vector.add(this.mCrossCheck);
        vector.add(this.mGroup);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }
}

