/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.correlate.bivariate;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.analyze.correlate.bivariate.BivariateOptions;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BootstrapDlg;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.post_processing_output.TableStyleDlg;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class BivariateDlg
extends BaseProcedureDialog
implements ListDataListener,
ItemListener {
    static final int MAX_LIMIT_OF_LIST = 500;
    static final String PEARSON_KEY = "IDS_PEARSON";
    static final String KENDAL_KEY = "IDS_KENDAL";
    static final String SPEARMAN_KEY = "IDS_SPEARMAN";
    static final String TWOTAILED_KEY = "IDS_TWOTAILED";
    static final String ONETAILED_KEY = "IDS_ONETAILED";
    static final String FLAGSIGNIFICANT_KEY = "IDS_FLAGSIGNIFICANT";
    static final String TARGET_LIST = "IDS_BIVARIATE_TARGET_LIST";
    static final String OPTIONS_BUTTON_KEY = "IDS_COMMON_OPTIONS_3DOT";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mTargetVarList;
    private JCheckBox mPearsonCheck;
    private JCheckBox mKedalCheck;
    private JCheckBox mSpearmanCheck;
    private JCheckBox mFlagsignCheck;
    private JRadioButton mTwoTailedRadio;
    private JRadioButton mOneTailedRadio;
    private JScrollPane mSrcScrollPane;
    private JScrollPane mTargetScrollPane;
    private ArrowButton mArrowButton;
    private SpssButtonGroup mGroup;
    private JPanel mCorrCoefPanel;
    private boolean mIsBootstrapOK;

    public BivariateDlg(JFrame jFrame) {
        super(jFrame, false, AnalyzeResBundle.getDefaultResourceBundleName(), AnalyzeResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_BIVARIATE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.enableOkPaste();
    }

    @Override
    public boolean okPastePressed() {
        if (this.mIsBootstrapOK && BootstrapDlg.isStrataVariableListEmpty(this)) {
            this.runSubDialog(new BootstrapDlg(this));
            return false;
        }
        return super.okPastePressed();
    }

    @Override
    public String generateSyntax() {
        String string;
        String[] stringArray;
        Boolean bl;
        Boolean bl2;
        Object object;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        StringBuffer stringBuffer2 = new StringBuffer("");
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        String string2 = this.mTargetVarList.getVariablesStringList();
        String string3 = "";
        DialogDataModel dialogDataModel2 = (DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY);
        if (this.mIsBootstrapOK && dialogDataModel2 != null) {
            object = "";
            string3 = BootstrapDlg.getBootstrapSyntax((String)object, string2, dialogDataModel2);
            stringBuffer.append(string3);
        }
        if ((object = dialogDataModel.getBoolean(PEARSON_KEY)) != null && !((Boolean)object).booleanValue()) {
            stringBuffer.append(SyntaxUtil.getMainCommand("NONPAR CORR"));
        } else {
            stringBuffer.append(SyntaxUtil.getMainCommand("CORRELATIONS"));
            if (string3.length() > 0) {
                stringBuffer2.append(string3);
            }
            stringBuffer2.append(SyntaxUtil.getMainCommand("NONPAR CORR"));
        }
        stringBuffer.append("\n");
        stringBuffer2.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/VARIABLES="));
        stringBuffer2.append(SyntaxUtil.getSubCommand("/VARIABLES="));
        stringBuffer.append(string2 + "\n");
        stringBuffer2.append(string2 + "\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/PRINT="));
        stringBuffer2.append(SyntaxUtil.getSubCommand("/PRINT="));
        Boolean bl3 = dialogDataModel.getBoolean(KENDAL_KEY);
        Boolean bl4 = dialogDataModel.getBoolean(SPEARMAN_KEY);
        if (bl3 != null && bl3.booleanValue() && object != null && ((Boolean)object).booleanValue()) {
            if (bl3 != null && bl3.booleanValue()) {
                if (bl4 != null && bl4.booleanValue()) {
                    stringBuffer2.append("BOTH ");
                } else {
                    stringBuffer2.append("KENDALL ");
                }
            }
        } else if (bl3 != null && bl3.booleanValue()) {
            if (bl4 != null && bl4.booleanValue()) {
                stringBuffer.append("BOTH ");
                stringBuffer2.append("BOTH ");
            } else {
                stringBuffer.append("KENDALL ");
                stringBuffer2.append("KENDALL ");
            }
        } else if (bl4 != null && bl4.booleanValue()) {
            if (object != null && !((Boolean)object).booleanValue()) {
                stringBuffer.append("SPEARMAN ");
            }
            stringBuffer2.append("SPEARMAN ");
        }
        if ((bl2 = dialogDataModel.getBoolean(TWOTAILED_KEY)) != null && bl2.booleanValue()) {
            stringBuffer.append("TWOTAIL");
            stringBuffer2.append("TWOTAIL");
        } else {
            stringBuffer = stringBuffer.append("ONETAIL");
            stringBuffer2.append("ONETAIL");
        }
        bl2 = dialogDataModel.getBoolean(FLAGSIGNIFICANT_KEY);
        if (bl2 != null && bl2.booleanValue()) {
            stringBuffer.append(" NOSIG");
            stringBuffer2.append(" NOSIG\n");
        } else {
            stringBuffer.append(" SIG");
            stringBuffer2.append(" SIG\n");
        }
        if (object != null && ((Boolean)object).booleanValue()) {
            bl = dialogDataModel.getBoolean("IDS_MEANS_STANDARD_DEVIATIONS");
            if (bl != null && bl.booleanValue()) {
                stringBuffer.append("\n");
                stringBuffer.append(SyntaxUtil.getSubCommand("/STATISTICS"));
                stringBuffer.append(" DESCRIPTIVES");
            }
            if ((stringArray = dialogDataModel.getBoolean("IDS_CROSS")) != null && stringArray.booleanValue()) {
                if (stringBuffer.indexOf("STATISTICS") > 0) {
                    stringBuffer.append(" XPROD");
                } else {
                    stringBuffer.append("\n");
                    stringBuffer.append(SyntaxUtil.getSubCommand("/STATISTICS"));
                    stringBuffer.append(" XPROD");
                }
            }
        }
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/MISSING="));
        stringBuffer2.append(SyntaxUtil.getSubCommand("/MISSING="));
        bl = dialogDataModel.getBoolean("IDS_PAIRWISE");
        if (bl == null || bl.booleanValue()) {
            stringBuffer.append("PAIRWISE");
            stringBuffer2.append("PAIRWISE");
        } else {
            stringBuffer.append("LISTWISE");
            stringBuffer2.append("LISTWISE");
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer2.append(SyntaxUtil.terminateSyntax());
        if (this.mIsBootstrapOK && dialogDataModel2 != null) {
            stringBuffer.append(BootstrapDlg.getRestoreSyntax((DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY)));
            stringBuffer2.append(BootstrapDlg.getRestoreSyntax((DialogDataModel)this.getDialogDataModel().getObject(BootstrapDlg.DIALOG_KEY)));
        }
        stringArray = null;
        if (object != null && ((Boolean)object).booleanValue() && (this.mKedalCheck.isSelected() || this.mSpearmanCheck.isSelected())) {
            stringBuffer.append(stringBuffer2);
            stringArray = new String[]{"CORRELATIONS", "NONPAR CORR"};
        }
        if ((string = TableStyleDlg.generateSyntax(dialogDataModel, TableStyleDlg.ConditionalFormatDlgType.BivariateCorrelations, stringArray)) != null) {
            stringBuffer.append(string);
            stringBuffer.append(SyntaxUtil.terminateSyntax());
        }
        return stringBuffer.toString();
    }

    public boolean isPearsonChecked() {
        return this.mPearsonCheck.isSelected();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_corr";
    }

    @Override
    public String getIActionKey() {
        return "analyze_correlate_bivariate";
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableOkPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableOkPaste();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableOkPaste();
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(OPTIONS_BUTTON_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BivariateDlg.this.runOptionsSubDialog();
            }
        };
        this.addOptionsPanelButton(jPanel, new JButton(toggleButtonAction));
        toggleButtonAction = new ToggleButtonAction("IDS_TABLE_STYLE_BUTTON_BIVARIATE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BivariateDlg.this.runConditionalSubDialog();
            }
        };
        this.addOptionsPanelButton(jPanel, new JButton(toggleButtonAction));
        this.mIsBootstrapOK = false;
        if (VersionInfo.allowBootstrapping()) {
            this.mIsBootstrapOK = true;
            toggleButtonAction = new ToggleButtonAction("IDS_COMMON_BOOTSTRAPPING_BUTTON"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BivariateDlg.this.runBoostrapSubDialog();
                }
            };
            JButton jButton = new JButton(toggleButtonAction);
            this.addOptionsPanelButton(jPanel, jButton);
            if (BootstrapDlg.isCurrentDatasetInMIMode()) {
                jButton.setEnabled(false);
                this.mIsBootstrapOK = false;
            }
        }
        return jPanel;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupLists();
        this.mCorrCoefPanel = this.setupCorrCoefPanel();
        JPanel jPanel3 = this.setupTestOfSignPanel();
        JPanel jPanel4 = this.setupFlagSignificantPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        Insets insets = new Insets(n2, 0, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mCorrCoefPanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 3, 1, 1, n, insets);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    protected void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetVarList = new TargetVariableList();
        this.mTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mTargetVarList.setMaxLimitOfList(500);
        this.mTargetVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mTargetVarList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), this.mTargetVarList.getFixedCellHeight() * 6 + 2));
        this.mTargetScrollPane = new JScrollPane(this.mTargetVarList);
        this.mTargetScrollPane.setPreferredSize(this.mTargetVarList.getMinimumSize());
        this.mTargetVarList.getModel().addListDataListener(this);
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mTargetVarList, SpssArrowButton.ButtonOrientation.left);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, TWOTAILED_KEY);
        this.mTwoTailedRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, ONETAILED_KEY);
        this.mOneTailedRadio = new JRadioButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, PEARSON_KEY);
        this.mPearsonCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, KENDAL_KEY);
        this.mKedalCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, SPEARMAN_KEY);
        this.mSpearmanCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, FLAGSIGNIFICANT_KEY);
        this.mFlagsignCheck = new JCheckBox(toggleButtonAction);
        this.mTargetVarList.setIdentifier(TARGET_LIST);
        this.mPearsonCheck.addItemListener(this);
        this.mKedalCheck.addItemListener(this);
        this.mSpearmanCheck.addItemListener(this);
    }

    private void enableOkPaste() {
        boolean bl = false;
        if (!(this.mKedalCheck.isSelected() || this.mPearsonCheck.isSelected() || this.mSpearmanCheck.isSelected())) {
            bl = false;
        } else if (this.mTargetVarList.getModel().getSize() > 1) {
            bl = true;
        }
        super.enableOkPaste(bl);
    }

    private void setDefaults() {
        this.mTargetVarList.getModel().removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mPearsonCheck.setSelected(true);
        this.mTwoTailedRadio.setSelected(true);
        this.mFlagsignCheck.setSelected(true);
        this.mKedalCheck.setSelected(false);
        this.mSpearmanCheck.setSelected(false);
        this.mSrcVarList.requestFocus();
        this.mSrcVarList.setSelectedIndex(0);
    }

    private void setFocusTraversalPolicy() {
        int n;
        int n2;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetVarList);
        int n3 = this.mCorrCoefPanel.getComponentCount();
        for (n2 = 0; n2 < n3; ++n2) {
            vector.add(this.mCorrCoefPanel.getComponent(n2));
        }
        vector.add(this.mGroup);
        vector.add(this.mFlagsignCheck);
        n2 = this.mOptionButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            if (!(this.mOptionButtonPanel.getComponent(n) instanceof JButton)) continue;
            vector.add(this.mOptionButtonPanel.getComponent(n));
        }
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private JPanel setupTestOfSignPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mTwoTailedRadio, this.mOneTailedRadio};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.xaxis, this.getResString("IDS_TEST_SIGNIFICANCE"));
        this.mGroup = DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupCorrCoefPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mPearsonCheck, this.mKedalCheck, this.mSpearmanCheck};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.xaxis, this.getResString("IDS_CORRELATE_COEFFICIENTS"));
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setupFlagSignificantPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mFlagsignCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupLists() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_BIVARIATE_SOURCE_LIST_LABEL");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        n = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_BIVARIATE_VARIABLES_COLON");
        jLabel2.setLabelFor(this.mTargetVarList);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 0, 1, 1, n, null);
        n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mTargetScrollPane, gridBagConstraints, 2, 1, 1, 1, n, null);
        return jPanel;
    }

    private void runOptionsSubDialog() {
        this.runSubDialog(new BivariateOptions(this));
    }

    private void runConditionalSubDialog() {
        this.runSubDialog(new TableStyleDlg(this, TableStyleDlg.ConditionalFormatDlgType.BivariateCorrelations));
    }

    private void runBoostrapSubDialog() {
        this.runSubDialog(new BootstrapDlg(this));
    }
}

