/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.analyze.comp_means.one_way_annova;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.ACREvent;
import com.spss.java_client.ui.controls.ACRWidget;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.IACRListener;
import com.spss.java_client.ui.controls.SerializableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.Document;

public class OneWayAnovaContrasts
extends BaseSubDialog
implements ItemListener,
IACRListener {
    static final String POLYNOMIAL_CHECK_KEY = "IDS_POLYNOMIAL_CHECK";
    static final String DEGREE_COMBO_KEY = "IDS_DEGREE_COMBO";
    static final String LAYER_COUNT_KEY = "IDS_LAYER_COUNT";
    static final String LAYERS_KEY = "IDS_LAYERS";
    static final String CURRENT_LAYER_KEY = "IDS_CURRENT_LAYER";
    private JCheckBox mPolynomialCheck;
    private TitledBorder mPanelBorder;
    private JLabel mDegreeLabel;
    private JComboBox mDegreeCombo;
    private JButton mPreviousButton;
    private JButton mNextButton;
    private FloatTextField mCoeffEdit;
    private ACRWidget mACRWidget;
    private JLabel mCoeffTotal;
    private int mCurrentPanel;
    private Vector<String[]> mLayers;

    public OneWayAnovaContrasts(BaseProcedureDialog baseProcedureDialog) {
        super(baseProcedureDialog, baseProcedureDialog.getResString("IDS_ANOVA_CONTRASTS_TITLE"), true);
        this.addLayer();
        this.mPanelBorder.setTitle(this.formatCurrentPanelTitle());
        this.mCoeffTotal.setText(this.formatCoefficientTotal());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_onew_con";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mPolynomialCheck) {
            this.mDegreeLabel.setEnabled(itemEvent.getStateChange() == 1);
            this.mDegreeCombo.setEnabled(itemEvent.getStateChange() == 1);
        }
    }

    @Override
    public void listChanged(ACREvent aCREvent) {
        int n = this.mACRWidget.getListItemCount();
        boolean bl = n != 1;
        this.mPreviousButton.setEnabled(this.mCurrentPanel > 0 && bl);
        boolean bl2 = this.mCurrentPanel + 1 < 10 && (n > 1 || n == 0 && this.mLayers.size() > this.mCurrentPanel + 1);
        this.mNextButton.setEnabled(bl2);
        this.mCoeffTotal.setText(this.formatCoefficientTotal());
        this.updateContinue();
    }

    @Override
    public boolean continuePressed() {
        boolean bl = super.continuePressed();
        if (bl) {
            int n;
            if (this.mCoeffEdit.getText().length() > 0 && (n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), ResUtil.getCommonDlgString("ERR_ACR_CONTINUE_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) != 0) {
                return false;
            }
            if (!this.saveLayer() && this.mCurrentPanel > 0) {
                --this.mCurrentPanel;
            }
        }
        return bl;
    }

    protected void doPrevious() {
        if (this.mCurrentPanel == 0) {
            assert (false);
            return;
        }
        this.saveLayer();
        --this.mCurrentPanel;
        this.doLayerPopulate();
    }

    protected void doNext() {
        if (this.saveLayer()) {
            ++this.mCurrentPanel;
        }
        if (this.mCurrentPanel == this.mLayers.size()) {
            this.addLayer();
        }
        this.doLayerPopulate();
    }

    @Override
    protected boolean saveState(DialogDataModel dialogDataModel) {
        boolean bl = super.saveState(dialogDataModel);
        if (bl) {
            dialogDataModel.putInteger(LAYER_COUNT_KEY, this.mLayers.size());
            for (int i = 0; i < this.mLayers.size(); ++i) {
                dialogDataModel.putArray(LAYERS_KEY + i, this.mLayers.get(i));
            }
            dialogDataModel.putInteger(CURRENT_LAYER_KEY, this.mCurrentPanel);
        }
        return bl;
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        Integer n;
        super.loadState(dialogDataModel);
        Integer n2 = dialogDataModel.getInteger(LAYER_COUNT_KEY);
        int n3 = n2 != null ? n2 : 0;
        this.mLayers.clear();
        for (int i = 0; i < n3; ++i) {
            String[] stringArray = (String[])dialogDataModel.getArray(LAYERS_KEY + i);
            this.mLayers.add(stringArray);
        }
        if (n3 == 0) {
            this.mLayers.add(new String[0]);
        }
        this.mCurrentPanel = (n = dialogDataModel.getInteger(CURRENT_LAYER_KEY)) != null ? n : 0;
        this.doLayerPopulate();
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.mLayers = new Vector();
        String[] stringArray = new String[]{this.getResString("IDS_LINEAR"), this.getResString("IDS_QUADRATIC"), this.getResString("IDS_CUBIC"), this.getResString("IDS_4TH"), this.getResString("IDS_5TH")};
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParentDlg, POLYNOMIAL_CHECK_KEY);
        this.mPolynomialCheck = new JCheckBox(toggleButtonAction);
        Insets insets2 = new Insets(insets.top + 2, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mPolynomialCheck, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        this.mPolynomialCheck.addItemListener(this);
        this.mDegreeLabel = DialogUtil.createLabel(this, "IDS_DEGREE_COLON_LABEL");
        insets2 = new Insets(insets.top + 4, insets.left + 20, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mDegreeLabel, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        this.mDegreeLabel.setEnabled(false);
        ComboboxAction comboboxAction = new ComboboxAction(this.mParentDlg, DEGREE_COMBO_KEY);
        this.mDegreeCombo = new JComboBox();
        this.mDegreeCombo.setAction(comboboxAction);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets2 = new Insets(insets.top, insets.left, insets.bottom, 2);
        DialogUtil.addUsingGBL(jPanel, this.mDegreeCombo, gridBagConstraints, 2, 0, 1, 1, n, insets2);
        for (String string : stringArray) {
            this.mDegreeCombo.addItem(string);
        }
        this.mDegreeCombo.setEnabled(false);
        this.mDegreeLabel.setLabelFor(this.mDegreeCombo);
        this.addContrastPanel(jPanel);
        Vector vector = new Vector();
        List<JComponent> list = this.mACRWidget.getTraversalComponents();
        SerializableList serializableList = this.mACRWidget.getList();
        vector.add(this.mPolynomialCheck);
        vector.add(this.mDegreeCombo);
        vector.add(this.mCoeffEdit);
        vector.add(list.get(1));
        vector.add(list.get(2));
        vector.add(list.get(3));
        vector.add(serializableList);
        vector.add(this.mNextButton);
        vector.add(this.mPreviousButton);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            Component component = this.mCmdButtonPanel.getComponent(i);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    private boolean saveLayer() {
        boolean bl = false;
        if (this.mCurrentPanel < this.mLayers.size()) {
            String[] stringArray = this.mACRWidget.getListItems();
            if (stringArray.length > 1) {
                this.mLayers.set(this.mCurrentPanel, stringArray);
                bl = true;
            } else {
                this.mLayers.remove(this.mCurrentPanel);
            }
        }
        return bl;
    }

    private void doLayerPopulate() {
        this.mACRWidget.clear();
        if (this.mCurrentPanel < this.mLayers.size()) {
            String[] stringArray = this.mLayers.get(this.mCurrentPanel);
            this.mACRWidget.setListItems(stringArray);
        }
        this.mPanelBorder.setTitle(this.formatCurrentPanelTitle());
        this.mCoeffTotal.setText(this.formatCoefficientTotal());
        this.repaint();
    }

    private void updateContinue() {
        this.enableContinue(this.mACRWidget.getListItemCount() != 1);
    }

    private void addLayer() {
        this.mLayers.add(new String[0]);
    }

    private String formatCoefficientTotal() {
        String[] stringArray;
        double d = 0.0;
        for (String string : stringArray = this.mACRWidget.getListItems()) {
            try {
                d += Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        return String.format(ComponentState.getSPSSLocale(), "%.3f", d);
    }

    private String formatCurrentPanelTitle() {
        return String.format(ComponentState.getSPSSLocale(), this.getResString("IDS_CONTRASTS_FORMAT"), this.mCurrentPanel + 1, this.mLayers.size());
    }

    private void addContrastPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(true);
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = DialogUtil.getStandardButtonInsets();
        int n = DialogUtil.getComponentGroupGap();
        int n2 = 23;
        this.mCurrentPanel = 0;
        this.mPanelBorder = new TitledBorder("");
        jPanel2.setBorder(this.mPanelBorder);
        AbstractAction abstractAction = new AbstractAction(this.getResString("IDS_PREVIOUS")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OneWayAnovaContrasts.this.doPrevious();
            }
        };
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            abstractAction.putValue("MnemonicKey", this.getDlgAccessKey("IDK_PREVIOUS_KEY"));
        }
        this.mPreviousButton = new JButton(abstractAction);
        DialogUtil.addUsingGBL(jPanel2, this.mPreviousButton, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        this.mPreviousButton.setEnabled(false);
        abstractAction = new AbstractAction(this.getResString("IDS_NEXT")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OneWayAnovaContrasts.this.doNext();
            }
        };
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            abstractAction.putValue("MnemonicKey", this.getDlgAccessKey("IDK_NEXT_KEY"));
        }
        this.mNextButton = new JButton(abstractAction);
        DialogUtil.addUsingGBL(jPanel2, this.mNextButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
        UIToolDialogUtil.normalizeButtonWidths((JPanel)jPanel2);
        this.mNextButton.setEnabled(false);
        this.setupCoefficientsPanel(jPanel2);
        this.mACRWidget = new ACRWidget((JTextField)this.mCoeffEdit){

            @Override
            protected void doAdd() {
                if (this.getListItemCount() <= 49) {
                    super.doAdd();
                } else {
                    SpssAlertOptionPane.showInformationMessageDialog(this, OneWayAnovaContrasts.this.getResString("ERR_ACR_LIST_MAX_SIZE_LIMIT_INFO_MSG"), VersionInfo.getAppVersionString());
                }
            }

            @Override
            protected void doRemove() {
                super.doRemove();
                OneWayAnovaContrasts.this.mCoeffEdit.requestFocus();
            }
        };
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets3 = new Insets(insets.top + 2, 20, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel2, this.mACRWidget, gridBagConstraints, 0, 2, 3, 1, n2, insets3);
        this.mACRWidget.addACRListener(this);
        this.mACRWidget.setSerializable(false);
        this.mACRWidget.setAllowDuplicates(true);
        JLabel jLabel = new JLabel(this.getResString("IDS_COEFF_TOTAL_COLON_LABEL"));
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 3, 1, 1, n2, insets);
        this.mCoeffTotal = new JLabel("");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel2, this.mCoeffTotal, gridBagConstraints, 1, 3, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets3 = new Insets(n, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 3, 1, n2, insets3);
    }

    private void setupCoefficientsPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(true);
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n2 = 23;
        jPanel2.setLayout(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_COEFF_COLON_LABEL");
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        this.mCoeffEdit = new FloatTextField(-999.0, 9999.0, 3, false);
        this.mCoeffEdit.setDocument((Document)new FixedLengthNumericDocument(4, false, true));
        jLabel.setLabelFor((Component)this.mCoeffEdit);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mCoeffEdit, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets2 = new Insets(n, insets.left, insets.bottom, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 3, 1, n2, insets2);
    }
}

